

CREATE TABLE `ceba_commentmeta` (
  `meta_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `comment_id` bigint(20) unsigned NOT NULL DEFAULT '0',
  `meta_key` varchar(255) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `meta_value` longtext COLLATE utf8mb4_unicode_520_ci,
  PRIMARY KEY (`meta_id`),
  KEY `comment_id` (`comment_id`),
  KEY `meta_key` (`meta_key`(191))
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;




CREATE TABLE `ceba_comments` (
  `comment_ID` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `comment_post_ID` bigint(20) unsigned NOT NULL DEFAULT '0',
  `comment_author` tinytext COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `comment_author_email` varchar(100) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `comment_author_url` varchar(200) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `comment_author_IP` varchar(100) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `comment_date` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `comment_date_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `comment_content` text COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `comment_karma` int(11) NOT NULL DEFAULT '0',
  `comment_approved` varchar(20) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '1',
  `comment_agent` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `comment_type` varchar(20) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT 'comment',
  `comment_parent` bigint(20) unsigned NOT NULL DEFAULT '0',
  `user_id` bigint(20) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`comment_ID`),
  KEY `comment_post_ID` (`comment_post_ID`),
  KEY `comment_approved_date_gmt` (`comment_approved`,`comment_date_gmt`),
  KEY `comment_date_gmt` (`comment_date_gmt`),
  KEY `comment_parent` (`comment_parent`),
  KEY `comment_author_email` (`comment_author_email`(10))
) ENGINE=MyISAM AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

INSERT INTO ceba_comments VALUES("1","1","A WordPress Commenter","wapuu@wordpress.example","https://wordpress.org/","","2022-12-01 08:14:24","2022-12-01 08:14:24","Hi, this is a comment.\nTo get started with moderating, editing, and deleting comments, please visit the Comments screen in the dashboard.\nCommenter avatars come from <a href=\"https://en.gravatar.com/\">Gravatar</a>.","0","1","","comment","0","0");



CREATE TABLE `ceba_e_events` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `event_data` text COLLATE utf8mb4_unicode_520_ci,
  `created_at` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `created_at_index` (`created_at`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;




CREATE TABLE `ceba_links` (
  `link_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `link_url` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `link_name` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `link_image` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `link_target` varchar(25) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `link_description` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `link_visible` varchar(20) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT 'Y',
  `link_owner` bigint(20) unsigned NOT NULL DEFAULT '1',
  `link_rating` int(11) NOT NULL DEFAULT '0',
  `link_updated` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `link_rel` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `link_notes` mediumtext COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `link_rss` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  PRIMARY KEY (`link_id`),
  KEY `link_visible` (`link_visible`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;




CREATE TABLE `ceba_options` (
  `option_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `option_name` varchar(191) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `option_value` longtext COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `autoload` varchar(20) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT 'yes',
  PRIMARY KEY (`option_id`),
  UNIQUE KEY `option_name` (`option_name`),
  KEY `autoload` (`autoload`)
) ENGINE=MyISAM AUTO_INCREMENT=281 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

INSERT INTO ceba_options VALUES("1","siteurl","https://zanzibartreasuretours.ceba.co.tz","yes");
INSERT INTO ceba_options VALUES("2","home","https://zanzibartreasuretours.ceba.co.tz","yes");
INSERT INTO ceba_options VALUES("3","blogname","ZANZIBAR TREASURE TOURS &amp; SAFARIS","yes");
INSERT INTO ceba_options VALUES("4","blogdescription","","yes");
INSERT INTO ceba_options VALUES("5","users_can_register","0","yes");
INSERT INTO ceba_options VALUES("6","admin_email","onejambomambojambo@gmail.com","yes");
INSERT INTO ceba_options VALUES("7","start_of_week","1","yes");
INSERT INTO ceba_options VALUES("8","use_balanceTags","0","yes");
INSERT INTO ceba_options VALUES("9","use_smilies","1","yes");
INSERT INTO ceba_options VALUES("10","require_name_email","1","yes");
INSERT INTO ceba_options VALUES("11","comments_notify","1","yes");
INSERT INTO ceba_options VALUES("12","posts_per_rss","10","yes");
INSERT INTO ceba_options VALUES("13","rss_use_excerpt","0","yes");
INSERT INTO ceba_options VALUES("14","mailserver_url","mail.example.com","yes");
INSERT INTO ceba_options VALUES("15","mailserver_login","login@example.com","yes");
INSERT INTO ceba_options VALUES("16","mailserver_pass","password","yes");
INSERT INTO ceba_options VALUES("17","mailserver_port","110","yes");
INSERT INTO ceba_options VALUES("18","default_category","1","yes");
INSERT INTO ceba_options VALUES("19","default_comment_status","open","yes");
INSERT INTO ceba_options VALUES("20","default_ping_status","open","yes");
INSERT INTO ceba_options VALUES("21","default_pingback_flag","1","yes");
INSERT INTO ceba_options VALUES("22","posts_per_page","10","yes");
INSERT INTO ceba_options VALUES("23","date_format","F j, Y","yes");
INSERT INTO ceba_options VALUES("24","time_format","g:i a","yes");
INSERT INTO ceba_options VALUES("25","links_updated_date_format","F j, Y g:i a","yes");
INSERT INTO ceba_options VALUES("26","comment_moderation","0","yes");
INSERT INTO ceba_options VALUES("27","moderation_notify","1","yes");
INSERT INTO ceba_options VALUES("28","permalink_structure","/index.php/%year%/%monthnum%/%day%/%postname%/","yes");
INSERT INTO ceba_options VALUES("29","rewrite_rules","a:200:{s:19:\"sitemap_index\\.xml$\";s:19:\"index.php?sitemap=1\";s:31:\"([^/]+?)-sitemap([0-9]+)?\\.xml$\";s:51:\"index.php?sitemap=$matches[1]&sitemap_n=$matches[2]\";s:24:\"([a-z]+)?-?sitemap\\.xsl$\";s:39:\"index.php?yoast-sitemap-xsl=$matches[1]\";s:11:\"^wp-json/?$\";s:22:\"index.php?rest_route=/\";s:14:\"^wp-json/(.*)?\";s:33:\"index.php?rest_route=/$matches[1]\";s:21:\"^index.php/wp-json/?$\";s:22:\"index.php?rest_route=/\";s:24:\"^index.php/wp-json/(.*)?\";s:33:\"index.php?rest_route=/$matches[1]\";s:17:\"^wp-sitemap\\.xml$\";s:23:\"index.php?sitemap=index\";s:17:\"^wp-sitemap\\.xsl$\";s:36:\"index.php?sitemap-stylesheet=sitemap\";s:23:\"^wp-sitemap-index\\.xsl$\";s:34:\"index.php?sitemap-stylesheet=index\";s:48:\"^wp-sitemap-([a-z]+?)-([a-z\\d_-]+?)-(\\d+?)\\.xml$\";s:75:\"index.php?sitemap=$matches[1]&sitemap-subtype=$matches[2]&paged=$matches[3]\";s:34:\"^wp-sitemap-([a-z]+?)-(\\d+?)\\.xml$\";s:47:\"index.php?sitemap=$matches[1]&paged=$matches[2]\";s:22:\"index.php/portfolio/?$\";s:29:\"index.php?post_type=portfolio\";s:52:\"index.php/portfolio/feed/(feed|rdf|rss|rss2|atom)/?$\";s:46:\"index.php?post_type=portfolio&feed=$matches[1]\";s:47:\"index.php/portfolio/(feed|rdf|rss|rss2|atom)/?$\";s:46:\"index.php?post_type=portfolio&feed=$matches[1]\";s:39:\"index.php/portfolio/page/([0-9]{1,})/?$\";s:47:\"index.php?post_type=portfolio&paged=$matches[1]\";s:57:\"index.php/category/(.+?)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:52:\"index.php?category_name=$matches[1]&feed=$matches[2]\";s:52:\"index.php/category/(.+?)/(feed|rdf|rss|rss2|atom)/?$\";s:52:\"index.php?category_name=$matches[1]&feed=$matches[2]\";s:33:\"index.php/category/(.+?)/embed/?$\";s:46:\"index.php?category_name=$matches[1]&embed=true\";s:45:\"index.php/category/(.+?)/page/?([0-9]{1,})/?$\";s:53:\"index.php?category_name=$matches[1]&paged=$matches[2]\";s:27:\"index.php/category/(.+?)/?$\";s:35:\"index.php?category_name=$matches[1]\";s:54:\"index.php/tag/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:42:\"index.php?tag=$matches[1]&feed=$matches[2]\";s:49:\"index.php/tag/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:42:\"index.php?tag=$matches[1]&feed=$matches[2]\";s:30:\"index.php/tag/([^/]+)/embed/?$\";s:36:\"index.php?tag=$matches[1]&embed=true\";s:42:\"index.php/tag/([^/]+)/page/?([0-9]{1,})/?$\";s:43:\"index.php?tag=$matches[1]&paged=$matches[2]\";s:24:\"index.php/tag/([^/]+)/?$\";s:25:\"index.php?tag=$matches[1]\";s:55:\"index.php/type/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?post_format=$matches[1]&feed=$matches[2]\";s:50:\"index.php/type/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?post_format=$matches[1]&feed=$matches[2]\";s:31:\"index.php/type/([^/]+)/embed/?$\";s:44:\"index.php?post_format=$matches[1]&embed=true\";s:43:\"index.php/type/([^/]+)/page/?([0-9]{1,})/?$\";s:51:\"index.php?post_format=$matches[1]&paged=$matches[2]\";s:25:\"index.php/type/([^/]+)/?$\";s:33:\"index.php?post_format=$matches[1]\";s:52:\"index.php/e-landing-page/[^/]+/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:62:\"index.php/e-landing-page/[^/]+/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:82:\"index.php/e-landing-page/[^/]+/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:77:\"index.php/e-landing-page/[^/]+/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:77:\"index.php/e-landing-page/[^/]+/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:58:\"index.php/e-landing-page/[^/]+/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:41:\"index.php/e-landing-page/([^/]+)/embed/?$\";s:47:\"index.php?e-landing-page=$matches[1]&embed=true\";s:45:\"index.php/e-landing-page/([^/]+)/trackback/?$\";s:41:\"index.php?e-landing-page=$matches[1]&tb=1\";s:53:\"index.php/e-landing-page/([^/]+)/page/?([0-9]{1,})/?$\";s:54:\"index.php?e-landing-page=$matches[1]&paged=$matches[2]\";s:60:\"index.php/e-landing-page/([^/]+)/comment-page-([0-9]{1,})/?$\";s:54:\"index.php?e-landing-page=$matches[1]&cpage=$matches[2]\";s:49:\"index.php/e-landing-page/([^/]+)(?:/([0-9]+))?/?$\";s:53:\"index.php?e-landing-page=$matches[1]&page=$matches[2]\";s:41:\"index.php/e-landing-page/[^/]+/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:51:\"index.php/e-landing-page/[^/]+/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:71:\"index.php/e-landing-page/[^/]+/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:66:\"index.php/e-landing-page/[^/]+/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:66:\"index.php/e-landing-page/[^/]+/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:47:\"index.php/e-landing-page/[^/]+/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:47:\"index.php/portfolio/[^/]+/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:57:\"index.php/portfolio/[^/]+/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:77:\"index.php/portfolio/[^/]+/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:72:\"index.php/portfolio/[^/]+/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:72:\"index.php/portfolio/[^/]+/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:53:\"index.php/portfolio/[^/]+/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:36:\"index.php/portfolio/([^/]+)/embed/?$\";s:42:\"index.php?portfolio=$matches[1]&embed=true\";s:40:\"index.php/portfolio/([^/]+)/trackback/?$\";s:36:\"index.php?portfolio=$matches[1]&tb=1\";s:60:\"index.php/portfolio/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:48:\"index.php?portfolio=$matches[1]&feed=$matches[2]\";s:55:\"index.php/portfolio/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:48:\"index.php?portfolio=$matches[1]&feed=$matches[2]\";s:48:\"index.php/portfolio/([^/]+)/page/?([0-9]{1,})/?$\";s:49:\"index.php?portfolio=$matches[1]&paged=$matches[2]\";s:55:\"index.php/portfolio/([^/]+)/comment-page-([0-9]{1,})/?$\";s:49:\"index.php?portfolio=$matches[1]&cpage=$matches[2]\";s:44:\"index.php/portfolio/([^/]+)(?:/([0-9]+))?/?$\";s:48:\"index.php?portfolio=$matches[1]&page=$matches[2]\";s:36:\"index.php/portfolio/[^/]+/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:46:\"index.php/portfolio/[^/]+/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:66:\"index.php/portfolio/[^/]+/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:61:\"index.php/portfolio/[^/]+/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:61:\"index.php/portfolio/[^/]+/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:42:\"index.php/portfolio/[^/]+/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:69:\"index.php/portfolio-category/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:57:\"index.php?portfolio_category=$matches[1]&feed=$matches[2]\";s:64:\"index.php/portfolio-category/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:57:\"index.php?portfolio_category=$matches[1]&feed=$matches[2]\";s:45:\"index.php/portfolio-category/([^/]+)/embed/?$\";s:51:\"index.php?portfolio_category=$matches[1]&embed=true\";s:57:\"index.php/portfolio-category/([^/]+)/page/?([0-9]{1,})/?$\";s:58:\"index.php?portfolio_category=$matches[1]&paged=$matches[2]\";s:39:\"index.php/portfolio-category/([^/]+)/?$\";s:40:\"index.php?portfolio_category=$matches[1]\";s:64:\"index.php/portfolio-tag/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:52:\"index.php?portfolio_tag=$matches[1]&feed=$matches[2]\";s:59:\"index.php/portfolio-tag/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:52:\"index.php?portfolio_tag=$matches[1]&feed=$matches[2]\";s:40:\"index.php/portfolio-tag/([^/]+)/embed/?$\";s:46:\"index.php?portfolio_tag=$matches[1]&embed=true\";s:52:\"index.php/portfolio-tag/([^/]+)/page/?([0-9]{1,})/?$\";s:53:\"index.php?portfolio_tag=$matches[1]&paged=$matches[2]\";s:34:\"index.php/portfolio-tag/([^/]+)/?$\";s:35:\"index.php?portfolio_tag=$matches[1]\";s:52:\"index.php/jupiterx-codes/[^/]+/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:62:\"index.php/jupiterx-codes/[^/]+/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:82:\"index.php/jupiterx-codes/[^/]+/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:77:\"index.php/jupiterx-codes/[^/]+/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:77:\"index.php/jupiterx-codes/[^/]+/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:58:\"index.php/jupiterx-codes/[^/]+/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:41:\"index.php/jupiterx-codes/([^/]+)/embed/?$\";s:47:\"index.php?jupiterx-codes=$matches[1]&embed=true\";s:45:\"index.php/jupiterx-codes/([^/]+)/trackback/?$\";s:41:\"index.php?jupiterx-codes=$matches[1]&tb=1\";s:53:\"index.php/jupiterx-codes/([^/]+)/page/?([0-9]{1,})/?$\";s:54:\"index.php?jupiterx-codes=$matches[1]&paged=$matches[2]\";s:60:\"index.php/jupiterx-codes/([^/]+)/comment-page-([0-9]{1,})/?$\";s:54:\"index.php?jupiterx-codes=$matches[1]&cpage=$matches[2]\";s:49:\"index.php/jupiterx-codes/([^/]+)(?:/([0-9]+))?/?$\";s:53:\"index.php?jupiterx-codes=$matches[1]&page=$matches[2]\";s:41:\"index.php/jupiterx-codes/[^/]+/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:51:\"index.php/jupiterx-codes/[^/]+/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:71:\"index.php/jupiterx-codes/[^/]+/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:66:\"index.php/jupiterx-codes/[^/]+/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:66:\"index.php/jupiterx-codes/[^/]+/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:47:\"index.php/jupiterx-codes/[^/]+/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:52:\"index.php/jupiterx-fonts/[^/]+/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:62:\"index.php/jupiterx-fonts/[^/]+/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:82:\"index.php/jupiterx-fonts/[^/]+/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:77:\"index.php/jupiterx-fonts/[^/]+/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:77:\"index.php/jupiterx-fonts/[^/]+/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:58:\"index.php/jupiterx-fonts/[^/]+/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:41:\"index.php/jupiterx-fonts/([^/]+)/embed/?$\";s:47:\"index.php?jupiterx-fonts=$matches[1]&embed=true\";s:45:\"index.php/jupiterx-fonts/([^/]+)/trackback/?$\";s:41:\"index.php?jupiterx-fonts=$matches[1]&tb=1\";s:53:\"index.php/jupiterx-fonts/([^/]+)/page/?([0-9]{1,})/?$\";s:54:\"index.php?jupiterx-fonts=$matches[1]&paged=$matches[2]\";s:60:\"index.php/jupiterx-fonts/([^/]+)/comment-page-([0-9]{1,})/?$\";s:54:\"index.php?jupiterx-fonts=$matches[1]&cpage=$matches[2]\";s:49:\"index.php/jupiterx-fonts/([^/]+)(?:/([0-9]+))?/?$\";s:53:\"index.php?jupiterx-fonts=$matches[1]&page=$matches[2]\";s:41:\"index.php/jupiterx-fonts/[^/]+/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:51:\"index.php/jupiterx-fonts/[^/]+/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:71:\"index.php/jupiterx-fonts/[^/]+/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:66:\"index.php/jupiterx-fonts/[^/]+/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:66:\"index.php/jupiterx-fonts/[^/]+/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:47:\"index.php/jupiterx-fonts/[^/]+/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:52:\"index.php/jupiterx-icons/[^/]+/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:62:\"index.php/jupiterx-icons/[^/]+/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:82:\"index.php/jupiterx-icons/[^/]+/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:77:\"index.php/jupiterx-icons/[^/]+/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:77:\"index.php/jupiterx-icons/[^/]+/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:58:\"index.php/jupiterx-icons/[^/]+/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:41:\"index.php/jupiterx-icons/([^/]+)/embed/?$\";s:47:\"index.php?jupiterx-icons=$matches[1]&embed=true\";s:45:\"index.php/jupiterx-icons/([^/]+)/trackback/?$\";s:41:\"index.php?jupiterx-icons=$matches[1]&tb=1\";s:53:\"index.php/jupiterx-icons/([^/]+)/page/?([0-9]{1,})/?$\";s:54:\"index.php?jupiterx-icons=$matches[1]&paged=$matches[2]\";s:60:\"index.php/jupiterx-icons/([^/]+)/comment-page-([0-9]{1,})/?$\";s:54:\"index.php?jupiterx-icons=$matches[1]&cpage=$matches[2]\";s:49:\"index.php/jupiterx-icons/([^/]+)(?:/([0-9]+))?/?$\";s:53:\"index.php?jupiterx-icons=$matches[1]&page=$matches[2]\";s:41:\"index.php/jupiterx-icons/[^/]+/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:51:\"index.php/jupiterx-icons/[^/]+/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:71:\"index.php/jupiterx-icons/[^/]+/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:66:\"index.php/jupiterx-icons/[^/]+/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:66:\"index.php/jupiterx-icons/[^/]+/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:47:\"index.php/jupiterx-icons/[^/]+/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:12:\"robots\\.txt$\";s:18:\"index.php?robots=1\";s:13:\"favicon\\.ico$\";s:19:\"index.php?favicon=1\";s:48:\".*wp-(atom|rdf|rss|rss2|feed|commentsrss2)\\.php$\";s:18:\"index.php?feed=old\";s:20:\".*wp-app\\.php(/.*)?$\";s:19:\"index.php?error=403\";s:18:\".*wp-register.php$\";s:23:\"index.php?register=true\";s:42:\"index.php/feed/(feed|rdf|rss|rss2|atom)/?$\";s:27:\"index.php?&feed=$matches[1]\";s:37:\"index.php/(feed|rdf|rss|rss2|atom)/?$\";s:27:\"index.php?&feed=$matches[1]\";s:18:\"index.php/embed/?$\";s:21:\"index.php?&embed=true\";s:30:\"index.php/page/?([0-9]{1,})/?$\";s:28:\"index.php?&paged=$matches[1]\";s:51:\"index.php/comments/feed/(feed|rdf|rss|rss2|atom)/?$\";s:42:\"index.php?&feed=$matches[1]&withcomments=1\";s:46:\"index.php/comments/(feed|rdf|rss|rss2|atom)/?$\";s:42:\"index.php?&feed=$matches[1]&withcomments=1\";s:27:\"index.php/comments/embed/?$\";s:21:\"index.php?&embed=true\";s:54:\"index.php/search/(.+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:40:\"index.php?s=$matches[1]&feed=$matches[2]\";s:49:\"index.php/search/(.+)/(feed|rdf|rss|rss2|atom)/?$\";s:40:\"index.php?s=$matches[1]&feed=$matches[2]\";s:30:\"index.php/search/(.+)/embed/?$\";s:34:\"index.php?s=$matches[1]&embed=true\";s:42:\"index.php/search/(.+)/page/?([0-9]{1,})/?$\";s:41:\"index.php?s=$matches[1]&paged=$matches[2]\";s:24:\"index.php/search/(.+)/?$\";s:23:\"index.php?s=$matches[1]\";s:57:\"index.php/author/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?author_name=$matches[1]&feed=$matches[2]\";s:52:\"index.php/author/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?author_name=$matches[1]&feed=$matches[2]\";s:33:\"index.php/author/([^/]+)/embed/?$\";s:44:\"index.php?author_name=$matches[1]&embed=true\";s:45:\"index.php/author/([^/]+)/page/?([0-9]{1,})/?$\";s:51:\"index.php?author_name=$matches[1]&paged=$matches[2]\";s:27:\"index.php/author/([^/]+)/?$\";s:33:\"index.php?author_name=$matches[1]\";s:79:\"index.php/([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/feed/(feed|rdf|rss|rss2|atom)/?$\";s:80:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&feed=$matches[4]\";s:74:\"index.php/([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/(feed|rdf|rss|rss2|atom)/?$\";s:80:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&feed=$matches[4]\";s:55:\"index.php/([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/embed/?$\";s:74:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&embed=true\";s:67:\"index.php/([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/page/?([0-9]{1,})/?$\";s:81:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&paged=$matches[4]\";s:49:\"index.php/([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/?$\";s:63:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]\";s:66:\"index.php/([0-9]{4})/([0-9]{1,2})/feed/(feed|rdf|rss|rss2|atom)/?$\";s:64:\"index.php?year=$matches[1]&monthnum=$matches[2]&feed=$matches[3]\";s:61:\"index.php/([0-9]{4})/([0-9]{1,2})/(feed|rdf|rss|rss2|atom)/?$\";s:64:\"index.php?year=$matches[1]&monthnum=$matches[2]&feed=$matches[3]\";s:42:\"index.php/([0-9]{4})/([0-9]{1,2})/embed/?$\";s:58:\"index.php?year=$matches[1]&monthnum=$matches[2]&embed=true\";s:54:\"index.php/([0-9]{4})/([0-9]{1,2})/page/?([0-9]{1,})/?$\";s:65:\"index.php?year=$matches[1]&monthnum=$matches[2]&paged=$matches[3]\";s:36:\"index.php/([0-9]{4})/([0-9]{1,2})/?$\";s:47:\"index.php?year=$matches[1]&monthnum=$matches[2]\";s:53:\"index.php/([0-9]{4})/feed/(feed|rdf|rss|rss2|atom)/?$\";s:43:\"index.php?year=$matches[1]&feed=$matches[2]\";s:48:\"index.php/([0-9]{4})/(feed|rdf|rss|rss2|atom)/?$\";s:43:\"index.php?year=$matches[1]&feed=$matches[2]\";s:29:\"index.php/([0-9]{4})/embed/?$\";s:37:\"index.php?year=$matches[1]&embed=true\";s:41:\"index.php/([0-9]{4})/page/?([0-9]{1,})/?$\";s:44:\"index.php?year=$matches[1]&paged=$matches[2]\";s:23:\"index.php/([0-9]{4})/?$\";s:26:\"index.php?year=$matches[1]\";s:68:\"index.php/[0-9]{4}/[0-9]{1,2}/[0-9]{1,2}/[^/]+/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:78:\"index.php/[0-9]{4}/[0-9]{1,2}/[0-9]{1,2}/[^/]+/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:98:\"index.php/[0-9]{4}/[0-9]{1,2}/[0-9]{1,2}/[^/]+/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:93:\"index.php/[0-9]{4}/[0-9]{1,2}/[0-9]{1,2}/[^/]+/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:93:\"index.php/[0-9]{4}/[0-9]{1,2}/[0-9]{1,2}/[^/]+/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:74:\"index.php/[0-9]{4}/[0-9]{1,2}/[0-9]{1,2}/[^/]+/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:63:\"index.php/([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/([^/]+)/embed/?$\";s:91:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&name=$matches[4]&embed=true\";s:67:\"index.php/([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/([^/]+)/trackback/?$\";s:85:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&name=$matches[4]&tb=1\";s:87:\"index.php/([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:97:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&name=$matches[4]&feed=$matches[5]\";s:82:\"index.php/([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:97:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&name=$matches[4]&feed=$matches[5]\";s:75:\"index.php/([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/([^/]+)/page/?([0-9]{1,})/?$\";s:98:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&name=$matches[4]&paged=$matches[5]\";s:82:\"index.php/([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/([^/]+)/comment-page-([0-9]{1,})/?$\";s:98:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&name=$matches[4]&cpage=$matches[5]\";s:71:\"index.php/([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/([^/]+)(?:/([0-9]+))?/?$\";s:97:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&name=$matches[4]&page=$matches[5]\";s:57:\"index.php/[0-9]{4}/[0-9]{1,2}/[0-9]{1,2}/[^/]+/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:67:\"index.php/[0-9]{4}/[0-9]{1,2}/[0-9]{1,2}/[^/]+/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:87:\"index.php/[0-9]{4}/[0-9]{1,2}/[0-9]{1,2}/[^/]+/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:82:\"index.php/[0-9]{4}/[0-9]{1,2}/[0-9]{1,2}/[^/]+/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:82:\"index.php/[0-9]{4}/[0-9]{1,2}/[0-9]{1,2}/[^/]+/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:63:\"index.php/[0-9]{4}/[0-9]{1,2}/[0-9]{1,2}/[^/]+/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:74:\"index.php/([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/comment-page-([0-9]{1,})/?$\";s:81:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&cpage=$matches[4]\";s:61:\"index.php/([0-9]{4})/([0-9]{1,2})/comment-page-([0-9]{1,})/?$\";s:65:\"index.php?year=$matches[1]&monthnum=$matches[2]&cpage=$matches[3]\";s:48:\"index.php/([0-9]{4})/comment-page-([0-9]{1,})/?$\";s:44:\"index.php?year=$matches[1]&cpage=$matches[2]\";s:37:\"index.php/.?.+?/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:47:\"index.php/.?.+?/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:67:\"index.php/.?.+?/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:62:\"index.php/.?.+?/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:62:\"index.php/.?.+?/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:43:\"index.php/.?.+?/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:26:\"index.php/(.?.+?)/embed/?$\";s:41:\"index.php?pagename=$matches[1]&embed=true\";s:30:\"index.php/(.?.+?)/trackback/?$\";s:35:\"index.php?pagename=$matches[1]&tb=1\";s:50:\"index.php/(.?.+?)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:47:\"index.php?pagename=$matches[1]&feed=$matches[2]\";s:45:\"index.php/(.?.+?)/(feed|rdf|rss|rss2|atom)/?$\";s:47:\"index.php?pagename=$matches[1]&feed=$matches[2]\";s:38:\"index.php/(.?.+?)/page/?([0-9]{1,})/?$\";s:48:\"index.php?pagename=$matches[1]&paged=$matches[2]\";s:45:\"index.php/(.?.+?)/comment-page-([0-9]{1,})/?$\";s:48:\"index.php?pagename=$matches[1]&cpage=$matches[2]\";s:34:\"index.php/(.?.+?)(?:/([0-9]+))?/?$\";s:47:\"index.php?pagename=$matches[1]&page=$matches[2]\";}","yes");
INSERT INTO ceba_options VALUES("30","hack_file","0","yes");
INSERT INTO ceba_options VALUES("31","blog_charset","UTF-8","yes");
INSERT INTO ceba_options VALUES("32","moderation_keys","","no");
INSERT INTO ceba_options VALUES("33","active_plugins","a:5:{i:0;s:30:\"advanced-custom-fields/acf.php\";i:1;s:23:\"elementor/elementor.php\";i:2;s:35:\"google-site-kit/google-site-kit.php\";i:3;s:31:\"jupiterx-core/jupiterx-core.php\";i:4;s:24:\"wordpress-seo/wp-seo.php\";}","yes");
INSERT INTO ceba_options VALUES("34","category_base","","yes");
INSERT INTO ceba_options VALUES("35","ping_sites","http://rpc.pingomatic.com/","yes");
INSERT INTO ceba_options VALUES("36","comment_max_links","2","yes");
INSERT INTO ceba_options VALUES("37","gmt_offset","0","yes");
INSERT INTO ceba_options VALUES("38","default_email_category","1","yes");
INSERT INTO ceba_options VALUES("39","recently_edited","","no");
INSERT INTO ceba_options VALUES("40","template","jupiterx","yes");
INSERT INTO ceba_options VALUES("41","stylesheet","jupiterx","yes");
INSERT INTO ceba_options VALUES("42","comment_registration","0","yes");
INSERT INTO ceba_options VALUES("43","html_type","text/html","yes");
INSERT INTO ceba_options VALUES("44","use_trackback","0","yes");
INSERT INTO ceba_options VALUES("45","default_role","subscriber","yes");
INSERT INTO ceba_options VALUES("46","db_version","53496","yes");
INSERT INTO ceba_options VALUES("47","uploads_use_yearmonth_folders","1","yes");
INSERT INTO ceba_options VALUES("48","upload_path","","yes");
INSERT INTO ceba_options VALUES("49","blog_public","1","yes");
INSERT INTO ceba_options VALUES("50","default_link_category","2","yes");
INSERT INTO ceba_options VALUES("51","show_on_front","posts","yes");
INSERT INTO ceba_options VALUES("52","tag_base","","yes");
INSERT INTO ceba_options VALUES("53","show_avatars","1","yes");
INSERT INTO ceba_options VALUES("54","avatar_rating","G","yes");
INSERT INTO ceba_options VALUES("55","upload_url_path","","yes");
INSERT INTO ceba_options VALUES("56","thumbnail_size_w","150","yes");
INSERT INTO ceba_options VALUES("57","thumbnail_size_h","150","yes");
INSERT INTO ceba_options VALUES("58","thumbnail_crop","1","yes");
INSERT INTO ceba_options VALUES("59","medium_size_w","300","yes");
INSERT INTO ceba_options VALUES("60","medium_size_h","300","yes");
INSERT INTO ceba_options VALUES("61","avatar_default","mystery","yes");
INSERT INTO ceba_options VALUES("62","large_size_w","1024","yes");
INSERT INTO ceba_options VALUES("63","large_size_h","1024","yes");
INSERT INTO ceba_options VALUES("64","image_default_link_type","none","yes");
INSERT INTO ceba_options VALUES("65","image_default_size","","yes");
INSERT INTO ceba_options VALUES("66","image_default_align","","yes");
INSERT INTO ceba_options VALUES("67","close_comments_for_old_posts","0","yes");
INSERT INTO ceba_options VALUES("68","close_comments_days_old","14","yes");
INSERT INTO ceba_options VALUES("69","thread_comments","1","yes");
INSERT INTO ceba_options VALUES("70","thread_comments_depth","5","yes");
INSERT INTO ceba_options VALUES("71","page_comments","0","yes");
INSERT INTO ceba_options VALUES("72","comments_per_page","50","yes");
INSERT INTO ceba_options VALUES("73","default_comments_page","newest","yes");
INSERT INTO ceba_options VALUES("74","comment_order","asc","yes");
INSERT INTO ceba_options VALUES("75","sticky_posts","a:0:{}","yes");
INSERT INTO ceba_options VALUES("76","widget_categories","a:0:{}","yes");
INSERT INTO ceba_options VALUES("77","widget_text","a:0:{}","yes");
INSERT INTO ceba_options VALUES("78","widget_rss","a:0:{}","yes");
INSERT INTO ceba_options VALUES("79","uninstall_plugins","a:2:{s:24:\"wordpress-seo/wp-seo.php\";s:14:\"__return_false\";s:23:\"elementor/elementor.php\";a:2:{i:0;s:21:\"Elementor\\Maintenance\";i:1;s:9:\"uninstall\";}}","no");
INSERT INTO ceba_options VALUES("80","timezone_string","","yes");
INSERT INTO ceba_options VALUES("81","page_for_posts","0","yes");
INSERT INTO ceba_options VALUES("82","page_on_front","0","yes");
INSERT INTO ceba_options VALUES("83","default_post_format","0","yes");
INSERT INTO ceba_options VALUES("84","link_manager_enabled","0","yes");
INSERT INTO ceba_options VALUES("85","finished_splitting_shared_terms","1","yes");
INSERT INTO ceba_options VALUES("86","site_icon","0","yes");
INSERT INTO ceba_options VALUES("87","medium_large_size_w","768","yes");
INSERT INTO ceba_options VALUES("88","medium_large_size_h","0","yes");
INSERT INTO ceba_options VALUES("89","wp_page_for_privacy_policy","3","yes");
INSERT INTO ceba_options VALUES("90","show_comments_cookies_opt_in","1","yes");
INSERT INTO ceba_options VALUES("91","admin_email_lifespan","1685434464","yes");
INSERT INTO ceba_options VALUES("92","disallowed_keys","","no");
INSERT INTO ceba_options VALUES("93","comment_previously_approved","1","yes");
INSERT INTO ceba_options VALUES("94","auto_plugin_theme_update_emails","a:0:{}","no");
INSERT INTO ceba_options VALUES("95","auto_update_core_dev","enabled","yes");
INSERT INTO ceba_options VALUES("96","auto_update_core_minor","enabled","yes");
INSERT INTO ceba_options VALUES("97","auto_update_core_major","enabled","yes");
INSERT INTO ceba_options VALUES("98","wp_force_deactivated_plugins","a:0:{}","yes");
INSERT INTO ceba_options VALUES("99","initial_db_version","53496","yes");
INSERT INTO ceba_options VALUES("100","ceba_user_roles","a:7:{s:13:\"administrator\";a:2:{s:4:\"name\";s:13:\"Administrator\";s:12:\"capabilities\";a:62:{s:13:\"switch_themes\";b:1;s:11:\"edit_themes\";b:1;s:16:\"activate_plugins\";b:1;s:12:\"edit_plugins\";b:1;s:10:\"edit_users\";b:1;s:10:\"edit_files\";b:1;s:14:\"manage_options\";b:1;s:17:\"moderate_comments\";b:1;s:17:\"manage_categories\";b:1;s:12:\"manage_links\";b:1;s:12:\"upload_files\";b:1;s:6:\"import\";b:1;s:15:\"unfiltered_html\";b:1;s:10:\"edit_posts\";b:1;s:17:\"edit_others_posts\";b:1;s:20:\"edit_published_posts\";b:1;s:13:\"publish_posts\";b:1;s:10:\"edit_pages\";b:1;s:4:\"read\";b:1;s:8:\"level_10\";b:1;s:7:\"level_9\";b:1;s:7:\"level_8\";b:1;s:7:\"level_7\";b:1;s:7:\"level_6\";b:1;s:7:\"level_5\";b:1;s:7:\"level_4\";b:1;s:7:\"level_3\";b:1;s:7:\"level_2\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:17:\"edit_others_pages\";b:1;s:20:\"edit_published_pages\";b:1;s:13:\"publish_pages\";b:1;s:12:\"delete_pages\";b:1;s:19:\"delete_others_pages\";b:1;s:22:\"delete_published_pages\";b:1;s:12:\"delete_posts\";b:1;s:19:\"delete_others_posts\";b:1;s:22:\"delete_published_posts\";b:1;s:20:\"delete_private_posts\";b:1;s:18:\"edit_private_posts\";b:1;s:18:\"read_private_posts\";b:1;s:20:\"delete_private_pages\";b:1;s:18:\"edit_private_pages\";b:1;s:18:\"read_private_pages\";b:1;s:12:\"delete_users\";b:1;s:12:\"create_users\";b:1;s:17:\"unfiltered_upload\";b:1;s:14:\"edit_dashboard\";b:1;s:14:\"update_plugins\";b:1;s:14:\"delete_plugins\";b:1;s:15:\"install_plugins\";b:1;s:13:\"update_themes\";b:1;s:14:\"install_themes\";b:1;s:11:\"update_core\";b:1;s:10:\"list_users\";b:1;s:12:\"remove_users\";b:1;s:13:\"promote_users\";b:1;s:18:\"edit_theme_options\";b:1;s:13:\"delete_themes\";b:1;s:6:\"export\";b:1;s:20:\"wpseo_manage_options\";b:1;}}s:6:\"editor\";a:2:{s:4:\"name\";s:6:\"Editor\";s:12:\"capabilities\";a:36:{s:17:\"moderate_comments\";b:1;s:17:\"manage_categories\";b:1;s:12:\"manage_links\";b:1;s:12:\"upload_files\";b:1;s:15:\"unfiltered_html\";b:1;s:10:\"edit_posts\";b:1;s:17:\"edit_others_posts\";b:1;s:20:\"edit_published_posts\";b:1;s:13:\"publish_posts\";b:1;s:10:\"edit_pages\";b:1;s:4:\"read\";b:1;s:7:\"level_7\";b:1;s:7:\"level_6\";b:1;s:7:\"level_5\";b:1;s:7:\"level_4\";b:1;s:7:\"level_3\";b:1;s:7:\"level_2\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:17:\"edit_others_pages\";b:1;s:20:\"edit_published_pages\";b:1;s:13:\"publish_pages\";b:1;s:12:\"delete_pages\";b:1;s:19:\"delete_others_pages\";b:1;s:22:\"delete_published_pages\";b:1;s:12:\"delete_posts\";b:1;s:19:\"delete_others_posts\";b:1;s:22:\"delete_published_posts\";b:1;s:20:\"delete_private_posts\";b:1;s:18:\"edit_private_posts\";b:1;s:18:\"read_private_posts\";b:1;s:20:\"delete_private_pages\";b:1;s:18:\"edit_private_pages\";b:1;s:18:\"read_private_pages\";b:1;s:15:\"wpseo_bulk_edit\";b:1;s:28:\"wpseo_edit_advanced_metadata\";b:1;}}s:6:\"author\";a:2:{s:4:\"name\";s:6:\"Author\";s:12:\"capabilities\";a:10:{s:12:\"upload_files\";b:1;s:10:\"edit_posts\";b:1;s:20:\"edit_published_posts\";b:1;s:13:\"publish_posts\";b:1;s:4:\"read\";b:1;s:7:\"level_2\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:12:\"delete_posts\";b:1;s:22:\"delete_published_posts\";b:1;}}s:11:\"contributor\";a:2:{s:4:\"name\";s:11:\"Contributor\";s:12:\"capabilities\";a:5:{s:10:\"edit_posts\";b:1;s:4:\"read\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:12:\"delete_posts\";b:1;}}s:10:\"subscriber\";a:2:{s:4:\"name\";s:10:\"Subscriber\";s:12:\"capabilities\";a:2:{s:4:\"read\";b:1;s:7:\"level_0\";b:1;}}s:13:\"wpseo_manager\";a:2:{s:4:\"name\";s:11:\"SEO Manager\";s:12:\"capabilities\";a:38:{s:17:\"moderate_comments\";b:1;s:17:\"manage_categories\";b:1;s:12:\"manage_links\";b:1;s:12:\"upload_files\";b:1;s:15:\"unfiltered_html\";b:1;s:10:\"edit_posts\";b:1;s:17:\"edit_others_posts\";b:1;s:20:\"edit_published_posts\";b:1;s:13:\"publish_posts\";b:1;s:10:\"edit_pages\";b:1;s:4:\"read\";b:1;s:7:\"level_7\";b:1;s:7:\"level_6\";b:1;s:7:\"level_5\";b:1;s:7:\"level_4\";b:1;s:7:\"level_3\";b:1;s:7:\"level_2\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:17:\"edit_others_pages\";b:1;s:20:\"edit_published_pages\";b:1;s:13:\"publish_pages\";b:1;s:12:\"delete_pages\";b:1;s:19:\"delete_others_pages\";b:1;s:22:\"delete_published_pages\";b:1;s:12:\"delete_posts\";b:1;s:19:\"delete_others_posts\";b:1;s:22:\"delete_published_posts\";b:1;s:20:\"delete_private_posts\";b:1;s:18:\"edit_private_posts\";b:1;s:18:\"read_private_posts\";b:1;s:20:\"delete_private_pages\";b:1;s:18:\"edit_private_pages\";b:1;s:18:\"read_private_pages\";b:1;s:15:\"wpseo_bulk_edit\";b:1;s:28:\"wpseo_edit_advanced_metadata\";b:1;s:20:\"wpseo_manage_options\";b:1;s:23:\"view_site_health_checks\";b:1;}}s:12:\"wpseo_editor\";a:2:{s:4:\"name\";s:10:\"SEO Editor\";s:12:\"capabilities\";a:36:{s:17:\"moderate_comments\";b:1;s:17:\"manage_categories\";b:1;s:12:\"manage_links\";b:1;s:12:\"upload_files\";b:1;s:15:\"unfiltered_html\";b:1;s:10:\"edit_posts\";b:1;s:17:\"edit_others_posts\";b:1;s:20:\"edit_published_posts\";b:1;s:13:\"publish_posts\";b:1;s:10:\"edit_pages\";b:1;s:4:\"read\";b:1;s:7:\"level_7\";b:1;s:7:\"level_6\";b:1;s:7:\"level_5\";b:1;s:7:\"level_4\";b:1;s:7:\"level_3\";b:1;s:7:\"level_2\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:17:\"edit_others_pages\";b:1;s:20:\"edit_published_pages\";b:1;s:13:\"publish_pages\";b:1;s:12:\"delete_pages\";b:1;s:19:\"delete_others_pages\";b:1;s:22:\"delete_published_pages\";b:1;s:12:\"delete_posts\";b:1;s:19:\"delete_others_posts\";b:1;s:22:\"delete_published_posts\";b:1;s:20:\"delete_private_posts\";b:1;s:18:\"edit_private_posts\";b:1;s:18:\"read_private_posts\";b:1;s:20:\"delete_private_pages\";b:1;s:18:\"edit_private_pages\";b:1;s:18:\"read_private_pages\";b:1;s:15:\"wpseo_bulk_edit\";b:1;s:28:\"wpseo_edit_advanced_metadata\";b:1;}}}","yes");
INSERT INTO ceba_options VALUES("101","fresh_site","1","yes");
INSERT INTO ceba_options VALUES("102","user_count","1","no");
INSERT INTO ceba_options VALUES("103","widget_block","a:6:{i:2;a:1:{s:7:\"content\";s:19:\"<!-- wp:search /-->\";}i:3;a:1:{s:7:\"content\";s:154:\"<!-- wp:group --><div class=\"wp-block-group\"><!-- wp:heading --><h2>Recent Posts</h2><!-- /wp:heading --><!-- wp:latest-posts /--></div><!-- /wp:group -->\";}i:4;a:1:{s:7:\"content\";s:227:\"<!-- wp:group --><div class=\"wp-block-group\"><!-- wp:heading --><h2>Recent Comments</h2><!-- /wp:heading --><!-- wp:latest-comments {\"displayAvatar\":false,\"displayDate\":false,\"displayExcerpt\":false} /--></div><!-- /wp:group -->\";}i:5;a:1:{s:7:\"content\";s:146:\"<!-- wp:group --><div class=\"wp-block-group\"><!-- wp:heading --><h2>Archives</h2><!-- /wp:heading --><!-- wp:archives /--></div><!-- /wp:group -->\";}i:6;a:1:{s:7:\"content\";s:150:\"<!-- wp:group --><div class=\"wp-block-group\"><!-- wp:heading --><h2>Categories</h2><!-- /wp:heading --><!-- wp:categories /--></div><!-- /wp:group -->\";}s:12:\"_multiwidget\";i:1;}","yes");
INSERT INTO ceba_options VALUES("104","sidebars_widgets","a:10:{s:19:\"wp_inactive_widgets\";a:0:{}s:15:\"sidebar_primary\";a:3:{i:0;s:7:\"block-2\";i:1;s:7:\"block-3\";i:2;s:7:\"block-4\";}s:17:\"sidebar_secondary\";a:2:{i:0;s:7:\"block-5\";i:1;s:7:\"block-6\";}s:23:\"footer_widgets_column_1\";a:0:{}s:23:\"footer_widgets_column_2\";a:0:{}s:23:\"footer_widgets_column_3\";a:0:{}s:23:\"footer_widgets_column_4\";a:0:{}s:23:\"footer_widgets_column_5\";a:0:{}s:23:\"footer_widgets_column_6\";a:0:{}s:13:\"array_version\";i:3;}","yes");
INSERT INTO ceba_options VALUES("105","cron","a:15:{i:1669886066;a:1:{s:34:\"wp_privacy_delete_old_export_files\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:6:\"hourly\";s:4:\"args\";a:0:{}s:8:\"interval\";i:3600;}}}i:1669891406;a:1:{s:26:\"upgrader_scheduled_cleanup\";a:1:{s:32:\"c9059feef497c200e69cb9956a81f005\";a:2:{s:8:\"schedule\";b:0;s:4:\"args\";a:1:{i:0;i:5;}}}}i:1669891661;a:1:{s:26:\"upgrader_scheduled_cleanup\";a:1:{s:32:\"686c8315be36c96dc00d0d7ed3656b43\";a:2:{s:8:\"schedule\";b:0;s:4:\"args\";a:1:{i:0;i:6;}}}}i:1669892015;a:1:{s:26:\"upgrader_scheduled_cleanup\";a:1:{s:32:\"d63aca0b7e6237c7964320bd7fc95644\";a:2:{s:8:\"schedule\";b:0;s:4:\"args\";a:1:{i:0;i:7;}}}}i:1669925666;a:3:{s:18:\"wp_https_detection\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}s:17:\"wp_update_plugins\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}s:16:\"wp_update_themes\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}}i:1669926816;a:1:{s:41:\"googlesitekit_cron_update_remote_features\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}}i:1669927345;a:1:{s:21:\"wp_update_user_counts\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}}i:1669968866;a:2:{s:30:\"wp_site_health_scheduled_check\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:6:\"weekly\";s:4:\"args\";a:0:{}s:8:\"interval\";i:604800;}}s:32:\"recovery_mode_clean_expired_keys\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1669970275;a:1:{s:31:\"wpseo_permalink_structure_check\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1669970478;a:1:{s:13:\"wpseo-reindex\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1669970545;a:2:{s:19:\"wp_scheduled_delete\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}s:25:\"delete_expired_transients\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1669970546;a:1:{s:30:\"wp_scheduled_auto_draft_delete\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1669971908;a:1:{s:28:\"elementor/tracker/send_event\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1670055287;a:1:{s:16:\"wp_version_check\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}}s:7:\"version\";i:2;}","yes");
INSERT INTO ceba_options VALUES("106","widget_pages","a:1:{s:12:\"_multiwidget\";i:1;}","yes");
INSERT INTO ceba_options VALUES("107","widget_calendar","a:1:{s:12:\"_multiwidget\";i:1;}","yes");
INSERT INTO ceba_options VALUES("108","widget_archives","a:1:{s:12:\"_multiwidget\";i:1;}","yes");
INSERT INTO ceba_options VALUES("109","widget_media_audio","a:1:{s:12:\"_multiwidget\";i:1;}","yes");
INSERT INTO ceba_options VALUES("110","widget_media_image","a:1:{s:12:\"_multiwidget\";i:1;}","yes");
INSERT INTO ceba_options VALUES("111","widget_media_gallery","a:1:{s:12:\"_multiwidget\";i:1;}","yes");
INSERT INTO ceba_options VALUES("112","widget_media_video","a:1:{s:12:\"_multiwidget\";i:1;}","yes");
INSERT INTO ceba_options VALUES("113","widget_meta","a:1:{s:12:\"_multiwidget\";i:1;}","yes");
INSERT INTO ceba_options VALUES("114","widget_search","a:1:{s:12:\"_multiwidget\";i:1;}","yes");
INSERT INTO ceba_options VALUES("115","nonce_key","faZ.(}qBU{KoDzkW6SEb04pf%AGs]L}X%b5hOdtBL52`&Abw]Ipu)QE`W1^E#{w)","no");
INSERT INTO ceba_options VALUES("116","nonce_salt","IZ;Dv,l|Gds=0CLfSHFGLkXg)2SpIQ>{,k*XsfY~NfXqN>?3a|qH#2K:pu60ri;-","no");
INSERT INTO ceba_options VALUES("117","widget_recent-posts","a:1:{s:12:\"_multiwidget\";i:1;}","yes");
INSERT INTO ceba_options VALUES("118","widget_recent-comments","a:1:{s:12:\"_multiwidget\";i:1;}","yes");
INSERT INTO ceba_options VALUES("119","widget_tag_cloud","a:1:{s:12:\"_multiwidget\";i:1;}","yes");
INSERT INTO ceba_options VALUES("120","widget_nav_menu","a:1:{s:12:\"_multiwidget\";i:1;}","yes");
INSERT INTO ceba_options VALUES("121","widget_custom_html","a:1:{s:12:\"_multiwidget\";i:1;}","yes");
INSERT INTO ceba_options VALUES("123","recovery_keys","a:0:{}","yes");
INSERT INTO ceba_options VALUES("178","_site_transient_community-events-533aadd0e18f38fc88cf15109871ebe0","a:4:{s:9:\"sandboxed\";b:0;s:5:\"error\";N;s:8:\"location\";a:1:{s:2:\"ip\";s:12:\"41.222.179.0\";}s:6:\"events\";a:1:{i:0;a:10:{s:4:\"type\";s:6:\"meetup\";s:5:\"title\";s:46:\"Virtual Wordpress Community Reactivation - Dar\";s:3:\"url\";s:76:\"https://www.meetup.com/dar-es-salaam-wordpress-meetup-group/events/289912308\";s:6:\"meetup\";s:30:\"Dar es Salaam WordPress Meetup\";s:10:\"meetup_url\";s:60:\"https://www.meetup.com/Dar-es-Salaam-WordPress-Meetup-Group/\";s:4:\"date\";s:19:\"2022-12-10 10:00:00\";s:8:\"end_date\";s:19:\"2022-12-10 11:00:00\";s:20:\"start_unix_timestamp\";i:1670655600;s:18:\"end_unix_timestamp\";i:1670659200;s:8:\"location\";a:4:{s:8:\"location\";s:6:\"Online\";s:7:\"country\";s:2:\"TZ\";s:8:\"latitude\";d:-6.82000000000000028421709430404007434844970703125;s:9:\"longitude\";d:39.280000000000001136868377216160297393798828125;}}}}","no");
INSERT INTO ceba_options VALUES("179","can_compress_scripts","0","no");
INSERT INTO ceba_options VALUES("180","_transient_timeout_feed_9bbd59226dc36b9b26cd43f15694c5c3","1669927353","no");
INSERT INTO ceba_options VALUES("181","_transient_feed_9bbd59226dc36b9b26cd43f15694c5c3","a:4:{s:5:\"child\";a:1:{s:0:\"\";a:1:{s:3:\"rss\";a:1:{i:0;a:6:{s:4:\"data\";s:3:\"\n\n\n\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:7:\"version\";s:3:\"2.0\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:1:{s:0:\"\";a:1:{s:7:\"channel\";a:1:{i:0;a:6:{s:4:\"data\";s:52:\"\n	\n	\n	\n	\n	\n	\n	\n	\n	\n\n \n	\n		\n		\n		\n		\n		\n		\n		\n		\n		\n	\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:4:{s:0:\"\";a:8:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:14:\"WordPress News\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:26:\"https://wordpress.org/news\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:59:\"The latest news about WordPress and the WordPress community\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:13:\"lastBuildDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Wed, 30 Nov 2022 21:31:04 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"language\";a:1:{i:0;a:5:{s:4:\"data\";s:5:\"en-US\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:9:\"generator\";a:1:{i:0;a:5:{s:4:\"data\";s:40:\"https://wordpress.org/?v=6.2-alpha-54919\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:5:\"image\";a:1:{i:0;a:6:{s:4:\"data\";s:11:\"\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:1:{s:0:\"\";a:5:{s:3:\"url\";a:1:{i:0;a:5:{s:4:\"data\";s:29:\"https://s.w.org/favicon.ico?2\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:14:\"WordPress News\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:26:\"https://wordpress.org/news\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:5:\"width\";a:1:{i:0;a:5:{s:4:\"data\";s:2:\"32\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:6:\"height\";a:1:{i:0;a:5:{s:4:\"data\";s:2:\"32\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}}s:4:\"item\";a:10:{i:0;a:6:{s:4:\"data\";s:72:\"\n		\n		\n		\n		\n		\n				\n		\n		\n		\n		\n		\n		\n\n					\n										\n					\n		\n		\n			\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:4:{s:0:\"\";a:6:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:34:\"People of WordPress: Huanyi Chuang\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:69:\"https://wordpress.org/news/2022/11/people-of-wordpress-huanyi-chuang/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Wed, 30 Nov 2022 20:09:00 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:6:{i:0;a:5:{s:4:\"data\";s:9:\"Community\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:1;a:5:{s:4:\"data\";s:8:\"Features\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:2;a:5:{s:4:\"data\";s:7:\"General\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:3;a:5:{s:4:\"data\";s:10:\"Interviews\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:4;a:5:{s:4:\"data\";s:9:\"HeroPress\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:5;a:5:{s:4:\"data\";s:19:\"People of WordPress\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:35:\"https://wordpress.org/news/?p=13562\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:144:\"The latest People of WordPress story features Huanyi Chuang, from #Taiwan, on his journey to become a digital marketer and front end developer. \";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:11:\"Abha Thakor\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:11499:\"\n<p><strong>This month we feature Huanyi (Eric) Chuang, a front end developer from Taiwan, who helps connect local groups to WordPress and the worldwide open source community. He is part of the team helping to make the first WordCamp Asia a success in 2023.</strong></p>\n\n\n\n<p><strong>The People of WordPress series shares some of the inspiring stories of how people&#8217;s lives can change for the better through WordPress and its global network of contributors.</strong></p>\n\n\n\n<figure class=\"wp-block-image size-full\"><img decoding=\"async\" width=\"1014\" height=\"627\" src=\"https://i0.wp.com/wordpress.org/news/files/2022/09/huanyi-featured-img.jpg?resize=1014%2C627&#038;ssl=1\" alt=\"Huanyi pictured sitting inside a rock formation.\" class=\"wp-image-13479\" srcset=\"https://i0.wp.com/wordpress.org/news/files/2022/09/huanyi-featured-img.jpg?w=1014&amp;ssl=1 1014w, https://i0.wp.com/wordpress.org/news/files/2022/09/huanyi-featured-img.jpg?w=300&amp;ssl=1 300w, https://i0.wp.com/wordpress.org/news/files/2022/09/huanyi-featured-img.jpg?w=768&amp;ssl=1 768w\" sizes=\"(max-width: 1000px) 100vw, 1000px\" data-recalc-dims=\"1\" /></figure>\n\n\n\n<h2><strong>Discovering WordPress and the benefit of child themes </strong></h2>\n\n\n\n<p>Huanyi’s first footsteps in WordPress began in 2017 when he worked for a firm that built blogs and developed ad content for clients.</p>\n\n\n\n<p>After building a few sites using the platform, he discovered child themes and through them opened up a world of possibilities for his clients. To this day, he uses child themes to deliver truly custom designs and functionality for clients.</p>\n\n\n\n<p>Later in his career, Huanyi moved into digital marketing, integrating sites with massive ad platforms like Google and Facebook. This led him to learn to work with tracking code and JavaScript. He also began his learning journey in HTML, CSS, and PHP, to be able to improve his development skills and customize child themes.</p>\n\n\n\n<h2><strong>Meetups bring together software users to learn together</strong></h2>\n\n\n\n<figure class=\"wp-block-image size-full\"><img decoding=\"async\" loading=\"lazy\" width=\"600\" height=\"800\" src=\"https://i2.wp.com/wordpress.org/news/files/2022/09/huanyi-1.jpg?fit=600%2C800&amp;ssl=1\" alt=\"Huanyi and a koala.\" class=\"wp-image-13476\" srcset=\"https://i0.wp.com/wordpress.org/news/files/2022/09/huanyi-1.jpg?w=600&amp;ssl=1 600w, https://i0.wp.com/wordpress.org/news/files/2022/09/huanyi-1.jpg?w=225&amp;ssl=1 225w\" sizes=\"(max-width: 600px) 100vw, 600px\" /><figcaption class=\"wp-element-caption\"><em>Huanyi pictured in Australia during one of his travels meeting a koala bear.</em></figcaption></figure>\n\n\n\n<p>When Huanyi had a problem with a client&#8217;s site, he looked to WordPress meetups near where he lived in <a href=\"https://www.meetup.com/Taipei-WordPress/\">Taipei</a> to help find the solutions.</p>\n\n\n\n<blockquote class=\"wp-block-quote\">\n<p><strong>“When I encountered an issue with the custom archive pages, a local meetup announcement showed up on my WordPress dashboard</strong>.&#8221;</p>\n<cite>Huanyi Chuang</cite></blockquote>\n\n\n\n<p>At the meetup, he met more experienced WordPress users and developers there, who answered his questions and helped him learn.</p>\n\n\n\n<p>“When I encountered an issue with the custom archive pages, a local meetup announcement showed up on my WordPress dashboard. That was my original connection with the local community,” Huanyi said.</p>\n\n\n\n<p>The WordPress community gave Huanyi a chance to connect with people, feed his curiosity about the software, and join a circle of people he could share this interest.</p>\n\n\n\n<p>At first, he thought meetups were an opportunity to source new clients, and he took his business cards to every event. However, he soon found that these events offered him the opportunity to make friends and share knowledge.</p>\n\n\n\n<p>From then on, Huanyi started focusing more on what he could give to these events and networks, making new friends, and listening to people. This led him to share as a meetup speaker his own commercial website management experience.</p>\n\n\n\n<h2><strong>The road to WordCamp</strong></h2>\n\n\n\n<p>It was going to his first meetup and then getting involved with WordCamps that changed Huanyi&#8217;s whole relationship with WordPress.</p>\n\n\n\n<figure class=\"wp-block-image size-full\"><img decoding=\"async\" loading=\"lazy\" width=\"600\" height=\"800\" src=\"https://i0.wp.com/wordpress.org/news/files/2022/09/huanyi-2.jpg?resize=600%2C800&#038;ssl=1\" alt=\"Huanyi pictured on an outing, stood next to a white car.\" class=\"wp-image-13477\" srcset=\"https://i0.wp.com/wordpress.org/news/files/2022/09/huanyi-2.jpg?w=600&amp;ssl=1 600w, https://i0.wp.com/wordpress.org/news/files/2022/09/huanyi-2.jpg?w=225&amp;ssl=1 225w\" sizes=\"(max-width: 600px) 100vw, 600px\" data-recalc-dims=\"1\" /></figure>\n\n\n\n<p>In 2018, he took the step to help as an organizer, having joined the Taoyuan Meetup in Taiwan. He played several parts across the organizing team, and the welcoming feeling he got in every situation encouraged him to get more involved.</p>\n\n\n\n<p>He recalls meeting new friends from different fields and other countries, which gave him a great sense of achievement and strengthened his passion for participating in the community.</p>\n\n\n\n<p>When the team started this meetup, numbers were much lower than in the group in the city of Taipei, but they were not disheartened and gradually grew the local WordPress community.</p>\n\n\n\n<p>They created a pattern of ‘multiple organizers,’ which spread the workload and grew friendships.&nbsp;</p>\n\n\n\n<blockquote class=\"wp-block-quote\">\n<p><strong>“Being connected to and from meetups is the most valuable part of the community. Having these friends makes me gather more information. We share information and benefit from others’ information, and thus we gain more trust in each other. With such credibility, we share more deeply and build deeper relations.”</strong> </p>\n<cite>Huanyi Chuang</cite></blockquote>\n\n\n\n<p>Before the pandemic, the meetup met every month and grew to become the second largest meetup in Taiwan. Huanyi also contributed to the WordPress community as an organizer of WordCamp Taipei 2018 in the speaker team and lead organizer of <a href=\"https://taiwan.wordcamp.org/2021/\">WordCamp Taiwan 2021</a>.</p>\n\n\n\n<h2><strong>So why should you join the community?</strong></h2>\n\n\n\n<p>According to Huanyi, you will always have something to take home with you. It might be new information or experiences. It might be plugins or theme ideas. But most of all, it is the chance to meet fascinating people and make new friends.</p>\n\n\n\n<blockquote class=\"wp-block-quote\">\n<p>Huanyi’s message to other contributors:<br>&#8220;Keep participating, and you will find more you can achieve than you expect.” </p>\n</blockquote>\n\n\n\n<p>He added that long-term participation will &#8216;let you feel the humanity behind the project&#8217;.</p>\n\n\n\n<h2><strong>Localize: the road ahead for WordPress</strong></h2>\n\n\n\n<figure class=\"wp-block-image size-full\"><img decoding=\"async\" loading=\"lazy\" width=\"900\" height=\"675\" src=\"https://i0.wp.com/wordpress.org/news/files/2022/09/huanyi-3.jpg?resize=900%2C675&#038;ssl=1\" alt=\"Huanyi standing on a sandy beach.\" class=\"wp-image-13478\" srcset=\"https://i0.wp.com/wordpress.org/news/files/2022/09/huanyi-3.jpg?w=900&amp;ssl=1 900w, https://i0.wp.com/wordpress.org/news/files/2022/09/huanyi-3.jpg?w=300&amp;ssl=1 300w, https://i0.wp.com/wordpress.org/news/files/2022/09/huanyi-3.jpg?w=768&amp;ssl=1 768w\" sizes=\"(max-width: 900px) 100vw, 900px\" data-recalc-dims=\"1\" /></figure>\n\n\n\n<p>Huanyi believes WordPress has the power to break down the barriers between designers, project managers, developers, marketers, writers, and publishers. In Taiwan, he said WordPress is &#8216;a common protocol&#8217; that lets people from all of these disciplines work and communicate together more easily than they ever have before.</p>\n\n\n\n<p>That is why he works on and encourages others to localize plugins today. He believes localization of the software is the foundation for the extension of the WordPress community as it enables people to ‘Flex their Freedom’ in a language they speak!</p>\n\n\n\n<p>He has helped to organize online events around previous <a href=\"https://wptranslationday.org/\">WordPress Translation Day</a> events.</p>\n\n\n\n<p>Huanyi said: “I think it&#8217;s important to localize WordPress because its very concept of ‘open source’ means that people can access it freely. In another way, free from the monopoly of knowledge and speech. To achieve it, it&#8217;s important that people can access it with their own language.</p>\n\n\n\n<p>“Localization is the foundation of the extension of WordPress community because it helps people using different languages to access the project and lowers the hurdle to understand how things work.”</p>\n\n\n\n<h2>Share the stories</h2>\n\n\n\n<p>Help share these stories of open source contributors and continue to grow the community. Meet more WordPressers in the <a href=\"https://wordpress.org/news/category/newsletter/interviews/\">People of WordPress series</a>.</p>\n\n\n\n<h2><strong>Contributors</strong></h2>\n\n\n\n<p>Thank you to <a href=\'https://profiles.wordpress.org/no249a002/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>no249a002</a> for sharing his adventures in WordPress.</p>\n\n\n\n<p>Thank you to Abha Thakor (<a href=\'https://profiles.wordpress.org/webcommsat/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>webcommsat</a>), Mary Baum (<a href=\'https://profiles.wordpress.org/marybaum/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>marybaum</a>), Meher Bala (<a href=\'https://profiles.wordpress.org/meher/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>meher</a>), Chloe Bringmann (<a href=\'https://profiles.wordpress.org/cbringmann/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>cbringmann</a>), Surendra Thakor (<a href=\'https://profiles.wordpress.org/sthakor/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>sthakor</a>), Adeeb Malik (<a href=\'https://profiles.wordpress.org/adeebmalik/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>adeebmalik</a>) for research, interviews, and contributing to this feature article.</p>\n\n\n\n<p>The <em>People of WordPress</em> series thanks Josepha Haden (<a href=\'https://profiles.wordpress.org/chanthaboune/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>chanthaboune</a>) and Topher DeRosia (<a href=\'https://profiles.wordpress.org/topher1kenobe/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>topher1kenobe</a>) for their support.</p>\n\n\n\n<div class=\"wp-block-media-text is-stacked-on-mobile is-vertically-aligned-center\" style=\"grid-template-columns:29% auto\"><figure class=\"wp-block-media-text__media\"><img decoding=\"async\" loading=\"lazy\" width=\"180\" height=\"135\" src=\"https://i0.wp.com/wordpress.org/news/files/2020/03/heropress_logo_180.png?resize=180%2C135&#038;ssl=1\" alt=\"HeroPress logo\" class=\"wp-image-8409 size-full\" data-recalc-dims=\"1\" /></figure><div class=\"wp-block-media-text__content\">\n<p class=\"has-small-font-size\"><em>This People of WordPress feature is inspired by an essay originally published on </em><a href=\"https://heropress.com/\"><em>HeroPress.com</em></a><em>, a community initiative created by Topher DeRosia. It highlights people in the WordPress community who have overcome barriers and whose stories might otherwise go unheard. </em>#HeroPress </p>\n</div></div>\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:30:\"com-wordpress:feed-additions:1\";a:1:{s:7:\"post-id\";a:1:{i:0;a:5:{s:4:\"data\";s:5:\"13562\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:1;a:6:{s:4:\"data\";s:61:\"\n		\n		\n		\n		\n		\n				\n		\n		\n\n					\n										\n					\n		\n		\n\n			\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:4:{s:0:\"\";a:7:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:73:\"WP Briefing: Episode 44: Minors, Majors, and Why We Have So Many Releases\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:93:\"https://wordpress.org/news/2022/11/episode-44-minors-majors-and-why-we-have-so-many-releases/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Mon, 28 Nov 2022 12:00:00 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:2:{i:0;a:5:{s:4:\"data\";s:7:\"Podcast\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:1;a:5:{s:4:\"data\";s:11:\"wp-briefing\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:53:\"https://wordpress.org/news/?post_type=podcast&p=13996\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:129:\"Hear Josepha Haden Chomphosy highlight the role of manor and minor releases in the WordPress open source project in this episode.\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:9:\"enclosure\";a:1:{i:0;a:5:{s:4:\"data\";s:0:\"\";s:7:\"attribs\";a:1:{s:0:\"\";a:3:{s:3:\"url\";s:60:\"https://wordpress.org/news/files/2022/11/WP-Briefing-044.mp3\";s:6:\"length\";s:1:\"0\";s:4:\"type\";s:0:\"\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:14:\"Santana Inniss\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:8562:\"\n<p>In the forty-fourth episode of the WordPress Briefing, our host Josepha Haden Chomphosy highlights the role of major and minor releases in the WordPress open source project. </p>\n\n\n\n<p><em><strong>Have a question you&#8217;d like answered? You can submit them to <a href=\"mailto:wpbriefing@wordpress.org\">wpbriefing@wordpress.org</a>, either written or as a voice recording.</strong></em></p>\n\n\n\n<h2>Credits</h2>\n\n\n\n<p>Editor:&nbsp;<a href=\"https://profiles.wordpress.org/dustinhartzler/\">Dustin Hartzler</a><br>Logo:&nbsp;<a href=\"https://profiles.wordpress.org/javiarce/\" data-type=\"URL\" data-id=\"https://profiles.wordpress.org/javiarce/\">Javier Arce</a><br>Production:&nbsp;<a href=\"https://profiles.wordpress.org/santanainniss/\">Santana Inniss</a><br>Song: Fearless First by Kevin MacLeod </p>\n\n\n\n<h2>References</h2>\n\n\n\n<p><a href=\"https://en.wikipedia.org/wiki/12th_man_(football)\" data-type=\"URL\" data-id=\"https://en.wikipedia.org/wiki/12th_man_(football)\">Twelfth Man</a><br><a href=\"https://wordpress.org/news/2022/11/state-of-the-word-2022/\" data-type=\"URL\" data-id=\"https://wordpress.org/news/2022/11/state-of-the-word-2022/\">State of the Word</a></p>\n\n\n\n<h2>Transcript</h2>\n\n\n\n<span id=\"more-13996\"></span>\n\n\n\n<p><strong>[Josepha Haden Chomphosy 00:00:00]&nbsp;</strong></p>\n\n\n\n<p>Hello everyone! And welcome to the WordPress Briefing, the podcast where you can catch quick explanations of the ideas behind the WordPress open source project, some insight into the community that supports it, and get a small list of big things coming up in the next two weeks.&nbsp;</p>\n\n\n\n<p>I&#8217;m your host, Josepha Haden Chomphosy. Here we go.</p>\n\n\n\n<p><strong>[Josepha Haden Chomphosy 00:00:27]&nbsp;</strong></p>\n\n\n\n<p>At the top of November, a new major release for WordPress shipped. That was WordPress 6.1. I know I talked about it basically nonstop. Then two weeks later, there was a new minor release for WordPress. It was WordPress 6.1.1, which I did not talk about at all. Way back in episode four of this podcast, I dug into the overall release cycle and what someone could expect from a high-level logistics aspect.</p>\n\n\n\n<p><strong>[Josepha Haden Chomphosy 00:01:05]&nbsp;</strong></p>\n\n\n\n<p>And today we&#8217;re gonna take a quick look at minor releases in particular. Just as a general heads up, I always want to lean into sports metaphors when I&#8217;m talking about releases, and I think it&#8217;s because of the words major and minor. And so, I&#8217;ve done my level best to not include that in any of my explanations today.</p>\n\n\n\n<p>But I do have one, I do have one that&#8217;s a sports thing. So just if you don&#8217;t like sports, know that it&#8217;s just one little bit and we&#8217;ll try to be carefully quick around it together. All right, so minor releases. You may have noticed that I don&#8217;t mention minor releases nearly as often as I mention major releases. And yet, most of the time, when we have a major release of WordPress, there&#8217;s a minor release that gets started almost immediately after.</p>\n\n\n\n<p>So first major versus minor. Major releases in WordPress happen roughly three times a year, give or take a release. Inside a major release, you will find that we include features, so– brand new abilities, enhancements, which you can generally call improvements to existing abilities, and also any bug fix that we can find, big or small, we&#8217;ll take &#8217;em all.</p>\n\n\n\n<p><strong>[Josepha Haden Chomphosy 00:02:16]&nbsp;</strong></p>\n\n\n\n<p>So minor releases in WordPress happen about four or five times a year on average. Minor releases include patches for issues introduced in the major release and any bug fix that doesn&#8217;t add or change functionality.&nbsp;</p>\n\n\n\n<p>If you&#8217;re with me so far, you probably have noted that there&#8217;s basically always at least one minor release per major release. And you might have also noted that I said minors include patches for issues we introduced in a major.</p>\n\n\n\n<p>Now, if I were hearing this with fresh ears, the first thing I would wonder is, okay, so if you start working on the minor right after you release the major to deal with issues you know you introduced in the major– why just not ship the major while there are bugs in it? Great question. I&#8217;m glad you asked. So there are a few things worth knowing here.</p>\n\n\n\n<p><strong>[Josepha Haden Chomphosy 00:03:09]&nbsp;</strong></p>\n\n\n\n<p>Firstly, there is this concept of “ship and iterate,” which is present in both agile and open source. The idea is that we ship software as soon as we have confidence that what is in the release is non-breaking and represents our best guests at a better experience for our users.</p>\n\n\n\n<p>Once that is out there, we use feedback on the initial release to quickly iterate and ship another release. That way, we don&#8217;t hold back any good features. And since we already planned the immediate minor, any major issues that show up can be fixed in as little as two weeks. Secondly, there is the concept that with many eyes, all bugs are shallow, which is primarily present in open source.</p>\n\n\n\n<p>The idea here is that with enough people looking at a problem, that problem doesn&#8217;t stand a chance. So when a release is shipped in a workable state but with interactions that could use some refinement, the fastest way to find those refinements is to take it to the community of WordPress users and developers and invite them to co-create this CMS with us.</p>\n\n\n\n<p><strong>[Josepha Haden Chomphosy 00:04:10]</strong></p>\n\n\n\n<p>Which touches on my final thought. The concept of the user as co-creator.</p>\n\n\n\n<p>If we think about the development and evolution of our software as a team effort, then we can think of the people who use our software as what&#8217;s called the “Twelfth Man” That&#8217;s in quotes, and I will, I&#8217;ll leave a link to that in the show notes as well.&nbsp;</p>\n\n\n\n<p>In sports, this refers to the fans. And if you&#8217;ve ever been to a live sporting event or played in any, you will know that the cheering and jeering from fans turns into this distinct motivating entity all its own. As a whole team or individual member, you know what you have to do. You know what you need to do in a game, but there&#8217;s something about that chaotic, loud roar of feedback that just brings life to what you&#8217;re doing, and that&#8217;s how I see our community of users.</p>\n\n\n\n<p><strong>[Josepha Haden Chomphosy 00:05:02]</strong></p>\n\n\n\n<p>So at the end of the day, the answer to the question of ‘why so many releases’ and the follow-up question of ‘why tolerate stable imperfection’ is largely the same. To get features into the hands of our users quickly so that we can always be breathing life into this CMS we care so much about.</p>\n\n\n\n<p>I hope that answers your questions about our release cadence, and if you didn&#8217;t come into this podcast having any questions about release cadences at all, I hope this new information brings a little extra light to the complexity of working in open source.&nbsp;</p>\n\n\n\n<p><strong>[Josepha Haden Chomphosy 00:05:32]&nbsp;</strong></p>\n\n\n\n<p>That brings us now to our small list of big things.</p>\n\n\n\n<p>Big thing number one is that the State of the Word has been announced and is scheduled for December 15th. It&#8217;s a little earlier in the day than in past iterations, so I hope we get a new crew of listeners tuning in at the same time. I&#8217;ll leave a link to that in the show notes, or you can pop over to wordpress.org/news to see the announcement for yourself.</p>\n\n\n\n<p><strong>[Josepha Haden Chomphosy 00:06:00]&nbsp;</strong></p>\n\n\n\n<p>Big thing number two is that team rep nominations are open on most teams right now. So if organization and people wrangling are high on your list of ways you can give back to WordPress, head on over to the team you contribute to and see how you raise your hand for that.&nbsp;</p>\n\n\n\n<p>Then big thing number three is that big-picture goals, hopes, and timelines are being gathered, and I will ship those shortly after the start of the new year.</p>\n\n\n\n<p>It will give us all an idea of where we want to focus our attention to ensure that WordPress continues to grow toward the future. You can keep an eye out for that on make.wordpress.org/project.&nbsp;</p>\n\n\n\n<p>And that, my friends, is your small list of big things. Thanks for tuning in today for the WordPress Briefing. I&#8217;m your host, Josepha Haden Chomphosy, and I&#8217;ll see you again in a couple of weeks.</p>\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:30:\"com-wordpress:feed-additions:1\";a:1:{s:7:\"post-id\";a:1:{i:0;a:5:{s:4:\"data\";s:5:\"13996\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:2;a:6:{s:4:\"data\";s:60:\"\n		\n		\n		\n		\n		\n				\n		\n		\n\n					\n										\n					\n		\n		\n			\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:4:{s:0:\"\";a:6:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:39:\"The Month in WordPress – October 2022\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:71:\"https://wordpress.org/news/2022/11/the-month-in-wordpress-october-2022/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Tue, 22 Nov 2022 11:00:00 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:2:{i:0;a:5:{s:4:\"data\";s:18:\"Month in WordPress\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:1;a:5:{s:4:\"data\";s:18:\"month in wordpress\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:35:\"https://wordpress.org/news/?p=13988\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:224:\"With the end of the year fast approaching, the WordPress project has not slowed down. Read on to learn more about the latest major release, WordPress 6.1, and the State of the Word 2022 live event, among other exciting news.\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:14:\"rmartinezduque\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:13933:\"\n<p>With the end of the year fast approaching, the WordPress project has not slowed down. Read on to learn more about the latest major release, WordPress 6.1, and the State of the Word 2022 live event, among other exciting news. It&#8217;s time to catch up on all things WordPress!</p>\n\n\n\n<hr class=\"wp-block-separator has-css-opacity\" />\n\n\n\n<h2>Say hello to WordPress 6.1 “Misha”</h2>\n\n\n\n<p>The third and last major release of 2022, <a href=\"https://wordpress.org/news/2022/11/misha/\"><strong>WordPress 6.1 “Misha,”</strong></a> shipped on November 1, 2022. Named after jazz pianist <strong>Mikhail “Misha” Alperin</strong>, this release comes packed with many improvements that refine the site-building experience introduced earlier this year in WordPress 5.9 and 6.0, as well as <a href=\"https://make.wordpress.org/core/2022/10/11/wordpress-6-1-accessibility-improvements/\">accessibility</a> and <a href=\"https://make.wordpress.org/core/2022/10/11/performance-field-guide-for-wordpress-6-1/\">performance</a> upgrades.</p>\n\n\n\n<p>WordPress 6.1 is also bundled with a new default block theme, <a href=\"https://wordpress.org/news/2022/11/introducing-twenty-twenty-three/\">Twenty Twenty-Three (TT3)</a>, that features <strong>10 style variations</strong> designed by WordPress community members. These intentionally unique designs ensure that you can change the visual details of your site with ease—and within a single theme.</p>\n\n\n\n<figure class=\"wp-block-embed is-type-video is-provider-youtube wp-block-embed-youtube wp-embed-aspect-16-9 wp-has-aspect-ratio\"><div class=\"wp-block-embed__wrapper\">\n<iframe loading=\"lazy\" class=\"youtube-player\" width=\"600\" height=\"338\" src=\"https://www.youtube.com/embed/1w9oywSa6Hw?version=3&#038;rel=1&#038;showsearch=0&#038;showinfo=1&#038;iv_load_policy=1&#038;fs=1&#038;hl=en-US&#038;autohide=2&#038;wmode=transparent\" allowfullscreen=\"true\" style=\"border:0;\" sandbox=\"allow-scripts allow-same-origin allow-popups allow-presentation\"></iframe>\n</div></figure>\n\n\n\n<p>Learn more about what&#8217;s in 6.1:</p>\n\n\n\n<ul>\n<li><a href=\"https://wordpress.org/news/2022/11/misha/\">WordPress 6.1 “Misha” Announcement</a></li>\n\n\n\n<li><a href=\"https://make.wordpress.org/core/2022/10/12/wordpress-6-1-field-guide/\">WordPress 6.1 Field Guide</a></li>\n</ul>\n\n\n\n<p>Following WordPress 6.1 “Misha”, a <a href=\"https://wordpress.org/news/2022/11/wordpress-6-1-1-maintenance-release/\">6.1.1 maintenance release</a> landed on November 15, 2022. This minor release includes about 50 bug fixes.</p>\n\n\n\n<blockquote class=\"wp-block-quote has-extra-large-font-size\">\n<p><a href=\"https://wordpress.org/download/\">Download WordPress 6.1.1</a></p>\n</blockquote>\n\n\n\n<div style=\"height:10px\" aria-hidden=\"true\" class=\"wp-block-spacer\"></div>\n\n\n\n<h2>State of the Word 2022 is coming on December 15</h2>\n\n\n\n<figure class=\"wp-block-image size-large\"><img decoding=\"async\" loading=\"lazy\" width=\"1024\" height=\"683\" src=\"https://i0.wp.com/wordpress.org/news/files/2022/11/Web-SOTW-Image-1200x800-1.png?resize=1024%2C683&#038;ssl=1\" alt=\"Decorative blue background with text: &quot;State of the Word 2022. December 15, 2022. 1–2:30 P.M. EST (18–19:30 UTC.) New York City.&quot;\" class=\"wp-image-13956\" srcset=\"https://i0.wp.com/wordpress.org/news/files/2022/11/Web-SOTW-Image-1200x800-1.png?resize=1024%2C683&amp;ssl=1 1024w, https://i0.wp.com/wordpress.org/news/files/2022/11/Web-SOTW-Image-1200x800-1.png?resize=300%2C200&amp;ssl=1 300w, https://i0.wp.com/wordpress.org/news/files/2022/11/Web-SOTW-Image-1200x800-1.png?resize=768%2C512&amp;ssl=1 768w, https://i0.wp.com/wordpress.org/news/files/2022/11/Web-SOTW-Image-1200x800-1.png?resize=1536%2C1024&amp;ssl=1 1536w, https://i0.wp.com/wordpress.org/news/files/2022/11/Web-SOTW-Image-1200x800-1.png?resize=2048%2C1365&amp;ssl=1 2048w\" sizes=\"(max-width: 1000px) 100vw, 1000px\" data-recalc-dims=\"1\" /></figure>\n\n\n\n<p><strong>State of the Word 2022</strong>, the annual keynote address delivered by the WordPress project’s co-founder, Matt Mullenweg, will be held on <strong>December 15, 2022</strong>. The event will take place in person in New York City and live-streamed via various WordPress.org social media platforms.</p>\n\n\n\n<p>You can also host or join a <a href=\"https://make.wordpress.org/community/handbook/meetup-organizer/state-of-the-word-watch-parties/\">State of the Word watch party</a> to enjoy the event with your WordPress friends.</p>\n\n\n\n<blockquote class=\"wp-block-quote has-extra-large-font-size\">\n<p><a href=\"https://wordpress.org/news/2022/11/state-of-the-word-2022/\">Learn more about State of the Word 2022</a></p>\n</blockquote>\n\n\n\n<div style=\"height:10px\" aria-hidden=\"true\" class=\"wp-block-spacer\"></div>\n\n\n\n<h2>What’s new in Gutenberg</h2>\n\n\n\n<p>Two new versions of Gutenberg have shipped in the last month:</p>\n\n\n\n<ul>\n<li><a href=\"https://make.wordpress.org/core/2022/10/27/whats-new-in-gutenberg-14-4-26-october/\"><strong>Gutenberg 14.4</strong></a> was released on October 26, 2022, with support for a distraction-free mode that allows a more focused writing experience. Other notable highlights include a redesigned pattern inserter, content locking to the Navigation block, and improvements to fluid typography.</li>\n\n\n\n<li><a href=\"https://make.wordpress.org/core/2022/11/09/whats-new-in-gutenberg-14-5-9-november/\"><strong>Gutenberg 14.5</strong></a> sets the groundwork for future releases with code quality improvements and bug fixes. This version introduces a new “Document Overview” panel for easier access to the list view and document information, expands margin and padding support, and improves spacing visualizers. It was released on November 9, 2022.</li>\n</ul>\n\n\n\n<blockquote class=\"wp-block-quote has-extra-large-font-size\">\n<p>Explore some of the latest enhancements to the writing experience in <a href=\"https://make.wordpress.org/core/2022/10/28/core-editor-improvement-advancing-the-writing-experience/\">this Core Editor Improvement post</a>.</p>\n</blockquote>\n\n\n\n<div style=\"height:10px\" aria-hidden=\"true\" class=\"wp-block-spacer\"></div>\n\n\n\n<h2>Team updates: Documentation Contributor Day, WordPress.org redesign updates, and more</h2>\n\n\n\n<ul>\n<li>After a <a href=\"https://make.wordpress.org/core/2022/07/27/giving-fse-a-more-user-friendly-name/\">lively discussion</a> around the site editing terminology, WordPress Executive Director Josepha Haden Chomphosy <a href=\"https://make.wordpress.org/updates/2022/11/04/site-editor-a-more-user-friendly-name/\">announced that the term &#8220;Site Editor&#8221; will be used going forward</a> in reference to the suite of site editing tools.</li>\n\n\n\n<li>Last month, the Docs Team successfully held its <a href=\"https://make.wordpress.org/docs/2022/10/28/the-documentation-team-contributor-day-summary/\">first online Contributor Day</a> to collaborate in real-time, help onboard new contributors, and work on backlog tasks.</li>\n\n\n\n<li>Progress and next steps for the WordPress.org website redesign were shared <a href=\"https://make.wordpress.org/meta/2022/10/21/wordpress-org-redesign-update/\">in this post</a>. The following pages that will get a refreshed look and feel soon include <a href=\"https://make.wordpress.org/design/2022/11/11/a-refresh-of-wordpress-org-showcase/\">Showcase</a> and <a href=\"https://make.wordpress.org/docs/2022/10/19/new-design-for-helphub-in-wordpress-org/\">Documentation (HelpHub)</a>.</li>\n\n\n\n<li>The WordPress.org Theme Directory <a href=\"https://make.wordpress.org/meta/2022/10/20/displaying-style-variations-for-supporting-themes/\">introduced a new feature</a> that allows visitors to preview style variations in block themes.</li>\n\n\n\n<li>Inspired by the Community Team’s efforts to reactivate meetup groups, the Polyglots Team is looking to start a <a href=\"https://make.wordpress.org/polyglots/2022/11/08/starting-a-polyglots-outreach-effort/\">Polyglots outreach project</a> and welcomes help.</li>\n\n\n\n<li>The Training Team shared an <a href=\"https://make.wordpress.org/training/2022/11/01/summary-update-courses-currently-in-development-1-november-2022/\">overview of some of the new Learn WordPress courses</a> they have been recently working on.</li>\n\n\n\n<li>Openverse’s catalog now includes <a href=\"https://make.wordpress.org/openverse/2022/11/16/openverse-now-includes-over-1-million-audio-records/\">more than one million audio records</a>!</li>\n\n\n\n<li>The WordPress Photo Directory also reached a significant milestone by surpassing 5,000 photos! <a href=\"https://make.wordpress.org/photos/2022/11/17/the-road-to-5000-photos-a-retrospective/\">Check out this celebratory retrospective from the Photos team</a>.</li>\n\n\n\n<li>Speaking of Openverse and the Photo Directory, <a href=\"https://wordpress.org/news/2022/11/episode-43-openverse-photo-directory-what-are-they-and-how-are-they-different/\">don’t miss the latest episode of the WP Briefing podcast</a>—it covers the differences between these two resources, and how they work to further openly-licensed media.</li>\n\n\n\n<li>The latest edition of People of WordPress features <a href=\"https://wordpress.org/news/2022/10/people-of-wordpress-raghavendra-satish-peri/\">Raghavendra Satish Peri</a>.</li>\n</ul>\n\n\n\n<blockquote class=\"wp-block-quote has-extra-large-font-size\">\n<p>Enjoy a spooky Halloween Mad Libs story completed by community contributors in <a href=\"https://wordpress.org/news/2022/10/episode-42-something-spooky-this-way-comes/\">Episode 42 of WP Briefing</a>.</p>\n</blockquote>\n\n\n\n<div style=\"height:10px\" aria-hidden=\"true\" class=\"wp-block-spacer\"></div>\n\n\n\n<h2>Feedback &amp; testing requests</h2>\n\n\n\n<ul>\n<li>The <a href=\"https://make.wordpress.org/core/2022/10/12/call-for-testing-plugin-dependencies/\">Plugin Dependencies feature plugin is available for testing</a>. Provide your feedback by December 1, 2022.</li>\n\n\n\n<li>What does a genuinely sustainable WordPress community look like to you? Share your vision and thoughts in <a href=\"https://make.wordpress.org/project/2022/11/01/sustainability-channel-what-should-we-do/\">this discussion post</a>.</li>\n\n\n\n<li>The new WordPress developer blog is in public beta and <a href=\"https://make.wordpress.org/core/2022/11/21/wordpress-developer-blog-is-in-public-beta/\">ready for feedback</a>.</li>\n\n\n\n<li>The Core Team requests assistance with <a href=\"https://make.wordpress.org/hosting/2022/10/19/call-for-action-testing-rollback-feature/\">testing a new Rollback Feature in WordPress core</a>.</li>\n\n\n\n<li>Version 21.2 of the WordPress mobile app for <a href=\"https://make.wordpress.org/mobile/2022/11/15/call-for-testing-wordpress-for-android-21-2/\">Android</a> and <a href=\"https://make.wordpress.org/mobile/2022/11/14/call-for-testing-wordpress-for-ios-21-2/\">iOS</a> is available for testing.</li>\n</ul>\n\n\n\n<blockquote class=\"wp-block-quote has-extra-large-font-size\">\n<p>Were you involved in WordPress 6.1? <a href=\"https://make.wordpress.org/core/2022/11/09/wordpress-6-1-misha-retrospective/\">Share your thoughts</a> on the release process by December 15, 2022.</p>\n</blockquote>\n\n\n\n<div style=\"height:10px\" aria-hidden=\"true\" class=\"wp-block-spacer\"></div>\n\n\n\n<h2>Event updates &amp; WordCamps</h2>\n\n\n\n<ul>\n<li>The WordCamp Asia organizing team is collaborating with WordCamp Central to bring the <a href=\"https://asia.wordcamp.org/2023/apply-for-wordcamp-asia-diversity-scholarship/\">WordCamp Asia Diversity Scholarship</a>. In addition, the team recently announced the <a href=\"https://asia.wordcamp.org/2023/speakers-announcement-round-1/\">first round of speakers</a>.</li>\n\n\n\n<li>Preparations for <a href=\"https://europe.wordcamp.org/2023/the-preparations-for-wordcamp-europe-2023-have-begun/\">WordCamp Europe 2023</a> are underway.</li>\n\n\n\n<li>Don’t miss these upcoming WordCamps:\n<ul>\n<li><img src=\"https://s.w.org/images/core/emoji/14.0.0/72x72/1f1e7-1f1f7.png\" alt=\"🇧🇷\" class=\"wp-smiley\" style=\"height: 1em; max-height: 1em;\" /> <a href=\"https://saopaulo.wordcamp.org/2022/\">WordCamp São Paulo</a>, Brazil on November 26, 2022</li>\n\n\n\n<li><img src=\"https://s.w.org/images/core/emoji/14.0.0/72x72/1f1ee-1f1f3.png\" alt=\"🇮🇳\" class=\"wp-smiley\" style=\"height: 1em; max-height: 1em;\" /> <a href=\"https://kolkata.wordcamp.org/2022/\">WordCamp Kolkata</a>, West Bengal, India on December 17-18, 2022</li>\n</ul>\n</li>\n</ul>\n\n\n\n<blockquote class=\"wp-block-quote has-extra-large-font-size\">\n<p>Boost your speaking confidence in WordPress events. Register for the <a href=\"https://www.eventbrite.com/e/how-to-own-your-expertise-start-speaking-at-wordpress-events-wpdiversity-tickets-462153532657\">How to Own Your Expertise &amp; Start Speaking at WordPress Events</a> online workshop happening December 7, 2022.</p>\n</blockquote>\n\n\n\n<div style=\"height:10px\" aria-hidden=\"true\" class=\"wp-block-spacer\"></div>\n\n\n\n<hr class=\"wp-block-separator has-css-opacity\" />\n\n\n\n<p><strong><em><strong><em><strong><em>Have a story that we should include in the next issue of The Month in WordPress? <strong><em>Fill out </em></strong><a href=\"https://make.wordpress.org/community/month-in-wordpress-submissions/\"><strong><em>this quick form</em></strong></a><strong><em> to let us know.</em></strong></em></strong></em></strong></em></strong></p>\n\n\n\n<p><em><em>The following folks contributed to this edition of The Month in WordPress:</em> <a href=\'https://profiles.wordpress.org/rmartinezduque/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>rmartinezduque</a>, <a href=\'https://profiles.wordpress.org/webcommsat/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>webcommsat</a>, <a href=\'https://profiles.wordpress.org/santanainniss/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>santanainniss</a>, <a href=\'https://profiles.wordpress.org/dansoschin/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>dansoschin</a>, <a href=\'https://profiles.wordpress.org/eidolonnight/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>eidolonnight</a>.</em></p>\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:30:\"com-wordpress:feed-additions:1\";a:1:{s:7:\"post-id\";a:1:{i:0;a:5:{s:4:\"data\";s:5:\"13988\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:3;a:6:{s:4:\"data\";s:63:\"\n		\n		\n		\n		\n		\n				\n		\n		\n		\n\n					\n										\n					\n		\n		\n			\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:4:{s:0:\"\";a:6:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:22:\"State of the Word 2022\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:58:\"https://wordpress.org/news/2022/11/state-of-the-word-2022/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Mon, 21 Nov 2022 17:14:43 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:3:{i:0;a:5:{s:4:\"data\";s:6:\"Events\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:1;a:5:{s:4:\"data\";s:4:\"sotw\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:2;a:5:{s:4:\"data\";s:17:\"state of the word\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:35:\"https://wordpress.org/news/?p=13971\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:223:\"Join the WordPress project leaders for State of the Word 2022 in New York City on December 15, 2022. Also live-streamed on social media, you will hear about the WordPress project, open source, and more in this annual event.\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:7:\"Josepha\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:9853:\"\n<figure class=\"wp-block-image size-large\"><img decoding=\"async\" loading=\"lazy\" width=\"1024\" height=\"683\" src=\"https://i0.wp.com/wordpress.org/news/files/2022/11/Web-SOTW-Image-1200x800-1.png?resize=1024%2C683&#038;ssl=1\" alt=\"Decorative blue background with text: &quot;State of the Word 2022. December 15, 2022. 1–2:30 P.M. EST (18–19:30 UTC.) New York City.&quot;\" class=\"wp-image-13956\" srcset=\"https://i0.wp.com/wordpress.org/news/files/2022/11/Web-SOTW-Image-1200x800-1.png?resize=1024%2C683&amp;ssl=1 1024w, https://i0.wp.com/wordpress.org/news/files/2022/11/Web-SOTW-Image-1200x800-1.png?resize=300%2C200&amp;ssl=1 300w, https://i0.wp.com/wordpress.org/news/files/2022/11/Web-SOTW-Image-1200x800-1.png?resize=768%2C512&amp;ssl=1 768w, https://i0.wp.com/wordpress.org/news/files/2022/11/Web-SOTW-Image-1200x800-1.png?resize=1536%2C1024&amp;ssl=1 1536w, https://i0.wp.com/wordpress.org/news/files/2022/11/Web-SOTW-Image-1200x800-1.png?resize=2048%2C1365&amp;ssl=1 2048w\" sizes=\"(max-width: 1000px) 100vw, 1000px\" data-recalc-dims=\"1\" /></figure>\n\n\n\n<p>Hello, WordPress!&nbsp;</p>\n\n\n\n<p><a href=\"https://calendar.google.com/calendar/u/0/r/eventedit?text=State+of+the+Word+2022&amp;dates=20221215T180000Z/20221215T193000Z&amp;details=State+of+the+Word+is+the+annual+keynote+address+delivered+by+the+WordPress+project%E2%80%99s+co-founder%2C+Matt+Mullenweg.+Every+year%2C+the+event+shares+reflections+on+the+project%E2%80%99s+progress+and+the+future+of+open+source.+Expect+this+and+more+in+this+year%E2%80%99s+edition.%0A%0AState+of+the+Word+will+be+live+streamed+from+New+York+City,+and+is+free+for+all+to+watch.%0A%0Ahttps://wordpress.org/news/2022/11/state-of-the-word-2022/\" target=\"_blank\" rel=\"noreferrer noopener\">Mark your calendars</a>; it’s almost time for State of the Word 2022!</p>\n\n\n\n<p>State of the Word is the annual keynote address delivered by the WordPress project’s co-founder, <a href=\"https://ma.tt\">Matt Mullenweg</a>. Every year, the event shares reflections on the project’s progress and the future of open source. Expect this and more in this year’s edition.</p>\n\n\n\n<p>This year’s event will take place in person in New York City and live-streamed via various WordPress.org social media platforms.&nbsp;</p>\n\n\n\n<p>Join Matt as he provides a retrospective of 2022, the latest WordPress releases, Site Editor advancements, and a return to in-person events around the globe, among other topics.</p>\n\n\n\n<p><strong>What:</strong> State of the Word 2022</p>\n\n\n\n<p><strong>When:</strong> <a href=\"https://calendar.google.com/calendar/u/0/r/eventedit?text=State+of+the+Word+2022&amp;dates=20221215T180000Z/20221215T193000Z&amp;details=State+of+the+Word+is+the+annual+keynote+address+delivered+by+the+WordPress+project%E2%80%99s+co-founder%2C+Matt+Mullenweg.+Every+year%2C+the+event+shares+reflections+on+the+project%E2%80%99s+progress+and+the+future+of+open+source.+Expect+this+and+more+in+this+year%E2%80%99s+edition.%0A%0AState+of+the+Word+will+be+live+streamed+from+New+York+City,+and+is+free+for+all+to+watch.%0A%0Ahttps://wordpress.org/news/2022/11/state-of-the-word-2022/\" target=\"_blank\" rel=\"noreferrer noopener\">December 15, 2022, 1–2:30 P.M. EST (18–19:30 UTC)</a></p>\n\n\n\n<p><strong>How:</strong> If you’re watching from the comfort of your home or <a href=\"https://make.wordpress.org/community/handbook/meetup-organizer/state-of-the-word-watch-parties/\">local watch party</a>, the live stream will be embedded in this post and available through the <a href=\"https://youtube.com/wordpress\">WordPress YouTube channel</a>.</p>\n\n\n\n<p>Would you like to join the in-person audience? <a href=\"https://wordcampcentral.survey.fm/request-a-seat-sotw-2022\">Request a seat by completing this survey</a>.</p>\n\n\n\n<h2>Have a question for Matt?</h2>\n\n\n\n<p>State of the Word will include a Q&amp;A session. If you want to participate, you can either send your question ahead of time to <strong>ask-matt@wordcamp.org</strong> or ask during the event in the live stream chat on YouTube.</p>\n\n\n\n<p>Given the volume of questions that are usually submitted, please note that it may not be possible to answer all of them in the live Q&amp;A. A follow-up post will be published after the State of the Word to answer those not covered at the event.</p>\n\n\n\n<p>First time attending State of the Word? Check out <a href=\"https://wordpress.tv/tag/state-of-the-word/\">previous years&#8217; recordings on</a> <a href=\"https://wordpress.tv/tag/state-of-the-word/\">WordPress.tv</a> to get a sense of the event.</p>\n\n\n\n<p>See you in person or online on December 15!</p>\n\n\n\n<hr class=\"wp-block-separator has-alpha-channel-opacity is-style-default\" />\n\n\n\n<h2 id=\"join-a-state-of-the-word-watch-party-near-you\">Join a State of the Word Watch Party near You</h2>\n\n\n\n<p>Can’t make it to New York? No problem, organize or join a watch party in your community in person or online. Like last year, the Community team has resources available to help! Check out <a href=\"https://make.wordpress.org/community/handbook/meetup-organizer/state-of-the-word-watch-parties/\">this handbook page</a>, which includes event templates, information on requesting a Zoom account, and how to get some swag.</p>\n\n\n\n<p>Gather together to look back on how WordPress has grown in 2022 and what is ahead for 2023. Stay up-to-date as a group on the latest happenings in the WordPress world and collaborate together on any questions you might have for Matt!</p>\n\n\n\n<p>Below you can find a list of State of the Word watch parties that will be updated regularly as the event approaches. If you don’t see a watch party in your region, <a href=\"https://meetup.com/pro/wordpress\">check this page on Meetup.com</a> to see if your local WordPress group is organizing one.</p>\n\n\n\n<ul>\n<li><img src=\"https://s.w.org/images/core/emoji/14.0.0/72x72/1f1fa-1f1f8.png\" alt=\"🇺🇸\" class=\"wp-smiley\" style=\"height: 1em; max-height: 1em;\" /> <a href=\"https://www.meetup.com/SeattleWordPressMeetup\">Seattle WordPress Meetup</a> &#8211; <a href=\"https://www.meetup.com/SeattleWordPressMeetup/events/282840880/\">WordPress Developer Meetup: State of the Word/General Discussion</a></li>\n\n\n\n<li><img src=\"https://s.w.org/images/core/emoji/14.0.0/72x72/1f1ed-1f1f9.png\" alt=\"🇭🇹\" class=\"wp-smiley\" style=\"height: 1em; max-height: 1em;\" /> <a href=\"https://www.meetup.com/Port-au-Prince-WordPress-Meetup\">Port-au-Prince WordPress Meetup Group</a> &#8211; <a href=\"https://www.meetup.com/Port-au-Prince-WordPress-Meetup/events/289909938/\">State of the Word Watch Party (Online)</a></li>\n\n\n\n<li><img src=\"https://s.w.org/images/core/emoji/14.0.0/72x72/1f1e8-1f1ed.png\" alt=\"🇨🇭\" class=\"wp-smiley\" style=\"height: 1em; max-height: 1em;\" /> <a href=\"https://www.meetup.com/geneva-wordpress\">WordPress Meetups Genève (Geneva)</a> &#8211; <a href=\"https://www.meetup.com/geneva-wordpress/events/289943099/\">State of the Word &#8220;Watch Party&#8221; et plus/and more (FR/EN) WordPress</a></li>\n\n\n\n<li><img src=\"https://s.w.org/images/core/emoji/14.0.0/72x72/1f1ee-1f1f9.png\" alt=\"🇮🇹\" class=\"wp-smiley\" style=\"height: 1em; max-height: 1em;\" /> <a href=\"https://www.meetup.com/meetup-wordpress-ancona\">WordPress Ancona Meetup</a> &#8211; <a href=\"https://www.meetup.com/meetup-wordpress-ancona/events/289968378/\">State of the Word Watch Party + Auguri di Natale + Proposte 2023</a></li>\n\n\n\n<li><img src=\"https://s.w.org/images/core/emoji/14.0.0/72x72/1f1e7-1f1ec.png\" alt=\"🇧🇬\" class=\"wp-smiley\" style=\"height: 1em; max-height: 1em;\" /> <a href=\"https://www.meetup.com/WordPress-Sofia-Meetup\">WordPress Sofia Meetup</a> &#8211; <a href=\"https://www.meetup.com/WordPress-Sofia-Meetup/events/289915099/\">&#8220;State of the Word 2022&#8221; watch party!</a></li>\n\n\n\n<li><img src=\"https://s.w.org/images/core/emoji/14.0.0/72x72/1f1ea-1f1f8.png\" alt=\"🇪🇸\" class=\"wp-smiley\" style=\"height: 1em; max-height: 1em;\" /> <a href=\"https://www.meetup.com/Granada-WordPress-Meetup\">Granada WordPress Meetup</a> &#8211; <a href=\"https://www.meetup.com/Granada-WordPress-Meetup/events/290016526/\">¡Veamos el State of the Word 2022!</a></li>\n\n\n\n<li><img src=\"https://s.w.org/images/core/emoji/14.0.0/72x72/1f1ee-1f1f3.png\" alt=\"🇮🇳\" class=\"wp-smiley\" style=\"height: 1em; max-height: 1em;\" /> <a href=\"https://www.meetup.com/Kochi-WordPress-Meetup\">Kochi WordPress Meetup</a> &#8211; <a href=\"https://www.meetup.com/Kochi-WordPress-Meetup/events/289893144/\">State of the Word Watch Party (In-person)</a></li>\n\n\n\n<li><img src=\"https://s.w.org/images/core/emoji/14.0.0/72x72/1f1ee-1f1e9.png\" alt=\"🇮🇩\" class=\"wp-smiley\" style=\"height: 1em; max-height: 1em;\" /> <a href=\"https://www.meetup.com/tegal-wordpress-meetup\">WordPress Meetup Tegal</a> &#8211; <a href=\"https://www.meetup.com/tegal-wordpress-meetup/events/290031767/\">Nonton bareng &#8220;State of the Word 2022&#8221;</a></li>\n\n\n\n<li><img src=\"https://s.w.org/images/core/emoji/14.0.0/72x72/1f1ef-1f1f5.png\" alt=\"🇯🇵\" class=\"wp-smiley\" style=\"height: 1em; max-height: 1em;\" /> <a href=\"https://www.meetup.com/Tokyo-WordPress-Meetup\">Tokyo WordPress Meetup</a> &#8211; <a href=\"https://www.meetup.com/Tokyo-WordPress-Meetup/events/289965452/\">State of the Word から来年の WordPress を考えよう！+ 忘年会</a></li>\n\n\n\n<li><img src=\"https://s.w.org/images/core/emoji/14.0.0/72x72/1f1fa-1f1f8.png\" alt=\"🇺🇸\" class=\"wp-smiley\" style=\"height: 1em; max-height: 1em;\" /> <a href=\"https://www.meetup.com/wpgrandrapids\">WPGR &#8211; Grand Rapids WordPress Meetup</a> &#8211; <a href=\"https://www.meetup.com/wpgrandrapids/events/290039217/\">State of the Word Watch Party (In-person)</a></li>\n</ul>\n\n\n\n<p>If you are planning a watch party for State of the Word and have questions, please email support@wordcamp.org. A member of the WordPress community team will assist you in the best way possible.</p>\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:30:\"com-wordpress:feed-additions:1\";a:1:{s:7:\"post-id\";a:1:{i:0;a:5:{s:4:\"data\";s:5:\"13971\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:4;a:6:{s:4:\"data\";s:69:\"\n		\n		\n		\n		\n		\n				\n		\n		\n		\n		\n		\n\n					\n										\n					\n		\n		\n			\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:4:{s:0:\"\";a:6:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:35:\"WordPress 6.1.1 Maintenance Release\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:71:\"https://wordpress.org/news/2022/11/wordpress-6-1-1-maintenance-release/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Tue, 15 Nov 2022 19:51:45 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:5:{i:0;a:5:{s:4:\"data\";s:8:\"Releases\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:1;a:5:{s:4:\"data\";s:3:\"6.1\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:2;a:5:{s:4:\"data\";s:5:\"6.1.1\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:3;a:5:{s:4:\"data\";s:14:\"minor-releases\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:4;a:5:{s:4:\"data\";s:8:\"releases\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:35:\"https://wordpress.org/news/?p=13918\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:244:\"WordPress 6.1.1 is now available for download. This maintenance release features several updates since the release of WordPress 6.1 on 01 November 2022. You can review a summary of the key changes in this release by visiting WordPress.org/news.\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:12:\"Jeffrey Paul\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:9850:\"\n<h2>WordPress 6.1.1 is now available</h2>\n\n\n\n<p>This minor release features <a href=\"https://core.trac.wordpress.org/query?milestone=6.1.1&amp;group=component&amp;col=id&amp;col=summary&amp;col=status&amp;col=owner&amp;col=type&amp;col=priority&amp;col=milestone&amp;order=priority\">29 bug fixes in Core</a> and <a href=\"https://github.com/WordPress/gutenberg/compare/ca07aa8354a1131dbabcc36dfcaf70e0c0891f54...6566f5fe9ece6ad5ae550349d3b1f0944a011040\">21 bug fixes</a> for the block editor. WordPress 6.1.1 is a short-cycle maintenance release. You can review a summary of the key updates in this release by reading the <a href=\"https://make.wordpress.org/core/2022/11/11/wordpress-6-1-1-rc1-is-now-available/\">RC1 announcement</a>.</p>\n\n\n\n<p>The next major release will be <a href=\"https://make.wordpress.org/core/6-2/\">version 6.2</a> planned for 2023.</p>\n\n\n\n<p>If you have sites that support automatic background updates, the update process will begin automatically.</p>\n\n\n\n<p>You can <a href=\"https://wordpress.org/wordpress-6.1.1.zip\">download WordPress 6.1.1 from WordPress.org</a>, or visit your WordPress Dashboard, click “Updates”, and then click “Update Now”.</p>\n\n\n\n<p>For more information, check out the <a href=\"https://wordpress.org/support/wordpress-version/version-6-1-1/\">version 6.1.1 HelpHub documentation page</a>.</p>\n\n\n\n<h2>Thank you to these WordPress contributors</h2>\n\n\n\n<p>The WordPress 6.1.1 release was led by <a href=\"https://profiles.wordpress.org/desrosj/\">Jonathan Desrosiers</a>, <a href=\"https://profiles.wordpress.org/mamaduka/\">George Mamadashvili</a>, and <a href=\"https://profiles.wordpress.org/jeffpaul/\">Jeffrey Paul</a>.</p>\n\n\n\n<p>WordPress 6.1.1 would not have been possible without the contributions of more than 105 people. Their asynchronous coordination to deliver several enhancements and fixes into a stable release is a testament to the power and capability of the WordPress community.</p>\n\n\n\n<p><a href=\"https://profiles.wordpress.org/10upsimon/\">10upsimon</a>, <a href=\"https://profiles.wordpress.org/jorbin/\">Aaron Jorbin</a>, <a href=\"https://profiles.wordpress.org/aaronrobertshaw/\">Aaron Robertshaw</a>, <a href=\"https://profiles.wordpress.org/adamsilverstein/\">Adam Silverstein</a>, <a href=\"https://profiles.wordpress.org/wildworks/\">Aki Hamano</a>, <a href=\"https://profiles.wordpress.org/alexstine/\">alexstine</a>, <a href=\"https://profiles.wordpress.org/andraganescu/\">Andrei Draganescu</a>, <a href=\"https://profiles.wordpress.org/azaozz/\">Andrew Ozz</a>, <a href=\"https://profiles.wordpress.org/andrewserong/\">Andrew Serong</a>, <a href=\"https://profiles.wordpress.org/oandregal/\">Andre</a>, <a href=\"https://profiles.wordpress.org/afragen/\">Andy Fragen</a>, <a href=\"https://profiles.wordpress.org/aristath/\">Ari Stathopoulos</a>, <a href=\"https://profiles.wordpress.org/azurseisme/\">azurseisme</a>, <a href=\"https://profiles.wordpress.org/scruffian/\">Ben Dwyer</a>, <a href=\"https://profiles.wordpress.org/bernhard-reiter/\">Bernie Reiter</a>, <a href=\"https://profiles.wordpress.org/mxbclang/\">Bethany Chobanian Lang</a>, <a href=\"https://profiles.wordpress.org/bph/\">Birgit Pauli-Haack</a>, <a href=\"https://profiles.wordpress.org/bjorn2404/\">bjorn2404</a>, <a href=\"https://profiles.wordpress.org/cbravobernal/\">Carlos Bravo</a>, <a href=\"https://profiles.wordpress.org/poena/\">Carolina Nymark</a>, <a href=\"https://profiles.wordpress.org/claytoncollie/\">Clayton Collie</a>, <a href=\"https://profiles.wordpress.org/codesdnc/\">codesdnc</a>, <a href=\"https://profiles.wordpress.org/costdev/\">Colin Stewart</a>, <a href=\"https://profiles.wordpress.org/talldanwp/\">Daniel Richards</a>, <a href=\"https://profiles.wordpress.org/davidbaumwald/\">David Baumwald</a>, <a href=\"https://profiles.wordpress.org/get_dave/\">David Smith</a>, <a href=\"https://profiles.wordpress.org/davidvongries/\">David Vongries</a>, <a href=\"https://profiles.wordpress.org/dilipbheda/\">Dilip Bheda</a>, <a href=\"https://profiles.wordpress.org/dd32/\">Dion Hulse</a>, <a href=\"https://profiles.wordpress.org/ocean90/\">Dominik Schilling</a>, <a href=\"https://profiles.wordpress.org/ellatrix/\">Ella</a>, <a href=\"https://profiles.wordpress.org/manuilov/\">Eugene M</a>, <a href=\"https://profiles.wordpress.org/flixos90/\">Felix Arntz</a>, <a href=\"https://profiles.wordpress.org/fpodhorsky/\">fpodhorsky</a>, <a href=\"https://profiles.wordpress.org/franz00/\">franzaurus</a>, <a href=\"https://profiles.wordpress.org/gamecreature/\">gamecreature</a>, <a href=\"https://profiles.wordpress.org/pento/\">Gary Pendergast</a>, <a href=\"https://profiles.wordpress.org/mamaduka/\">George Mamadashvili</a>, <a href=\"https://profiles.wordpress.org/gisgeo/\">gisgeo</a>, <a href=\"https://profiles.wordpress.org/glendaviesnz/\">glendaviesnz</a>, <a href=\"https://profiles.wordpress.org/innovext/\">Innovext</a>, <a href=\"https://profiles.wordpress.org/ironprogrammer/\">ironprogrammer</a>, <a href=\"https://profiles.wordpress.org/isabel_brison/\">Isabel Brison</a>, <a href=\"https://profiles.wordpress.org/outrankjames/\">James</a>, <a href=\"https://profiles.wordpress.org/janthiel/\">Jan Thiel</a>, <a href=\"https://profiles.wordpress.org/carazo/\">Javier Carazo</a>, <a href=\"https://profiles.wordpress.org/audrasjb/\">Jb Audras</a>, <a href=\"https://profiles.wordpress.org/jchambo/\">jchambo</a>, <a href=\"https://profiles.wordpress.org/jeffpaul/\">jeffpaul</a>, <a href=\"https://profiles.wordpress.org/joelmadigan/\">joelmadigan</a>, <a href=\"https://profiles.wordpress.org/joen/\">Joen A.</a>, <a href=\"https://profiles.wordpress.org/johnbillion/\">John Blackbourn</a>, <a href=\"https://profiles.wordpress.org/johnwatkins0/\">John Watkins</a>, <a href=\"https://profiles.wordpress.org/desrosj/\">Jonathan Desrosiers</a>, <a href=\"https://profiles.wordpress.org/spacedmonkey/\">Jonny Harris</a>, <a href=\"https://profiles.wordpress.org/jsh4/\">jsh4</a>, <a href=\"https://profiles.wordpress.org/jrf/\">Juliette Reinders Folmer</a>, <a href=\"https://profiles.wordpress.org/kadamwhite/\">K. Adam White</a>, <a href=\"https://profiles.wordpress.org/kacper3355/\">kacper3355</a>, <a href=\"https://profiles.wordpress.org/kevin940726/\">Kai Hao</a>, <a href=\"https://profiles.wordpress.org/obenland/\">Konstantin Obenland</a>, <a href=\"https://profiles.wordpress.org/konyoldeath/\">konyoldeath</a>, <a href=\"https://profiles.wordpress.org/larsmqller/\">larsmqller</a>, <a href=\"https://profiles.wordpress.org/0mirka00/\">Lena Morita</a>, <a href=\"https://profiles.wordpress.org/leonidasmilossis/\">Leo Milo</a>, <a href=\"https://profiles.wordpress.org/lozula/\">lozula</a>, <a href=\"https://profiles.wordpress.org/mciampini/\">Marco Ciampini</a>, <a href=\"https://profiles.wordpress.org/tyxla/\">Marin Atanasov</a>, <a href=\"https://profiles.wordpress.org/clorith/\">Marius L. J.</a>, <a href=\"https://profiles.wordpress.org/mattkeys/\">Matt Keys</a>, <a href=\"https://profiles.wordpress.org/czapla/\">Michal Czaplinski</a>, <a href=\"https://profiles.wordpress.org/miguelaxcar/\">Miguel Axcar</a>, <a href=\"https://profiles.wordpress.org/mcsf/\">Miguel Fonseca</a>, <a href=\"https://profiles.wordpress.org/mukesh27/\">Mukesh Panchal</a>, <a href=\"https://profiles.wordpress.org/mw108/\">mw108</a>, <a href=\"https://profiles.wordpress.org/namithjawahar/\">Namith Jawahar</a>, <a href=\"https://profiles.wordpress.org/ndiego/\">Nick Diego</a>, <a href=\"https://profiles.wordpress.org/ntsekouras/\">Nik Tsekouras</a>, <a href=\"https://profiles.wordpress.org/nithins53/\">Nithin SreeRaj</a>, <a href=\"https://profiles.wordpress.org/nuvopoint/\">nuvoPoint</a>, <a href=\"https://profiles.wordpress.org/oakesjosh/\">oakesjosh</a>, <a href=\"https://profiles.wordpress.org/ockham/\">ockham</a>, <a href=\"https://profiles.wordpress.org/webmandesign/\">Oliver Juhas</a>, <a href=\"https://profiles.wordpress.org/swissspidy/\">Pascal Birchler</a>, <a href=\"https://profiles.wordpress.org/pbiron/\">Paul Biron</a>, <a href=\"https://profiles.wordpress.org/peterwilsoncc/\">Peter Wilson</a>, <a href=\"https://profiles.wordpress.org/petitphp/\">petitphp</a>, <a href=\"https://profiles.wordpress.org/pkolenbr/\">pkolenbr</a>, <a href=\"https://profiles.wordpress.org/pypwalters/\">pypwalters</a>, <a href=\"https://profiles.wordpress.org/ramonopoly/\">ramonopoly</a>, <a href=\"https://profiles.wordpress.org/youknowriad/\">Riad Benguella</a>, <a href=\"https://profiles.wordpress.org/rjasdfiii/\">rjasdfiii</a>, <a href=\"https://profiles.wordpress.org/noisysocks/\">Robert Anderson</a>, <a href=\"https://profiles.wordpress.org/rodricus/\">rodricus</a>, <a href=\"https://profiles.wordpress.org/ryankienstra/\">Ryan Kienstra</a>, <a href=\"https://profiles.wordpress.org/mikachan/\">Sarah Norris</a>, <a href=\"https://profiles.wordpress.org/sergeybiryukov/\">Sergey Biryukov</a>, <a href=\"https://profiles.wordpress.org/stentibbing/\">stentibbing</a>, <a href=\"https://profiles.wordpress.org/sabernhardt/\">Stephen Bernhardt</a>, <a href=\"https://profiles.wordpress.org/subrataemfluence/\">Subrata Sarkar</a>, <a href=\"https://profiles.wordpress.org/cybr/\">Sybre Waaijer</a>, <a href=\"https://profiles.wordpress.org/sippis/\">Timi Wahalahti</a>, <a href=\"https://profiles.wordpress.org/timothyblynjacobs/\">Timothy Jacobs</a>, <a href=\"https://profiles.wordpress.org/hellofromtonya/\">Tonya Mork</a>, <a href=\"https://profiles.wordpress.org/zodiac1978/\">Torsten Landsiedel</a>, and <a href=\"https://profiles.wordpress.org/vtad/\">vtad</a>.</p>\n\n\n\n<h2>How to contribute</h2>\n\n\n\n<p>To get involved in WordPress core development, head over to Trac, <a href=\"https://core.trac.wordpress.org/report/6\">pick a ticket</a>, and join the conversation in the <a href=\"https://wordpress.slack.com/archives/C02RQBWTW\">#core</a> and <a href=\"https://wordpress.slack.com/archives/C03LZ88NX6G\">#6-1-release-leads channels</a>. Need help? Check out the <a href=\"https://make.wordpress.org/core/handbook/\">Core Contributor Handbook</a>.</p>\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:30:\"com-wordpress:feed-additions:1\";a:1:{s:7:\"post-id\";a:1:{i:0;a:5:{s:4:\"data\";s:5:\"13918\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:5;a:6:{s:4:\"data\";s:61:\"\n		\n		\n		\n		\n		\n				\n		\n		\n\n					\n										\n					\n		\n		\n\n			\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:4:{s:0:\"\";a:7:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:102:\"WP Briefing: Episode 43: Openverse &amp; Photo Directory– What Are They, and How Are They Different?\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:113:\"https://wordpress.org/news/2022/11/episode-43-openverse-photo-directory-what-are-they-and-how-are-they-different/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Mon, 14 Nov 2022 12:00:00 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:2:{i:0;a:5:{s:4:\"data\";s:7:\"Podcast\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:1;a:5:{s:4:\"data\";s:11:\"wp-briefing\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:53:\"https://wordpress.org/news/?post_type=podcast&p=13890\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:151:\"Join Josepha as she explores the differences between Openverse &#38; Photo Directory, two resources for openly licensed media in the WordPress project.\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:9:\"enclosure\";a:1:{i:0;a:5:{s:4:\"data\";s:0:\"\";s:7:\"attribs\";a:1:{s:0:\"\";a:3:{s:3:\"url\";s:62:\"https://wordpress.org/news/files/2022/11/WP-Briefing-043-1.mp3\";s:6:\"length\";s:1:\"0\";s:4:\"type\";s:0:\"\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:14:\"Santana Inniss\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:8965:\"\n<p>In the forty-third episode of the WordPress Briefing, Josepha Haden Chomphosy explores two resources for openly licensed media in the WordPress project&#8211; Openverse and Photo Directory&#8211; and how they differ from one another!</p>\n\n\n\n<p><em><strong>Have a question you&#8217;d like answered? You can submit them to <a href=\"mailto:wpbriefing@wordpress.org\">wpbriefing@wordpress.org</a>, either written or as a voice recording.</strong></em></p>\n\n\n\n<h2>Credits</h2>\n\n\n\n<p>Editor:&nbsp;<a href=\"https://profiles.wordpress.org/dustinhartzler/\">Dustin Hartzler</a><br>Logo:&nbsp;<a href=\"https://profiles.wordpress.org/javiarce/\" data-type=\"URL\" data-id=\"https://profiles.wordpress.org/javiarce/\">Javier Arce</a><br>Production:&nbsp;<a href=\"https://profiles.wordpress.org/santanainniss/\">Santana Inniss</a><br>Song: Fearless First by Kevin MacLeod </p>\n\n\n\n<h2>References</h2>\n\n\n\n<p><a href=\"https://make.wordpress.org/photos/\" data-type=\"URL\" data-id=\"https://make.wordpress.org/photos/\">Photo Directory Make Page</a><br><a href=\"https://wordpress.org/photos/submit/\" data-type=\"URL\" data-id=\"https://wordpress.org/photos/submit/\">Submit a Photo to the Photo Directory</a><br><a href=\"https://make.wordpress.org/openverse/\" data-type=\"URL\" data-id=\"https://make.wordpress.org/openverse/\">Openverse Make Page</a><br><a href=\"https://github.com/WordPress/gutenberg/issues/44496\" data-type=\"URL\" data-id=\"https://github.com/WordPress/gutenberg/issues/44496\">Openverse Call for Contributions: Block Editor Integration</a><br><a href=\"https://wordpress.org/download/\" data-type=\"URL\" data-id=\"https://wordpress.org/download/\">Download WordPress 6.1</a><br><a href=\"https://make.wordpress.org/docs/?p=13761\" data-type=\"URL\" data-id=\"https://make.wordpress.org/docs/?p=13761\">Docs Team Contributor Day Recap Post</a><br><a href=\"https://wp.me/p4FYxH-1XH\" data-type=\"URL\" data-id=\"https://wp.me/p4FYxH-1XH\">Hallway Hangout Block Themes (Video)</a></p>\n\n\n\n<h2>Transcript</h2>\n\n\n\n<span id=\"more-13890\"></span>\n\n\n\n<p><strong>[Josepha Haden Chomphosy 00:00:00]&nbsp;</strong></p>\n\n\n\n<p>Hello everyone, and welcome to the WordPress Briefing, the podcast where you can catch quick explanations of the ideas behind the WordPress open source project, some insight into the community that supports it, and get a small list of big things coming up in the next two weeks.&nbsp;</p>\n\n\n\n<p>I&#8217;m your host, Josepha Haden Chomphosy. Here we go!</p>\n\n\n\n<p><strong>[Josepha Haden Chomphosy 00:00:27] </strong></p>\n\n\n\n<p>About 18 months ago, the Openverse project became part of the WordPress open source project, and at roughly the same time, we also welcomed the Photo Directory.</p>\n\n\n\n<p>Since that time, we&#8217;ve seen growth in teams supporting both of these initiatives. But if you&#8217;re not involved in the day-to-day, it can be hard to know how those two things fit together or if they fit together at all.</p>\n\n\n\n<p><strong>[Josepha Haden Chomphosy 00:01:00]&nbsp;</strong></p>\n\n\n\n<p>Today, let&#8217;s take a brief tour of those two projects and why they came to be.&nbsp;</p>\n\n\n\n<p>In my timeline, work on the Photo Directory started before the work on Openverse, so that&#8217;s where we&#8217;ll start.</p>\n\n\n\n<p>For as long as I can remember, the WordPress community has raised the need for WordPress-first ways to have and host GPL-compatible photos for use in themes, site builds, and marketing efforts as a whole. As recently as 2016, that was still coming up as a question at various flagship events and among the career photographers that contribute their time to WordPress.</p>\n\n\n\n<p>So in 2017 and 2018, as attention started to turn toward rebuilding the CMS using blocks, it dropped down the list of priority items. But it never really went away as a thing that people were hoping we could do for the project as a whole. So in 2019, it was becoming clear that having open source-first tools of all varieties for people whose businesses were built on our software would help broaden the availability of the open source freedoms we believe in.</p>\n\n\n\n<p><strong>[Josepha Haden Chomphosy 00:02:00]&nbsp;</strong></p>\n\n\n\n<p>This began the work on the Photo Directory with the intention of providing a GPL-friendly, community-driven repository of images. It has since launched, and we have photos in it now. We have a whole team around it. It&#8217;s wonderful. But that is how that all kind of came to be.&nbsp;</p>\n\n\n\n<p>Openverse, on the other hand, was launched as CC Search in 2019 with the laudable mandate to increase the discoverability and accessibility of open access media.</p>\n\n\n\n<p>Late in 2020, while work on the Photo Directory was underway, Matt shared with me that the team was looking for a new project home. When I first met with them, they shared an overview of the product, which they shorthanded as an open source search engine that searches openly licensed images. We were working on a repo of openly licensed images, so clearly, this was all written in the stars. And so you might be asking yourself at this point, great, how does it work together?</p>\n\n\n\n<p>I think for most of us, the timeline there kind of covers the question of what is the difference between these two things.&nbsp;</p>\n\n\n\n<p><strong>[Josepha Haden Chomphosy 00:03:00]&nbsp;</strong></p>\n\n\n\n<p>But because I never know which of you will want to strike up a conversation about open source on an elevator, I&#8217;ve also got the elevator pitch version.&nbsp;</p>\n\n\n\n<p>Openverse is an open source search engine that searches, indexes, and aggregates copy left media from across the web using sources such as WordPress&#8217;s Photo Directory, Flickr&#8217;s CC Tagged Media, and Wikimedia, to name just a few.&nbsp;</p>\n\n\n\n<p>Another key difference between the Photo Directory and Openverse is that in order to contribute to the Photo Directory, now that it&#8217;s all built, that&#8217;s mostly done by submitting photos or reviewing photos. So you don&#8217;t really need to be a developer to join in.&nbsp;</p>\n\n\n\n<p>Openverse is not only a developer-centric contribution opportunity, but it also uses a different tech stack than WordPress as a whole. So it&#8217;s a good place for folks to go if they&#8217;re looking to broaden their horizons.</p>\n\n\n\n<p>So that&#8217;s your elevator pitch of what Openverse is and how it uses the Photo Directory.&nbsp;</p>\n\n\n\n<p><strong>[Josepha Haden Chomphosy 00:04:00]&nbsp;</strong></p>\n\n\n\n<p>You have a couple of ways that you can get involved with these two projects. For the Photo Directory, as I mentioned at the start, you can always contribute photos, and they could always use more photo contributions.</p>\n\n\n\n<p>I&#8217;ll include a link to the submission guidelines in the show notes below, and as I mentioned, it is a no-code way to give back to the WordPress project. So no code, development environments, and testing skills are required. The Photo Directory team also could always use more contributors to help with the moderating of photo submissions.</p>\n\n\n\n<p>And so I&#8217;ll link to their making WordPress page in the show notes as well so that you can get started there.&nbsp;</p>\n\n\n\n<p>And as I mentioned before, Openverse is an aggregator, so it doesn&#8217;t host any media itself, but it is always accepting suggestions for new GPL-compatible media providers. I&#8217;ll link the area where you can leave suggestions in the show notes as well.</p>\n\n\n\n<p>And if you are more code inclined, there&#8217;s an open issue for adding Openverse browsing to the block editor right now.&nbsp;&nbsp;</p>\n\n\n\n<p><strong>[Josepha Haden Chomphosy 00:05:00]&nbsp;</strong></p>\n\n\n\n<p>So I&#8217;ll link that issue in the show notes in case you thought to yourself, gosh, that sounds like my most favorite thing to do. That is where you can go.&nbsp;</p>\n\n\n\n<p><strong>[Josepha Haden Chomphosy 00:05:12]</strong></p>\n\n\n\n<p>This leads us now to our small list of big things.</p>\n\n\n\n<p>In case you missed it, WordPress 6.1 is now available. It launched on November 1st. Late, late, late in the day, and so it was easy to miss if you&#8217;re used to seeing it at a particular time. We were about six hours later than usual. But if you go to wordpress.org/download, you can get your own copy there.</p>\n\n\n\n<p>The second thing on our small list of big things is that the Docs team had a contributor day. It was excellent. There&#8217;s a recap post up. I will include that in the show notes.&nbsp;</p>\n\n\n\n<p>And then the final thing is that there was a recent hallway hangout that talked about the site editor and block themes.</p>\n\n\n\n<p>[<strong>Josepha Haden Chomphosy </strong>00:06:00]&nbsp;</p>\n\n\n\n<p>The video for that is also published. I will also share that in our show notes.</p>\n\n\n\n<p>And that, my friends, is your small list of big things. Thank you for tuning in today for the WordPress Briefing. I&#8217;m your host, Josepha Haden Chomphosy, and I&#8217;ll see you again in a couple of weeks.</p>\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:30:\"com-wordpress:feed-additions:1\";a:1:{s:7:\"post-id\";a:1:{i:0;a:5:{s:4:\"data\";s:5:\"13890\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:6;a:6:{s:4:\"data\";s:70:\"\n		\n		\n		\n		\n		\n				\n		\n		\n		\n		\n		\n\n					\n										\n					\n		\n		\n\n			\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:4:{s:0:\"\";a:7:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Introducing Twenty Twenty-Three\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:67:\"https://wordpress.org/news/2022/11/introducing-twenty-twenty-three/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Tue, 08 Nov 2022 15:42:22 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:5:{i:0;a:5:{s:4:\"data\";s:6:\"Design\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:1;a:5:{s:4:\"data\";s:11:\"Development\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:2;a:5:{s:4:\"data\";s:3:\"6.1\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:3;a:5:{s:4:\"data\";s:3:\"tt3\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:4;a:5:{s:4:\"data\";s:19:\"twenty twenty-three\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:35:\"https://wordpress.org/news/?p=13892\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:376:\"This post was written in collaboration with Lauren Stein (@laurlittle) and Anne McCarthy @annezazu). Twenty Twenty-Three is here, alongside WordPress 6.1! The new default theme offers a clean, blank canvas bundled with a collection of style variations. Style variations are predefined design options that give you the opportunity to alter the appearance of your site [&#8230;]\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:9:\"enclosure\";a:1:{i:0;a:5:{s:4:\"data\";s:0:\"\";s:7:\"attribs\";a:1:{s:0:\"\";a:3:{s:3:\"url\";s:72:\"https://wordpress.org/news/files/2022/11/Introducing-TT3_V4_captions.mp4\";s:6:\"length\";s:8:\"90767180\";s:4:\"type\";s:9:\"video/mp4\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:14:\"Beatriz Fialho\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:2438:\"\n<figure class=\"wp-block-video\"><video controls poster=\"https://wordpress.org/news/files/2022/11/introducing_tt3_featured_image.png\" src=\"https://wordpress.org/news/files/2022/11/Introducing-TT3_V4_captions.mp4\"></video></figure>\n\n\n\n<p><em>This post was written in collaboration with Lauren Stein (<a href=\'https://profiles.wordpress.org/laurlittle/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>laurlittle</a>) and Anne McCarthy <a href=\'https://profiles.wordpress.org/annezazu/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>annezazu</a>)</em>.</p>\n\n\n\n<hr class=\"wp-block-separator has-alpha-channel-opacity\" />\n\n\n\n<p>Twenty Twenty-Three is here, alongside WordPress 6.1! The new default theme offers a clean, blank canvas bundled with a collection of style variations.</p>\n\n\n\n<p>Style variations are predefined design options that give you the opportunity to alter the appearance of your site without having to change your theme. This means that you can keep your template structure but change the visual details of your site with ease.</p>\n\n\n\n<p>For a truly diverse collection, Twenty Twenty-Three’s featured style variations were submitted by members of the WordPress community, resulting in 38 submissions from 19 people in 8 different countries. From those submissions, a curated collection of ten was chosen and bundled with the new theme.</p>\n\n\n\n<p>This approach to style variations ushers in the next generation of block themes, able to harness the potential of the platform’s latest design capabilities and tools directly in the Site Editor. Since style variations don’t require any code experience, you’re encouraged to tweak and/or create your own.</p>\n\n\n\n<p><strong>Thank you to everyone who contributed. <img src=\"https://s.w.org/images/core/emoji/14.0.0/72x72/1f389.png\" alt=\"🎉\" class=\"wp-smiley\" style=\"height: 1em; max-height: 1em;\" /></strong></p>\n\n\n\n<p>Useful links:<br><a href=\"https://wordpress.org/themes/twentytwentythree/\">Download Twenty Twenty-Three</a><br><a href=\"https://wordpress.org/support/article/twenty-twenty-three/\">Twenty Twenty-Three Documentation</a><br><a href=\"https://make.wordpress.org/design/2022/08/10/twenty-twenty-three-default-theme-project-kickoff/\">Twenty Twenty-Three Project Kick Off</a><br><a href=\"https://make.wordpress.org/design/2022/09/07/tt3-default-theme-announcing-style-variation-selections/\">Twenty Twenty-Three Selected Style Variations</a></p>\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:30:\"com-wordpress:feed-additions:1\";a:1:{s:7:\"post-id\";a:1:{i:0;a:5:{s:4:\"data\";s:5:\"13892\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:7;a:6:{s:4:\"data\";s:66:\"\n		\n		\n		\n		\n		\n				\n		\n		\n		\n		\n\n					\n										\n					\n		\n		\n			\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:4:{s:0:\"\";a:6:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:25:\"WordPress 6.1 “Misha”\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:41:\"https://wordpress.org/news/2022/11/misha/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Tue, 01 Nov 2022 18:38:09 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:4:{i:0;a:5:{s:4:\"data\";s:7:\"General\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:1;a:5:{s:4:\"data\";s:8:\"Releases\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:2;a:5:{s:4:\"data\";s:3:\"6.1\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:3;a:5:{s:4:\"data\";s:8:\"releases\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:35:\"https://wordpress.org/news/?p=13798\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:206:\"Say hello to “Misha,” the WordPress 6.1 release, inspired by Mikhail “Misha” Alperin acclaimed jazz ensemblist and composer. At least 800 contributors made this release possible. Download 6.1 today.\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:14:\"Matt Mullenweg\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:85835:\"\n<figure class=\"wp-block-image size-large\"><img decoding=\"async\" loading=\"lazy\" width=\"1024\" height=\"683\" src=\"https://i0.wp.com/wordpress.org/news/files/2022/11/inline-image-inline.png?resize=1024%2C683&#038;ssl=1\" alt=\"\" class=\"wp-image-13872\" srcset=\"https://i0.wp.com/wordpress.org/news/files/2022/11/inline-image-inline.png?resize=1024%2C683&amp;ssl=1 1024w, https://i0.wp.com/wordpress.org/news/files/2022/11/inline-image-inline.png?resize=300%2C200&amp;ssl=1 300w, https://i0.wp.com/wordpress.org/news/files/2022/11/inline-image-inline.png?resize=768%2C512&amp;ssl=1 768w, https://i0.wp.com/wordpress.org/news/files/2022/11/inline-image-inline.png?resize=1536%2C1024&amp;ssl=1 1536w, https://i0.wp.com/wordpress.org/news/files/2022/11/inline-image-inline.png?resize=2048%2C1365&amp;ssl=1 2048w\" sizes=\"(max-width: 1000px) 100vw, 1000px\" data-recalc-dims=\"1\" /></figure>\n\n\n\n<h1>Welcome to “Misha”</h1>\n\n\n\n<p>Say hello to WordPress 6.1, “Misha,” inspired by the life and work of jazz pianist <a href=\"https://en.wikipedia.org/wiki/Mikhail_Alperin\">Mikhail “Misha” Alperin</a>. Ukrainian-born Misha introduced the work of jazz ensembles globally and is celebrated as a founding member of the <a href=\"https://en.wikipedia.org/wiki/Moscow_Art_Trio\">Moscow Art Trio</a>.<br><br>“Misha” further refines the site-building experience. Inside WordPress 6.1 you’ll interact with enhancements that continue to make site creation more intuitive while pushing your creative boundaries further than ever. Don’t forget to enjoy some of Misha’s <a href=\"https://www.youtube.com/channel/UCuh5oEm_jJ_jTcv8DmbLi2Q\">jazz piano</a> as you take in all WordPress 6.1 has to offer.</p>\n\n\n\n<p><span style=\"font-weight: 400\">The third major release of 2022 is here. </span><a href=\"https://wordpress.org/wordpress-6.1.zip\"><span style=\"font-weight: 400\">Download it now</span></a><span style=\"font-weight: 400\">! As of the time of this release, WordPress powers </span><a href=\"https://w3techs.com/technologies/overview/content_management\">43%</a><span style=\"font-weight: 400\"> of websites worldwide.</span></p>\n\n\n\n<p><span style=\"font-weight: 400\">Site owners and administrators should upgrade today to take full advantage of the many stability, performance, and usability enhancements. Furthermore, WordPress content creators will enjoy a suite of new features geared toward improving the writing and designing experiences.</span></p>\n\n\n\n<blockquote class=\"wp-block-quote\">\n<p>This release includes features that many in the WordPress Community have been most excited about since the start of this project. Additional enhancements and improvements to the editor give site owners more control and easier customization while offering a more cohesive experience to users. A lot of writing-focused improvements are included in the release, because if you’re giving voices to the voiceless you’ve got to focus on folks writing the copy. </p>\n\n\n\n<p>Some of my favorite enhancements are the refined ability to select partial paragraphs in a block; settings to keep list view open by default; and the keyboard shortcut to add internal links expanded to all blocks.</p>\n<cite>Josepha Haden Chomphosy, Executive Director</cite></blockquote>\n\n\n\n<div class=\"wp-block-buttons is-layout-flex\">\n<div class=\"wp-block-button\"><a class=\"wp-block-button__link wp-element-button\" href=\"https://wordpress.org/wordpress-6.1.zip\">Download WordPress 6.1</a></div>\n</div>\n\n\n\n<hr class=\"wp-block-separator has-alpha-channel-opacity\" />\n\n\n\n<h2>What’s Inside</h2>\n\n\n\n<h3>Twenty Twenty-Three:<br>A fresh default theme with 10 distinct style variations</h3>\n\n\n\n<p>After introducing foundational elements for block themes and style variations in releases 5.9 and 6.0, WordPress site builders welcome a new default theme, Twenty Twenty-Three, that is powered by <a href=\"https://make.wordpress.org/design/2022/09/07/tt3-default-theme-announcing-style-variation-selections/\">10 different styles</a> and tagged as&nbsp; “<a href=\"https://make.wordpress.org/themes/handbook/review/accessibility/\">Accessibility Ready</a>.” These intentionally unique styles ensure users can apply a different look and feel to their site with a single click—all within a single theme.</p>\n\n\n\n<figure class=\"wp-block-image size-large\"><img decoding=\"async\" loading=\"lazy\" width=\"1024\" height=\"601\" src=\"https://i0.wp.com/wordpress.org/news/files/2022/11/Style-Variation-News-1.png?resize=1024%2C601&#038;ssl=1\" alt=\"\" class=\"wp-image-13843\" srcset=\"https://i0.wp.com/wordpress.org/news/files/2022/11/Style-Variation-News-1.png?resize=1024%2C601&amp;ssl=1 1024w, https://i0.wp.com/wordpress.org/news/files/2022/11/Style-Variation-News-1.png?resize=300%2C176&amp;ssl=1 300w, https://i0.wp.com/wordpress.org/news/files/2022/11/Style-Variation-News-1.png?resize=768%2C451&amp;ssl=1 768w, https://i0.wp.com/wordpress.org/news/files/2022/11/Style-Variation-News-1.png?resize=1536%2C901&amp;ssl=1 1536w, https://i0.wp.com/wordpress.org/news/files/2022/11/Style-Variation-News-1.png?resize=2048%2C1201&amp;ssl=1 2048w\" sizes=\"(max-width: 1000px) 100vw, 1000px\" data-recalc-dims=\"1\" /></figure>\n\n\n\n<h3>New templates for an improved creator experience</h3>\n\n\n\n<p>New and more refined templates now give site builders more control over the creation of their sites. In this suite of new templates, find a custom template for posts &amp; pages in the Site Editor. Create and edit template parts like headers and footers more quickly with a new search-and-replace tool and easily view your new site.</p>\n\n\n\n<figure class=\"wp-block-image size-large\"><img decoding=\"async\" loading=\"lazy\" width=\"1024\" height=\"601\" src=\"https://i0.wp.com/wordpress.org/news/files/2022/11/Templates-News.png?resize=1024%2C601&#038;ssl=1\" alt=\"\" class=\"wp-image-13818\" srcset=\"https://i0.wp.com/wordpress.org/news/files/2022/11/Templates-News.png?resize=1024%2C601&amp;ssl=1 1024w, https://i0.wp.com/wordpress.org/news/files/2022/11/Templates-News.png?resize=300%2C176&amp;ssl=1 300w, https://i0.wp.com/wordpress.org/news/files/2022/11/Templates-News.png?resize=768%2C451&amp;ssl=1 768w, https://i0.wp.com/wordpress.org/news/files/2022/11/Templates-News.png?resize=1536%2C901&amp;ssl=1 1536w, https://i0.wp.com/wordpress.org/news/files/2022/11/Templates-News.png?resize=2048%2C1201&amp;ssl=1 2048w\" sizes=\"(max-width: 1000px) 100vw, 1000px\" data-recalc-dims=\"1\" /></figure>\n\n\n\n<h3>Design tools for more consistency and control</h3>\n\n\n\n<p>Thoughtful upgrades to the controls for design elements and blocks make laying out and building your new site a more consistent, complete, and intuitive experience.</p>\n\n\n\n<figure class=\"wp-block-gallery has-nested-images columns-default is-cropped wp-block-gallery-2 is-layout-flex\">\n<figure class=\"wp-block-image size-large\"><img decoding=\"async\" loading=\"lazy\" width=\"1024\" height=\"601\" data-id=\"13819\"  src=\"https://i0.wp.com/wordpress.org/news/files/2022/11/Design-Tools-News.png?resize=1024%2C601&#038;ssl=1\" alt=\"\" class=\"wp-image-13819\" srcset=\"https://i0.wp.com/wordpress.org/news/files/2022/11/Design-Tools-News.png?resize=1024%2C601&amp;ssl=1 1024w, https://i0.wp.com/wordpress.org/news/files/2022/11/Design-Tools-News.png?resize=300%2C176&amp;ssl=1 300w, https://i0.wp.com/wordpress.org/news/files/2022/11/Design-Tools-News.png?resize=768%2C451&amp;ssl=1 768w, https://i0.wp.com/wordpress.org/news/files/2022/11/Design-Tools-News.png?resize=1536%2C901&amp;ssl=1 1536w, https://i0.wp.com/wordpress.org/news/files/2022/11/Design-Tools-News.png?resize=2048%2C1201&amp;ssl=1 2048w\" sizes=\"(max-width: 1000px) 100vw, 1000px\" data-recalc-dims=\"1\" /></figure>\n</figure>\n\n\n\n<h3>Manage menus with ease</h3>\n\n\n\n<p>New fallback options in the navigation block mean you can edit the menu that’s open; no searching needed. Plus, the controls for choosing and working on menus have their own place in the block settings. The mobile menu system also gets an upgrade with new features, including different icon options, to make the menu yours.</p>\n\n\n\n<figure class=\"wp-block-image size-large\"><img decoding=\"async\" loading=\"lazy\" width=\"1024\" height=\"601\" src=\"https://i0.wp.com/wordpress.org/news/files/2022/11/Navigation-1.png?resize=1024%2C601&#038;ssl=1\" alt=\"\" class=\"wp-image-13844\" srcset=\"https://i0.wp.com/wordpress.org/news/files/2022/11/Navigation-1.png?resize=1024%2C601&amp;ssl=1 1024w, https://i0.wp.com/wordpress.org/news/files/2022/11/Navigation-1.png?resize=300%2C176&amp;ssl=1 300w, https://i0.wp.com/wordpress.org/news/files/2022/11/Navigation-1.png?resize=768%2C451&amp;ssl=1 768w, https://i0.wp.com/wordpress.org/news/files/2022/11/Navigation-1.png?resize=1536%2C901&amp;ssl=1 1536w, https://i0.wp.com/wordpress.org/news/files/2022/11/Navigation-1.png?resize=2048%2C1201&amp;ssl=1 2048w\" sizes=\"(max-width: 1000px) 100vw, 1000px\" data-recalc-dims=\"1\" /></figure>\n\n\n\n<h3>Cleaner layouts and document settings visualization</h3>\n\n\n\n<p>View and manage post and page settings with a better-organized display improving the use of features like template picker and scheduler.</p>\n\n\n\n<figure class=\"wp-block-image size-large\"><img decoding=\"async\" loading=\"lazy\" width=\"1024\" height=\"601\" src=\"https://i0.wp.com/wordpress.org/news/files/2022/11/Document-settings-News-1.png?resize=1024%2C601&#038;ssl=1\" alt=\"\" class=\"wp-image-13838\" srcset=\"https://i0.wp.com/wordpress.org/news/files/2022/11/Document-settings-News-1.png?resize=1024%2C601&amp;ssl=1 1024w, https://i0.wp.com/wordpress.org/news/files/2022/11/Document-settings-News-1.png?resize=300%2C176&amp;ssl=1 300w, https://i0.wp.com/wordpress.org/news/files/2022/11/Document-settings-News-1.png?resize=768%2C451&amp;ssl=1 768w, https://i0.wp.com/wordpress.org/news/files/2022/11/Document-settings-News-1.png?resize=1536%2C901&amp;ssl=1 1536w, https://i0.wp.com/wordpress.org/news/files/2022/11/Document-settings-News-1.png?resize=2048%2C1201&amp;ssl=1 2048w\" sizes=\"(max-width: 1000px) 100vw, 1000px\" data-recalc-dims=\"1\" /></figure>\n\n\n\n<h3>One-click lock setting for all inner blocks</h3>\n\n\n\n<p>When locking blocks, a new toggle lets you apply your lock settings to all the blocks in a containing block like the group, cover, and column blocks.</p>\n\n\n\n<figure class=\"wp-block-gallery has-nested-images columns-default is-cropped wp-block-gallery-4 is-layout-flex\">\n<figure class=\"wp-block-image size-large\"><img decoding=\"async\" loading=\"lazy\" width=\"1024\" height=\"601\" data-id=\"13824\"  src=\"https://i0.wp.com/wordpress.org/news/files/2022/11/Lock-News.png?resize=1024%2C601&#038;ssl=1\" alt=\"\" class=\"wp-image-13824\" srcset=\"https://i0.wp.com/wordpress.org/news/files/2022/11/Lock-News.png?resize=1024%2C601&amp;ssl=1 1024w, https://i0.wp.com/wordpress.org/news/files/2022/11/Lock-News.png?resize=300%2C176&amp;ssl=1 300w, https://i0.wp.com/wordpress.org/news/files/2022/11/Lock-News.png?resize=768%2C451&amp;ssl=1 768w, https://i0.wp.com/wordpress.org/news/files/2022/11/Lock-News.png?resize=1536%2C901&amp;ssl=1 1536w, https://i0.wp.com/wordpress.org/news/files/2022/11/Lock-News.png?resize=2048%2C1201&amp;ssl=1 2048w\" sizes=\"(max-width: 1000px) 100vw, 1000px\" data-recalc-dims=\"1\" /></figure>\n</figure>\n\n\n\n<h3>Improved block placeholders</h3>\n\n\n\n<p>Various blocks have improved placeholders that reflect customization options to help you design your site and its content. For example, the Image block placeholder displays custom borders and duotone filters even before selecting an image.</p>\n\n\n\n<h3>Compose richer lists and quotes with inner blocks</h3>\n\n\n\n<p>The List and Quote blocks now support inner blocks, allowing for more flexible and rich compositions like adding headings inside your Quote blocks.</p>\n\n\n\n<h3>More responsive text with fluid typography</h3>\n\n\n\n<p>For developers working with block themes and/or <code>theme.json</code>, <a href=\"https://make.wordpress.org/core/2022/08/04/whats-new-in-gutenberg-13-8-3-august/#fluid-typography-support\">fluid typography</a> lets you define font sizes that adapt for easy reading in any screen size.</p>\n\n\n\n<h3>Add starter patterns to any post type</h3>\n\n\n\n<p>In WordPress 6.0, site builders could add suggested patterns so that when creating a new page, you did not have to start blank. In 6.1, site builders can continue to opt-in to this feature for not only pages but for any post type. </p>\n\n\n\n<h3>Find block themes faster</h3>\n\n\n\n<p>The Themes Directory has a filter for block themes, and a pattern preview gives a better sense of what the theme might look like while exploring different themes and patterns.</p>\n\n\n\n<h3>Keep your Site Editor settings for later</h3>\n\n\n\n<p>Site Editor settings are now <a href=\"https://make.wordpress.org/core/2022/10/10/changes-to-block-editor-preferences-in-wordpress-6-1/\">persistent for each user</a>. This means your settings will now be consistent across browsers and devices.</p>\n\n\n\n<h3>A streamlined style system</h3>\n\n\n\n<p>The CSS rules for margin, padding, typography, colors, and borders within the <a href=\"https://make.wordpress.org/core/2022/10/10/block-styles-generation-style-engine/\">styles engine</a> are now all in one place, reducing time spent on layout-specific tasks and helps to generate semantic class names.</p>\n\n\n\n<h3>Updated interface options and features</h3>\n\n\n\n<p>Updates include <a href=\"https://make.wordpress.org/core/2022/10/10/styling-elements-in-block-themes/\">styling elements</a> like buttons, citations, and links globally; controlling hover, active, and focus states for links using theme.json (not available to control in the interface yet); and customizing outline support for blocks and elements, among other features.</p>\n\n\n\n<h3>Continued evolution of layout options</h3>\n\n\n\n<p>The default content dimensions provided by themes can now be overridden in the Styles Sidebar, giving site builders better control over full-width content. Developers have <a href=\"https://make.wordpress.org/core/2022/10/10/updated-editor-layout-support-in-6-1-after-refactor/\">fine-grained control over these controls</a>.</p>\n\n\n\n<h3>Block Template parts in classic themes</h3>\n\n\n\n<p><a href=\"https://make.wordpress.org/core/2022/10/04/block-based-template-parts-in-traditional-themes/\">Block template parts can now be defined in classic themes</a> by adding the appropriate HTML files `parts` directory at the root of the theme.</p>\n\n\n\n<h3>Expanded support for Query Loop blocks</h3>\n\n\n\n<p><a href=\"https://make.wordpress.org/core/2022/10/10/extending-the-query-loop-block/\">New filters</a> let Query Block variations support custom queries for more powerful variations and advanced hierarchical post types filtering options.</p>\n\n\n\n<h3>Filters for all your styles</h3>\n\n\n\n<p><a href=\"https://make.wordpress.org/core/2022/10/10/filters-for-theme-json-data/\">Leverage filters</a> in the Styles sidebar to control settings at all four levels of your site—core, theme, user, or block, from less to more specific.</p>\n\n\n\n<h3>Spacing presets for faster, consistent design</h3>\n\n\n\n<p>Save time and avoid hard-coding values into a theme with <a href=\"https://make.wordpress.org/core/2022/10/07/introduction-of-presets-across-padding-margin-and-block-gap/\">preset margin and padding values for multiple blocks.</a></p>\n\n\n\n<h3>Content-only editing support for container blocks</h3>\n\n\n\n<p>Thanks to content-only editing settings, layouts can be locked within container blocks. In a content-only block, its children are invisible to the List View and entirely uneditable. So you control the layout while your writers can focus on the content. Combine it with block-locking options for even more advanced control over your blocks.</p>\n\n\n\n<h3>Other notes of interest</h3>\n\n\n\n<ul>\n<li>6.1 includes a new time-to-read feature showing content authors the approximate time-to-read values for pages, posts, and custom post types.</li>\n\n\n\n<li>The site tagline is empty by default in new sites but can be modified in General Settings.</li>\n\n\n\n<li>A new modal design offers a background blur effect, making it easier to focus on the task at hand.</li>\n</ul>\n\n\n\n<h2>Enhancing WordPress 6.1 Accessibility</h2>\n\n\n\n<p>Accessibility is an integral part of the WordPress mission of fostering an inclusive community and supporting users of all types around the world. With this in mind, WordPress 6.1 includes nearly 60 updates specifically focused on enhancing the accessibility of the platform. <a href=\"https://make.wordpress.org/core/2022/10/11/wordpress-6-1-accessibility-improvements/\">Read these updates</a> to learn more about the continual initiatives aimed at improving accessibility.</p>\n\n\n\n<h2>Improved Performance in WordPress 6.1</h2>\n\n\n\n<p>WordPress 6.1 resolves more than 25 tickets dedicated to enhancing performance with improvements for every type of site. A full breakdown can be found in the <a href=\"https://make.wordpress.org/core/2022/10/11/performance-field-guide-for-wordpress-6-1/\">Performance Field Guide</a>.</p>\n\n\n\n<h2>Learn More About WordPress 6.1</h2>\n\n\n\n<p>See WordPress 6.1 in action! Watch a <a href=\"https://www.youtube.com/watch?v=1w9oywSa6Hw\">brief overview video</a> highlighting some of the major features debuting in WordPress 6.1.</p>\n\n\n\n<figure class=\"wp-block-embed is-type-video is-provider-youtube wp-block-embed-youtube wp-embed-aspect-16-9 wp-has-aspect-ratio\"><div class=\"wp-block-embed__wrapper\">\n<iframe loading=\"lazy\" class=\"youtube-player\" width=\"600\" height=\"338\" src=\"https://www.youtube.com/embed/1w9oywSa6Hw?version=3&#038;rel=1&#038;showsearch=0&#038;showinfo=1&#038;iv_load_policy=1&#038;fs=1&#038;hl=en-US&#038;autohide=2&#038;wmode=transparent\" allowfullscreen=\"true\" style=\"border:0;\" sandbox=\"allow-scripts allow-same-origin allow-popups allow-presentation\"></iframe>\n</div></figure>\n\n\n\n<p><br></p>\n\n\n\n<p>Explore <a href=\"https://learn.wordpress.org/\">learn.wordpress.org</a> for brief how-to videos and lots more on new features in WordPress. Or join a live <a href=\"https://learn.wordpress.org/social-learning/\">interactive online </a>workshop on a specific WordPress topic.</p>\n\n\n\n<p>Developers can explore the <a href=\"https://make.wordpress.org/core/2022/10/12/wordpress-6-1-field-guide/\">WordPress 6.1 Field Guide</a>, complete with detailed developer notes to help you build with and extend WordPress. Read the <a href=\"https://wordpress.org/support/wordpress-version/version-6-1\">WordPress</a><a href=\"https://wordpress.org/support/wordpress-version/version-6-1/\"> 6.1 Release Notes</a> for more information on the included enhancements and issues fixed, installation information, developer notes and resources, release contributors, and the list of file changes in this release.</p>\n\n\n\n<h2>The WordPress 6.1 Release Squad</h2>\n\n\n\n<p><span style=\"font-weight: 400\">The group listed below tirelessly supported the release, from conception to ship date, and beyond:</span></p>\n\n\n\n<p><span style=\"font-weight: 400\">Release Lead: </span><a href=\"https://profiles.wordpress.org/matt/\"><span style=\"font-weight: 400\">Matt Mullenweg</span></a><span style=\"font-weight: 400\">&nbsp;</span><br><span style=\"font-weight: 400\">Release Coordinators: </span><a href=\"https://profiles.wordpress.org/priethor/\"><span style=\"font-weight: 400\">Héctor Prieto</span></a><span style=\"font-weight: 400\"> and </span><a href=\"https://profiles.wordpress.org/desrosj/\"><span style=\"font-weight: 400\">Jonathan Desrosiers</span></a><span style=\"font-weight: 400\">&nbsp;</span><br><span style=\"font-weight: 400\">Core Tech Co-Leads: </span><a href=\"https://profiles.wordpress.org/mikeschroder/\"><span style=\"font-weight: 400\">Mike Schroder</span></a><span style=\"font-weight: 400\">, </span><a href=\"https://profiles.wordpress.org/davidbaumwald/\"><span style=\"font-weight: 400\">David Baumwald</span></a><span style=\"font-weight: 400\">, and </span><a href=\"https://profiles.wordpress.org/jeffpaul/\"><span style=\"font-weight: 400\">Jeff Paul</span></a><br><span style=\"font-weight: 400\">Editor Tech Co-Leads: </span><a href=\"https://profiles.wordpress.org/czapla/\"><span style=\"font-weight: 400\">Michal Czaplinski</span></a><span style=\"font-weight: 400\">, </span><a href=\"https://profiles.wordpress.org/bernhard-reiter/\"><span style=\"font-weight: 400\">Bernie Reiter</span></a><span style=\"font-weight: 400\">, and </span><a href=\"https://profiles.wordpress.org/cbravobernal/\"><span style=\"font-weight: 400\">Carlos Bravo</span></a><br><span style=\"font-weight: 400\">Core Triage Co-Leads: </span><a href=\"https://profiles.wordpress.org/audrasjb/\"><span style=\"font-weight: 400\">JB Audras</span></a><span style=\"font-weight: 400\"> and </span><a href=\"https://profiles.wordpress.org/chaion07/\"><span style=\"font-weight: 400\">Ahmed Chaion</span></a><br><span style=\"font-weight: 400\">Editor Triage Co-Leads: </span><a href=\"https://profiles.wordpress.org/ndiego/\"><span style=\"font-weight: 400\">Nick Diego</span></a> <span style=\"font-weight: 400\">and </span><a href=\"https://profiles.wordpress.org/annezazu/\"><span style=\"font-weight: 400\">Anne McCarthy</span></a><br><span style=\"font-weight: 400\">Documentation Co-Leads: </span><a href=\"https://profiles.wordpress.org/bph/\"><span style=\"font-weight: 400\">Birgit Pauli-Haack</span></a><span style=\"font-weight: 400\">, </span><a href=\"https://profiles.wordpress.org/milana_cap/\"><span style=\"font-weight: 400\">Milana Cap</span></a><span style=\"font-weight: 400\">, and </span><a href=\"https://profiles.wordpress.org/femkreations/\"><span style=\"font-weight: 400\">Femy Praseeth</span></a><br><span style=\"font-weight: 400\">Marketing &amp; Communications Co-Leads:</span> <a href=\"https://profiles.wordpress.org/jpantani/\"><span style=\"font-weight: 400\">Jonathan Pantani</span></a> <span style=\"font-weight: 400\">and </span><a href=\"https://profiles.wordpress.org/dansoschin/\"><span style=\"font-weight: 400\">Dan Soschin</span></a><br><span style=\"font-weight: 400\">Test Lead: </span><a href=\"https://profiles.wordpress.org/ironprogrammer/\"><span style=\"font-weight: 400\">Brian Alexander</span></a><br><span style=\"font-weight: 400\">Design Lead: </span><a href=\"https://profiles.wordpress.org/richtabor/\"><span style=\"font-weight: 400\">Rich Tabor</span></a><br><span style=\"font-weight: 400\">Default Theme Co-Leads: </span><a href=\"https://profiles.wordpress.org/beafialho/\"><span style=\"font-weight: 400\">Beatriz Fialho</span></a><span style=\"font-weight: 400\"> &amp; </span><a href=\"https://profiles.wordpress.org/mikachan/\"><span style=\"font-weight: 400\">Sarah Norris</span></a></p>\n\n\n\n<blockquote class=\"wp-block-quote\">\n<p>Thank you to all the contributors who dedicated time and energy to bring the best WordPress experience to everyone.</p>\n<cite>Josepha Haden Chomphosy</cite></blockquote>\n\n\n\n<p></p>\n\n\n\n<pre class=\"wp-block-code\"><code class=\"\"><p class=\"is-style-wporg-props-long alignfull\"><a href=\"https://profiles.wordpress.org/10upsimon/\">10upsimon</a> · <a href=\"https://profiles.wordpress.org/1naveengiri/\">1naveengiri</a> · <a href=\"https://profiles.wordpress.org/aaroncampbell/\">Aaron D. Campbell</a> · <a href=\"https://profiles.wordpress.org/jorbin/\">Aaron Jorbin</a> · <a href=\"https://profiles.wordpress.org/aaronrobertshaw/\">Aaron Robertshaw</a> · <a href=\"https://profiles.wordpress.org/webcommsat/\">Abha Thakor</a> · <a href=\"https://profiles.wordpress.org/hurayraiit/\">Abu Hurayra</a> · <a href=\"https://profiles.wordpress.org/bosconiandynamics/\">Adam Bosco</a> · <a href=\"https://profiles.wordpress.org/adampickering/\">Adam Pickering</a> · <a href=\"https://profiles.wordpress.org/adamsilverstein/\">Adam Silverstein</a> · <a href=\"https://profiles.wordpress.org/admwgn/\">Adam Wiltgen</a> · <a href=\"https://profiles.wordpress.org/zieladam/\">Adam Zielinski</a> · <a href=\"https://profiles.wordpress.org/addiestavlo/\">Addie</a> · <a href=\"https://profiles.wordpress.org/oztaser/\">Adil &#214;ztaşer</a> · <a href=\"https://profiles.wordpress.org/aduth/\">aduth</a> · <a href=\"https://profiles.wordpress.org/aezazshekh/\">Aezaz Shekh</a> · <a href=\"https://profiles.wordpress.org/afrid1719/\">afrid1719</a> · <a href=\"https://profiles.wordpress.org/chaion07/\">Ahmed Chaion</a> · <a href=\"https://profiles.wordpress.org/engahmeds3ed/\">Ahmed Saeed</a> · <a href=\"https://profiles.wordpress.org/seakashdiu/\">Akash Mia</a> · <a href=\"https://profiles.wordpress.org/wildworks/\">Aki Hamano</a> · <a href=\"https://profiles.wordpress.org/kamig478/\">Akram ul haq</a> · <a href=\"https://profiles.wordpress.org/akshitsethi/\">Akshit Sethi</a> · <a href=\"https://profiles.wordpress.org/schlessera/\">Alain Schlesser</a> · <a href=\"https://profiles.wordpress.org/alamgircsebd/\">alamgircsebd</a> · <a href=\"https://profiles.wordpress.org/alanp57/\">AlanP57</a> · <a href=\"https://profiles.wordpress.org/alansyue/\">alansyue</a> · <a href=\"https://profiles.wordpress.org/aljullu/\">Albert Juh&#233; Lluveras</a> · <a href=\"https://profiles.wordpress.org/alberuni-azad/\">Alberuni Azad.</a> · <a href=\"https://profiles.wordpress.org/elpanda13gmailcom/\">Alejandro J. Sanchez P.</a> · <a href=\"https://profiles.wordpress.org/zutigrm/\">Aleksej</a> · <a href=\"https://profiles.wordpress.org/xknown/\">Alex Concha</a> · <a href=\"https://profiles.wordpress.org/ajlende/\">Alex Lende</a> · <a href=\"https://profiles.wordpress.org/viper007bond/\">Alex Mills</a> · <a href=\"https://profiles.wordpress.org/acoulombe/\">Alexis Coulombe</a> · <a href=\"https://profiles.wordpress.org/alexstine/\">alexstine</a> · <a href=\"https://profiles.wordpress.org/allancole/\">allancole</a> · <a href=\"https://profiles.wordpress.org/allisonplus/\">allisonplus</a> · <a href=\"https://profiles.wordpress.org/mrfoxtalbot/\">Alvaro G&#243;mez</a> · <a href=\"https://profiles.wordpress.org/amirkamizi/\">amirkamizi</a> · <a href=\"https://profiles.wordpress.org/amjadr360/\">Amjad Ali</a> · <a href=\"https://profiles.wordpress.org/anantajitjg/\">Anantajit JG</a> · <a href=\"https://profiles.wordpress.org/afercia/\">Andrea Fercia</a> · <a href=\"https://profiles.wordpress.org/deksar/\">Andreas</a> · <a href=\"https://profiles.wordpress.org/andraganescu/\">Andrei Draganescu</a> · <a href=\"https://profiles.wordpress.org/_smartik_/\">Andrei Surdu</a> · <a href=\"https://profiles.wordpress.org/nacin/\">Andrew Nacin</a> · <a href=\"https://profiles.wordpress.org/azaozz/\">Andrew Ozz</a> · <a href=\"https://profiles.wordpress.org/andrewserong/\">Andrew Serong</a> · <a href=\"https://profiles.wordpress.org/eatingrules/\">Andrew Wilder</a> · <a href=\"https://profiles.wordpress.org/andrewnz/\">AndrewNZ</a> · <a href=\"https://profiles.wordpress.org/rarst/\">Andrey \"Rarst\" Savchenko</a> · <a href=\"https://profiles.wordpress.org/andrija/\">Andrija Naglic</a> · <a href=\"https://profiles.wordpress.org/oandregal/\">André</a> · <a href=\"https://profiles.wordpress.org/afragen/\">Andy Fragen</a> · <a href=\"https://profiles.wordpress.org/andykeith/\">Andy Keith</a> · <a href=\"https://profiles.wordpress.org/aniketpatel/\">Aniket Patel</a> · <a href=\"https://profiles.wordpress.org/anitanenova/\">anitanenova</a> · <a href=\"https://profiles.wordpress.org/ankit-k-gupta/\">Ankit K Gupta</a> · <a href=\"https://profiles.wordpress.org/annabansaghi/\">Anna Bansaghi</a> · <a href=\"https://profiles.wordpress.org/annezazu/\">Anne McCarthy</a> · <a href=\"https://profiles.wordpress.org/alaca/\">Ante Laca</a> · <a href=\"https://profiles.wordpress.org/antpb/\">Anthony Burchell</a> · <a href=\"https://profiles.wordpress.org/antonvlasenko/\">Anton Vlasenko</a> · <a href=\"https://profiles.wordpress.org/apedog/\">apedog</a> · <a href=\"https://profiles.wordpress.org/apokalyptik/\">apokalyptik</a> · <a href=\"https://profiles.wordpress.org/arrasel403/\">AR Rasel</a> · <a href=\"https://profiles.wordpress.org/arcangelini/\">arcangelini</a> · <a href=\"https://profiles.wordpress.org/archon810/\">archon810</a> · <a href=\"https://profiles.wordpress.org/aristath/\">Ari Stathopoulos</a> · <a href=\"https://profiles.wordpress.org/yellyc/\">Ariel Chinn</a> · <a href=\"https://profiles.wordpress.org/xylocone/\">Arjun Singh</a> · <a href=\"https://profiles.wordpress.org/armondal/\">Arnab Mondal</a> · <a href=\"https://profiles.wordpress.org/passoniate/\">Arslan Kalwar</a> · <a href=\"https://profiles.wordpress.org/arturgrabo/\">Artur Grabowski</a> · <a href=\"https://profiles.wordpress.org/ideag/\">Arunas Liuiza</a> · <a href=\"https://profiles.wordpress.org/aspexi/\">Aspexi</a> · <a href=\"https://profiles.wordpress.org/aurooba/\">Aurooba Ahmed</a> · <a href=\"https://profiles.wordpress.org/filosofo/\">Austin Matzko</a> · <a href=\"https://profiles.wordpress.org/ayeshrajans/\">Ayesh Karunaratne</a> · <a href=\"https://profiles.wordpress.org/azurseisme/\">azurseisme</a> · <a href=\"https://profiles.wordpress.org/baned/\">BaneD</a> · <a href=\"https://profiles.wordpress.org/barneydavey/\">barneydavey</a> · <a href=\"https://profiles.wordpress.org/bbobnis/\">Bartosz Bobnis</a> · <a href=\"https://profiles.wordpress.org/beafialho/\">Beatriz Fialho</a> · <a href=\"https://profiles.wordpress.org/scruffian/\">Ben Dwyer</a> · <a href=\"https://profiles.wordpress.org/bengreeley/\">Ben Greeley</a> · <a href=\"https://profiles.wordpress.org/utz119/\">Benachi</a> · <a href=\"https://profiles.wordpress.org/benjgrolleau/\">Benjamin Grolleau</a> · <a href=\"https://profiles.wordpress.org/benoitchantre/\">Benoit Chantre</a> · <a href=\"https://profiles.wordpress.org/bernhard reiter/\">Bernhard Reiter</a> · <a href=\"https://profiles.wordpress.org/bernhard-reiter/\">Bernie Reiter</a> · <a href=\"https://profiles.wordpress.org/mxbclang/\">Bethany Chobanian Lang</a> · <a href=\"https://profiles.wordpress.org/albatross10/\">Bhavik Kalpesh</a> · <a href=\"https://profiles.wordpress.org/bhrugesh12/\">Bhrugesh Bavishi</a> · <a href=\"https://profiles.wordpress.org/elten/\">bing</a> · <a href=\"https://profiles.wordpress.org/birgire/\">Birgir Erlendsson (birgire)</a> · <a href=\"https://profiles.wordpress.org/bph/\">Birgit Pauli-Haack</a> · <a href=\"https://profiles.wordpress.org/bjorn2404/\">bjorn2404</a> · <a href=\"https://profiles.wordpress.org/boblindner/\">Bob</a> · <a href=\"https://profiles.wordpress.org/bobbingwide/\">bobbingwide</a> · <a href=\"https://profiles.wordpress.org/gitlost/\">bonger</a> · <a href=\"https://profiles.wordpress.org/boonebgorges/\">Boone Gorges</a> · <a href=\"https://profiles.wordpress.org/bjorsch/\">Brad Jorsch</a> · <a href=\"https://profiles.wordpress.org/kraftbj/\">Brandon Kraft</a> · <a href=\"https://profiles.wordpress.org/ironprogrammer/\">Brian Alexander</a> · <a href=\"https://profiles.wordpress.org/bgardner/\">Brian Gardner</a> · <a href=\"https://profiles.wordpress.org/cantuaria/\">Bruno Cantuaria</a> · <a href=\"https://profiles.wordpress.org/ribaricplusplus/\">Bruno Ribaric</a> · <a href=\"https://profiles.wordpress.org/burgiuk/\">burgiuk</a> · <a href=\"https://profiles.wordpress.org/burhandodhy/\">Burhan Nasir</a> · <a href=\"https://profiles.wordpress.org/bwbama/\">bwbama</a> · <a href=\"https://profiles.wordpress.org/cadlec/\">cadlec</a> · <a href=\"https://profiles.wordpress.org/cagsmith/\">cagsmith</a> · <a href=\"https://profiles.wordpress.org/cbravobernal/\">Carlos Bravo</a> · <a href=\"https://profiles.wordpress.org/carlosgprim/\">Carlos Garcia Prim</a> · <a href=\"https://profiles.wordpress.org/poena/\">Carolina Nymark</a> · <a href=\"https://profiles.wordpress.org/cavalierlife/\">cavalierlife</a> · <a href=\"https://profiles.wordpress.org/cdbessig/\">cdbessig</a> · <a href=\"https://profiles.wordpress.org/shireling/\">Chad Chadbourne</a> · <a href=\"https://profiles.wordpress.org/nhuja/\">Chandra M</a> · <a href=\"https://profiles.wordpress.org/critterverse/\">Channing Ritter</a> · <a href=\"https://profiles.wordpress.org/chetan200891/\">Chetan Prajapati</a> · <a href=\"https://profiles.wordpress.org/chintan1896/\">Chintan hingrajiya</a> · <a href=\"https://profiles.wordpress.org/cbringmann/\">Chloe Bringmann</a> · <a href=\"https://profiles.wordpress.org/chouby/\">Chouby</a> · <a href=\"https://profiles.wordpress.org/chrisbudd1/\">Chris Budd</a> · <a href=\"https://profiles.wordpress.org/chrishardie/\">Chris Hardie</a> · <a href=\"https://profiles.wordpress.org/czarate/\">Chris Zarate</a> · <a href=\"https://profiles.wordpress.org/chriscct7/\">chriscct7</a> · <a href=\"https://profiles.wordpress.org/chrisguitarguy/\">chrisguitarguy</a> · <a href=\"https://profiles.wordpress.org/cwbudde/\">Christian-W. Budde</a> · <a href=\"https://profiles.wordpress.org/christinavoudouris/\">Christina Voudouris</a> · <a href=\"https://profiles.wordpress.org/apermo/\">Christoph Daum</a> · <a href=\"https://profiles.wordpress.org/cfinke/\">Christopher Finke</a> · <a href=\"https://profiles.wordpress.org/ryno267/\">Chuck Reynolds</a> · <a href=\"https://profiles.wordpress.org/chynnabenton/\">chynnabenton</a> · <a href=\"https://profiles.wordpress.org/ckanderson22/\">ckanderson22</a> · <a href=\"https://profiles.wordpress.org/claytoncollie/\">Clayton Collie</a> · <a href=\"https://profiles.wordpress.org/design_dolphin/\">CodePoet</a> · <a href=\"https://profiles.wordpress.org/codesdnc/\">codesdnc</a> · <a href=\"https://profiles.wordpress.org/codewhy/\">codewhy</a> · <a href=\"https://profiles.wordpress.org/costdev/\">Colin Stewart</a> · <a href=\"https://profiles.wordpress.org/colonelphantom/\">colonelphantom</a> · <a href=\"https://profiles.wordpress.org/cbirdsong/\">Cory Birdsong</a> · <a href=\"https://profiles.wordpress.org/courane01/\">Courtney Robertson</a> · <a href=\"https://profiles.wordpress.org/craigfrancis/\">craigfrancis</a> · <a href=\"https://profiles.wordpress.org/crazycoders/\">crazycoders</a> · <a href=\"https://profiles.wordpress.org/mitogh/\">Crisoforo Gaspar</a> · <a href=\"https://profiles.wordpress.org/cu121/\">Cupid Chakma</a> · <a href=\"https://profiles.wordpress.org/curdin/\">Curdin Krummenacher</a> · <a href=\"https://profiles.wordpress.org/cyrillbolliger/\">cyrillbolliger</a> · <a href=\"https://profiles.wordpress.org/dxd5001/\">Daijiro Miyazawa</a> · <a href=\"https://profiles.wordpress.org/dainemawer/\">dainemawer</a> · <a href=\"https://profiles.wordpress.org/daisyo/\">Daisy Olsen</a> · <a href=\"https://profiles.wordpress.org/daledupreez/\">Dale du Preez</a> · <a href=\"https://profiles.wordpress.org/colorful-tones/\">Damon Cook</a> · <a href=\"https://profiles.wordpress.org/damonganto/\">damonganto</a> · <a href=\"https://profiles.wordpress.org/danfarrow/\">Dan Farrow</a> · <a href=\"https://profiles.wordpress.org/dansoschin/\">Dan Soschin</a> · <a href=\"https://profiles.wordpress.org/danielbachhuber/\">Daniel Bachhuber</a> · <a href=\"https://profiles.wordpress.org/danieliser/\">Daniel Iser</a> · <a href=\"https://profiles.wordpress.org/talldanwp/\">Daniel Richards</a> · <a href=\"https://profiles.wordpress.org/schutzsmith/\">Daniel Schutzsmith</a> · <a href=\"https://profiles.wordpress.org/mte90/\">Daniele Scasciafratte</a> · <a href=\"https://profiles.wordpress.org/darerodz/\">darerodz</a> · <a href=\"https://profiles.wordpress.org/dariak/\">Daria</a> · <a href=\"https://profiles.wordpress.org/dkotter/\">Darin Kotter</a> · <a href=\"https://profiles.wordpress.org/darkog/\">Darko G.</a> · <a href=\"https://profiles.wordpress.org/darkskipper/\">darkskipper</a> · <a href=\"https://profiles.wordpress.org/uofaberdeendarren/\">Darren Coutts</a> · <a href=\"https://profiles.wordpress.org/htdat/\">Dat Hoang</a> · <a href=\"https://profiles.wordpress.org/datainterlock/\">datainterlock</a> · <a href=\"https://profiles.wordpress.org/dhilditch/\">Dave Hilditch</a> · <a href=\"https://profiles.wordpress.org/dave1010/\">dave1010</a> · <a href=\"https://profiles.wordpress.org/davidanderson/\">David Anderson</a> · <a href=\"https://profiles.wordpress.org/davidbaumwald/\">David Baumwald</a> · <a href=\"https://profiles.wordpress.org/davidbinda/\">David Biňovec</a> · <a href=\"https://profiles.wordpress.org/dcowgill/\">David C</a> · <a href=\"https://profiles.wordpress.org/dpcalhoun/\">David Calhoun</a> · <a href=\"https://profiles.wordpress.org/desmith/\">David E. Smith</a> · <a href=\"https://profiles.wordpress.org/dg12345/\">David Goring</a> · <a href=\"https://profiles.wordpress.org/dgwyer/\">David Gwyer</a> · <a href=\"https://profiles.wordpress.org/dlh/\">David Herrera</a> · <a href=\"https://profiles.wordpress.org/daviedr/\">David Rozando</a> · <a href=\"https://profiles.wordpress.org/get_dave/\">David Smith</a> · <a href=\"https://profiles.wordpress.org/davidvongries/\">David Vongries</a> · <a href=\"https://profiles.wordpress.org/daxelrod/\">daxelrod</a> · <a href=\"https://profiles.wordpress.org/daymobrew/\">daymobrew</a> · <a href=\"https://profiles.wordpress.org/dsas/\">Dean Sas</a> · <a href=\"https://profiles.wordpress.org/deepakvijayan/\">Deepak Vijayan</a> · <a href=\"https://profiles.wordpress.org/denis-de-bernardy/\">Denis de Bernardy</a> · <a href=\"https://profiles.wordpress.org/dingo_d/\">Denis Žoljom</a> · <a href=\"https://profiles.wordpress.org/denishua/\">denishua</a> · <a href=\"https://profiles.wordpress.org/dennisatyoast/\">Dennis Claassen</a> · <a href=\"https://profiles.wordpress.org/dmsnell/\">Dennis Snell</a> · <a href=\"https://profiles.wordpress.org/derekblank/\">derekblank</a> · <a href=\"https://profiles.wordpress.org/pcfreak30/\">Derrick Hammer</a> · <a href=\"https://profiles.wordpress.org/dharm1025/\">Dharmesh Patel</a> · <a href=\"https://profiles.wordpress.org/dhl/\">dhl</a> · <a href=\"https://profiles.wordpress.org/dianeco/\">Diane Co</a> · <a href=\"https://profiles.wordpress.org/dilipbheda/\">Dilip Bheda</a> · <a href=\"https://profiles.wordpress.org/dingdang/\">dingdang</a> · <a href=\"https://profiles.wordpress.org/dd32/\">Dion Hulse</a> · <a href=\"https://profiles.wordpress.org/dipakparmar443/\">Dipak Parmar</a> · <a href=\"https://profiles.wordpress.org/divyeshgodhani/\">divyeshgodhani</a> · <a href=\"https://profiles.wordpress.org/ocean90/\">Dominik Schilling</a> · <a href=\"https://profiles.wordpress.org/donmhico/\">donmhico</a> · <a href=\"https://profiles.wordpress.org/dougwollison/\">Doug Wollison</a> · <a href=\"https://profiles.wordpress.org/dougal/\">Dougal Campbell</a> · <a href=\"https://profiles.wordpress.org/drewapicture/\">Drew Jaynes</a> · <a href=\"https://profiles.wordpress.org/drivingralle/\">Drivingralle</a> · <a href=\"https://profiles.wordpress.org/drzraf/\">drzraf</a> · <a href=\"https://profiles.wordpress.org/dwainm/\">Dwain Maralack</a> · <a href=\"https://profiles.wordpress.org/kucrut/\">Dzikri Aziz</a> · <a href=\"https://profiles.wordpress.org/dovyp/\">Dōvy Paukstys</a> · <a href=\"https://profiles.wordpress.org/eclev91/\">eclev91</a> · <a href=\"https://profiles.wordpress.org/chopinbach/\">Edwin Cromley</a> · <a href=\"https://profiles.wordpress.org/eedee/\">eedee</a> · <a href=\"https://profiles.wordpress.org/ehtis/\">Ehtisham S.</a> · <a href=\"https://profiles.wordpress.org/eliezerspp/\">Eliezer Pe&#241;a</a> · <a href=\"https://profiles.wordpress.org/ellatrix/\">Ella van Durpe</a> · <a href=\"https://profiles.wordpress.org/clarkeemily/\">Emily Clarke</a> · <a href=\"https://profiles.wordpress.org/manooweb/\">Emmanuel Hesry</a> · <a href=\"https://profiles.wordpress.org/lopo/\">Enrico Battocchi</a> · <a href=\"https://profiles.wordpress.org/ethitter/\">Erick Hitter</a> · <a href=\"https://profiles.wordpress.org/codekraft/\">Erik</a> · <a href=\"https://profiles.wordpress.org/kebbet/\">Erik Betshammar</a> · <a href=\"https://profiles.wordpress.org/estelaris/\">Estela Rueda</a> · <a href=\"https://profiles.wordpress.org/manuilov/\">Eugene M</a> · <a href=\"https://profiles.wordpress.org/eugenemanuilov/\">Eugene.Manuilov</a> · <a href=\"https://profiles.wordpress.org/madpixels/\">eugene.manuilov</a> · <a href=\"https://profiles.wordpress.org/eherman24/\">Evan Herman</a> · <a href=\"https://profiles.wordpress.org/aaemnnosttv/\">Evan Mattson</a> · <a href=\"https://profiles.wordpress.org/circlecube/\">Evan Mullins</a> · <a href=\"https://profiles.wordpress.org/fabiankaegy/\">Fabian K&#228;gy</a> · <a href=\"https://profiles.wordpress.org/faisal03/\">Faisal Alvi</a> · <a href=\"https://profiles.wordpress.org/faison/\">Faison</a> · <a href=\"https://profiles.wordpress.org/felipeelia/\">Felipe Elia</a> · <a href=\"https://profiles.wordpress.org/flixos90/\">Felix Arntz</a> · <a href=\"https://profiles.wordpress.org/fellyph/\">Fellyph Cintra</a> · <a href=\"https://profiles.wordpress.org/femkreations/\">Femy Praseeth</a> · <a href=\"https://profiles.wordpress.org/florianbrinkmann/\">Florian Brinkmann</a> · <a href=\"https://profiles.wordpress.org/fpodhorsky/\">fpodhorsky</a> · <a href=\"https://profiles.wordpress.org/fcoveram/\">Francisco</a> · <a href=\"https://profiles.wordpress.org/franz00/\">franzaurus</a> · <a href=\"https://profiles.wordpress.org/fuadragib/\">Fuad Ragib</a> · <a href=\"https://profiles.wordpress.org/furi3r/\">furi3r</a> · <a href=\"https://profiles.wordpress.org/gabri3lmarques/\">gabri3lmarques</a> · <a href=\"https://profiles.wordpress.org/gdetassigny/\">Gabriel de Tassigny</a> · <a href=\"https://profiles.wordpress.org/gabertronic/\">Gabriel Rose</a> · <a href=\"https://profiles.wordpress.org/gamecreature/\">gamecreature</a> · <a href=\"https://profiles.wordpress.org/garrett-eclipse/\">Garrett Hyder</a> · <a href=\"https://profiles.wordpress.org/voldemortensen/\">Garth Mortensen</a> · <a href=\"https://profiles.wordpress.org/garyj/\">Gary Jones</a> · <a href=\"https://profiles.wordpress.org/pento/\">Gary Pendergast</a> · <a href=\"https://profiles.wordpress.org/garymatthews919/\">garymatthews919</a> · <a href=\"https://profiles.wordpress.org/revgeorge/\">George Hotelling</a> · <a href=\"https://profiles.wordpress.org/mamaduka/\">George Mamadashvili</a> · <a href=\"https://profiles.wordpress.org/georgestephanis/\">George Stephanis</a> · <a href=\"https://profiles.wordpress.org/geriux/\">Gerardo Pacheco</a> · <a href=\"https://profiles.wordpress.org/gigitux/\">gigitux</a> · <a href=\"https://profiles.wordpress.org/giox069/\">giox069</a> · <a href=\"https://profiles.wordpress.org/gisgeo/\">gisgeo</a> · <a href=\"https://profiles.wordpress.org/giuseppemazzapica/\">giuseppemazzapica</a> · <a href=\"https://profiles.wordpress.org/glendaviesnz/\">Glen Davies</a> · <a href=\"https://profiles.wordpress.org/goldenapples/\">goldenapples</a> · <a href=\"https://profiles.wordpress.org/greglone/\">Gr&#233;gory Viguier</a> · <a href=\"https://profiles.wordpress.org/graham73may/\">graham73may</a> · <a href=\"https://profiles.wordpress.org/grantmkin/\">Grant M. Kinney</a> · <a href=\"https://profiles.wordpress.org/greg24/\">Greg Niedzielski</a> · <a href=\"https://profiles.wordpress.org/gziolo/\">Greg Ziółkowski</a> · <a href=\"https://profiles.wordpress.org/gregorlove/\">gRegor Morrill</a> · <a href=\"https://profiles.wordpress.org/gunterer/\">gunterer</a> · <a href=\"https://profiles.wordpress.org/bordoni/\">Gustavo Bordoni</a> · <a href=\"https://profiles.wordpress.org/gvgvgvijayan/\">gvgvgvijayan</a> · <a href=\"https://profiles.wordpress.org/h2ham/\">h2ham (Hiromu Hasegawa)</a> · <a href=\"https://profiles.wordpress.org/hakanca/\">hakanca</a> · <a href=\"https://profiles.wordpress.org/hakre/\">hakre</a> · <a href=\"https://profiles.wordpress.org/hansjovisyoast/\">Hans-Christiaan Braun</a> · <a href=\"https://profiles.wordpress.org/thakkarhardik/\">Hardik Thakkar</a> · <a href=\"https://profiles.wordpress.org/haritpanchal/\">Harit Panchal</a> · <a href=\"https://profiles.wordpress.org/harshvaishnav/\">harshvaishnav</a> · <a href=\"https://profiles.wordpress.org/hasanuzzamanshamim/\">Hasanuzzaman</a> · <a href=\"https://profiles.wordpress.org/azhiyadev/\">Hauwa Abashiya</a> · <a href=\"https://profiles.wordpress.org/helen/\">Helen Hou-Sandi</a> · <a href=\"https://profiles.wordpress.org/iamarinoh/\">Henrique Iamarino</a> · <a href=\"https://profiles.wordpress.org/henrywright/\">Henry Wright</a> · <a href=\"https://profiles.wordpress.org/here/\">here</a> · <a href=\"https://profiles.wordpress.org/herregroen/\">Herre Groen</a> · <a href=\"https://profiles.wordpress.org/hilayt24/\">Hilay Trivedi</a> · <a href=\"https://profiles.wordpress.org/hiren1094/\">hiren sanja</a> · <a href=\"https://profiles.wordpress.org/hiyascout/\">hiyascout</a> · <a href=\"https://profiles.wordpress.org/howdy_mcgee/\">Howdy_McGee</a> · <a href=\"https://profiles.wordpress.org/hugodevos/\">hugodevos</a> · <a href=\"https://profiles.wordpress.org/huubl/\">huubl</a> · <a href=\"https://profiles.wordpress.org/hztyfoon/\">hztyfoon</a> · <a href=\"https://profiles.wordpress.org/priethor/\">Héctor Prieto</a> · <a href=\"https://profiles.wordpress.org/ianbelanger/\">Ian Belanger</a> · <a href=\"https://profiles.wordpress.org/iandunn/\">Ian Dunn</a> · <a href=\"https://profiles.wordpress.org/iansvo/\">iansvo</a> · <a href=\"https://profiles.wordpress.org/icaspar/\">iCaspar</a> · <a href=\"https://profiles.wordpress.org/igmoweb/\">Ignacio Cruz Moreno</a> · <a href=\"https://profiles.wordpress.org/igorsch/\">Igor</a> · <a href=\"https://profiles.wordpress.org/igrigorik/\">igrigorik</a> · <a href=\"https://profiles.wordpress.org/ilovecats7/\">ilovecats7</a> · <a href=\"https://profiles.wordpress.org/ilunabar/\">ilunabar</a> · <a href=\"https://profiles.wordpress.org/imadarshakshat/\">imadarshakshat</a> · <a href=\"https://profiles.wordpress.org/innovext/\">Innovext</a> · <a href=\"https://profiles.wordpress.org/ipajen/\">ipajen</a> · <a href=\"https://profiles.wordpress.org/ipstenu/\">Ipstenu (Mika Epstein)</a> · <a href=\"https://profiles.wordpress.org/irecinius/\">irecinius</a> · <a href=\"https://profiles.wordpress.org/isabel_brison/\">Isabel Brison</a> · <a href=\"https://profiles.wordpress.org/iulia-cazan/\">Iulia Cazan</a> · <a href=\"https://profiles.wordpress.org/ivanjeronimo/\">ivanjeronimo</a> · <a href=\"https://profiles.wordpress.org/iviweb/\">iviweb</a> · <a href=\"https://profiles.wordpress.org/jdgrimes/\">J.D. Grimes</a> · <a href=\"https://profiles.wordpress.org/primetimejas/\">Jacob Schweitzer</a> · <a href=\"https://profiles.wordpress.org/jakariaistauk/\">Jakaria Istauk</a> · <a href=\"https://profiles.wordpress.org/outrankjames/\">James</a> · <a href=\"https://profiles.wordpress.org/jameskoster/\">James Koster</a> · <a href=\"https://profiles.wordpress.org/jamesckemp/\">jamesckemp</a> · <a href=\"https://profiles.wordpress.org/jamieburchell/\">jamieburchell</a> · <a href=\"https://profiles.wordpress.org/janthiel/\">Jan Thiel</a> · <a href=\"https://profiles.wordpress.org/jarretc/\">Jarret</a> · <a href=\"https://profiles.wordpress.org/jsnjohnston/\">Jason Johnston</a> · <a href=\"https://profiles.wordpress.org/trapsta/\">Jasper Kinoti</a> · <a href=\"https://profiles.wordpress.org/javiarce/\">Javier Arce</a> · <a href=\"https://profiles.wordpress.org/carazo/\">Javier Carazo</a> · <a href=\"https://profiles.wordpress.org/javiercasares/\">Javier Casares</a> · <a href=\"https://profiles.wordpress.org/grandeljay/\">Jay Trees</a> · <a href=\"https://profiles.wordpress.org/jchambo/\">jchambo</a> · <a href=\"https://profiles.wordpress.org/audrasjb/\">Jean-Baptiste Audras</a> · <a href=\"https://profiles.wordpress.org/jeawhanlee/\">jeawhanlee</a> · <a href=\"https://profiles.wordpress.org/jffng/\">Jeff Ong</a> · <a href=\"https://profiles.wordpress.org/jeffpaul/\">Jeff Paul</a> · <a href=\"https://profiles.wordpress.org/juberstine/\">Jeff Uberstine</a> · <a href=\"https://profiles.wordpress.org/jeremyfelt/\">Jeremy Felt</a> · <a href=\"https://profiles.wordpress.org/jeherve/\">Jeremy Herve</a> · <a href=\"https://profiles.wordpress.org/jeroenreumkens/\">JeroenReumkens</a> · <a href=\"https://profiles.wordpress.org/luminuu/\">Jessica Lyschik</a> · <a href=\"https://profiles.wordpress.org/jhart35/\">jhart35</a> · <a href=\"https://profiles.wordpress.org/jhnstn/\">jhnstn</a> · <a href=\"https://profiles.wordpress.org/jigar-bhanushali/\">jigar bhanushali</a> · <a href=\"https://profiles.wordpress.org/jnz31/\">jnz31</a> · <a href=\"https://profiles.wordpress.org/joedolson/\">Joe Dolson</a> · <a href=\"https://profiles.wordpress.org/joehoyle/\">Joe Hoyle</a> · <a href=\"https://profiles.wordpress.org/joemcgill/\">Joe McGill</a> · <a href=\"https://profiles.wordpress.org/joelhardi/\">joelhardi</a> · <a href=\"https://profiles.wordpress.org/joelmadigan/\">joelmadigan</a> · <a href=\"https://profiles.wordpress.org/joen/\">Joen Asmussen</a> · <a href=\"https://profiles.wordpress.org/johnbillion/\">John Blackbourn</a> · <a href=\"https://profiles.wordpress.org/johnjamesjacoby/\">John James Jacoby</a> · <a href=\"https://profiles.wordpress.org/johnregan3/\">John Regan</a> · <a href=\"https://profiles.wordpress.org/johnwatkins0/\">John Watkins</a> · <a href=\"https://profiles.wordpress.org/johnmark8080/\">johnmark8080</a> · <a href=\"https://profiles.wordpress.org/jb510/\">Jon Brown</a> · <a href=\"https://profiles.wordpress.org/jonsurrell/\">Jon Surrell</a> · <a href=\"https://profiles.wordpress.org/psykro/\">Jonathan Bossenger</a> · <a href=\"https://profiles.wordpress.org/desrosj/\">Jonathan Desrosiers</a> · <a href=\"https://profiles.wordpress.org/jpantani/\">Jonathan Pantani</a> · <a href=\"https://profiles.wordpress.org/jonmackintosh/\">jonmackintosh</a> · <a href=\"https://profiles.wordpress.org/spacedmonkey/\">Jonny Harris</a> · <a href=\"https://profiles.wordpress.org/jonny-s/\">jonny-s</a> · <a href=\"https://profiles.wordpress.org/jonoaldersonwp/\">Jono Alderson</a> · <a href=\"https://profiles.wordpress.org/joostdevalk/\">Joost de Valk</a> · <a href=\"https://profiles.wordpress.org/jorgefilipecosta/\">Jorge Costa</a> · <a href=\"https://profiles.wordpress.org/josvelasco/\">Jos Velasco</a> · <a href=\"https://profiles.wordpress.org/joegrainger/\">Joseph Grainger</a> · <a href=\"https://profiles.wordpress.org/jostnes/\">Josepha Dambul</a> · <a href=\"https://profiles.wordpress.org/chanthaboune/\">Josepha Haden</a> · <a href=\"https://profiles.wordpress.org/jhabdas/\">Josh Habdas</a> · <a href=\"https://profiles.wordpress.org/joshuaabenazer/\">Joshua Abenazer</a> · <a href=\"https://profiles.wordpress.org/joyously/\">Joy</a> · <a href=\"https://profiles.wordpress.org/jrbeilke/\">jrbeilke</a> · <a href=\"https://profiles.wordpress.org/jsh4/\">jsh4</a> · <a href=\"https://profiles.wordpress.org/jsnajdr/\">jsnajdr</a> · <a href=\"https://profiles.wordpress.org/juhise/\">Juhi Saxena</a> · <a href=\"https://profiles.wordpress.org/juliemoynat/\">Julie Moynat</a> · <a href=\"https://profiles.wordpress.org/jrf/\">Juliette Reinders Folmer</a> · <a href=\"https://profiles.wordpress.org/juliobox/\">Julio Potier</a> · <a href=\"https://profiles.wordpress.org/just0nequestion/\">just0nequestion</a> · <a href=\"https://profiles.wordpress.org/justinahinon/\">Justin Ahinon</a> · <a href=\"https://profiles.wordpress.org/justinsainton/\">Justin Sainton</a> · <a href=\"https://profiles.wordpress.org/greenshady/\">Justin Tadlock</a> · <a href=\"https://profiles.wordpress.org/welenofsky/\">Justin Welenofsky</a> · <a href=\"https://profiles.wordpress.org/jyolsna/\">jyolsna</a> · <a href=\"https://profiles.wordpress.org/kadamwhite/\">K. Adam White</a> · <a href=\"https://profiles.wordpress.org/kacper3355/\">kacper3355</a> · <a href=\"https://profiles.wordpress.org/kafleg/\">KafleG</a> · <a href=\"https://profiles.wordpress.org/kevin940726/\">Kai Hao</a> · <a href=\"https://profiles.wordpress.org/kajalgohel/\">Kajal Gohel</a> · <a href=\"https://profiles.wordpress.org/akabarikalpesh/\">Kalpesh Akabari</a> · <a href=\"https://profiles.wordpress.org/kapilpaul/\">Kapil Paul</a> · <a href=\"https://profiles.wordpress.org/karinclimber/\">Kari Anderson</a> · <a href=\"https://profiles.wordpress.org/karlgroves/\">karlgroves</a> · <a href=\"https://profiles.wordpress.org/karlijnbk/\">Karlijn Bok</a> · <a href=\"https://profiles.wordpress.org/kasparsd/\">Kaspars</a> · <a href=\"https://profiles.wordpress.org/zoonini/\">Kathryn Presner</a> · <a href=\"https://profiles.wordpress.org/kbrownkd/\">kbrownkd</a> · <a href=\"https://profiles.wordpress.org/kkoppenhaver/\">Keanan Koppenhaver</a> · <a href=\"https://profiles.wordpress.org/ryelle/\">Kelly Choyce-Dwan</a> · <a href=\"https://profiles.wordpress.org/kellychoffman/\">Kelly Hoffman</a> · <a href=\"https://profiles.wordpress.org/kevinb/\">Kevin Behrens</a> · <a href=\"https://profiles.wordpress.org/khag7/\">Kevin Hagerty</a> · <a href=\"https://profiles.wordpress.org/khoipro/\">Khoi Pro</a> · <a href=\"https://profiles.wordpress.org/khokansardar/\">Khokan Sardar</a> · <a href=\"https://profiles.wordpress.org/killua99/\">killua99</a> · <a href=\"https://profiles.wordpress.org/kishanjasani/\">Kishan Jasani</a> · <a href=\"https://profiles.wordpress.org/kitchin/\">kitchin</a> · <a href=\"https://profiles.wordpress.org/kjellr/\">Kjell Reigstad</a> · <a href=\"https://profiles.wordpress.org/kkmuffme/\">kkmuffme</a> · <a href=\"https://profiles.wordpress.org/blackawxs/\">klewis</a> · <a href=\"https://profiles.wordpress.org/knutsp/\">Knut Sparhell</a> · <a href=\"https://profiles.wordpress.org/vdwijngaert/\">Koen Van den Wijngaert</a> · <a href=\"https://profiles.wordpress.org/konradyoast/\">Konrad.K</a> · <a href=\"https://profiles.wordpress.org/kovshenin/\">Konstantin Kovshenin</a> · <a href=\"https://profiles.wordpress.org/obenland/\">Konstantin Obenland</a> · <a href=\"https://profiles.wordpress.org/konyoldeath/\">konyoldeath</a> · <a href=\"https://profiles.wordpress.org/kanlukasz/\">Kris Kelvin</a> · <a href=\"https://profiles.wordpress.org/krishaweb/\">KrishaWeb</a> · <a href=\"https://profiles.wordpress.org/krupalpanchal/\">Krupal Panchal</a> · <a href=\"https://profiles.wordpress.org/kmadhak/\">Kunal Madhak</a> · <a href=\"https://profiles.wordpress.org/kurtpayne/\">Kurt Payne</a> · <a href=\"https://profiles.wordpress.org/kwillmorth/\">kwillmorth</a> · <a href=\"https://profiles.wordpress.org/kbjohnson90/\">Kyle B. Johnson</a> · <a href=\"https://profiles.wordpress.org/devnel/\">Kyle Nel</a> · <a href=\"https://profiles.wordpress.org/larsmqller/\">larsmqller</a> · <a href=\"https://profiles.wordpress.org/laurelfulford/\">laurelfulford</a> · <a href=\"https://profiles.wordpress.org/laurlittle/\">Lauren Stein</a> · <a href=\"https://profiles.wordpress.org/laurent22777/\">laurent22777</a> · <a href=\"https://profiles.wordpress.org/lazam786/\">lazam786</a> · <a href=\"https://profiles.wordpress.org/leewillis77/\">Lee Willis</a> · <a href=\"https://profiles.wordpress.org/leemon/\">leemon</a> · <a href=\"https://profiles.wordpress.org/0mirka00/\">Lena Morita</a> · <a href=\"https://profiles.wordpress.org/leonidasmilossis/\">Leo Milo</a> · <a href=\"https://profiles.wordpress.org/leogermani/\">leogermani</a> · <a href=\"https://profiles.wordpress.org/rudlinkon/\">Linkon Miyan</a> · <a href=\"https://profiles.wordpress.org/linsoftware/\">Linnea Huxford</a> · <a href=\"https://profiles.wordpress.org/lonnylot/\">lonnylot</a> · <a href=\"https://profiles.wordpress.org/thelovekesh/\">Lovekesh Kumar</a> · <a href=\"https://profiles.wordpress.org/lovor/\">Lovro Hrust</a> · <a href=\"https://profiles.wordpress.org/lozula/\">lozula</a> · <a href=\"https://profiles.wordpress.org/lucasbustamante/\">Lucas Bustamante</a> · <a href=\"https://profiles.wordpress.org/lucilastancato/\">lucilastancato</a> · <a href=\"https://profiles.wordpress.org/luigipulcini/\">luigipulcini</a> · <a href=\"https://profiles.wordpress.org/zaguiini/\">Luis Felipe Zaguini</a> · <a href=\"https://profiles.wordpress.org/luisherranz/\">luisherranz</a> · <a href=\"https://profiles.wordpress.org/infolu/\">Luiz Ara&#250;jo</a> · <a href=\"https://profiles.wordpress.org/mitweka/\">Lukas Niebler</a> · <a href=\"https://profiles.wordpress.org/lukecavanagh/\">Luke Cavanagh</a> · <a href=\"https://profiles.wordpress.org/msnewas/\">M S Newaz</a> · <a href=\"https://profiles.wordpress.org/maartenj/\">Maarten</a> · <a href=\"https://profiles.wordpress.org/mashikag/\">Maciej</a> · <a href=\"https://profiles.wordpress.org/maciejmackowiak/\">maciejmackowiak</a> · <a href=\"https://profiles.wordpress.org/mrdollu/\">Madhu Dollu</a> · <a href=\"https://profiles.wordpress.org/madhudollu/\">Madhu Dollu</a> · <a href=\"https://profiles.wordpress.org/onemaggie/\">Maggie Cabrera</a> · <a href=\"https://profiles.wordpress.org/maahrokh/\">Mahrokh</a> · <a href=\"https://profiles.wordpress.org/maksimkuzmin/\">maksimkuzmin</a> · <a href=\"https://profiles.wordpress.org/malthert/\">malthert</a> · <a href=\"https://profiles.wordpress.org/manfcarlo/\">manfcarlo</a> · <a href=\"https://profiles.wordpress.org/manishsongirkar36/\">Manish Songirkar</a> · <a href=\"https://profiles.wordpress.org/manzoorwanijk/\">Manzoor Wani</a> · <a href=\"https://profiles.wordpress.org/manzurahammed/\">Manzur Ahammed</a> · <a href=\"https://profiles.wordpress.org/marcyoast/\">Marc</a> · <a href=\"https://profiles.wordpress.org/fullofcaffeine/\">Marcelo de Moraes Serpa</a> · <a href=\"https://profiles.wordpress.org/mciampini/\">Marco Ciampini</a> · <a href=\"https://profiles.wordpress.org/mkaz/\">Marcus Kazmierczak</a> · <a href=\"https://profiles.wordpress.org/marekdedic/\">Marek Dědič</a> · <a href=\"https://profiles.wordpress.org/nuryko/\">Marianna</a> · <a href=\"https://profiles.wordpress.org/chaton666/\">Marie Comet</a> · <a href=\"https://profiles.wordpress.org/tyxla/\">Marin Atanasov</a> · <a href=\"https://profiles.wordpress.org/santosguillamot/\">Mario Santos</a> · <a href=\"https://profiles.wordpress.org/clorith/\">Marius L. J.</a> · <a href=\"https://profiles.wordpress.org/markbiek/\">Mark Biek</a> · <a href=\"https://profiles.wordpress.org/markhowellsmead/\">Mark Howells-Mead</a> · <a href=\"https://profiles.wordpress.org/markjaquith/\">Mark Jaquith</a> · <a href=\"https://profiles.wordpress.org/markparnell/\">Mark Parnell</a> · <a href=\"https://profiles.wordpress.org/markoheijnen/\">Marko Heijnen</a> · <a href=\"https://profiles.wordpress.org/flootr/\">Markus</a> · <a href=\"https://profiles.wordpress.org/mkox/\">Markus Kosmal</a> · <a href=\"https://profiles.wordpress.org/mhkuu/\">Martijn van der Klis</a> · <a href=\"https://profiles.wordpress.org/hinjiriyo/\">Martin Stehle</a> · <a href=\"https://profiles.wordpress.org/martinkrcho/\">martin.krcho</a> · <a href=\"https://profiles.wordpress.org/marybaum/\">Mary Baum</a> · <a href=\"https://profiles.wordpress.org/mashukushibiki/\">Mashu</a> · <a href=\"https://profiles.wordpress.org/masteradhoc/\">masteradhoc</a> · <a href=\"https://profiles.wordpress.org/msurdi/\">Mat&#237;as Emanuel Surdi</a> · <a href=\"https://profiles.wordpress.org/matveb/\">Matias Ventura</a> · <a href=\"https://profiles.wordpress.org/mmaattiiaass/\">matiasbenedetto</a> · <a href=\"https://profiles.wordpress.org/mattchowning/\">Matt Chowning</a> · <a href=\"https://profiles.wordpress.org/mattkeys/\">Matt Keys</a> · <a href=\"https://profiles.wordpress.org/matt/\">Matt Mullenweg</a> · <a href=\"https://profiles.wordpress.org/mattwondra/\">Matt Wondra</a> · <a href=\"https://profiles.wordpress.org/mboynes/\">Matthew Boynes</a> · <a href=\"https://profiles.wordpress.org/mattheweppelsheimer/\">Matthew Eppelsheimer</a> · <a href=\"https://profiles.wordpress.org/matthiaspabst/\">Matthias Pabst</a> · <a href=\"https://profiles.wordpress.org/matthiasreinholz/\">Matthias Reinholz</a> · <a href=\"https://profiles.wordpress.org/mattyrob/\">mattyrob</a> · <a href=\"https://profiles.wordpress.org/azouamauriac/\">Mauriac AZOUA</a> · <a href=\"https://profiles.wordpress.org/maximej/\">Maxime J.</a> · <a href=\"https://profiles.wordpress.org/maximemeganck/\">Maxime Meganck</a> · <a href=\"https://profiles.wordpress.org/mayankmajeji/\">Mayank Majeji</a> · <a href=\"https://profiles.wordpress.org/maythamalsudany/\">maythamalsudany</a> · <a href=\"https://profiles.wordpress.org/mayuge/\">Mayuge</a> · <a href=\"https://profiles.wordpress.org/mcliwanow/\">mcliwanow</a> · <a href=\"https://profiles.wordpress.org/rakibwordpress/\">Md Rakib Hossain</a> · <a href=\"https://profiles.wordpress.org/russel07/\">Md. Russel Hussain</a> · <a href=\"https://profiles.wordpress.org/mdrago/\">mdrago</a> · <a href=\"https://profiles.wordpress.org/mehedi890/\">Mehedi Foysal</a> · <a href=\"https://profiles.wordpress.org/meher/\">Meher Bala</a> · <a href=\"https://profiles.wordpress.org/mehulkaklotar/\">Mehul Kaklotar</a> · <a href=\"https://profiles.wordpress.org/melchoyce/\">Mel Choyce-Dwan</a> · <a href=\"https://profiles.wordpress.org/meloniq/\">meloniq</a> · <a href=\"https://profiles.wordpress.org/merkys/\">Merkys Maliukevičius</a> · <a href=\"https://profiles.wordpress.org/meysamnorouzi/\">meysam norouzi</a> · <a href=\"https://profiles.wordpress.org/mfgmicha/\">Micha Krapp</a> · <a href=\"https://profiles.wordpress.org/michaelbourne/\">Michael Bourne</a> · <a href=\"https://profiles.wordpress.org/mburridge/\">Michael Burridge</a> · <a href=\"https://profiles.wordpress.org/czapla/\">Michal Czaplinski</a> · <a href=\"https://profiles.wordpress.org/miguelaxcar/\">Miguel Axcar</a> · <a href=\"https://profiles.wordpress.org/mcsf/\">Miguel Fonseca</a> · <a href=\"https://profiles.wordpress.org/mihaidumitrascu/\">Mihai Dumitrascu</a> · <a href=\"https://profiles.wordpress.org/mihai2u/\">Mike Crantea</a> · <a href=\"https://profiles.wordpress.org/mdgl/\">Mike Glendinning</a> · <a href=\"https://profiles.wordpress.org/mikehansenme/\">Mike Hansen</a> · <a href=\"https://profiles.wordpress.org/mikejolley/\">Mike Jolley (a11n)</a> · <a href=\"https://profiles.wordpress.org/mikeschroder/\">Mike Schroder</a> · <a href=\"https://profiles.wordpress.org/mikemanzo/\">mikemanzo</a> · <a href=\"https://profiles.wordpress.org/milana_cap/\">Milana Cap</a> · <a href=\"https://profiles.wordpress.org/milindmore22/\">Milind More</a> · <a href=\"https://profiles.wordpress.org/mimitips/\">mimi</a> · <a href=\"https://profiles.wordpress.org/multidots1896/\">Minal Diwan</a> · <a href=\"https://profiles.wordpress.org/presents111/\">miya</a> · <a href=\"https://profiles.wordpress.org/mlajo/\">Mladen</a> · <a href=\"https://profiles.wordpress.org/batmoo/\">Mohammad Jangda</a> · <a href=\"https://profiles.wordpress.org/mjkhajeh/\">MohammadJafar Khajeh</a> · <a href=\"https://profiles.wordpress.org/mohitdadhich10/\">Mohit Dadhich</a> · <a href=\"https://profiles.wordpress.org/boemedia/\">Monique Dubbelman</a> · <a href=\"https://profiles.wordpress.org/mt8biz/\">moto hachi</a> · <a href=\"https://profiles.wordpress.org/mreishus/\">mreishus</a> · <a href=\"https://profiles.wordpress.org/mrobit/\">mrobit</a> · <a href=\"https://profiles.wordpress.org/msolution/\">msolution</a> · <a href=\"https://profiles.wordpress.org/mtias/\">mtias</a> · <a href=\"https://profiles.wordpress.org/wparslan/\">Muhammad Arslan</a> · <a href=\"https://profiles.wordpress.org/mukesh27/\">Mukesh Panchal</a> · <a href=\"https://profiles.wordpress.org/mmaumio/\">Muntasir Mahmud</a> · <a href=\"https://profiles.wordpress.org/amustaque97/\">Mustaque Ahmed</a> · <a href=\"https://profiles.wordpress.org/mvraghavan/\">mvraghavan</a> · <a href=\"https://profiles.wordpress.org/mw108/\">mw108</a> · <a href=\"https://profiles.wordpress.org/mweichert/\">mweichert</a> · <a href=\"https://profiles.wordpress.org/n8finch/\">n8finch</a> · <a href=\"https://profiles.wordpress.org/tushar284/\">Nahid Hasan</a> · <a href=\"https://profiles.wordpress.org/nalininonstopnewsuk/\">Nalini Thakor</a> · <a href=\"https://profiles.wordpress.org/namithjawahar/\">Namith Jawahar</a> · <a href=\"https://profiles.wordpress.org/nareshbheda/\">Naresh Bheda</a> · <a href=\"https://profiles.wordpress.org/nateallen/\">Nate Allen</a> · <a href=\"https://profiles.wordpress.org/nhadsall/\">Nathan</a> · <a href=\"https://profiles.wordpress.org/nathanatmoz/\">Nathan Johnson</a> · <a href=\"https://profiles.wordpress.org/navigatrum/\">navigatrum</a> · <a href=\"https://profiles.wordpress.org/neffff/\">neffff</a> · <a href=\"https://profiles.wordpress.org/nendeb55/\">nendeb</a> · <a href=\"https://profiles.wordpress.org/neychok/\">Neycho Kalaydzhiev</a> · <a href=\"https://profiles.wordpress.org/eidolonnight/\">Nicholas Garofalo</a> · <a href=\"https://profiles.wordpress.org/ndiego/\">Nick Diego</a> · <a href=\"https://profiles.wordpress.org/celloexpressions/\">Nick Halsey</a> · <a href=\"https://profiles.wordpress.org/nico23/\">Nico</a> · <a href=\"https://profiles.wordpress.org/nidhidhandhukiya/\">nidhidhandhukiya</a> · <a href=\"https://profiles.wordpress.org/ntsekouras/\">Nik Tsekouras</a> · <a href=\"https://profiles.wordpress.org/nikkigagency/\">nikkigagency</a> · <a href=\"https://profiles.wordpress.org/im_niloy/\">Niloy</a> · <a href=\"https://profiles.wordpress.org/ninos-ego/\">Ninos</a> · <a href=\"https://profiles.wordpress.org/nithi22/\">Nithin John</a> · <a href=\"https://profiles.wordpress.org/nithins53/\">Nithin SreeRaj</a> · <a href=\"https://profiles.wordpress.org/nlpro/\">nlpro</a> · <a href=\"https://profiles.wordpress.org/noahtallen/\">Noah Allen</a> · <a href=\"https://profiles.wordpress.org/noplanman/\">noplanman</a> · <a href=\"https://profiles.wordpress.org/nouarah/\">nouarah</a> · <a href=\"https://profiles.wordpress.org/numidwasnotavailable/\">NumidWasNotAvailable</a> · <a href=\"https://profiles.wordpress.org/nunomorgadinho/\">nunomorgadinho</a> · <a href=\"https://profiles.wordpress.org/zikubd/\">Nurul Umbhiya</a> · <a href=\"https://profiles.wordpress.org/nuvopoint/\">nuvoPoint</a> · <a href=\"https://profiles.wordpress.org/nvartolomei/\">nvartolomei</a> · <a href=\"https://profiles.wordpress.org/oakesjosh/\">oakesjosh</a> · <a href=\"https://profiles.wordpress.org/obayedmamur/\">Obayed Mamur</a> · <a href=\"https://profiles.wordpress.org/obliviousharmony/\">obliviousharmony</a> · <a href=\"https://profiles.wordpress.org/ockham/\">ockham</a> · <a href=\"https://profiles.wordpress.org/oguzkocer/\">oguzkocer</a> · <a href=\"https://profiles.wordpress.org/oglekler/\">Olga Gleckler</a> · <a href=\"https://profiles.wordpress.org/oliverstapelfeldt/\">Oliver Stapelfeldt</a> · <a href=\"https://profiles.wordpress.org/olliejones/\">OllieJones</a> · <a href=\"https://profiles.wordpress.org/oneearth27/\">oneearth27</a> · <a href=\"https://profiles.wordpress.org/onnimonni/\">Onni Hakala</a> · <a href=\"https://profiles.wordpress.org/opr18/\">opr18</a> · <a href=\"https://profiles.wordpress.org/ovidiul/\">ovidiul</a> · <a href=\"https://profiles.wordpress.org/p_enrique/\">p_enrique</a> · <a href=\"https://profiles.wordpress.org/paaljoachim/\">Paal Joachim Romdahl</a> · <a href=\"https://profiles.wordpress.org/poliuk/\">Pablo Postigo</a> · <a href=\"https://profiles.wordpress.org/pablohoney/\">PabloHoney</a> · <a href=\"https://profiles.wordpress.org/palmiak/\">palmiak</a> · <a href=\"https://profiles.wordpress.org/pls78/\">Paolo L. Scala</a> · <a href=\"https://profiles.wordpress.org/paragoninitiativeenterprises/\">Paragon Initiative Enterprises</a> · <a href=\"https://profiles.wordpress.org/xparham/\">Parham Ghaffarian</a> · <a href=\"https://profiles.wordpress.org/swissspidy/\">Pascal Birchler</a> · <a href=\"https://profiles.wordpress.org/patrickgroot/\">Patrick Groot</a> · <a href=\"https://profiles.wordpress.org/pbearne/\">Paul Bearne</a> · <a href=\"https://profiles.wordpress.org/pbiron/\">Paul Biron</a> · <a href=\"https://profiles.wordpress.org/paulkevan/\">Paul Kevan</a> · <a href=\"https://profiles.wordpress.org/figureone/\">Paul Ryan</a> · <a href=\"https://profiles.wordpress.org/paulohcruz/\">Paulo Cruz</a> · <a href=\"https://profiles.wordpress.org/paulopmt1/\">Paulo Trentin</a> · <a href=\"https://profiles.wordpress.org/pavanpatil1/\">Pavan Patil</a> · <a href=\"https://profiles.wordpress.org/pavelschoffer/\">pavelschoffer</a> · <a href=\"https://profiles.wordpress.org/pbking/\">pbking</a> · <a href=\"https://profiles.wordpress.org/pedromendonca/\">Pedro Mendon&#231;a</a> · <a href=\"https://profiles.wordpress.org/westi/\">Peter Westwood</a> · <a href=\"https://profiles.wordpress.org/peterwilsoncc/\">Peter Wilson</a> · <a href=\"https://profiles.wordpress.org/petitphp/\">petitphp</a> · <a href=\"https://profiles.wordpress.org/walbo/\">Petter Walbø Johnsgård</a> · <a href=\"https://profiles.wordpress.org/johnstonphilip/\">Phil Johnston</a> · <a href=\"https://profiles.wordpress.org/phillsav/\">Phill</a> · <a href=\"https://profiles.wordpress.org/strategio/\">Pierre Sylvestre</a> · <a href=\"https://profiles.wordpress.org/nekojonez/\">Pieterjan Deneys</a> · <a href=\"https://profiles.wordpress.org/boniu91/\">Piotrek Boniu</a> · <a href=\"https://profiles.wordpress.org/mordauk/\">Pippin Williamson</a> · <a href=\"https://profiles.wordpress.org/pkolenbr/\">pkolenbr</a> · <a href=\"https://profiles.wordpress.org/webtechpooja/\">Pooja Derashri</a> · <a href=\"https://profiles.wordpress.org/pooja1210/\">Pooja N Muchandikar</a> · <a href=\"https://profiles.wordpress.org/praful2111/\">Praful Patel</a> · <a href=\"https://profiles.wordpress.org/pratiweb/\">Pratiksha</a> · <a href=\"https://profiles.wordpress.org/nikeo/\">presscustomizr</a> · <a href=\"https://profiles.wordpress.org/presskopp/\">Presskopp</a> · <a href=\"https://profiles.wordpress.org/presstoke/\">presstoke</a> · <a href=\"https://profiles.wordpress.org/priyomukul/\">Priyo Mukul</a> · <a href=\"https://profiles.wordpress.org/prokium/\">prokium</a> · <a href=\"https://profiles.wordpress.org/pypwalters/\">pypwalters</a> · <a href=\"https://profiles.wordpress.org/itsjonq/\">Q</a> · <a href=\"https://profiles.wordpress.org/rachelbaker/\">Rachel Baker</a> · <a href=\"https://profiles.wordpress.org/larrach/\">Rachel Peter</a> · <a href=\"https://profiles.wordpress.org/raduiason/\">raduiason</a> · <a href=\"https://profiles.wordpress.org/rafiahmedd/\">Rafi Ahmed</a> · <a href=\"https://profiles.wordpress.org/tan007/\">Rahi Prajapati</a> · <a href=\"https://profiles.wordpress.org/rajanpanchal2028/\">Rajan Panchal</a> · <a href=\"https://profiles.wordpress.org/rajeshraval786/\">Rajesh Raval</a> · <a href=\"https://profiles.wordpress.org/ralucastn/\">ralucastn</a> · <a href=\"https://profiles.wordpress.org/superpoincare/\">Ramanan</a> · <a href=\"https://profiles.wordpress.org/rahmohn/\">Ramon Ahnert</a> · <a href=\"https://profiles.wordpress.org/rcorrales/\">Ramon Corrales</a> · <a href=\"https://profiles.wordpress.org/ramon-fincken/\">ramon fincken</a> · <a href=\"https://profiles.wordpress.org/ramonopoly/\">Ramon James</a> · <a href=\"https://profiles.wordpress.org/randhirexpresstech/\">Randhir Jha</a> · <a href=\"https://profiles.wordpress.org/ravipatel/\">Ravikumar Patel</a> · <a href=\"https://profiles.wordpress.org/rcanepa/\">rcanepa</a> · <a href=\"https://profiles.wordpress.org/rebasaurus/\">rebasaurus</a> · <a href=\"https://profiles.wordpress.org/rehanali/\">Rehan Ali</a> · <a href=\"https://profiles.wordpress.org/tabrisrp/\">Remy Perona</a> · <a href=\"https://profiles.wordpress.org/renathoc/\">Renatho (a11n)</a> · <a href=\"https://profiles.wordpress.org/renegeuze/\">renegeuze</a> · <a href=\"https://profiles.wordpress.org/laboiteare/\">Reuhno</a> · <a href=\"https://profiles.wordpress.org/rflw/\">rflw</a> · <a href=\"https://profiles.wordpress.org/youknowriad/\">Riad Benguella</a> · <a href=\"https://profiles.wordpress.org/richtabor/\">Rich Tabor</a> · <a href=\"https://profiles.wordpress.org/rinatkhaziev/\">Rinat</a> · <a href=\"https://profiles.wordpress.org/rinkychowdhury9/\">Rinky Chowdhury</a> · <a href=\"https://profiles.wordpress.org/rishishah/\">Rishi Shah</a> · <a href=\"https://profiles.wordpress.org/rjasdfiii/\">rjasdfiii</a> · <a href=\"https://profiles.wordpress.org/rkaiser0324/\">rkaiser0324</a> · <a href=\"https://profiles.wordpress.org/noisysocks/\">Robert Anderson</a> · <a href=\"https://profiles.wordpress.org/miqrogroove/\">Robert Chapin</a> · <a href=\"https://profiles.wordpress.org/robertghetau/\">robertght</a> · <a href=\"https://profiles.wordpress.org/robinwpdeveloper/\">Robin</a> · <a href=\"https://profiles.wordpress.org/robmiller/\">robmiller</a> · <a href=\"https://profiles.wordpress.org/rodricus/\">rodricus</a> · <a href=\"https://profiles.wordpress.org/rodrigosevero/\">rodrigosevero</a> · <a href=\"https://profiles.wordpress.org/ravanh/\">Rolf Allard van Hagen</a> · <a href=\"https://profiles.wordpress.org/rolfsiebers/\">Rolf Siebers</a> · <a href=\"https://profiles.wordpress.org/rollybueno/\">rollybueno</a> · <a href=\"https://profiles.wordpress.org/rherault/\">Romain Herault</a> · <a href=\"https://profiles.wordpress.org/romulodl/\">romulodl</a> · <a href=\"https://profiles.wordpress.org/ross_ritchey/\">ross_ritchey</a> · <a href=\"https://profiles.wordpress.org/lev0/\">Roy</a> · <a href=\"https://profiles.wordpress.org/geekstreetwp/\">Russell Aaron</a> · <a href=\"https://profiles.wordpress.org/ryan/\">Ryan Boren</a> · <a href=\"https://profiles.wordpress.org/ryankienstra/\">Ryan Kienstra</a> · <a href=\"https://profiles.wordpress.org/rmccue/\">Ryan McCue</a> · <a href=\"https://profiles.wordpress.org/ryanmurphy/\">Ryan Murphy</a> · <a href=\"https://profiles.wordpress.org/welcher/\">Ryan Welcher</a> · <a href=\"https://profiles.wordpress.org/sebastienserre/\">S&#233;bastien SERRE</a> · <a href=\"https://profiles.wordpress.org/sergiomdgomes/\">S&#233;rgio Gomes</a> · <a href=\"https://profiles.wordpress.org/soean/\">S&#246;ren Wrede</a> · <a href=\"https://profiles.wordpress.org/sabbirmc/\">Sabbir Ahmed</a> · <a href=\"https://profiles.wordpress.org/sajjad67/\">Sajjad Hossain Sagor</a> · <a href=\"https://profiles.wordpress.org/saggre/\">Sakri Koskimies</a> · <a href=\"https://profiles.wordpress.org/samikeijonen/\">Sami Keijonen</a> · <a href=\"https://profiles.wordpress.org/viralsampat/\">Sampat Viral</a> · <a href=\"https://profiles.wordpress.org/otto42/\">Samuel Wood (Otto)</a> · <a href=\"https://profiles.wordpress.org/sandipmondal/\">Sandip Mondal - a11n</a> · <a href=\"https://profiles.wordpress.org/sandrasanzdev/\">Sandra Sanz</a> · <a href=\"https://profiles.wordpress.org/mikachan/\">Sarah Norris</a> · <a href=\"https://profiles.wordpress.org/sarahricker/\">sarahricker</a> · <a href=\"https://profiles.wordpress.org/sathyapulse/\">Sathiyamoorthy V</a> · <a href=\"https://profiles.wordpress.org/isaumya/\">Saumya Majumder</a> · <a href=\"https://profiles.wordpress.org/xconsau/\">Saurabh Sharma</a> · <a href=\"https://profiles.wordpress.org/scofennellgmailcom/\">Scott Fennell</a> · <a href=\"https://profiles.wordpress.org/sc0ttkclark/\">Scott Kingsley Clark</a> · <a href=\"https://profiles.wordpress.org/gmagicscott/\">Scott Lesovic</a> · <a href=\"https://profiles.wordpress.org/wonderboymusic/\">Scott Taylor</a> · <a href=\"https://profiles.wordpress.org/scribu/\">scribu</a> · <a href=\"https://profiles.wordpress.org/sean212/\">Sean Fisher</a> · <a href=\"https://profiles.wordpress.org/sebastianpisula/\">Sebastian Pisula</a> · <a href=\"https://profiles.wordpress.org/monolithon/\">seieric</a> · <a href=\"https://profiles.wordpress.org/sergeybiryukov/\">Sergey Biryukov</a> · <a href=\"https://profiles.wordpress.org/seedsca/\">Sergio Scabuzzo</a> · <a href=\"https://profiles.wordpress.org/seriouslysenpai/\">seriouslysenpai</a> · <a href=\"https://profiles.wordpress.org/sethta/\">Seth Alling</a> · <a href=\"https://profiles.wordpress.org/shanjidah/\">shangidah afroz</a> · <a href=\"https://profiles.wordpress.org/enchiridion/\">Shannon Little</a> · <a href=\"https://profiles.wordpress.org/sharjeelkhanvmi/\">Sharjeel Khan</a> · <a href=\"https://profiles.wordpress.org/shoaibkarimali/\">Shoaib Ali</a> · <a href=\"https://profiles.wordpress.org/shraboni/\">Shraboni</a> · <a href=\"https://profiles.wordpress.org/shreyasikhar26/\">Shreyas Ikhar</a> · <a href=\"https://profiles.wordpress.org/shuvo586/\">shuvo586</a> · <a href=\"https://profiles.wordpress.org/rsiddharth/\">siddharth ravikumar</a> · <a href=\"https://profiles.wordpress.org/nomnom99/\">Siddharth Thevaril</a> · <a href=\"https://profiles.wordpress.org/siobhyb/\">Siobhan</a> · <a href=\"https://profiles.wordpress.org/sirzooro/\">sirzooro</a> · <a href=\"https://profiles.wordpress.org/slaffik/\">Slava Abakumov</a> · <a href=\"https://profiles.wordpress.org/slobodanmanic/\">Slobodan Manic</a> · <a href=\"https://profiles.wordpress.org/smit08/\">Smit Rathod</a> · <a href=\"https://profiles.wordpress.org/sobatkras/\">sobatkras</a> · <a href=\"https://profiles.wordpress.org/khromov/\">Stanislav Khromov</a> · <a href=\"https://profiles.wordpress.org/steelwagstaff/\">SteelWagstaff</a> · <a href=\"https://profiles.wordpress.org/ste_95/\">Stefano</a> · <a href=\"https://profiles.wordpress.org/ryokuhi/\">Stefano Minoia</a> · <a href=\"https://profiles.wordpress.org/hypest/\">Stefanos Togoulidis</a> · <a href=\"https://profiles.wordpress.org/stentibbing/\">stentibbing</a> · <a href=\"https://profiles.wordpress.org/sabernhardt/\">Stephen Bernhardt</a> · <a href=\"https://profiles.wordpress.org/netweb/\">Stephen Edgar</a> · <a href=\"https://profiles.wordpress.org/camwynsp/\">Stephen Page</a> · <a href=\"https://profiles.wordpress.org/sterlo/\">Sterling Hamilton</a> · <a href=\"https://profiles.wordpress.org/stevenlinx/\">Steven Lin</a> · <a href=\"https://profiles.wordpress.org/steveo2000/\">steveo2000</a> · <a href=\"https://profiles.wordpress.org/studiolxv/\">studiolxv</a> · <a href=\"https://profiles.wordpress.org/subrataemfluence/\">Subrata Sarkar</a> · <a href=\"https://profiles.wordpress.org/sumitbagthariya16/\">Sumit Bagthariya</a> · <a href=\"https://profiles.wordpress.org/sumitsingh/\">Sumit Singh</a> · <a href=\"https://profiles.wordpress.org/5um17/\">Sumit Singh</a> · <a href=\"https://profiles.wordpress.org/csesumonpro/\">Sumon Sarker</a> · <a href=\"https://profiles.wordpress.org/sunil25393/\">SunilPrajapati</a> · <a href=\"https://profiles.wordpress.org/sunyatasattva/\">sunyatasattva</a> · <a href=\"https://profiles.wordpress.org/cybr/\">Sybre Waaijer</a> · <a href=\"https://profiles.wordpress.org/synchro/\">Synchro</a> · <a href=\"https://profiles.wordpress.org/system909/\">system909</a> · <a href=\"https://profiles.wordpress.org/tahmidulkarim/\">Tahmid ul Karim</a> · <a href=\"https://profiles.wordpress.org/inc2734/\">Takashi Kitajima</a> · <a href=\"https://profiles.wordpress.org/karmatosed/\">Tammie Lister</a> · <a href=\"https://profiles.wordpress.org/devtanbir/\">Tanbir Ahmod</a> · <a href=\"https://profiles.wordpress.org/tanvirul/\">Tanvirul Haque</a> · <a href=\"https://profiles.wordpress.org/taskotr/\">Taras Dashkevych</a> · <a href=\"https://profiles.wordpress.org/targz/\">targz</a> · <a href=\"https://profiles.wordpress.org/tlovett1/\">Taylor Lovett</a> · <a href=\"https://profiles.wordpress.org/tazotodua/\">tazotodua</a> · <a href=\"https://profiles.wordpress.org/tbember/\">tbember</a> · <a href=\"https://profiles.wordpress.org/tykoted/\">Teddy Patriarca</a> · <a href=\"https://profiles.wordpress.org/tellyworth/\">Tellyworth</a> · <a href=\"https://profiles.wordpress.org/edent/\">Terence Eden</a> · <a href=\"https://profiles.wordpress.org/tharsheblows/\">tharsheblows</a> · <a href=\"https://profiles.wordpress.org/iamjaydip/\">thejaydip</a> · <a href=\"https://profiles.wordpress.org/tweetythierry/\">Thierry Muller</a> · <a href=\"https://profiles.wordpress.org/thijso/\">Thijs</a> · <a href=\"https://profiles.wordpress.org/griffinjt/\">Thomas Griffin</a> · <a href=\"https://profiles.wordpress.org/hyperbrand/\">Thorsten Schraut</a> · <a href=\"https://profiles.wordpress.org/threadi/\">threadi</a> · <a href=\"https://profiles.wordpress.org/baxbridge/\">Tiffany Bridge</a> · <a href=\"https://profiles.wordpress.org/tillkruess/\">Till Kr&#252;ss</a> · <a href=\"https://profiles.wordpress.org/sippis/\">Timi Wahalahti</a> · <a href=\"https://profiles.wordpress.org/timothyblynjacobs/\">Timothy Jacobs</a> · <a href=\"https://profiles.wordpress.org/tmooredev/\">Titus Moore</a> · <a href=\"https://profiles.wordpress.org/tobiasbg/\">TobiasBg</a> · <a href=\"https://profiles.wordpress.org/tobifjellner/\">tobifjellner (Tor-Bjorn Fjellner)</a> · <a href=\"https://profiles.wordpress.org/tomjdv/\">Tom de Visser</a> · <a href=\"https://profiles.wordpress.org/tjnowell/\">Tom J Nowell</a> · <a href=\"https://profiles.wordpress.org/tj692/\">Tom Janssen</a> · <a href=\"https://profiles.wordpress.org/tommusrhodus/\">Tom Rhodes</a> · <a href=\"https://profiles.wordpress.org/tomasztunik/\">Tomasz Tunik</a> · <a href=\"https://profiles.wordpress.org/tomepajk/\">tomepajk</a> · <a href=\"https://profiles.wordpress.org/shimotomoki/\">Tomoki Shimomura</a> · <a href=\"https://profiles.wordpress.org/skithund/\">Toni Viemer&#246;</a> · <a href=\"https://profiles.wordpress.org/tonylocalword/\">tony.localword</a> · <a href=\"https://profiles.wordpress.org/hellofromtonya/\">Tonya Mork</a> · <a href=\"https://profiles.wordpress.org/toro_unit/\">Toro_Unit (Hiroshi Urabe)</a> · <a href=\"https://profiles.wordpress.org/zodiac1978/\">Torsten Landsiedel</a> · <a href=\"https://profiles.wordpress.org/transl8or/\">transl8or</a> · <a href=\"https://profiles.wordpress.org/wpsmith/\">Travis Smith</a> · <a href=\"https://profiles.wordpress.org/tremidkhar/\">Tremi Dkhar</a> · <a href=\"https://profiles.wordpress.org/trevorpfromsandee/\">TrevorPolischuk</a> · <a href=\"https://profiles.wordpress.org/nathannoom/\">Trinadin</a> · <a href=\"https://profiles.wordpress.org/dinhtungdu/\">Tung Du</a> · <a href=\"https://profiles.wordpress.org/turtlepod/\">turtlepod</a> · <a href=\"https://profiles.wordpress.org/ugyensupport/\">Ugyen Dorji</a> · <a href=\"https://profiles.wordpress.org/grapplerulrich/\">Ulrich</a> · <a href=\"https://profiles.wordpress.org/umesh84/\">Umesh Gupta</a> · <a href=\"https://profiles.wordpress.org/upadalavipul/\">upadalavipul</a> · <a href=\"https://profiles.wordpress.org/utsavmadaan823/\">utsavmadaan823</a> · <a href=\"https://profiles.wordpress.org/eboxnet/\">Vagelis</a> · <a href=\"https://profiles.wordpress.org/evildon/\">varma</a> · <a href=\"https://profiles.wordpress.org/vasartam/\">vasartam</a> · <a href=\"https://profiles.wordpress.org/vdankbaar/\">vdankbaar</a> · <a href=\"https://profiles.wordpress.org/velochicdunord/\">Velochicdunord</a> · <a href=\"https://profiles.wordpress.org/vcanales/\">Vicente Canales</a> · <a href=\"https://profiles.wordpress.org/vikasprogrammer/\">vikasprogrammer</a> · <a href=\"https://profiles.wordpress.org/virgar/\">Virginie Garnier</a> · <a href=\"https://profiles.wordpress.org/vishalkakadiya/\">Vishal Kakadiya</a> · <a href=\"https://profiles.wordpress.org/vortfu/\">vortfu</a> · <a href=\"https://profiles.wordpress.org/vtad/\">vtad</a> · <a href=\"https://profiles.wordpress.org/webbeetle/\">webbeetle</a> · <a href=\"https://profiles.wordpress.org/webmandesign/\">WebMan Design &#124; Oliver Juhas</a> · <a href=\"https://profiles.wordpress.org/westonruter/\">Weston Ruter</a> · <a href=\"https://profiles.wordpress.org/whaze/\">whaze</a> · <a href=\"https://profiles.wordpress.org/whissi/\">Whissi</a> · <a href=\"https://profiles.wordpress.org/earnjam/\">William Earnhardt</a> · <a href=\"https://profiles.wordpress.org/williampatton/\">williampatton</a> · <a href=\"https://profiles.wordpress.org/withinboredom/\">withinboredom</a> · <a href=\"https://profiles.wordpress.org/woji29911/\">woji29911</a> · <a href=\"https://profiles.wordpress.org/yahil/\">Yahil Madakiya</a> · <a href=\"https://profiles.wordpress.org/yannielsen/\">Yan Knudtskov</a> · <a href=\"https://profiles.wordpress.org/collet/\">Yann</a> · <a href=\"https://profiles.wordpress.org/yoavf/\">Yoav Farhi</a> · <a href=\"https://profiles.wordpress.org/byohann6/\">Yohann Billard</a> · <a href=\"https://profiles.wordpress.org/fierevere/\">Yui</a> · <a href=\"https://profiles.wordpress.org/omaeyusuke/\">yuu</a> · <a href=\"https://profiles.wordpress.org/zaerl/\">zaerl</a> · <a href=\"https://profiles.wordpress.org/zebulan/\">Zebulan Stanphill</a> · <a href=\"https://profiles.wordpress.org/zenaulislam/\">Zenaul Islam</a> · <a href=\"https://profiles.wordpress.org/ziposc/\">ziposc</a> · <a href=\"https://profiles.wordpress.org/chesio/\">Česlav Przywara</a> · <a href=\"https://profiles.wordpress.org/shenyanzhi/\">沈唁</a></p><br></code></pre>\n\n\n\n<p>WordPress 6.1 would not have been possible without the contributions of more than 800 people in over 60 countries. Their asynchronous coordination to deliver hundreds of enhancements and fixes into a stable release is a testament to the power and capability of the WordPress community.</p>\n\n\n\n<p>By release day, 71 locales had translated 90-percent or more of WordPress 6.1 into their language. Community translators continue after a release ensuring more translations are on their way. Thank you to everyone who helps to make WordPress available in over 200 languages.</p>\n\n\n\n<p>Many thanks to all of the community volunteers who contribute to the <a href=\"https://wordpress.org/support/\">support forums</a> by answering questions from WordPress users around the world.</p>\n\n\n\n<p>If contributing to WordPress appeals to you, it’s easy to learn more and get involved. Discover the different teams that come together to <a href=\"https://make.wordpress.org/\">Make WordPress</a> and explore the product roadmap on the <a href=\"https://make.wordpress.org/core/\">core development blog</a>.</p>\n\n\n\n<h2>The WordPress Mission &amp; You</h2>\n\n\n\n<p>WordPress is software designed for everyone, emphasizing accessibility, performance, security, and ease of use. The project believes great software should work with minimum setup, so you can focus on sharing your story, product, or services freely. The basic WordPress software is simple and predictable so you can easily get started. It also offers powerful features for growth and success.</p>\n\n\n\n<p>WordPress believes in democratizing publishing and <a href=\"https://opensource.org/osd-annotated\">the freedoms that come with open source</a>. Supporting this idea is a large community of people collaborating on and contributing to this project. The WordPress community is welcoming and inclusive. Our contributors’ passion drives the success of WordPress which, in turn, helps you reach your goals.</p>\n\n\n\n<p><a href=\"https://wordpress.org/about/\">Learn more about WordPress</a> and how you can join our community to help shape the future of the world’s most popular website platform.</p>\n\n\n\n<hr class=\"wp-block-separator has-alpha-channel-opacity\" />\n\n\n\n<h2>Haiku Fun for 6.1</h2>\n\n\n\n<p>Another release,<br>Mark it down as completed.<br>Breathe, relax, and cheers!</p>\n\n\n\n<hr class=\"wp-block-separator has-alpha-channel-opacity\" />\n\n\n\n<p><em>This announcement was updated on Tue Nov 8 at 9:00 p.m. UTC to clarify some features in 6.1.</em></p>\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:30:\"com-wordpress:feed-additions:1\";a:1:{s:7:\"post-id\";a:1:{i:0;a:5:{s:4:\"data\";s:5:\"13798\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:8;a:6:{s:4:\"data\";s:72:\"\n		\n		\n		\n		\n		\n				\n		\n		\n		\n		\n		\n		\n\n					\n										\n					\n		\n		\n			\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:4:{s:0:\"\";a:6:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:44:\"People of WordPress: Raghavendra Satish Peri\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:79:\"https://wordpress.org/news/2022/10/people-of-wordpress-raghavendra-satish-peri/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Mon, 31 Oct 2022 19:00:00 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:6:{i:0;a:5:{s:4:\"data\";s:9:\"Community\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:1;a:5:{s:4:\"data\";s:8:\"Features\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:2;a:5:{s:4:\"data\";s:7:\"General\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:3;a:5:{s:4:\"data\";s:10:\"Interviews\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:4;a:5:{s:4:\"data\";s:9:\"HeroPress\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:5;a:5:{s:4:\"data\";s:19:\"People of WordPress\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:35:\"https://wordpress.org/news/?p=13705\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:138:\"The latest People of WordPress story features Raghavendra Satish Peri, a digital entrepreneur in web accessibility and digital marketing. \";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:10:\"Meher Bala\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:15167:\"\n<p><strong>This month, in the run up to WordPress Accessibility Day, we feature Raghavendra Satish Peri, a blogger turned digital entrepreneur based in India, who specializes</strong> <strong>in web accessibility and digital marketing</strong>.</p>\n\n\n\n<p><strong>The People of WordPress series shares inspiring stories of how people&#8217;s lives can change for the better through WordPress and its global network of contributors.</strong></p>\n\n\n\n<figure class=\"wp-block-image size-full\"><img decoding=\"async\" loading=\"lazy\" width=\"1014\" height=\"627\" src=\"https://i0.wp.com/wordpress.org/news/files/2022/10/raghavendra-featured-img.jpg?resize=1014%2C627&#038;ssl=1\" alt=\"Raghavendra speaking at a Blogger event, 2015.\" class=\"wp-image-13701\" srcset=\"https://i0.wp.com/wordpress.org/news/files/2022/10/raghavendra-featured-img.jpg?w=1014&amp;ssl=1 1014w, https://i0.wp.com/wordpress.org/news/files/2022/10/raghavendra-featured-img.jpg?resize=300%2C186&amp;ssl=1 300w, https://i0.wp.com/wordpress.org/news/files/2022/10/raghavendra-featured-img.jpg?resize=768%2C475&amp;ssl=1 768w\" sizes=\"(max-width: 1000px) 100vw, 1000px\" data-recalc-dims=\"1\" /><figcaption class=\"wp-element-caption\">Raghavendra speaking at a blogger event, 2015</figcaption></figure>\n\n\n\n<h2>Expressing myself through WordPress</h2>\n\n\n\n<p>Raghavendra Satish Peri says WordPress is more than a way to succeed online. It&#8217;s a community that has always answered his questions and helped him learn, and has enabled his voice to be heard across the world.</p>\n\n\n\n<p>These are motivating benefits for Raghavendra, who has a vision impairment that introduces challenges to many of the things he wants to do. The WordPress community has helped him make some of his dreams come true. After chatting with others at WordPress events, about his wish to go trekking and running, he found he was later contacted by people in the community went with him to do just that.</p>\n\n\n\n<figure class=\"wp-block-image size-full\"><img decoding=\"async\" loading=\"lazy\" width=\"534\" height=\"748\" src=\"https://i0.wp.com/wordpress.org/news/files/2022/10/raghavendra-3.jpg?resize=534%2C748&#038;ssl=1\" alt=\"Raghavendra training for a marathon in 2013.\" class=\"wp-image-13702\" srcset=\"https://i0.wp.com/wordpress.org/news/files/2022/10/raghavendra-3.jpg?w=534&amp;ssl=1 534w, https://i0.wp.com/wordpress.org/news/files/2022/10/raghavendra-3.jpg?resize=214%2C300&amp;ssl=1 214w\" sizes=\"(max-width: 534px) 100vw, 534px\" data-recalc-dims=\"1\" /><figcaption class=\"wp-element-caption\">Raghavendra training for a marathon in 2013</figcaption></figure>\n\n\n\n<p>He also found WordPress events a way to raise the importance of accessibility issues, share tips, and connect local communities so they can collaborate on items both within and outside WordPress.</p>\n\n\n\n<h2>Life growing up with an enabling family</h2>\n\n\n\n<p>A key asset for Raghavendra has been the support of his family as he coped with his progressive blindness. His sister took charge of teaching him important social and life skills, so he could navigate his country&#8217;s rigorous education system.</p>\n\n\n\n<p>Those were the early days of technology everywhere, and nobody much was thinking about using it in education and day-to-day life.</p>\n\n\n\n<p>When Raghavendra got his first computer, in 2004, it was a revelation. His sister taught him to use the internet efficiently, and he taught himself a few basics of programming. Soon he was spending 10 to 12 hours a day exploring the online world and learning about the web.</p>\n\n\n\n<h2>Discovering WordPress and blogging</h2>\n\n\n\n<p>In 2006, he learned basic web design and began to sell website templates. His growing interest in search engines and content led him to WordPress. As the years progressed, his eyesight deteriorated. He had to relearn his skills and acquire new ones to compensate. When he could no longer see the computer screen, he learnt to use screen readers.&nbsp;</p>\n\n\n\n<p>At that point there was a gap: he had the same business skills, but he couldn&#8217;t apply them as effectively until he got comfortable with using screen readers.&nbsp;</p>\n\n\n\n<figure class=\"wp-block-image size-full\"><img decoding=\"async\" loading=\"lazy\" width=\"800\" height=\"534\" src=\"https://i0.wp.com/wordpress.org/news/files/2022/10/4.jpg?resize=800%2C534&#038;ssl=1\" alt=\"Raghavendra speaking at an event in Bangalore, India in 2014. Photo Credit: Two Feet To Fly - fLaShBuLbZz Photography\" class=\"wp-image-13790\" srcset=\"https://i0.wp.com/wordpress.org/news/files/2022/10/4.jpg?w=800&amp;ssl=1 800w, https://i0.wp.com/wordpress.org/news/files/2022/10/4.jpg?resize=300%2C200&amp;ssl=1 300w, https://i0.wp.com/wordpress.org/news/files/2022/10/4.jpg?resize=768%2C513&amp;ssl=1 768w\" sizes=\"(max-width: 800px) 100vw, 800px\" data-recalc-dims=\"1\" /><figcaption class=\"wp-element-caption\">Raghavendra speaking at an event in Bengalaru, India in 2014</figcaption></figure>\n\n\n\n<p>To help achieve that, Raghavendra moved to Bengalaru, where he got a full education in screen-reader technology and took a job as a consultant in digital accessibility.</p>\n\n\n\n<p>He recalls learning from that time that, in his words: “Some things are important, but one needs to let them go so that more important things can take the new space.”</p>\n\n\n\n<p>During his stay in Bengaluru, he stumbled on the idea of blogging and audiobooks. On his 23rd birthday, he had two firsts: registering a domain and publishing a blog post. At first he wrote about things happening in his daily life, which initially got low responses. But when he started attending blogging and tech meetups, he received encouragement from fellow bloggers who complimented him on his writing style. </p>\n\n\n\n<p>Using WordPress to publish his story, Raghavendra found a love for writing and this made him want to learn and understand WordPress much better.</p>\n\n\n\n<blockquote class=\"wp-block-quote\">\n<h2>“Writing freed my mind and soul from the pain and sorrow; it takes a person into a Zen state where one can understand their soul once they see their own thoughts on paper.”</h2>\n<cite>Raghavendra Satish Peri</cite></blockquote>\n\n\n\n<p>There were still some ongoing challenges arising from his difficulties with seeing. For example, Raghavendra found coding was made more complicated. But he took it slowly, and he improved steadily.&nbsp;</p>\n\n\n\n<p>He started as many WordPressers do, installing themes and plugins, and making minor changes to the code. Ultimately, he moved all of his sites to WordPress, and as he learned more about WordPress, he could help his friends and family more with their projects.</p>\n\n\n\n<p>After just a few years, Raghavendra had the skills and the confidence to build just about anything in WordPress, progressing from simple to complex websites.</p>\n\n\n\n<p>Today Raghavendra is a successful entrepreneur. He sees his life as full of promise. WordPress still helps him grow every day, professionally and personally.</p>\n\n\n\n<blockquote class=\"wp-block-quote\">\n<p>“There is always hope for tomorrow! Do not look for the light at the end of the tunnel, embrace the darkness, listen to the quietness, and feel the airflow. You will know that light is ahead even before you see it.&#8221;&nbsp;</p>\n<cite>Raghavendra Satish Peri</cite></blockquote>\n\n\n\n<h2>Contribute to accessibility and WordPress</h2>\n\n\n\n<p>Another thing Raghavendra has in common with many WordPressers is his enthusiasm and involvement in the community. As he has learnt more about the software, he felt he needed to be involved with improving accessibility too. He started to help organize local meetups and conferences and encourages others to give time and skills to contribute too.&nbsp;</p>\n\n\n\n<figure class=\"wp-block-image size-full\"><img decoding=\"async\" loading=\"lazy\" width=\"704\" height=\"500\" src=\"https://i0.wp.com/wordpress.org/news/files/2022/10/raghavendra-5.jpg?resize=704%2C500&#038;ssl=1\" alt=\"2016, Raghavendra on stage speaking at WordCamp Mumbai\" class=\"wp-image-13699\" srcset=\"https://i0.wp.com/wordpress.org/news/files/2022/10/raghavendra-5.jpg?w=704&amp;ssl=1 704w, https://i0.wp.com/wordpress.org/news/files/2022/10/raghavendra-5.jpg?resize=300%2C213&amp;ssl=1 300w\" sizes=\"(max-width: 704px) 100vw, 704px\" data-recalc-dims=\"1\" /><figcaption class=\"wp-element-caption\">2016, Raghavendra speaking at WordCamp Mumbai</figcaption></figure>\n\n\n\n<p>He follows software development closely, especially where WordPress meets accessibility.</p>\n\n\n\n<p>In 2020, on learning about a global WordPress Accessibility event, he applied and became a speaker. His topic was <a href=\"https://youtu.be/bvgLjWCRfrQ\">Gutenberg Accessibility, A Screen Reader User&#8217;s Perspective</a>. His interest continued as a result of this event, and he wanted to be part of growing its audience and impact, initially through joining its dedicated channel on Slack. Eventually, he joined the organizing team for future events.</p>\n\n\n\n<p>Helping run WordPress events brought together all of Raghavendra&#8217;s existing skills. It taught him a lot about what it takes to make an event truly inclusive, from captions and sign language to media players and more.&nbsp;</p>\n\n\n\n<p>As his involvement has grown, Raghavendra has found it has become easier to source and use resources that make events and presentations more accessible. But knows there&#8217;s always more that can be learnt in this area, and encourages others to use understanding from events like the Accessibility Days in their conferences.</p>\n\n\n\n<p>Join the global WordPress Accessibility Day 2022 online on November 2-3, 2022.&nbsp;It&#8217;s <a href=\"https://wpaccessibility.day/\">free to register</a>!</p>\n\n\n\n<figure class=\"wp-block-image size-full\"><a href=\"https://wpaccessibility.day/\" target=\"_blank\" rel=\"noreferrer noopener\"><img decoding=\"async\" loading=\"lazy\" width=\"568\" height=\"173\" src=\"https://i0.wp.com/wordpress.org/news/files/2022/10/wp-accessibility-day-22.png?resize=568%2C173&#038;ssl=1\" alt=\"WordPress Accessibility Day 2022 logo in purple and turquoise\" class=\"wp-image-13783\" srcset=\"https://i0.wp.com/wordpress.org/news/files/2022/10/wp-accessibility-day-22.png?w=568&amp;ssl=1 568w, https://i0.wp.com/wordpress.org/news/files/2022/10/wp-accessibility-day-22.png?resize=300%2C91&amp;ssl=1 300w\" sizes=\"(max-width: 568px) 100vw, 568px\" data-recalc-dims=\"1\" /></a></figure>\n\n\n\n<h2><br>Sharing learning on accessibility can be a motivator </h2>\n\n\n\n<p>In 2021, Raghavendra underwent his most challenging event to date, when he had a kidney transplant. To motivate himself, he started a website that focuses on accessibility and inclusive design. This prompted him to start an accessibility community to help fill the gaps in accessibility knowledge. Today, it is one of India’s largest online accessibility communities, educating developers and designers and training people with disabilities to build a career in accessibility testing.</p>\n\n\n\n<figure class=\"wp-block-image size-full is-resized\"><img decoding=\"async\" loading=\"lazy\" src=\"https://i0.wp.com/wordpress.org/news/files/2022/10/raghavendra-6.jpg?resize=680%2C790&#038;ssl=1\" alt=\"Portrait photo of Raghavendra post his organ transplant, 2021.\" class=\"wp-image-13698\" width=\"680\" height=\"790\" srcset=\"https://i0.wp.com/wordpress.org/news/files/2022/10/raghavendra-6.jpg?w=774&amp;ssl=1 774w, https://i0.wp.com/wordpress.org/news/files/2022/10/raghavendra-6.jpg?resize=258%2C300&amp;ssl=1 258w, https://i0.wp.com/wordpress.org/news/files/2022/10/raghavendra-6.jpg?resize=768%2C893&amp;ssl=1 768w\" sizes=\"(max-width: 680px) 100vw, 680px\" data-recalc-dims=\"1\" /><figcaption class=\"wp-element-caption\">Raghavendra after his organ transplant in 2021</figcaption></figure>\n\n\n\n<p>Raghavendra is also a keen user of the WordPress Gutenberg editor and builds all his websites using it. Though content creation and editing can still pose him difficulties, he finds the front end of the Gutenberg blocks very accessible. He believes in participating in the software to make it a better experience for all.</p>\n\n\n\n<blockquote class=\"wp-block-quote\">\n<p>&#8220;I decided to live my life to the fullest and make my mark on the world. This thought keeps me motivated.&#8221;</p>\n<cite>Raghavendra Satish Peri</cite></blockquote>\n\n\n\n<p>After a successful transplant, he lives a disciplined life with a few restrictions. He continues to enjoy working in-depth in disability, accessibility, and inclusion spaces. Raghavendra hopes others will join with him and the thousands of other people who collaborate to make a difference.</p>\n\n\n\n<h2>Share the stories</h2>\n\n\n\n<p>Help share these stories of open source contributors and continue to grow the community. Meet more WordPressers in the <a href=\"https://wordpress.org/news/category/newsletter/interviews/\">People of WordPress series</a>.</p>\n\n\n\n<p>Thank you to Raghavendra Satish Peri (<a href=\'https://profiles.wordpress.org/tarkham/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>tarkham</a>) for sharing his experiences for this latest edition.</p>\n\n\n\n<h2>Contributors</h2>\n\n\n\n<p>Thanks to Meher Bala (<a href=\'https://profiles.wordpress.org/meher/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>meher</a>), Abha Thakor (<a href=\'https://profiles.wordpress.org/webcommsat/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>webcommsat</a>) and Surendra Thakor (<a href=\'https://profiles.wordpress.org/sthakor/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>sthakor</a>) for interviews and writing this feature, to Mary Baum (<a href=\'https://profiles.wordpress.org/marybaum/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>marybaum</a>), Chloe Bringmann (<a href=\'https://profiles.wordpress.org/cbringmann/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>cbringmann</a>), and Larissa Murillo (<a href=\'https://profiles.wordpress.org/lmurillom/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>lmurillom</a>) for reviews.</p>\n\n\n\n<p>The <em>People of WordPress</em> series thanks Josepha Haden (<a href=\'https://profiles.wordpress.org/chanthaboune/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>chanthaboune</a>) and Topher DeRosia (<a href=\'https://profiles.wordpress.org/topher1kenobe/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>topher1kenobe</a>) for their support.</p>\n\n\n\n<div class=\"wp-block-media-text is-stacked-on-mobile is-vertically-aligned-center\" style=\"grid-template-columns:29% auto\"><figure class=\"wp-block-media-text__media\"><img decoding=\"async\" loading=\"lazy\" width=\"180\" height=\"135\" src=\"https://i0.wp.com/wordpress.org/news/files/2020/03/heropress_logo_180.png?resize=180%2C135&#038;ssl=1\" alt=\"HeroPress logo\" class=\"wp-image-8409 size-full\" data-recalc-dims=\"1\" /></figure><div class=\"wp-block-media-text__content\">\n<p class=\"has-small-font-size\"><em>This People of WordPress feature is inspired by an essay originally published on </em><a href=\"https://heropress.com/\"><em>HeroPress.com</em></a><em>, a community initiative created by Topher DeRosia. It highlights people in the WordPress community who have overcome barriers and whose stories might otherwise go unheard. </em>#HeroPress </p>\n</div></div>\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:30:\"com-wordpress:feed-additions:1\";a:1:{s:7:\"post-id\";a:1:{i:0;a:5:{s:4:\"data\";s:5:\"13705\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:9;a:6:{s:4:\"data\";s:61:\"\n		\n		\n		\n		\n		\n				\n		\n		\n\n					\n										\n					\n		\n		\n\n			\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:4:{s:0:\"\";a:7:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:56:\"WP Briefing: Episode 42: Something Spooky This Way Comes\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:78:\"https://wordpress.org/news/2022/10/episode-42-something-spooky-this-way-comes/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Mon, 31 Oct 2022 12:00:00 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:2:{i:0;a:5:{s:4:\"data\";s:7:\"Podcast\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:1;a:5:{s:4:\"data\";s:11:\"wp-briefing\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:53:\"https://wordpress.org/news/?post_type=podcast&p=13666\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:136:\"Tis the season for spooky fun. Hear Josepha Haden Chomphosy read a Halloween-themed WordPress Mad Lib on the episode of the WP Briefing.\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:9:\"enclosure\";a:1:{i:0;a:5:{s:4:\"data\";s:0:\"\";s:7:\"attribs\";a:1:{s:0:\"\";a:3:{s:3:\"url\";s:60:\"https://wordpress.org/news/files/2022/10/WP-Briefing-042.mp3\";s:6:\"length\";s:1:\"0\";s:4:\"type\";s:0:\"\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:14:\"Santana Inniss\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:13139:\"\n<p>In the forty-second episode of the WordPress Briefing podcast, Josepha Haden Chomphosy reads a WordPress Halloween story completed by contributor-submitted Mad Libs. </p>\n\n\n\n<p><em><strong>Have a question you&#8217;d like answered? You can submit them to <a href=\"mailto:wpbriefing@wordpress.org\">wpbriefing@wordpress.org</a>, either written or as a voice recording.</strong></em></p>\n\n\n\n<h2>Credits</h2>\n\n\n\n<p>Editor:&nbsp;<a href=\"https://profiles.wordpress.org/dustinhartzler/\">Dustin Hartzler</a><br>Logo:&nbsp;<a href=\"https://profiles.wordpress.org/javiarce/\" data-type=\"URL\" data-id=\"https://profiles.wordpress.org/javiarce/\">Javier Arce</a><br>Production:&nbsp;<a href=\"https://profiles.wordpress.org/santanainniss/\">Santana Inniss</a><br>Music: Spooky edit by <a href=\"https://goodnightnobody.space/\" data-type=\"URL\" data-id=\"https://goodnightnobody.space/\">Timothy Volpert</a><br>Mad Lib Contributors: <a href=\"https://profiles.wordpress.org/juanlucha/\" data-type=\"URL\" data-id=\"https://profiles.wordpress.org/juanlucha/\">Juan Lucha</a>, <a href=\"https://profiles.wordpress.org/laurlittle/\" data-type=\"URL\" data-id=\"https://profiles.wordpress.org/laurlittle/\">Lauren Stein</a>, <a href=\"https://profiles.wordpress.org/robinwpdeveloper/\" data-type=\"URL\" data-id=\"https://profiles.wordpress.org/robinwpdeveloper/\">robinwpdeveloper</a>, <a href=\"https://profiles.wordpress.org/bph/\">Birgit Pauli-Haack</a>, <a href=\"https://profiles.wordpress.org/aetherunbound/\" data-type=\"URL\" data-id=\"https://profiles.wordpress.org/aetherunbound/\">Madison Swain-Bowden</a>, <a href=\"https://profiles.wordpress.org/kgagne/\" data-type=\"URL\" data-id=\"https://profiles.wordpress.org/kgagne/\">Ken Gagne</a>, <a href=\"https://profiles.wordpress.org/juliarosia/\">Julia Golomb</a>, <a href=\"https://profiles.wordpress.org/kawserz/\">kawserz</a>, <a href=\"https://profiles.wordpress.org/sereedmedia/\">Sé Reed</a>, <a href=\"https://profiles.wordpress.org/faguni22/\">Mumtahina Faguni</a>, <a href=\"https://www.linkedin.com/in/cleamahoney/\" data-type=\"URL\" data-id=\"https://www.linkedin.com/in/cleamahoney/\">Clea Mahoney</a></p>\n\n\n\n<h2>Download Mad Libs:</h2>\n\n\n\n<div class=\"wp-block-file\"><a id=\"wp-block-file--media-bbc1dbb2-b633-4e46-b53b-4440a449cac4\" href=\"https://wordpress.org/news/files/2022/10/WP-Briefing-Halloween-Mad-Libs.pdf\">WP-Briefing-Halloween-Mad-Libs</a><a href=\"https://wordpress.org/news/files/2022/10/WP-Briefing-Halloween-Mad-Libs.pdf\" class=\"wp-block-file__button wp-element-button\" download aria-describedby=\"wp-block-file--media-bbc1dbb2-b633-4e46-b53b-4440a449cac4\">Download</a></div>\n\n\n\n<h2>References</h2>\n\n\n\n<p><a href=\"https://make.wordpress.org/core/6-1/\" data-type=\"URL\" data-id=\"https://make.wordpress.org/core/6-1/\">Important Note: WordPress 6.1 is released tomorrow!</a><br><a rel=\"noreferrer noopener\" href=\"https://make.wordpress.org/core/2022/10/20/multisite-registration-and-activation-pages-have-new-html-and-css/\" target=\"_blank\">Multisite registration and activation pages have new HTML and CSS</a><br><a rel=\"noreferrer noopener\" href=\"https://make.wordpress.org/mobile/2022/10/18/call-for-testing-wordpress-for-android-21-0/\" target=\"_blank\">Call for Testing: WordPress for Android 21.0</a><br><a rel=\"noreferrer noopener\" href=\"https://make.wordpress.org/docs/2022/10/19/new-design-for-helphub-in-wordpress-org/\" target=\"_blank\">New design for HelpHub in WordPress.org</a><br><a rel=\"noreferrer noopener\" href=\"https://make.wordpress.org/meta/2022/10/21/wordpress-org-redesign-update/\" target=\"_blank\">WordPress.org Redesign Update</a><br><a rel=\"noreferrer noopener\" href=\"https://make.wordpress.org/test/2022/10/15/fse-program-guiding-the-gutenberg-gallery-summary/\" target=\"_blank\">FSE Program Guiding the Gutenberg Gallery Summary</a></p>\n\n\n\n<h2>Transcript</h2>\n\n\n\n<span id=\"more-13666\"></span>\n\n\n\n<p><strong>[Josepha Haden Chomphosy 00:00:00]&nbsp;</strong></p>\n\n\n\n<p>Howdy, Halloween nerds! And welcome to the WordPress Briefing, a podcast where I&#8217;m normally very serious, but today is Halloween! And gosh, do I love a chance to celebrate. So today, the most serious thing I have is this WordPress themed Halloween Madlib for you. I&#8217;m your host, Josepha Haden Chomphosy. Here we go.</p>\n\n\n\n<p><strong>[Josepha Haden Chomphosy 00:00:43]&nbsp;</strong></p>\n\n\n\n<p>I was so excited to learn that WordCamp would be on Halloween this year, and now it&#8217;s finally here. After a full day of workshops and mingling, I am exhausted. But I&#8217;ve got just enough time to return to the hotel and prepare for the after party. It&#8217;s a themed costume event organized by the Docs team, and I cannot wait.</p>\n\n\n\n<p>Walking into my room, I give a big yawn and realize just how tired I am. The bed is looking extra comfortable right now. Surely a little nap wouldn&#8217;t hurt, right? As soon as my head hits the pillow, I&#8217;m out like a light, but almost immediately, my eyes snap back open, a flash of lightning lights up the room, and I hear rain pouring down outside.</p>\n\n\n\n<p><strong>[Josepha Haden Chomphosy 00:01:23]&nbsp;</strong></p>\n\n\n\n<p>After another flash, the lights in the room start to flicker. That&#8217;s strange, I think to myself, but I have an after party to get to. There must have been a power surge because when I look back at the clock, it&#8217;s reset and flashing 12:00 am. I check my phone, but it&#8217;s dead too. I&#8217;m not quite sure how long I&#8217;ve been sleeping, so I don&#8217;t know if I have enough time to change into my full Ninja Turtles costume.</p>\n\n\n\n<p>I just put the mask on and head down to the lobby to meet my WordPress friends. When the elevator dings open in the lobby, it&#8217;s completely empty. No concierge, no hotel staff, and no WordPress friends. That&#8217;s weird. The lights also seem dimmer. And, are those urgent Trac tickets on the lobby lounge chairs?</p>\n\n\n\n<p>I&#8217;m wondering where everybody is, but I keep walking toward the convention hall. A shadow suddenly moves in the corner of my eye, and I spin around but only see my own face reflecting in a hallway mirror. Hmm, that&#8217;s odd. I notice that the cute Ninja Turtle mask looks a little less cute somehow. The eyes are angry red, and the teeth are now sharp-looking fangs.</p>\n\n\n\n<p><strong>[Josepha Haden Chomphosy 00:02:33]&nbsp;</strong></p>\n\n\n\n<p>Before I can take off the mask for a closer look, I see another shadow move in the corner of the mirror. When I turn around this time, I see the faint outline of a person. It looks familiar. Could that be Matt Mullenweg? Darn it. They disappear into the convention hall before I can even call out, ‘howdy!’ And so I break into a jog to follow after them.</p>\n\n\n\n<p>Walking into the hall, I can hear the musical stylings of WordPress Jazzer Duke Ellington playing on a gramophone. I bob my head to the music, super relieved to see the room full of WordPressers dressed up and dancing. I head over to some of the folks from my Make team to chat, but oddly, they won&#8217;t stop dancing. They&#8217;re smiling and dancing and cheering each other on.</p>\n\n\n\n<p>Some of them are even doing the electric slide. It&#8217;s actually kind of impressive, but it&#8217;s still a little strange that no one will stop dancing to talk to me. Actually, now that I think about it, none of the party goers seem to be noticing me at all. Wondering what&#8217;s going on, I start backing up toward the door.</p>\n\n\n\n<p><strong>[Josepha Haden Chomphosy 00:03:32]&nbsp;</strong></p>\n\n\n\n<p>I jump a little as it slams behind me with the loud sound of an old door creaking and the heavy click of a lock.</p>\n\n\n\n<p>That&#8217;s when I noticed the shadowy familiar figure again. This time they&#8217;re standing by an open door on the other side of the hall. They seem to be watching me. They lift a white gloved hand and motion for me to follow before disappearing through the door again.</p>\n\n\n\n<p>I run after the mysterious figure weaving between groups of dancing WordCamp goers. Could they be under a spell, I wonder while running past. I exit the convention space and enter a small hallway that seems to twist and turn. It feels a lot longer than I remember. I continue running through it and suddenly find myself back in the Contributor Day conference room.</p>\n\n\n\n<p>The shadow person is nowhere to be found, and as I walk around the contributor tables, I quickly notice that the exit back to the hotel has also disappeared. Okay, so this is getting really weird. My first thought is to get my Make team involved, but since they won&#8217;t stop dancing, I know I need to devise a different plan.</p>\n\n\n\n<p><strong>[Josepha Haden Chomphosy 00:04:34]&nbsp;</strong></p>\n\n\n\n<p>That&#8217;s when I noticed the big glass box at the center of the room. I am almost certain it wasn&#8217;t there during Contributor Day. I approach the box cautiously. Inside I see a shiny silver goblet of gently fizzing WordPress blue liquid, possibly blueberry flavored if I had to guess. Attached to the goblet stem is a ribbon with a note in EB Garamond that reads: Merge Me.</p>\n\n\n\n<p>At first, I chuckle at the poor attempt at a GitHub joke until I spot another note scrolled on the glass in black marker. It says,&nbsp;</p>\n\n\n\n<p><em>Bubble, bubble, toil, and trouble;</em><br><em>Find your escape route on the double;&nbsp;</em><br><em>Bring back the community and one thing more;&nbsp;</em><br><em>Merge the elixir with your core.&nbsp;</em></p>\n\n\n\n<p>As I&#8217;m trying to decode the odd poem’s meaning, a flash of lightning lurches across the room, and a clap of thunder follows behind.</p>\n\n\n\n<p><strong>[Josepha Haden Chomphosy 00:05:24]&nbsp;</strong></p>\n\n\n\n<p>I shield my eyes before looking up to find that I am no longer alone. It&#8217;s the shadowy figure again, except in the light of this room, I can finally see that it&#8217;s not anyone familiar. It is a lumpy-looking being, and it&#8217;s wearing a witch costume. The costume-clad figure looks very unsteady on its feet like it might fall over.</p>\n\n\n\n<p>And just as I&#8217;m about to ask if they&#8217;re all right, the person suddenly topples over into a heap of robes and broomsticks. I can see spots of yellow fur and a few pairs of fuzzy ears. Aha! There was a wisdom of Wapuus under that witchy costume.&nbsp;</p>\n\n\n\n<p>They blink cutely at me for a moment and then quickly scurry into a surprisingly organized line. I watch, totally confused, as the line of Wapuus starts moving methodically back toward the convention hall. They take three steps, and then they turn to the side, take another three steps, and then turn to the other side.</p>\n\n\n\n<p>The last Wapuu in the line turns to look at me and motions with its tiny paw to follow. That&#8217;s when the words on the glass box finally click. I have to bring the community back. All the dancing WordPressers need to return to the contributor tables to break the spell. The Wapuus have started a conga line to help lead the way.</p>\n\n\n\n<p><strong>[Josepha Haden Chomphosy 00:06:35]&nbsp;</strong></p>\n\n\n\n<p>So, off I go. Following the tiny conga line through the twisting hallway and into the convention hall. As I&#8217;m dancing behind the Wapuus, I&#8217;m happy to see all my fellow WordCamp attendees falling into step behind me. My steadily growing conga line is weaving its way through the hall, picking up WordPressers, wearing mouse costumes, and Frankensteins and penguin costumes, and that&#8217;s when the Wapuus changed their course, leading us back through the twisting hallway and into the Contributor Day conference room.</p>\n\n\n\n<p>With the first part of the riddle solved, I&#8217;m glad to see that everyone has finally stopped dancing. Some folks are happy to sit down and get off their feet. Others are wondering how they ended up back in the contributor room. My Make team waves at me from across the room. I noticed there&#8217;s still no exit, but the glass box has disappeared. With the goblet free, there&#8217;s just one thing left for me to do.</p>\n\n\n\n<p><strong>[Josepha Haden Chomphosy 00:07:27]&nbsp;</strong></p>\n\n\n\n<p>I rush toward it, dodging Wapuus and a pile of kicked-off shoes. Except that the closer I think I&#8217;m getting to the goblet, the further away it feels. I run faster, weaving through people and tables, and just when I feel close enough to reach out for the goblet, I trip over a live-streaming cable, and I wake up in my hotel room.</p>\n\n\n\n<p>Sitting up quickly, I realize it was all just a very strange dream. Outside, the sun is setting in a clear sky with no storm in sight. I try to shake it off. I change into my Ninja Turtles costume, ready to do my best Monster Mash at the after party with all of my WordPress friends. As I walk out of the hotel room, I pause for a quick costume check in the mirror.</p>\n\n\n\n<p>Before heading downstairs, I take a quick glance at the digital clock on the nightstand to see the time. Huh, that&#8217;s odd. Next to the digital clock sits a fuzzy plush Wapuu wearing a witch costume. That wasn&#8217;t there before, was it? And if I didn&#8217;t know any better, I almost think I see it wink.&nbsp;</p>\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:30:\"com-wordpress:feed-additions:1\";a:1:{s:7:\"post-id\";a:1:{i:0;a:5:{s:4:\"data\";s:5:\"13666\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}}}s:27:\"http://www.w3.org/2005/Atom\";a:1:{s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:0:\"\";s:7:\"attribs\";a:1:{s:0:\"\";a:3:{s:4:\"href\";s:32:\"https://wordpress.org/news/feed/\";s:3:\"rel\";s:4:\"self\";s:4:\"type\";s:19:\"application/rss+xml\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:44:\"http://purl.org/rss/1.0/modules/syndication/\";a:2:{s:12:\"updatePeriod\";a:1:{i:0;a:5:{s:4:\"data\";s:9:\"\n	hourly	\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:15:\"updateFrequency\";a:1:{i:0;a:5:{s:4:\"data\";s:4:\"\n	1	\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:30:\"com-wordpress:feed-additions:1\";a:1:{s:4:\"site\";a:1:{i:0;a:5:{s:4:\"data\";s:8:\"14607090\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}}}}}}}}s:4:\"type\";i:128;s:7:\"headers\";O:42:\"Requests_Utility_CaseInsensitiveDictionary\":1:{s:7:\"\0*\0data\";a:11:{s:6:\"server\";s:5:\"nginx\";s:4:\"date\";s:29:\"Thu, 01 Dec 2022 08:42:33 GMT\";s:12:\"content-type\";s:34:\"application/rss+xml; charset=UTF-8\";s:4:\"vary\";s:15:\"Accept-Encoding\";s:25:\"strict-transport-security\";s:11:\"max-age=360\";s:6:\"x-olaf\";s:3:\"⛄\";s:13:\"last-modified\";s:29:\"Wed, 30 Nov 2022 21:31:04 GMT\";s:4:\"link\";s:63:\"<https://wordpress.org/news/wp-json/>; rel=\"https://api.w.org/\"\";s:15:\"x-frame-options\";s:10:\"SAMEORIGIN\";s:16:\"content-encoding\";s:2:\"br\";s:4:\"x-nc\";s:9:\"HIT ord 2\";}}s:5:\"build\";s:14:\"20211220193300\";}","no");
INSERT INTO ceba_options VALUES("126","theme_mods_twentytwentythree","a:2:{s:18:\"custom_css_post_id\";i:-1;s:16:\"sidebars_widgets\";a:2:{s:4:\"time\";i:1669884879;s:4:\"data\";a:3:{s:19:\"wp_inactive_widgets\";a:0:{}s:9:\"sidebar-1\";a:3:{i:0;s:7:\"block-2\";i:1;s:7:\"block-3\";i:2;s:7:\"block-4\";}s:9:\"sidebar-2\";a:2:{i:0;s:7:\"block-5\";i:1;s:7:\"block-6\";}}}}","yes");
INSERT INTO ceba_options VALUES("129","https_detection_errors","a:0:{}","yes");
INSERT INTO ceba_options VALUES("130","_site_transient_update_core","O:8:\"stdClass\":4:{s:7:\"updates\";a:1:{i:0;O:8:\"stdClass\":10:{s:8:\"response\";s:6:\"latest\";s:8:\"download\";s:59:\"https://downloads.wordpress.org/release/wordpress-6.1.1.zip\";s:6:\"locale\";s:5:\"en_US\";s:8:\"packages\";O:8:\"stdClass\":5:{s:4:\"full\";s:59:\"https://downloads.wordpress.org/release/wordpress-6.1.1.zip\";s:10:\"no_content\";s:70:\"https://downloads.wordpress.org/release/wordpress-6.1.1-no-content.zip\";s:11:\"new_bundled\";s:71:\"https://downloads.wordpress.org/release/wordpress-6.1.1-new-bundled.zip\";s:7:\"partial\";s:0:\"\";s:8:\"rollback\";s:0:\"\";}s:7:\"current\";s:5:\"6.1.1\";s:7:\"version\";s:5:\"6.1.1\";s:11:\"php_version\";s:6:\"5.6.20\";s:13:\"mysql_version\";s:3:\"5.0\";s:11:\"new_bundled\";s:3:\"6.1\";s:15:\"partial_version\";s:0:\"\";}}s:12:\"last_checked\";i:1669885016;s:15:\"version_checked\";s:5:\"6.1.1\";s:12:\"translations\";a:0:{}}","no");
INSERT INTO ceba_options VALUES("202","_site_transient_timeout_theme_roots","1669886279","no");
INSERT INTO ceba_options VALUES("203","_site_transient_theme_roots","a:4:{s:8:\"jupiterx\";s:7:\"/themes\";s:15:\"twentytwentyone\";s:7:\"/themes\";s:17:\"twentytwentythree\";s:7:\"/themes\";s:15:\"twentytwentytwo\";s:7:\"/themes\";}","no");
INSERT INTO ceba_options VALUES("210","_site_transient_update_themes","O:8:\"stdClass\":5:{s:12:\"last_checked\";i:1669885016;s:7:\"checked\";a:4:{s:8:\"jupiterx\";s:5:\"2.5.3\";s:15:\"twentytwentyone\";s:3:\"1.7\";s:17:\"twentytwentythree\";s:3:\"1.0\";s:15:\"twentytwentytwo\";s:3:\"1.3\";}s:8:\"response\";a:0:{}s:9:\"no_update\";a:3:{s:15:\"twentytwentyone\";a:6:{s:5:\"theme\";s:15:\"twentytwentyone\";s:11:\"new_version\";s:3:\"1.7\";s:3:\"url\";s:45:\"https://wordpress.org/themes/twentytwentyone/\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/theme/twentytwentyone.1.7.zip\";s:8:\"requires\";s:3:\"5.3\";s:12:\"requires_php\";s:3:\"5.6\";}s:17:\"twentytwentythree\";a:6:{s:5:\"theme\";s:17:\"twentytwentythree\";s:11:\"new_version\";s:3:\"1.0\";s:3:\"url\";s:47:\"https://wordpress.org/themes/twentytwentythree/\";s:7:\"package\";s:63:\"https://downloads.wordpress.org/theme/twentytwentythree.1.0.zip\";s:8:\"requires\";s:3:\"6.1\";s:12:\"requires_php\";s:3:\"5.6\";}s:15:\"twentytwentytwo\";a:6:{s:5:\"theme\";s:15:\"twentytwentytwo\";s:11:\"new_version\";s:3:\"1.3\";s:3:\"url\";s:45:\"https://wordpress.org/themes/twentytwentytwo/\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/theme/twentytwentytwo.1.3.zip\";s:8:\"requires\";s:3:\"5.9\";s:12:\"requires_php\";s:3:\"5.6\";}}s:12:\"translations\";a:0:{}}","no");
INSERT INTO ceba_options VALUES("211","current_theme","JupiterX","yes");
INSERT INTO ceba_options VALUES("212","theme_mods_jupiterx","a:1:{s:18:\"custom_css_post_id\";i:-1;}","yes");
INSERT INTO ceba_options VALUES("246","_elementor_installed_time","1669885514","yes");
INSERT INTO ceba_options VALUES("214","jupiterx","a:11:{s:13:\"theme_version\";s:5:\"2.5.3\";s:21:\"theme_current_version\";s:5:\"2.5.3\";s:23:\"mods_migrated_from_lite\";b:1;s:28:\"first_installation_after_250\";b:1;s:30:\"jupiterx_selected_google_fonts\";a:0:{}s:28:\"envato_purchase_code_5177775\";s:36:\"341984d3-46f4-4074-986e-1dec7c2f6b90\";s:7:\"api_key\";s:64:\"1cf5a254d6ab88cd0134fca22e30490662cb7c9acaead2da7444e2b252bbd1db\";s:16:\"api_access_token\";s:32:\"a799c7f6f3b0c0c81a764a1837b7ca52\";s:9:\"api_email\";s:22:\"colmandeocar@gmail.com\";s:10:\"api_expiry\";s:19:\"2019-06-02 18:52:53\";s:11:\"svg_support\";i:1;}","yes");
INSERT INTO ceba_options VALUES("215","jupiterx_tgmpa_plugins","a:25:{i:0;a:14:{s:2:\"id\";i:37690;s:10:\"theme_name\";s:8:\"jupiterx\";s:4:\"name\";s:14:\"Jupiter X Core\";s:4:\"slug\";s:13:\"jupiterx-core\";s:8:\"basename\";s:31:\"jupiterx-core/jupiterx-core.php\";s:7:\"img_url\";s:100:\"https://d3fvlpdr5b7667.cloudfront.net/wp-content/uploads/2019/11/plugin-thumb-jupiterx-core-icon.png\";s:4:\"desc\";s:107:\"Enables the customizer settings in Jupiter X. Also, some other theme functionalities depend on this plugin.\";s:6:\"source\";s:101:\"https://d3fvlpdr5b7667.cloudfront.net/wp-content/uploads/dlm_uploads/2022/11/jupiterx-core-v2.5.4.zip\";s:7:\"version\";s:5:\"2.5.4\";s:8:\"required\";s:4:\"true\";s:11:\"recommended\";s:5:\"false\";s:3:\"pro\";s:5:\"false\";s:9:\"more_link\";s:63:\"https://themes.artbees.net/docs/jupiter-x-core-plugin-overview/\";s:11:\"is_callable\";s:13:\"JupiterX_Core\";}i:1;a:12:{s:2:\"id\";i:37695;s:10:\"theme_name\";s:8:\"jupiterx\";s:4:\"name\";s:22:\"Advanced Custom Fields\";s:4:\"slug\";s:22:\"advanced-custom-fields\";s:8:\"basename\";s:30:\"advanced-custom-fields/acf.php\";s:7:\"img_url\";s:90:\"https://d3fvlpdr5b7667.cloudfront.net/wp-content/uploads/2019/11/plugin-thumb-acf-icon.png\";s:4:\"desc\";s:134:\"Adds the page options to Jupiter X so you can override the global settings on each page. Add and edit extra fields to your post types.\";s:8:\"required\";s:4:\"true\";s:11:\"recommended\";s:5:\"false\";s:3:\"pro\";s:5:\"false\";s:9:\"more_link\";s:53:\"https://wordpress.org/plugins/advanced-custom-fields/\";s:11:\"is_callable\";s:3:\"ACF\";}i:2;a:12:{s:2:\"id\";i:37698;s:10:\"theme_name\";s:8:\"jupiterx\";s:4:\"name\";s:9:\"Elementor\";s:4:\"slug\";s:9:\"elementor\";s:8:\"basename\";s:23:\"elementor/elementor.php\";s:7:\"img_url\";s:96:\"https://d3fvlpdr5b7667.cloudfront.net/wp-content/uploads/2019/11/plugin-thumb-elementor-icon.png\";s:4:\"desc\";s:162:\"The default page builder with Jupiter X. It allows you to edit the pages in a real WYSIWYG editor. Currently known as the most advanced page builder in the world.\";s:8:\"required\";s:4:\"true\";s:11:\"recommended\";s:5:\"false\";s:3:\"pro\";s:5:\"false\";s:9:\"more_link\";s:74:\"https://help.artbees.net/getting-started/plugins/elementor-plugin-overview\";s:11:\"is_callable\";s:16:\"Elementor\\Plugin\";}i:3;a:15:{s:2:\"id\";i:37586;s:10:\"theme_name\";s:8:\"jupiterx\";s:4:\"name\";s:5:\"Raven\";s:4:\"slug\";s:5:\"raven\";s:8:\"basename\";s:15:\"raven/raven.php\";s:7:\"img_url\";s:92:\"https://d3fvlpdr5b7667.cloudfront.net/wp-content/uploads/2019/11/plugin-thumb-raven-icon.png\";s:4:\"desc\";s:189:\"20+ new elements exclusively developed by Artbees for Elementor. Also, Header, Footer and custom post type templates in the Free version of Elementor will be available by using this plugin.\";s:6:\"source\";s:94:\"https://d3fvlpdr5b7667.cloudfront.net/wp-content/uploads/dlm_uploads/2020/09/raven-v1.11.0.zip\";s:7:\"version\";s:6:\"1.11.0\";s:8:\"required\";s:5:\"false\";s:11:\"recommended\";s:5:\"false\";s:3:\"pro\";s:4:\"true\";s:9:\"more_link\";s:70:\"https://help.artbees.net/getting-started/plugins/raven-plugin-overview\";s:11:\"is_callable\";s:12:\"Raven\\Plugin\";s:8:\"releases\";O:8:\"stdClass\":2:{s:6:\"item-0\";O:8:\"stdClass\":2:{s:14:\"_version_label\";s:1:\"I\";s:15:\"_version_number\";s:5:\"1.3.0\";}s:6:\"item-1\";O:8:\"stdClass\":2:{s:14:\"_version_label\";s:2:\"II\";s:15:\"_version_number\";s:5:\"1.3.1\";}}}i:4;a:18:{s:2:\"id\";i:37701;s:10:\"theme_name\";s:8:\"jupiterx\";s:4:\"name\";s:12:\"Jet Elements\";s:8:\"headline\";s:26:\"Get More Elementor Widgets\";s:5:\"video\";s:50:\"https://www.youtube-nocookie.com/embed/edflWQvInNc\";s:15:\"large_thumbnail\";s:83:\"https://d3fvlpdr5b7667.cloudfront.net/wp-content/uploads/2019/11/Jet-elements-2.jpg\";s:4:\"slug\";s:12:\"jet-elements\";s:8:\"basename\";s:29:\"jet-elements/jet-elements.php\";s:7:\"img_url\";s:99:\"https://d3fvlpdr5b7667.cloudfront.net/wp-content/uploads/2019/11/plugin-thumb-jet-elements-icon.png\";s:4:\"desc\";s:62:\"Adds different Elements and widgets to Elementor page builder.\";s:6:\"source\";s:100:\"https://d3fvlpdr5b7667.cloudfront.net/wp-content/uploads/dlm_uploads/2022/11/jet-elements-v2.6.8.zip\";s:7:\"version\";s:5:\"2.6.8\";s:8:\"required\";s:5:\"false\";s:11:\"recommended\";s:5:\"false\";s:3:\"pro\";s:4:\"true\";s:9:\"more_link\";s:60:\"https://themes.artbees.net/docs/jetelements-plugin-overview/\";s:11:\"is_callable\";s:12:\"Jet_Elements\";s:10:\"label_type\";s:8:\"Optional\";}i:5;a:18:{s:2:\"id\";i:37706;s:10:\"theme_name\";s:8:\"jupiterx\";s:4:\"name\";s:8:\"Jet Blog\";s:8:\"headline\";s:18:\"Create Better Blog\";s:5:\"video\";s:50:\"https://www.youtube-nocookie.com/embed/80LaNrv9fZ8\";s:15:\"large_thumbnail\";s:79:\"https://d3fvlpdr5b7667.cloudfront.net/wp-content/uploads/2019/11/Jet-Blog-2.jpg\";s:4:\"slug\";s:8:\"jet-blog\";s:8:\"basename\";s:21:\"jet-blog/jet-blog.php\";s:7:\"img_url\";s:95:\"https://d3fvlpdr5b7667.cloudfront.net/wp-content/uploads/2019/11/plugin-thumb-jet-blog-icon.png\";s:4:\"desc\";s:90:\"Adds advanced widgets to Elementor and let you build a powerful blog and magazine website.\";s:6:\"source\";s:96:\"https://d3fvlpdr5b7667.cloudfront.net/wp-content/uploads/dlm_uploads/2022/09/jet-blog-v2.3.1.zip\";s:7:\"version\";s:5:\"2.3.1\";s:8:\"required\";s:5:\"false\";s:11:\"recommended\";s:5:\"false\";s:3:\"pro\";s:4:\"true\";s:9:\"more_link\";s:56:\"https://themes.artbees.net/docs/jetblog-plugin-overview/\";s:11:\"is_callable\";s:8:\"Jet_Blog\";s:10:\"label_type\";s:8:\"Optional\";}i:6;a:18:{s:2:\"id\";i:37711;s:10:\"theme_name\";s:8:\"jupiterx\";s:4:\"name\";s:8:\"Jet Menu\";s:8:\"headline\";s:21:\"Create Advanced Menus\";s:5:\"video\";s:50:\"https://www.youtube-nocookie.com/embed/Pndy-eEgGsY\";s:15:\"large_thumbnail\";s:79:\"https://d3fvlpdr5b7667.cloudfront.net/wp-content/uploads/2019/11/Jet-Menu-2.jpg\";s:4:\"slug\";s:8:\"jet-menu\";s:8:\"basename\";s:21:\"jet-menu/jet-menu.php\";s:7:\"img_url\";s:95:\"https://d3fvlpdr5b7667.cloudfront.net/wp-content/uploads/2019/11/plugin-thumb-jet-menu-icon.png\";s:4:\"desc\";s:52:\"Advanced mega menu addon for Elementor page builder.\";s:6:\"source\";s:96:\"https://d3fvlpdr5b7667.cloudfront.net/wp-content/uploads/dlm_uploads/2022/11/jet-menu-v2.2.4.zip\";s:7:\"version\";s:5:\"2.2.4\";s:8:\"required\";s:5:\"false\";s:11:\"recommended\";s:5:\"false\";s:3:\"pro\";s:4:\"true\";s:9:\"more_link\";s:56:\"https://themes.artbees.net/docs/jetmenu-plugin-overview/\";s:11:\"is_callable\";s:8:\"Jet_Menu\";s:10:\"label_type\";s:8:\"Optional\";}i:7;a:18:{s:2:\"id\";i:37716;s:10:\"theme_name\";s:8:\"jupiterx\";s:4:\"name\";s:9:\"Jet Popup\";s:8:\"headline\";s:25:\"Create Pop-ups and Modals\";s:5:\"video\";s:50:\"https://www.youtube-nocookie.com/embed/pgINfIT8hKk\";s:15:\"large_thumbnail\";s:78:\"https://d3fvlpdr5b7667.cloudfront.net/wp-content/uploads/2019/11/Jet-Popup.jpg\";s:4:\"slug\";s:9:\"jet-popup\";s:8:\"basename\";s:23:\"jet-popup/jet-popup.php\";s:7:\"img_url\";s:96:\"https://d3fvlpdr5b7667.cloudfront.net/wp-content/uploads/2019/11/plugin-thumb-jet-popup-icon.png\";s:4:\"desc\";s:55:\"The advanced plugin for creating popups with Elementor.\";s:6:\"source\";s:97:\"https://d3fvlpdr5b7667.cloudfront.net/wp-content/uploads/dlm_uploads/2022/11/jet-popup-v1.6.3.zip\";s:7:\"version\";s:5:\"1.6.3\";s:8:\"required\";s:5:\"false\";s:11:\"recommended\";s:5:\"false\";s:3:\"pro\";s:4:\"true\";s:9:\"more_link\";s:57:\"https://themes.artbees.net/docs/jetpopup-plugin-overview/\";s:11:\"is_callable\";s:9:\"Jet_Popup\";s:10:\"label_type\";s:8:\"Optional\";}i:8;a:18:{s:2:\"id\";i:37721;s:10:\"theme_name\";s:8:\"jupiterx\";s:4:\"name\";s:8:\"Jet Tabs\";s:8:\"headline\";s:41:\"Create Tabs with Extended Functionalities\";s:5:\"video\";s:50:\"https://www.youtube-nocookie.com/embed/WgOJEQrMEFg\";s:15:\"large_thumbnail\";s:79:\"https://d3fvlpdr5b7667.cloudfront.net/wp-content/uploads/2019/11/Jet-Tabs-2.jpg\";s:4:\"slug\";s:8:\"jet-tabs\";s:8:\"basename\";s:21:\"jet-tabs/jet-tabs.php\";s:7:\"img_url\";s:95:\"https://d3fvlpdr5b7667.cloudfront.net/wp-content/uploads/2019/11/plugin-thumb-jet-tabs-icon.png\";s:4:\"desc\";s:56:\"Advanced Tabs and Accordions for Elementor Page Builder.\";s:6:\"source\";s:97:\"https://d3fvlpdr5b7667.cloudfront.net/wp-content/uploads/dlm_uploads/2022/11/jet-tabs-v2.1.20.zip\";s:7:\"version\";s:6:\"2.1.20\";s:8:\"required\";s:5:\"false\";s:11:\"recommended\";s:5:\"false\";s:3:\"pro\";s:4:\"true\";s:9:\"more_link\";s:56:\"https://themes.artbees.net/docs/jettabs-plugin-overview/\";s:11:\"is_callable\";s:8:\"Jet_Tabs\";s:10:\"label_type\";s:8:\"Optional\";}i:9;a:18:{s:2:\"id\";i:37726;s:10:\"theme_name\";s:8:\"jupiterx\";s:4:\"name\";s:14:\"Jet WooBuilder\";s:8:\"headline\";s:23:\"Customize Product Pages\";s:5:\"video\";s:50:\"https://www.youtube-nocookie.com/embed/vvMrjACSnzo\";s:15:\"large_thumbnail\";s:85:\"https://d3fvlpdr5b7667.cloudfront.net/wp-content/uploads/2019/11/Jet-woobuilder-2.jpg\";s:4:\"slug\";s:15:\"jet-woo-builder\";s:8:\"basename\";s:35:\"jet-woo-builder/jet-woo-builder.php\";s:7:\"img_url\";s:101:\"https://d3fvlpdr5b7667.cloudfront.net/wp-content/uploads/2019/11/plugin-thumb-jet-woobuilder-icon.png\";s:4:\"desc\";s:131:\"Custom shop templates for WooCommerce. Adds some widgets to Elementor that can be used inside and outside of WooCommerce templates.\";s:6:\"source\";s:103:\"https://d3fvlpdr5b7667.cloudfront.net/wp-content/uploads/dlm_uploads/2022/11/jet-woo-builder-v2.0.5.zip\";s:7:\"version\";s:5:\"2.0.5\";s:8:\"required\";s:5:\"false\";s:11:\"recommended\";s:5:\"false\";s:3:\"pro\";s:4:\"true\";s:9:\"more_link\";s:62:\"https://themes.artbees.net/docs/jetwoobuilder-plugin-overview/\";s:11:\"is_callable\";s:15:\"Jet_Woo_Builder\";s:10:\"label_type\";s:8:\"Optional\";}i:10;a:18:{s:2:\"id\";i:37731;s:10:\"theme_name\";s:8:\"jupiterx\";s:4:\"name\";s:10:\"Jet Tricks\";s:8:\"headline\";s:21:\"Create Visual Effects\";s:5:\"video\";s:50:\"https://www.youtube-nocookie.com/embed/mfGuDEsixFs\";s:15:\"large_thumbnail\";s:81:\"https://d3fvlpdr5b7667.cloudfront.net/wp-content/uploads/2019/11/Jet-Tricks-2.jpg\";s:4:\"slug\";s:10:\"jet-tricks\";s:8:\"basename\";s:25:\"jet-tricks/jet-tricks.php\";s:7:\"img_url\";s:97:\"https://d3fvlpdr5b7667.cloudfront.net/wp-content/uploads/2019/11/plugin-thumb-jet-tricks-icon.png\";s:4:\"desc\";s:124:\"Use different eye-catching stylish animation effects and let your content become truly alive with outstanding visual tricks.\";s:6:\"source\";s:98:\"https://d3fvlpdr5b7667.cloudfront.net/wp-content/uploads/dlm_uploads/2022/09/jet-tricks-v1.4.2.zip\";s:7:\"version\";s:5:\"1.4.2\";s:8:\"required\";s:5:\"false\";s:11:\"recommended\";s:5:\"false\";s:3:\"pro\";s:4:\"true\";s:9:\"more_link\";s:58:\"https://themes.artbees.net/docs/jettricks-plugin-overview/\";s:11:\"is_callable\";s:10:\"Jet_Tricks\";s:10:\"label_type\";s:8:\"Optional\";}i:11;a:18:{s:2:\"id\";i:37736;s:10:\"theme_name\";s:8:\"jupiterx\";s:4:\"name\";s:10:\"Jet Engine\";s:8:\"headline\";s:31:\"Create Dynamic Fields and Pages\";s:5:\"video\";s:50:\"https://www.youtube-nocookie.com/embed/aP_jHmX9hd4\";s:15:\"large_thumbnail\";s:81:\"https://d3fvlpdr5b7667.cloudfront.net/wp-content/uploads/2019/11/Jet-Engine-2.jpg\";s:4:\"slug\";s:10:\"jet-engine\";s:8:\"basename\";s:25:\"jet-engine/jet-engine.php\";s:7:\"img_url\";s:97:\"https://d3fvlpdr5b7667.cloudfront.net/wp-content/uploads/2019/11/plugin-thumb-jet-engine-icon.png\";s:4:\"desc\";s:146:\"Create and manage custom post types, listings and booking forms for them. Completely compatible with Jupiter X Custom Post Type templates feature.\";s:6:\"source\";s:98:\"https://d3fvlpdr5b7667.cloudfront.net/wp-content/uploads/dlm_uploads/2022/11/jet-engine-v3.0.7.zip\";s:7:\"version\";s:5:\"3.0.7\";s:8:\"required\";s:5:\"false\";s:11:\"recommended\";s:5:\"false\";s:3:\"pro\";s:4:\"true\";s:9:\"more_link\";s:58:\"https://themes.artbees.net/docs/jetengine-plugin-overview/\";s:11:\"is_callable\";s:10:\"Jet_Engine\";s:10:\"label_type\";s:8:\"Optional\";}i:12;a:18:{s:2:\"id\";i:37741;s:10:\"theme_name\";s:8:\"jupiterx\";s:4:\"name\";s:16:\"Jet SmartFilters\";s:8:\"headline\";s:32:\"Create Filters For Any Post Type\";s:5:\"video\";s:50:\"https://www.youtube-nocookie.com/embed/uJ2efTTaxD8\";s:15:\"large_thumbnail\";s:87:\"https://d3fvlpdr5b7667.cloudfront.net/wp-content/uploads/2019/11/Jet-SmartFilters-2.jpg\";s:4:\"slug\";s:17:\"jet-smart-filters\";s:8:\"basename\";s:39:\"jet-smart-filters/jet-smart-filters.php\";s:7:\"img_url\";s:103:\"https://d3fvlpdr5b7667.cloudfront.net/wp-content/uploads/2019/11/plugin-thumb-jet-smartfilters-icon.png\";s:4:\"desc\";s:107:\"Adds easy-to-use AJAX filters and widgets to Elementor so you can easily manage your listings and products.\";s:6:\"source\";s:105:\"https://d3fvlpdr5b7667.cloudfront.net/wp-content/uploads/dlm_uploads/2022/11/jet-smart-filters-v3.0.1.zip\";s:7:\"version\";s:5:\"3.0.1\";s:8:\"required\";s:5:\"false\";s:11:\"recommended\";s:5:\"false\";s:3:\"pro\";s:4:\"true\";s:9:\"more_link\";s:64:\"https://themes.artbees.net/docs/jetsmartfilters-plugin-overview/\";s:11:\"is_callable\";s:17:\"Jet_Smart_Filters\";s:10:\"label_type\";s:8:\"Optional\";}i:13;a:16:{s:2:\"id\";i:37746;s:10:\"theme_name\";s:8:\"jupiterx\";s:4:\"name\";s:40:\"WPBakery Page Builder (Modified Version)\";s:8:\"headline\";s:61:\"Use Another Page Builder to Migrate from Jupiter to Jupiter X\";s:15:\"large_thumbnail\";s:77:\"https://d3fvlpdr5b7667.cloudfront.net/wp-content/uploads/2019/11/wpbakery.jpg\";s:4:\"slug\";s:17:\"js_composer_theme\";s:8:\"basename\";s:33:\"js_composer_theme/js_composer.php\";s:7:\"img_url\";s:99:\"https://d3fvlpdr5b7667.cloudfront.net/wp-content/uploads/2019/11/plugin-thumb-js_composer_theme.svg\";s:4:\"desc\";s:140:\"Another page builder with Jupiter X. It can work along side Elementor. Best for the websites that want to migrate from Jupiter to Jupiter X.\";s:6:\"source\";s:113:\"https://d3fvlpdr5b7667.cloudfront.net/wp-content/uploads/dlm_uploads/2020/10/jupiterx_js_composer_theme.6.4.1.zip\";s:7:\"version\";s:5:\"6.4.1\";s:8:\"required\";s:5:\"false\";s:11:\"recommended\";s:5:\"false\";s:3:\"pro\";s:4:\"true\";s:11:\"is_callable\";s:10:\"Vc_Manager\";s:10:\"label_type\";s:8:\"Optional\";}i:14;a:16:{s:2:\"id\";i:37751;s:10:\"theme_name\";s:8:\"jupiterx\";s:4:\"name\";s:13:\"Jupiter Donut\";s:8:\"headline\";s:48:\"Add Jupiter Shortcodes For WPBakery Page Builder\";s:15:\"large_thumbnail\";s:75:\"https://d3fvlpdr5b7667.cloudfront.net/wp-content/uploads/2019/11/donut2.jpg\";s:4:\"slug\";s:13:\"jupiter-donut\";s:8:\"basename\";s:31:\"jupiter-donut/jupiter-donut.php\";s:7:\"img_url\";s:95:\"https://d3fvlpdr5b7667.cloudfront.net/wp-content/uploads/2019/11/plugin-thumb-jupiter-donut.png\";s:4:\"desc\";s:205:\"80+ shortcodes for WPBakery Page Builder. These shortcodes were available in Jupiter and are necessary if you are migrating your theme from Jupiter to Jupiter X and still want to use WPBakery Page Builder.\";s:6:\"source\";s:101:\"https://d3fvlpdr5b7667.cloudfront.net/wp-content/uploads/dlm_uploads/2022/05/jupiter-donut-v1.4.2.zip\";s:7:\"version\";s:5:\"1.4.2\";s:8:\"required\";s:5:\"false\";s:11:\"recommended\";s:5:\"false\";s:3:\"pro\";s:4:\"true\";s:11:\"is_callable\";s:13:\"Jupiter_Donut\";s:10:\"label_type\";s:8:\"Optional\";}i:15;a:17:{s:2:\"id\";i:37755;s:10:\"theme_name\";s:8:\"jupiterx\";s:4:\"name\";s:26:\"Advanced Custom Fields PRO\";s:8:\"headline\";s:19:\"Create Field Groups\";s:15:\"large_thumbnail\";s:76:\"https://d3fvlpdr5b7667.cloudfront.net/wp-content/uploads/2019/11/acf-pro.jpg\";s:4:\"slug\";s:26:\"advanced-custom-fields-pro\";s:8:\"basename\";s:34:\"advanced-custom-fields-pro/acf.php\";s:7:\"img_url\";s:90:\"https://d3fvlpdr5b7667.cloudfront.net/wp-content/uploads/2019/11/plugin-thumb-acf-icon.png\";s:4:\"desc\";s:134:\"Adds the page options to Jupiter X so you can override the global settings on each page. Add and edit extra fields to your post types.\";s:6:\"source\";s:115:\"https://d3fvlpdr5b7667.cloudfront.net/wp-content/uploads/dlm_uploads/2022/07/advanced-custom-fields-pro-v5.12.3.zip\";s:7:\"version\";s:6:\"5.12.3\";s:8:\"required\";s:5:\"false\";s:11:\"recommended\";s:5:\"false\";s:3:\"pro\";s:4:\"true\";s:9:\"more_link\";s:91:\"https://help.artbees.net/getting-started/plugins/advanced-custom-fields-pro-plugin-overview\";s:11:\"is_callable\";s:7:\"acf_pro\";s:10:\"label_type\";s:8:\"Optional\";}i:16;a:15:{s:2:\"id\";i:37759;s:10:\"theme_name\";s:8:\"jupiterx\";s:4:\"name\";s:23:\"Menu Icons by ThemeIsle\";s:8:\"headline\";s:17:\"Add Icons to Menu\";s:15:\"large_thumbnail\";s:79:\"https://d3fvlpdr5b7667.cloudfront.net/wp-content/uploads/2019/11/Menu-Icons.jpg\";s:4:\"slug\";s:10:\"menu-icons\";s:8:\"basename\";s:25:\"menu-icons/menu-icons.php\";s:7:\"img_url\";s:92:\"https://d3fvlpdr5b7667.cloudfront.net/wp-content/uploads/2019/11/plugin-thumb-menu-icons.png\";s:4:\"desc\";s:30:\"Adds icons to your menu items.\";s:8:\"required\";s:5:\"false\";s:11:\"recommended\";s:5:\"false\";s:3:\"pro\";s:5:\"false\";s:9:\"more_link\";s:59:\"https://themes.artbees.net/docs/menu-icons-plugin-overview/\";s:11:\"is_callable\";s:10:\"Menu_Icons\";s:10:\"label_type\";s:8:\"Optional\";}i:17;a:18:{s:2:\"id\";i:37762;s:10:\"theme_name\";s:8:\"jupiterx\";s:4:\"name\";s:17:\"Slider Revolution\";s:8:\"headline\";s:14:\"Create Sliders\";s:5:\"video\";s:43:\"https://www.youtube.com/watch?v=mn5hC07aGvE\";s:15:\"large_thumbnail\";s:80:\"https://d3fvlpdr5b7667.cloudfront.net/wp-content/uploads/2019/11/sliderrev-2.jpg\";s:4:\"slug\";s:9:\"revslider\";s:8:\"basename\";s:23:\"revslider/revslider.php\";s:7:\"img_url\";s:91:\"https://d3fvlpdr5b7667.cloudfront.net/wp-content/uploads/2019/11/slider-revolution-icon.png\";s:4:\"desc\";s:55:\"One of the most advanced premium sliders for WordPress.\";s:6:\"source\";s:97:\"https://d3fvlpdr5b7667.cloudfront.net/wp-content/uploads/dlm_uploads/2022/11/revslider.v6.6.5.zip\";s:7:\"version\";s:5:\"6.6.5\";s:8:\"required\";s:5:\"false\";s:11:\"recommended\";s:5:\"false\";s:3:\"pro\";s:4:\"true\";s:9:\"more_link\";s:66:\"https://themes.artbees.net/docs/slider-revolution-plugin-overview/\";s:11:\"is_callable\";s:14:\"RevSliderFront\";s:10:\"label_type\";s:8:\"Optional\";}i:18;a:17:{s:2:\"id\";i:37767;s:10:\"theme_name\";s:8:\"jupiterx\";s:4:\"name\";s:13:\"Master Slider\";s:8:\"headline\";s:14:\"Create Sliders\";s:15:\"large_thumbnail\";s:82:\"https://d3fvlpdr5b7667.cloudfront.net/wp-content/uploads/2019/11/Master-Slider.jpg\";s:4:\"slug\";s:12:\"masterslider\";s:8:\"basename\";s:29:\"masterslider/masterslider.php\";s:7:\"img_url\";s:100:\"https://d3fvlpdr5b7667.cloudfront.net/wp-content/uploads/2019/11/plugin-thumb-master-slider-icon.jpg\";s:4:\"desc\";s:55:\"One of the most advanced premium sliders for WordPress.\";s:6:\"source\";s:100:\"https://d3fvlpdr5b7667.cloudfront.net/wp-content/uploads/dlm_uploads/2021/12/masterslider-v3.5.9.zip\";s:7:\"version\";s:5:\"3.5.9\";s:8:\"required\";s:5:\"false\";s:11:\"recommended\";s:5:\"false\";s:3:\"pro\";s:4:\"true\";s:9:\"more_link\";s:62:\"https://themes.artbees.net/docs/master-slider-plugin-overview/\";s:11:\"is_callable\";s:13:\"Master_Slider\";s:10:\"label_type\";s:8:\"Optional\";}i:19;a:17:{s:2:\"id\";i:37769;s:10:\"theme_name\";s:8:\"jupiterx\";s:4:\"name\";s:14:\"LayerSlider WP\";s:8:\"headline\";s:14:\"Create Sliders\";s:15:\"large_thumbnail\";s:85:\"https://d3fvlpdr5b7667.cloudfront.net/wp-content/uploads/2019/11/LayerSlider-WP-2.jpg\";s:4:\"slug\";s:11:\"LayerSlider\";s:8:\"basename\";s:27:\"LayerSlider/layerslider.php\";s:7:\"img_url\";s:99:\"https://d3fvlpdr5b7667.cloudfront.net/wp-content/uploads/2019/11/plugin-thumb-layer-slider-icon.png\";s:4:\"desc\";s:108:\"Popular advanced Slider plugin. Build and publish your sliders on your website. License is \"In-Stock Usage\".\";s:6:\"source\";s:100:\"https://d3fvlpdr5b7667.cloudfront.net/wp-content/uploads/dlm_uploads/2022/11/layersliderwp-7.5.3.zip\";s:7:\"version\";s:5:\"7.5.3\";s:8:\"required\";s:5:\"false\";s:11:\"recommended\";s:5:\"false\";s:3:\"pro\";s:4:\"true\";s:9:\"more_link\";s:61:\"https://themes.artbees.net/docs/layer-slider-plugin-overview/\";s:11:\"is_callable\";s:9:\"LS_Config\";s:10:\"label_type\";s:8:\"Optional\";}i:20;a:15:{s:2:\"id\";i:37772;s:10:\"theme_name\";s:8:\"jupiterx\";s:4:\"name\";s:11:\"WooCommerce\";s:8:\"headline\";s:23:\"Build eCommerce Website\";s:15:\"large_thumbnail\";s:80:\"https://d3fvlpdr5b7667.cloudfront.net/wp-content/uploads/2019/11/WooCommerce.jpg\";s:4:\"slug\";s:11:\"woocommerce\";s:8:\"basename\";s:27:\"woocommerce/woocommerce.php\";s:7:\"img_url\";s:98:\"https://d3fvlpdr5b7667.cloudfront.net/wp-content/uploads/2019/11/plugin-thumb-woocommerce-icon.png\";s:4:\"desc\";s:131:\"Create and manage your e-commerce website with this plugin. After activating, the Shop section in the Customizer will be available.\";s:8:\"required\";s:5:\"false\";s:11:\"recommended\";s:5:\"false\";s:3:\"pro\";s:5:\"false\";s:9:\"more_link\";s:60:\"https://themes.artbees.net/docs/woocommerce-plugin-overview/\";s:11:\"is_callable\";s:11:\"WooCommerce\";s:10:\"label_type\";s:8:\"Optional\";}i:21;a:15:{s:2:\"id\";i:37774;s:10:\"theme_name\";s:8:\"jupiterx\";s:4:\"name\";s:24:\"Customizer Export/Import\";s:8:\"headline\";s:42:\"Add Export and Import Option to Customizer\";s:15:\"large_thumbnail\";s:93:\"https://d3fvlpdr5b7667.cloudfront.net/wp-content/uploads/2019/11/customizer-import-export.jpg\";s:4:\"slug\";s:24:\"customizer-export-import\";s:8:\"basename\";s:53:\"customizer-export-import/customizer-export-import.php\";s:7:\"img_url\";s:111:\"https://d3fvlpdr5b7667.cloudfront.net/wp-content/uploads/2019/11/plugin-thumb-customizer-export-import-icon.png\";s:4:\"desc\";s:112:\"Adds the Export and import option to the Customizer. Useful for theme migrations and moving to the child themes.\";s:8:\"required\";s:5:\"false\";s:11:\"recommended\";s:5:\"false\";s:3:\"pro\";s:5:\"false\";s:9:\"more_link\";s:73:\"https://themes.artbees.net/docs/customizer-export-import-plugin-overview/\";s:11:\"is_callable\";s:8:\"CEI_Core\";s:10:\"label_type\";s:8:\"Optional\";}i:22;a:15:{s:2:\"id\";i:37776;s:10:\"theme_name\";s:8:\"jupiterx\";s:4:\"name\";s:16:\"Customizer Reset\";s:8:\"headline\";s:26:\"Reset Theme Customizations\";s:15:\"large_thumbnail\";s:85:\"https://d3fvlpdr5b7667.cloudfront.net/wp-content/uploads/2019/11/customizer-reset.jpg\";s:4:\"slug\";s:26:\"customizer-reset-by-wpzoom\";s:8:\"basename\";s:47:\"customizer-reset-by-wpzoom/customizer-reset.php\";s:7:\"img_url\";s:103:\"https://d3fvlpdr5b7667.cloudfront.net/wp-content/uploads/2019/11/plugin-thumb-customizer-reset-icon.png\";s:4:\"desc\";s:107:\"Reset theme customizations made via WordPress Customizer. Useful for troubleshooting the customizer issues.\";s:8:\"required\";s:5:\"false\";s:11:\"recommended\";s:5:\"false\";s:3:\"pro\";s:5:\"false\";s:9:\"more_link\";s:65:\"https://themes.artbees.net/docs/customizer-reset-plugin-overview/\";s:11:\"is_callable\";s:21:\"ZOOM_Customizer_Reset\";s:10:\"label_type\";s:8:\"Optional\";}i:23;a:16:{s:2:\"id\";i:45885;s:10:\"theme_name\";s:8:\"jupiterx\";s:4:\"name\";s:8:\"WunderWP\";s:8:\"headline\";s:65:\"Build Pages Quickly With Presets and Reusable Styles or Templates\";s:5:\"video\";s:50:\"https://www.youtube-nocookie.com/embed/nW4vduTqD64\";s:15:\"large_thumbnail\";s:79:\"https://d3fvlpdr5b7667.cloudfront.net/wp-content/uploads/2020/02/wunderwp-2.jpg\";s:4:\"slug\";s:8:\"wunderwp\";s:8:\"basename\";s:21:\"wunderwp/wunderwp.php\";s:7:\"img_url\";s:89:\"https://d3fvlpdr5b7667.cloudfront.net/wp-content/uploads/2020/02/wunderwp_plugin_icon.png\";s:4:\"desc\";s:151:\"Save and reuse your Elementor styles or templates in the WunderWP Cloud or use readymade styles to quickly beautify your Elementor pages. All for free!\";s:8:\"required\";s:5:\"false\";s:11:\"recommended\";s:5:\"false\";s:3:\"pro\";s:5:\"false\";s:9:\"more_link\";s:21:\"https://wunderwp.com/\";s:11:\"is_callable\";s:8:\"WunderWP\";s:10:\"label_type\";s:8:\"Optional\";}i:24;a:16:{s:2:\"id\";i:74379;s:10:\"theme_name\";s:8:\"jupiterx\";s:4:\"name\";s:9:\"Growmatik\";s:8:\"headline\";s:44:\"All-in-one Personalized Marketing Automation\";s:5:\"video\";s:50:\"https://www.youtube-nocookie.com/embed/vdk09PMWit4\";s:15:\"large_thumbnail\";s:78:\"https://d3fvlpdr5b7667.cloudfront.net/wp-content/uploads/2020/08/growmatik.jpg\";s:4:\"slug\";s:40:\"marketing-automation-and-personalization\";s:8:\"basename\";s:54:\"marketing-automation-and-personalization/growmatik.php\";s:7:\"img_url\";s:83:\"https://d3fvlpdr5b7667.cloudfront.net/wp-content/uploads/2020/08/growmatik-logo.png\";s:4:\"desc\";s:150:\"Growmatik automates your marketing and personalizes your customer experience across their journey by highly-personalized web pages, emails and popups.\";s:8:\"required\";s:5:\"false\";s:11:\"recommended\";s:5:\"false\";s:3:\"pro\";s:5:\"false\";s:9:\"more_link\";s:93:\"https://app.growmatik.ai/start/?utm_source=JupiterXSuggestedPlugin&utm_campaign=JupiterXAdmin\";s:11:\"is_callable\";s:9:\"Growmatik\";s:10:\"label_type\";s:8:\"Optional\";}}","no");
INSERT INTO ceba_options VALUES("213","theme_switched","","yes");
INSERT INTO ceba_options VALUES("142","yoast_migrations_free","a:1:{s:7:\"version\";s:5:\"19.11\";}","yes");
INSERT INTO ceba_options VALUES("143","wpseo","a:99:{s:8:\"tracking\";b:0;s:22:\"license_server_version\";b:0;s:15:\"ms_defaults_set\";b:0;s:40:\"ignore_search_engines_discouraged_notice\";b:0;s:19:\"indexing_first_time\";b:1;s:16:\"indexing_started\";b:0;s:15:\"indexing_reason\";s:20:\"taxonomy_made_public\";s:29:\"indexables_indexing_completed\";b:1;s:13:\"index_now_key\";s:0:\"\";s:7:\"version\";s:5:\"19.11\";s:16:\"previous_version\";s:0:\"\";s:20:\"disableadvanced_meta\";b:1;s:30:\"enable_headless_rest_endpoints\";b:1;s:17:\"ryte_indexability\";b:0;s:11:\"baiduverify\";s:0:\"\";s:12:\"googleverify\";s:0:\"\";s:8:\"msverify\";s:0:\"\";s:12:\"yandexverify\";s:0:\"\";s:9:\"site_type\";s:0:\"\";s:20:\"has_multiple_authors\";s:0:\"\";s:16:\"environment_type\";s:0:\"\";s:23:\"content_analysis_active\";b:1;s:23:\"keyword_analysis_active\";b:1;s:34:\"inclusive_language_analysis_active\";b:0;s:21:\"enable_admin_bar_menu\";b:1;s:26:\"enable_cornerstone_content\";b:1;s:18:\"enable_xml_sitemap\";b:1;s:24:\"enable_text_link_counter\";b:1;s:16:\"enable_index_now\";b:1;s:22:\"show_onboarding_notice\";b:1;s:18:\"first_activated_on\";i:1669883875;s:13:\"myyoast-oauth\";b:0;s:26:\"semrush_integration_active\";b:1;s:14:\"semrush_tokens\";a:0:{}s:20:\"semrush_country_code\";s:2:\"us\";s:19:\"permalink_structure\";s:46:\"/index.php/%year%/%monthnum%/%day%/%postname%/\";s:8:\"home_url\";s:40:\"https://zanzibartreasuretours.ceba.co.tz\";s:18:\"dynamic_permalinks\";b:0;s:17:\"category_base_url\";s:0:\"\";s:12:\"tag_base_url\";s:0:\"\";s:21:\"custom_taxonomy_slugs\";a:0:{}s:29:\"enable_enhanced_slack_sharing\";b:1;s:25:\"zapier_integration_active\";b:0;s:19:\"zapier_subscription\";a:0:{}s:14:\"zapier_api_key\";s:0:\"\";s:23:\"enable_metabox_insights\";b:1;s:23:\"enable_link_suggestions\";b:1;s:26:\"algolia_integration_active\";b:0;s:14:\"import_cursors\";a:0:{}s:13:\"workouts_data\";a:1:{s:13:\"configuration\";a:1:{s:13:\"finishedSteps\";a:0:{}}}s:28:\"configuration_finished_steps\";a:0:{}s:36:\"dismiss_configuration_workout_notice\";b:0;s:34:\"dismiss_premium_deactivated_notice\";b:0;s:19:\"importing_completed\";a:0:{}s:26:\"wincher_integration_active\";b:1;s:14:\"wincher_tokens\";a:0:{}s:36:\"wincher_automatically_add_keyphrases\";b:0;s:18:\"wincher_website_id\";s:0:\"\";s:28:\"wordproof_integration_active\";b:0;s:29:\"wordproof_integration_changed\";b:0;s:18:\"first_time_install\";b:1;s:34:\"should_redirect_after_install_free\";b:0;s:34:\"activation_redirect_timestamp_free\";i:1669883875;s:18:\"remove_feed_global\";b:0;s:27:\"remove_feed_global_comments\";b:0;s:25:\"remove_feed_post_comments\";b:0;s:19:\"remove_feed_authors\";b:0;s:22:\"remove_feed_categories\";b:0;s:16:\"remove_feed_tags\";b:0;s:29:\"remove_feed_custom_taxonomies\";b:0;s:22:\"remove_feed_post_types\";b:0;s:18:\"remove_feed_search\";b:0;s:21:\"remove_atom_rdf_feeds\";b:0;s:17:\"remove_shortlinks\";b:0;s:21:\"remove_rest_api_links\";b:0;s:20:\"remove_rsd_wlw_links\";b:0;s:19:\"remove_oembed_links\";b:0;s:16:\"remove_generator\";b:0;s:20:\"remove_emoji_scripts\";b:0;s:24:\"remove_powered_by_header\";b:0;s:22:\"remove_pingback_header\";b:0;s:28:\"clean_campaign_tracking_urls\";b:0;s:16:\"clean_permalinks\";b:0;s:32:\"clean_permalinks_extra_variables\";s:0:\"\";s:14:\"search_cleanup\";b:0;s:20:\"search_cleanup_emoji\";b:0;s:23:\"search_cleanup_patterns\";b:0;s:22:\"search_character_limit\";i:50;s:20:\"deny_search_crawling\";b:0;s:21:\"deny_wp_json_crawling\";b:0;s:27:\"redirect_search_pretty_urls\";b:0;s:29:\"least_readability_ignore_list\";a:0:{}s:27:\"least_seo_score_ignore_list\";a:0:{}s:23:\"most_linked_ignore_list\";a:0:{}s:24:\"least_linked_ignore_list\";a:0:{}s:28:\"indexables_page_reading_list\";a:5:{i:0;b:0;i:1;b:0;i:2;b:0;i:3;b:0;i:4;b:0;}s:25:\"indexables_overview_state\";s:21:\"dashboard-not-visited\";s:28:\"last_known_public_post_types\";a:9:{i:0;s:4:\"post\";i:1;s:4:\"page\";i:2;s:10:\"attachment\";i:3;s:14:\"e-landing-page\";i:4;s:17:\"elementor_library\";i:5;s:9:\"portfolio\";i:6;s:14:\"jupiterx-codes\";i:7;s:14:\"jupiterx-fonts\";i:8;s:14:\"jupiterx-icons\";}s:28:\"last_known_public_taxonomies\";a:5:{i:0;s:8:\"category\";i:1;s:8:\"post_tag\";i:2;s:11:\"post_format\";i:3;s:18:\"portfolio_category\";i:4;s:13:\"portfolio_tag\";}}","yes");
INSERT INTO ceba_options VALUES("144","wpseo_titles","a:107:{s:17:\"forcerewritetitle\";b:0;s:9:\"separator\";s:7:\"sc-dash\";s:16:\"title-home-wpseo\";s:42:\"%%sitename%% %%page%% %%sep%% %%sitedesc%%\";s:18:\"title-author-wpseo\";s:41:\"%%name%%, Author at %%sitename%% %%page%%\";s:19:\"title-archive-wpseo\";s:38:\"%%date%% %%page%% %%sep%% %%sitename%%\";s:18:\"title-search-wpseo\";s:63:\"You searched for %%searchphrase%% %%page%% %%sep%% %%sitename%%\";s:15:\"title-404-wpseo\";s:35:\"Page not found %%sep%% %%sitename%%\";s:25:\"social-title-author-wpseo\";s:8:\"%%name%%\";s:26:\"social-title-archive-wpseo\";s:8:\"%%date%%\";s:31:\"social-description-author-wpseo\";s:0:\"\";s:32:\"social-description-archive-wpseo\";s:0:\"\";s:29:\"social-image-url-author-wpseo\";s:0:\"\";s:30:\"social-image-url-archive-wpseo\";s:0:\"\";s:28:\"social-image-id-author-wpseo\";i:0;s:29:\"social-image-id-archive-wpseo\";i:0;s:19:\"metadesc-home-wpseo\";s:0:\"\";s:21:\"metadesc-author-wpseo\";s:0:\"\";s:22:\"metadesc-archive-wpseo\";s:0:\"\";s:9:\"rssbefore\";s:0:\"\";s:8:\"rssafter\";s:53:\"The post %%POSTLINK%% appeared first on %%BLOGLINK%%.\";s:20:\"noindex-author-wpseo\";b:0;s:28:\"noindex-author-noposts-wpseo\";b:1;s:21:\"noindex-archive-wpseo\";b:1;s:14:\"disable-author\";b:0;s:12:\"disable-date\";b:0;s:19:\"disable-post_format\";b:0;s:18:\"disable-attachment\";b:1;s:20:\"breadcrumbs-404crumb\";s:25:\"Error 404: Page not found\";s:29:\"breadcrumbs-display-blog-page\";b:1;s:20:\"breadcrumbs-boldlast\";b:0;s:25:\"breadcrumbs-archiveprefix\";s:12:\"Archives for\";s:18:\"breadcrumbs-enable\";b:1;s:16:\"breadcrumbs-home\";s:4:\"Home\";s:18:\"breadcrumbs-prefix\";s:0:\"\";s:24:\"breadcrumbs-searchprefix\";s:16:\"You searched for\";s:15:\"breadcrumbs-sep\";s:2:\"»\";s:12:\"website_name\";s:0:\"\";s:11:\"person_name\";s:0:\"\";s:11:\"person_logo\";s:0:\"\";s:22:\"alternate_website_name\";s:0:\"\";s:12:\"company_logo\";s:0:\"\";s:12:\"company_name\";s:0:\"\";s:22:\"company_alternate_name\";s:0:\"\";s:17:\"company_or_person\";s:7:\"company\";s:25:\"company_or_person_user_id\";b:0;s:17:\"stripcategorybase\";b:0;s:26:\"open_graph_frontpage_title\";s:12:\"%%sitename%%\";s:25:\"open_graph_frontpage_desc\";s:0:\"\";s:26:\"open_graph_frontpage_image\";s:0:\"\";s:10:\"title-post\";s:39:\"%%title%% %%page%% %%sep%% %%sitename%%\";s:13:\"metadesc-post\";s:0:\"\";s:12:\"noindex-post\";b:0;s:23:\"display-metabox-pt-post\";b:1;s:23:\"post_types-post-maintax\";i:0;s:21:\"schema-page-type-post\";s:7:\"WebPage\";s:24:\"schema-article-type-post\";s:7:\"Article\";s:17:\"social-title-post\";s:9:\"%%title%%\";s:23:\"social-description-post\";s:0:\"\";s:21:\"social-image-url-post\";s:0:\"\";s:20:\"social-image-id-post\";i:0;s:10:\"title-page\";s:39:\"%%title%% %%page%% %%sep%% %%sitename%%\";s:13:\"metadesc-page\";s:0:\"\";s:12:\"noindex-page\";b:0;s:23:\"display-metabox-pt-page\";b:1;s:23:\"post_types-page-maintax\";i:0;s:21:\"schema-page-type-page\";s:7:\"WebPage\";s:24:\"schema-article-type-page\";s:4:\"None\";s:17:\"social-title-page\";s:9:\"%%title%%\";s:23:\"social-description-page\";s:0:\"\";s:21:\"social-image-url-page\";s:0:\"\";s:20:\"social-image-id-page\";i:0;s:16:\"title-attachment\";s:39:\"%%title%% %%page%% %%sep%% %%sitename%%\";s:19:\"metadesc-attachment\";s:0:\"\";s:18:\"noindex-attachment\";b:0;s:29:\"display-metabox-pt-attachment\";b:1;s:29:\"post_types-attachment-maintax\";i:0;s:27:\"schema-page-type-attachment\";s:7:\"WebPage\";s:30:\"schema-article-type-attachment\";s:4:\"None\";s:18:\"title-tax-category\";s:53:\"%%term_title%% Archives %%page%% %%sep%% %%sitename%%\";s:21:\"metadesc-tax-category\";s:0:\"\";s:28:\"display-metabox-tax-category\";b:1;s:20:\"noindex-tax-category\";b:0;s:25:\"social-title-tax-category\";s:23:\"%%term_title%% Archives\";s:31:\"social-description-tax-category\";s:0:\"\";s:29:\"social-image-url-tax-category\";s:0:\"\";s:28:\"social-image-id-tax-category\";i:0;s:18:\"title-tax-post_tag\";s:53:\"%%term_title%% Archives %%page%% %%sep%% %%sitename%%\";s:21:\"metadesc-tax-post_tag\";s:0:\"\";s:28:\"display-metabox-tax-post_tag\";b:1;s:20:\"noindex-tax-post_tag\";b:0;s:25:\"social-title-tax-post_tag\";s:23:\"%%term_title%% Archives\";s:31:\"social-description-tax-post_tag\";s:0:\"\";s:29:\"social-image-url-tax-post_tag\";s:0:\"\";s:28:\"social-image-id-tax-post_tag\";i:0;s:21:\"title-tax-post_format\";s:53:\"%%term_title%% Archives %%page%% %%sep%% %%sitename%%\";s:24:\"metadesc-tax-post_format\";s:0:\"\";s:31:\"display-metabox-tax-post_format\";b:1;s:23:\"noindex-tax-post_format\";b:1;s:28:\"social-title-tax-post_format\";s:23:\"%%term_title%% Archives\";s:34:\"social-description-tax-post_format\";s:0:\"\";s:32:\"social-image-url-tax-post_format\";s:0:\"\";s:31:\"social-image-id-tax-post_format\";i:0;s:14:\"person_logo_id\";i:0;s:15:\"company_logo_id\";i:0;s:17:\"company_logo_meta\";b:0;s:16:\"person_logo_meta\";b:0;s:29:\"open_graph_frontpage_image_id\";i:0;}","yes");
INSERT INTO ceba_options VALUES("145","wpseo_social","a:19:{s:13:\"facebook_site\";s:0:\"\";s:13:\"instagram_url\";s:0:\"\";s:12:\"linkedin_url\";s:0:\"\";s:11:\"myspace_url\";s:0:\"\";s:16:\"og_default_image\";s:0:\"\";s:19:\"og_default_image_id\";s:0:\"\";s:18:\"og_frontpage_title\";s:0:\"\";s:17:\"og_frontpage_desc\";s:0:\"\";s:18:\"og_frontpage_image\";s:0:\"\";s:21:\"og_frontpage_image_id\";s:0:\"\";s:9:\"opengraph\";b:1;s:13:\"pinterest_url\";s:0:\"\";s:15:\"pinterestverify\";s:0:\"\";s:7:\"twitter\";b:1;s:12:\"twitter_site\";s:0:\"\";s:17:\"twitter_card_type\";s:19:\"summary_large_image\";s:11:\"youtube_url\";s:0:\"\";s:13:\"wikipedia_url\";s:0:\"\";s:17:\"other_social_urls\";a:0:{}}","yes");
INSERT INTO ceba_options VALUES("171","_site_transient_browser_f981dd2164895fca9576214ea5750ede","a:10:{s:4:\"name\";s:6:\"Safari\";s:7:\"version\";s:4:\"16.1\";s:8:\"platform\";s:9:\"Macintosh\";s:10:\"update_url\";s:29:\"https://www.apple.com/safari/\";s:7:\"img_src\";s:43:\"http://s.w.org/images/browsers/safari.png?1\";s:11:\"img_src_ssl\";s:44:\"https://s.w.org/images/browsers/safari.png?1\";s:15:\"current_version\";s:2:\"11\";s:7:\"upgrade\";b:0;s:8:\"insecure\";b:0;s:6:\"mobile\";b:0;}","no");
INSERT INTO ceba_options VALUES("172","_site_transient_timeout_php_check_a5907c2ea4d6fbd7e531b3aa7734f0e4","1670488946","no");
INSERT INTO ceba_options VALUES("173","_site_transient_php_check_a5907c2ea4d6fbd7e531b3aa7734f0e4","a:5:{s:19:\"recommended_version\";s:3:\"7.4\";s:15:\"minimum_version\";s:6:\"5.6.20\";s:12:\"is_supported\";b:0;s:9:\"is_secure\";b:0;s:13:\"is_acceptable\";b:0;}","no");
INSERT INTO ceba_options VALUES("149","_transient_googlesitekit_verification_meta_tags","a:0:{}","yes");
INSERT INTO ceba_options VALUES("153","googlesitekit_db_version","1.3.0","yes");
INSERT INTO ceba_options VALUES("158","_transient_timeout_wpseo_total_unindexed_post_type_archives","1669970545","no");
INSERT INTO ceba_options VALUES("159","_transient_wpseo_total_unindexed_post_type_archives","0","no");
INSERT INTO ceba_options VALUES("160","_transient_timeout_wpseo_total_unindexed_general_items","1669970546","no");
INSERT INTO ceba_options VALUES("161","_transient_wpseo_total_unindexed_general_items","0","no");
INSERT INTO ceba_options VALUES("170","_site_transient_timeout_browser_f981dd2164895fca9576214ea5750ede","1670488946","no");
INSERT INTO ceba_options VALUES("177","_site_transient_timeout_community-events-533aadd0e18f38fc88cf15109871ebe0","1669927352","no");
INSERT INTO ceba_options VALUES("182","_transient_timeout_feed_mod_9bbd59226dc36b9b26cd43f15694c5c3","1669927353","no");
INSERT INTO ceba_options VALUES("183","_transient_feed_mod_9bbd59226dc36b9b26cd43f15694c5c3","1669884153","no");
INSERT INTO ceba_options VALUES("184","_transient_timeout_feed_d117b5738fbd35bd8c0391cda1f2b5d9","1669927353","no");
INSERT INTO ceba_options VALUES("185","_transient_feed_d117b5738fbd35bd8c0391cda1f2b5d9","a:4:{s:5:\"child\";a:1:{s:0:\"\";a:1:{s:3:\"rss\";a:1:{i:0;a:6:{s:4:\"data\";s:3:\"\n\n\n\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:7:\"version\";s:3:\"2.0\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:1:{s:0:\"\";a:1:{s:7:\"channel\";a:1:{i:0;a:6:{s:4:\"data\";s:61:\"\n	\n	\n	\n	\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:1:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:16:\"WordPress Planet\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:28:\"http://planet.wordpress.org/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"language\";a:1:{i:0;a:5:{s:4:\"data\";s:2:\"en\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:47:\"WordPress Planet - http://planet.wordpress.org/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"item\";a:50:{i:0;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:99:\"WPTavern: ElasticPress 4.4.0 Adds New Status Report Page and Instant Results Template Customization\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:30:\"https://wptavern.com/?p=139973\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:110:\"https://wptavern.com/elasticpress-4-4-0-adds-new-status-report-page-and-instant-results-template-customization\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:2708:\"<p>10up has released <a href=\"https://github.com/10up/ElasticPress/releases/tag/4.4.0\">version 4.4.0</a> of <a href=\"https://wordpress.org/plugins/elasticpress/\">ElasticPress</a>, its enhanced search plugin that speeds up searching while reducing the load on WordPress sites. The plugin is based on Elasticsearch and is used by customers of the ElasticPress.io service (a SaaS solution), as well as those who are hosting their own Elasticsearch instance.</p>\n\n\n\n<p>This update adds a new &#8220;Status Report&#8221; page in the dashboard with information that can be helpful for troubleshooting ElasticPress and synced content. The UI uses Gutenberg components for the collapsible sections. Version 4.4.0 introduces a new query logger functionality that stores failed queries (up to 5 in the last 24 hours) and displays an admin notice if failed queries are detected. The failed queries are displayed on the new Status Report page.</p>\n\n\n\n<img />\n\n\n\n<p>Another highlight of this release is the ability to <a href=\"https://github.com/10up/ElasticPress/pull/2959\">customize the template for Instant Results</a>. It gives developers a JavaScript hook for replacing the component used to render search results in Instant Results. The Instant Results feature <a href=\"https://www.elasticpress.io/blog/2022/03/introducing-instant-results-wordpress-fastest-search-ever/\">was introduced in March</a> with limited customization capabilities. It added a new search modal over the page content that inherits the site&#8217;s styles. Developers could adjust the appearance and expose facets, but this new update gives them control over the whole template.</p>\n\n\n\n<p>Another small but useful update in this release is the ability to <a href=\"https://github.com/10up/ElasticPress/pull/3100\">exclude a specific post from Search</a>. This helps site owners further customize the search experience to deliver only the intended results. </p>\n\n\n\n<p>Developers who are using the plugin should take note of the announcement included in this release regarding the migration of the Users feature to the ElasticPress Labs plugin, which houses more experimental features:</p>\n\n\n\n<blockquote class=\"wp-block-quote\">\n<p>Note that starting from the ElasticPress 5.0.0 release the <code>Users</code> feature will be moved to the <a href=\"https://github.com/10up/ElasticPressLabs\">ElasticPress Labs</a> plugin. The <code>Terms</code> and <code>Comments</code> features will remain in ElasticPress but will be available only if enabled via code.</p>\n</blockquote>\n\n\n\n<p>Check out the full list of updates and bug fixes on GitHub in the <a href=\"https://github.com/10up/ElasticPress/releases/tag/4.4.0\">changelog</a> for 4.4.0. </p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Thu, 01 Dec 2022 05:22:10 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Sarah Gooding\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:1;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:67:\"WPTavern: WordPress Versions 3.7-4.0 No Longer Get Security Updates\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:30:\"https://wptavern.com/?p=139956\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:78:\"https://wptavern.com/wordpress-versions-3-7-4-0-no-longer-get-security-updates\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:1338:\"<p>In September, WordPress’ Security Team announced it would be <a href=\"https://wptavern.com/wordpress-to-drop-security-updates-for-versions-3-7-through-4-0-by-december-2022\">dropping support for versions 3.7 through 4.0</a> by December 1, 2022. Yesterday the final releases for these versions (3.7.41, 3.8.41, 3.9.40, and 4.0.38) were made available to the very small percentage of users who are running ancient versions of WordPress. </p>\n\n\n\n<p>As part of the final releases, the upgrade notification now informs users that they are on a version that is no longer receiving security updates. This affects fewer than 1% of total installs. The vast majority of WordPress sites are running 4.1 or later and will continue receiving security updates. </p>\n\n\n\n<p>Wherever possible, WordPress users should be running 6.1.1 on PHP 8 or later. (Although PHP 7.4 is the <a href=\"https://wordpress.org/about/requirements/\">minimum version</a> required to use WordPress, <a href=\"https://www.php.net/supported-versions.php\">PHP 7.4 reached end of life two days ago</a> and will no longer be receiving security updates. Version 8.0 will reach EOL in 11 months.)</p>\n\n\n\n<p>Now that the Security Team is no longer obligated to backport security updates to very old versions, it frees up their time to better support newer versions of WordPress.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Wed, 30 Nov 2022 20:53:48 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Sarah Gooding\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:2;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:54:\"WordPress.org blog: People of WordPress: Huanyi Chuang\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:35:\"https://wordpress.org/news/?p=13562\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:69:\"https://wordpress.org/news/2022/11/people-of-wordpress-huanyi-chuang/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:9814:\"<p><strong>This month we feature Huanyi (Eric) Chuang, a front end developer from Taiwan, who helps connect local groups to WordPress and the worldwide open source community. He is part of the team helping to make the first WordCamp Asia a success in 2023.</strong></p>\n\n\n\n<p><strong>The People of WordPress series shares some of the inspiring stories of how people&#8217;s lives can change for the better through WordPress and its global network of contributors.</strong></p>\n\n\n\n<img width=\"1014\" height=\"627\" src=\"https://i0.wp.com/wordpress.org/news/files/2022/09/huanyi-featured-img.jpg?resize=1014%2C627&ssl=1\" alt=\"Huanyi pictured sitting inside a rock formation.\" class=\"wp-image-13479\" />\n\n\n\n<h2><strong>Discovering WordPress and the benefit of child themes </strong></h2>\n\n\n\n<p>Huanyi’s first footsteps in WordPress began in 2017 when he worked for a firm that built blogs and developed ad content for clients.</p>\n\n\n\n<p>After building a few sites using the platform, he discovered child themes and through them opened up a world of possibilities for his clients. To this day, he uses child themes to deliver truly custom designs and functionality for clients.</p>\n\n\n\n<p>Later in his career, Huanyi moved into digital marketing, integrating sites with massive ad platforms like Google and Facebook. This led him to learn to work with tracking code and JavaScript. He also began his learning journey in HTML, CSS, and PHP, to be able to improve his development skills and customize child themes.</p>\n\n\n\n<h2><strong>Meetups bring together software users to learn together</strong></h2>\n\n\n\n<img width=\"600\" height=\"800\" src=\"https://i2.wp.com/wordpress.org/news/files/2022/09/huanyi-1.jpg?fit=600%2C800&ssl=1\" alt=\"Huanyi and a koala.\" class=\"wp-image-13476\" /><em>Huanyi pictured in Australia during one of his travels meeting a koala bear.</em>\n\n\n\n<p>When Huanyi had a problem with a client&#8217;s site, he looked to WordPress meetups near where he lived in <a href=\"https://www.meetup.com/Taipei-WordPress/\">Taipei</a> to help find the solutions.</p>\n\n\n\n<blockquote class=\"wp-block-quote\">\n<p><strong>“When I encountered an issue with the custom archive pages, a local meetup announcement showed up on my WordPress dashboard</strong>.&#8221;</p>\n<cite>Huanyi Chuang</cite></blockquote>\n\n\n\n<p>At the meetup, he met more experienced WordPress users and developers there, who answered his questions and helped him learn.</p>\n\n\n\n<p>“When I encountered an issue with the custom archive pages, a local meetup announcement showed up on my WordPress dashboard. That was my original connection with the local community,” Huanyi said.</p>\n\n\n\n<p>The WordPress community gave Huanyi a chance to connect with people, feed his curiosity about the software, and join a circle of people he could share this interest.</p>\n\n\n\n<p>At first, he thought meetups were an opportunity to source new clients, and he took his business cards to every event. However, he soon found that these events offered him the opportunity to make friends and share knowledge.</p>\n\n\n\n<p>From then on, Huanyi started focusing more on what he could give to these events and networks, making new friends, and listening to people. This led him to share as a meetup speaker his own commercial website management experience.</p>\n\n\n\n<h2><strong>The road to WordCamp</strong></h2>\n\n\n\n<p>It was going to his first meetup and then getting involved with WordCamps that changed Huanyi&#8217;s whole relationship with WordPress.</p>\n\n\n\n<img width=\"600\" height=\"800\" src=\"https://i0.wp.com/wordpress.org/news/files/2022/09/huanyi-2.jpg?resize=600%2C800&ssl=1\" alt=\"Huanyi pictured on an outing, stood next to a white car.\" class=\"wp-image-13477\" />\n\n\n\n<p>In 2018, he took the step to help as an organizer, having joined the Taoyuan Meetup in Taiwan. He played several parts across the organizing team, and the welcoming feeling he got in every situation encouraged him to get more involved.</p>\n\n\n\n<p>He recalls meeting new friends from different fields and other countries, which gave him a great sense of achievement and strengthened his passion for participating in the community.</p>\n\n\n\n<p>When the team started this meetup, numbers were much lower than in the group in the city of Taipei, but they were not disheartened and gradually grew the local WordPress community.</p>\n\n\n\n<p>They created a pattern of ‘multiple organizers,’ which spread the workload and grew friendships.&nbsp;</p>\n\n\n\n<blockquote class=\"wp-block-quote\">\n<p><strong>“Being connected to and from meetups is the most valuable part of the community. Having these friends makes me gather more information. We share information and benefit from others’ information, and thus we gain more trust in each other. With such credibility, we share more deeply and build deeper relations.”</strong> </p>\n<cite>Huanyi Chuang</cite></blockquote>\n\n\n\n<p>Before the pandemic, the meetup met every month and grew to become the second largest meetup in Taiwan. Huanyi also contributed to the WordPress community as an organizer of WordCamp Taipei 2018 in the speaker team and lead organizer of <a href=\"https://taiwan.wordcamp.org/2021/\">WordCamp Taiwan 2021</a>.</p>\n\n\n\n<h2><strong>So why should you join the community?</strong></h2>\n\n\n\n<p>According to Huanyi, you will always have something to take home with you. It might be new information or experiences. It might be plugins or theme ideas. But most of all, it is the chance to meet fascinating people and make new friends.</p>\n\n\n\n<blockquote class=\"wp-block-quote\">\n<p>Huanyi’s message to other contributors:<br />&#8220;Keep participating, and you will find more you can achieve than you expect.” </p>\n</blockquote>\n\n\n\n<p>He added that long-term participation will &#8216;let you feel the humanity behind the project&#8217;.</p>\n\n\n\n<h2><strong>Localize: the road ahead for WordPress</strong></h2>\n\n\n\n<img width=\"900\" height=\"675\" src=\"https://i0.wp.com/wordpress.org/news/files/2022/09/huanyi-3.jpg?resize=900%2C675&ssl=1\" alt=\"Huanyi standing on a sandy beach.\" class=\"wp-image-13478\" />\n\n\n\n<p>Huanyi believes WordPress has the power to break down the barriers between designers, project managers, developers, marketers, writers, and publishers. In Taiwan, he said WordPress is &#8216;a common protocol&#8217; that lets people from all of these disciplines work and communicate together more easily than they ever have before.</p>\n\n\n\n<p>That is why he works on and encourages others to localize plugins today. He believes localization of the software is the foundation for the extension of the WordPress community as it enables people to ‘Flex their Freedom’ in a language they speak!</p>\n\n\n\n<p>He has helped to organize online events around previous <a href=\"https://wptranslationday.org/\">WordPress Translation Day</a> events.</p>\n\n\n\n<p>Huanyi said: “I think it&#8217;s important to localize WordPress because its very concept of ‘open source’ means that people can access it freely. In another way, free from the monopoly of knowledge and speech. To achieve it, it&#8217;s important that people can access it with their own language.</p>\n\n\n\n<p>“Localization is the foundation of the extension of WordPress community because it helps people using different languages to access the project and lowers the hurdle to understand how things work.”</p>\n\n\n\n<h2>Share the stories</h2>\n\n\n\n<p>Help share these stories of open source contributors and continue to grow the community. Meet more WordPressers in the <a href=\"https://wordpress.org/news/category/newsletter/interviews/\">People of WordPress series</a>.</p>\n\n\n\n<h2><strong>Contributors</strong></h2>\n\n\n\n<p>Thank you to <a href=\"https://profiles.wordpress.org/no249a002/\" class=\"mention\"><span class=\"mentions-prefix\">@</span>no249a002</a> for sharing his adventures in WordPress.</p>\n\n\n\n<p>Thank you to Abha Thakor (<a href=\"https://profiles.wordpress.org/webcommsat/\" class=\"mention\"><span class=\"mentions-prefix\">@</span>webcommsat</a>), Mary Baum (<a href=\"https://profiles.wordpress.org/marybaum/\" class=\"mention\"><span class=\"mentions-prefix\">@</span>marybaum</a>), Meher Bala (<a href=\"https://profiles.wordpress.org/meher/\" class=\"mention\"><span class=\"mentions-prefix\">@</span>meher</a>), Chloe Bringmann (<a href=\"https://profiles.wordpress.org/cbringmann/\" class=\"mention\"><span class=\"mentions-prefix\">@</span>cbringmann</a>), Surendra Thakor (<a href=\"https://profiles.wordpress.org/sthakor/\" class=\"mention\"><span class=\"mentions-prefix\">@</span>sthakor</a>), Adeeb Malik (<a href=\"https://profiles.wordpress.org/adeebmalik/\" class=\"mention\"><span class=\"mentions-prefix\">@</span>adeebmalik</a>) for research, interviews, and contributing to this feature article.</p>\n\n\n\n<p>The <em>People of WordPress</em> series thanks Josepha Haden (<a href=\"https://profiles.wordpress.org/chanthaboune/\" class=\"mention\"><span class=\"mentions-prefix\">@</span>chanthaboune</a>) and Topher DeRosia (<a href=\"https://profiles.wordpress.org/topher1kenobe/\" class=\"mention\"><span class=\"mentions-prefix\">@</span>topher1kenobe</a>) for their support.</p>\n\n\n\n<div class=\"wp-block-media-text is-stacked-on-mobile is-vertically-aligned-center\"><img width=\"180\" height=\"135\" src=\"https://i0.wp.com/wordpress.org/news/files/2020/03/heropress_logo_180.png?resize=180%2C135&ssl=1\" alt=\"HeroPress logo\" class=\"wp-image-8409 size-full\" /><div class=\"wp-block-media-text__content\">\n<p class=\"has-small-font-size\"><em>This People of WordPress feature is inspired by an essay originally published on </em><a href=\"https://heropress.com/\"><em>HeroPress.com</em></a><em>, a community initiative created by Topher DeRosia. It highlights people in the WordPress community who have overcome barriers and whose stories might otherwise go unheard. </em>#HeroPress </p>\n</div></div>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Wed, 30 Nov 2022 20:09:00 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:11:\"Abha Thakor\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:3;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:132:\"Post Status: State of the Word 2022 • Meetup Accessibility Overlays • Multi-line Code Comments • WP 3.7 – 4.0 Final Releases\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:32:\"https://poststatus.com/?p=145276\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:127:\"https://poststatus.com/state-of-the-word-2022-meetup-accessibility-overlays-multi-line-code-comments-wp-3-7-4-0-final-releases/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:14252:\"<h2 id=\"h-this-week-at-wordpress-org-november-28-2022\">This Week at WordPress.org (November 28, 2022)</h2>\n\n\n<div class=\"has-background has-theme-palette-8-background-color wp-block-post-excerpt\"><p class=\"wp-block-post-excerpt__excerpt\">Should code comments switch to <code><strong>//</strong></code> ? Meetup.com stops using an accessibility overlay. Final releases for WordPress 3.7 &#8211; 4.0 are now available. Tune in soon for State of the Word 2023, happening December 15 via livestream from New York City.   </p></div>\n\n\n<div class=\"wp-block-spacer\"></div>\n\n\n\n<div id=\"kt-info-box_68609b-a8\" class=\"wp-block-kadence-infobox\"><div class=\"kt-blocks-info-box-link-wrap kt-blocks-info-box-media-align-left kt-info-halign-left\"><div class=\"kt-blocks-info-box-media-container\"><div class=\"kt-blocks-info-box-media kt-info-media-animate-none\"><div class=\"kadence-info-box-icon-container kt-info-icon-animate-none\"><div class=\"kadence-info-box-icon-inner-container\"><span class=\"kt-info-svg-icon kt-info-svg-icon-fas_microphone-alt\"></span></div></div></div></div><div class=\"kt-infobox-textcontent\"><h2 class=\"kt-blocks-info-box-title\">EOL WP 3.7 &#8211; 4.0, Multi-line Code Comments, Meetup Accessibility, SotW</h2><p class=\"kt-blocks-info-box-text\"><img src=\"https://s.w.org/images/core/emoji/14.0.0/72x72/1f399.png\" alt=\"🎙\" class=\"wp-smiley\" /> <a href=\"https://wordpress.org/news/2022/11/state-of-the-word-2022/\">State of the Word 2022</a><br /><br /><img src=\"https://s.w.org/images/core/emoji/14.0.0/72x72/267f.png\" alt=\"♿\" class=\"wp-smiley\" /> <a href=\"https://make.wordpress.org/community/2022/11/23/meetup-com-accessibility-overlay-update/\">Meetup.com Accessibility Overlay Update</a><br /><br /><img src=\"https://s.w.org/images/core/emoji/14.0.0/72x72/1faa6.png\" alt=\"🪦\" class=\"wp-smiley\" /> <a href=\"https://make.wordpress.org/core/2022/11/30/now-available-wordpress-3-7-4-0-final-releases/\">Now Available: WordPress 3.7-4.0 Final Releases</a><br /><br /><img src=\"https://s.w.org/images/core/emoji/14.0.0/72x72/1f4ac.png\" alt=\"💬\" class=\"wp-smiley\" /> <a href=\"https://make.wordpress.org/core/2022/11/24/proposal-amend-the-inline-documentation-standards-for-multi-line-comments/\">Proposal: Amend the Inline Documentation Standards for multi-line comments</a><br /><br /></p></div></div></div>\n\n\n\n<h2 id=\"h-news\">News<a href=\"https://wordpress.org/news/2022/10/wordpress-6-1-release-candidate-3/\"></a></h2>\n\n\n\n<ul>\n<li><a href=\"https://wordpress.org/news/2022/11/episode-44-minors-majors-and-why-we-have-so-many-releases/\">WP Briefing: Episode 44: Minors, Majors, and Why We Have So Many Releases</a></li>\n</ul>\n\n\n\n<div class=\"wp-block-kadence-spacer aligncenter kt-block-spacer-_121b9e-cb\"><div class=\"kt-block-spacer kt-block-spacer-halign-center\"><hr class=\"kt-divider\" /></div></div>\n\n\n\n<div class=\"is-layout-flex wp-container-3 wp-block-columns\">\n<div class=\"is-layout-flow wp-block-column\">\n<h2 id=\"h-accessibility\"><a href=\"https://make.wordpress.org/accessibility\">Accessibility</a></h2>\n\n\n\n<ul>\n<li><a href=\"https://make.wordpress.org/accessibility/2022/11/30/accessibility-team-meeting-agenda-december-2-2022/\">Accessibility Team Meeting Agenda: December 2, 2022</a></li>\n</ul>\n\n\n\n<h2 id=\"h-community\">Community</h2>\n\n\n\n<ul>\n<li><a href=\"https://make.wordpress.org/community/2022/11/30/community-team-meeting-agenda-1-dec-2022/\">Community Team Meeting Agenda 1 Dec 2022</a></li>\n\n\n\n<li><a href=\"https://make.wordpress.org/community/2022/11/30/vote-for-community-team-rep-2023/\">Vote for Community Team Rep 2023</a></li>\n\n\n\n<li><a href=\"https://make.wordpress.org/community/2022/11/28/plan-your-state-of-the-word-watch-party-today/\">Plan Your State of the Word Watch Party Today!</a></li>\n\n\n\n<li><a href=\"https://make.wordpress.org/community/2022/11/28/wordpress-community-team-training-5-active-listening/\">WordPress Community Team Training #5: Active Listening</a></li>\n\n\n\n<li><a href=\"https://make.wordpress.org/community/2022/11/24/recap-of-the-diverse-speaker-training-group-wpdiversity-amer-emea-on-november-23-2022/\">Recap of the Diverse Speaker Training group (#WPDiversity) AMER/EMEA on November 23, 2022</a></li>\n</ul>\n\n\n\n<h2 id=\"h-core\"><a href=\"https://make.wordpress.org/core\">Core</a> </h2>\n\n\n\n<ul>\n<li><a href=\"https://make.wordpress.org/core/2022/11/23/whats-new-in-gutenberg-14-6-23-november/\">What’s new in Gutenberg 14.6? (23 November)</a></li>\n\n\n\n<li><a href=\"https://make.wordpress.org/core/2022/11/29/a-week-in-core-november-28-2022/\">A Week in Core – November 28, 2022</a></li>\n\n\n\n<li><a href=\"https://make.wordpress.org/core/2022/11/30/devchat-agenda-november-30-2022/\">Devchat agenda, November 30, 2022</a></li>\n\n\n\n<li><a href=\"https://make.wordpress.org/core/2022/11/24/dev-chat-summary-wednesday-november-23-2022/\">Dev Chat summary: Wednesday, November 23, 2022</a></li>\n\n\n\n<li><a href=\"https://make.wordpress.org/core/2022/11/28/editor-chat-agenda-november-30-2022/\">Editor Chat Agenda: November 30, 2022</a></li>\n\n\n\n<li><a href=\"https://make.wordpress.org/core/2022/11/23/editor-chat-summary-november-23-2022/\">Editor chat summary: 23 November 2022</a></li>\n</ul>\n\n\n\n<h2 id=\"h-docs\"><a href=\"https://make.wordpress.org/docs\">Docs</a></h2>\n\n\n\n<ul>\n<li><a href=\"https://make.wordpress.org/docs/2022/11/30/summary-for-docs-team-meeting-november-29-2022/\">Summary for Docs Team Meeting November 29, 2022</a></li>\n\n\n\n<li><a href=\"https://make.wordpress.org/docs/2022/11/28/agenda-for-docs-team-bi-weekly-november-29-2022/\">Agenda for Docs Team Bi-Weekly November 29, 2022</a></li>\n\n\n\n<li><a href=\"https://make.wordpress.org/updates/2022/11/29/documentation-team-update-november-29-2022/\">Documentation Team Update – November 29, 2022</a></li>\n</ul>\n\n\n\n<h2 id=\"h-hosting\"><a href=\"https://make.wordpress.org/hosting\">Hosting</a></h2>\n\n\n\n<ul>\n<li><a href=\"https://make.wordpress.org/hosting/2022/11/23/server-environment-for-wordpress-6-1/\">Server Environment for WordPress 6.1</a></li>\n\n\n\n<li><a href=\"https://make.wordpress.org/hosting/2022/11/09/nominations-for-hosting-team-reps-2023/\">Nominations for Hosting Team Reps 2023</a></li>\n</ul>\n\n\n\n<h2 id=\"h-marketing\"><a href=\"https://make.wordpress.org/marketing\">Marketing</a></h2>\n\n\n\n<ul>\n<li><a href=\"https://make.wordpress.org/marketing/2022/11/29/agenda-global-wordpress-marketing-team-meeting-november-30-2022/\">Agenda: global WordPress marketing team meeting, November 30, 2022</a></li>\n\n\n\n<li><a href=\"https://make.wordpress.org/marketing/2022/11/29/notes-global-marketing-team-meeting-november-23-2022/\">Notes: Global Marketing Team meeting, November 23, 2022</a></li>\n</ul>\n\n\n\n<h2 id=\"h-mobile\"><a href=\"https://make.wordpress.org/mobile\">Mobile</a></h2>\n\n\n\n<ul>\n<li><a href=\"https://make.wordpress.org/mobile/2022/11/29/call-for-testing-wordpress-for-ios-21-3/\">Call for Testing: WordPress for iOS 21.3</a></li>\n\n\n\n<li><a href=\"https://make.wordpress.org/updates/2022/11/30/mobile-team-update-november-30th-2/\">Mobile Team Update – November 30th</a></li>\n</ul>\n</div>\n\n\n\n<div class=\"is-layout-flow wp-block-column\">\n<h2 id=\"h-performance\"><a href=\"https://make.wordpress.org/performance/\">Performance</a></h2>\n\n\n\n<ul>\n<li><a href=\"https://make.wordpress.org/core/2022/11/29/performance-team-meeting-summary-29-november-2022/\">Performance Chat Summary: 29 November 2022</a></li>\n\n\n\n<li><a href=\"https://make.wordpress.org/updates/2022/11/30/core-performance-team-update-november-30-2022/\">Core Performance Team Update – November 30, 2022</a></li>\n</ul>\n\n\n\n<h2 id=\"h-polyglots\">Polyglots</h2>\n\n\n\n<ul>\n<li><a href=\"https://make.wordpress.org/polyglots/2022/11/29/agenda-weekly-polyglots-chat-nov-30-2022-0700-utc/\">Agenda: Weekly Polyglots Chat – Nov. 30, 2022 (07:00 UTC)</a></li>\n\n\n\n<li><a href=\"https://make.wordpress.org/polyglots/2022/11/08/call-for-polyglots-team-representatives-2/\">Call for Polyglots Team Representatives</a></li>\n</ul>\n\n\n\n<h2 id=\"h-test\"><a href=\"https://make.wordpress.org/test\">Test</a></h2>\n\n\n\n<ul>\n<li><a href=\"https://make.wordpress.org/test/2022/11/13/fse-program-exploration-site-editor-sneak-peek/\">FSE Program Exploration: Site Editor Sneak Peek</a></li>\n\n\n\n<li><a href=\"https://make.wordpress.org/updates/2022/11/29/test-team-update-28-november-2022/\">Test Team Update: 28 November 2022</a></li>\n</ul>\n\n\n\n<h2 id=\"h-themes\"><a href=\"https://make.wordpress.org/themes\">Themes</a></h2>\n\n\n\n<ul>\n<li><a href=\"https://make.wordpress.org/themes/2022/11/16/nominations-call-for-the-themes-team-representatives-2023-edition/\">Nominations Call for the themes team representatives: 2023 Edition</a></li>\n\n\n\n<li><a href=\"https://make.wordpress.org/updates/2022/11/29/themes-team-update-november-29-2022/\">Themes team update November 29, 2022</a></li>\n</ul>\n\n\n\n<h2 id=\"h-training\"><a href=\"https://make.wordpress.org/training\">Training</a></h2>\n\n\n\n<ul>\n<li><a href=\"https://learn.wordpress.org/individual-learner-survey/\">How did you learn WordPress?</a></li>\n\n\n\n<li><a href=\"https://make.wordpress.org/training/2022/11/28/meeting-agenda-for-november-29-2022/\">Meeting Agenda for November 29, 2022</a></li>\n\n\n\n<li><a href=\"https://make.wordpress.org/training/2022/11/26/project-thread-training-team-onboarding-paths/\">Project Thread: Training Team Onboarding Paths</a></li>\n</ul>\n\n\n\n<h3 id=\"h-online-workshops\">Online Workshops</h3>\n\n\n\n<ul>\n<li><a href=\"https://learn.wordpress.org/?meeting=https-www-meetup-com-learn-wordpress-online-workshops-events-290051844\">State of the Word Watch Party (Live Online)</a></li>\n\n\n\n<li><a href=\"https://learn.wordpress.org/?meeting=how-to-join-core-release-party\">How to Join Core Release Party</a></li>\n\n\n\n<li><a href=\"https://learn.wordpress.org/?meeting=lets-code-developing-blocks-without-react-part-3\">Let’s code: Developing Blocks without React! – Part 3</a></li>\n\n\n\n<li><a href=\"https://learn.wordpress.org/?meeting=wordpress-development-live-stream-developing-blocks-without-react-part-3\">WordPress development live stream: Developing Blocks without React – Part 3</a></li>\n\n\n\n<li><a href=\"https://learn.wordpress.org/?meeting=what-is-seo-search-engine-optimization\">What is SEO? (Search Engine Optimization)</a></li>\n\n\n\n<li><a href=\"https://learn.wordpress.org/?meeting=creating-a-call-to-action-with-the-block-editor-apac-time-zone\">Creating a Call To Action with the Block Editor (APAC Time Zone)</a></li>\n\n\n\n<li><a href=\"https://learn.wordpress.org/?meeting=creating-a-call-to-action-with-the-block-editor\">Creating a Call To Action with the Block Editor</a></li>\n\n\n\n<li><a href=\"https://learn.wordpress.org/?meeting=image-seo-best-practices-to-make-your-content-discoverable-2\">Image SEO Best Practices to Make Your Content Discoverable</a></li>\n\n\n\n<li><a href=\"https://learn.wordpress.org/?meeting=navigation-block\">Navigation Block</a></li>\n</ul>\n\n\n\n<h2 id=\"h-wptv\">WPTV</h2>\n\n\n\n<ul>\n<li><a href=\"https://wordpress.tv/category/year/2022/\">Latest WordPress TV videos</a></li>\n</ul>\n</div>\n</div>\n\n\n\n<hr class=\"wp-block-separator has-alpha-channel-opacity\" />\n\n\n\n<h2 id=\"h-related-news\">Related News:</h2>\n\n\n\n<ul>\n<li><a href=\"https://www.php.net/archive/2022.php#2022-11-26-1\">PHP 8.0.26 Released!</a></li>\n\n\n\n<li><a href=\"https://www.php.net/archive/2022.php#2022-11-24-2\">PHP 8.2.0 RC7 available for testing</a></li>\n\n\n\n<li><a href=\"https://www.php.net/archive/2022.php#2022-11-24-1\">PHP 8.1.13 Released!</a></li>\n\n\n\n<li><a href=\"https://nodejs.org/en/blog/release/v19.2.0/\">Node v19.2.0 (Current)</a></li>\n\n\n\n<li><a href=\"https://tc39.es/#proposals\">ECMAScript Proposals</a></li>\n</ul>\n\n\n\n<p class=\"has-theme-palette-7-background-color has-background\">Thanks for reading our WP dot .org roundup! Each week we are highlighting the news and discussions coming from the good folks making WordPress possible. If you or your company create products or services that use WordPress, you need to be engaged with them and their work. Be sure to share this resource with your product and project managers. <br /><br /><strong>Are you interested in giving back and contributing your time and skills to WordPress.org?</strong> <img src=\"https://s.w.org/images/core/emoji/14.0.0/72x72/1f64f.png\" alt=\"🙏\" class=\"wp-smiley\" /> <a href=\"https://wordpress.org/support/article/contributing-to-wordpress/\">Start Here ›</a><br /><br /><strong>Get our weekly WordPress community news digest</strong> — Post Status\' <a href=\"https://poststatus.com/news/week-in-review/\">Week in Review</a> — covering the WP/Woo news plus significant writing and podcasts. It\'s also available in <a href=\"https://poststatus.com/newsletter\">our newsletter</a>. <img src=\"https://s.w.org/images/core/emoji/14.0.0/72x72/1f48c.png\" alt=\"💌\" class=\"wp-smiley\" /></p>\n\n\n\n<div class=\"wp-block-spacer\"></div>\n\n\n\n<div class=\"wp-block-media-text alignwide is-stacked-on-mobile has-background\"><a href=\"https://poststatus.com/\"><img src=\"https://cdn.poststatus.com/wp-content/uploads/2021/09/vertical-post-status-logo-250.png\" alt=\"Post Status\" class=\"wp-image-85823 size-full\" /></a><div class=\"wp-block-media-text__content\">\n<p class=\"has-text-align-left has-normal-font-size\" id=\"h-get-ready-for-remote-work\">You — and <a href=\"https://poststatus.com/#Agency\">your whole team</a> can <a href=\"https://poststatus.com/#choose-membership\">Join Post Status</a> too!</p>\n\n\n\n<p class=\"has-text-align-left has-small-font-size\"><strong>Build your network. Learn with others. Find your next job — or your next hire.</strong> Read the <strong>Post Status</strong> <a href=\"https://poststatus.com/newsletter/\">newsletter</a>. <img src=\"https://s.w.org/images/core/emoji/14.0.0/72x72/2709.png\" alt=\"✉\" class=\"wp-smiley\" /> Listen to <a href=\"https://poststatus.com/podcasts/\">podcasts</a>. <img src=\"https://s.w.org/images/core/emoji/14.0.0/72x72/1f399.png\" alt=\"🎙\" class=\"wp-smiley\" /> Follow <a href=\"https://twitter.com/post_status/\">@Post_Status</a> <img src=\"https://s.w.org/images/core/emoji/14.0.0/72x72/1f426.png\" alt=\"🐦\" class=\"wp-smiley\" /> and <a href=\"https://www.linkedin.com/company/post-status-llc/\">LinkedIn</a>. <img src=\"https://s.w.org/images/core/emoji/14.0.0/72x72/1f4bc.png\" alt=\"💼\" class=\"wp-smiley\" /></p>\n</div></div>\n\n\n\n<div class=\"wp-block-spacer\"></div>\n<p>This article was published at Post Status — the community for WordPress professionals.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Wed, 30 Nov 2022 19:15:38 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:18:\"Courtney Robertson\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:4;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:71:\"WPTavern: #53 – Matt Medeiros on the State of the WordPress Landscape\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:48:\"https://wptavern.com/?post_type=podcast&p=139905\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:85:\"https://wptavern.com/podcast/53-matt-medeiros-on-the-state-of-the-wordpress-landscape\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:55637:\"Transcript<div>\n<p>[00:00:00] <strong>Nathan Wrigley:</strong> Welcome to the Jukebox podcast from WP Tavern. My name is Nathan Wrigley. Jukebox is a podcast which is dedicated to all things WordPress. The people, the events, the plugins, the blocks, the themes, and in this case, the thoughts on the past present and future of WordPress.</p>\n\n\n\n<p>If you&#8217;d like to subscribe to the podcast, you can do that by searching for WP Tavern in your podcast, player of choice, or by going to wptavern.com forward slash feed forward slash podcast. And you can copy that URL into most podcast players. If you have a topic that you&#8217;d like us to feature on the podcast, I&#8217;m keen to hear from you, and hopefully get you, or your idea featured on the show. Head to wptavern.com forward slash contact forward slash jukebox, and use the form there.</p>\n\n\n\n<p>So on the podcast today, we have Matt Medeiros. Matt is the driving force behind many WordPress initiatives. That could be the creation of plugins, WordPress news, media, as well as podcasts about all manner of WordPress specific subjects. He likes to juggle multiple projects at once.</p>\n\n\n\n<p>Currently he&#8217;s the director of podcaster to success at Castos, which is a podcast hosting company with a WordPress plugin. He&#8217;s on the podcast today to give us his take on the past, present and future of WordPress.</p>\n\n\n\n<p>Many millions of people like to work with the WordPress software, they create websites, plugins, and themes, and extend what the CMS can do. Others, such as Matt like to ponder the broader purpose and direction of the software and the community around it. The Matt Report and The WP Minute have enabled us to hear about what the community is doing, what it wants and where its points of friction are. He&#8217;s talked to hundreds of people about what WordPress was, is, and might be. And so he&#8217;s in a unique position to pontificate about what WordPress, beyond the software, is.</p>\n\n\n\n<p>We start with mats backstory. How he found WordPress and why he started to use it. We talk about how he&#8217;s dipped in and out of the community over the years. More excited at times, less so at others.</p>\n\n\n\n<p>The conversation moves on to some of the trends that Matt has noticed. He identifies how the software and the wider community have altered over time. We talk about how The WP Minute got started, and how he&#8217;s building up a community of like-minded people to consume as well as to create the content that they&#8217;re putting out.</p>\n\n\n\n<p>Towards the end, we get into the governance of WordPress and the future of the project more generally. There are certainly things that Matt likes, but there are some wrinkles which get aired as well.</p>\n\n\n\n<p>We finish up by talking about podcasts and Matt&#8217;s work with Castos and how they are trying to make it easier to get your voice out there, especially with their WordPress integration.</p>\n\n\n\n<p>It&#8217;s a lovely chat with a thoughtful and far sighted member of the community.</p>\n\n\n\n<p>If you&#8217;re interested in finding out more. You can find all of the links in the show notes by heading over to WP tavern.com forward slash podcast. Where you&#8217;ll find all the other episodes as well.</p>\n\n\n\n<p>And so without further delay, I bring you Matt Medeiros.</p>\n\n\n\n<p>I am joined on the podcast today by Matt Medeiros. Hello, Matt.</p>\n\n\n\n<p>[00:04:10] <strong>Matt Medeiros:</strong> Nathan, thanks for having me.</p>\n\n\n\n<p>[00:04:12] <strong>Nathan Wrigley:</strong> You are so welcome. If you&#8217;ve been in the WordPress space for, I&#8217;m going to say a decade or more, it&#8217;s very likely that you&#8217;ve heard about Matt Medeiros, but just in case you haven&#8217;t, I&#8217;m going to let Matt do a little bit of an intro to give us his backstory about WordPress, the WordPress space, the projects he&#8217;s been involved in. So, Matt, off you go.</p>\n\n\n\n<p>[00:04:33] <strong>Matt Medeiros:</strong> Well, my newsletter list says otherwise. So, there&#8217;s still plenty of people who need to know me. So Matt Medeiros. I&#8217;ve been doing WordPress stuff, 10, 15 years. I don&#8217;t know how long it&#8217;s been. Started a podcast called Matt Report back when I started a digital agency. That&#8217;s how I built the digital agency. Ran Matt Report for many, many, many, many years still out there, and now have pivoted this focus on thewpminute.com, which is five minutes of WordPress news every week.</p>\n\n\n\n<p>So I&#8217;ve been in the WordPress space, agency stuff, plugin stuff, theme stuff, podcasting stuff, YouTube stuff. And now I am the director of podcaster success at castos.com, which is a podcast hosting company, which also has a WordPress plugin. And also the parent company of wordpress.com, Automattic, has invested in Castos a little over a year ago at this point. So it&#8217;s podcasting and WordPress.</p>\n\n\n\n<p>[00:05:24] <strong>Nathan Wrigley:</strong> We&#8217;ll definitely get into that. I confess I had forgotten that fact. Cast your mind back. Let&#8217;s say it&#8217;s 12 years ago, something like that. What was the thing that made it WordPress as opposed to something else all those years ago? Could have been Drupal, could have been Joomla, could have been Expression Engine. Why WordPress?</p>\n\n\n\n<p>[00:05:40] <strong>Matt Medeiros:</strong> In fact, it was Drupal, to begin with. That was my first foray into really taking an open source CMS seriously, besides PHP-Nuke, which I had played with, before Drupal. But Drupal came into my professional career as I was head of web services for an ISP, internet service provider.</p>\n\n\n\n<p>We used to do things like dial up, ISDN, if you can remember those. T1 lines. And we purchased another ISP that had a web development arm and it was a Drupal shop. And this is around Drupal four and five, around those versions. And the head of design or the head designer at the time, he was like, hey Matt, because we were taking over and other people were leaving and I was going to steer the ship.</p>\n\n\n\n<p>He&#8217;s like, I want to get away from Drupal. It is so hard to design on top of. Now you got to remember this is, I don&#8217;t know, 15 years ago, something like that. And he said, there&#8217;s this thing called WordPress. I can really design on top of that. I can do really well with it. I want to try it out. And that was the first theme we bought was the theme called Standard, which was a collaboration way back in the day between John Saddington, Tom McFarlin, and Eric Dye, I believe was his last name.</p>\n\n\n\n<p>That was the first theme I ever purchased, in a professional setting. We use that to build themes and do that with our customers. And, and that was the entrance into WordPress. And once I broke off from that company, I just took all that knowledge and started my digital agency with that. And it was domino effect, ever since in the WordPress space.</p>\n\n\n\n<p>[00:07:08] <strong>Nathan Wrigley:</strong> You&#8217;ve really had a, like a broad, rich, encounter with WordPress though, because for me at least, anyway, it was WordPress websites and then more recently got into podcasting and those are basically the two things that I&#8217;ve done. But, as we&#8217;ll probably find out during the course of the show, you&#8217;ve really dotted around.</p>\n\n\n\n<p>One of the things that I want to raise right at the beginning, and I don&#8217;t know what your thoughts on this are. It&#8217;s a bit of an abstract thought. If we were to rewind the clock, say 20 years ago. Both of us have obviously decided at some point, I think the internet is quite an interesting and fun thing. But I genuinely had no idea, it could have been a flash in the pan. Maybe it would&#8217;ve represented a tiny sliver of what people were doing. Shops, brick and mortar shops would still be thriving. Websites would&#8217;ve been really tangential, hardly anybody might have visited them.</p>\n\n\n\n<p>There was no conception that the phone would become a conduit. That you would carry something around in your back pocket. That computers would be basically portable. None of that was a thought, and yet both of us staked more or less everything on it, which with a bit of hindsight was probably the best decision we ever made.</p>\n\n\n\n<p>Now, you can talk to computers that sit in a tiny box in your kitchen and it will give you coherent answers to everything. Do you feel like you&#8217;re a very privileged person to have stepped into the broader internet and all that that offers?</p>\n\n\n\n<p>[00:08:28] <strong>Matt Medeiros:</strong> My genesis around getting into this space, if you want to go even deeper into the rabbit hole of who Matt Medeiros is, is my family ran a string of car dealerships for about 45 years in my local, my local area. We weren&#8217;t like this big massive conglomerate auto dealership. We just had two, family owned and operated.</p>\n\n\n\n<p>It was the technology that was moving, fast paced in that world. Consumer internet being born, websites, you know, this all sounds pretty trivial, but back then it was like, oh wow, we can post a car on the internet and somebody can look at it and email us, or most likely call us back then and buy it? Speaking of the privilege that, like being in that space, having a family that ran this dealership, but because I was the youngest one and I was into it. I was the one that put all the technology together, from General Motors, right?</p>\n\n\n\n<p>They were literally talking to an 17, 18 year old at the time, as the head of the internet department. Because I was the only one who got it, who understood it. My dad did, but you know, I sort of led the charge on that. And, I remember being in college and, you know, when you look at WordPress and open source, one of my, uh, capstone courses was to build something with, I forget what the terms were, but they said build it with multiple packages. And back then I was learning like Linux and Novell and, and Windows NT.</p>\n\n\n\n<p>And I remember building PHP-Nuke with a bulletin board with, a blog roll. And I was building a car site, and I was like, wouldn&#8217;t it be awesome if somebody could go to this website and book an oil change for their car by filling out this form. And then if you had questions about repairing your car, you could come to this thing called a bulletin board, and have like this little community.</p>\n\n\n\n<p>What I was doing back then was doing everything that social, that we all take for granted these days with the advancement of technology. And I was like wiring it together with little open source packages. So yeah, roundabout way of getting to, yeah, I feel pretty lucky to fall into that space at an early age.</p>\n\n\n\n<p>[00:10:30] <strong>Nathan Wrigley:</strong> I feel that you and I hit a time when you could flip from just having any kind of job into working on the internet, because the barrier to entry in terms of knowledge was so low. You basically had to learn HTML and then along came CSS, it was straightforward.</p>\n\n\n\n<p>I think the promise now is much more difficult. I can&#8217;t really imagine what it must be like for somebody at the age of 17 or 18. The things that they must need to learn in order to become employable. Speaking of the internet, you mentioned social media and what have you. I wonder what your thoughts are on that.</p>\n\n\n\n<p>I know that we&#8217;re straying away a little bit from WordPress, but it does touch on GPL and it does touch on the broader purpose of the internet. What are your feelings about how the internet has evolved over the last, let&#8217;s say seven, eight years? Things like Facebook, social media, and the associated benefits and harms that go with it.</p>\n\n\n\n<p>[00:11:25] <strong>Matt Medeiros:</strong> I don&#8217;t think humans were ready to be wired up emotionally, to the level that we&#8217;re at these days. Spanning across many, many contexts, right? From your everyday life of sharing pictures of what you&#8217;re eating, what your kids are doing, to more serious things like health, wellness, mental health.</p>\n\n\n\n<p>Couple weeks ago suddenly lost my father-in-law and like the grieving factor of online. And you really start to sit back and say like, what, what is this? Like why? Is this value, all of us connected like this? Are we really together in this? Or is it just this digital connection that sort of literally just disappears as the feed refreshes?</p>\n\n\n\n<p>And it really starts to have you question all of these things. Now there&#8217;s definitely many, many benefits. I mean, friends, that I&#8217;ve made through social, the businesses that I&#8217;ve built, and continue to build. There&#8217;s definitely a plus factor, but there&#8217;s a huge negative and, and things that I don&#8217;t think human beings are really ready for.</p>\n\n\n\n<p>And I look at it in two different ways. One, I have three very young sons, three boys, under the ages of six. And I&#8217;m just like mentally preparing on how to onboard them to the internet, how I will do that. But I also see things from the broader perspective, is you and I are content creators. We&#8217;re just playing in the WordPress world mostly and softwares and stuff like that.</p>\n\n\n\n<p>But I see people who are whatever, they&#8217;re into fashion, they&#8217;re into tech, they&#8217;re into video games, and there&#8217;s a burnout factor. There&#8217;s a, I must continue to create all of this content to please these people who really don&#8217;t care about me, factor. And then there&#8217;s those who really become hits, they do really well. And they&#8217;re not ready for that fame and that spotlight, because they&#8217;re one person with a million YouTube subscribers in their home office.</p>\n\n\n\n<p>And they&#8217;re not ready for what that&#8217;s like, to have all of these humans watching them and asking them for things. And it&#8217;s just, it&#8217;s not a mindset that I think we&#8217;re all really ready for, without some education. But we&#8217;re so early that, 50 years from now, it&#8217;s, it&#8217;s probably not going to be a thing, because we&#8217;re, we&#8217;re still cresting the analog to the digital. Like you said, the young folks, how are they going to get jobs?</p>\n\n\n\n<p>I think the, the issue is, is they lose the fundamentals of building technology. When I was learning how to build a website, I was learning how to build a computer. So I knew that there was a CPU and memory and a hard disc, and these things were storing this content and yada, all that fun stuff. Now, with the introduction of whatever, let&#8217;s say, easy web website builders and you just talk to AI and it codes a website for you. There are going to be this swath of people who just don&#8217;t know where all of this stuff lives and how it&#8217;s all connected. So, that was a deep rabbit hole that I just went down, and I hope we tumbled around it.</p>\n\n\n\n<p>[00:14:14] <strong>Nathan Wrigley:</strong> Yeah, really interesting. You mentioned your three children and I think that&#8217;s really fascinating for me. I have children as well, and one of the things that I struggle with. On the one hand, I&#8217;m really a proponent of technology. I love it. There&#8217;s almost nothing about it that I don&#8217;t love.</p>\n\n\n\n<p>And yet at the same time, I&#8217;ve noticed that my children have been born into an era in which technology could be literally welded to your hand and, you know, there&#8217;s no escape from it. And so the notifications can come in at all times of day, and night. Stress there on night, so it disrupts things. Like it disrupts the normal cycle of interpersonal relations in a room because, there&#8217;s a bing bong on a phone and suddenly you&#8217;re distracted.</p>\n\n\n\n<p>And the reason for being in the room with other people is somewhat shattered. And then, you hear about people who leave their phones by their bedsides and the phone goes off in the middle of the night and it disrupts their sleep, and all of these impacts. And whilst I am boldly a proponent of the internet, there are aspects of it which trouble me. And I think your wise point there, right at the end was that we&#8217;re young to this. We&#8217;re 20 years in, maybe a little bit more, but let&#8217;s say roughly 20 years in. And so we don&#8217;t really know where this is going.</p>\n\n\n\n<p>It&#8217;s kind of like steering a ship. I&#8217;m imagining somebody in 1492, Christopher Columbus or somebody on a ship, you know, they&#8217;ve set sail. They know they&#8217;ve got a destination, but they don&#8217;t know how long it&#8217;s going to be or when they&#8217;re going to get there. This feels to me like the internet. And I do wonder if some of these things that we may regard as bad habits at the moment will get washed away and replaced, hopefully with more beneficial things. I&#8217;m optimistic about that.</p>\n\n\n\n<p>[00:15:52] <strong>Matt Medeiros:</strong> Yeah, I agree.</p>\n\n\n\n<p>[00:15:53] <strong>Nathan Wrigley:</strong> Let&#8217;s just turn to the WordPress space, generally speaking. So you&#8217;ve been in it for a long time. Certainly much longer than I have. And you&#8217;ve been somebody that&#8217;s been observing the WordPress space. Not just using the software, but considering it, considering the impact of it, considering the business that can be made around it, and looking at the plugins and the themes and all of that, and having a critical eye on it.</p>\n\n\n\n<p>This is a very broad question, but I&#8217;m going to ask it anyway. What have you noticed as the main changes over time? Young people to the community, you&#8217;ve been in the community using WordPress for a couple of years. They won&#8217;t know that there&#8217;s been any changes. The software&#8217;s just the software, but there&#8217;s been a lot. What do you think the main things have been for you?</p>\n\n\n\n<p>[00:16:29] <strong>Matt Medeiros:</strong> Yeah, I&#8217;m, I&#8217;m going to try to summarize this as quickly as possible that we can break off into different paths that I think are, are relevant. But there was certainly a long span of the same folks doing the same WordCamp talks, I&#8217;m not saying this in a bad way, but there was, I don&#8217;t know, a 10 year cohort of WordPress that I felt, we were all jiving and doing the same thing, showing up to the WordCamps, and everyone knew each other.</p>\n\n\n\n<p>The real pivotal milestone, for better or worse, was the introduction of Gutenberg, and the software and how it was introduced and all that stuff. Those pages in the history books have already been written. I think it was at that point where a certain segment of the community was one, they were like, I don&#8217;t want this in WordPress, so I&#8217;m done. There was another segment where, we don&#8217;t know how to code around this, and I don&#8217;t want this coding overhead. And then there was a third, in my view, where a lot of people used it.</p>\n\n\n\n<p>Excuse might be the wrong word, but it was certainly a time where, man, you&#8217;re 10 or whatever it was, 10 or 12 years into software. That&#8217;s a lifetime of using the same shiny tool. And there&#8217;s just this natural thing, I think, of all of us who are like technologists or like 10, 12 years in, ah, I just got to try something else. And that was a moment, two thirds of these people are leaving because of these reasons. I guess I&#8217;ll leave too, and go find another shiny object.</p>\n\n\n\n<p>And that&#8217;s where I guess the no code market really stepped in. Not saying because of WordPress, but it was certainly a right time, right place, kind of thing where those tools were getting shinier and better, and it was a great moment for them to somebody else to be like, ah, Webflow, ah, Wix, Squarespace, Shopify, Coda, Notion, all these things that we&#8217;re just like piecing together like we did with WordPress 10 years ago. Now we can do this again here with these shiny, faster free tools.</p>\n\n\n\n<p>So that&#8217;s the way that I see it. That change in the community over the milestone of Gutenberg, and up until now there&#8217;s a lot of fresh faces in here, which is great. But there&#8217;s less of this, I don&#8217;t know, warm blanket around all of us these days, that used to be there, for a good 10 year cohort.</p>\n\n\n\n<p>One of the reasons why I started The Matt Report at the time was, one, it&#8217;s because I wasn&#8217;t a developer and I didn&#8217;t know anyone. I didn&#8217;t know how to talk to developers, so I said, well, I&#8217;ll just interview them and, and promote them so that they can get jobs and maybe I&#8217;ll learn more people.</p>\n\n\n\n<p>But two, when I was at one of my first WordCamps, perfect example, there was, you know, one of the core contributors of WordPress and he would walk by and people like, Oh, I really want to talk to him. I&#8217;m afraid to talk to him. So there was like this celebrity status kind of thing.</p>\n\n\n\n<p>And that&#8217;s when it hit me like, oh, people really care about these other people in the community. Let me go and find them and interview them, and prop them up so other people can meet them instead of being, you know, shy or worried to talk about them at a WordCamp. So I think the biggest change, for me anyway, has been the community in the involvement of everyone.</p>\n\n\n\n<p>[00:19:24] <strong>Nathan Wrigley:</strong> Did I get a sense, I could be wrong. Forgive me if I got this sense and my spidey sense was tingling in the wrong direction. But, I kind of got a feeling about three or four years ago that you, you kinda fell out of love a little bit with WordPress and were seeking paths new. But then you&#8217;ve drifted back in, drift is the wrong word, you&#8217;ve come back in with great aplomb, you know, you&#8217;re back in making all the content and what have you. Is that true? Did you find yourself in that miasma, thinking I don&#8217;t really know whether I belong anymore?</p>\n\n\n\n<p>[00:19:55] <strong>Matt Medeiros:</strong> Picture us in the, in my therapist office, and you&#8217;re sitting across from me with your pen and notepad. There&#8217;s a lot of things that go into that feeling. You&#8217;re not totally wrong. But, as you know as a content creator, you continue to create all the content. And quite literally, I burned out on the YouTube stuff because it was just a hard slog on the Plugin Tut channel. But then it was, how do I really grow this? How do I grow this podcast and, bring in other, other voices? Because the same thing I just mentioned about this 10 year cohort, all the same people.</p>\n\n\n\n<p>I could feel those effects on the content that I was doing. That&#8217;s when I started to introduce the no code, maybe the more business aspect, SaaS developers, stuff like that, and bringing that into the fold. It certainly, my love for WordPress, it actually goes much deeper than the software. I think that WordPress itself is, speaking of like jobs and education. This is a tool that can empower individuals, local organizations, states, towns, to put people into a workforce.</p>\n\n\n\n<p>And WordPress is, I think, a great learning tool. A great building tool to do all that stuff, aside from the fun web stuff that we can do with it. So you&#8217;re not too far off, but there was sort of a reshaping of how do I introduce new voices? Because I could feel probably just like you, the social media, the engagement of everyone sort of just getting burned out from the same old thing in WordPress, and that was probably me shifting the way I do content at the time.</p>\n\n\n\n<p>[00:21:32] <strong>Nathan Wrigley:</strong> So shifting more recently, your content creation, it&#8217;s not entirely this, but you&#8217;ve moved to a new moniker. You&#8217;ve got The WP Minute. Just give us a bit of an insight into what the intention was there and how it&#8217;s going.</p>\n\n\n\n<p>[00:21:46] <strong>Matt Medeiros:</strong> We can thank our mutual friend Davinder Singh Kainth for getting me into this, uh, yet another content rabbit hole. But I also thank him very much for pushing me in this direction. I had an idea that I pitched to him one day and I was like, hey, probably just like your spidey sense went off. I&#8217;ve gotten really busy with the Castos day job, three young boys. It&#8217;s like, how the heck can I even do long form content anymore?</p>\n\n\n\n<p>So I wanted to do short form content and I approached Davinder and I said, hey, what I&#8217;d really like to do is a spoken version of your, of your newsletter. Fast forward, to make a long story short, he just said, how about you just start your own and I&#8217;ll just support you and I said, I don&#8217;t really want to do my own, I just want to, just want to piggyback off of somebody else. And that&#8217;s how we, we got into The WP Minute. So it&#8217;s your favorite five minutes of WordPress news, every Wednesday. But it&#8217;s really grown, to, uh, a small but mighty community. Just introduced Erik Karkovack, who is a top WP Tavern commenter, as the head editor or the editor of The WP Minute.</p>\n\n\n\n<p>So he&#8217;s working for me, air quotes, full time as the editor of putting together all the news, curating the news. And then I read the news, every Wednesday, and it&#8217;s just a short five minutes, so you&#8217;re busy, you&#8217;re a busy WordPress professional, you don&#8217;t have the time. We get all the top headlines for you and summarize it for you. And we have a fun community. So if you&#8217;re into the news, I, I certainly recommend The WP Minute.</p>\n\n\n\n<p>[00:23:10] <strong>Nathan Wrigley:</strong> How do you decide what stays in and what&#8217;s goes out? I face this problem. I have to decide which podcast episode I&#8217;m going to make, but it&#8217;s much more straightforward because the stuff that I&#8217;m producing content on, probably won&#8217;t matter whether it&#8217;s next week or the week after, it&#8217;s less critical. But for you, you&#8217;ve really got one shot and you&#8217;ve got to presumably try and get all the good bits in in five minutes. That&#8217;s hard, because in the WordPress community, as you know, I can talk about it for at least an hour and a half every week. How do you decide what stays in and what gets cut onto the floor?</p>\n\n\n\n<p>[00:23:41] <strong>Matt Medeiros:</strong> Yeah, so I look at the WP Minute as probably the best thing that I&#8217;m ever going to create for WordPress, right? So Matt Report, all the plugins, themes, services, consultations I&#8217;ve done, I feel like the WP Minute is the best thing that I&#8217;m going to contribute to this community. As far as I can see, and I look at it as community driven journalism without, self-promotion on this point.</p>\n\n\n\n<p>The idea is if you really want to have a hand in the news, you could join the membership and be part of this, and you join the membership to support it, because it costs money. And I try to be as transparent as possible of, there&#8217;s hosting, there&#8217;s podcast hosting, there&#8217;s paying Eric, there&#8217;s paying Raquel, there&#8217;s paying Pat to run this team.</p>\n\n\n\n<p>And the idea is if you want to get the stories out, you join us for short money to support the whole cause. And what I call the members, they call them producers. So you, the community member, can help produce the show. And as you know, Nathan, you get people knocking on your door to promote their product, promote their thing, and it&#8217;s like, hey, great, put your money where your mouth is and if you want your news to be heard, submit it to, what we call the link squad at The WP Minute. It&#8217;s a member curation. So you have the editorial team, myself, Eric, Pat, Raquel, and then you have the members who contribute the news. We all watch the news.</p>\n\n\n\n<p>You know, I got some Slack bots wired up. We get all the hot topics pumped right into the Slack channel so we can all collaborate on it. But then everyone sort of gets to have a vote. So people who put in their links, if their link makes it to the news, then they all get a credit thank you, both in the newsletter and the podcast. Now the idea is it&#8217;s supposed to be a five minute show. So if there&#8217;s a ton of news and somebody has voted for their top 10 slider plugins for October, chances are that one&#8217;s not going to make it. But we&#8217;ve had some times where we&#8217;ll cut a story from make.wordpress.org.</p>\n\n\n\n<p>Hey, we&#8217;ve got WordPress 6.1 release candidate one is ready. Please test it. Those are things that we always include to raise awareness, but if there&#8217;s acquisition news, community news, Tumblr News, like things that are really big and impactful, those things might drop because those things happen a lot more. So that&#8217;s not the most educated answer of how we select the news, but it is a community effort, and then within the confines of, hey look, this is also short form, so we try to keep it to five to seven minutes every week. People have said to me, why isn&#8217;t it called The WP Minutes?</p>\n\n\n\n<p>[00:26:07] <strong>Nathan Wrigley:</strong> You&#8217;ve been doing this like you said, for such a long time, and so you&#8217;ve been inspecting the community and what have you. You&#8217;ve got this media channel now, WP Minute, I know you&#8217;re doing a bunch of other stuff, and we&#8217;ll get onto that.</p>\n\n\n\n<p>Have you noticed over the last 10, 12, 8, whatever number of years. Have you noticed that the audience has changed? The desire of the content for the audience has changed? Because, when I started listening to WordPress content, really the only stuff I could find was how tos. It was, here I am, I know stuff about code. I&#8217;m going to tell you about code. Whereas now, if you look around, I feel that you can get news on almost everything.</p>\n\n\n\n<p>You know, you&#8217;ve got news about accessibility. You&#8217;ve got news about governance. You&#8217;ve got news about the plugins. You&#8217;ve got news about the themes, full site editing. The list could go on and on. And it seems almost like we&#8217;ve really properly got a little ecosystem where you don&#8217;t need to code, you could just be a community member talking about the community. So any thoughts on that?</p>\n\n\n\n<p>[00:27:05] <strong>Matt Medeiros:</strong> Yeah, I have a lot of thoughts on that. I talk about this topic a lot, I really just put all my cards out on the table and I could be totally wrong and it wouldn&#8217;t, certainly wouldn&#8217;t be the first time. But I think that the audience size, and again, this goes back to your spidey sense from before. I think that the audience size for the type of content that you and I put out is maximum, if you had the whole globe of human beings in front of you, the whole earth is probably about 8,000 people, out of whatever, 8, 9 billion people.</p>\n\n\n\n<p>I think that&#8217;s our cap for WordPress news, the inside baseball or how, how the community is put together, the ins and outs of the project, right. I think that the cap is 8,000 people. Now, the cap for how to put together a WooCommerce store, vastly different, right? those are the ones that, I mean, that&#8217;s hundreds of thousands, if not, uh, I don&#8217;t know, millions of people, who would want that kind of content? So I think yes, it has changed. I think the one constant is content that is still developer centric, is still the king of WordPress content, because there&#8217;s just far more WordPress developers who care about how to put sites together, than it is about the business side of WordPress and, maybe the community side, right?</p>\n\n\n\n<p>So I think that it has certainly shifted, although maybe even has gotten even tighter into the development space with the introduction of Gutenberg, full sight editing and just the general changes of WordPress.</p>\n\n\n\n<p>So, I know that if you told me 10 years ago, could you have made a business out of, whatever I, Matt Report and The WP Minute, I probably would&#8217;ve said no, I&#8217;m just trying to like grow brand awareness, which I was. I think I&#8217;ve successfully turned it, air quote, successfully turned it, into a media business, but it&#8217;s still very, very small. Very appreciative to like the sponsors over the years, and I have done really well compared to the larger podcasting industry, But, the audience I think for the stuff that, at least that I do, not trying to put you in the same bucket as me, is pretty small. It&#8217;s just people going in and out, all the time.</p>\n\n\n\n<p>[00:29:12] <strong>Nathan Wrigley:</strong> Given that we&#8217;ve both hitched our cart to the WordPress space, what are your thoughts about the future? Because I personally feel at least anyway, that the future is quite bright. I&#8217;m fairly optimistic about the progress around full sight editing and the block editor. I can well understand why people have become dissuaded with the desire to use WordPress into the future, I can understand that. But I feel that there&#8217;s light at the end of that tunnel, albeit, I don&#8217;t know how many days, weeks, months, or years it&#8217;s going to be before the train finally emerges out of the tunnel. But for me, it&#8217;s important because I do podcasting. I do content in the WordPress space. I would like to think that WordPress has a bright and glowing future. Maybe you share that optimism or maybe not.</p>\n\n\n\n<p>[00:30:02] <strong>Matt Medeiros:</strong> Yeah, I feel like I&#8217;m a realist in the fact that Automattic will take over wordpress.org, and it&#8217;ll just be more of a prominent upsell to either Jetpack or wordpress.com. And there is nothing wrong with that in my eyes, okay. So let&#8217;s just set that aside for a moment. I&#8217;ve recently, so hold that thought.</p>\n\n\n\n<p>I&#8217;ve recently been using Ghost, another open source CMS and, I&#8217;m using their paid version because like the folks who would make that decision to not have to maintain WordPress, get a hosting account, do plugins and themes. I said, hey, for this little side, side, side project that I&#8217;m working on, I&#8217;m just going to pay ghosts 30 bucks a month.</p>\n\n\n\n<p>And I want to be carefree like everyone else who picks these no code tools. This is what they&#8217;re all saying. This is why they&#8217;re all moving there. And I&#8217;ll tell you, yes, Ghost is good in the lane that Ghost runs in. But just the other day I was like, ah, I need to add a landing page, or I need to edit the footer.</p>\n\n\n\n<p>And I go to the help docs and it&#8217;s like, install your code editor. Set up a local repo., like run docker containers, and I&#8217;m like, I don&#8217;t want this. Where&#8217;s my full sight editing? Where&#8217;s my Beaver Builder? Where&#8217;s my Elementor? I just want to edit this one thing. Why can&#8217;t I do it? There is a luxury in WordPress that I think a lot of, a user interface luxury. Uh, a no code luxury. Call it what you want, that when I just want to click something and edit, for all the faults that you hear people complain about speed and performance. Man, put this up against the Ghosts, the Webflows, the Wix&#8217;s.</p>\n\n\n\n<p>I was looking at card.co, the other, I think it&#8217;s card.co. It&#8217;s like a super simplified like page building, five page portfolio site and I wanted to upload multiple photos. This was for again, the passing of my father-in-law and I wanted to put a little memorial site up, and I had hundreds of photos that I wanted to upload and I had to upload one at a time. And I said, no, I just want you drag a bunch of photos like I do in WordPress into a media gallery and display it. And these other tools just, they just don&#8217;t do it as easy as WordPress.</p>\n\n\n\n<p>So, like you, I&#8217;m, I&#8217;m an optimist on using WordPress. It&#8217;s the learning curve and the maintenance. But I think that&#8217;s a world we&#8217;re all slowly moving to where, that will all continue to get simplified by Automattic, by web hosts. Full sight editing. Oh boy. I&#8217;m really struggling with that big time. Gutenberg, yes, there are still some things I really struggle with, but there are some other great tools as alternatives that I use. And that&#8217;s the patchwork that I&#8217;m doing now.</p>\n\n\n\n<p>[00:32:38] <strong>Nathan Wrigley:</strong> The grass is always greener. There&#8217;s always that, I&#8217;m going to try that other CMS and see how it goes. And I&#8217;ve done the same, I&#8217;ve always ended up back with WordPress. It always seems like a, a comfortable pair of shoes. Terrible analogy, but there you go.</p>\n\n\n\n<p>[00:32:52] <strong>Matt Medeiros:</strong> WordPress, a comfortable pair of shoes.</p>\n\n\n\n<p>[00:32:54] <strong>Nathan Wrigley:</strong> Let&#8217;s get into the awkward business of Automattic and your thoughts around that. And you mentioned a moment ago that you thought that wordpress.org was moving inexorably towards being dominated by Automattic. What makes you say that, and does it trouble you? You went to great pains to say that it didn&#8217;t trouble you, but maybe on some level it does?.</p>\n\n\n\n<p>[00:33:14] <strong>Matt Medeiros:</strong> I think that the biggest factor here is communication, right? It&#8217;s communication from WordPress leadership. It&#8217;s communication from Jetpack and Automattic. These are signs that are quite obvious. So, I forget six months ago or something like that, I interviewed the uh, president or CEO of wordpress.com, talking about their new price points because they had done new price points.</p>\n\n\n\n<p>And the obvious gorilla in the room to me is, what are we doing with WooCommerce? We collectively as Automattic, like, when are you really going to compete with Shopify? And you know, he is, oh, you can compete with Shopify right now. You can just sign up for a WordPress.com. Yeah, but it&#8217;s nothing, it&#8217;s nothing like going to Shopify to start an e-commerce store. Nothing is guiding you as a merchant, as a store seller, as an entrepreneur.</p>\n\n\n\n<p>So these are obvious things that I can see, that everyone can see are the obvious paths to monetization to Automattic. And I think, one, we all step back and say, What would WordPress look like without Automattic? What would that world look like? Who would it be? Would it be Salesforce? Would it be Oracle? Would it be Microsoft? Do you want them in the lead of this software?</p>\n\n\n\n<p>I think that the best steward for all of this stuff, .org included, is Automattic. The challenge is, communication, direction. And do we all really get a seat at the table, question mark? And I fight for that seat at the table from my point of view, which is the website builder, the entrepreneur, the user, not a developer, certainly not a developer. But from my perspective, these are the things that I fight for. And I fight for WordPress to be open source because I think it is, in a world where we all go closed source, like I said before, this is things that could impact local economies.</p>\n\n\n\n<p>This is a tool that could get somebody who&#8217;s really struggling in life, to get a job in technology because you know how to make a WordPress post. These are the building blocks of the fundamentals of the internet, in my eyes. So, to me it&#8217;s, hey, go Automattic. Tax us, air quotes, tax us. I know this is interesting, me being in New England and you being in England to me, for me to say tax us. But that&#8217;s fine with me. I used to say the same thing when I used to sell themes. Why is this process so difficult? Why don&#8217;t we have the data? Why isn&#8217;t dot org just a marketplace?</p>\n\n\n\n<p>I am fine getting a 30% tax. If I can sell my goods in a place that&#8217;s trusted, secure, that we&#8217;re true partners with. And it just hasn&#8217;t happened because I feel that all roads lead to, we&#8217;ll monetize WordPress, this is Automattic speaking. We&#8217;ll monetize WordPress through Jetpack, wordpress.org, and then we&#8217;ll eventually upsell, hey, if you don&#8217;t want to host it yourself, come to .com, or Pressable. And I don&#8217;t see anything wrong with that. It&#8217;s just everyone, I think needs to sort of just face the fact and build their business, their plugin business around that.</p>\n\n\n\n<p>What I don&#8217;t like is overstepping and, and the hidden paths to upsell without anyone saying anything, ala Jetpack. I still think Jetpack is good for the right user. In fact, I used it on that memorial site because it&#8217;s a fantastic tool for quick and easy. But I think it&#8217;s also going to dominate other SEO plug-ins, other contact form plugins, the blue collar digital workforce that I try to advocate for a lot in the content that I put out.</p>\n\n\n\n<p>[00:36:35] <strong>Nathan Wrigley:</strong> What do you think about the governance of the project? So at the moment, we have the model, which is often called the benevolent dictator for life, and it kind of trickles down from there. Would you like there to be forays into altering that model? Are you happy with the fact that there is one person governing for life, or would you like to see little bits of that chipped away, chunks of the project, which are governed by the community more?</p>\n\n\n\n<p>[00:37:00] <strong>Matt Medeiros:</strong> I really appreciate the three conversations that Matt and I have had on my podcast. I think it&#8217;s been three. I don&#8217;t think that there is, when I have a problem with my MacBook, I don&#8217;t call up Tim Cook, and say hey man, come on my podcast, let&#8217;s talk about this Apple ecosystem you&#8217;ve got here, speaking of a 30% tax. It&#8217;s great for us as a community to have a single person that is semi approachable to have conversations with you. To be at WordCamps and have this, literally armed lengths away, to have a conversation with. Having said all of that, yes, I would like change. As I&#8217;ve told Matt, he does an insane amount of stuff.</p>\n\n\n\n<p>Automattic, wordpress.org, Tumblr, and Automattic is like 25 different products. One of them my favorite, which is Simple Note App, Jetpack, and all the other stuff that he does in life. How can he do it all? And I think that is a real issue. We look at the last couple of weeks ish, he&#8217;s actually talked more openly about where he wants to go with Tumblr than I feel he has with WordPress dot org, and how can you balance that?</p>\n\n\n\n<p>I think it&#8217;s a super challenge. I think, he thinks he can do it and he is doing it, but I think there should be some level of change. And Josepha again gracious to have her on the podcast once. How much can she possibly load on her back to do all of the work that she does? So, yes, I mean, I don&#8217;t have the answer for it.</p>\n\n\n\n<p>I don&#8217;t think it&#8217;s easy. I think a lot of people think that it&#8217;s easier said than done. But there should be something, some kind of governance model change, which I know people have pushed for in the past. I just don&#8217;t see how, how Matt can steer so many ships at once.</p>\n\n\n\n<p>[00:38:46] <strong>Nathan Wrigley:</strong> Speaking of steering a lot of ships. You&#8217;ve not only got The WP Minute and various other bits and pieces. You&#8217;ve also got a real interest in how podcasts are made, not just because you&#8217;re making podcasts and you go through that whole editing process and interviewing guests, much like we&#8217;re doing right now. But you&#8217;ve also taken a great interest in the technology behind how podcasts work. Actually just occurs to me, many people might not even know that there is a whole industry behind podcasting, but there is, and Castos is one of them. How long have you been now with Castos and what do you do over there?</p>\n\n\n\n<p>[00:39:19] <strong>Matt Medeiros:</strong> Yeah, so two and a half years, something like that. Director of Podcaster success. I try to make podcasters coming in to Castos successful with their podcast, however they might define success, Again, joining Caso because one, I&#8217;m a podcaster, two, they have a fantastic WordPress plugin.</p>\n\n\n\n<p>There&#8217;s a commitment to open source, on the WordPress side, there&#8217;s a commitment to open RSS. These are two worlds that collide greatly with me, and I&#8217;m a huge proponent, of course on open source and open distribution. You know, the perfect example is what&#8217;s the difference? Well, the, difference is a Spotify where you have to have the Spotify app to listen to a particular show, and open RSS means you can subscribe and distribute anywhere that accepts RSS.</p>\n\n\n\n<p>The world of podcasting, it&#8217;s funny, it continues to grow and there continues to be this excitement around it, but it continues to be more in more corporate interest. There is a tiny, tiny, tiny open source team that&#8217;s sort of leading the charge for, I&#8217;ll dumb it down, but RSS standards.</p>\n\n\n\n<p>It&#8217;s called Podcasting 2.0, and you can go to the podcastindex.org, and they run their own index, which is different than Apple, right? So Apple has their index, but you have to, you know, register and do all this stuff with Apple. Podcastindex.org is an open, so think of it as almost like wordpress.org, if you will.</p>\n\n\n\n<p>And they&#8217;re really leading the charge of enhancing the RSS feed. Doing things, more things in the RSS feed, like micro payment support, transcripts, chapters, live feed item tags, chat, cross platform chat. So they&#8217;re introducing a lot of this data and information that can help podcasters, and their challenges, similar to WordPress. They have to get other podcast hosts and other podcast apps to support these name spaces so that it&#8217;s for the greater good of the whole podcast economy or, or industry, right?</p>\n\n\n\n<p>So, you know, I&#8217;m a huge proponent of that. Again, to talk about like the approach of Matt, Matt Mullenweg to pull it back. I know, well, Matt&#8217;s from Texas, one of the head guys at Podcast Index is from Texas, Adam Curry, and I sent an email to Matt and Adam and I said, hey, you guys should talk to each other. You both know each other, you&#8217;re both into open source, open distribution. You all should have a conversation.</p>\n\n\n\n<p>And they, and they had a conversation and that Matt tied together the Pocket Cast team to them, and they had some great conversations. So, yeah, open source, open collaboration, it&#8217;s a great thing and I hope to keep waving that flag for podcasting.</p>\n\n\n\n<p>[00:41:52] <strong>Nathan Wrigley:</strong> That&#8217;s really interesting. I wonder if we are on the cusp of something akin to RSS with things like Mastodon, based upon Activity Hub, which is very like RSS. So essentially it&#8217;s an open platform where you can attach your social media stuff. I don&#8217;t know if you&#8217;ve come across this exodus from Twitter over the last couple of weeks.</p>\n\n\n\n<p>But there seemed to be a lot of people who, over the last few weeks have made up their mind that they would like something a bit more open. They would like to be able to get the content and post the content that they wish without the constraints of being logged in to some proprietary system. And in many of the comments that I&#8217;ve seen in people&#8217;s flight from Twitter, they keep talking about podcasts and how podcasting, 20 years ago, I believe it was Dave Winer who came up with the spec for RSS for podcasts, I could be wrong about that.</p>\n\n\n\n<p>But just how, with the benefit of hindsight, the whole RSS open nature of podcasts, so take Spotify and all those other things out of the equation. The fact that my podcast, your podcast, is available completely for free. You don&#8217;t need any sort of system, particularly, you just need to subscribe to a podcast feed, which is held on the website. Just how breathtakingly clever that was with a bit of hindsight.</p>\n\n\n\n<p>[00:43:03] <strong>Matt Medeiros:</strong> Yeah, yeah. Adam Curry as well helped, lead that charge. And he&#8217;s, he&#8217;s the one that&#8217;s sort of leading up the podcast index stuff, and podcasting 2.0 stuff. Yeah, it is great. A lot of the technology is, it&#8217;s very easy to implement, right? It&#8217;s all part of the RSS feed.</p>\n\n\n\n<p>And, you know, the challenge is, is sharing that data. So, it&#8217;s a, I don&#8217;t know if platform war is the right phrase for it, but you know, if you have your podcast on Spotify, Spotify can give you more analytics. They can do things in app that are for the better of the, of the listener. But don&#8217;t forget that it will be for the better of Spotify first, because they&#8217;re going to be the ones that run the ads and take a larger chunk of the profits or what have you.</p>\n\n\n\n<p>Whereas open RSS, we&#8217;re all fending for ourself, and as the more collaboration and the more people who support the innovations, the better we&#8217;ll all be. But that&#8217;s the challenge. To get everyone on the, on the same page. It&#8217;s, it&#8217;s actually no, a lot of similarities to WordPress.</p>\n\n\n\n<p>[00:44:01] <strong>Nathan Wrigley:</strong> You mentioned a moment ago that you feel that podcasting is still growing? I, I honestly have no insight into that whatsoever, but it does feel much more of a mainstream thing this year than it was last year and the year before that and so on. Is that in fact the case? Is there still a case to be made, is there data to back up that, yeah, podcasts really are still growing, and if your business or your interest, your hobby is something that you want to plunge into a podcast, it&#8217;s probably worth your time and effort.</p>\n\n\n\n<p>[00:44:27] <strong>Matt Medeiros:</strong> You have to kind of look at it, obviously I&#8217;ll call myself an insider to the podcasting space, but there is a lot more money and a lot more interest coming in from what I&#8217;ll call the corporate level. And the corporate level translates into Wondery&#8217;s, Amazon. Amazon owns Wondery, which is probably the premier podcast production company creating fiction, true crime, entertainment podcasts. And that&#8217;s all backed by advertisement. That can be openly distributed, but because Amazon owns it, if you listen to it on Amazon&#8217;s music app, then you get it without the ads. But if you listen to it on Apple Podcasts, you get it with the ads, right?</p>\n\n\n\n<p>So there&#8217;s this big interest in advertising, and celebrities and movies and movie industry and all that stuff. Then there&#8217;s the flip side, there&#8217;s you and me. The guys that make probably a few thousand dollars a year, instead of a few million dollars a year, like the big boys.</p>\n\n\n\n<p>If you go to podcastindex.org, I&#8217;m looking at it right now. There&#8217;s 4 million podcasts in the index. I think Apple says around two and a half million. But there is a stat right below that, that within the last three days there&#8217;s been 109,000 updates to podcasts. And in the last 90 days, 483,000 have been updated.</p>\n\n\n\n<p>So of the 4 million, yes, there&#8217;s a bunch that have probably either just ended, you know, it&#8217;s just a series of content that people have done. Pod faded where they have given up. The true earmark to that is 483,000 in the last 90 days. So people get scared of the 4 million mark. Like, oh my God. How is my podcast going to live within 4 million? But when you look at the data of 500,000 active within the last 90 days, you still have a shot, and yes, the answer is it&#8217;s still growing for the hobbyists, like you and I.</p>\n\n\n\n<p>[00:46:14] <strong>Nathan Wrigley:</strong> It&#8217;s really amazing. I feel so privileged in a way that I made the decision to get into it a little bit early when things were probably less competitive than they are now. That I&#8217;ve just kept banging on with it week week after week. It&#8217;s, yeah, it&#8217;s pretty amazing. Uh, I realize that we&#8217;ve used up a lot more of your time than I should have done, I apologize. So I&#8217;m just going to round off with one very simple question. You&#8217;ve been in the community many, many years. Let&#8217;s imagine five years, 10 years into the future. Do you reckon you&#8217;ll still be</p>\n\n\n\n<p>[00:46:40] <strong>Matt Medeiros:</strong> here?</p>\n\n\n\n<p>Yeah, a hundred percent. I&#8217;ll be using WordPress, as far as I can see, again. One, because I love it as a publishing tool. Two because I believe in it as a tool for somebody to learn and educate themselves and, and find a new opportunity, whether that&#8217;s coding, designing or writing. This is a tool that can impact economies. Three, I love, I just love the idea of, of open source on the web and really believe in that wholeheartedly. So yeah, I see myself sticking around.</p>\n\n\n\n<p>[00:47:09] <strong>Nathan Wrigley:</strong> Matt Medeiros, thank you for joining us on the podcast today.</p>\n\n\n\n<p>[00:47:12] <strong>Matt Medeiros:</strong> Thanks, Nathan.</p>\n</div>\n\n\n\n<p>On the podcast today we have <a href=\"https://craftedbymatt.com/about-matt/\">Matt Medeiros</a>.</p>\n\n\n\n<p>Matt is the driving force behind many WordPress initiatives. That could be the creation of plugins, WordPress news media, as well as podcasts about all manner of WordPress specific subjects. He likes to juggle multiple projects at once.</p>\n\n\n\n<p>Currently he’s the Director of Podcaster Success at <a href=\"https://castos.com/\">Castos</a>, which is a podcast hosting company with a WordPress plugin.</p>\n\n\n\n<p>He’s on the podcast today to give his take on the past, present and future of WordPress.</p>\n\n\n\n<p>Many millions of people like to work with the WordPress software. They create websites, plugins and themes which extend what the CMS can do. Others, such as Matt, like to ponder the broader purpose and direction of the software and the community around it.</p>\n\n\n\n<p><a href=\"https://mattreport.com/\">The Matt Report</a> and <a href=\"https://thewpminute.com/\">The WP Minute</a> have enabled us to hear about what the community is doing, what it wants and where its points of friction are. He’s talked to hundreds of people about what WordPress was, is, and might be, and so is in a unique position to pontificate about what WordPress, beyond the software, is.</p>\n\n\n\n<p>We start with Matt’s backstory. How he found WordPress and why he started to use it. We talk about how he’s dipped in and out of the community over the years; more excited at times, less so at others.</p>\n\n\n\n<p>The conversation moves on to some of the trends that Matt has noticed. He identifies how the software and the wider community have altered over time.</p>\n\n\n\n<p>We talk about how The WP Minute got started and how he’s building up a community of like-minded people to consume as well as to create the content that they’re putting out.</p>\n\n\n\n<p>Towards the end, we get into the governance of WordPress and the future of the project more generally. There are certainly things that Matt likes, but there are some wrinkles which get aired as well.</p>\n\n\n\n<p>We finish up talking about podcasts and Matt’s work with Castos and how they are trying to make it easier to get your voice out there, especially with their WordPress integration.</p>\n\n\n\n<p>It’s a lovely chat with a thoughtful and far sighted member of the community.</p>\n\n\n\n<h2>Useful links.</h2>\n\n\n\n<p><a href=\"https://mattreport.com/\">Matt Report</a></p>\n\n\n\n<p><a href=\"https://thewpminute.com/\">The WP Minute</a></p>\n\n\n\n<p><a href=\"https://castos.com/\">Castos</a></p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Wed, 30 Nov 2022 15:00:00 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:14:\"Nathan Wrigley\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:5;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:118:\"WPTavern: Gutenberg 14.6 Adds List View for Editing Navigation Block, Introduces New Automatic Color Palette Generator\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:30:\"https://wptavern.com/?p=139909\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:128:\"https://wptavern.com/gutenberg-14-6-adds-list-view-for-editing-navigation-block-introduces-new-automatic-color-palette-generator\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:4827:\"<p><a href=\"https://make.wordpress.org/core/2022/11/23/whats-new-in-gutenberg-14-6-23-november/\">Gutenberg 14.6</a> was released last week with a long list of small but impactful refinements to core blocks and the full-site editing experience. One of the most practical enhancements included in this update is the <a href=\"https://github.com/WordPress/gutenberg/pull/45546\">new list view for editing the Navigation block</a>.</p>\n\n\n\n<p>Gutenberg contributor Fabian Kägy published a quick video that helps to visualize the changes: </p>\n\n\n\n\n\n\n\n<p>The list view makes it easy for users to reorder navigation items using a drag-and-drop UI. The Navigation block in the content area instantly previews items that are moved in the block inspector.</p>\n\n\n\n<p>As part of a larger effort to make it easier to edit Navigation Links off the canvas, this release also <a href=\"https://github.com/WordPress/gutenberg/pull/45751\">adds a new URL field to the Navigation Link inspector</a> controls. Now user can edit the URL from the inspector controls as well as from the main link control.</p>\n\n\n\n<img />image credit: PR <a href=\"https://github.com/WordPress/gutenberg/pull/45751\">45751</a>\n\n\n\n<p>Version 14.6 also <a href=\"https://github.com/WordPress/gutenberg/pull/43496\">adds a variation picker to the Group block placeholder</a>. When users insert a new Group block, it will now allow them to select from among different variations to set the layout for the block. This makes it significantly easier for users to get started when using a Group block, instead of having to fiddle around to manually assign the desired layout.</p>\n\n\n\n<img />\n\n\n\n<p>One of the most creative features introduced in this release is the new <a href=\"https://github.com/WordPress/gutenberg/pull/40988\">“Randomize colors” feature</a> that will automatically generate color palettes on the fly. It utilizes hue rotations based on the <a href=\"https://www.mrao.cam.ac.uk/~dag/CUBEHELIX/\">Cubehelix color scheme</a>.</p>\n\n\n\n<p>&#8220;Hue rotation consists in rotating the hue wheel — such as the one you<br />might see in a color picker — by a determined amount of degrees, each turn<br />generating a new color,&#8221; Gutenberg contributor Vicente Canales said in the PR for the feature. He also noted that this new feature surfaces &#8220;the need for themes to explicitly support style randomization, as well as the need to incorporate a way to define a color&#8217;s role within a palette as a way of avoiding getting, for example, palettes where background and foreground don&#8217;t contrast, rendering text illegible.&#8221;</p>\n\n\n\n\n\n\n\n<p>While randomizing color palettes is a fun feature for users, some theme and plugin developers do not see the need for it to land in core Gutenberg and eventually WordPress.</p>\n\n\n\n<p>&#8220;Yes, it&#8217;s fun, but from a theme designer&#8217;s perspective I don&#8217;t see an urgent use since the theme designer can provide numerous style variations,&#8221; block and theme developer Ellen Bauer <a href=\"https://github.com/WordPress/gutenberg/pull/40988#issuecomment-1316048575\">commented</a> on the PR. &#8220;For the user this provides the same kind of &#8216;fun feel&#8217;, but theme designers would provide an experience that actually works.</p>\n\n\n\n<p>&#8220;There is so much potential in styles, but not much is published yet. So as a theme builder I feel style export/imports, the option to separate font styles from color styles are much more basic features I would love to have first.&#8221;</p>\n\n\n\n<p>Newsletter Glue co-founder Lesley Sim agreed that it&#8217;s a fun idea but that anyone using a theme will probably rely on the theme&#8217;s style variations.</p>\n\n\n\n<p>&#8220;And that will probably feel like a randomizer to them already,&#8221; Sim said. &#8220;At least, that&#8217;s how I personally view style variations.</p>\n\n\n\n<p>&#8220;I&#8217;d much rather focus on basic features first too, rather than fun ones. Let plugin and theme developers build the fun.&#8221;</p>\n\n\n\n<p>Other notable features in Gutenberg 14.6 include the following:</p>\n\n\n\n<ul>\n<li>Block Toolbar is now hidden when Spacing Visualizer is displayed</li>\n\n\n\n<li>New keyboard shortcut for transforming Paragraph block into Heading block</li>\n\n\n\n<li>Focal Point handle updated to be more representative of the broader selection area</li>\n\n\n\n<li>New “Minimum Height” dimension control is now available for the Group and Post Content block</li>\n</ul>\n\n\n\n<p>This update&#8217;s performance benchmarks for the site editor and post editor are significantly improved for three out of four metrics over the last release. Check out the <a href=\"https://make.wordpress.org/core/2022/11/23/whats-new-in-gutenberg-14-6-23-november/\">release post</a> for a more detailed look at every PR included 14.6. </p>\n\n\n\n<p></p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Wed, 30 Nov 2022 03:12:10 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Sarah Gooding\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:6;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:59:\"Do The Woo Community: Cooking Up Some Code with Kim Coleman\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:28:\"https://dothewoo.io/?p=73751\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:58:\"https://dothewoo.io/cooking-up-some-code-with-kim-coleman/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:408:\"<p>Kim talks about looking at code as words, learning PHP, her journey as a WordPress developer, and choosing her lifestyle and her career.</p>\n<p>&gt;&gt; The post <a rel=\"nofollow\" href=\"https://dothewoo.io/cooking-up-some-code-with-kim-coleman/\">Cooking Up Some Code with Kim Coleman</a> appeared first on <a rel=\"nofollow\" href=\"https://dothewoo.io\">Do the Woo - a WooCommerce Builder Community</a>	.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Tue, 29 Nov 2022 11:25:00 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:5:\"BobWP\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:7;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:98:\"WPTavern: Meetup.com Removes Accessibility Overlay In Response to WordPress Community’s Concerns\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:30:\"https://wptavern.com/?p=139886\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:106:\"https://wptavern.com/meetup-com-removes-accessibility-overlay-in-response-to-wordpress-communitys-concerns\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:4753:\"<p>Meetup.com has <a href=\"https://make.wordpress.org/community/2022/11/23/meetup-com-accessibility-overlay-update/\">removed its accessibility overlay</a>, a recent addition to the company&#8217;s website that <a href=\"https://wptavern.com/meetup-com-raises-concerns-with-new-accessibility-overlay\">raised concerns with the WordPress community</a> and the broader community of accessibility professionals. The overly was powered by <a href=\"https://www.equalweb.com/html5/?_id=8591&did=1116&_gid=202027&trace=equalweb_menu_en_\">EqualWeb</a>, a product which claims to provide automated compliance with accessibility standards but doesn&#8217;t address inaccessibility at the root of the problem.</p>\n\n\n\n<p>WordPress Community Team leaders requested a meeting with the company and were able to persuade them to take the overlay down and focus on direct improvements to the Meetup.com platform. WordPress community organizer Angela Jin reported that their director of engineering and other team members were &#8220;very receptive to our feedback.&#8221;</p>\n\n\n\n<p>&#8220;EqualWeb’s widget does scan for accessibility issues, and the original plan was for EqualWeb’s team (real people!) to provide progressive fixes to the overlay,&#8221; Jin said. &#8220;Meetup’s hope was to provide, over time, a fully accessible overlay.&#8221; </p>\n\n\n\n<p>During the meeting, WordPress&#8217; Community Team representatives contended that overlays create a poor user experience for people who use assistive technology while also ignoring key WCAG issues. This is why there are growing legal and privacy concerns associated with the overlays, which do not deliver on the promise of providing equal and open access to platforms.</p>\n\n\n\n<p>After reporting on the issue earlier this month, one reader asked if the overlays  actually work to address the issues and, if so, what is motivating the complaint.</p>\n\n\n\n<p>&#8220;They don’t work,&#8221; WordPress accessibility contributor Joe Dolson said. &#8220;To the degree that they do work, they mostly offer functionality that is already duplicated by the user’s own technology.&#8221;</p>\n\n\n\n<p>Dolson examined Meetup.com&#8217;s overlay and highlighted a few of its major shortcomings:</p>\n\n\n\n<blockquote class=\"wp-block-quote\">\n<p>This particular overlay also commits the cardinal sin of labeling tools by disability, rather than according to what they do. For example, if you turn on the “Visually Impaired” mode, that’s actually a high contrast mode; which is only relevant if your visual impairment benefits from high contrast. This kind of presumptive labeling is ineffective at best (because it makes it difficult to find what tool might actually help you, should you need it), and offensive at worst.</p>\n\n\n\n<p>But the reality is that overlay tools are a misdirection of resources: if a user needs high contrast, large fonts, or other tools, they need those on <em>all</em> websites, and they need a solution that’s their tool, in their control, with their settings – and the majority of users already have that in their assistive technology.&#8221;</p>\n</blockquote>\n\n\n\n<p>As part of revising its accessibility roadmap, Meetup.com is requesting feedback from WordPress community members with experience using its platforms across devices with accessibility features enabled. Those who have 50 minutes in the coming weeks can request to speak with Meetup representatives regarding which features should be prioritized. People can also leave feedback in the comments.</p>\n\n\n\n<p>Meetup.com&#8217;s decision to remove the overlay was well-received by accessibility advocates who hope to see more changes to the platform&#8217;s source code based on community feedback in the next few weeks. Beyond these changes, some community members are also recommending Meetup.com add people with disabilities to their team to get more first-hand information without having to publicly walk back an implementation like this.</p>\n\n\n\n<p>&#8220;Although I applaud Meetup for removing the Overlay, they are going at this backwards,&#8221; WordPress user @bryan202 said in the comments. &#8220;They should have an independent company who employs persons with disabilities to audit their platform and inform them of the issues. If Meetup wants feedback on the specific issues this choice of overlay caused, then they should be willing to pay for that market feedback. </p>\n\n\n\n<p>&#8220;As a disabled person we are constantly called upon to give feedback for free. We deserve to be respected for our time, efforts and feedback. Meetup needs to expand their technical team to include persons with disabilities so they have an inside look since their current team is missing this essential component.&#8221;</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Tue, 29 Nov 2022 03:18:35 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Sarah Gooding\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:8;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:93:\"WordPress.org blog: WP Briefing: Episode 44: Minors, Majors, and Why We Have So Many Releases\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:53:\"https://wordpress.org/news/?post_type=podcast&p=13996\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:93:\"https://wordpress.org/news/2022/11/episode-44-minors-majors-and-why-we-have-so-many-releases/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:8340:\"<p>In the forty-fourth episode of the WordPress Briefing, our host Josepha Haden Chomphosy highlights the role of major and minor releases in the WordPress open source project. </p>\n\n\n\n<p><em><strong>Have a question you&#8217;d like answered? You can submit them to <a href=\"mailto:wpbriefing@wordpress.org\">wpbriefing@wordpress.org</a>, either written or as a voice recording.</strong></em></p>\n\n\n\n<h2>Credits</h2>\n\n\n\n<p>Editor:&nbsp;<a href=\"https://profiles.wordpress.org/dustinhartzler/\">Dustin Hartzler</a><br />Logo:&nbsp;<a href=\"https://profiles.wordpress.org/javiarce/\">Javier Arce</a><br />Production:&nbsp;<a href=\"https://profiles.wordpress.org/santanainniss/\">Santana Inniss</a><br />Song: Fearless First by Kevin MacLeod </p>\n\n\n\n<h2>References</h2>\n\n\n\n<p><a href=\"https://en.wikipedia.org/wiki/12th_man_(football)\">Twelfth Man</a><br /><a href=\"https://wordpress.org/news/2022/11/state-of-the-word-2022/\">State of the Word</a></p>\n\n\n\n<h2>Transcript</h2>\n\n\n\n<span id=\"more-13996\"></span>\n\n\n\n<p><strong>[Josepha Haden Chomphosy 00:00:00]&nbsp;</strong></p>\n\n\n\n<p>Hello everyone! And welcome to the WordPress Briefing, the podcast where you can catch quick explanations of the ideas behind the WordPress open source project, some insight into the community that supports it, and get a small list of big things coming up in the next two weeks.&nbsp;</p>\n\n\n\n<p>I&#8217;m your host, Josepha Haden Chomphosy. Here we go.</p>\n\n\n\n<p><strong>[Josepha Haden Chomphosy 00:00:27]&nbsp;</strong></p>\n\n\n\n<p>At the top of November, a new major release for WordPress shipped. That was WordPress 6.1. I know I talked about it basically nonstop. Then two weeks later, there was a new minor release for WordPress. It was WordPress 6.1.1, which I did not talk about at all. Way back in episode four of this podcast, I dug into the overall release cycle and what someone could expect from a high-level logistics aspect.</p>\n\n\n\n<p><strong>[Josepha Haden Chomphosy 00:01:05]&nbsp;</strong></p>\n\n\n\n<p>And today we&#8217;re gonna take a quick look at minor releases in particular. Just as a general heads up, I always want to lean into sports metaphors when I&#8217;m talking about releases, and I think it&#8217;s because of the words major and minor. And so, I&#8217;ve done my level best to not include that in any of my explanations today.</p>\n\n\n\n<p>But I do have one, I do have one that&#8217;s a sports thing. So just if you don&#8217;t like sports, know that it&#8217;s just one little bit and we&#8217;ll try to be carefully quick around it together. All right, so minor releases. You may have noticed that I don&#8217;t mention minor releases nearly as often as I mention major releases. And yet, most of the time, when we have a major release of WordPress, there&#8217;s a minor release that gets started almost immediately after.</p>\n\n\n\n<p>So first major versus minor. Major releases in WordPress happen roughly three times a year, give or take a release. Inside a major release, you will find that we include features, so– brand new abilities, enhancements, which you can generally call improvements to existing abilities, and also any bug fix that we can find, big or small, we&#8217;ll take &#8217;em all.</p>\n\n\n\n<p><strong>[Josepha Haden Chomphosy 00:02:16]&nbsp;</strong></p>\n\n\n\n<p>So minor releases in WordPress happen about four or five times a year on average. Minor releases include patches for issues introduced in the major release and any bug fix that doesn&#8217;t add or change functionality.&nbsp;</p>\n\n\n\n<p>If you&#8217;re with me so far, you probably have noted that there&#8217;s basically always at least one minor release per major release. And you might have also noted that I said minors include patches for issues we introduced in a major.</p>\n\n\n\n<p>Now, if I were hearing this with fresh ears, the first thing I would wonder is, okay, so if you start working on the minor right after you release the major to deal with issues you know you introduced in the major– why just not ship the major while there are bugs in it? Great question. I&#8217;m glad you asked. So there are a few things worth knowing here.</p>\n\n\n\n<p><strong>[Josepha Haden Chomphosy 00:03:09]&nbsp;</strong></p>\n\n\n\n<p>Firstly, there is this concept of “ship and iterate,” which is present in both agile and open source. The idea is that we ship software as soon as we have confidence that what is in the release is non-breaking and represents our best guests at a better experience for our users.</p>\n\n\n\n<p>Once that is out there, we use feedback on the initial release to quickly iterate and ship another release. That way, we don&#8217;t hold back any good features. And since we already planned the immediate minor, any major issues that show up can be fixed in as little as two weeks. Secondly, there is the concept that with many eyes, all bugs are shallow, which is primarily present in open source.</p>\n\n\n\n<p>The idea here is that with enough people looking at a problem, that problem doesn&#8217;t stand a chance. So when a release is shipped in a workable state but with interactions that could use some refinement, the fastest way to find those refinements is to take it to the community of WordPress users and developers and invite them to co-create this CMS with us.</p>\n\n\n\n<p><strong>[Josepha Haden Chomphosy 00:04:10]</strong></p>\n\n\n\n<p>Which touches on my final thought. The concept of the user as co-creator.</p>\n\n\n\n<p>If we think about the development and evolution of our software as a team effort, then we can think of the people who use our software as what&#8217;s called the “Twelfth Man” That&#8217;s in quotes, and I will, I&#8217;ll leave a link to that in the show notes as well.&nbsp;</p>\n\n\n\n<p>In sports, this refers to the fans. And if you&#8217;ve ever been to a live sporting event or played in any, you will know that the cheering and jeering from fans turns into this distinct motivating entity all its own. As a whole team or individual member, you know what you have to do. You know what you need to do in a game, but there&#8217;s something about that chaotic, loud roar of feedback that just brings life to what you&#8217;re doing, and that&#8217;s how I see our community of users.</p>\n\n\n\n<p><strong>[Josepha Haden Chomphosy 00:05:02]</strong></p>\n\n\n\n<p>So at the end of the day, the answer to the question of ‘why so many releases’ and the follow-up question of ‘why tolerate stable imperfection’ is largely the same. To get features into the hands of our users quickly so that we can always be breathing life into this CMS we care so much about.</p>\n\n\n\n<p>I hope that answers your questions about our release cadence, and if you didn&#8217;t come into this podcast having any questions about release cadences at all, I hope this new information brings a little extra light to the complexity of working in open source.&nbsp;</p>\n\n\n\n<p><strong>[Josepha Haden Chomphosy 00:05:32]&nbsp;</strong></p>\n\n\n\n<p>That brings us now to our small list of big things.</p>\n\n\n\n<p>Big thing number one is that the State of the Word has been announced and is scheduled for December 15th. It&#8217;s a little earlier in the day than in past iterations, so I hope we get a new crew of listeners tuning in at the same time. I&#8217;ll leave a link to that in the show notes, or you can pop over to wordpress.org/news to see the announcement for yourself.</p>\n\n\n\n<p><strong>[Josepha Haden Chomphosy 00:06:00]&nbsp;</strong></p>\n\n\n\n<p>Big thing number two is that team rep nominations are open on most teams right now. So if organization and people wrangling are high on your list of ways you can give back to WordPress, head on over to the team you contribute to and see how you raise your hand for that.&nbsp;</p>\n\n\n\n<p>Then big thing number three is that big-picture goals, hopes, and timelines are being gathered, and I will ship those shortly after the start of the new year.</p>\n\n\n\n<p>It will give us all an idea of where we want to focus our attention to ensure that WordPress continues to grow toward the future. You can keep an eye out for that on make.wordpress.org/project.&nbsp;</p>\n\n\n\n<p>And that, my friends, is your small list of big things. Thanks for tuning in today for the WordPress Briefing. I&#8217;m your host, Josepha Haden Chomphosy, and I&#8217;ll see you again in a couple of weeks.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Mon, 28 Nov 2022 12:00:00 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:14:\"Santana Inniss\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:9;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:142:\"Gutenberg Times: Gutenberg Changelog #76 – The new developer blog’s public beta, Gutenberg 14.5 and 14.6, and what’s coming up in 6.2. \";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:53:\"https://gutenbergtimes.com/?post_type=podcast&p=22833\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:145:\"https://gutenbergtimes.com/podcast/gutenberg-changelog-76-the-new-developer-blogs-public-beta-gutenberg-14-5-and-14-6-and-whats-coming-up-in-6-2/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:74613:\"<p>Ryan Welcher and Birgit Pauli-Haack discuss the new developer blog’s public beta, Gutenberg 14.5 and 14.6, and what’s in the works for the block editor.</p>\n\n\n\n<p><a href=\"https://gutenbergtimes.com/podcast/gutenberg-changelog-69-gutenberg-releases-wordpress-6-0-1-the-create-block-theme/#shownotes\">Show Notes</a> / <a href=\"https://gutenbergtimes.com/podcast/gutenberg-changelog-69-gutenberg-releases-wordpress-6-0-1-the-create-block-theme/#transcript\">Transcript</a></p>\n\n\n\n<ul>\n<li>Music:&nbsp;<a href=\"https://soundcloud.com/xirclebox\">Homer Gaines</a></li>\n\n\n\n<li>Editor:&nbsp;<a href=\"https://www.linkedin.com/in/sandy-reed/\">Sandy Reed</a></li>\n\n\n\n<li>Logo:&nbsp;<a href=\"https://markuraine.com/\">Mark Uraine</a></li>\n\n\n\n<li>Production:&nbsp;<a href=\"https://icodeforapurpose.com\">Birgit Pauli-Haack</a></li>\n</ul>\n\n\n\n<p class=\"has-larger-font-size\" id=\"shownotes\"><strong>Show Notes</strong></p>\n\n\n\n<h2>Connect with Ryan Welcher</h2>\n\n\n\n<ul>\n<li>Twitch Streams: <a href=\"https://www.twitch.tv/ryanwelchercodes\">RyanWelcherCodes</a></li>\n\n\n\n<li>YouTube Channel: <a href=\"https://www.youtube.com/ryanwelchercodes\">Ryan Welcher Codes</a></li>\n\n\n\n<li>Twitter: <a href=\"https://twitter.com/ryanwelcher\">@ryanwelcher</a></li>\n\n\n\n<li>WordPress Make Slack: <a href=\"https://profiles.wordpress.org/welcher/\">@welcher</a></li>\n\n\n\n<li>GitHub: <a href=\"https://github.com/ryanwelcher\">@ryanwelcher</a></li>\n</ul>\n\n\n\n<h2>Announcements</h2>\n\n\n\n<ul>\n<li><a href=\"https://make.wordpress.org/core/2022/11/23/final-releases-of-wordpress-3-7-4-0/\">Final releases of WordPress 3.7 – 4.0</a></li>\n\n\n\n<li><a href=\"https://wordpress.org/news/2022/11/state-of-the-word-2022/\">State of the Word 2022</a></li>\n</ul>\n\n\n\n<h3>WordPress Developer Blog</h3>\n\n\n\n<ul>\n<li><a href=\"https://make.wordpress.org/core/2022/11/21/wordpress-developer-blog-is-in-public-beta/\">WordPress Developer Blog is in public beta</a>  \n<ul>\n<li><a href=\"https://wptavern.com/wordpress-launches-developer-blog-in-beta\">WordPress Launches Developer Blog In Beta</a> (WPTavern) </li>\n\n\n\n<li><a href=\"https://css-tricks.com/wordpress-developer-blog/\">WordPress Developer Blog</a> (CSS-Tricks) </li>\n</ul>\n</li>\n\n\n\n<li><a href=\"https://developer.wordpress.org/news/2022/11/17/welcome-to-the-wordpress-developer-blog/\">Welcome to the WordPress Developer Blog</a> by Josepha Haden Chomphosy</li>\n\n\n\n<li><a href=\"https://developer.wordpress.org/news/2022/11/17/demystifying-home-and-posts-templates-in-wordpress-theme-development/\">Demystifying Home and Posts Templates in WordPress theme development</a> by Daisy Olsen</li>\n\n\n\n<li><a href=\"https://developer.wordpress.org/news/2022/11/17/creating-themes-from-a-pattern-first-mindset/\">Creating Themes from a Pattern-First Mindset</a> by Justin Tadlock </li>\n\n\n\n<li><a href=\"https://developer.wordpress.org/news/2022/11/18/how-to-extend-wordpress-via-the-slotfill-system/\">How to extend WordPress via the SlotFill system</a> by Ryan Welcher</li>\n</ul>\n\n\n\n<h2>What&#8217;s released</h2>\n\n\n\n<ul>\n<li><a href=\"https://wordpress.org/news/2022/11/wordpress-6-1-1-maintenance-release/\">WordPress 6.1.1 Maintenance Release</a></li>\n\n\n\n<li><a href=\"https://wordpress.org/news/2022/11/misha/\">WordPress 6.1 “Misha”</a></li>\n\n\n\n<li><a href=\"https://wordpress.org/plugins/woo-gutenberg-products-block/\">Woo Commerce Blocks</a></li>\n\n\n\n<li><a href=\"https://developer.woocommerce.com/2022/11/23/woocommerce-blocks-9-0-0-release-notes/\">WooCommerce Blocks 9.0.0 Release Notes</a></li>\n</ul>\n\n\n\n<h3>Gutenberg Plugin</h3>\n\n\n\n<ul>\n<li><a href=\"https://make.wordpress.org/core/2022/11/09/whats-new-in-gutenberg-14-5-9-november/\">What’s new in Gutenberg 14.5? (9 November)</a></li>\n\n\n\n<li><a href=\"https://make.wordpress.org/core/2022/11/23/whats-new-in-gutenberg-14-6-23-november/\">What’s new in Gutenberg 14.6? (23 November)</a></li>\n\n\n\n<li><a href=\"https://wptavern.com/gutenberg-14-5-introduces-new-document-overview-panel-improves-block-spacing-controls\">Gutenberg 14.5 Introduces New “Document Overview” Panel, Improves Block Spacing Controls</a></li>\n</ul>\n\n\n\n<h4>Documentation</h4>\n\n\n\n<ul>\n<li><a href=\"https://developer.wordpress.org/block-editor/how-to-guides/javascript/\">How to use JavaScript with the Block Editor</a></li>\n\n\n\n<li><a href=\"https://wordpress.github.io/gutenberg/?path=/docs/docs-introduction--page\">Storybook &#8211; Introduction</a></li>\n</ul>\n\n\n\n<h2>What’s in active development or discussed</h2>\n\n\n\n<ul>\n<li><a href=\"https://github.com/WordPress/gutenberg/discussions/45346\">Design Concepts on the new brows mode</a>&nbsp;&nbsp;</li>\n\n\n\n<li><a href=\"https://github.com/WordPress/gutenberg/pull/45509\">Template Parts: Add an option to import widgets from the sidebars</a></li>\n\n\n\n<li><a href=\"https://github.com/WordPress/gutenberg/issues/45271\">Global Styles/Typography: Managing font sets</a></li>\n\n\n\n<li><a href=\"https://github.com/WordPress/gutenberg/issues/44361\">Make it possible to push local block styles to global block styles</a>.</li>\n\n\n\n<li><a href=\"https://github.com/WordPress/gutenberg/pull/46014\">Pre-publish: suggest uploading external images</a></li>\n\n\n\n<li><a href=\"https://github.com/WordPress/gutenberg/pull/45005\">Sidebar: Split block tools into menu, settings, and appearance tabs</a></li>\n</ul>\n\n\n\n<p class=\"has-large-font-size\">Stay in Touch</p>\n\n\n\n<div class=\"wp-block-group is-layout-flow\"><div class=\"wp-block-group__inner-container\">\n<ul>\n<li>Did you like this episode? <a href=\"https://lovethepodcast.com/gutenbergchangelog\"><strong>Please write us a review </strong></a></li>\n\n\n\n<li>Ping us on Twitter or send DMs with questions. <a href=\"https://twitter.com/gutenbergtimes\">@gutenbergtimes </a>and <a href=\"https://twitter.com/bph\">@bph</a>.</li>\n\n\n\n<li><em>If you have questions or suggestions, or news you want us to include, send them to <a href=\"mailto:changelog@gutenbergtimes.com\">changelog@gutenbergtimes.com</a>. </em></li>\n\n\n\n<li><em>Please write us a review on iTunes! <a href=\"https://gutenbergtimes.com/itunes/\">(Click here to learn how)</a></em></li>\n</ul>\n</div></div>\n\n\n\n<p class=\"has-large-font-size\" id=\"transcript\"><strong>Transcript</strong></p>\n\n\n\n<p><em>Birgit Pauli-Haack</em>: Hello and welcome to our 76th episode of the Gutenberg Changelog podcast. In today&#8217;s episode, we will talk about the new Developer Blog Public Beta, Gutenberg 14.5, 14.6 and what&#8217;s in the work on for the Block Editor. I&#8217;m Birgit Pauli-Haack, curator at the Gutenberg Times and WordPress developer advocate. And I&#8217;m thrilled that my friend, Ryan Welcher, core contributor, livestream on Twitch and developer advocate joined me today. Again, yeah, you&#8217;ve been on the show before. Good afternoon, Ryan. How are you?</p>\n\n\n\n<p><em>Ryan Welcher</em>: I&#8217;m good, Birgit. Thanks for having me again. I&#8217;m always excited to hang out with you and talk Gutenberg release notes and all this stuff. Yeah. I&#8217;m excited.</p>\n\n\n\n<p><em>Birgit Pauli-Haack</em>: We do to have you here. So yesterday, you had your weekly Twitch stream again. And you had a break of three weeks and you came back and so what was it about?</p>\n\n\n\n<p><em>Ryan Welcher</em>: Well, for the past two weeks&#8230; well, the first week back I spent trying to relearn how to use computers and the internet because it was three weeks off. I didn&#8217;t have a clue what I was doing. So the last couple of weeks, I&#8217;ve been focusing on Query Loop Block variations. So this week or yesterday, I actually started building a plugin that introduced controls to the Query Loop Block to be able to do more complicated and more advanced queries. And so I&#8217;ll probably be doing that for the next couple of streams and then hopefully releasing that into the wild for developers or anyone to use really. So yeah.</p>\n\n\n\n<p><em>Birgit Pauli-Haac</em>k: Oh, that&#8217;s cool. Yeah.</p>\n\n\n\n<p><em>Ryan Welcher</em>: Yeah. You can check me out at RyanWelchercodes is my handle on Twitch. Every Thursday at 10:30 Eastern.</p>\n\n\n\n<p><em>Birgit Pauli-Haack</em>: And if you missed any of Ryan&#8217;s Twitch streams, they go silent on Twitch. But Ryan always makes the additional effort to put them up on your YouTube channel. That&#8217;s the same username, youtube.com/ryanwelchercodes.</p>\n\n\n\n<p><em>Ryan Welcher:</em> That&#8217;s right, yep.</p>\n\n\n\n<p><em>Birgit Pauli-Haack</em>: Yeah. And I always have to follow up because it&#8217;s really great stuff that you put out there and I learn so much about it.</p>\n\n\n\n<p><em>Ryan Welcher:</em> Oh, thank you.</p>\n\n\n\n<p><em>Birgit Pauli-Haack</em>: Not only how to do it well, but also to how to get to doing it well and see what you&#8217;re struggle with. And I&#8217;m really good-</p>\n\n\n\n<p><em>Ryan Welcher:</em> Yeah. 80% of my stream is me spelling things horribly and typoing like crazy and then not knowing why something&#8217;s broken. So, yeah, I have some viewers that are regulars that help me out all the time. Shout out to Kevin, he knows who he is. Cool.</p>\n\n\n\n<p><em>Birgit Pauli-Haack</em>: Awesome. Awesome. And we have a good show for you dear listeners today. And for the American listeners, it&#8217;s all happy Thanksgiving. And also I hope you have a great time on Black Friday and then serve on Monday. So I will be, over the weekend, at a cricket game tournament in Sarasota. And so we are doing this recording today and then I&#8217;m off to my weekend.&nbsp;</p>\n\n\n\n<h3><strong>Announcements</strong></h3>\n\n\n\n<p>So we have a couple announcements that came in from project and one of we are all involved, you and I. That&#8217;s the WordPress Developer Blog is in public beta. And so it came out of discussion or year-long complaints or many years is that staying on top of the new features that are coming to WordPress. Open source is really one of the main barriers for developers to get started on the Block Editor, the site editor and doing stuff with it.</p>\n\n\n\n<p>And the Core Block where most of the information is released has a very heavy emphasis for meeting nodes of the various core teams. And also it only highlights the new features that came with a major release. But for the Gutenberg plugin or what&#8217;s in the works on the PHP site, there is not a central place. It&#8217;s difficult for developers who are not contributors to get anything out of those make blogs as a relevant information. So the content will or focuses on the updates for developers, extenders who create plugins and themes and those who work with WordPress at an agency or as freelancers. And you were one of them working at an agency, also a free freelancer. So I really appreciate your continuing input on what is needed for agencies on the new features and how does it work there also.</p>\n\n\n\n<p>So it&#8217;s really good that we have now a place where that information can be shared. And it&#8217;s in beta, so there are not a whole lot of posts there, but that&#8217;s definitely going to change next year. We have three posts there. One is Ryan&#8217;s post on how to extend the WordPress wire slot fill system. What is that about, Ryan?</p>\n\n\n\n<p><em>Ryan Welcher</em>: So a slot fill system is an extension paradigm that was introduced with the Block Editor with WordPress 5.0. And it&#8217;s a way of extending UIs, let&#8217;s put it that way. So you can inject your own elements into certain areas inside of the Block Editor and inside the site editor now. And, yeah, the article there is sort of preliminary. Sort of deep but not too deep. Deep enough to get started. And it&#8217;s based on a couple of talks that I&#8217;ve given in the past. So if you&#8217;re looking to extend the UI for the site editor or for the Block Editor, I&#8217;d go and take a look at that.</p>\n\n\n\n<p>But, yeah, it&#8217;s kind of code heavy, but it&#8217;s one of the reasons why the Developer Blog, I think, is going to be so important because normally I would write this on my own personal blog. And now we have a central place where we can share this information, it&#8217;s sort of official, and people know where to go and they don&#8217;t have to know who I am or what my web address is or any of that stuff to be able to get the information that I&#8217;m trying to share.</p>\n\n\n\n<p><em>Birgit Pauli-Haack</em>: Yeah, that&#8217;s a very good point. Yeah, there&#8217;s a lot of information out there that&#8217;s decentralized and bringing them all in or bring the writers in. Daisy Olsen has a post and she demystifies the home and post templates for the WordPress theme development. It&#8217;s not necessarily focused on block themes, that&#8217;s pretty much&#8230; it shows you for classic themes as well as for block themes. And then Justin Tadlock has a post where he helps theme developers think about block theme development from a pattern first mindset to avoid redundancy in code and also to have some simplicity more in the theme development. And I think that all three of them are really excellent hosts there. So I&#8217;m so excited about this and I know a lot of people are to kind of see what comes out of that. Yeah, so check it out.</p>\n\n\n\n<p>There&#8217;s also a page there that gives you a little bit more history about that and also a page that says how you can contribute if you want to be a writer or if you want to be a reviewer or you want to just kind of add your ideas to it, go there. And it&#8217;s mainly managed through GitHub so you get even an additional kind of insight in how GitHub works, even if you&#8217;re not so code centric and had always shied away. But believe me, it&#8217;s always a good place to be as a WordPress contributor.</p>\n\n\n\n<p><em>Ryan Welcher</em>: I just want to kind of reiterate what you&#8217;re saying about how anyone can write for the Developer Blog. It&#8217;s not gated in the sense of&#8230; there is a process and ideas and content may not be accepted, but that&#8217;s based on topic, not based on who&#8217;s contributing it. So I think it&#8217;s really important to understand that it&#8217;s not just for certain folks and it&#8217;s not just for contributors or whoever, it&#8217;s for whoever really wants to. And as long as you sort of adhere to the process, there&#8217;s no reason why I could say anybody wouldn&#8217;t be able to add content to the Developer Blog. It&#8217;s truly open source.</p>\n\n\n\n<p><em>Birgit Pauli-Haack</em>: And can also be reused because it&#8217;s going to be in public domain. So that&#8217;s the GPL part of it. Yeah. Another announcement came down the pipe, which is that core committer and Peter Wilson, and he&#8217;s also member of the security team, announced that WordPress will drop support for WordPress 3.7 and 4.0 on December 1st. And you might ask, &#8220;What? They&#8217;re still supporting that? I thought it was only the last two WordPress versions.&#8221; That is true. Officially, WordPress only supports the last two major versions, but the security team had always also applied security updates to previous versions from 3.7 to 6.03. They all got the same security updates. And that is to end.</p>\n\n\n\n<p>So 3.7, 3.8, 3.9 and 4.0, they get one more update that will announce that there won&#8217;t be any future updates in the WP admin. So if you have these old versions in the stable of your clients, make sure that you upgrade to the later versions. I looked at the WordPress stats for that. So there is a stat online that gives you how many people are on which version on WordPress. And all four versions come together at 0.5% of WordPress installations. So, yeah, it&#8217;s a good decision. They wanted to do it last year but somehow it didn&#8217;t make it. Now it&#8217;s this year. So I just wanted to let everybody know the 3.7 to 4.0.</p>\n\n\n\n<p><em>Ryan Welcher</em>: It just amazes me that WordPress versions that far back still work. People are still able to run it and I just think that&#8217;s fantastic. You should update. If you&#8217;re running 3.7, you should update. There&#8217;s a lot of functionality that you&#8217;re missing out on, but it&#8217;s amazing that it still works.</p>\n\n\n\n<p><em>Birgit Pauli-Haack:</em> I wanted to look up when 3.7 was actually released and I think it was 2010 or something like that, but I can verify that. Maybe not. Yeah.</p>\n\n\n\n<p><em>Ryan Welcher:</em> March 14th, 2017? That makes sense?</p>\n\n\n\n<p><em>Birgit Pauli-Haack</em>: Oh, yeah. Could be. Could be. Yeah. Yeah. We are only at 3.0 or something.</p>\n\n\n\n<p><em>Ryan Welcher</em>: Sorry, I was looking at the wrong place. October 24th, 2013, version 3.7.</p>\n\n\n\n<p><em>Birgit Pauli-Haack</em>: Okay, thank you.</p>\n\n\n\n<p><em>Ryan Welcher</em>: Was named for Count Basie. Interesting.</p>\n\n\n\n<p><em>Birgit Pauli-Haack</em>: 2013. So that is a nine year old version, and nothing on your computer should be nine years old. And not on the survey either or be just accessible by the public on the internet. Yeah, for sure. Update.&nbsp;</p>\n\n\n\n<h3><strong>What’s Released</strong></h3>\n\n\n\n<p>So we&#8217;ll come to sections what&#8217;s released? And since the last show on October 30th recorded, we had two WordPress releases. One was a major release 6.1 and we talked about it. Yay. We talked about it quite a few times here and I definitely will share again the field guide link in the show notes. And then there was another release on November 15th for the 6.1.1. And it&#8217;s about roughly 50 bug fixes that didn&#8217;t make it in at 6.1 or came out after 6.1 was released. So that was a major effort from the release team 14 days after a major release to come up with a point release to get all the bug fixes in the hands of the WordPress users.</p>\n\n\n\n<p>So there&#8217;s also a release from WooCommerce Blocks 9.0. Just for those who don&#8217;t know, WooCommerce Blocks is the bleeding edge plugin from WooCommerce similar to the Gutenberg plugin relates to the WordPress software. So using it, you can test all the future features coming to WooCommerce and help improve them before they&#8217;re actually released in WooCommerce. And the 9.0 the release came out this week. Actually today, and it&#8217;s November 25th, 2022. So they updated the options to customize products with an attribute template from the site editor, which sounds really cool. And then they improved the performance of product blocks by removing some fragments that were in there. And then they also cleared out some validation errors that were visible. A nice quality of life enhancement is that the placeholder for blocks who has placeholders&#8230; so the cover block, the image block, the gallery block, they all have placeholders that they take on the main store color coming from the theme JSON file. That&#8217;s kind of really nice. It&#8217;s, of course, an experimentation, but that is certainly something that any theme developer might want to look at how they implement that.</p>\n\n\n\n<p><em>Ryan Welcher:</em> Yeah, that&#8217;s really neat. I&#8217;d love to take a look and see. I&#8217;ve always been intrigued because I do a lot of block development, especially on my streams, and I&#8217;m always intrigued by how much can I interface? If I had a block that just didn&#8217;t matter where it was installed, if it could take on certain aspects of theme.JSON, I think that would be super neat. I mean I think some of that stuff just trickles down by default, but I&#8217;d be interested to take a deeper look at that.</p>\n\n\n\n<p><em>Birgit Pauli-Haack</em>: Yeah. In Gutenberg, there was also a feature where you can access the theme JSON through some hooks and filters in 6.1, but I&#8217;m not sure how robust that is.</p>\n\n\n\n<p><em>Ryan Welcher</em>: You can filter it as and add new things to it, but I&#8217;d be interested to see how it works. And I just haven&#8217;t put in the research so I don&#8217;t know. But I mean I&#8217;d be interested to see if there&#8217;s a data store on the JavaScript side where we could retrieve that stuff because you can get Block Editor information. I just have to do the research.</p>\n\n\n\n<p><em>Birgit Pauli-Haack</em>: That will be for the, what did you say? The next couple of Twitch streams are still Query Block and then the third one from now.</p>\n\n\n\n<p><em>Ryan Welcher</em>: Yeah. It&#8217;s a great idea integrating&#8230; thinking about JSON into your blocks, using values from there to do things in a block, that&#8217;d be fun.</p>\n\n\n\n<p><em>Birgit Pauli-Haack</em>: Yeah. I think that makes whatever block in you have kind of very versatile and kind of migrates from theme to theme. But I also think that you probably need some standards as the naming convention on how you kind of primary, secondary, tertiary kind of colors. So I think as long as we don&#8217;t have them, it can be hit and miss. Yeah.&nbsp;</p>\n\n\n\n<p><em>Ryan Welcher</em>: Yeah. I mean as soon as it&#8217;s up to somebody naming something, that&#8217;s like what? The second hardest thing to do in computer and software development is naming things.</p>\n\n\n\n<p><em>Birgit Pauli-Haack</em>: What&#8217;s the hardest thing?</p>\n\n\n\n<p><em>Ryan Welcher</em>: Recursion I think.</p>\n\n\n\n<p><em>Birgit Pauli-Haack</em>: Okay.</p>\n\n\n\n<p><em>Ryan Welcher</em>: I can&#8217;t remember who said that. Somebody smarter than me anyway.</p>\n\n\n\n<p><em>Birgit Pauli-Haack</em>: Yeah. And, yeah, Gutenberg 4.5 was released on November 9th and we have a few enhancements there. It was not a very heavy release because everybody still came off of the November 1st 6.1 release and I&#8217;m still moving some stuff around.&nbsp;</p>\n\n\n\n<h3><strong>Enhancements</strong></h3>\n\n\n\n<p>There were some enhancement for Create Block for instance and I&#8217;m sure&#8230; you were, I think, involved in that to update to use the APIs. Yeah.</p>\n\n\n\n<p><em>Ryan Welcher</em>: Yep. So the Create Block package is near and dear to my heart. And this one actually allowed us to create&#8230; so backing up, when you use the Create Block package, you can also create external templates. And so those templates will define how your plugin is structured and how your block is structured. And part of that templating system, there&#8217;s a series of default values that you can pass. And so what this commit did was it allowed you to use the Render property because in 6.1, the block API introduced Render as a block.JSON property where you can pass the path to a file and that file will be used for dynamic blocks. It&#8217;s a PHP file.</p>\n\n\n\n<p>And so what that did, that allows you to do away with having to call Render call back and defining a function when you&#8217;re registering a block. So it&#8217;s made block registration a lot easier, but we needed to update the Create Block package to be able to work with that system. As a template author, you can define what the name of that file is, where it lives and all those sort of things. So that&#8217;s what that did. That&#8217;s a long way of explaining it. Just caught one thing up to the other thing.</p>\n\n\n\n<p><em>Birgit Pauli-Haack</em>: Yeah, it was cool. That&#8217;s cool. Thank you so much. And we all need kind of a little bit more explanation about these things that are just one headline from&#8230; that&#8217;s what we are doing here at the podcast. So in the Style Engine, that&#8217;s kind of the engine that&#8217;s behind&#8230; that&#8217;s the black box behind the theme JSON file that kind of tries to manage all the user inputs, the block JSON attributes, the styles from the theme and the default style from the Block Editor. And nowadays, support the dimensions minimum height property. So you could have, for all kind of blocks, but it&#8217;s now available. And that&#8217;s really cool because then you can say, &#8220;Okay, my Core Block or my cover block has a certain minimum height to fill up and can also inherit that to the other blocks that are there.&#8221; Yeah. So it&#8217;s all cool.</p>\n\n\n\n<p>Yeah. And then the comment template, post comment count, post comment form and post common links, they all got now also spacing support. So for your site editor and template. So you can actually&#8230; then here you can remove the spacer block and control it all with the blocks there. For another social icon, they got a new attribute and that&#8217;s the rel attribute, R-E-L, which is needed for something that&#8217;s happened on the rest outside of the WordPress universe, which is that Twitter had some implosion things coming on.</p>\n\n\n\n<p><em>Ryan Welcher</em>: Yeah, some stuff happened over there.</p>\n\n\n\n<p><em>Birgit Pauli-Haack</em>: Some stuff happened there. I don&#8217;t want to really belabor that, but if you want to&#8230; so the social link block now has a Mastodon block variation, but the Mastodon variation also lets you verify your website with your Mastodon account. So you can say or can prove, &#8220;Okay, I am the person who belongs to this website.&#8221; And it then gives you a check mark in the Mastodon profile. And George Hotelling, he&#8217;s a WordPress co con&#8230; what is it? A core contributor.</p>\n\n\n\n<p><em>Ryan Welcher:</em> That&#8217;s it.</p>\n\n\n\n<p><em>Birgit Pauli-Haack</em>: And he wrote a short tutorial on how to do this and verify your WordPress site with Mastodon. So if you have the need or wish or just want to check it out on Mastodon as a replacement for Twitter, a lot of people have registered Mastodon accounts since Elon Musk took over Twitter. And I think they are now on 2 million within a week, new accounts. So there&#8217;s definitely a wave there. And you can&#8217;t leave Twitter until you tell your followers where you will be. So it&#8217;s definitely a good way to at least get a Mastodon account and get it verified.</p>\n\n\n\n<p><em>Ryan Welcher</em>: I have to get a Mastodon account. Do you have one, Birgit? Do you have a Mastodon account?</p>\n\n\n\n<p><em>Birgit Pauli-Haack</em>: I have two, yes.</p>\n\n\n\n<p><em>Ryan Welcher</em>: You have two? Wow.</p>\n\n\n\n<p><em>Birgit Pauli-Haack</em>: I have one on-</p>\n\n\n\n<p><em>Ryan Welcher</em>: I&#8217;m always playing catch up with you. You&#8217;re so bleeding edge.&nbsp;</p>\n\n\n\n<p><em>Birgit Pauli-Haack</em>: Totally, totally.</p>\n\n\n\n<p><em>Ryan Welcher</em>: These new technology, not only do you have an account, you have two accounts and you&#8217;re the lead community contributor.</p>\n\n\n\n<p><em>Birgit Pauli-Haack</em>: Well, I looked at the Mastodon account and then my browser kind of said, &#8220;Oh, you have an account? Here&#8217;s your password.&#8221; I said, &#8220;Oh?&#8221; And then I looked at it-</p>\n\n\n\n<p><em>Ryan Welcher</em>: You&#8217;re an early adopter. Well before the Twitter nonsense.</p>\n\n\n\n<p><em>Birgit Pauli-Haack</em>: I looked at it and it was from 2017 and had not a single post and three followers.</p>\n\n\n\n<p><em>Ryan Welcher:</em> All right.</p>\n\n\n\n<p><em>Birgit Pauli-Haack</em>: So I pinned on my new account on my profile. So if you want to follow me or you have left Twitter and you want to kind of look at it and you want to connect with me again, do that. I also pinned my Tumblr account, which I set up in 2008 I guess.</p>\n\n\n\n<p><em>Ryan Welcher</em>: Yeah. I actually have a Tumblr account that I think I set up back when I was doing Flash development. That&#8217;s how long ago it was. So I need to get that updated.</p>\n\n\n\n<p><em>Birgit Pauli-Haack</em>: Yeah. Yeah. Okay. So now we got that out of the way. The second account that I have was the Gutenberg Times of course. Yeah. It&#8217;s a separate account. So if you don&#8217;t want the other things that I post on Twitter or on Mastodon, yeah. And WordPress only then the Gutenberg Times account on TWiT Social actually. TWiT is a long time podcast and live show technology podcast by Leo Laporte. And I have been following this week in Google Show, that&#8217;s the since, I don&#8217;t know, 10 years ago. And they have a Mastodon instance on their server. I like the name of it. It&#8217;s not Twitter but it&#8217;s TWiT. It&#8217;s not social. So I like that. And they also have an instance that is a little bit more moderated so it&#8217;s not anybody could come because they want to kind of keep the community tech oriented. So I think that&#8217;s a good place to be. But you can follow from any other Mastodon instance on the Gutenberg Times Stream there.</p>\n\n\n\n<p><em>Ryan Welcher</em>: Awesome.</p>\n\n\n\n<p><em>Birgit Pauli-Haack</em>: What else is in there?</p>\n\n\n\n<p><em>Ryan Welcher</em>: I think we were on post editor. Yeah.</p>\n\n\n\n<p><em>Birgit Pauli-Haack</em>: I highlighted that, a little piece there, is just to reiterate that there is a distraction free mode in Gutenberg plugin now that kind of hides all the interface items when you write or at all. So the toolbar on top, the side settings, but also the block toolbar that comes up or any other things that sometimes spring up and distract you from &#8216;what does it now&#8217; want kind of thing. And now also the notices are now improved that come up on the edit post screen. For instance, the saving part and the transform part when you transform things and all that. That&#8217;s nicely improved.</p>\n\n\n\n<p><em>Ryan Welcher</em>: Yeah, it looks really nice on the screenshot that they have there.</p>\n\n\n\n<p><em>Birgit Pauli-Haack</em>: Yeah.&nbsp;</p>\n\n\n\n<p><em>Ryan Welcher:</em> The next one there is…</p>\n\n\n\n<p><em>Birgit Pauli-Haack</em>: Go ahead.</p>\n\n\n\n<p><em>Ryan Welcher</em>: So moving the document information into the outline deal, which is interesting to me. So if you want to know the word count and all that, you normally go up into the&#8230; there&#8217;s one of the buttons, I can&#8217;t remember what it was, what it looks like.</p>\n\n\n\n<p>Yeah. It&#8217;s a little I or the info one. But now it&#8217;s been moved down to the bottom of the list view, which I don&#8217;t necessarily hate. This is the first I&#8217;ve seen this one, but I wonder is that an option or is that only in specific instances or is it always going to be there?</p>\n\n\n\n<p><em>Birgit Pauli-Haack</em>: That&#8217;s always right now. I think the last word hasn&#8217;t been spoken yet about that. It definitely needs some additional accessibility review and improvements and it also is missing some information. So I think the time to read comes up if your post is longer than a minute, then you get the time to read. And the number of blocks is, I think, mission. But you also get the outline as well. And that&#8217;s a little bit of a duplication between&#8230; so the outline is just the headers that are in your document and in the list view, you also see all the blocks that are in there. So it&#8217;s kind of a reduced&#8230; I like that the information is now just in one panel and it declutters the top toolbar because I&#8217;m sure we&#8217;re going to get additional information there.</p>\n\n\n\n<p><em>Ryan Welcher</em>: Almost guaranteed.</p>\n\n\n\n<p><em>Birgit Pauli-Haack</em>: Yeah. And I know that some plugins you signed as well. Yeah.</p>\n\n\n\n<p><em>Ryan Welcher:</em> Yeah. I would love to see this leverage the preferences. The preferences so a user can decide where they want that because that could be something that you&#8230; I can see use cases on both sides of it. I don&#8217;t care about it, I&#8217;m in distraction-free mode whatever. Or I just wanted to be able to be nice and quick because I have a word count that I&#8217;m trying to hit or something. So I can see that. I can see people loving this and handling this as with always the case with anytime we change anything. But I think it&#8217;s cool. It&#8217;s nice.</p>\n\n\n\n<p><em>Birgit Pauli-Haack</em>: Yeah. And I definitely wanted to mention it here because I heard from quite a few people that thought, &#8220;Oh, it&#8217;s missing now, what did I do?&#8221; Kind of thing. It&#8217;s actually hidden and there is no notification that, &#8220;Look here if you&#8217;re looking for that&#8221; kind of thing.</p>\n\n\n\n<p><em>Ryan Welcher</em>: Yeah, they used to do that a lot.</p>\n\n\n\n<p>Birgit Pauli-Haack: And they haven&#8217;t done yet for this one.&nbsp;</p>\n\n\n\n<p><em>Ryan Welcher:</em> They used to have those little blue arrows. Do you remember that pre-Gutenberg days when something would move and all of a sudden there&#8217;d be a little blue arrow that says, &#8220;Hey, this thing&#8217;s over here now&#8221;? Yeah, it&#8217;d be cool if they did that again.</p>\n\n\n\n<p><em>Birgit Pauli-Haack</em>: Yeah. Do they have that feature or kind of the API for that in Gutenberg? I think that will be a good API to have.</p>\n\n\n\n<p><em>Ryan Welcher</em>: They have the modal that pops up the first time that you go into the Block Editor. That might be something to leverage when there&#8217;s an update that gets triggered again with like, &#8220;Hey, do you want to see what&#8217;s new?&#8221; And then everyone will hate it and turn it off. But it might be an interesting thing to leverage to kind of save people from trying to figure out where the heck something went or them feeling like they broke something and&#8230; anyways.</p>\n\n\n\n<p><em>Birgit Pauli-Haack</em>: No, I totally agree. I totally agree. There are quite a few apps that do this quite well that they have a little notification bell somewhere and they just change the color of it and you know there&#8217;s something new. So when you have time to browse that, yeah, you&#8217;re going to go there.</p>\n\n\n\n<p><em>Ryan Welcher</em>: Yeah. Especially something where you&#8217;re using-</p>\n\n\n\n<p><em>Birgit Pauli-Haack</em>: Does Twitch have that?</p>\n\n\n\n<p><em>Ryan Welcher</em>: Yeah, it does. And a lot of desktop apps will do that and stuff like that. So I think it&#8217;s a nice consideration for a user to be able to say, &#8220;Oh, hey. Something&#8217;s changed and you can opt into it.&#8221; So maybe just having it popped up is not the best way to doing it, but having some notification that shows up that says there&#8217;s been some changes to the UI, would you like to see what they are? I think that&#8217;d be kind of neat.</p>\n\n\n\n<p><em>Birgit Pauli-Haack:</em> And with all those changes coming…</p>\n\n\n\n<p><em>Ryan Welcher</em>: So you talk to your people about that and I&#8217;ll talk to my people about that. We&#8217;ll see what happens. Yeah.</p>\n\n\n\n<p><em>Birgit Pauli-Haack</em>: Yeah.</p>\n\n\n\n<p><em>Ryan Welcher</em>: Anyhow, what&#8217;s the next thing?</p>\n\n\n\n<p><em>Birgit Pauli-Haack</em>: What&#8217;s the next thing? Yeah, I&#8217;m kind of browsing past the bug fixes and I saw a headline that&#8217;s called Meta Boxes. And I was looking at that and the PR is that perform has Meta Boxes check on every safe which I really appreciate now because there have been very much quite some instances where I changed something in a Meta Box but I didn&#8217;t hit save. And then I went out there and that thing was also not updated, although all the Block Editor edits were updated. So it now does that in every auto save as well so you&#8217;re not losing any data from your Meta Boxes. Yeah.</p>\n\n\n\n<p><em>Ryan Welcher:</em> Now when you say Meta Boxes, are you saying&#8230; the first thing that comes to mind is register Meta Box in the original way that you&#8217;d do that. Is that what you&#8217;re talking about or just-</p>\n\n\n\n<p><em>Birgit Pauli-Haack</em>: Yeah. So the Meta Boxes on the bottom of a screen in the Block Editor like Yoast has them and newsletter…</p>\n\n\n\n<p><em>Ryan Welcher</em>: Stuff like that. Yeah.</p>\n\n\n\n<p><em>Birgit Pauli-Haack</em>: Yeah. And those boxes were not always saved unless you physically saved it. So the auto save would not catch up.</p>\n\n\n\n<p><em>Ryan Welcher</em>: Oh, that&#8217;s great. That&#8217;s so nice because that is horribly annoying when you&#8217;ve been messing around with stuff and then you navigate away, that doesn&#8217;t trigger the &#8216;are you sure&#8217;? And then you&#8217;ve lost your work. That&#8217;s nice. That&#8217;s really nice.</p>\n\n\n\n<p><em>Birgit Pauli-Haack:</em> Especially when you&#8217;re so accustomed to the every 15 seconds auto save kicks in and you don&#8217;t have to worry about it. All of a sudden you have to worry again. Yeah, it&#8217;s a little bit counterintuitive.</p>\n\n\n\n<h3><strong>Documentation</strong></h3>\n\n\n\n<p>And then we come to the documentation section and there was one thing, that was the Storyboard intro. And the Storybook, not Storyboard, Storybook. Storybook is a tool that allows you to see each WordPress component from the Block Editor in isolation. And you see what values are in there, what action you can have there and you can kind of make some changes and then see how that happens. And this Storybook site didn&#8217;t have an intro page. You landed there and it says hello world. And so a few of us got together and updated it so you can learn more about it and also how to…</p>\n\n\n\n<p><em>Ryan Welcher:</em> Take the credit, Birgit. This was all you. You did this and some people helped. So props to you. It&#8217;s quite literally the definition of devral is making this easier to understand. I remember when I started first playing around with this Storybook instance, specifically I was like, &#8220;Why is it just say hello world?&#8221; And then it would fall off my radar. Yeah. So thank you. From the community, officially thanking you for doing this and making it better. So that&#8217;s great.</p>\n\n\n\n<p><em>Birgit Pauli-Haack</em>: Thank you.</p>\n\n\n\n<p><em>Ryan Welcher</em>: I actually used this tool today. It&#8217;s so helpful not only for reference guides, but, for example, WordPress icons. Way down the bottom of that list on the left hand side, you can see all of the available icons. And so I was working on that plugin today and I used it and it&#8217;s a handy dandy little tool to show you what&#8217;s available and you can see it in real time and see the different states of things. It&#8217;s very cool.</p>\n\n\n\n<p><em>Birgit Pauli-Haack:</em> Yeah. No, I think it improves development. Not only improves it but also speeds it up because you can go there and say, &#8220;So what is that component?&#8221; You can grab the example code and put it in your component and see how the first version looks. And so it&#8217;s really good. We&#8217;ll share the tool in the show notes of course so you can check it out yourself and see if you want to use it for your development.</p>\n\n\n\n<p>And the other documentation issue that I wanted to highlight was that the curating the editor experience is a page in the Block Editor handbook. And that was updated with the content lock ability or the content only lock ability. So it&#8217;s a WordPress 6.1 new feature and I also link to the developer notes in the show notes. But it practically lets you lock down a pattern for instance. Just that the user only can change the content of the headline, but not the headline itself, the content of the paragraph or just upload a new image. But a block pattern itself stays as it is. So I think that is pretty far reaching because a lot of people build custom blocks because they wanted to lock down content and not have people or users kind of change things. And there is actually no need for that if you now with the content only blocks or patterns because now you just use a normal Core Blocks, a collection of Core Blocks and lock down the changing and only open up the content for that.</p>\n\n\n\n<p><em>Ryan Welcher:</em> Yeah, I think it&#8217;s super powerful. I know coming from the agency world, that was one thing that being able to stop people from creating every iteration of button color on the planet because you have to design for that and you have to count for that and stuff. So being able to just manage the content of something and leave everything else alone, I think, is going to help a lot of people. And this, sorry, explains it a little bit better.</p>\n\n\n\n<p><em>Birgit Pauli-Haack</em>: And, again, it speeds up building websites considerably if you don&#8217;t have to have a developer create your custom block to have that feature there. So really good.</p>\n\n\n\n<p><em>Ryan Welcher:</em> Sure.</p>\n\n\n\n<p><em>Birgit Pauli-Haack</em>: Yeah. So that was the Gutenberg 14.5. And without any further ado, we go to Gutenberg 14.6 that came out this week.&nbsp;</p>\n\n\n\n<h3><strong>Gutenberg 14.6</strong></h3>\n\n\n\n<p>Oh we didn&#8217;t say 14.9, the release lead was Nick Diego and he also posted the release document. Gutenberg 14.6, Fabian Kagey, was the release lead and that was came out two days ago on Wednesday. And so, yeah, there are quite a few enhancements. Again, it&#8217;s a much richer plugin release than 14.5 was. And we have a few things that we wanted to point out. The first one is in the block library. So the navigation block is in major revamp just because you need more space to manage your menu.</p>\n\n\n\n<p>And in 14.6, you now find that the navigation block has an added list view in the side bar and you can have more space to actually create your menu, select the menus, add a new link to a menu instead of doing it all in the small little space that you had next to the insert on the navigation block. So that&#8217;s definitely something to check out. And then also the navigation link. It now has a URL feed to the inspector control. So the inspector controls itself, you get a URL, you get names and all that additional features for your links and that is definitely useful. What else is in there?</p>\n\n\n\n<p><em>Ryan Welcher</em>: Make author block, select or display all users instead of just 10. I just looked at that. It&#8217;s not all users, it&#8217;s a hundred users. If you have more than 100 users on your site, you&#8217;re kind of a special use case anyways I would imagine. So that should encompass the majority of users, but that&#8217;s pretty nice. Yeah. I&#8217;m not sure the column address.</p>\n\n\n\n<p><em>Birgit Pauli-Haack</em>: Yeah, the columns block now has a transform that kind of unwraps the content. Meaning if you get it out of the columns into a normal&#8230; so if you have a head and image in a paragraph in a column and you look at unwrap the content, it comes out of the column and-</p>\n\n\n\n<p><em>Ryan Welcher</em>: Oh, that&#8217;s super handy. That&#8217;s super handy.</p>\n\n\n\n<p><em>Birgit Pauli-Haack</em>: Okay. I can&#8217;t figure out where I put this, but now I can kind of get it out of it.</p>\n\n\n\n<p><em>Ryan Welcher</em>: And, I mean, try to drag it out of columns and figure that all out. Just one button doesn&#8217;t make that way easier.</p>\n\n\n\n<p><em>Birgit Pauli-Haack</em>: Yeah. Yeah. Otherwise, you would have to drag and drop, for instance, three blocks instead of having a one button connection there. Yeah, yeah. You got it right. Yeah.</p>\n\n\n\n<p><em>Ryan Welcher</em>: That&#8217;s neat. Oh, and the next one, so the group block now has a variation picker in the placeholder. Which looks really, again, helpful being able to just choose the thing you want, the variation, in there, which is really handy.</p>\n\n\n\n<p><em>Birgit Pauli-Haack</em>: Yeah. And I like it that this surface the row and the stack variation right when you select the group block not only when you have it already on your canvas and then on the right hand side, you need to figure out the layouts of that. So, yeah, I really like that. Yeah.</p>\n\n\n\n<p><em>Ryan Welcher</em>: I think that that&#8217;s a quality of life thing right there. So you don&#8217;t have to insert the block and then get to the block and then go over to the right like what you&#8217;re saying. Just make this nice and easy. You want a row, you get a row. Two clicks, you&#8217;re done.</p>\n\n\n\n<p><em>Birgit Pauli-Haack</em>: Right. Yeah.</p>\n\n\n\n<p><em>Ryan Welcher:</em> Yeah. So the next one is under components, update the design of the focal point handle. What does that one look like? I think that&#8217;s&#8230; well, that&#8217;s nice. No, that&#8217;s nice. It&#8217;s like a little white circle with a little bit of opacity so you can see the stuff behind it. That&#8217;s super nice. I quite like that.</p>\n\n\n\n<p><em>Birgit Pauli-Haack</em>: Yeah.</p>\n\n\n\n<p><em>Ryan Welcher</em>: I love that people are actually taking the time and looking at these little&#8230; in a grand scheme WordPress, this is a tiny detail, but it just makes it that much nicer. It&#8217;s that little drop shadow, you can kind of see the image through it. I don&#8217;t know, that kind of stuff I&#8217;m always amazed because I don&#8217;t&#8230; I&#8217;m not a designer so I don&#8217;t look at things like that. If it was me, it&#8217;d be a big block, bright blue in there and it would look horrible but it would do the job. So it&#8217;s nice there&#8217;s this level of refinement happening to these existing tools.</p>\n\n\n\n<p><em>Birgit Pauli-Haack:</em> Yeah. A good job on the designers and they really figure out all the alignment like when they redesigned the whole setting section or the style section on a block where you have two things in one row, they&#8217;re all line up nicely. That was in a second iteration but they now have a standard how to do that. So it&#8217;s really good. And the next one is the same qua&#8230; it&#8217;s also a quality of life thing, but it also speeds up your writing. You can convert paragraphs to headings with a keyboard shortcut and the keyboard shortcut…</p>\n\n\n\n<p><em>Ryan Welcher</em>: Ctrl+Alt.</p>\n\n\n\n<p><em>Birgit Pauli-Haack</em>: Ctrl+Alt and then the number for the heading. So for H2, it&#8217;s Ctrl+Alt 2 and for three is&#8230; H3 is Ctrl+Alt.</p>\n\n\n\n<p><em>Ryan Welcher</em>: Yeah. If you&#8217;re on a Mac, I guess there&#8217;s options. So Ctrl+Options one to six.</p>\n\n\n\n<p><em>Birgit Pauli-Haack</em>: Ctrl+Options, yes. Yeah, yeah.</p>\n\n\n\n<p><em>Ryan Welcher</em>: Which is nice because I just learned that you can do that in Google Docs. So that&#8217;s a nice carryover here.</p>\n\n\n\n<p><em>Birgit Pauli-Haack</em>: Yeah, yeah. And I wish Google would carry over the paste.</p>\n\n\n\n<p><em>Ryan Welcher</em>: The link? Were you going to say the link?</p>\n\n\n\n<p><em>Birgit Pauli-Haack</em>: Link. Yeah.</p>\n\n\n\n<p><em>Ryan Welcher:</em> Yes. Why does Google Docs not have that?</p>\n\n\n\n<p><em>Birgit Pauli-Haack</em>: It trips me up every time. Every time I have a link on a Google, it kind of trips me up.</p>\n\n\n\n<p><em>Ryan Welcher</em>: Yeah, I know. And I just end up pasting over top of the text that I just wrote because I want put a link on it. Hey, Google. Hey, Google, if you&#8217;re listening. I&#8217;m going to trigger everyone&#8217;s Google Home now by saying that.</p>\n\n\n\n<p><em>Birgit Pauli-Haack</em>: Mine is downstairs so no problem with that.</p>\n\n\n\n<p><em>Ryan Welcher</em>: Yeah. Oh, mine just triggered. I have one in the garage here and it just triggered. It just said, &#8220;I can&#8217;t hear what you&#8217;re saying.&#8221; Anyways.</p>\n\n\n\n<p><em>Birgit Pauli-Haack</em>: Well, ours, when it kind of gets triggered from something on the TV, it responds back in German. It&#8217;s so funny.</p>\n\n\n\n<p><em>Ryan Welcher</em>: Oh, wow. Okay. Yeah. That&#8217;s funny.</p>\n\n\n\n<p><em>Birgit Pauli-Haack</em>: Yeah, the home devices. Yeah. Okay. And the next one is really the following, the change in vocabulary. We don&#8217;t say full site editor anymore, we do just site editor. And that, of course, needs to come through the whole interface and some other documentation. I think we will follow it quite a bit, but sooner or later we will all be there.</p>\n\n\n\n<p><em>Ryan Welcher:</em> Yeah. It&#8217;s the same thing as trying not to call the Block Editor Site Editor Gutenberg, because Gutenberg&#8217;s the name&#8230; it&#8217;s the codename of the project, right? I know I&#8217;m very guilty of it just using it as a catchall tool. So I think this is just a matter of leading by example and having people, maybe not correcting everyone, but just kind of using it.</p>\n\n\n\n<p><em>Birgit Pauli-Haack:</em> Yeah. Yeah. Exactly. Oh, we talked about the minimum height on the dimensions already, I think.</p>\n\n\n\n<p><em>Ryan Welcher</em>: I think we did. Yeah.</p>\n\n\n\n<p><em>Birgit Pauli-Haack</em>: Yeah. But there&#8217;s also another design tool change or update. So on the right hand side, do you have the dimension controls and the spacing for padding and margin controls? And you notice when you go and change it in the step scale that it has a little visualizer around the block that you are editing in blue. And now that process also will hide the toolbar. So you really can concentrate on that block that you&#8217;re trying to place pixel perfect into your canvas. So I really like the spacing visualizer because I can never figure out is margin new outside or inside or is that padding outside on inside? So the visualizer really helps you with that.</p>\n\n\n\n<p><em>Ryan Welcher:</em> That is really nice. Yeah. On the global styles, they have some elements of adding a tech text decoration control to link elements. That&#8217;s nice. Being able to manage that. Very cool. Blue typography, adjust font size, min and max rules. That&#8217;s great. These are all interface items. They&#8217;re all being added to-</p>\n\n\n\n<p><em>Birgit Pauli-Haack</em>: The theme JSON items.</p>\n\n\n\n<p><em>Ryan Welcher:</em> Yeah. But are they adding controls for them as well like the one for the text link?</p>\n\n\n\n<p><em>Birgit Pauli-Haack</em>: Well, the text … Yeah.</p>\n\n\n\n<p><em>Ryan Welcher</em>: Yeah. And I think some of these are sort of&#8230; the other one we were talking about, the min height I believe that was more about&#8230; the first thing we talked about was allowing it to work and the second one was giving a sort of a control and some tooling around that.</p>\n\n\n\n<p><em>Birgit Pauli-Haack</em>: And for fluid typography, I think they have started working on the interface or the user controls for it. But they&#8217;re right now only available through the theme JSON and they added minimum and maximum rules for the fun size. So you can actually change those, which was missing in 6.1 when the fluid topography came in the first time. And there is another global&#8230; so it&#8217;s also an attempt to see if you can generate random color palettes.</p>\n\n\n\n<p><em>Ryan Welcher</em>: Pretty neat.</p>\n\n\n\n<p><em>Birgit Pauli-Haack</em>: It&#8217;s pretty neat for those that are having a hard time with the design that you can give a color and then it gives you additional colors that match that or kind of go well with it.</p>\n\n\n\n<p><em>Ryan Welcher:</em> That&#8217;s super neat.</p>\n\n\n\n<p><em>Birgit Pauli-Haack:</em> Yeah. You don&#8217;t have to think about all the colors that you wanted to use. It&#8217;s really neat.</p>\n\n\n\n<p><em>Ryan Welcher</em>: Yeah, that&#8217;s really neat. I can just hear the agency folks going, &#8220;No.&#8221; But, yeah, being able to generate&#8230; that&#8217;s so neat. For someone like me who&#8217;s not a designer, who&#8217;s colorblind, being able to pick one color I like and then having sort of other complimentary colors generated for me, I think that&#8217;s really cool. It&#8217;s a really cool idea. Hopefully you can disable that for certain individuals or certain use cases I should say.</p>\n\n\n\n<p><em>Birgit Pauli-Haack</em>: I hope so too. It&#8217;s actually in the style variations. Those, you can shut down quite a bit. I&#8217;m just going through the PR and looking for &#8216;to disable this, do this&#8217; but I haven&#8217;t found it yet, but I&#8217;m also just scrolling through some of them. But those, okay, disable things will never be in the first iteration of a feature because you need to be pretty firm on how a feature works before you can say, &#8220;Okay, and now we disable it.&#8221; But given the history of whatever happened before, I think there&#8217;s a good chance that that will be added. Yeah.</p>\n\n\n\n<p><em>Ryan Welcher</em>: Definitely. So some bug fixes there. Play board is in both front end and editor. Well, that seems like a good thing to do.</p>\n\n\n\n<p><em>Birgit Pauli-Haack</em>: Yeah, that bug has been fixed.</p>\n\n\n\n<p><em>Ryan Welcher</em>: That&#8217;s great.</p>\n\n\n\n<p><em>Birgit Pauli-Haack</em>: Yeah. And other than that, I&#8230; or the Block Editor. So the list view has been updated to disable the branch expansion when a block editing is locked. So if you are not allowed to edit it or if you&#8217;re not allowed to move it or remove it and you can only edit the content, then it will not expand in the list view either.</p>\n\n\n\n<p><em>Ryan Welcher</em>: Right. So an example would be you&#8217;ve got a group block that you&#8217;ve locked and so you can&#8217;t see any of the nested blocks in there. You can&#8217;t expand that tree to see that. I think that&#8217;s really smart. I think that&#8217;s really smart because there&#8217;s a way of getting around locking and why clutter up the list view if you can&#8217;t&#8230; if you&#8217;ve got 100 blocks in there, it&#8217;s a very complicated pattern. You&#8217;ve inserted it, but why mess up the list view with stuff you can&#8217;t even edit in the first place? That&#8217;s my opinion.</p>\n\n\n\n<p><em>Birgit Pauli-Haack:</em> Yeah, yeah. Then we have some experiments. We didn&#8217;t have a whole lot of experiments for a long time, but at the beginning of the Gutenberg development, there were a few experiments where developers wanted to just see how things work. And we are back to that. The navigation list view is actually an experiment. And then also inspector based navigation editing is also an experiment. So when you install the Gutenberg plugin, you need to go down to the menu where it says Gutenberg and then go to the experiments settings page and then enable those so you can test them. Yeah. What else?</p>\n\n\n\n<p><em>Ryan Welcher</em>: You want to move on the documentation?</p>\n\n\n\n<p><em>Birgit Pauli-Haack:</em> Yep.</p>\n\n\n\n<h3><strong>Documentation</strong></h3>\n\n\n\n<p><em>Ryan Welcher:</em> Yeah, a lot of nice little documentation changes, changing titles around working with JavaScript in Gutenberg as opposed to just being&#8230; oh, and this is another Birgit thing here. So it&#8217;s not about getting started with JavaScript, it&#8217;s about how to use JavaScript in Gutenberg. It&#8217;s a fundamental difference because the assumption is that you do know how to use some JavaScript when coming to working with the Block Editor and Gutenberg Project and stuff like that. So I think it was a misnomer. So nice job.</p>\n\n\n\n<p><em>Birgit Pauli-Haack</em>: Well, thank you.</p>\n\n\n\n<p>Yeah, there were quite a few posts in the community there where the PHP developer kind of started to figure out how that works with block development and all. And I saw if not twice, but three times that people didn&#8217;t get to that handbook section because of the title. It says How to Use JavaScript instead of &#8216;How to Use JavaScript With Gutenberg&#8217; or with WordPress is actually the title now. WordPress Block Editor. Of course they&#8217;re not saying Gutenberg, but I think that helps people who kind of read through the handbook to get to those pages much earlier in their discovery and also save them some headaches on their way to discover that. Yeah.</p>\n\n\n\n<p><em>Ryan Welcher</em>: Yeah. I mean it&#8217;s much more discoverable now and I think that&#8217;s great. That&#8217;s wonderful.</p>\n\n\n\n<p><em>Birgit Pauli-Haack:</em> And are you reorganized to create block documentation?</p>\n\n\n\n<p><em>Ryan Welcher</em>: Yeah, yeah, yeah. We added another subsection. One of the things in the handbook is we have that massive left hand navigation that has accordions in it. And so for some of these packages, they can get quite lengthy those sections. So a while back, we worked on having the DocGen tool&#8230; so the DocGen tool is what generates the docs, but then get ingested into the Block Editor handbook from the Gutenberg repository. So we were working on ways of having sort of nested pages underneath those sort of subsections. And so that&#8217;s part of what one had done here. It&#8217;s great that it splits out to the available commands and kind of organizes that content a little bit better so it&#8217;s a little bit more palatable. Because, as we all know, the documentation in WordPress, there&#8217;s a zero to 100 thing. Here&#8217;s the basics and then here&#8217;s everything else you could ever need to know about it all on the same page. And that&#8217;s just hard to ingest and it&#8217;s hard to kind of parse through.</p>\n\n\n\n<p>So by doing this, and we&#8217;ll be doing this to some other packages as well, I have a pull request in place that I have to finish for the scripts package that does the same thing. That kind of breaks out some of the more complicated things, more advanced things into their own pages because for the majority of users, they don&#8217;t need that. They just need to know what commands are available, for example. So, yeah, that&#8217;s the motivation behind this.</p>\n\n\n\n<p><em>Birgit Pauli-Haack</em>: Yeah. I think it&#8217;s good kind of to go once in a while through documentation and do a little bit of an overhaul to update with the feedback from developers that have tried to insert information and say, &#8220;Okay. Well, it could be a little bit better.&#8221; So any improvement, you dear listeners, that you find or you couldn&#8217;t imagine, let us know on any places either WP Slack or a Twitter DM or on the Gutenberg Repo and we definitely are receptive to that and help out with making that happen.</p>\n\n\n\n<p><em>Ryan Welcher:</em> Absolutely. Many hands make light work.&nbsp;</p>\n\n\n\n<p><em>Birgit Pauli-Haack</em>: Many eyeballs, bugs are shallow. It&#8217;s the same with documentation. Yeah.</p>\n\n\n\n<p><em>Ryan Welcher</em>: Oh, okay. Yeah, totally.</p>\n\n\n\n<p><em>Birgit Pauli-Haack</em>: That&#8217;s great.</p>\n\n\n\n<p><em>Ryan Welcher:</em> Okay. So that&#8217;s all the documentation stuff we&#8217;re going to go through. And then what&#8217;s next? Code quality or patterns?</p>\n\n\n\n<p><em>Birgit Pauli-Haack</em>: No. I think we are done a certain&#8230; yeah. Well, there is a view call&#8230;&nbsp;</p>\n\n\n\n<p><em>Ryan Welcher</em>: There&#8217;s a few things bolded in the code quality ones, but I don&#8217;t know if that&#8217;s-</p>\n\n\n\n<p><em>Birgit Pauli-Haack</em>: I actually bolded them to do some more research on it, but I didn&#8217;t get to it.</p>\n\n\n\n<p><em>Ryan Welcher</em>: I mean most of these things like the color palette, color box, kind of border box polish and dry prop types add default values. This is just making it easier to use the rename to .TS is for type script I guess. Yeah. I don&#8217;t know if there&#8217;s anything you want to specifically call it.</p>\n\n\n\n<p><em>Birgit Pauli-Haack</em>: Yeah. No, I don&#8217;t think we&#8230; there&#8217;s one change in the pattern directory API that it now supports pagination parameters, but that&#8217;s for Gutenberg developers or for contributors that use type into the pattern directory.</p>\n\n\n\n<p><em>Ryan Welcher</em>: Oh, okay. Yeah.</p>\n\n\n\n<p><em>Birgit Pauli-Haack</em>: I don&#8217;t think it&#8217;s a public API. I wasn&#8217;t quite&#8230; oh, I think I was&#8230; yeah, I got the 401 kind of there not allowed, but I&#8217;m not quite sure.</p>\n\n\n\n<p><em>Ryan Welcher</em>: Yeah. It&#8217;s probably locked down. You probably have to be&#8230; well, no. Maybe. I don&#8217;t know. I have to look here. Anyways, it&#8217;s giving us pagination, which is great.</p>\n\n\n\n<p><em>Birgit Pauli-Haack</em>: Yeah. So if you wanted to have more than 30 blocks or something like that so … No, it&#8217;s a 404 not found. So it&#8217;s kind of-</p>\n\n\n\n<p><em>Ryan Welcher:</em> Okay. Yeah. So it&#8217;s locked down to somebody.</p>\n\n\n\n<h3><strong>What in Active Development or Discussed</strong></h3>\n\n\n\n<p><em>Birgit Pauli-Haack</em>: Yeah, it&#8217;s locked down. All right, so that was the Gutenberg 14.6 release and now we are coming into section with what active development and discussions. And there are quite a few things that I find really, really exciting for the next iteration and I hope they make it all&#8230; there are still open PRs so you can test it. There is a different way how to test open PRs, but you get some great videos that demonstrate the features. So the first one is the design concepts for the browse method. So now that there are so many things that you can do in the site editor, the design team came up with how can we unify some of the interfaces. Some things are on the left column, some things are in the right column and can we have not all together, what about design?</p>\n\n\n\n<p>And they have some nice ideas where the global styles will be taken out of the right hand side, put them on the left hand side, have a design sub menu for the site editor. Also have a template sub menu for the site editor, but it&#8217;s all in one place. It&#8217;s not kind of fragmented.</p>\n\n\n\n<p><em>Ryan Welcher</em>: Yeah. It&#8217;s really nice. I&#8217;m just kind of scrolling through some of the design items in the ticket there. It looks great. The transitions that they have going, I just think it&#8217;s going to be really nice.</p>\n\n\n\n<p><em>Birgit Pauli-Haack</em>: And there&#8217;s also a browse mode. So when you click on the templates or page template, you see all the page templates in thumbnails. But they&#8217;re relatively big depending on your screen, but you see how they kind of can change when you change the style variation as well. So there&#8217;s a lot more &#8216;what you see is what you get.&#8217; And also kind of keeping a broader view on your site, especially when you do a lot of customizations on your templates to make it a little bit more consistent. Also show you things that are not consistent. So I think that really helps with the customization for site owners and those who actually build themes through the interface to have a better view on how this all looks.</p>\n\n\n\n<p>So that&#8217;s one thing that I wanted to talk about. The other one is they&#8217;re working on a&#8230; and that&#8217;s more for the migration from classic themes to block themes that you can import widgets from the sidebar or that you&#8217;re using the sidebar that you can add them to block-based theme parts or template parts. And because the widget wasn&#8217;t available yet, there was a plugin available to add it to the site editor by Justin Tadlock called Classic Widgets. And this is the attempt to get it all into core, but that is definitely something to check out and see how that suits you. There&#8217;s not a whole lot of inter&#8230; yeah, there is a little video there on how to do that. So how it&#8217;s going to work, and I really like that.</p>\n\n\n\n<p><em>Ryan Welcher:</em> Yeah, this stuff&#8217;s so cool. It&#8217;s just amazing. I don&#8217;t know. That&#8217;s the stuff that they&#8217;re working on. I&#8217;m just like, &#8220;I don&#8217;t even know how to start that. I don&#8217;t even know how to build that.&#8221; But you all are doing a fantastic job doing all these cool things, so yeah. Glad I got out of development when I did because clearly I&#8217;m not qualified to do it anymore.</p>\n\n\n\n<p><em>Birgit Pauli-Haack</em>: Yeah. And that&#8217;s certainly something that&#8230; it&#8217;s for web developers that come from the &#8217;90s or early 2000s that kind of did all the database, the CSS, the HTML, the PHP, the JavaScript. I think it&#8217;s part of the times that you are not being expert in all of them as you were able to do in the early 2000s or mid 2000 or when WordPress came out with custom post types and you can do it all. Yeah.</p>\n\n\n\n<p>So, yeah, another thing that working on is actually managing the font sets for the global styles typography and how you can kind of make them available to more than one block or kind of have the settings. Okay, I want those&#8230; you cannot go to every block and change the font family. You need some more general places where you can just click on things and then that applies that particular font family to that series of blocks. So you can kind of get this a little bit better. But that is really hard. When I look at the interfaces and all the design interfaces, you get a good feeling how hard that actually is to make this palatable for non code users to put it in an interface that&#8217;s not crowded, that&#8217;s not give you a lot of cognitive overload.</p>\n\n\n\n<p><em>Ryan Welcher</em>: And isn&#8217;t developer jargon loaded. It&#8217;s hard to be able to communicate what a font face means or font weight. I know what that means as a developer, but if you&#8217;re not, then how do you explain how thick your letters are basically. It&#8217;s kind of how it is, right? Letter thickness. Maybe that&#8217;s how you do it. I don&#8217;t know. I&#8217;ll leave that to the professionals.</p>\n\n\n\n<p><em>Birgit Pauli-Haack</em>: Yeah. And I mean the other interfaces like the text editors or like the Google Docs that have some of it, but then there is such a granular control that a theme developer would need as well that it kind of can really overload the things. Yeah.</p>\n\n\n\n<p><em>Ryan Welcher</em>: For sure.</p>\n\n\n\n<p><em>Birgit Pauli-Haack</em>: And one feature I really like is that to make it possible that you push a local block style to the global styles. You say, &#8220;Oh, I like this block how it is and that post that I just wrote and I wish all my blocks, my paragraph blocks or my image blocks would look that way.&#8221; Now they&#8217;re working on it that you can push that to the global styles and then all of a sudden every&#8230;</p>\n\n\n\n<p><em>Ryan Welcher</em>: So like reusable blocks, but for styles kind of?</p>\n\n\n\n<p><em>Birgit Pauli-Haack</em>: For styles, yeah. Reuseable for styles kind of thing.</p>\n\n\n\n<p><em>Ryan Welcher:</em> Yeah. So anytime you insert a paragraph block, you&#8217;d have that style available to you even if it wasn&#8217;t defined as part of your theme. I think that&#8217;s super cool.</p>\n\n\n\n<p><em>Birgit Pauli-Haack</em>: Yeah, it&#8217;s super cool at the beginning when I think so. But if I think about, okay, how often do I change my mind? I said, &#8220;Oh, that could be really hard to kind of redo it.&#8221; Yeah, you want it on 15 blocks but not on 80 blocks kind of thing. Yeah.</p>\n\n\n\n<p><em>Ryan Welcher</em>: Yeah, yeah. That&#8217;s true. Maybe they&#8217;ll need an interface for editing those curated things where you edit the style and everything just gets automatically, but who knows? Who knows?</p>\n\n\n\n<p><em>Birgit Pauli-Haack</em>: Yeah.</p>\n\n\n\n<p><em>Ryan Welcher:</em> Sounds cool. Cool either way.</p>\n\n\n\n<p><em>Birgit Pauli-Haack</em>: You need to explore that and if you tested and use it and then all of a sudden you see what&#8217;s working and what&#8217;s not working. Yeah. Now the other two really exciting as well. Do you want to take the first one or?</p>\n\n\n\n<p><em>Ryan Welcher</em>: Is that the pre-published one?</p>\n\n\n\n<p><em>Birgit Pauli-Haack:</em> Mm-hmm.</p>\n\n\n\n<p><em>Ryan Welcher</em>: Yeah, so this one&#8217;s really cool. When you&#8217;re about to publish a post, if you have images that are external to the website. So if you imported a post from something and the URLs to your images are somewhere else, in the pre-published sidebar that says are you ready to publish, there&#8217;s a new panel being sort of suggested to be able to identify that you&#8217;ve got external images and give you the option to upload into your media library. I think that is such a handy thing. I know having done about a billion migrations that that&#8217;s a point of contention because it&#8217;s not easy to move those images programmatically. It can be done, but if you&#8217;ve imported stuff or copied and pasted and it&#8217;s there and you can just do it with a button, that&#8217;s so much simpler. I mean it&#8217;s not going to translate to doing 1000 posts all at once, but at least it&#8217;s such a nice feature. I think it&#8217;s so cool.</p>\n\n\n\n<p><em>Birgit Pauli-Haack</em>: Well, it&#8217;s only for that particular page, right?</p>\n\n\n\n<p><em>Ryan Welcher:</em> Yeah, yeah. Exactly. It&#8217;s not bulk uploading for the entire site, it&#8217;s for that specific page. Which I think is great. So cool.</p>\n\n\n\n<p><em>Birgit Pauli-Haack</em>: Yeah, I really like that. And there was always a restriction before. There was a button on each image block that said upload image, but that was kind of hit and miss as well. With Google Docs for instance, it worked, but it didn&#8217;t work with other WordPress sites or certain WordPress sites on certain servers. But Ella put some research on it and found how that can be consistently work better now with that tool as well. And there&#8217;s another PR open to copy that over to make that even better.</p>\n\n\n\n<p><em>Ryan Welcher:</em> Right. Yeah. I think it&#8217;s really nice. On the issue that I&#8217;m sure will be linked in the show notes, there&#8217;s a nice little graphical representation of what that looks like. It&#8217;s nice and slick and just seems super easy. Yeah. The next one is&#8230; this has been merged. It&#8217;s going to be the next version of Gutenberg I believe, but it&#8217;s an experimental feature that&#8217;s&#8230; so it&#8217;s an experiment on the experiment. In the sidebar, this is going to split block sidebar controls into tabs, which I think is super neat. So being able to define settings for a block and appearance or styles or whatever you want to call it in separate tabs. So that&#8217;s pretty exciting. As a block developer, I&#8217;m pretty excited about being able to do that because I know that that sidebar gets really&#8230; with really complicated blocks that are doing lots of things, that sidebar gets really tall. Really, really big and you have to have all your panels come in and they&#8217;re collapsed by default. But being able to split them out in into tabs will make that a much better experience I think.</p>\n\n\n\n<p>I&#8217;m not sure about the technical implementation right now, but I would imagine though instead of just wrapping everything in inspector controls, you might have inspector control settings and inspector control appearance or whatever you want to call it. So, yeah, that&#8217;s something that I&#8217;m excited about is I nerd out about that kind of stuff.</p>\n\n\n\n<p><em>Birgit Pauli-Haack</em>: And I think it&#8217;s much easier also for a user to have that separate because sooner or later, you&#8217;re done with fiddling with the design of your site and now you&#8217;re putting content and you don&#8217;t have to touch those tires anymore or scroll past them all the time. So it&#8217;s really a good way to think about these things and put them in experiments so we all can experience them and kind of see what works and what doesn&#8217;t work out. Yeah.</p>\n\n\n\n<p><em>Ryan Welcher</em>: Yeah.</p>\n\n\n\n<p><em>Birgit Pauli-Haack</em>: I think what&#8217;s active in development is so exciting for me to look forward and I hope all of this makes it into 6.2. That&#8217;s the next major version and we don&#8217;t have a plan yet for 6.2 and I think sooner or later, it will come out. I know that Hector and some of the core contributors are working on it and figuring out what will be a good release.</p>\n\n\n\n<p>It&#8217;s definitely going to be not in 2022, so it&#8217;ll be February or March of 2023. And maybe even before. Maybe not WordCamp Asia, but after WordCamp Asia. Yeah. Oh, speaking of which, what we haven&#8217;t announced yet is the State of the Word. That&#8217;s before the end of the show and we are all on the end of the show. The State of the Word will be happening in New York and on livestream on December 15th at 1:00 PM Eastern, that&#8217;s 5:00 PM UTC or 17:00 UTC&#8230; No, 1:00 PM Eastern is plus five, it&#8217;s 18:00 UTC and 17:00 Central European Time. And we share the announcement post to the State of the Word on the news section in the show notes, so you can all make your reservations. There&#8217;s also a form that you can apply to actually come to the event in New York. It&#8217;s, again, in the Automattic office like last year and the Automattic office and SOHO office in New York City in Manhattan. It&#8217;s going to be pretty cool. It&#8217;s scheduled for one hour and a half, and normally that&#8217;s kind of half an hour presentation by Matt Mullenweg and Josepha together. And then Q&amp;A for another hour, both livestream and in-person. Yeah.</p>\n\n\n\n<p><em>Ryan Welcher:</em> Very cool. Nice. Exclusive.&nbsp;</p>\n\n\n\n<p><em>Birgit Pauli-Haack</em>: Well, it&#8217;s published already.</p>\n\n\n\n<p><em>Ryan Welcher</em>: Oh. Well, then it&#8217;s not that exclusive. I just haven&#8217;t seen it. It&#8217;s exclusive to me, I just haven&#8217;t seen it yet.</p>\n\n\n\n<p><em>Birgit Pauli-Haack</em>: Yeah. As always, the show notes will be published on gutenbergtimes.com/podcast. Well, it&#8217;s hard today. Published on the gutenbergtimes.com/podcast and this is episode 76. And if you have questions or suggestions or news that you want us to include, send them to <a href=\"mailto:changelog@gutenbergtimes.com\">changelog@gutenbergtimes.com</a>. Yes, that&#8217;s an email address and that&#8217;s <a href=\"mailto:changelog@gutenbergtimes.com\">changelog@gutenbergtimes.com</a>. So thank you so much, Ryan. It was wonderful to have you. Do you have anything that you want our listeners to know that you haven&#8217;t talked about yet or how can people reach you?</p>\n\n\n\n<p><em>Ryan Welcher:</em> Well, I don&#8217;t have any exclusive things to announce today, but you can find me online. I&#8217;m @RyanWelcher on Twitter. I am Welcher or Welcher Ryan or Ryan Welcher on basically every other piece of social media. My Twitch, you can check me out at RyanWelchercodes. And that&#8217;s the same name for my YouTube channel, which is also Ryan Welcher codes. And I think that&#8217;s probably it. But, yeah, I&#8217;d love to have everyone come and hang out with me on Thursdays 10:30 Eastern when I do my livestream. But thank you for having me, Birgit. I know. Love coming here and hanging out and talking to all this cool code stuff.</p>\n\n\n\n<p><em>Birgit Pauli-Haack</em>: Yeah. And it&#8217;s so wonderful to have you. Yeah. To talk through those things and have all your excitement for the Gutenberg developer. Custom development is such a nice addition to the Gutenberg Changelog. Thank you so much.</p>\n\n\n\n<p><em>Ryan Welcher</em>: Thank you for having me. Looking forward to the next one.</p>\n\n\n\n<p><em>Birgit Pauli-Haack</em>: Yeah, and this was it. Thank you all for listening. This is goodbye for me and talk to you the next time.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Sun, 27 Nov 2022 14:58:22 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:19:\"Gutenberg Changelog\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:10;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:35:\"BuddyPress: BuddyPress 11.0.0-beta2\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:32:\"https://buddypress.org/?p=327306\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:55:\"https://buddypress.org/2022/11/buddypress-11-0-0-beta2/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:3457:\"<p>Hello BuddyPress contributors!</p>\n\n\n\n<p>If you haven’t tested our first&nbsp;<a href=\"https://buddypress.org/2022/11/buddypress-11-0-0-beta1/\">11.0.0 beta release</a>, here’s another opportunity to help us give the final touches to our next major release so that we make sure it will fit perfectly into your WordPress / BuddyPress specific configuration. Beta testing is very important and we need you all, whether you’re a regular or advanced user, a theme designer or a plugin author: <strong>please contribute</strong>!</p>\n\n\n\n<div class=\"is-content-justification-center is-layout-flex wp-container-1 wp-block-buttons\">\n<div class=\"wp-block-button aligncenter has-custom-font-size has-medium-font-size\"><a class=\"wp-block-button__link has-white-color has-text-color has-background wp-element-button\" href=\"https://downloads.wordpress.org/plugin/buddypress.11.0.0-beta2.zip\">Download &amp; Test BuddyPress 11.0.0-beta2</a></div>\n</div>\n\n\n\n<div class=\"wp-block-spacer\"></div>\n\n\n\n<p>Please note the plugin is&nbsp;<strong>still in development</strong>, so we recommend running this beta release on a&nbsp;<strong>testing site</strong>.</p>\n\n\n\n<p>You can test&nbsp;<a href=\"https://downloads.wordpress.org/plugin/buddypress.11.0.0-beta2.zip\">BuddyPress 11.0.0-beta2</a>&nbsp;in 4 ways :</p>\n\n\n\n<ul>\n<li>Try the&nbsp;<a href=\"https://wordpress.org/plugins/bp-beta-tester/\">BP Beta Tester</a>&nbsp;plugin.</li>\n\n\n\n<li><a href=\"https://downloads.wordpress.org/plugin/buddypress.11.0.0-beta2.zip\">Download the beta here (zip file)</a>.</li>\n\n\n\n<li>Check out our SVN repository:&nbsp;<code>svn co https://buddypress.svn.wordpress.org/trunk/</code></li>\n\n\n\n<li>Clone our read-only Git repository:&nbsp;<code>git clone git://buddypress.git.wordpress.org/</code></li>\n</ul>\n\n\n\n<p>The current target for final release is <strong>December 14, 2022</strong> <img src=\"https://s.w.org/images/core/emoji/14.0.0/72x72/1f448.png\" alt=\"👈\" class=\"wp-smiley\" />. We would greatly appreciate your help making sure this next major version of your community engine is as good as it can be.</p>\n\n\n\n<p>Since beta1, we&#8217;ve fixed <a href=\"https://buddypress.trac.wordpress.org/query?changetime=11%2F10%2F2022..11%2F26%2F2022&resolution=fixed&milestone=11.0.0&or&resolution=fixed&milestone=10.7.0&group=status&col=id&col=summary&col=owner&col=type&col=priority&col=component&col=version&order=priority\">12 new tickets</a> and documented some important changes BP Themes or Plugins authors should definitely read:</p>\n\n\n\n<ul>\n<li><a href=\"https://bpdevel.wordpress.com/2022/11/24/webp-support-is-arriving-in-buddypress-11-0-0/\">.webp support is arriving in BuddyPress&nbsp;11.0.0</a></li>\n\n\n\n<li><a href=\"https://bpdevel.wordpress.com/2022/11/21/buddypress-will-soon-only-load-its-javascript-and-style-assets-into-the-community-area-of-your-site/\">BuddyPress will soon only load its JavaScript and Style assets into the community area of your&nbsp;site</a></li>\n\n\n\n<li><a href=\"https://bpdevel.wordpress.com/2022/11/20/the-way-buddypress-loads-deprecated-code-will-change-in-version-11-0-0/\">The way BuddyPress loads deprecated code will change in version&nbsp;11.0.0</a></li>\n</ul>\n\n\n\n<p>If you find something weird testing this beta, please report it on&nbsp;<a href=\"https://buddypress.trac.wordpress.org/newticket\">BuddyPress Trac</a>&nbsp;or post a reply to&nbsp;<a href=\"https://buddypress.org/support/topic/buddypress-11-0-0-beta2/\">this support topic</a>.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Fri, 25 Nov 2022 22:28:29 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:12:\"Mathieu Viet\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:11;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:58:\"Post Status: WordPress is People (Weekly Community Update)\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:32:\"https://poststatus.com/?p=145168\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:67:\"https://poststatus.com/wordpress-is-people-weekly-community-update/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:2397:\"<p>Yes, of course WordPress is software. It’s code. It’s several different programming languages. It’s blocks. It’s the editor. Yes, it\'s all of the technology. </p>\n\n\n\n<p>But it’s people. It’s created by people. It’s used by people. It relies on people to move it forward, to modify it, to moderate it, and to build community around it.</p>\n\n\n\n<p>John Donne said “No man is an island, entire of itself; every man is a piece of the continent.” The same is true about WordPress. Each of us is part of it. WordPress is you and me. It’s us.</p>\n\n\n\n<p>If you’re interested in volunteering your time, skills, and resources to the open source project, there are many ways to be involved (and most of them aren’t coding). Learn more about ways to get involved on the <a href=\"https://make.wordpress.org/\">WordPress website</a>.</p>\n\n\n\n<h2 id=\"h-black-friday-cyber-monday-is-here\">Black Friday/Cyber Monday is here!&nbsp;</h2>\n\n\n\n<p>Have you snagged some good deals? (I’ve found a few!) We’ve accumulated over 200 deals on our site. I bet whatever you might need is there. <a href=\"https://poststatus.com/2022-black-friday-cyber-monday-wordpress-deals/\">Find this year’s deals here</a>.&nbsp;</p>\n\n\n\n<h2 id=\"h-we-have-a-black-friday-deal-too\">We have a Black Friday deal, too!</h2>\n\n\n\n<p>Did someone say Black Friday? We have a deal, too! Get $100 off <a href=\"https://poststatus.com/#choose-membership\">any level membership</a>. (Gets you Slack access, too!)<br />USe code: BFCM<br />Effective 11/25 &#8211; 12/31</p>\n\n\n\n<h2 id=\"h-about-us\">About Us</h2>\n\n\n\n<p>Have you ever wondered who it is that makes Post Status work? Look no further than our About Us page to meet the Post Status team: <a href=\"https://poststatus.com/about/\">Cory, Lindsey, Michelle, Adam, and Olivia</a></p>\n\n\n\n<h2>Upcoming Events:</h2>\n\n\n\n<ul>\n<li><a href=\"https://wordpress.org/news/2022/11/state-of-the-word-2022/\">State of the Word</a> December 15, 2022</li>\n\n\n\n<li>Post Status <a href=\"https://poststatus.com/huddles/\">Member Huddles </a>every week</li>\n\n\n\n<li>Calls for Speakers and Sponsors are open at <a href=\"https://www.wpwealthbuilder.com/\">WP Wealthbuilder Summit</a></li>\n\n\n\n<li>WordCamps are back. <a href=\"https://central.wordcamp.org/schedule/\">Check the schedule online</a>!</li>\n</ul>\n<p>This article was published at Post Status — the community for WordPress professionals.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Fri, 25 Nov 2022 18:35:23 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:18:\"Michelle Frechette\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:12;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"WPTavern: Dig Into the Open Web\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:30:\"https://wptavern.com/?p=139721\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:42:\"https://wptavern.com/dig-into-the-open-web\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:4066:\"<p>As the American Thanksgiving holiday is coming up, I am so grateful for all of our Tavern readers and the people who make WordPress &#8211; <a href=\"https://jeanbaptisteaudras.com/en/2022/11/contribution-stats-for-wordpress-6-1-misha/\">800 in the most recent 6.1 release</a> with 35 percent of them being new contributors. This community has made remarkable progress this year, while navigating changes and uncertain times. Committed contributors continue to show up and make WordPress the best platform for publishing on the web.</p>\n\n\n\n<div class=\"wp-block-embed__wrapper\">\n<blockquote class=\"twitter-tweet\"><p lang=\"en\" dir=\"ltr\">This time last year, WordPress didn\'t have:<br /><br /><img src=\"https://s.w.org/images/core/emoji/14.0.0/72x72/1f449.png\" alt=\"👉\" class=\"wp-smiley\" /> The Site Editor<br /><img src=\"https://s.w.org/images/core/emoji/14.0.0/72x72/1f449.png\" alt=\"👉\" class=\"wp-smiley\" /> Many block themes<br /><img src=\"https://s.w.org/images/core/emoji/14.0.0/72x72/1f449.png\" alt=\"👉\" class=\"wp-smiley\" /> Theme style variations<br /><img src=\"https://s.w.org/images/core/emoji/14.0.0/72x72/1f449.png\" alt=\"👉\" class=\"wp-smiley\" /> Advanced typography controls<br /><img src=\"https://s.w.org/images/core/emoji/14.0.0/72x72/1f449.png\" alt=\"👉\" class=\"wp-smiley\" /> Gap, padding &amp; margin controls<br /><img src=\"https://s.w.org/images/core/emoji/14.0.0/72x72/1f449.png\" alt=\"👉\" class=\"wp-smiley\" /> Block locking<br /><br />2022 has been WORK. <img src=\"https://s.w.org/images/core/emoji/14.0.0/72x72/1f4aa.png\" alt=\"💪\" class=\"wp-smiley\" /><br /><br />Good stuff team!</p>&mdash; Rich Tabor (@richard_tabor) <a href=\"https://twitter.com/richard_tabor/status/1595385429724905473?ref_src=twsrc%5Etfw\">November 23, 2022</a></blockquote>\n</div>\n\n\n\n<p>The recent social media upheaval with Twitter has been an unexpected gift that has created an opportunity for a mass return to decentralization and open web protocols, like ActivityPub and RSS. The sting of the prospect of losing Twitter followers and the network that users worked to build, has underscored the importance of agency in social networking, the ability to take your data and connections with you to other networks on your own terms. </p>\n\n\n\n<p>Although it is somewhat heartbreaking to see Twitter struggling to survive, one silver lining is that this situation is inspiring a drive towards a greater level of interoperability between apps, like <a href=\"https://techcrunch.com/2022/11/21/tumblr-to-add-support-for-activitypub-the-social-protocol-powering-mastodon-and-other-apps/\">Tumblr engineers working to add ActivityPub support</a> so users can connect across Mastodon and other networks that use the same protocol.</p>\n\n\n\n<p>People are steadily moving away from the all-powerful algorithms that steer consumers and subtly manipulate the public consciousness, and migrating away in search of healthier, more ethical social networking alternatives. The refreshing lack of ads and algorithms are winning people over in decentralized social networks, which are getting a second look from mainstream publications in light of Twitter&#8217;s loss of critical engineering teams.</p>\n\n\n\n<p>I&#8217;m thankful for this renewed focus on networks that value the open web, where people are now exploring alternatives to walled gardens with their friends, instead of having to start over alone. Never underestimate the power of friction and crisis to refine how we communicate and motivate us to find a better way to stay connected. This is a moment that may have enough traction to change the course of social interaction on the web.</p>\n\n\n\n<p>With things changing all around, it&#8217;s heartening to know that  WordPress is still here and going strong, for those of us who have chosen it as the home for our content. We&#8217;re fortunate to have so many plugins available that connect our ecosystem to the broader web, allowing us to syndicate content to almost anywhere.  Let&#8217;s not miss this opportunity to dig into the open web and see where it takes us. </p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Wed, 23 Nov 2022 21:06:51 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Sarah Gooding\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:13;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:87:\"Post Status: State of the Word 2022 • Dev Blog Beta • WP 3.7 – 4.0 Final Releases\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:32:\"https://poststatus.com/?p=145071\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:86:\"https://poststatus.com/state-of-the-word-2022-dev-blog-beta-wp-3-7-4-0-final-releases/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:17376:\"<h2 id=\"h-this-week-at-wordpress-org-november-21-2022\">This Week at WordPress.org (November 21, 2022)</h2>\n\n\n<div class=\"has-background has-theme-palette-8-background-color wp-block-post-excerpt\"><p class=\"wp-block-post-excerpt__excerpt\">As 2022 comes to an end, State of the Word will happen in NYC again. Apply to attend or tune in to the livestream. Check out the beta version of the WordPress Developer Blog. Still have sites on WordPress 3.7 &#8211; 4.0? It\'s really time to upgrade as this will receive no further updates after December 1. It\'s team rep nomination time too. </p></div>\n\n\n<div class=\"wp-block-spacer\"></div>\n\n\n\n<div id=\"kt-info-box_68609b-a8\" class=\"wp-block-kadence-infobox\"><div class=\"kt-blocks-info-box-link-wrap kt-blocks-info-box-media-align-left kt-info-halign-left\"><div class=\"kt-blocks-info-box-media-container\"><div class=\"kt-blocks-info-box-media kt-info-media-animate-none\"><div class=\"kadence-info-box-icon-container kt-info-icon-animate-none\"><div class=\"kadence-info-box-icon-inner-container\"><span class=\"kt-info-svg-icon kt-info-svg-icon-fe_arrowUpCircle\"></span></div></div></div></div><div class=\"kt-infobox-textcontent\"><h2 class=\"kt-blocks-info-box-title\">State of the Word, New Dev Blog, and EOL WP 3.7 &#8211; 4.0</h2><p class=\"kt-blocks-info-box-text\"><img src=\"https://s.w.org/images/core/emoji/14.0.0/72x72/1f399.png\" alt=\"🎙\" class=\"wp-smiley\" /> <a href=\"https://wordpress.org/news/2022/11/state-of-the-word-2022/\">State of the Word 2022</a><br /><br /><img src=\"https://s.w.org/images/core/emoji/14.0.0/72x72/1f4a1.png\" alt=\"💡\" class=\"wp-smiley\" /> <a href=\"https://make.wordpress.org/core/2022/11/21/wordpress-developer-blog-is-in-public-beta/\">WordPress Developer Blog is in public beta</a><br /><br /><img src=\"https://s.w.org/images/core/emoji/14.0.0/72x72/1faa6.png\" alt=\"🪦\" class=\"wp-smiley\" /> <a href=\"https://make.wordpress.org/core/2022/11/23/final-releases-of-wordpress-3-7-4-0/\">Final releases of WordPress 3.7 – 4.0</a><br /><br /><img src=\"https://s.w.org/images/core/emoji/14.0.0/72x72/1f64b-1f3fc.png\" alt=\"🙋🏼\" class=\"wp-smiley\" /> <a href=\"https://make.wordpress.org/updates/2022/11/15/team-rep-nominations-2022/\">Team Rep Nominations, 2022</a></p></div></div></div>\n\n\n\n<h2 id=\"h-news\">News<a href=\"https://wordpress.org/news/2022/10/wordpress-6-1-release-candidate-3/\"></a></h2>\n\n\n\n<ul>\n<li><a href=\"https://wordpress.org/news/2022/11/the-month-in-wordpress-october-2022/\">The Month in WordPress – October 2022</a></li>\n\n\n\n<li><a href=\"https://wordpress.org/news/2022/11/state-of-the-word-2022/\">State of the Word 2022</a></li>\n</ul>\n\n\n\n<div class=\"wp-block-kadence-spacer aligncenter kt-block-spacer-_121b9e-cb\"><div class=\"kt-block-spacer kt-block-spacer-halign-center\"><hr class=\"kt-divider\" /></div></div>\n\n\n\n<div class=\"is-layout-flex wp-container-9 wp-block-columns\">\n<div class=\"is-layout-flow wp-block-column\">\n<h2 id=\"h-accessibility\"><a href=\"https://make.wordpress.org/accessibility\">Accessibility</a></h2>\n\n\n\n<ul>\n<li><a href=\"https://make.wordpress.org/accessibility/2022/11/17/accessibility-team-meeting-agenda-november-18-2022/\">Accessibility Team Meeting Agenda: November 18, 2022</a></li>\n</ul>\n\n\n\n<h2 id=\"h-community\">Community</h2>\n\n\n\n<ul>\n<li><a href=\"https://make.wordpress.org/community/2022/11/22/meetup-organizer-newsletter-november-2022/\">Meetup Organizer Newsletter: November 2022</a></li>\n\n\n\n<li><a href=\"https://make.wordpress.org/community/2022/11/17/announcement-new-european-camera-kits/\">Announcement: New European Camera Kits</a></li>\n</ul>\n\n\n\n<h2 id=\"h-core\"><a href=\"https://make.wordpress.org/core\">Core</a> </h2>\n\n\n\n<ul>\n<li><a href=\"https://make.wordpress.org/core/2022/11/23/a-week-in-core-november-21-2022/\">A Week in Core – November 21, 2022</a></li>\n\n\n\n<li><a href=\"https://make.wordpress.org/core/2022/11/23/editor-chat-summary-november-23-2022/\">Editor chat summary: 23 November 2022</a></li>\n\n\n\n<li><a href=\"https://make.wordpress.org/core/2022/11/23/devchat-agenda-november-23-2022/\">Devchat agenda, November 23, 2022</a></li>\n\n\n\n<li><a href=\"https://make.wordpress.org/core/2022/11/21/editor-chat-agenda-nov-23-2022/\">Editor Chat Agenda: November 23, 2022</a></li>\n\n\n\n<li><a href=\"https://make.wordpress.org/core/2022/11/17/editor-chat-summary-november-16-2022/\">Editor chat summary: 16 November 2022</a></li>\n</ul>\n\n\n\n<h2 id=\"h-design\"><a href=\"https://make.wordpress.org/design\">Design</a></h2>\n\n\n\n<ul>\n<li><a href=\"https://make.wordpress.org/design/2022/11/21/design-share-nov-7-nov-18/\">Design Share: Nov 7 – Nov 18</a></li>\n\n\n\n<li><a href=\"https://make.wordpress.org/design/2022/11/11/a-refresh-of-wordpress-org-showcase/\">A refresh of WordPress.org/Showcase</a></li>\n</ul>\n\n\n\n<h2 id=\"h-docs\"><a href=\"https://make.wordpress.org/docs\">Docs</a></h2>\n\n\n\n<ul>\n<li><a href=\"https://make.wordpress.org/docs/2022/11/22/devhub-getting-a-new-look/\">DevHub getting a new look</a></li>\n\n\n\n<li><a href=\"https://make.wordpress.org/updates/2022/11/21/documentation-team-update-november-21-2022/\">Documentation Team Update – November 21, 2022</a></li>\n</ul>\n\n\n\n<h2 id=\"h-hosting\"><a href=\"https://make.wordpress.org/hosting\">Hosting</a></h2>\n\n\n\n<ul>\n<li><a href=\"https://make.wordpress.org/hosting/2022/11/23/server-environment-for-wordpress-6-1/\">Server Environment for WordPress 6.1</a></li>\n\n\n\n<li><a href=\"https://make.wordpress.org/hosting/2022/11/09/nominations-for-hosting-team-reps-2023/\">Nominations for Hosting Team Reps 2023</a></li>\n</ul>\n\n\n\n<h2 id=\"h-marketing\"><a href=\"https://make.wordpress.org/marketing\">Marketing</a></h2>\n\n\n\n<ul>\n<li><a href=\"https://make.wordpress.org/marketing/2022/11/23/notes-global-marketing-team-meeting-november-16-2022/\">Notes: Global Marketing Team meeting, November 16, 2022</a></li>\n\n\n\n<li><a href=\"https://make.wordpress.org/marketing/2022/11/23/agenda-global-marketing-team-meeting-november-23-2022/\">Agenda: global Marketing Team meeting, November 23, 2022</a></li>\n\n\n\n<li><a href=\"https://make.wordpress.org/marketing/2022/11/16/2023-team-rep-nominations-for-marketing/\">2023 Team Rep Nominations for Marketing</a></li>\n</ul>\n\n\n\n<h2 id=\"h-meta\"><a href=\"https://make.wordpress.org/meta\">Meta</a></h2>\n\n\n\n<ul>\n<li><a href=\"https://make.wordpress.org/meta/2022/10/21/wordpress-org-redesign-update/\">WordPress.org Redesign Update</a></li>\n</ul>\n\n\n\n<h2 id=\"h-mobile\"><a href=\"https://make.wordpress.org/mobile\">Mobile</a></h2>\n\n\n\n<ul>\n<li><a href=\"https://make.wordpress.org/mobile/2022/11/15/call-for-testing-wordpress-for-android-21-2/\">Call for Testing: WordPress for Android 21.2</a></li>\n\n\n\n<li><a href=\"https://make.wordpress.org/mobile/2022/11/14/call-for-testing-wordpress-for-ios-21-2/\">Call for Testing: WordPress for iOS 21.2</a></li>\n</ul>\n\n\n\n<h2 id=\"h-openverse\"><a href=\"http://make.wordpress.org/openverse\">Openverse</a></h2>\n\n\n\n<ul>\n<li><a href=\"https://make.wordpress.org/openverse/2022/11/23/community-meeting-recap-22-november-2022/\">Community Meeting Recap (22 November 2022)</a></li>\n\n\n\n<li><a href=\"https://make.wordpress.org/openverse/2022/11/18/preparing-the-next-migration-of-the-catalog/\">Preparing the next migration of the Catalog</a></li>\n</ul>\n\n\n\n<h2 id=\"h-performance\"><a href=\"https://make.wordpress.org/performance/\">Performance</a></h2>\n\n\n\n<ul>\n<li><a href=\"https://github.com/WordPress/five-for-the-future/issues/218\">Add &#8220;Core Performance Team&#8221; to Contributor Teams list for Profiles</a></li>\n\n\n\n<li><a href=\"https://make.wordpress.org/core/2022/11/22/performance-chat-summary-22-november-2022/\">Performance Chat Summary: 22 November 2022</a></li>\n\n\n\n<li><a href=\"https://make.wordpress.org/core/2022/11/22/performance-chat-agenda-22-november-2022/\">Performance Chat Agenda: 22 November 2022</a></li>\n</ul>\n\n\n\n<h2 id=\"h-photos\"><a href=\"https://make.wordpress.org/photos\">Photos</a></h2>\n\n\n\n<ul>\n<li><a href=\"https://make.wordpress.org/photos/2022/11/17/the-road-to-5000-photos-a-retrospective/\">The Road To 5000 Photos, A Retrospective</a></li>\n</ul>\n</div>\n\n\n\n<div class=\"is-layout-flow wp-block-column\">\n<h2 id=\"h-polyglots\">Polyglots</h2>\n\n\n\n<ul>\n<li><a href=\"https://make.wordpress.org/polyglots/2022/11/22/agenda-weekly-polyglots-chat-nov-23-2022-1300-utc/\">Agenda: Weekly Polyglots Chat – Nov. 23, 2022 (13:00 UTC)</a></li>\n\n\n\n<li><a href=\"https://make.wordpress.org/polyglots/2022/11/22/polyglots-monthly-newsletter-november-2022/\">Polyglots Monthly Newsletter: November 2022&nbsp;</a></li>\n\n\n\n<li><a href=\"https://make.wordpress.org/polyglots/2022/11/08/call-for-polyglots-team-representatives-2/\">Call for Polyglots Team Representatives</a></li>\n</ul>\n\n\n\n<h2 id=\"h-plugins\"><a href=\"https://make.wordpress.org/plugins\">Plugins</a></h2>\n\n\n\n<ul>\n<li><a href=\"https://make.wordpress.org/updates/2022/11/22/plugin-review-team-update-21-november-2022/\">Plugin Review Team Update: 21 November 2022</a></li>\n</ul>\n\n\n\n<h2 id=\"h-project\"><a href=\"https://make.wordpress.org/project\">Project</a></h2>\n\n\n\n<ul>\n<li><a href=\"https://make.wordpress.org/project/2022/11/01/sustainability-channel-what-should-we-do/\">Now we have a sustainability channel in Making WordPress Slack, what should we do?</a></li>\n</ul>\n\n\n\n<h2><a href=\"https://make.wordpress.org/support\">Support</a></h2>\n\n\n\n<ul>\n<li><a href=\"https://make.wordpress.org/support/2022/11/november-17th-support-team-meeting-summary-2/\">November 17th Support Team Meeting Summary</a></li>\n\n\n\n<li><a href=\"https://make.wordpress.org/support/2022/11/call-for-support-team-representatives/\">Call for Support Team Representative(s)</a></li>\n</ul>\n\n\n\n<h2 id=\"h-test\"><a href=\"https://make.wordpress.org/test\">Test</a></h2>\n\n\n\n<ul>\n<li><a href=\"https://make.wordpress.org/test/2022/11/13/fse-program-exploration-site-editor-sneak-peek/\">FSE Program Exploration: Site Editor Sneak Peek</a></li>\n\n\n\n<li><a href=\"https://make.wordpress.org/updates/2022/11/22/test-team-update-21-november-2022/\">Test Team Update: 21 November 2022</a></li>\n</ul>\n\n\n\n<h2 id=\"h-themes\"><a href=\"https://make.wordpress.org/themes\">Themes</a></h2>\n\n\n\n<ul>\n<li><a href=\"https://make.wordpress.org/themes/2022/11/21/themes-team-meeting-agenda-for-november-22-2022/\">Themes team meeting agenda for November 22, 2022</a></li>\n\n\n\n<li><a href=\"https://make.wordpress.org/themes/2022/11/16/nominations-call-for-the-themes-team-representatives-2023-edition/\">Nominations Call for the themes team representatives: 2023 Edition</a></li>\n\n\n\n<li><a href=\"https://make.wordpress.org/updates/2022/11/22/themes-team-update-november-22-2022/\">Themes team update November 22, 2022</a></li>\n</ul>\n\n\n\n<h2 id=\"h-training\"><a href=\"https://make.wordpress.org/training\">Training</a></h2>\n\n\n\n<ul>\n<li><a href=\"https://learn.wordpress.org/individual-learner-survey/\">How did you learn WordPress?</a></li>\n\n\n\n<li><a href=\"https://make.wordpress.org/training/2022/11/21/meeting-agenda-for-november-22-2022/\">Meeting Agenda for November 22, 2022</a></li>\n\n\n\n<li><a href=\"https://make.wordpress.org/training/2022/11/17/nomination-for-training-team-reps-2023/\">Nomination for Training Team Reps 2023</a></li>\n\n\n\n<li><a href=\"https://make.wordpress.org/training/2022/11/09/choosing-accessible-contrasting-dark-theme-colors-for-online-workshops-and-tutorial-videos/\">Choosing accessible/contrasting dark theme colors for online workshops and tutorial videos</a></li>\n\n\n\n<li><a href=\"https://make.wordpress.org/training/2022/11/15/november-2022-faculty-meeting/\">November 2022 Faculty Meeting</a></li>\n\n\n\n<li><a href=\"https://make.wordpress.org/training/2022/11/07/project-thread-content-localization-foundations/\">Project Thread: Content Localization Foundations</a></li>\n</ul>\n\n\n\n<h3 id=\"h-tutorials\">Tutorials</h3>\n\n\n\n<ul>\n<li><a href=\"https://learn.wordpress.org/tutorial/streamline-your-block-theme-development-with-create-block-theme/\">Streamline your Block Theme development with Create Block&nbsp;Theme</a></li>\n\n\n\n<li><a href=\"https://learn.wordpress.org/tutorial/padding-versus-margin/\">Padding Versus Margin</a></li>\n</ul>\n\n\n\n<h3 id=\"h-online-workshops\">Online Workshops</h3>\n\n\n\n<ul>\n<li><a href=\"https://learn.wordpress.org/?meeting=i-just-got-this-wordpress-and-dont-know-how-to-use-it\">I Just Got This WordPress and Don’t Know How to Use It</a></li>\n\n\n\n<li><a href=\"https://learn.wordpress.org/?meeting=lets-code-developing-blocks-without-react-part-2-2\">Let’s code: Developing Blocks without React! – Part 2</a></li>\n\n\n\n<li><a href=\"https://learn.wordpress.org/?meeting=wordpress-development-live-stream-developers-guide-to-block-themes-part-2\">WordPress development live stream: Developers Guide to Block Themes – Part 2</a></li>\n\n\n\n<li><a href=\"https://learn.wordpress.org/?meeting=image-seo-best-practices-to-make-your-content-discoverable\">Image SEO Best Practices to Make Your Content Discoverable</a></li>\n\n\n\n<li><a href=\"https://learn.wordpress.org/?meeting=hallway-hangout-future-of-css-in-themes\">Hallway Hangout: Future of CSS in themes</a></li>\n\n\n\n<li><a href=\"https://learn.wordpress.org/?meeting=designing-in-the-site-editor-a-wordpress-block-theme-exploration-2\">Designing in the Site Editor: A WordPress Block Theme Exploration</a></li>\n\n\n\n<li><a href=\"https://learn.wordpress.org/?meeting=designing-in-the-site-editor-a-wordpress-block-theme-exploration\">Designing in the Site Editor: A WordPress Block Theme Exploration</a></li>\n\n\n\n<li><a href=\"https://learn.wordpress.org/?meeting=wordpress-6-1-%E3%81%AE%E3%82%A2%E3%83%83%E3%83%97%E3%83%87%E3%83%BC%E3%83%88%E5%86%85%E5%AE%B9%E3%82%92%E8%A6%8B%E3%81%A6%E3%81%BF%E3%82%88%E3%81%86%EF%BC%81-2\">WordPress 6.1 のアップデート内容を見てみよう！</a></li>\n\n\n\n<li><a href=\"https://learn.wordpress.org/?meeting=wordpress-6-1-%E3%81%AE%E3%82%A2%E3%83%83%E3%83%97%E3%83%87%E3%83%BC%E3%83%88%E5%86%85%E5%AE%B9%E3%82%92%E8%A6%8B%E3%81%A6%E3%81%BF%E3%82%88%E3%81%86%EF%BC%81\">WordPress 6.1 のアップデート内容を見てみよう！</a></li>\n</ul>\n\n\n\n<h2 id=\"h-wptv\">WPTV</h2>\n\n\n\n<ul>\n<li><a href=\"https://meta.trac.wordpress.org/ticket/1430\">WordPress TV videos are now auto-published to YouTube</a></li>\n\n\n\n<li><a href=\"https://wordpress.tv/category/year/2022/\">Latest WordPress TV videos</a></li>\n</ul>\n</div>\n</div>\n\n\n\n<hr class=\"wp-block-separator has-alpha-channel-opacity\" />\n\n\n\n<h2 id=\"h-related-news\">Related News:</h2>\n\n\n\n<ul>\n<li><a href=\"https://getcomposer.org/changelog/2.4.4\">Composer 2.4.4</a></li>\n\n\n\n<li><a href=\"https://www.php.net/archive/2022.php#2022-11-10-1\">PHP 8.2.0 RC 6 available for testing</a></li>\n\n\n\n<li><a href=\"https://nodejs.org/en/blog/release/v19.1.0/\">Node v19.1.0 (Current)</a></li>\n\n\n\n<li><a href=\"https://tc39.es/#proposals\">ECMAScript Proposals</a></li>\n</ul>\n\n\n\n<p class=\"has-theme-palette-7-background-color has-background\">Thanks for reading our WP dot .org roundup! Each week we are highlighting the news and discussions coming from the good folks making WordPress possible. If you or your company create products or services that use WordPress, you need to be engaged with them and their work. Be sure to share this resource with your product and project managers. <br /><br /><strong>Are you interested in giving back and contributing your time and skills to WordPress.org?</strong> <img src=\"https://s.w.org/images/core/emoji/14.0.0/72x72/1f64f.png\" alt=\"🙏\" class=\"wp-smiley\" /> <a href=\"https://wordpress.org/support/article/contributing-to-wordpress/\">Start Here ›</a><br /><br /><strong>Get our weekly WordPress community news digest</strong> — Post Status\' <a href=\"https://poststatus.com/news/week-in-review/\">Week in Review</a> — covering the WP/Woo news plus significant writing and podcasts. It\'s also available in <a href=\"https://poststatus.com/newsletter\">our newsletter</a>. <img src=\"https://s.w.org/images/core/emoji/14.0.0/72x72/1f48c.png\" alt=\"💌\" class=\"wp-smiley\" /></p>\n\n\n\n<div class=\"wp-block-spacer\"></div>\n\n\n\n<div class=\"wp-block-media-text alignwide is-stacked-on-mobile has-background\"><a href=\"https://poststatus.com/\"><img src=\"https://cdn.poststatus.com/wp-content/uploads/2021/09/vertical-post-status-logo-250.png\" alt=\"Post Status\" class=\"wp-image-85823 size-full\" /></a><div class=\"wp-block-media-text__content\">\n<p class=\"has-text-align-left has-normal-font-size\" id=\"h-get-ready-for-remote-work\">You — and <a href=\"https://poststatus.com/#Agency\">your whole team</a> can <a href=\"https://poststatus.com/#choose-membership\">Join Post Status</a> too!</p>\n\n\n\n<p class=\"has-text-align-left has-small-font-size\"><strong>Build your network. Learn with others. Find your next job — or your next hire.</strong> Read the <strong>Post Status</strong> <a href=\"https://poststatus.com/newsletter/\">newsletter</a>. <img src=\"https://s.w.org/images/core/emoji/14.0.0/72x72/2709.png\" alt=\"✉\" class=\"wp-smiley\" /> Listen to <a href=\"https://poststatus.com/podcasts/\">podcasts</a>. <img src=\"https://s.w.org/images/core/emoji/14.0.0/72x72/1f399.png\" alt=\"🎙\" class=\"wp-smiley\" /> Follow <a href=\"https://twitter.com/post_status/\">@Post_Status</a> <img src=\"https://s.w.org/images/core/emoji/14.0.0/72x72/1f426.png\" alt=\"🐦\" class=\"wp-smiley\" /> and <a href=\"https://www.linkedin.com/company/post-status-llc/\">LinkedIn</a>. <img src=\"https://s.w.org/images/core/emoji/14.0.0/72x72/1f4bc.png\" alt=\"💼\" class=\"wp-smiley\" /></p>\n</div></div>\n\n\n\n<div class=\"wp-block-spacer\"></div>\n<p>This article was published at Post Status — the community for WordPress professionals.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Wed, 23 Nov 2022 18:51:06 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:18:\"Courtney Robertson\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:14;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:84:\"WPTavern: #52 – Hannah Smith on Why We Need To Be Making Websites More Sustainable\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:48:\"https://wptavern.com/?post_type=podcast&p=139776\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:98:\"https://wptavern.com/podcast/52-hannah-smith-on-why-we-need-to-be-making-websites-more-sustainable\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:46564:\"Transcript<div>\n<p>[00:00:00] <strong>Nathan Wrigley:</strong> Welcome to the Jukebox podcast from WP Tavern. My name is Nathan Wrigley.</p>\n\n\n\n<p>Jukebox is a podcast which is dedicated to all things WordPress. The people, the events, the plugins, the blocks, the themes, and in this case making websites more sustainable.</p>\n\n\n\n<p>If you&#8217;d like to subscribe to the podcast, you can do that by searching for WP Tavern in your podcast player of choice, or by going to WPTavern.com forward slash feed forward slash podcast. And you can copy that URL into most podcast players.</p>\n\n\n\n<p>If you have a topic that you&#8217;d like us to feature on the podcast, well, I&#8217;m very keen to hear from you and hopefully get you, or your idea featured on the show. Head to WPTavern.com forward slash contact forward slash jukebox. And use the form there.</p>\n\n\n\n<p>So on the podcast today, we have Hannah Smith. Hannah is the operations and training manager for the Green Web Foundation, and founder of The Let&#8217;s Green The Web campaign. She&#8217;s also co-founder of Green Tech Southwest.</p>\n\n\n\n<p>Her background is in computer science. She previously worked as a freelance WordPress developer and also for the Environment Agency, where she managed business change projects.</p>\n\n\n\n<p>It&#8217;s pretty easy to forget that the device that you&#8217;re reading or listening to this podcast on is consuming power. We plug things in or charge them up, and they just work. They are sleek and sterile. No pollution comes out of the device directly. In fact, I&#8217;d go as far as to say that many of us never make the connection between our use of technology and the impact that this has on the environment.</p>\n\n\n\n<p>Enter Hannah Smith. She&#8217;s been thinking about this for years and is on the podcast today to highlight the issue and hopefully get your ideas about what users of WordPress can do to make sure that the websites we create are having the smallest impact possible.</p>\n\n\n\n<p>Her approach is not that we need to cease and desist using our technology. Rather it&#8217;s about coming up with new and innovative ways that we can reduce the impact that we have.</p>\n\n\n\n<p>As creators of websites, there are a whole raft of options available to us. Reducing the size of our images. Inspecting the HTML to remove bloat. Choosing hosting options that source renewable energy.</p>\n\n\n\n<p>With this in mind, Hannah and others have been working on a sustainability related blog post, which has been published on the Make WordPress site this week. This post is intended to trigger meaningful and open discussion in the global WordPress community about the topic of sustainability.</p>\n\n\n\n<p>She really wants to encourage others to weigh into this public conversation with their own thoughts, so that we can build on what is already happening to make WordPress more sustainable.</p>\n\n\n\n<p>It&#8217;s a fascinating and thought provoking topic, and if you&#8217;re interested in finding out more, you can get all of the links in the show notes by heading over to WPTavern.com forward slash podcast. Where you&#8217;ll find all of the other episodes as well.</p>\n\n\n\n<p>And so without further delay, I bring you Hannah Smith.</p>\n\n\n\n<p>I am joined on the podcast today by Hannah Smith. Hello Hannah.</p>\n\n\n\n<p>[00:04:02] <strong>Hannah Smith:</strong> Hello Nathan. Thank you so much for having me today.</p>\n\n\n\n<p>[00:04:05] <strong>Nathan Wrigley:</strong> You are so welcome. Hannah is here today to talk about the environmental impact of having WordPress websites, and I genuinely think this is going to be a real eye opener for many of us.</p>\n\n\n\n<p>Before we do that though Hannah, we always orientate our listeners by allowing the guests to just give us a bit of background on who they are and what their relationship is with WordPress. So if you don&#8217;t mind, I&#8217;m going to ask you that very generic question is just tell us a little bit about yourself and how come you are into WordPress.</p>\n\n\n\n<p>[00:04:35] <strong>Hannah Smith:</strong> Thank you. I&#8217;m a massive fan of WordPress. I&#8217;ve so much love and admiration for the community. So my background is as a computer scientist, so that&#8217;s what I studied in my degree. Had, like many people, are very sort of winding interesting journey in and around different things.</p>\n\n\n\n<p>And about eight years ago, I set myself up as a freelance WordPress developer. So having done sort of other careers within tech, I won&#8217;t give you the long winding path that I got there, but serendipity basically somehow landed me, as a freelance WordPress developer. Finding myself wanting to give it a go.</p>\n\n\n\n<p>I was living in Bristol at the time, and wanted to learn more about WordPress and found that we had a meetup community in Bristol, and decided to pop along. Was made to feel very welcome, and learn loads from the awesome people there. So, a shout out to Simon, Janice, and Rob, who were the people that grounded me into that community.</p>\n\n\n\n<p>And then it wasn&#8217;t long before I somehow found myself invited to help run that community and help drive that community, which I was very happy to do for a good few years. And then in 2019 we did WordCamp Bristol. We had about 200 odd people come to that, which was brilliant. And I&#8217;ve been quite involved in WordCamps and speaking at conferences. Try and contribute where I can.</p>\n\n\n\n<p>These days I&#8217;ve actually hung up my shoes, only recently as a WordPress developer, and I&#8217;ve transitioned to working full-time for the Green Web Foundation. But part of my role at the Green Web Foundation, so I do a lot of training and outreach and operations, because we&#8217;re small, so everyone wears lots of hats.</p>\n\n\n\n<p>But I do also manage our WordPress website as well and our WordPress estate too. So, whilst it might not be my full job title to have WordPress every single day, it is still very much a part of what I do.</p>\n\n\n\n<p>[00:06:35] <strong>Nathan Wrigley:</strong> Thank you. What a, rich and interesting history you&#8217;ve had. We&#8217;ve met in person on a number of occasions, but it&#8217;s been a little while since we met up in person. But you came across my radar on the 1st of November because of a piece that you had written over on make.wordpress.org.</p>\n\n\n\n<p>I will link to it in the show notes and, it may well be a good idea, if you&#8217;re listening to this podcast and you are anywhere near a device, it might be a good idea to pause the podcast actually. Go and read the piece it&#8217;s called, now we have a sustainability channel in making WordPress Slack, what should we do?</p>\n\n\n\n<p>And the reason I&#8217;m asking you to potentially go and read that is because really it&#8217;s going to form the basis of everything that we are going to be talking about around the environment and so on. So tell us what was the concern? What was the primary motive for writing that piece?</p>\n\n\n\n<p>[00:07:25] <strong>Hannah Smith:</strong> So, the piece was written very much in collaboration with four others, so I want to say from the outset that whilst it was my face next to the post when you read it, I was the nominated person to publish it. It was very much a collaborative effort with four others.</p>\n\n\n\n<p>So with Nora, Nahuai, Pace, and Csaba, who are placed in different places across Europe. And, Nahuai and Nora, I knew from some workshops I&#8217;d run back in the spring, exploring the topic of digital sustainability. But we were chatting and we all felt that where was the action in WordPress on sustainability?</p>\n\n\n\n<p>We were kind of looking around and, I&#8217;m very involved in the wider community around digital sustainability. But I was looking around and I was like, I just don&#8217;t feel this in WordPress. It&#8217;s just not surfaced enough. It&#8217;s very niche and, we are really getting to a point where sustainability can&#8217;t be a niche concern.</p>\n\n\n\n<p>It has to be a concern for everybody, everywhere because what&#8217;s happening around us in terms of the changing climate, in terms of our lack of sustainable approaches, does affect every single person, whether they want to admit that or not. We are all impacted by it. Rich, poor, young, old, we&#8217;re all going to face these consequences.</p>\n\n\n\n<p>So we were chatting and Nora and Nahuai I were at WordCamp Europe this year, and Nora actually asked a question in, you know the Q and A that Josepha and Matt have? So Nora asked a question about sustainability and  stood up. I mean more power to her. She stood up in front of the whole crowd and said, hey, sustainability. We really care about this, but there&#8217;s nothing much happening, and Matt and Josepha said, well, okay, look. The very first thing we can do is set up a channel in Slack. So maybe that will help, WordPress Slack. You know to give people a collaboration space and a meeting space.</p>\n\n\n\n<p>And they also said, well, and if you&#8217;ve got any ideas or specific proposals that you want to make, we are going to listen. The door is open, essentially. So Nora set this ball in motion really with her question. And then Josepha and Matt responded really well. And so since then, since the summer, a few of us have been sort of working, just informally, thinking, okay, well how do we capitalize upon this?</p>\n\n\n\n<p>WordPress leadership is saying we&#8217;re listening, or, we are happy to collaborate with you. But now what we need to do is to get the community together and to get the community, A, to know who each other are, and B, to acknowledge this is a topic and to talk about it, and discuss it, and bring knowledge and ideas into a space together. So this is why we ended up writing the post. And the post is very much saying, hey, WordPress community, look, we&#8217;ve got this channel, but you know, a channel isn&#8217;t going to solve our problems.</p>\n\n\n\n<p>It&#8217;s, it&#8217;s you. You and your ideas that are going to solve these problems or that are going to make progress. So, could we please get into a discussion about what people&#8217;s ideas are? So we&#8217;ve invited people to share their ideas and particularly any vision that they have. Or ideas that they have around what sustainability and WordPress might look like in the future.</p>\n\n\n\n<p>Because if we can&#8217;t imagine it, we&#8217;re not going to get there. And I think a lot of the narrative around climate change is very doom and gloom. It&#8217;s very pessimistic. It feels almost like we&#8217;re accepting that we&#8217;ve been defeated. opposite. It&#8217;s so the opposite. We have every opportunity and potential here to turn things around and change things. It is not yet too late. So we wanted to really bring everyone together and imagine these ideas together and then see where that leads us.</p>\n\n\n\n<p>[00:11:18] <strong>Nathan Wrigley:</strong> Thank you. That&#8217;s really helpful. You used the word sustainable a dozen times or more in, in that, last little section, and it occurs to me that there&#8217;s probably quite a few people listening who have some sort of conception of what we mean by sustainability, but I&#8217;m pretty sure that everybody&#8217;s conception of it will be slightly different to everybody else&#8217;s.</p>\n\n\n\n<p>What exactly are you meaning when you say sustainability in WordPress or sustainability surrounding WordPress? What are the areas that you are touching on? What are the points of concern that we need to have drawn to our attention?</p>\n\n\n\n<p>[00:11:54] <strong>Hannah Smith:</strong> Yeah, that&#8217;s a great question. You are absolutely right that most people will have slightly differing ideas of sustainability. Some people may even have a very narrow view of sustainability, which might be something called decarbonization. Which really relates around carbon emissions. But, Perhaps let me give a really sort of wide view of what sustainability is outside of the realms of tech or WordPress, and then we can kind of narrow in a bit and talk about how that relates then to tech or digital specifically, or WordPress specifically.</p>\n\n\n\n<p>So if we talk about sustainability or the word sustain, it means that we&#8217;re able to keep doing things into the long term. There&#8217;s this quote that&#8217;s often used. It&#8217;s about meeting the needs of the present without compromising the needs, or the ability of the future generations to meet their needs. So at it&#8217;s most basic level, sustainability can mean that. To get a bit more specific about it, I draw on something called the donor economics framework.</p>\n\n\n\n<p>If anybody here is interested in a really holistic way of thinking about sustainability, that&#8217;s a bit more in depth, I really recommend this as a resource to have a look at. Very accessible. Don&#8217;t let the fact that it&#8217;s about economics or economics turn you away, make you think it&#8217;s not for you. It is for everybody. And the way that donor economics talks about sustainability, I really love this is, it talks about sustainability as having humanity at the center of the story.</p>\n\n\n\n<p>So sustainability is much more than us thinking about the environmental ecosystems. It&#8217;s about thinking about how humanity sits within the environment. So if you can imagine a simple donut shape with a hole in the middle. Essentially what you get there is two circles, one smaller one inside, a bigger one. That smaller circle, we might often think of something that they term as the social foundation. And the social foundation is a set of 12 things that, when you consider them all in relation to one another, define the things that makes us human, and defines the things that just allow us to survive as humans, but allows us to really thrive as humans.</p>\n\n\n\n<p>So it&#8217;s more than just thinking about food, water, shelter, clothing. It&#8217;s also thinking about those emotional needs that we have as well around peace and justice. Around meaningful connections with other people around access to education and opportunities. So I love to think about our social foundation as the center of the story of sustainability. Because humans are a part of this planet. And it is a very dangerous mindset, or a very dangerous kind of thing to get into, to think that the only way that we become more sustainable is by not being here. And that&#8217;s really not a good story to tell, and it&#8217;s not the right story to tell. We are part of the planet, and we can live within the boundaries of what the planet can provide for us.</p>\n\n\n\n<p>And that moves me onto the second circle, this outer circle. And donor economics talks about that as our ecological boundaries or our ecological ceiling. And that&#8217;s basically accepting that the planet has a finite amount of resources. There&#8217;s only so much wind that blows. There&#8217;s only so many raw materials in the ground. There&#8217;s only so much accessible water, drinkable water. There&#8217;s only so much land.</p>\n\n\n\n<p>It helps us understand that we have these boundaries in place. We have these limitations. So when we talk about sustainability, or when I&#8217;m talking personally talking about sustainability, I&#8217;m thinking about those concepts. I&#8217;m thinking about humanity being at the center of the planet. Being at the center of our concerns, but I&#8217;m also thinking that humanity has to live within these constraints that the world places upon us.</p>\n\n\n\n<p>And in donor economics, if you have that donut shaped circle, if I&#8217;m hoping everyone listening can picture it or maybe you&#8217;ve looked it up online. If you&#8217;ve got this kind of circle, what you have is, the way the donor economics talks about it is we talk about sustainability as being this sweet spot in the middle where we are meeting everybody&#8217;s needs to thrive. But we are doing that within the boundaries of the planet. And that it is absolutely possible that we can have nice things and that we can be happy, healthy, joyful humans, but that we can live within the means of our planet.</p>\n\n\n\n<p>So for me, sustainability is that broad concept. And I&#8217;m just going to stop there, Nathan, because I know we haven&#8217;t actually talked about this before and I&#8217;m curious to know, how that resonates with you, as a definition of sustainability or as a way of thinking about it.</p>\n\n\n\n<p>[00:17:05] <strong>Nathan Wrigley:</strong> Yeah, I fully understand where you are coming from. I guess the piece that I&#8217;m confronted with is that, I always think of, how to describe this. I very often think of conservation and I think about it in terms of we&#8217;ve got to do less things. We&#8217;ve got to drive the car less. We&#8217;ve got to consume less electricity, we&#8217;ve got to get on planes less. We&#8217;ve got to produce less.</p>\n\n\n\n<p>And so the environmental debate always, for me at least anyway, comes back to reducing what we&#8217;re doing and kind of admitting to ourselves that the aspirations that we seem to have as a species, to rampantly consume everything and believe that we are fully in charge of everything on the planet.</p>\n\n\n\n<p>It feels as if we need to put the breaks on and actually, rather than that, we need to go in reverse. We need to, like I said, produce less things, consume less things. It sounds as if you&#8217;ve got a slightly different philosophy there, which is we&#8217;ve just got to figure out how we can carry on the way we are. But with cleverer solutions so that the things that we create, the plane journeys that we go on, the cars that we drive. All of that&#8217;s still possible, but we need to figure out how the impact of that would be lessened.</p>\n\n\n\n<p>[00:18:28] <strong>Hannah Smith:</strong> Almost, yeah. That&#8217;s almost what I&#8217;m saying, but not quite. If we think about what we&#8217;re driving our cars for. What we are flying for. What are we doing these things for? It might be that the mechanism by which we create connection with one another or that we get from A to B, or that we see our family and friends, or that we have meaningful relationships with people.</p>\n\n\n\n<p>It might be that those things are done differently. And yeah, so it might mean that we reduce car use. We reduce airplane flights. But that doesn&#8217;t mean we don&#8217;t replace it with other things. Technology is amazing. I mean, look at, look at the internet. It&#8217;s absolutely incredible what digital technology enables us to do.</p>\n\n\n\n<p>So I think the story of sustainability, it&#8217;s very, very important to not get drawn into this narrative that we&#8217;ve all got to live like cave people, which is so often what people think being sustainable means. It means giving up all the things that bring us joy and bring us meaning in life.</p>\n\n\n\n<p>And actually, I don&#8217;t buy that at all. I think that that is the wrong way to look at sustainability. I actually think what living in a truly sustainable way means is reducing the things that don&#8217;t give us those joyful things. Don&#8217;t provide meaningful connection in our life, and replacing them with the things that do. And do you know what? What&#8217;s amazing is that the things that genuinely, meaningfully do improve our lives, are generally sustainable, at the same time. Like riding a bike, walking, exercising, spending less time on social media, perhaps doing more time crafting or reading a book. Those things do all actually add to our lives, add to our happiness, add to our, you know, meaning and purpose.</p>\n\n\n\n<p>So I think it&#8217;s a really important starting point just to say to the WordPress community, hey, look, being sustainable doesn&#8217;t mean we&#8217;re going to lose all these things that we love. In fact, we are going to lose the things that don&#8217;t service and replace them with better, better, more meaningful things.</p>\n\n\n\n<p>[00:20:39] <strong>Nathan Wrigley:</strong> Yeah. One of the things that I find tricky is I don&#8217;t really equate my use of the internet with the environmental consequences that there are from my use of the internet. Before we hit record, I was talking to you, I described how the technology that I&#8217;m using, so I&#8217;ve got a computer in front of me, I have a mobile phone. Unless I actually apply thought, my default in a way, is that they are completely benign and harmless. Typically, if I&#8217;m using my mobile phone say, there&#8217;s not really any part of me which is consciously thinking, okay, for every minute that I spend on this phone, there&#8217;s a consequence to this. There&#8217;s an environmental impact. I&#8217;m consuming electricity. That phone needed to be charged, and the same would go for any device, any piece of technology, any website that I visit.</p>\n\n\n\n<p>Just not bridging that gap. Whereas other things, so for example, the driving of the car. I&#8217;m acutely aware of the consequences of that because there&#8217;s things actually coming out of the rear of that car through the exhaust system that I can detect. I can feel the harm from that.</p>\n\n\n\n<p>You know? There&#8217;s no way that if you told me to go and stand behind a car for 10 minutes and breathe in deeply. There&#8217;s no way that that&#8217;s going to be something that I wish to do. I can draw a, a line between the stuff that&#8217;s coming out the exhaust, and my health and lungs, I can completely understand that. Whereas the phone, like I said, is completely benign. I could do that for hours, and so, I do think it&#8217;s an interesting thing.</p>\n\n\n\n<p>I wonder if you sense that generally speaking. When you have these discussions and you are trying to encourage people to equate internet use, technology use, whatever it may be, with the consequences of that, I&#8217;m wondering if people are generally, they&#8217;re open to it, they understand it, they draw that line themselves immediately.</p>\n\n\n\n<p>Or is there a bit of, what, hang on a minute. I&#8217;ve, I&#8217;m going to have to apply some thought to this. What do you mean? How can my, how can my computer possibly be doing any harm?</p>\n\n\n\n<p>[00:22:53] <strong>Hannah Smith:</strong> oh yeah, it&#8217;s such a good point. I mean, I can speak from my own experience as someone that has always been really interested in the environment, and really conscious of sustainability, environmentalism. And it wasn&#8217;t until I went to WordCamp Europe, when it was in Berlin actually, and Jack Lenox was giving a talk and Jack Lenox&#8217;s talk was, are website&#8217;s killing the planet? Something along those lines.</p>\n\n\n\n<p>I had this like total mad aha moment where I was like, oh my God, right? Digital tech runs on electricity. Has to be built. All that stuff&#8217;s got to come from somewhere. So of course it has an impact. But it wasn&#8217;t until I heard Jack&#8217;s talk, and also around the same sort of time, I heard Whole Grain Digital talking as well, I put two and two together.</p>\n\n\n\n<p>So it&#8217;s funny, but once, as soon as someone told me, oh yeah, you are using electricity to run this stuff. And of course electricity is mostly coming from the burning of fossil fuels, and all this stuff has to be manufactured. So all the lithium and cobalt, gold and silver and all the stuff that&#8217;s in your phone all has to come from somewhere. And that&#8217;s really energy intensive and damaging to create, or extract.</p>\n\n\n\n<p>As soon as I was given that little push in the right direction, suddenly this whole cascade of implications unfolded in front of me, and I was like, oh, well, yeah obviously, now I see it. But I, like many people, I think just need to be given that little nudge. Really helps to hear someone say that explicitly. Hey, did you know that between, see if I can get the numbers right. 1.9 and 3.3% of the world&#8217;s global greenhouse gas emissions arise from our use of digital tech.</p>\n\n\n\n<p>Did you know that that&#8217;s more than shipping and more than aviation? Did you know that that actually means that the internet becomes the world&#8217;s seventh biggest polluter is a country? When you start to hear those things, yeah, it dawns on you. And that&#8217;s certainly how I came into this space, or certainly how I kind of realized this for the first time.</p>\n\n\n\n<p>Maybe many people listening to what I&#8217;ve just said, the light bulbs have just flicked on as well and gone, oh right, yeah, of course, good point. It&#8217;s unseen, isn&#8217;t it, this pollution? To your point earlier, it&#8217;s all been abstracted away from us, so that we have clean, convenient lives. As you rightly say, you know, our phones are really sleek. Our laptops are really sleek. And that&#8217;s part of the service I suppose, that we&#8217;re being provided. We&#8217;re being given this convenience. We&#8217;re being given beautiful, well designed things. But that impact, unfortunately, is still very real at the moment. Maybe in time to come, we&#8217;ll get to a place where it&#8217;s not.</p>\n\n\n\n<p>We&#8217;ll have some new technologies that perhaps use the regenerative techniques, where we&#8217;re not extracting materials from the ground. Maybe we can start to grow them or find other ways to create them. But right now, yeah, that impact is real. Whoever came up with the term cloud really like clever, but from a sustainability angle, not helpful.</p>\n\n\n\n<p>[00:26:15] <strong>Nathan Wrigley:</strong> It&#8217;s about the most benign thing imaginable, isn&#8217;t it? It&#8217;s fluffy and, welcoming and, you know, they&#8217;re associated with the sun and all of that. Yeah, that&#8217;s interesting.</p>\n\n\n\n<p>[00:26:24] <strong>Hannah Smith:</strong> Yeah, and it&#8217;s just not true. Like actually it&#8217;s like a big diesel plume. To your point, actually the reality is 62% of the world&#8217;s energy, electricity comes from fossil fuel sources. And we can think about it as the internet is actually the world&#8217;s largest coal fired machine. When you start to have those pictures in your head, it does change your relationship to what you&#8217;re doing and what you have in front of you a bit I think.</p>\n\n\n\n<p>[00:26:51] <strong>Nathan Wrigley:</strong> And I guess that&#8217;s really the purpose of what it is that you are doing in the article that you wrote. Is you are, you&#8217;re keenly aware of this. It&#8217;s obviously something which is meaningful to you on a personal level. And you are, you&#8217;re really scouting out for ideas and suggestions and, for the community to gather around, and come up with what we can do.</p>\n\n\n\n<p>So, let&#8217;s lay out a few things in terms of WordPress. These are the things which just come into my mind as we&#8217;re sitting here talking to one another. I confess that there isn&#8217;t a great deal of backstory here. I&#8217;m just going to generate things as they come up into my mind.</p>\n\n\n\n<p>So the first thing is that our website&#8217;s dependent upon what is being presented to the end user. So, you know, if it&#8217;s a, if it&#8217;s a website, which is rich in large images. If it&#8217;s a website which is rich in video. If it&#8217;s a website which has huge amounts of JavaScript and CSS. We are pushing more bits over the wire. And so maybe there&#8217;s a piece there. Can we cut down the amount that WordPress needs to do, and needs to deliver?Would that have an impact?</p>\n\n\n\n<p>[00:28:00] <strong>Hannah Smith:</strong> Definitely.</p>\n\n\n\n<p>[00:28:02] <strong>Nathan Wrigley:</strong> Yeah. And then another thing which comes into my head is, at the end of the day when I finish with my computer, the last thing I do is I switch it off. I turn it off, and then when I need it again, I&#8217;ll switch it on and I&#8217;ll, whenever I&#8217;ve finished I turn it off again, so it&#8217;s on, off, on, off.</p>\n\n\n\n<p>What I&#8217;m trying to say is that it&#8217;s off more than It&#8217;s on. Significantly more. But our website hosting, let&#8217;s just call it that, wherever that might be, whatever system you are using. We need that to be on all the time because our websites need to be available all the time. That&#8217;s one of the points is something which is, you know, you don&#8217;t have to go to a website and be visited by a page which says, one moment, we&#8217;re just going to switch the computer on, and come back in a moment and everything will be ready to go.</p>\n\n\n\n<p>No, you want it to be ready immediately. And in fact, we&#8217;re being told all the time that the faster our webpage is being served up, the better it&#8217;s going to do in search engine rankings, which is almost like a holy grail. So everything needs to be quicker and everything needs to be more available.</p>\n\n\n\n<p>So there&#8217;s just a couple of pieces there really, which came to my head, the first one being that can we reduce the amount that WordPress has to serve up, and will that have a positive effect? And obviously that very much feels like a seesaw. You could argue that from both sides. But also the machines that our websites are running on, there&#8217;s probably quite a lot of conversations that we could have around there. The kind of things that hosting companies are doing to source the power and so on and so forth.</p>\n\n\n\n<p>[00:29:30] <strong>Hannah Smith:</strong> Yeah, I mean, it&#8217;s brilliant, isn&#8217;t it? You start to think about these things and you&#8217;ve hit upon two real, really key actionable things that we can look at within WordPress. So we&#8217;re talking at the moment about electricity and energy use, and I&#8217;m just going to sort put this into context and say, hey, don&#8217;t forget that electricity and energy use is just one aspect of sustainability. There is a little bit more to it than that.</p>\n\n\n\n<p>But I do think that when you are brand new to thinking about the impact of digital tech on sustainability, this is an absolutely awesome starting point. It&#8217;s very tangible and there&#8217;s quite a bit of research and tooling out there to help you. So I just want to kind of caveat and say, let&#8217;s deep dive into that for a little bit, awesome. But bear in mind, there&#8217;s more to think about.</p>\n\n\n\n<p>There is a very direct relationship between the amount of data that you send and the amount of CO2 emissions that that creates. So the more data to use your words, the more data, the more stuff you&#8217;re sending down the wire, the more pollution or the more energy that you&#8217;re using.</p>\n\n\n\n<p>And there&#8217;s a simple way to calculate this. For anyone that wants to get into this. If you know how much data you are sending, we can estimate how much electricity that is going to use to send that data from A to B. Whole load of assumptions that you&#8217;ll have to make in order to make that estimation.</p>\n\n\n\n<p>But there&#8217;s some models out there that you can use. You can have a look at the sustainable web design website. So if you know how much data you&#8217;ve got, you can figure out an estimation of how much electricity that would use to send from A to B. And then we can use something called carbon intensity data.</p>\n\n\n\n<p>And carbon intensity data allows us to understand how much CO2 emissions are created per unit of energy, or per unit of electricity that is created. So I mentioned to you that 62% of the worlds electricity is generated by fossil fuels. In different countries, and in different regions that will change. So I think Norway, for example, is 100% renewable energy.</p>\n\n\n\n<p>So depending on where you are in the world, you&#8217;ll have different carbon intensities to consider. But yeah, so essentially it can come down, a really good starting point is to think about performance and optimization, and think about how can I reduce the waste around this. There are dozens of reasons why we should be thinking about performance anyway.</p>\n\n\n\n<p>This is not a new ask of developers, or ask of technical people to think about performance. We have reasons around accessibility. We have reasons around cost. We also have reasons around SEO as well. The more performant and optimize something is, the better your SEO. And we also have things to think about in terms of people&#8217;s enjoyment of using said service, or said website.</p>\n\n\n\n<p>And we can add another one, another cracking good reason to think about this optimization and performance, and that is also the sustainability angle. So, I mean, really this stuff is just stacking up and stacking up to be like a no brainer. If you want to be a sustainable web developer, your first job is to get good at performance and optimization.</p>\n\n\n\n<p>[00:32:50] <strong>Nathan Wrigley:</strong> It&#8217;s interesting, the whole performance thing, while you were talking about that, I was thinking about the fact that performance really can go in two directions. The performance could be gained by cutting out waste, but it can also be gained by using more resources.</p>\n\n\n\n<p>[00:33:05] <strong>Hannah Smith:</strong> Ha ha, yes, good shout.</p>\n\n\n\n<p>[00:33:07] <strong>Nathan Wrigley:</strong> It is possible to simply say to yourself, I shall purchase more expensive hosting, which has got more CPUs and so on and so forth. And in that way, I cut out the need for me to make my website leaner, if you know what I mean. So, just to be clear, when you talk about performance, you really are talking about getting rid of the waste, considering whether that image needs to be that big or could it be smaller? Do I need to put that video on there? It&#8217;s more trimming things down as opposed to spending more money on a faster machine for example.</p>\n\n\n\n<p>[00:33:39] <strong>Hannah Smith:</strong> Interesting point. I&#8217;m really glad we&#8217;re having this conversation. Yes and no I would answer that question. 100% the yes part is definitely around the waste. Is around just not sending stuff we don&#8217;t need. Not having analytics collecting that we don&#8217;t need. Not generating data that we don&#8217;t need.</p>\n\n\n\n<p>The resources part is a really interesting one, because there&#8217;s a piece around maybe using our resources more wisely. So there can be arguments for perhaps having better hosting. Because if that better hosting, say you are serving a website across, you&#8217;ve got users all across the world visiting your website. Actually having a better hosting service that makes really good use of CDNs, content delivery networks, actually can have an impact on sustainability.</p>\n\n\n\n<p>Because if you are serving your data closer to the person that actually wants to use that data, you can save quite a bit of energy, electricity, because you&#8217;re not sending it from one side of the world to the other. And there is an electricity cost to doing that. Again, it&#8217;s not seen by us, but it&#8217;s real. It is there.</p>\n\n\n\n<p>So the service side, the hosting side of things. Something very specific you can do there is look for hosting companies that are using renewable energy, using renewable energy sources to power themselves. And I&#8217;m going to plug the Green Web Foundation where I&#8217;m working now.</p>\n\n\n\n<p>We have a really awesome data set, which we&#8217;ve been collecting for 10 years or so on hosting companies that are powered by renewables. That&#8217;s a very specific action you can take. But yeah, to your point that you can make something really performant by chucking loads of resources at it. Yeah, that&#8217;s not what we are talking about here when we are talking about sustainability. We are talking about speeding things up through the use of wise resources instead.</p>\n\n\n\n<p>[00:35:36] <strong>Nathan Wrigley:</strong> I know that time is pressing for you, so we&#8217;ll wrap up fairly shortly, but I just want to, just want to offer a few thoughts as well, and, the piece that I mentioned towards the beginning of the podcast where I said that, it&#8217;s very difficult I think for me, and I&#8217;m sure a lot of other people as well, to draw the line between the website and the impact on the environment, and I&#8217;m wondering if it might be that we need to be alerted to the consequences of our use of the internet.</p>\n\n\n\n<p>So just throwing out some ideas, which probably, may very well have no legs, but just some thoughts really. Would be interesting, for example, if in the WordPress backend we could see something which gave us a measure of what it was that our website was doing. So if it gave us a direct link to okay, every, every time somebody comes to this particular page, this is what you are sending to them, and that has this kind of consequence.</p>\n\n\n\n<p>Now, obviously, that&#8217;s much more complicated, as you&#8217;ve described, because it depends on the hosting that you&#8217;re using. It depends whether they&#8217;re close or far away. But just some sort of broad metrics so that we could understand what the consequence of the thing that we&#8217;re building is. So I don&#8217;t even know what that would look like. Maybe it would be some sort of graph or chart or just raw number that would give us some indication.</p>\n\n\n\n<p>And then also more broadly, just browsing the internet. If we could have this kind of information coming back to us. So, I don&#8217;t know, I&#8217;m thinking of like a browser extension or something like that, which would measure what it was that I was doing when I went around the internet, and then give me some kind of feedback for, okay, this week you consumed this much in terms of electricity or carbon that was produced as a result of your browsing the internet.</p>\n\n\n\n<p>Last week it was this, the week before it was this, so you know you&#8217;re going in the right direction. Just those kind of things. I&#8217;m just wondering if there are things afoot. Maybe tools that exist already, or projects that you know about that can help us to understand the consequences of what we are doing.</p>\n\n\n\n<p>[00:37:39] <strong>Hannah Smith:</strong> Definitely, and do you know what Nathan? These ideas absolutely have legs and these are exactly the kind of ideas that we are inviting people to come and share on our post with us. All of these suggestions, all of these ideas are relevant and very, very actionable, and have already been actioned in certain ways.</p>\n\n\n\n<p>So to your point about CO2, understanding CO2 emissions of websites, so there&#8217;s a fantastic tool called Website Carbon Calculator. I think the URL is websitecarbon.com. So you can go along to that and put any URL in, and immediately get a sense of how polluting that page is. And that is such an awesome tool to use with bosses or clients, who perhaps aren&#8217;t so interested in the nitty gritty technical detail, but want a number, or a statistic or a sense of how good or bad they&#8217;re doing.</p>\n\n\n\n<p>And the Website Carbon Calculator has a little bit of JavaScript code that you can embed in your site that will give you a reading of each page of how much CO2 that that page is polluting. Now I believe that there is a plugin for that as well, and I don&#8217;t know if that would give you the information in the back end of WordPress, but Website Carbon Calculator&#8217;s being developed by Whole Grain Digital. If you&#8217;re interested in WordPress sustainability, I mean, they&#8217;re really thought leaders in this space, so definitely worth checking them out.</p>\n\n\n\n<p>I had some conversations with Jenny Wong many years ago, and, and those of you that are in the UK WordPress community, you&#8217;ll probably know Jenny. I think most people do. And if you&#8217;re listening, Jenny, hello. Jenny and I exchanged some ideas around using Site Health, and actually building some of these ideas into Site Health. That section of the WordPress backend. It might be difficult to get that as a core contribution to begin with, but we could certainly look at making some plugins.</p>\n\n\n\n<p>There&#8217;s loads and loads of data out there that we could use to surface these emissions. And then to your point about browsers, yes. Actually at the Green Web Foundation, we&#8217;ve been talking quite a lot with the Firefox people, made by Mozilla. And there are some open issues in GitHub at the moment around integrating carbon emission readings and estimations into the Firefox browser.</p>\n\n\n\n<p>I don&#8217;t know off the top of my head whether the intention would be to track it in the way that you&#8217;ve talked, but you know how if you&#8217;re a developer, you, you might be familiar with the web dev tooling that we have, say within Firefox or Chrome. The idea is to create a separate tab in the performance section, to start to give you a reading within the browser as well.</p>\n\n\n\n<p>So there are all these things happening, and this is where I really want to invite people to come and join us. Please let us share these initiatives that are happening. If you&#8217;ve got some time and capacity and you&#8217;ve got some energy, and you want to take action, we desperately want people to come and join in, and make these things happen. So yeah, please share these ideas that you have.</p>\n\n\n\n<p>[00:40:49] <strong>Nathan Wrigley:</strong> Thank you. Yeah, that&#8217;s really, really interesting. Just before we wrap it up finally, it just occurs to me that we&#8217;re always looking for ways to, to have a competitive edge. If you are a freelancer or an agency, you&#8217;re always trying to figure out ways that you are different from your competition. And it just strikes me that maybe this, maybe this could be one of those ways. You are one of the developers who actually gives this some thought. And it may very well be that there are a whole load of clients out there for whom this would be a very important metric when making hiring decisions, so.</p>\n\n\n\n<p>[00:41:24] <strong>Hannah Smith:</strong> Such a good point. As a freelance WordPress developer, uh, you know, people were, were starting to know me as someone who knew about digital sustainability and who could build sustainable WordPress sites, you know, efficient WordPress sites. And the demand was mad. I couldn&#8217;t keep up with it. I was constantly being like, oh, I need more people to recommend this work to. So yeah, I think this is a really strong selling point, and it makes you feel good as well, to know that you&#8217;re doing the best you can, you&#8217;re doing the right things.</p>\n\n\n\n<p>[00:41:55] <strong>Nathan Wrigley:</strong> Hannah, just as a very final thing. If people have been interested in this, I will obviously link to the post in the show notes. You can check those out on wptavern.com, but if they want to contact you, are you available? And if so, where should we do that? What&#8217;s the best way to reach out to you?</p>\n\n\n\n<p>[00:42:12] <strong>Hannah Smith:</strong> Yeah, well, I mean, I would love to chat with anyone that&#8217;s interested in bouncing some ideas around, or is interested in finding out more. The best way to get hold of me is through the Green Web Foundation, so hannah@thegreenwebfoundation.org, or if you&#8217;re in make WordPress you can also drop me a line. You&#8217;ll see me lurking around in the sustainability channel quite a lot in the make WordPress Slack space. You can drop me a line there too.</p>\n\n\n\n<p>[00:42:38] <strong>Nathan Wrigley:</strong> Hannah Smith, thank you very much for joining us on the podcast.</p>\n\n\n\n<p>[00:42:41] <strong>Hannah Smith:</strong> Oh, thank you Nathan. Thank you for making time for this today. I really appreciate it.</p>\n</div>\n\n\n\n<p>On the podcast today, we have <a href=\"https://profiles.wordpress.org/hanopcan/\">Hannah Smith</a>.</p>\n\n\n\n<p>Hannah is the Operations and Training Manager for the <a href=\"https://www.thegreenwebfoundation.org/\">Green Web Foundation</a> and founder of the <a href=\"https://climateaction.tech/projects/letsgreentheweb-campaign/\">Let’s Green The Web campaign</a>. She’s also co-founder of <a href=\"https://greentechsouthwest.org/\">Green Tech South West</a>.</p>\n\n\n\n<p>Her background is in Computer Science. She previously worked as a freelance WordPress developer, and also for the Environment Agency, where she managed large business change projects.</p>\n\n\n\n<p>It’s pretty easy to forget that the device that you’re reading this post on is consuming power. We plug things in or charge them up, and they just work. They are sleek and sterile. No pollution comes out of the device directly. In fact, I’d go as far as to say that many of us never make the connection between our use of technology and the impact this has on the environment.</p>\n\n\n\n<p>Enter Hannah Smith. She’s been thinking about this for years and is on the podcast today to highlight the issue, and hopefully get your ideas about what users of WordPress can do to make sure that the websites we create are having the smallest impact possible.</p>\n\n\n\n<p>Her approach is not that we need to cease and desist using our technology. Rather, it’s about coming up with new and innovative ways that we can reduce the impact that we have.</p>\n\n\n\n<p>As creators of websites, there are a whole raft of options available to us. Reducing the size of our images. Inspecting the HTML to remove bloat. Choosing hosting options that source renewable energy.</p>\n\n\n\n<p>With this in mind, Hannah and others have been working on a sustainability related <a href=\"https://make.wordpress.org/project/2022/11/01/sustainability-channel-what-should-we-do/#comment-162\">blog post</a> which has been published on the Make WordPress site this week.</p>\n\n\n\n<p>This post is intended to trigger meaningful and open discussion in the global WordPress community about the topic of sustainability. She really wants to encourage others to weigh into this public conversation with their own thoughts, so we can build on what is already happening to make WordPress more sustainable.</p>\n\n\n\n<p>It’s a fascinating and thought-provoking topic.</p>\n\n\n\n<h2>Useful links.</h2>\n\n\n\n<p><a href=\"https://www.thegreenwebfoundation.org/\">The Green Web Foundation website</a></p>\n\n\n\n<p><a href=\"https://climateaction.tech/projects/letsgreentheweb-campaign/\">#Let&#8217;sGreenTheWeb Campaign</a></p>\n\n\n\n<p><a href=\"https://www.wholegraindigital.com/\">Wholegrain Digital website</a></p>\n\n\n\n<p><a href=\"https://sustainablewebdesign.org/\">Sustainable Web Design website</a></p>\n\n\n\n<p><a href=\"https://www.websitecarbon.com/\">Website Carbon Calculator</a></p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Wed, 23 Nov 2022 15:00:00 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:14:\"Nathan Wrigley\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:15;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:103:\"WPTavern: BuddyPress 11.0.0 to Limit JavaScript and CSS Asset Loading to Community Pages Using a Filter\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:30:\"https://wptavern.com/?p=139798\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:114:\"https://wptavern.com/buddypress-11-0-0-to-limit-javascript-and-css-asset-loading-to-community-pages-using-a-filter\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:3241:\"<p>BuddyPress will soon be <a href=\"https://bpdevel.wordpress.com/2022/11/21/buddypress-will-soon-only-load-its-javascript-and-style-assets-into-the-community-area-of-your-site/\">improving the way it loads its JavaScript and CSS assets</a> so that they are only loaded on community pages. Previously, the plugin would load them indiscriminately on every page.</p>\n\n\n\n<p>BuddyPress lead developer Mathieu Viet said he&#8217;s not sure there is a specific reason explaining why this was kept in place. Before the plugin <a href=\"https://buddypress.org/2013/04/buddypress-1-7-is-now-available/\">introduced the BP Theme Compat API</a> in version 1.7, it was necessary to use a BuddyPress compatible theme like the one bundled by default (<a href=\"https://github.com/buddypress/BP-Default\">BP Default</a>).</p>\n\n\n\n<p>&#8220;I think we kept the way this theme was loading these assets into the first Template Pack (BP Legacy) we added to BuddyPress,&#8221; Viet said.</p>\n\n\n\n<p>Users have often requested BuddyPress only load its assets on community pages in hopes of further optimizing their websites. For example, in 2020, a user on the BuddyDev forums <a href=\"https://buddydev.com/support/forums/topic/how-to-load-buddypress-scripts-styles-only-on-buddypress-pages/\">requested custom code</a> to accomplish this. Experts recommended against doing it</p>\n\n\n\n<p>&#8220;It is not going to help you much and will cause a lot of issues in future,&#8221; BuddyPress contributor Brajesh Singh said. &#8220;There are dependent plugins which may start throwing JavaScript errors and breaking some of your site functionality. It is not worth the effort.&#8221;</p>\n\n\n\n<p>Singh recommended the user enable browser caching to avoid loading the assets multiple times and stick to best practices for enabling gzip compression and other optimization measure. He also recommended adding a plugin that would conditionally prevent loading BuddyPress on certain pages.</p>\n\n\n\n<p>Coming in version 11.0.0, BuddyPress core will progressively move towards loading only the assets it needs in community areas. This update will still load JS and CSS everywhere but will offer a filter that users can add to their <a href=\"https://codex.buddypress.org/themes/bp-custom-php/\">bp-custom.php</a> files in order to keep BP assets on community pages only:</p>\n\n\n\n<blockquote class=\"wp-block-quote\">\n<p>add_filter( &#8216;bp_enqueue_assets_in_bp_pages_only&#8217;, &#8216;__return_true&#8217; );</p>\n</blockquote>\n\n\n\n<p>&#8220;If using the above filter, you notice something is going wrong with your website due to the use of a specific BP plugin or theme, <a href=\"https://buddypress.trac.wordpress.org/newticket\">report it here</a> and we’ll then have another development cycle to fix things before we completely restrict these assets to BuddyPress generated pages in a second step in version 12.0.0,&#8221; Viet said.</p>\n\n\n\n<p>Version 11.0.0 is expected to be released on December 14, 2022. Early adopters and BuddyPress site owners who have always wished for the plugin to behave this way can take advantage of it after the next major update using the filter. The filter can also be easily removed if users are troubleshooting and having issues with plugins. </p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Wed, 23 Nov 2022 00:28:57 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Sarah Gooding\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:16;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:60:\"WPTavern: New Tool Checks If Google Fonts Are Hosted Locally\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:30:\"https://wptavern.com/?p=139780\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:71:\"https://wptavern.com/new-tool-checks-if-google-fonts-are-hosted-locally\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:3462:\"<p>Earlier this year, WordPress&#8217; Themes Team began urging theme authors to <a href=\"https://wptavern.com/wordpress-org-strongly-urges-theme-authors-to-switch-to-locally-hosted-webfonts\">switch to locally hosted fonts</a> after a German court case decision, which <a href=\"https://wptavern.com/german-court-fines-website-owner-for-violating-the-gdpr-by-using-google-hosted-fonts\">fined a website owner for violating the GDPR by using Google-hosted webfonts</a>. Since that ruling, German website owners have <a href=\"https://www.reddit.com/r/de_EDV/comments/xm6803/abmahnung_bzgl_dsgvoversto%C3%9F_wg_angeblicher/\">continued to receive threats of fines</a> for not having their fonts hosted locally. </p>\n\n\n\n<p>The makers of the <a href=\"https://fontsplugin.com/\">Fonts Plugin</a>, a commercial product with a free version on WordPress.org, have created a tool called <a href=\"https://fontsplugin.com/google-fonts-checker/\">Google Fonts Checker</a> that will help website owners discover where their fonts are hosted. The tool analyzes any URL entered and if the fonts are hosted by Google, it says &#8220;Google Fonts Connection Found&#8221; with a red &#8216;X.&#8217; Sites that are in the clear will show a notice that a Google Fonts connection was not found:</p>\n\n\n\n<img />\n\n\n\n<p>Google Fonts Checker is useful for non-technical users who are not sure whether their theme or plugins are referencing fonts hosted on Google&#8217;s servers. Beyond delivering the simple connection message, the tool scans the website and returns a list of the font files used to render the page, which can be helpful in tracking down the specific extension loading these files.</p>\n\n\n\n<p>More than 200,000 people are using the <a href=\"https://wordpress.org/plugins/olympus-google-fonts/\">Fonts Plugin</a> to load assets from the Google Fonts Library. Although the Google Fonts Checker tool is free to use and doesn&#8217;t require any personal information or login, the free version of the Fonts Plugin doesn&#8217;t support hosting fonts locally. Users will either need to upgrade to the commercial version or use a different plugin, like <a href=\"https://wordpress.org/plugins/local-google-fonts/\">Local Google Fonts</a> or the <a href=\"https://wordpress.org/plugins/host-webfonts-local/\">OMGF | Host Google Fonts Locally</a> plugin, both of which perform this for free.</p>\n\n\n\n<p>Those who find a Google Fonts connection using the tool may also consider switching to <a href=\"https://fonts.bunny.net/\">Bunny Fonts</a>, an open-source, privacy-first web font platform with no tracking or logging that is fully GDPR compliant. It can act as a drop-in replacement to Google Fonts. The <a href=\"https://wordpress.org/plugins/replace-google-fonts-with-bunny-fonts/\">Replace Google Fonts with Bunny Fonts</a> plugin makes it easy to switch.</p>\n\n\n\n<p>Some of WordPress&#8217; older default themes are still loading fonts from Google. A <a href=\"https://core.trac.wordpress.org/ticket/55985\">ticket</a> for bundling the fonts with the legacy default themes had patches and was on track to be included in WordPress 6.1, but ended up getting <a href=\"https://wptavern.com/wordpress-punts-locally-hosted-fonts-for-legacy-default-themes-to-6-2-release\">punted to a future release</a> after it was determined the approach needed more work. In the meantime, those who are concerned about using Google Fonts in older default themes can use a plugin to host them locally.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Tue, 22 Nov 2022 21:49:59 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Sarah Gooding\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:17;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:59:\"WordPress.org blog: The Month in WordPress – October 2022\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:35:\"https://wordpress.org/news/?p=13988\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:71:\"https://wordpress.org/news/2022/11/the-month-in-wordpress-october-2022/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:12235:\"<p>With the end of the year fast approaching, the WordPress project has not slowed down. Read on to learn more about the latest major release, WordPress 6.1, and the State of the Word 2022 live event, among other exciting news. It&#8217;s time to catch up on all things WordPress!</p>\n\n\n\n<hr class=\"wp-block-separator has-css-opacity\" />\n\n\n\n<h2>Say hello to WordPress 6.1 “Misha”</h2>\n\n\n\n<p>The third and last major release of 2022, <a href=\"https://wordpress.org/news/2022/11/misha/\"><strong>WordPress 6.1 “Misha,”</strong></a> shipped on November 1, 2022. Named after jazz pianist <strong>Mikhail “Misha” Alperin</strong>, this release comes packed with many improvements that refine the site-building experience introduced earlier this year in WordPress 5.9 and 6.0, as well as <a href=\"https://make.wordpress.org/core/2022/10/11/wordpress-6-1-accessibility-improvements/\">accessibility</a> and <a href=\"https://make.wordpress.org/core/2022/10/11/performance-field-guide-for-wordpress-6-1/\">performance</a> upgrades.</p>\n\n\n\n<p>WordPress 6.1 is also bundled with a new default block theme, <a href=\"https://wordpress.org/news/2022/11/introducing-twenty-twenty-three/\">Twenty Twenty-Three (TT3)</a>, that features <strong>10 style variations</strong> designed by WordPress community members. These intentionally unique designs ensure that you can change the visual details of your site with ease—and within a single theme.</p>\n\n\n\n<div class=\"wp-block-embed__wrapper\">\n\n</div>\n\n\n\n<p>Learn more about what&#8217;s in 6.1:</p>\n\n\n\n<ul>\n<li><a href=\"https://wordpress.org/news/2022/11/misha/\">WordPress 6.1 “Misha” Announcement</a></li>\n\n\n\n<li><a href=\"https://make.wordpress.org/core/2022/10/12/wordpress-6-1-field-guide/\">WordPress 6.1 Field Guide</a></li>\n</ul>\n\n\n\n<p>Following WordPress 6.1 “Misha”, a <a href=\"https://wordpress.org/news/2022/11/wordpress-6-1-1-maintenance-release/\">6.1.1 maintenance release</a> landed on November 15, 2022. This minor release includes about 50 bug fixes.</p>\n\n\n\n<blockquote class=\"wp-block-quote has-extra-large-font-size\">\n<p><a href=\"https://wordpress.org/download/\">Download WordPress 6.1.1</a></p>\n</blockquote>\n\n\n\n<div class=\"wp-block-spacer\"></div>\n\n\n\n<h2>State of the Word 2022 is coming on December 15</h2>\n\n\n\n<img width=\"1024\" height=\"683\" src=\"https://i0.wp.com/wordpress.org/news/files/2022/11/Web-SOTW-Image-1200x800-1.png?resize=1024%2C683&ssl=1\" alt=\"Decorative blue background with text: \" />\n\n\n\n<p><strong>State of the Word 2022</strong>, the annual keynote address delivered by the WordPress project’s co-founder, Matt Mullenweg, will be held on <strong>December 15, 2022</strong>. The event will take place in person in New York City and live-streamed via various WordPress.org social media platforms.</p>\n\n\n\n<p>You can also host or join a <a href=\"https://make.wordpress.org/community/handbook/meetup-organizer/state-of-the-word-watch-parties/\">State of the Word watch party</a> to enjoy the event with your WordPress friends.</p>\n\n\n\n<blockquote class=\"wp-block-quote has-extra-large-font-size\">\n<p><a href=\"https://wordpress.org/news/2022/11/state-of-the-word-2022/\">Learn more about State of the Word 2022</a></p>\n</blockquote>\n\n\n\n<div class=\"wp-block-spacer\"></div>\n\n\n\n<h2>What’s new in Gutenberg</h2>\n\n\n\n<p>Two new versions of Gutenberg have shipped in the last month:</p>\n\n\n\n<ul>\n<li><a href=\"https://make.wordpress.org/core/2022/10/27/whats-new-in-gutenberg-14-4-26-october/\"><strong>Gutenberg 14.4</strong></a> was released on October 26, 2022, with support for a distraction-free mode that allows a more focused writing experience. Other notable highlights include a redesigned pattern inserter, content locking to the Navigation block, and improvements to fluid typography.</li>\n\n\n\n<li><a href=\"https://make.wordpress.org/core/2022/11/09/whats-new-in-gutenberg-14-5-9-november/\"><strong>Gutenberg 14.5</strong></a> sets the groundwork for future releases with code quality improvements and bug fixes. This version introduces a new “Document Overview” panel for easier access to the list view and document information, expands margin and padding support, and improves spacing visualizers. It was released on November 9, 2022.</li>\n</ul>\n\n\n\n<blockquote class=\"wp-block-quote has-extra-large-font-size\">\n<p>Explore some of the latest enhancements to the writing experience in <a href=\"https://make.wordpress.org/core/2022/10/28/core-editor-improvement-advancing-the-writing-experience/\">this Core Editor Improvement post</a>.</p>\n</blockquote>\n\n\n\n<div class=\"wp-block-spacer\"></div>\n\n\n\n<h2>Team updates: Documentation Contributor Day, WordPress.org redesign updates, and more</h2>\n\n\n\n<ul>\n<li>After a <a href=\"https://make.wordpress.org/core/2022/07/27/giving-fse-a-more-user-friendly-name/\">lively discussion</a> around the site editing terminology, WordPress Executive Director Josepha Haden Chomphosy <a href=\"https://make.wordpress.org/updates/2022/11/04/site-editor-a-more-user-friendly-name/\">announced that the term &#8220;Site Editor&#8221; will be used going forward</a> in reference to the suite of site editing tools.</li>\n\n\n\n<li>Last month, the Docs Team successfully held its <a href=\"https://make.wordpress.org/docs/2022/10/28/the-documentation-team-contributor-day-summary/\">first online Contributor Day</a> to collaborate in real-time, help onboard new contributors, and work on backlog tasks.</li>\n\n\n\n<li>Progress and next steps for the WordPress.org website redesign were shared <a href=\"https://make.wordpress.org/meta/2022/10/21/wordpress-org-redesign-update/\">in this post</a>. The following pages that will get a refreshed look and feel soon include <a href=\"https://make.wordpress.org/design/2022/11/11/a-refresh-of-wordpress-org-showcase/\">Showcase</a> and <a href=\"https://make.wordpress.org/docs/2022/10/19/new-design-for-helphub-in-wordpress-org/\">Documentation (HelpHub)</a>.</li>\n\n\n\n<li>The WordPress.org Theme Directory <a href=\"https://make.wordpress.org/meta/2022/10/20/displaying-style-variations-for-supporting-themes/\">introduced a new feature</a> that allows visitors to preview style variations in block themes.</li>\n\n\n\n<li>Inspired by the Community Team’s efforts to reactivate meetup groups, the Polyglots Team is looking to start a <a href=\"https://make.wordpress.org/polyglots/2022/11/08/starting-a-polyglots-outreach-effort/\">Polyglots outreach project</a> and welcomes help.</li>\n\n\n\n<li>The Training Team shared an <a href=\"https://make.wordpress.org/training/2022/11/01/summary-update-courses-currently-in-development-1-november-2022/\">overview of some of the new Learn WordPress courses</a> they have been recently working on.</li>\n\n\n\n<li>Openverse’s catalog now includes <a href=\"https://make.wordpress.org/openverse/2022/11/16/openverse-now-includes-over-1-million-audio-records/\">more than one million audio records</a>!</li>\n\n\n\n<li>The WordPress Photo Directory also reached a significant milestone by surpassing 5,000 photos! <a href=\"https://make.wordpress.org/photos/2022/11/17/the-road-to-5000-photos-a-retrospective/\">Check out this celebratory retrospective from the Photos team</a>.</li>\n\n\n\n<li>Speaking of Openverse and the Photo Directory, <a href=\"https://wordpress.org/news/2022/11/episode-43-openverse-photo-directory-what-are-they-and-how-are-they-different/\">don’t miss the latest episode of the WP Briefing podcast</a>—it covers the differences between these two resources, and how they work to further openly-licensed media.</li>\n\n\n\n<li>The latest edition of People of WordPress features <a href=\"https://wordpress.org/news/2022/10/people-of-wordpress-raghavendra-satish-peri/\">Raghavendra Satish Peri</a>.</li>\n</ul>\n\n\n\n<blockquote class=\"wp-block-quote has-extra-large-font-size\">\n<p>Enjoy a spooky Halloween Mad Libs story completed by community contributors in <a href=\"https://wordpress.org/news/2022/10/episode-42-something-spooky-this-way-comes/\">Episode 42 of WP Briefing</a>.</p>\n</blockquote>\n\n\n\n<div class=\"wp-block-spacer\"></div>\n\n\n\n<h2>Feedback &amp; testing requests</h2>\n\n\n\n<ul>\n<li>The <a href=\"https://make.wordpress.org/core/2022/10/12/call-for-testing-plugin-dependencies/\">Plugin Dependencies feature plugin is available for testing</a>. Provide your feedback by December 1, 2022.</li>\n\n\n\n<li>What does a genuinely sustainable WordPress community look like to you? Share your vision and thoughts in <a href=\"https://make.wordpress.org/project/2022/11/01/sustainability-channel-what-should-we-do/\">this discussion post</a>.</li>\n\n\n\n<li>The new WordPress developer blog is in public beta and <a href=\"https://make.wordpress.org/core/2022/11/21/wordpress-developer-blog-is-in-public-beta/\">ready for feedback</a>.</li>\n\n\n\n<li>The Core Team requests assistance with <a href=\"https://make.wordpress.org/hosting/2022/10/19/call-for-action-testing-rollback-feature/\">testing a new Rollback Feature in WordPress core</a>.</li>\n\n\n\n<li>Version 21.2 of the WordPress mobile app for <a href=\"https://make.wordpress.org/mobile/2022/11/15/call-for-testing-wordpress-for-android-21-2/\">Android</a> and <a href=\"https://make.wordpress.org/mobile/2022/11/14/call-for-testing-wordpress-for-ios-21-2/\">iOS</a> is available for testing.</li>\n</ul>\n\n\n\n<blockquote class=\"wp-block-quote has-extra-large-font-size\">\n<p>Were you involved in WordPress 6.1? <a href=\"https://make.wordpress.org/core/2022/11/09/wordpress-6-1-misha-retrospective/\">Share your thoughts</a> on the release process by December 15, 2022.</p>\n</blockquote>\n\n\n\n<div class=\"wp-block-spacer\"></div>\n\n\n\n<h2>Event updates &amp; WordCamps</h2>\n\n\n\n<ul>\n<li>The WordCamp Asia organizing team is collaborating with WordCamp Central to bring the <a href=\"https://asia.wordcamp.org/2023/apply-for-wordcamp-asia-diversity-scholarship/\">WordCamp Asia Diversity Scholarship</a>. In addition, the team recently announced the <a href=\"https://asia.wordcamp.org/2023/speakers-announcement-round-1/\">first round of speakers</a>.</li>\n\n\n\n<li>Preparations for <a href=\"https://europe.wordcamp.org/2023/the-preparations-for-wordcamp-europe-2023-have-begun/\">WordCamp Europe 2023</a> are underway.</li>\n\n\n\n<li>Don’t miss these upcoming WordCamps:\n<ul>\n<li><img src=\"https://s.w.org/images/core/emoji/14.0.0/72x72/1f1e7-1f1f7.png\" alt=\"🇧🇷\" class=\"wp-smiley\" /> <a href=\"https://saopaulo.wordcamp.org/2022/\">WordCamp São Paulo</a>, Brazil on November 26, 2022</li>\n\n\n\n<li><img src=\"https://s.w.org/images/core/emoji/14.0.0/72x72/1f1ee-1f1f3.png\" alt=\"🇮🇳\" class=\"wp-smiley\" /> <a href=\"https://kolkata.wordcamp.org/2022/\">WordCamp Kolkata</a>, West Bengal, India on December 17-18, 2022</li>\n</ul>\n</li>\n</ul>\n\n\n\n<blockquote class=\"wp-block-quote has-extra-large-font-size\">\n<p>Boost your speaking confidence in WordPress events. Register for the <a href=\"https://www.eventbrite.com/e/how-to-own-your-expertise-start-speaking-at-wordpress-events-wpdiversity-tickets-462153532657\">How to Own Your Expertise &amp; Start Speaking at WordPress Events</a> online workshop happening December 7, 2022.</p>\n</blockquote>\n\n\n\n<div class=\"wp-block-spacer\"></div>\n\n\n\n<hr class=\"wp-block-separator has-css-opacity\" />\n\n\n\n<p><strong><em><strong><em><strong><em>Have a story that we should include in the next issue of The Month in WordPress? <strong><em>Fill out </em></strong><a href=\"https://make.wordpress.org/community/month-in-wordpress-submissions/\"><strong><em>this quick form</em></strong></a><strong><em> to let us know.</em></strong></em></strong></em></strong></em></strong></p>\n\n\n\n<p><em><em>The following folks contributed to this edition of The Month in WordPress:</em> <a href=\"https://profiles.wordpress.org/rmartinezduque/\" class=\"mention\"><span class=\"mentions-prefix\">@</span>rmartinezduque</a>, <a href=\"https://profiles.wordpress.org/webcommsat/\" class=\"mention\"><span class=\"mentions-prefix\">@</span>webcommsat</a>, <a href=\"https://profiles.wordpress.org/santanainniss/\" class=\"mention\"><span class=\"mentions-prefix\">@</span>santanainniss</a>, <a href=\"https://profiles.wordpress.org/dansoschin/\" class=\"mention\"><span class=\"mentions-prefix\">@</span>dansoschin</a>, <a href=\"https://profiles.wordpress.org/eidolonnight/\" class=\"mention\"><span class=\"mentions-prefix\">@</span>eidolonnight</a>.</em></p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Tue, 22 Nov 2022 11:00:00 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:14:\"rmartinezduque\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:18;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:65:\"Do The Woo Community: Building a Cloud-Based SaaS versus Hosted \";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:28:\"https://dothewoo.io/?p=73737\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:62:\"https://dothewoo.io/building-a-cloud-based-saas-versus-hosted/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:377:\"<p>Learn why NitroPack made the decision to go cloud-based vs. self hosted with the SasS product. </p>\n<p>&gt;&gt; The post <a rel=\"nofollow\" href=\"https://dothewoo.io/building-a-cloud-based-saas-versus-hosted/\">Building a Cloud-Based SaaS versus Hosted </a> appeared first on <a rel=\"nofollow\" href=\"https://dothewoo.io\">Do the Woo - a WooCommerce Builder Community</a>	.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Tue, 22 Nov 2022 10:18:00 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:5:\"BobWP\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:19;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:51:\"WPTavern: WordPress Launches Developer Blog In Beta\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:30:\"https://wptavern.com/?p=139729\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:62:\"https://wptavern.com/wordpress-launches-developer-blog-in-beta\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:3318:\"<img />\n\n\n\n<p>WordPress.org will soon be launching a <a href=\"https://developer.wordpress.org/news/\">blog for developers</a>. The blog went into beta at the end of last week and resides on a subdomain of the main site. It is sporting a design similar to WordPress&#8217; general News blog.</p>\n\n\n\n<p>One of the <a href=\"https://make.wordpress.org/project/2022/01/21/big-picture-goals-2022/\">big picture goals</a> that WordPress&#8217; Executive Director Josepha Haden-Chomphosy identified for 2022 was the creation of a developer-focused communications site. This new blog is the culmination of an effort that began earlier this year.</p>\n\n\n\n<p>&#8220;Staying on top of the new features coming to the WordPress open-source project is one of the main barriers expressed by developers,&#8221; contributor Birgit Pauli-Haack said in the original <a href=\"https://make.wordpress.org/core/2022/02/25/proposal-to-start-a-news-blog-on-developer-wordpress-org/\">proposal</a>.</p>\n\n\n\n<p>&#8220;The Make Core blog has a heavy emphasis on meeting notes for the various core teams, rather than highlighting new features. This makes it difficult for developers who are not contributors or who just occasionally contribute to find the relevant information among the team-related posts.&#8221;</p>\n\n\n\n<p>Content on the new developer blog will be focused on updates applicable to theme and plugin creators, developers who work at agencies, Gutenberg API updates, advanced programming concepts, PHP gems, and developer case studies. </p>\n\n\n\n<p> There are already three posts published, which offer a hint at what kind of content WordPress developers can expect on the blog:</p>\n\n\n\n<ul>\n<li><a href=\"https://developer.wordpress.org/news/2022/11/18/how-to-extend-wordpress-via-the-slotfill-system/\">How to extend WordPress via the SlotFill system</a></li>\n\n\n\n<li><a href=\"https://developer.wordpress.org/news/2022/11/17/demystifying-home-and-posts-templates-in-wordpress-theme-development/\">Demystifying Home and Posts Templates in WordPress theme development</a></li>\n\n\n\n<li><a href=\"https://developer.wordpress.org/news/2022/11/17/creating-themes-from-a-pattern-first-mindset/\">Creating Themes from a Pattern-First Mindset</a></li>\n</ul>\n\n\n\n<p>The blog&#8217;s editorial process is being entirely <a href=\"https://github.com/WordPress/developer-blog-content\">managed on GitHub</a> from pitches to publication. Anyone who wants to contribute can post to the <a href=\"https://github.com/WordPress/developer-blog-content/discussions/categories/ideas\">Ideas board</a> for discussion. Approved ideas become blessed tasks and drafts and go through two reviews. People can contribute by posting ideas, writing posts, or joining the editorial team that reviews posts.</p>\n\n\n\n<p>Now that the blog is in beta, contributors are looking for feedback from WordPress&#8217; developer community. Leave comments on the <a href=\"https://make.wordpress.org/core/2022/11/21/wordpress-developer-blog-is-in-public-beta/\">beta announcement</a> or join the next meeting  in the <a href=\"https://wordpress.slack.com/archives/C03RL47B3S8\">core-dev-blog</a> WP Slack channel on December 1, at 13:00 UTC. <a href=\"https://developer.wordpress.org/news/feed/\">Subscribe to the RSS feed</a> to never miss a post from WordPress&#8217; new developer blog.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Tue, 22 Nov 2022 03:10:56 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Sarah Gooding\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:20;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:87:\"WPTavern: State of the Word 2022 Will Be Livestreamed from New York City on December 15\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:30:\"https://wptavern.com/?p=139734\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:98:\"https://wptavern.com/state-of-the-word-2022-will-be-livestreamed-from-new-york-city-on-december-15\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:2961:\"<p>Matt Mullenweg&#8217;s annual <a href=\"https://wordpress.org/news/2022/11/state-of-the-word-2022/\">State of the Word</a> (SOTW) address will be delivered in New York City this year before a live audience, on December 15. The event format is similar to last year where a small group of invited guests will join in person. </p>\n\n\n\n<p>Traditionally, the State of the Word has been given at WordCamp US, capping off the event with an inspiring review of WordPress&#8217; progress and a lively Q&amp;A session. Starting in 2020, due to the pandemic, the SOTW transitioned to a separate, smaller event that can be broadcast to all who cannot attend. Organizers are planning to livestream this year&#8217;s event across WordPress.org&#8217;s social media platforms. </p>\n\n\n\n<p>Unlike last year, where prominent members of the community were invited to attend, organizers have created a form where anyone can <a href=\"https://wordcampcentral.survey.fm/request-a-seat-sotw-2022\">request an invitation to attend</a>. Seats are available to the public on a first-come, first-served basis. The form states that masks will not be required at the event, a policy that is as controversial today as it was last year, and makes it impossible for medically vulnerable people to attend:</p>\n\n\n\n<blockquote class=\"wp-block-quote\">\n<p>&#8220;While at the event, masks are not mandatory but encouraged, as is using hand sanitizer and social distancing.&#8221;</p>\n</blockquote>\n\n\n\n<p>Since the majority of people will be watching via live stream, the Q&amp;A portion of the event will be handled via email for virtual participants. Anyone can ask a question in advance by emailing ask-matt@wordcamp.org or may ask during the event in the live stream chat on YouTube. WordPress Executive Director Josepha Haden-Chomphosy said there may be a follow-up post published with answers to questions not covered at the event.</p>\n\n\n\n<p>The live stream will be embedded in the <a href=\"https://wordpress.org/news/2022/11/state-of-the-word-2022/\">announcement post</a> and will also air on <a href=\"https://youtube.com/wordpress\">WordPress&#8217; YouTube channel</a> on <a rel=\"noreferrer noopener\" href=\"https://calendar.google.com/calendar/u/0/r/eventedit?text=State+of+the+Word+2022&dates=20221215T180000Z/20221215T193000Z&details=State+of+the+Word+is+the+annual+keynote+address+delivered+by+the+WordPress+project%E2%80%99s+co-founder%2C+Matt+Mullenweg.+Every+year%2C+the+event+shares+reflections+on+the+project%E2%80%99s+progress+and+the+future+of+open+source.+Expect+this+and+more+in+this+year%E2%80%99s+edition.%0A%0AState+of+the+Word+will+be+live+streamed+from+New+York+City,+and+is+free+for+all+to+watch.%0A%0Ahttps://wordpress.org/news/2022/11/state-of-the-word-2022/\" target=\"_blank\">December 15, 2022, at 1–2:30 P.M. EST (18–19:30 UTC)</a>. Those who are hosting watch parties are encouraged to email support@wordcamp.org for additional resources from the Community Team.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Mon, 21 Nov 2022 23:40:44 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Sarah Gooding\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:21;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:42:\"WordPress.org blog: State of the Word 2022\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:35:\"https://wordpress.org/news/?p=13971\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:58:\"https://wordpress.org/news/2022/11/state-of-the-word-2022/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:8590:\"<img width=\"1024\" height=\"683\" src=\"https://i0.wp.com/wordpress.org/news/files/2022/11/Web-SOTW-Image-1200x800-1.png?resize=1024%2C683&ssl=1\" alt=\"Decorative blue background with text: \" />\n\n\n\n<p>Hello, WordPress!&nbsp;</p>\n\n\n\n<p><a href=\"https://calendar.google.com/calendar/u/0/r/eventedit?text=State+of+the+Word+2022&dates=20221215T180000Z/20221215T193000Z&details=State+of+the+Word+is+the+annual+keynote+address+delivered+by+the+WordPress+project%E2%80%99s+co-founder%2C+Matt+Mullenweg.+Every+year%2C+the+event+shares+reflections+on+the+project%E2%80%99s+progress+and+the+future+of+open+source.+Expect+this+and+more+in+this+year%E2%80%99s+edition.%0A%0AState+of+the+Word+will+be+live+streamed+from+New+York+City,+and+is+free+for+all+to+watch.%0A%0Ahttps://wordpress.org/news/2022/11/state-of-the-word-2022/\" target=\"_blank\" rel=\"noreferrer noopener\">Mark your calendars</a>; it’s almost time for State of the Word 2022!</p>\n\n\n\n<p>State of the Word is the annual keynote address delivered by the WordPress project’s co-founder, <a href=\"https://ma.tt\">Matt Mullenweg</a>. Every year, the event shares reflections on the project’s progress and the future of open source. Expect this and more in this year’s edition.</p>\n\n\n\n<p>This year’s event will take place in person in New York City and live-streamed via various WordPress.org social media platforms.&nbsp;</p>\n\n\n\n<p>Join Matt as he provides a retrospective of 2022, the latest WordPress releases, Site Editor advancements, and a return to in-person events around the globe, among other topics.</p>\n\n\n\n<p><strong>What:</strong> State of the Word 2022</p>\n\n\n\n<p><strong>When:</strong> <a href=\"https://calendar.google.com/calendar/u/0/r/eventedit?text=State+of+the+Word+2022&dates=20221215T180000Z/20221215T193000Z&details=State+of+the+Word+is+the+annual+keynote+address+delivered+by+the+WordPress+project%E2%80%99s+co-founder%2C+Matt+Mullenweg.+Every+year%2C+the+event+shares+reflections+on+the+project%E2%80%99s+progress+and+the+future+of+open+source.+Expect+this+and+more+in+this+year%E2%80%99s+edition.%0A%0AState+of+the+Word+will+be+live+streamed+from+New+York+City,+and+is+free+for+all+to+watch.%0A%0Ahttps://wordpress.org/news/2022/11/state-of-the-word-2022/\" target=\"_blank\" rel=\"noreferrer noopener\">December 15, 2022, 1–2:30 P.M. EST (18–19:30 UTC)</a></p>\n\n\n\n<p><strong>How:</strong> If you’re watching from the comfort of your home or <a href=\"https://make.wordpress.org/community/handbook/meetup-organizer/state-of-the-word-watch-parties/\">local watch party</a>, the live stream will be embedded in this post and available through the <a href=\"https://youtube.com/wordpress\">WordPress YouTube channel</a>.</p>\n\n\n\n<p>Would you like to join the in-person audience? <a href=\"https://wordcampcentral.survey.fm/request-a-seat-sotw-2022\">Request a seat by completing this survey</a>.</p>\n\n\n\n<h2>Have a question for Matt?</h2>\n\n\n\n<p>State of the Word will include a Q&amp;A session. If you want to participate, you can either send your question ahead of time to <strong>ask-matt@wordcamp.org</strong> or ask during the event in the live stream chat on YouTube.</p>\n\n\n\n<p>Given the volume of questions that are usually submitted, please note that it may not be possible to answer all of them in the live Q&amp;A. A follow-up post will be published after the State of the Word to answer those not covered at the event.</p>\n\n\n\n<p>First time attending State of the Word? Check out <a href=\"https://wordpress.tv/tag/state-of-the-word/\">previous years&#8217; recordings on</a> <a href=\"https://wordpress.tv/tag/state-of-the-word/\">WordPress.tv</a> to get a sense of the event.</p>\n\n\n\n<p>See you in person or online on December 15!</p>\n\n\n\n<hr class=\"wp-block-separator has-alpha-channel-opacity is-style-default\" />\n\n\n\n<h2 id=\"join-a-state-of-the-word-watch-party-near-you\">Join a State of the Word Watch Party near You</h2>\n\n\n\n<p>Can’t make it to New York? No problem, organize or join a watch party in your community in person or online. Like last year, the Community team has resources available to help! Check out <a href=\"https://make.wordpress.org/community/handbook/meetup-organizer/state-of-the-word-watch-parties/\">this handbook page</a>, which includes event templates, information on requesting a Zoom account, and how to get some swag.</p>\n\n\n\n<p>Gather together to look back on how WordPress has grown in 2022 and what is ahead for 2023. Stay up-to-date as a group on the latest happenings in the WordPress world and collaborate together on any questions you might have for Matt!</p>\n\n\n\n<p>Below you can find a list of State of the Word watch parties that will be updated regularly as the event approaches. If you don’t see a watch party in your region, <a href=\"https://meetup.com/pro/wordpress\">check this page on Meetup.com</a> to see if your local WordPress group is organizing one.</p>\n\n\n\n<ul>\n<li><img src=\"https://s.w.org/images/core/emoji/14.0.0/72x72/1f1fa-1f1f8.png\" alt=\"🇺🇸\" class=\"wp-smiley\" /> <a href=\"https://www.meetup.com/SeattleWordPressMeetup\">Seattle WordPress Meetup</a> &#8211; <a href=\"https://www.meetup.com/SeattleWordPressMeetup/events/282840880/\">WordPress Developer Meetup: State of the Word/General Discussion</a></li>\n\n\n\n<li><img src=\"https://s.w.org/images/core/emoji/14.0.0/72x72/1f1ed-1f1f9.png\" alt=\"🇭🇹\" class=\"wp-smiley\" /> <a href=\"https://www.meetup.com/Port-au-Prince-WordPress-Meetup\">Port-au-Prince WordPress Meetup Group</a> &#8211; <a href=\"https://www.meetup.com/Port-au-Prince-WordPress-Meetup/events/289909938/\">State of the Word Watch Party (Online)</a></li>\n\n\n\n<li><img src=\"https://s.w.org/images/core/emoji/14.0.0/72x72/1f1e8-1f1ed.png\" alt=\"🇨🇭\" class=\"wp-smiley\" /> <a href=\"https://www.meetup.com/geneva-wordpress\">WordPress Meetups Genève (Geneva)</a> &#8211; <a href=\"https://www.meetup.com/geneva-wordpress/events/289943099/\">State of the Word &#8220;Watch Party&#8221; et plus/and more (FR/EN) WordPress</a></li>\n\n\n\n<li><img src=\"https://s.w.org/images/core/emoji/14.0.0/72x72/1f1ee-1f1f9.png\" alt=\"🇮🇹\" class=\"wp-smiley\" /> <a href=\"https://www.meetup.com/meetup-wordpress-ancona\">WordPress Ancona Meetup</a> &#8211; <a href=\"https://www.meetup.com/meetup-wordpress-ancona/events/289968378/\">State of the Word Watch Party + Auguri di Natale + Proposte 2023</a></li>\n\n\n\n<li><img src=\"https://s.w.org/images/core/emoji/14.0.0/72x72/1f1e7-1f1ec.png\" alt=\"🇧🇬\" class=\"wp-smiley\" /> <a href=\"https://www.meetup.com/WordPress-Sofia-Meetup\">WordPress Sofia Meetup</a> &#8211; <a href=\"https://www.meetup.com/WordPress-Sofia-Meetup/events/289915099/\">&#8220;State of the Word 2022&#8221; watch party!</a></li>\n\n\n\n<li><img src=\"https://s.w.org/images/core/emoji/14.0.0/72x72/1f1ea-1f1f8.png\" alt=\"🇪🇸\" class=\"wp-smiley\" /> <a href=\"https://www.meetup.com/Granada-WordPress-Meetup\">Granada WordPress Meetup</a> &#8211; <a href=\"https://www.meetup.com/Granada-WordPress-Meetup/events/290016526/\">¡Veamos el State of the Word 2022!</a></li>\n\n\n\n<li><img src=\"https://s.w.org/images/core/emoji/14.0.0/72x72/1f1ee-1f1f3.png\" alt=\"🇮🇳\" class=\"wp-smiley\" /> <a href=\"https://www.meetup.com/Kochi-WordPress-Meetup\">Kochi WordPress Meetup</a> &#8211; <a href=\"https://www.meetup.com/Kochi-WordPress-Meetup/events/289893144/\">State of the Word Watch Party (In-person)</a></li>\n\n\n\n<li><img src=\"https://s.w.org/images/core/emoji/14.0.0/72x72/1f1ee-1f1e9.png\" alt=\"🇮🇩\" class=\"wp-smiley\" /> <a href=\"https://www.meetup.com/tegal-wordpress-meetup\">WordPress Meetup Tegal</a> &#8211; <a href=\"https://www.meetup.com/tegal-wordpress-meetup/events/290031767/\">Nonton bareng &#8220;State of the Word 2022&#8221;</a></li>\n\n\n\n<li><img src=\"https://s.w.org/images/core/emoji/14.0.0/72x72/1f1ef-1f1f5.png\" alt=\"🇯🇵\" class=\"wp-smiley\" /> <a href=\"https://www.meetup.com/Tokyo-WordPress-Meetup\">Tokyo WordPress Meetup</a> &#8211; <a href=\"https://www.meetup.com/Tokyo-WordPress-Meetup/events/289965452/\">State of the Word から来年の WordPress を考えよう！+ 忘年会</a></li>\n\n\n\n<li><img src=\"https://s.w.org/images/core/emoji/14.0.0/72x72/1f1fa-1f1f8.png\" alt=\"🇺🇸\" class=\"wp-smiley\" /> <a href=\"https://www.meetup.com/wpgrandrapids\">WPGR &#8211; Grand Rapids WordPress Meetup</a> &#8211; <a href=\"https://www.meetup.com/wpgrandrapids/events/290039217/\">State of the Word Watch Party (In-person)</a></li>\n</ul>\n\n\n\n<p>If you are planning a watch party for State of the Word and have questions, please email support@wordcamp.org. A member of the WordPress community team will assist you in the best way possible.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Mon, 21 Nov 2022 17:14:43 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:7:\"Josepha\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:22;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:96:\"Gutenberg Times: Block Art, MindMap block, Slotfills, Patterns and more – Weekend Edition #236\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:35:\"https://gutenbergtimes.com/?p=22670\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:99:\"https://gutenbergtimes.com/block-art-mindmap-block-slotfills-patterns-and-more-weekend-edition-236/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:25645:\"<p>Howdy, </p>\n\n\n\n<p>I am so excited about next week! Finally, there will be another Six-a-side Festival at the <a href=\"https://sarasotacricket.org/\">Sarasota International Cricket Club</a>. I&#8217;ll be there Saturday and Sunday. I am excited to see all the friends again, most I haven&#8217;t seen in three years. </p>\n\n\n\n<p>If you are in the area, come on by. It&#8217;s a lot of fun, a diverse community, and you can meet cricketers from England, the Caribbean, and the West-Indies  coming together to play cricket, party and play cricket again the next day and the next.  It&#8217;s great fun for the whole family! </p>\n\n\n\n<p>What are your plans for next week? I hope  you have a fabulous one!</p>\n\n\n\n\n\n<p>In this edition, you&#8217;ll find a vast array of videos, blog posts and podcasts from Learn.WordPress, WordPress TV and around the community. Let&#8217;s get started! </p>\n\n\n\n<p>Yours, 💕<br /><em>Birgit</em></p>\n\n\n\n\n\n<hr class=\"wp-block-separator has-alpha-channel-opacity is-style-wide\" />\n\n\n\n\n<div class=\"wp-block-group has-light-background-background-color has-background is-layout-flow\"><div class=\"wp-block-group__inner-container\">\n<p><strong>Table of Contents</strong></p>\n\n\n\n<div class=\"wp-block-sortabrilliant-guidepost\"><ul><li><a href=\"https://gutenbergtimes.com/feed/#0-word-press-release-information\">Developing Gutenberg and WordPress</a><ul><li><a href=\"https://gutenbergtimes.com/feed/#1-gute\">Gutenberg 14.5 released</a></li></ul></li><li><a href=\"https://gutenbergtimes.com/feed/#0-p\">Plugins, Themes, and Tools for #nocode site builders and owners</a></li><li><a href=\"https://gutenbergtimes.com/feed/#2-word-press-6-0-1-and-6-1-scheduled\">Theme Development for Full Site Editing and Blocks</a></li><li><a href=\"https://gutenbergtimes.com/feed/#3-building-themes-for-fse-and-word-press\">Building Blocks and Tools for the Block editor. </a></li><li><a href=\"https://gutenbergtimes.com/feed/#5-s\">Upcoming WordPress events</a><ul><li><a href=\"https://gutenbergtimes.com/feed/#1-l\">Learn WordPress Online Meetups</a></li></ul></li></ul></div>\n</div></div>\n\n\n\n\n<h2 id=\"0-word-press-release-information\">Developing Gutenberg and WordPress</h2>\n\n\n\n<p>If you found the <a href=\"https://make.wordpress.org/core/2022/10/12/wordpress-6-1-field-guide/\">Field guide of WordPress 6.1</a> too developer centric, yet the <a href=\"https://wordpress.org/news/2022/11/misha/\">announcement post</a> not detailed enough, then let <strong>Courtney Robertson</strong>, team rep of the WordPress Training team, show you <a href=\"https://www.godaddy.com/garage/wordpress-6-1/\"><strong>What’s new in WordPress 6.1</strong>: <strong>Misha</strong></a></p>\n\n\n\n<hr class=\"wp-block-separator has-alpha-channel-opacity is-style-wide\" />\n\n\n\n<p>Hostinger&#8217;s <strong>Leonardus Nugraha</strong>, member of the WordPress docs team, published <a href=\"https://www.hostinger.com/blog/wordpress-6-1\"><strong>WordPress 6.1: What’s New in the New Major Release</strong></a> in collaboration with yours truly. </p>\n\n\n\n<img src=\"https://i0.wp.com/www.hostinger.com/blog/wp-content/uploads/sites/4/2022/11/WordPress-6.1-Release-1024x596.webp?resize=652%2C379&ssl=1\" alt=\"\" />\n\n\n\n<hr class=\"wp-block-separator has-alpha-channel-opacity is-style-wide\" />\n\n\n\n<p>Also, part of WordPress 6.1 is a new default theme. In her post <a href=\"https://wordpress.org/news/2022/11/introducing-twenty-twenty-three/\"><strong>Introducing Twenty Twenty-Three</strong></a>, Beatriz Fialho, design lead,  takes you a long for the journey exploring the new default theme  and it&#8217;s community-submitted style variations. </p>\n\n\n\n<p>You&#8217;ll find more details about the  features of <a href=\"https://wordpress.org/support/article/twenty-twenty-three/\"><strong>Twenty Twenty-three in the End User documentation article</strong></a></p>\n\n\n\n<hr class=\"wp-block-separator has-alpha-channel-opacity is-style-wide\" />\n\n\n\n<p><a href=\"https://wordpress.org/news/2022/11/wordpress-6-1-1-maintenance-release/\"><strong>WordPress 6.1.1 was released</strong></a>, fixing a few bugs on the backend and frontend of the software. Core contributors and release leads JB Audras, Jeff Paul and George Mamadashvili,  worked hard to get this out with two weeks of the 6.1 release. This was a really fast turn around. </p>\n\n\n\n<hr class=\"wp-block-separator has-alpha-channel-opacity is-style-wide\" />\n\n\n\n<p>In his <strong><a href=\"https://make.wordpress.org/design/2022/11/07/design-share-oct-24-nov-4/\">Design Share: Oct 24-Nov 4</a>, Joen Asmussen</strong> lists the project the WordPress design team has been working on. The visuals representation of upcoming feature are absolutely exciting. First up are the screens of possible location for the Custom CSS feature, many of you found missing around the block themes. You can also see the design explorations for the interface to make a Group block sticky. You could use it for an ever present navigation bar or a public service announcement. Or an ongoing news ticker banner. </p>\n\n\n\n<p>If you use the latest version of the Gutenberg plugin, you might have noticed, that the the info screen with the meta information on word count, or the outline was moved into the List view as an additional tab. The design team also explored more delightful designs for this panel. </p>\n\n\n\n<img />\n\n\n\n<hr class=\"wp-block-separator has-alpha-channel-opacity is-style-wide\" />\n\n\n\n<p><strong>James Koster</strong> tries to answer how to<a href=\"https://github.com/WordPress/gutenberg/issues/44361\"> </a><strong><a href=\"https://github.com/WordPress/gutenberg/issues/44361\">make it possible to push local block styles to global block styles</a>.</strong> In other words, after you modified the look and feel of a single block, how can you make the styles persistent for all the blocks of that particular type on your site.</p>\n\n\n\n<div class=\"wp-block-group has-light-background-background-color has-background is-layout-flow\"><div class=\"wp-block-group__inner-container\">\n<p><strong>🎙️ </strong> New episode:  <a href=\"https://gutenbergtimes.com/podcast/gutenberg-changelog-76-the-new-developer-blogs-public-beta-gutenberg-14-5-and-14-6-and-whats-coming-up-in-6-2/\">Gutenberg Changelog #76 – The new developer blog’s public beta, Gutenberg 14.5 and 14.6, and what’s coming up in 6.2. </a>with special guest, Ryan Welcher, and host Birgit Pauli-Haack. </p>\n</div></div>\n\n\n\n<p>The WordPress meta, design, and marketing teams have been working on the redesign of the Showcase page on the main website. <strong>Joen Asmussen</strong> reports on the progress in his post <strong><a href=\"https://make.wordpress.org/design/2022/11/11/a-refresh-of-wordpress-org-showcase/\">A refresh of WordPress.org/Showcase</a>.</strong> &#8220;The current work represents a starting point that will continue to be iterated upon as additional features, and content changes are explored.&#8221; he wrote. He also provides links to <a href=\"https://www.figma.com/file/nK6LcMOZMtRAQdIky3PNIA/Showcase-Pages?node-id=1%3A2193\">the Figma file</a> and the <a href=\"https://github.com/WordPress/wporg-showcase\">Showcase GitHub repository</a>. </p>\n\n\n\n<h3 id=\"1-gute\">Gutenberg 14.5 released</h3>\n\n\n\n<p><strong>Nick Diego</strong> was the lead for last week&#8217;s Gutenberg plugin release. In his posts <a href=\"https://make.wordpress.org/core/2022/11/09/whats-new-in-gutenberg-14-5-9-november/\"><strong>What’s new in Gutenberg 14.5? (9 November)</strong></a> he wrote:  &#8220;It consolidates the list view and document information, expands margin and padding support while improving spacing visualizers, and sets the groundwork for future releases with numerous code quality improvements and&nbsp;bug&nbsp;fixes.&#8221;</p>\n\n\n\n<hr class=\"wp-block-separator has-alpha-channel-opacity is-style-wide\" />\n\n\n\n<p><strong>Sarah Gooding</strong> also reported on the latest release in <a href=\"https://wptavern.com/gutenberg-14-5-introduces-new-document-overview-panel-improves-block-spacing-controls\"><strong>Gutenberg 14.5 Introduces New “Document Overview” Panel, Improves Block Spacing Controls</strong></a>.</p>\n\n\n\n<p>One of the new features is a new Social Link Block for <em><a href=\"https://joinmastodon.org/\">Mastodon </a></em>accounts, Mastodon, is an open-source decentralized social network, that many feel comfortable as using while Twitter seems to be deteriorating fast. </p>\n\n\n\n<hr class=\"wp-block-separator has-alpha-channel-opacity is-style-wide\" />\n\n\n\n<p><strong>George Hotelling</strong>, WordPress core contributor, wrote a short tutorial on <strong><a href=\"https://g13g.blog/2022/11/09/how-to-verify-your-wordpress-site-on-mastodon/\">How to verify your WordPress site on Mastodon</a>. </strong></p>\n\n\n\n<p>On a side note, I just created the @gutenbergtimes account on the mastodon server at twit.social. If you want to follow, just search for <a href=\"https://twit.social/@gutenbergtimes\">https://twit.social/@gutenbergtimes</a> on any mastodon server, and you can follow me there. It&#8217;s a new account so not much going on. </p>\n\n\n\n<p>My personal account is <a href=\"https://mastodon.social/@bph\">https://mastodon.social/@bph</a>. </p>\n\n\n\n<hr class=\"wp-block-separator has-alpha-channel-opacity is-style-wide\" />\n\n\n\n<p><a href=\"https://github.com/WordPress/gutenberg/releases/tag/v14.6.0-rc.1\"><strong>Gutenberg 14.6 RC</strong></a> is already available for testing. The stable version will be release by <strong>Fabian Kägy</strong> on November 23, 2022</p>\n\n\n\n<h2 id=\"0-p\">Plugins, Themes, and Tools for #nocode site builders and owners</h2>\n\n\n\n<p><a href=\"https://twitter.com/thisisthien\"><strong>Thien Nguyen</strong></a> published his <a href=\"https://thisisthien.gumroad.com/l/wp-block-mindmap\"><strong>Mindmap Block</strong></a> It&#8217;s a cool block that provides the conversion from Markdown input in the block editor to a Mind map display on the frontend. This could get fascinating when Phase 3 of the Gutenberg project progresses, as then you can use this to collaborate on mind maps, too. We&#8217;ll revisit this in two years or so. It&#8217;s not a free plugin, and it is available on Gumroad with single site or unlimited site levels. </p>\n\n\n\n<a href=\"https://thisisthien.gumroad.com/l/wp-block-mindmap\"><img /></a>\n\n\n\n<p>Today&#8217;s count is 182 Themes supporting the Site editor in the <a href=\"https://wordpress.org/themes/tags/full-site-editing/\"><strong>WordPress Themes Directory</strong></a>. New themes are available by the Block Styles team, Brian Gardner, Blockify, Catch Themes, Wen Solutions, and by Wwwows. </p>\n\n\n\n<a href=\"https://wordpress.org/themes/tags/full-site-editing/\"><img /></a>\n\n\n\n<p>Another recently added theme is <a href=\"https://wptavern.com/loudness-a-new-block-theme-from-automattic\"><strong>Loudness: A New Block Theme from Automattic</strong></a> It’s an artistic and opinionated theme&nbsp;. Sarah Gooding has the skinny for you. </p>\n\n\n\n<hr class=\"wp-block-separator has-alpha-channel-opacity is-style-wide\" />\n\n\n\n<p><strong>Rich Tabor</strong> and <strong>Courtney Portnoy</strong> discussed <a href=\"https://wordpress.tv/2022/11/18/the-creative-side-of-blocks-vol-3/\"><strong>The creative side of blocks</strong></a> on WordPressTV. Rich Tabor walks the viewers through one of his block art creations. It&#8217;s quite inspiring to watch Tabor&#8217;s exploratory creative process using the block editor. I learned quite a few things about the power of the various color features: gradient, nested group blocks, and how to replace the theme&#8217;s primary and secondary colors for the whole site.  You&#8217;ll also get an introduction to the <a href=\"https://block-museum.com/\">Museum of Block Art</a>, where Rich and other block artists showcase their creations. </p>\n\n\n\n<hr class=\"wp-block-separator has-alpha-channel-opacity is-style-wide\" />\n\n\n\n<p>On the <a href=\"https://www.youtube.com/watch?v=f5x9c33lyRk&t\"><strong>Torque Social Hour,</strong></a> host Doc Pop interviewed <strong>Roy Sivan</strong> and <strong>James Tryon</strong> about <a href=\"https://blockstyles.com/\"><strong>Block Styles</strong></a> Community and plugins built by the two. Gutenberg adopters of the first hour, the team aims to augment the Block editor with Block Styles to make it a professional page builder for power users. They created 160 input fields to customize a site. </p>\n\n\n\n<p>The most obvious styles enhancements are the tools to separate the page layout features by screen sizes for desktop, tablet, and mobile. It&#8217;s a bit unfortunate to give  a product / membership service the same name as a WordPress feature. Plugin developers have the advantage of a shortened implementation time and run into the danger to be passed by core in the long run. </p>\n\n\n\n<p><a href=\"https://wordpress.org/plugins/missing-menu-items/\">Missing Menu</a> plugin and the newest block theme <a href=\"https://wordpress.org/themes/gesso-by-block-styles/\"><strong>Gesso</strong></a> were also mentioned on the show. </p>\n\n\n\n<h2 id=\"2-word-press-6-0-1-and-6-1-scheduled\">Theme Development for Full Site Editing and Blocks</h2>\n\n\n\n<p><strong>Daisy Olsen</strong> wrote about <a href=\"https://developer.wordpress.org/news/2022/11/17/demystifying-home-and-posts-templates-in-wordpress-theme-development/\"><strong>Demystifying Home and Posts Templates in WordPress theme development</strong></a>, explains the WordPress Themes Hierarchy for both classic and block themes. </p>\n\n\n\n<hr class=\"wp-block-separator has-alpha-channel-opacity is-style-wide\" />\n\n\n\n<p>In his post <a href=\"https://developer.wordpress.org/news/2022/11/17/creating-themes-from-a-pattern-first-mindset/\"><strong>Creating Themes from a Pattern-First Mindset</strong></a>, <strong>Justin Tadlock</strong> helped theme developers interested in block themes to see the power of using pattern in their templates to reduce code redundancy and simplicity. </p>\n\n\n\n<hr class=\"wp-block-separator has-alpha-channel-opacity is-style-wide\" />\n\n\n\n<p>On Tuesday next week (Nov 22) <strong>Daisy Olsen</strong> and <strong>Justin Tadlock</strong>, together with <strong>Damon Cook</strong> will hold a Hallway Hangout on <strong><a href=\"https://www.meetup.com/learn-wordpress-online-workshops/events/289840236/\">Future of CSS in block themes</a></strong>.<strong> </strong>It will be in a casual chat about some Block Theme development-related features that are under active development. Hope to see you there 🙂 </p>\n\n\n\n<hr class=\"wp-block-separator has-alpha-channel-opacity is-style-wide\" />\n\n\n\n<p><strong>Ganesh Dahal</strong> wrote about <a href=\"https://css-tricks.com/managing-css-styles-in-a-wordpress-block-theme/\"><strong>Managing CSS Styles in a WordPress Block&nbsp;Theme</strong></a> and took a deep dive into the migration from styles.css files to theme.json. &#8220;One of the major benefits of moving CSS to JSON is that JSON is a machine-readable format, which means it can be exposed in the WordPress Site Editor UI by fetching an API, thus allowing users to modify default values and customize a site’s appearance without writing any CSS at all.&#8221; he wrote. </p>\n\n\n\n\n<p><strong>&nbsp;<a href=\"https://make.wordpress.org/core/handbook/references/keeping-up-with-gutenberg-index/\" target=\"_blank\" rel=\"noreferrer noopener\">&#8220;Keeping up with Gutenberg &#8211; Index 2022&#8221;</a>&nbsp;</strong><br />A chronological list of the WordPress Make Blog posts from various teams involved in Gutenberg development: Design, Theme Review Team, Core Editor, Core JS, Core CSS, Test and Meta team from Jan. 2021 on. Updated by yours truly.  <a href=\"https://make.wordpress.org/core/handbook/references/keeping-up-with-gutenberg-index/keeping-up-with-gutenberg-index-2020/\"><em>The index 2020 is here</em></a></p>\n\n\n\n\n<p><strong>Sarah Gooding</strong> reports on an update of the Create Theme plugin in her post: <a href=\"https://wptavern.com/gutenbergs-roadmap-for-a-font-library-will-give-users-an-interface-for-registering-and-managing-web-fonts\"><strong>Gutenberg’s Roadmap for a “Font Library” Will Give Users an Interface for Registering and Managing Web Fonts</strong></a>. Besides the features: create a new theme, start with a blank theme, create a child theme, or create a style variation, in now sports a dedicated screen for managing fonts. In her post, Gooding also summarized the tracking ticket on the Webfonts API and links to design exploration for a font manager within the core app.  </p>\n\n\n\n<hr class=\"wp-block-separator has-alpha-channel-opacity is-style-wide\" />\n\n\n\n<p><strong>Mike McAlister</strong> shows you <a href=\"https://olliewp.com/three-beautiful-font-pairs-to-bring-your-design-to-life/\"><strong>Three beautiful font pairs to bring your design to life</strong></a>. &#8220;With all the new fonts out there, there’s no excuse to be using tired old fonts on your website. Here are a few fonts that should definitely be on your radar.&#8221; he wrote.</p>\n\n\n\n<hr class=\"wp-block-separator has-alpha-channel-opacity is-style-wide\" />\n\n\n\n<h2 id=\"3-building-themes-for-fse-and-word-press\">Building Blocks and Tools for the Block editor. </h2>\n\n\n\n<p><strong>Fränk Klein</strong> was a guest on the WP Jukebox podcast episode #50 and discussed with host Nathan Wrigley about <a href=\"https://wptavern.com/podcast/50-frank-klein-on-how-gutenberg-and-full-site-editing-are-bringing-new-opportunities-for-wordpress-developers\"><strong>How Gutenberg and Full Site Editing Are Bringing New Opportunities for WordPress Developers</strong></a>.</p>\n\n\n\n<hr class=\"wp-block-separator has-alpha-channel-opacity is-style-wide\" />\n\n\n\n<p><strong><a href=\"https://twitter.com/bxtgeek\">Manoj Kumal</a></strong> wrote a tutorial on CSS-Tricks on <a href=\"https://css-tricks.com/creating-a-settings-ui-for-a-custom-wordpress-block/\"><strong>Creating a Settings UI for a Custom WordPress Block</strong></a>. It&#8217;s the third post in the series &#8220;Working With External APIs in WordPress Blocks&#8221;.  The first two post cover the rendering of external data <a href=\"https://css-tricks.com/rendering-external-api-data-in-wordpress-blocks-on-the-back-end/\">on backend</a> and <a href=\"https://css-tricks.com/rendering-external-api-data-in-wordpress-blocks-on-the-front-end/\">frontend</a>. The last post on &#8220;Saving custom block settings&#8221; is coming soon. </p>\n\n\n\n<hr class=\"wp-block-separator has-alpha-channel-opacity is-style-wide\" />\n\n\n\n<p><strong>Ryan Welcher</strong> is back streaming on Twitch again! This week&#8217;s topic was <a href=\"https://www.twitch.tv/videos/1655281302\"><strong>Working with Query Loop block variations</strong></a>, a new feature that came with the latest major WordPress 6.1. You can read the dev note on then WordPress make blog: <a href=\"https://make.wordpress.org/core/2022/10/10/extending-the-query-loop-block/\">Extending the Query Loop block</a>. </p>\n\n\n\n<p>As always, if you read this post two weeks after it was published, you&#8217;ll find the recording of the Twitch streams on <a href=\"https://www.youtube.com/c/RyanWelcherCodes/videos\">Ryan Welcher&#8217;s YouTube channel</a>. </p>\n\n\n\n<hr class=\"wp-block-separator has-alpha-channel-opacity is-style-wide\" />\n\n\n\n<p><strong>Jonathan Bossenger</strong> and <strong>Álvaro Gómez</strong> ran a two-part workshop on <strong>Developing blocks without React.</strong> The recordings are now available on WordPress TV: </p>\n\n\n\n<ul>\n<li><a href=\"https://wordpress.tv/2022/11/11/lets-code-developing-blocks-without-react-part-1/\"><strong>Let’s code: developing blocks without React! – Part&nbsp;1</strong></a> &#8211; In Part one, the presenters covered the initial files needed to register a block, go over some JavaScript syntax and WordPress dependencies, and then add some styling to our block via a useBlockProps and custom stylesheets. <em>(<a href=\"https://www.slideshare.net/psykro/developing-blocks-without-react-part-1\">Presentation Slides</a>)</em></li>\n\n\n\n<li><strong><a href=\"https://wordpress.tv/2022/11/18/lets-code-developing-blocks-without-react-part-2/\">Let’s code: developing blocks without React! – Part&nbsp;2</a> </strong>&#8211;  In Part two, was about how to add support for attributes, as well as how to implement the pre-existing RichText component. These will enable a user to edit the content of the block. <em>(<a href=\"https://www.slideshare.net/psykro/developing-blocks-without-react-part-2\">Presentation Slides</a>)</em></li>\n</ul>\n\n\n\n<hr class=\"wp-block-separator has-alpha-channel-opacity is-style-wide\" />\n\n\n\n<p><strong>Dan Knauss</strong> of <a href=\"https://twitter.com/post_status\">Post Status</a> reported on <a href=\"https://poststatus.com/the-future-of-givewp-and-the-block-editor/\"><strong>The Future of GiveWP and the Block Editor</strong></a>. He summarized: &#8220;The journey to&nbsp;<strong>GiveWP 3.0</strong>&nbsp;is well underway — an open, iterative development process that fully embraces WordPress&#8217;s Gutenberg block editor. Give cofounder&nbsp;<strong>Matt Cromwell</strong>&nbsp;and development director&nbsp;<strong>Jason Adams</strong>&nbsp;share what they&#8217;ve learned so far.&#8221; </p>\n\n\n\n<p>The main reasons for the rebuild are that the plugin match visual experience of the block editor, the need for more form field flexibility and to simplify template building. &#8220;Taking advantage of the components and packages of the block editor, as visual builder framework, continually improved and maintained by the open-source project, the GiveWP developers were faster in getting specific features done in a matter of hours rather than months.  </p>\n\n\n\n\n<p><strong><a href=\"https://gutenbergtimes.com/need-a-zip-from-master/\">Need a plugin .zip from Gutenberg&#8217;s master branch?</a></strong><br />Gutenberg Times provides daily build for testing and review. <br />Have you been using it? Hit reply and let me know.</p>\n\n\n\n<p><img alt=\"GitHub all releases\" src=\"https://img.shields.io/github/downloads/bph/gutenberg/total?style=for-the-badge\" /></p>\n\n\n\n\n<h2 id=\"5-s\">Upcoming WordPress events</h2>\n\n\n\n<p>New Date! <strong>December 16, 2022</strong><br /><strong><a href=\"https://www.wordfest.live/2022/november/\">WordFest Live Returns</a></strong>&nbsp;– the 24-hour Festival of WordPress</p>\n\n\n\n<p>February 17 – 19, 2023<br /><a href=\"https://asia.wordcamp.org/2023/\"><strong>WordCamp Asia 2023</strong></a>  &#8211; the <a href=\"https://asia.wordcamp.org/2023/speakers-announcement-round-1/\">first round of speakers was announced</a></p>\n\n\n\n<p class=\"has-light-background-background-color has-background has-normal-font-size\"><a href=\"https://central.wordcamp.org/schedule/\"><strong>Have a look at the schedule of upcoming WordCamps</strong></a> to find one near you. </p>\n\n\n\n<h3 id=\"1-l\">Learn WordPress Online Meetups</h3>\n\n\n\n<p>November 21, 2022 &#8211; 3 pm ET / 20:00 UTC<br /><a href=\"https://www.meetup.com/learn-wordpress-online-workshops/events/289536031/\"><strong>Intro to the Site Editor &amp; Template Editor</strong></a> with Wes Theron</p>\n\n\n\n<p>November 22, 2022 &#8211;  3:30 pm ET / 20:30 UTC <br /><strong><a href=\"https://www.meetup.com/learn-wordpress-online-workshops/events/289840236/\">Hallway Hangout: Future of CSS in block themes</a></strong></p>\n\n\n\n<p>November 22, 2022 &#8211; 11 am ET / 16:00 UTC Repeated at 5 pm ET / 22:00 UTC <br /><a href=\"https://www.meetup.com/learn-wordpress-online-workshops/events/289836820/\"><strong>Designing in the Site Editor: A WordPress Block Theme Exploration</strong></a></p>\n\n\n\n<p>November 22, 2022 &#8211;  7 pm ET / 24:00 UTC &#8211; Repeated at 11 pm ET / 4:00 UTC<br /><a href=\"https://www.meetup.com/learn-wordpress-online-workshops/events/289784100/\"><strong>Demystifying Gutenberg</strong></a></p>\n\n\n\n<p>December 1, 2022 &#8211; 3 pm ET / 20:00 UTC <br /><a href=\"https://www.meetup.com/learn-wordpress-online-workshops/events/289520991/\"><strong>Builder Basics: Building with Columns, Groups, Rows and Stacks</strong></a> with Nick Diego </p>\n\n\n\n<p>December 8, 2022 &#8211; 3 pm ET / 20:00 UTC <br /><strong><a href=\"https://www.meetup.com/learn-wordpress-online-workshops/events/289521234/\">Builder Basics: Demystifying theme.json and Global Styles</a></strong> with Nick Diego</p>\n\n\n\n<hr class=\"wp-block-separator has-alpha-channel-opacity is-style-wide\" />\n\n\n\n\n<p>Featured Image: <em>Early morning. Building with where the lights are on</em> by Paal Joachim Romdaal found on <a href=\"https://wordpress.org/photos/photo/263636f704/\">WordPress.org/photos</a></p>\n\n\n\n<hr class=\"wp-block-separator has-css-opacity is-style-wide\" />\n\n\n\n<p class=\"has-text-align-left\"><strong>Don&#8217;t want to miss the next Weekend Edition? </strong></p>\n\n\n\n<form class=\"wp-block-newsletterglue-form ngl-form ngl-portrait\" action=\"https://gutenbergtimes.com/feed/\" method=\"post\"><div class=\"ngl-form-container\"><div class=\"ngl-form-field\"><label class=\"ngl-form-label\" for=\"ngl_email\"><br />Type in your Email address to subscribe.</label><div class=\"ngl-form-input\"><input type=\"email\" class=\"ngl-form-input-text\" name=\"ngl_email\" id=\"ngl_email\" /></div></div><button type=\"submit\" class=\"ngl-form-button\">Subscribe</button><p class=\"ngl-form-text\">We hate spam, too and won&#8217;t give your email address to anyone except Mailchimp to send out our Weekend Edition</p></div><div class=\"ngl-message-overlay\"><div class=\"ngl-message-svg-wrap\"></div><div class=\"ngl-message-overlay-text\">Thanks for subscribing.</div></div><input type=\"hidden\" name=\"ngl_list_id\" id=\"ngl_list_id\" value=\"26f81bd8ae\" /><input type=\"hidden\" name=\"ngl_double_optin\" id=\"ngl_double_optin\" value=\"yes\" /></form>\n\n\n\n<hr class=\"wp-block-separator has-css-opacity is-style-wide\" />\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Sat, 19 Nov 2022 23:21:25 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:18:\"Birgit Pauli-Haack\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:23;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:69:\"WPTavern: Divi 5.0 Aims to Bring Greater Compatibility with Gutenberg\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:30:\"https://wptavern.com/?p=139629\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:80:\"https://wptavern.com/divi-5-0-aims-to-bring-greater-compatibility-with-gutenberg\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:5698:\"<p>Divi, the popular commercial WordPress theme and page builder created by Elegant Themes, has <a href=\"https://www.elegantthemes.com/blog/general-news/the-future-of-divi\">announced</a> major changes coming in version 5.0 that constitute a complete rewrite of Divi’s core technologies. The update, which is expected to be released in beta next year, will focus on performance, stability, scalability, and extendability, but it will not introduce any new features.</p>\n\n\n\n<p>&#8220;We are recreating Divi’s backend framework, cleaning up years of technical debt, changing Divi’s storage format and improving its rendering mechanism,&#8221; Elegant Themes CEO Nick Roach said. &#8220;This new version of Divi will be able to processes design settings much more quickly.&#8221;</p>\n\n\n\n<p>One of the most notable changes coming in 5.0 is that Divi will be migrating away from shortcodes.</p>\n\n\n\n<p>&#8220;This change will bring Divi into alignment with the future of WordPress, which is evolving in a new direction,&#8221; Roach said.</p>\n\n\n\n<p>Divi will migrate to a new JSON format that is similar to the way Gutenberg stores data. The legacy shortcodes will continue to work and for a time Divi will lazy load in the old framework as necessary.</p>\n\n\n\n<p>&#8220;If you are using Divi shortcodes outside of your post content, it will be highly recommended to replace these shortcodes with our new json-based elements,&#8221; Roach said. &#8220;Otherwise, you are going to take a performance hit.&#8221;</p>\n\n\n\n<p>As part of the 5.0 update, Divi&#8217;s developers plan to include a button to perform the migration away from shortcodes, which will automatically change posts to use the new system.</p>\n\n\n\n<p>Divi 5.0 will also introduce a new Builder API, which Roach said &#8220;may also open up opportunities for Divi/Gutenberg cross-compatibility:&#8221;</p>\n\n\n\n<blockquote class=\"wp-block-quote\">\n<p>Developers familiar with creating blocks for WordPress will find a lot of similarities in the Divi 5.0 module API. WordPress blocks will be more easily adapted to Divi and WordPress developers will be able to jump head first into building things for our community. We are building this new version of Divi to work in harmony with WordPress.</p>\n</blockquote>\n\n\n\n<p>News of the coming update was well-received by Divi users who posted additional questions and concerns in the comments. A few users were skeptical about the new direction but willing to see how it pans out.</p>\n\n\n\n<p>Peter R, a current user who said he appreciates Divi&#8217;s &#8220;nicer and smoother UX,&#8221; along with the collections of design settings, indicated that Divi seems to be falling behind what the block editor offers for building pages with dynamic data: </p>\n\n\n\n<blockquote class=\"wp-block-quote\">\n<p>As nice as Divi 5.0 sounds, it’s just sooo far away… especially since it won’t have the features I’m looking for at launch which will then take even longer if those features appear at all. I was really hoping Divi 5.0 would move more towards the Gutenberg block builder (other than back-end data storage etc). </p>\n\n\n\n<p>There seems to be a real arms race going on with block builders right now. Many are adding features that Divi simply can’t compete with now and will probably take years to match if at all. Far more flexible layouts especially when it comes to making your own post loops etc, more powerful features for displaying dynamic data or for collecting and storing data, and the ability to mix-and-match blocks from different creators so you don’t depend on a single provider like Divi.</p>\n</blockquote>\n\n\n\n<p>More than <a href=\"https://trends.builtwith.com/websitelist/Divi\">2,425,411 live websites</a> are currently using Divi and an an additional 1,486,812 sites that used the product historically, according to BuiltWith. The nearly 10-year-old product has grown steadily for years but seems to have plateaued beginning in 2020.</p>\n\n\n\n<img />\n\n\n\n<p>Embracing the way WordPress is going will be important for the page builder&#8217;s continued success, and Elegant Themes seems to be acknowledging this with the planned update.</p>\n\n\n\n<p>&#8220;On the block theme front, as a part of Divi 5.0, we are also transitioning into a Block Based theme, and since Divi 5.0 is actually internally built using the same &#8216;packages&#8217; that Gutenberg itself is composed of, Divi 5.0 has a lot of compatibility built in from the core,&#8221; Elegant Themes developer Josh Ronk said. </p>\n\n\n\n<p>&#8220;We are working diligently to push Divi 5.0 for maximum Gutenberg block compatibility, with the goal being that you would be able to use Gutenberg blocks inside of your Divi built pages, and then apply all of the Divi design options you love to the otherwise plain Gutenberg blocks you have installed. This means you won’t have to choose between Divi or Gutenberg, and rather you get Divi AND Gutenberg.&#8221;</p>\n\n\n\n<p>Divi&#8217;s developers plan to ensure the old Divi modules built with the current Divi API are backwards-compatible, working on the front end but with a more limited capacity in the Visual Builder. They will be encouraging developers to move to the new API to take advantage of the performance benefits. </p>\n\n\n\n<p>Divi 5.0 will not introduce new features or changes to Divi&#8217;s design, but the underlying architecture will be moving closer to Gutenberg compatibility. </p>\n\n\n\n<p>&#8220;Divi 5.0 will use React and it will leverage more of the native Gutenberg packages,&#8221; Roach said. &#8220;At some point we hope that Divi and Gutenberg will work in harmony. We don’t want to fight against the direction that WordPress is heading.&#8221;</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Sat, 19 Nov 2022 00:07:08 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Sarah Gooding\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:24;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:40:\"Post Status: WordPress Community Roundup\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:32:\"https://poststatus.com/?p=144726\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:51:\"https://poststatus.com/wordpress-community-roundup/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:3370:\"<h2 id=\"h-a-new-home-for-the-wordpress-community\">A New Home for the WordPress Community?</h2>\n\n\n\n<p>It sounds like a tall order, but there it is: over at <strong>Ollie</strong>, <strong>Mike McAlister</strong> has proposed &#8220;a thought experiment and design concept&#8221; called <strong>OpenPress</strong>:</p>\n\n\n\n<blockquote class=\"wp-block-quote\">\n<p>What would it look like to start connecting millions of websites, users, and content that power half of the web in a more purposeful and open way?</p>\n</blockquote>\n\n\n\n<p><strong>Alex Kirk</strong> <a href=\"https://olliewp.com/finding-a-new-home-for-the-wordpress-community/#comment-19\">drew attention to his work on a plugin</a> I\'d never heard of called <strong><a href=\"https://wordpress.org/plugins/friends/\">Friends</a></strong>. Friends makes it easier to follow your selected blogs/<strong>RSS</strong> feeds inside WordPress — and restrict some posts to a private network of friends. There are content blocks with restricted visibility &#8220;for friends on a per-block basis.&#8221; Friends &#8220;supports <a href=\"https://indieweb.org/IndieAuth\"><strong>IndieAuth</strong></a>&#8221; and &#8220;doesn’t interfere with other <strong>IndieWeb</strong> projects such as <strong>Webmentions</strong>.&#8221;</p>\n\n\n\n<p class=\"has-theme-palette-8-background-color has-background\"><strong>Black Friday/Cyber Monday</strong> is coming quickly! <a href=\"https://poststatus.com/submit-black-friday-cyber-monday-deals/\">Submit your deals here</a>.&nbsp;<br /><a href=\"https://poststatus.com/2022-black-friday-cyber-monday-wordpress-deals/\">Find this year’s deals here</a>. (More are being added weekly!)</p>\n\n\n\n<p><strong>Sabina Ionescu</strong> published <a href=\"https://www.codeinwp.com/blog/pandemic-vs-wordpress-two-years-after/\">a lot of different responses </a>from people in the WordPress community to questions about the impact of the pandemic on them.</p>\n\n\n\n<p>The <a href=\"https://www.theverge.com/23203911/screen-readers-history-blind-henter-curran-teh-nvda\">history of screen readers</a> is incredible! <strong>Sheon Han</strong> tells their hidden story and how “blind programmers have been creating the tools their community needs” — for decades.</p>\n\n\n\n<p><strong>Joanne Limburg</strong> discusses <a href=\"https://aeon.co/essays/what-does-it-mean-to-consider-yourself-a-disabled-person\">the agonizing and awful, inadequate questions about disability</a> in job applications, government forms, and thoughtless conversations.</p>\n\n\n\n<p><strong>Dan Knauss</strong> blogged about &#8220;crip time.&#8221; What happens if we <a href=\"https://cmt.blog/2022/10/16/crip-time/\">think about time management through disability</a>, pain, grief, or the needs of children?</p>\n\n\n\n<h2>Upcoming Events</h2>\n\n\n\n<ul>\n<li>Post Status <a href=\"https://poststatus.com/huddles/\">Member Huddles </a>every week</li>\n\n\n\n<li><a href=\"https://www.wordfest.live/2022/november/\">WordFest</a> is happening on <strong>December 16</strong> (New Date!)</li>\n\n\n\n<li>Calls for Speakers and Sponsors are open at <a href=\"https://www.wpwealthbuilder.com/\">WP Wealthbuilder Summit</a></li>\n</ul>\n\n\n\n<p><strong>WordCamps</strong> are back. <a href=\"https://central.wordcamp.org/schedule/\">Check the schedule online</a>!</p>\n<p>This article was published at Post Status — the community for WordPress professionals.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Fri, 18 Nov 2022 20:30:28 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:10:\"Dan Knauss\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:25;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:67:\"Post Status: WordPress Business Roundup for the Week of November 14\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:32:\"https://poststatus.com/?p=144686\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:78:\"https://poststatus.com/wordpress-business-roundup-for-the-week-of-november-14/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:6286:\"<div class=\"is-layout-flow wp-block-group eplus-wrapper has-theme-palette-2-color has-theme-palette-8-background-color has-text-color has-background\"><div class=\"wp-block-group__inner-container\"><div class=\"wp-block-post-excerpt\"><p class=\"wp-block-post-excerpt__excerpt\"><strong>Tom Willmot</strong> on the Challenges and Opportunities  Facing Enterprise WordPress • <strong>Tom Lach</strong> on the costs of rapid growth — It\'s not for everyone • The Future of GiveWP and the Block Editor • Evolving Edupack — and Sunsetting It • and more&#8230; </p></div>\n\n\n<div class=\"wp-block-spacer eplus-wrapper\"></div>\n\n\n\n<p class=\"yoast-reading-time__wrapper\"><span class=\"yoast-reading-time__icon\"></span><span class=\"yoast-reading-time__spacer\"></span><span class=\"yoast-reading-time__descriptive-text\">Estimated reading time:  </span><span class=\"yoast-reading-time__reading-time\">8</span><span class=\"yoast-reading-time__time-unit\"> minutes</span></p>\n</div></div>\n\n\n\n<h2 id=\"h-tom-willmot-on-the-challenges-and-opportunities-facing-enterprise-wordpress\"><a href=\"https://poststatus.com/tom-willmot-on-the-challenges-and-opportunities-facing-enterprise-wordpress-post-status-draft-130/\" target=\"_blank\" rel=\"noreferrer noopener\">Tom Willmot on the Challenges and Opportunities  Facing Enterprise WordPress</a></h2>\n\n\n\n<p>Sparked by <strong>Magne Ilsaas</strong>&#8216;s ideas in <a href=\"https://poststatus.com/the-wordpress-enterprise-paradox/\">The WordPress Enterprise Paradox</a>, Tom started a Twitter thread and hosted a live discussion with Magne and others at enterprise WordPress agencies this week. Their main concern is the challenges that arise from not having a well-defined brand and market that allows &#8220;WordPress for the Enterprise&#8221; to stand out — without being ties to a particular WordPress company or host. After getting an outline of the problem as it stands today, I asked Tom what might help differentiate &#8220;Enterprise WordPress&#8221; as a collective or entire ecosystem of agencies operating within it. Can open-source values of sharing and cooperation shape a unique global identity for enterprise WordPress agencies? Is it time for an inter-agency association or &#8220;guild&#8221; to take on these challenges? <a href=\"https://poststatus.com/tom-willmot-on-the-challenges-and-opportunities-facing-enterprise-wordpress-post-status-draft-130/\" target=\"_blank\" rel=\"noreferrer noopener\">LISTEN→</a></p>\n\n\n\n<h2 id=\"h-big-growth-isn-t-for-everyone\"><a href=\"https://poststatus.com/big-growth-isnt-for-everyone/\">Big Growth Isn’t for Everyone</a></h2>\n\n\n\n<p>Back in 2019, <strong>Tom Lach</strong>&#8216;s agency was a team of 10 people, and they were entering a space where they could easily start working with big enterprises. Their idea of the future was to scale up and grow. Of course it was. How honest conversations at WCEU changed that. <a href=\"https://poststatus.com/big-growth-isnt-for-everyone/\" target=\"_blank\" rel=\"noreferrer noopener\">READ→</a></p>\n\n\n\n<h2 id=\"h-the-future-of-givewp-and-the-block-editor\"><a href=\"https://poststatus.com/the-future-of-givewp-and-the-block-editor/\">The Future of GiveWP and the Block Editor</a></h2>\n\n\n\n<p>The journey to <strong>GiveWP 3.0</strong> is well underway — an open, iterative development process that fully embraces WordPress\'s Gutenberg block editor. Give cofounder <strong>Matt Cromwell</strong> and development director <strong>Jason Adams</strong> share what they\'ve learned so far. <a href=\"https://poststatus.com/the-future-of-givewp-and-the-block-editor/\" target=\"_blank\" rel=\"noreferrer noopener\">READ→</a></p>\n\n\n\n<h2 id=\"h-evolving-edupack-and-sunsetting-it\"><a href=\"https://poststatus.com/evolving-edupack-a-one-size-fits-all-plugin-leads-to-an-accessibility-platform-and-enhanced-agency-services/\">Evolving Edupack</a> — and <a href=\"https://poststatus.com/keeping-higher-education-website-managers-dream-alive-while-sunsetting-edupack/\" target=\"_blank\" rel=\"noreferrer noopener\">Sunsetting It</a></h2>\n\n\n\n<p><strong>Blake Bertuccelli </strong>shares how a plugin that tried to do it all led to an accessibility platform and enhanced client services. <a href=\"https://poststatus.com/author/blake/\" target=\"_blank\" rel=\"noreferrer noopener\">READ→</a></p>\n\n\n\n<h2 id=\"h-quick-links\">Quick links</h2>\n\n\n\n<ul>\n<li>WordPress Terminology Meta at the <strong>WPwatercooler</strong>: Naming is hard, all over the WordPress ecosystem. This is <a href=\"https://wpwatercooler.com/devbranch/ep22-wordpress-terminology-meta/\">an important topic</a> that came out of a <strong>Post Status Slack #security</strong> discussion involving <strong>Robert Rowley</strong> and <strong>John James Jacoby</strong>.</li>\n\n\n\n<li>An overdue <strong>Do the Woo</strong> <a href=\"https://poststatus.com/catching-up-with-do-the-woo/\" target=\"_blank\" rel=\"noreferrer noopener\">roundup</a>.</li>\n\n\n\n<li><strong>Patchstack</strong>&#8216;s open vulnerability data is <a href=\"https://poststatus.com/patchstack-enriches-open-vulnerability-data-with-signals-showing-attack-volume-method-and-source/\">enriched with signals showing attack volume, method, and source</a>.</li>\n\n\n\n<li>To explore strange new words, to seek out bigger budgets without vendor lock-in, and to boldly go where your work is never done — these are the voyages of <a href=\"https://poststatus.com/the-enterprise/\">The Enterprise</a>. <a href=\"https://poststatus.com/the-enterprise/\" target=\"_blank\" rel=\"noreferrer noopener\">READ→</a></li>\n\n\n\n<li>Last-minute <strong>Black Friday</strong> tips for WordPress businesses from <strong>Alex Denning</strong> and <strong>Ellipsis</strong>. <a href=\"https://getellipsis.com/blog/black-friday-2022/\" target=\"_blank\" rel=\"noreferrer noopener\">READ→</a></li>\n\n\n\n<li><a href=\"https://newsletterglue.com/blog/customer-stories/post-status/\" target=\"_blank\" rel=\"noreferrer noopener\">How I redesigned the Post Status’ newsletter for improve readability</a>. Thank <strong>Lesley Sim</strong> for this colorful and more legible newsletter! <a href=\"https://newsletterglue.com/blog/customer-stories/post-status/\" target=\"_blank\" rel=\"noreferrer noopener\">READ→</a></li>\n</ul>\n<p>This article was published at Post Status — the community for WordPress professionals.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Fri, 18 Nov 2022 17:36:52 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:10:\"Dan Knauss\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:26;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:114:\"Post Status: Tom Willmot on the Challenges and Opportunities Facing Enterprise WordPress — Post Status Draft 130\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:32:\"https://poststatus.com/?p=144467\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:121:\"https://poststatus.com/tom-willmot-on-the-challenges-and-opportunities-facing-enterprise-wordpress-post-status-draft-130/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:9991:\"<div class=\"is-layout-flow wp-block-group eplus-wrapper has-theme-palette-2-color has-theme-palette-8-background-color has-text-color has-background\"><div class=\"wp-block-group__inner-container\"><div class=\"wp-block-post-excerpt\"><p class=\"wp-block-post-excerpt__excerpt\">Sparked by <strong>Magne Ilsaas</strong>&#8216;s ideas in <a href=\"https://poststatus.com/the-wordpress-enterprise-paradox/\">The WordPress Enterprise Paradox</a>, Tom started a Twitter thread and hosted a live discussion with Magne and others at enterprise WordPress agencies this week. Their main concern is the challenges that arise from not having a well-defined brand and market that allows &#8220;WordPress for the Enterprise&#8221; to stand out — without being ties to a particular WordPress company or host. After getting an outline of the problem as it stands today, I asked Tom what might help differentiate &#8220;Enterprise WordPress&#8221; as a collective or entire ecosystem of agencies operating within it. Can open-source values of sharing and cooperation shape a unique global identity for enterprise WordPress agencies? Is it time for an inter-agency association or &#8220;guild&#8221; to take on these challenges? </p></div>\n\n\n<div class=\"wp-block-spacer eplus-wrapper\"></div>\n\n\n\n<p class=\"yoast-reading-time__wrapper\"><span class=\"yoast-reading-time__icon\"></span><span class=\"yoast-reading-time__spacer\"></span><span class=\"yoast-reading-time__descriptive-text\">Estimated reading time:  </span><span class=\"yoast-reading-time__reading-time\">8</span><span class=\"yoast-reading-time__time-unit\"> minutes</span></p>\n</div></div>\n\n\n\n\n\n\n\n<p><a href=\"https://poststatus.com/planet/feed/#h-transcript\">Transcript</a> ↓</p>\n\n\n\n<p class=\"has-drop-cap\"><strong>Tom Willmot</strong> has been a WordPress pioneer and leader in the agency space since co-founding <strong>Human Made</strong> in 2010. Just in the past year, <strong>Human Made</strong> has more than doubled its size with a team of 100. Tom is also CEO and co-founder of <strong>Altis DXP</strong>, Human Made\'s enterprise WordPress digital experience platform. I caught up with Tom this week to find out what he\'s thinking about the challenges and opportunities of the enterprise market for WordPress agencies today. </p>\n\n\n\n<p>Sparked by <strong>Magne Ilsaas</strong>&#8216;s ideas in <a href=\"https://poststatus.com/the-wordpress-enterprise-paradox/\">The WordPress Enterprise Paradox</a>, Tom started <a href=\"https://twitter.com/tomwillmot/status/1589919739643834370\">a Twitter thread</a> and hosted a <a href=\"https://twitter.com/i/spaces/1OwxWwmOeykxQ?s=20\">live discussion</a> this week about the challenges of not having a well-defined brand and market for enterprise WordPress. In the minds of clients beyond the WordPress and open-source community not to mention unhelpful tech industry analysts, &#8220;WordPress&#8221; is something you can buy, and it\'s often confused with any number of related brands: <strong>Automattic</strong>, <strong>WordPress VIP</strong>, and managed WordPress hosts that support enterprise clients. </p>\n\n\n\n<p>After getting an outline of the problem as it stands today, I asked Tom what might help differentiate &#8220;Enterprise WordPress&#8221; as a collective or entire ecosystem of agencies operating within it. Can open-source values of sharing and cooperation shape a unique global identity for enterprise WordPress agencies? Is it time for an inter-agency association or &#8220;guild&#8221; to take on these challenges? (Human Made has <a href=\"https://handbook.hmn.md/working-here/guilds/\">an internal &#8220;guild&#8221; structure of cross-functional teams</a> — what could it look like to extend them across the whole agency space?)</p>\n\n\n\n<p>And how might that look within the WordPress ecosystem and others adjacent to it? Are more inter-agency gatherings needed along with greater participation in existing tech and design conferences? Will agencies like Human Made resume hosting conferences like their Day and Week of REST events in the past? Can the larger WordCamps cater to an enterprise track? Does Enterprise WordPress need its own conferences? I like <strong>Jeremy Keith</strong> and&nbsp;<strong>ClearLeft</strong> as <a href=\"https://clearleft.com/services/events-and-training/\" target=\"_blank\" rel=\"noreferrer noopener\">a model for agency thought leadership</a>. Magne has pointed to the <a href=\"https://www.sodaspeaks.com/\"><strong>Society of Digital Agencies</strong></a> (<strong>SoDA</strong>) as a model for organized peer collaboration and <strong><a href=\"https://buyersguidetowebprojects.com/\">North Patrol</a></strong> as a model for a research and advisory firm that connects agencies with clients and reports on regional enterprise web tech markets.</p>\n\n\n\n<p>This is an open, ongoing conversation. If it piques your interest, connect with Tom on Twitter. </p>\n\n\n\n<div class=\"is-layout-flow wp-block-group\"><div class=\"wp-block-group__inner-container\">\n<div class=\"is-layout-flex wp-container-22 wp-block-columns sponsor has-theme-palette-8-background-color has-background\" id=\"StellarWP\">\n<div class=\"is-layout-flow wp-block-column\">\n<h3 class=\"StellarWP has-theme-palette-1-color has-text-color\" id=\"Sponsor\"><img src=\"https://s.w.org/images/core/emoji/14.0.0/72x72/1f64f.png\" alt=\"🙏\" class=\"wp-smiley\" /> Sponsor: <span><a href=\"https://poststat.us/elementor\" rel=\"sponsored nofollow\">Elementor</a></span></h3>\n\n\n\n<p><strong>Elementor </strong>enables web creators to build professional, pixel-perfect websites with an intuitive visual builder. Quickly create amazing websites for your clients or your business with complete control over every piece, without writing a single line of code. Join <a href=\"https://elementor.com/community/\">a vast community of web creators</a> from all around the world who deliver exceptional websites using Elementor.</p>\n</div>\n\n\n\n<div class=\"is-layout-flow wp-block-column is-vertically-aligned-top\"><div class=\"wp-block-image elementor-logo\">\n<img src=\"https://cdn.poststatus.com/wp-content/uploads/2022/08/Elementor-Logo-Symbol-Blue-150x150.png\" alt=\"Elementor\" class=\"wp-image-104033\" width=\"150\" height=\"150\" title=\"Elementor Logo\" />Elementor</div></div>\n</div>\n</div></div>\n\n\n\n<p> </p>\n\n\n\n<h3 class=\"eplus-wrapper\" id=\"h-mentioned-in-the-show\"><img src=\"https://s.w.org/images/core/emoji/14.0.0/72x72/1f517.png\" alt=\"🔗\" class=\"wp-smiley\" /> Mentioned in the show:</h3>\n\n\n\n<ul>\n<li><a href=\"https://humanmade.com/\">Human Made</a> (<a href=\"https://github.com/humanmade/\">GitHub</a>) • <a href=\"https://tõm.com/\">Tom Willmot</a> • <a href=\"https://twitter.com/joe_hoyle?ref_src=twsrc%5Egoogle%7Ctwcamp%5Eserp%7Ctwgr%5Eauthor\">Joe Hoyle</a> • <a href=\"https://twitter.com/noeltock\">Noel Tock</a> \n<ul>\n<li><a href=\"https://www.altis-dxp.com/\">Altis DXP</a> (<a href=\"https://github.com/humanmade/altis\">GitHub</a>) • <a href=\"https://humanmade.com/2019/06/17/a-technical-introduction-to-altis-enterprise-augmented-wordpress-platform/\">A Technical Introduction to Altis</a> • <a href=\"https://www.altis-dxp.com/accelerate/\">Altis Accelerate</a> (<a href=\"https://wordpress.org/plugins/altis-accelerate/\">Plugin</a>)</li>\n\n\n\n<li><a href=\"https://tõm.com/how-i-work/\">How Tom Works</a></li>\n</ul>\n</li>\n\n\n\n<li><a href=\"https://www.forrester.com\">Forrester Research</a>\n<ul>\n<li><a href=\"https://www.forrester.com/report/now-tech-agile-content-management-systems-q2-2022/RES177332\">Now Tech: Agile Content Management Systems, Q2 2022</a></li>\n</ul>\n</li>\n\n\n\n<li><a href=\"https://www.gartner.com/reviews/market/digital-experience-platforms\">Gartner Peer Insights 2022 DXP Reviews and Ratings</a> \n<ul>\n<li><a href=\"https://www.gartner.com/doc/reprints?id=1-298FK2QX&ct=220224&st=sb\">Magic Quadrant for Digital Experience Platforms 2022</a></li>\n</ul>\n</li>\n</ul>\n\n\n\n<h3 class=\"eplus-wrapper\" id=\"h-you-can-follow-post-status-and-our-guests-on-twitter\"><img src=\"https://s.w.org/images/core/emoji/14.0.0/72x72/1f426.png\" alt=\"🐦\" class=\"wp-smiley\" /> You can follow Post Status and our guests on Twitter:</h3>\n\n\n\n<ul class=\"eplus-wrapper\">\n<li><a href=\"https://twitter.com/tomwillmot\">Tom Willmot</a> (CEO, <a href=\"https://twitter.com/humanmadeltd\">Human Made</a>)</li>\n\n\n\n<li><a href=\"https://twitter.com/dan_knauss\">Dan Knauss</a> (Editor, <a href=\"https://twitter.com/post_status\">Post Status</a>)</li>\n\n\n\n<li><a href=\"https://twitter.com/lemonadecode\">Olivia Bisset</a> (Intern, <a href=\"https://twitter.com/post_status\">Post Status</a>)</li>\n</ul>\n\n\n\n<p class=\"eplus-wrapper has-background\">The <strong>Post Status Draft</strong> podcast is geared toward WordPress professionals, with interviews, news, and deep analysis. <img src=\"https://s.w.org/images/core/emoji/14.0.0/72x72/1f4dd.png\" alt=\"📝\" class=\"wp-smiley\" /><br /><br /><a href=\"https://poststatus.com/category/post-status-podcasts/\" target=\"_blank\" rel=\"noreferrer noopener\">Browse our archives</a>, and don’t forget to subscribe via <a href=\"https://itunes.apple.com/us/podcast/post-status-draft-wordpress/id976403008\" target=\"_blank\" rel=\"noreferrer noopener\">iTunes</a>, <a href=\"https://podcasts.google.com/feed/aHR0cHM6Ly9mZWVkcy5zaW1wbGVjYXN0LmNvbS8ySkU5c2M4UA\" target=\"_blank\" rel=\"noreferrer noopener\">Google Podcasts</a>, <a href=\"https://www.youtube.com/c/PostStatus\" target=\"_blank\" rel=\"noreferrer noopener\">YouTube</a>, <a href=\"http://www.stitcher.com/podcast/krogsgard/post-status-draft-wordpress-podcast\" target=\"_blank\" rel=\"noreferrer noopener\">Stitcher</a>, <a href=\"https://wordpress-post-status-draft-podcast.simplecast.com/\" target=\"_blank\" rel=\"noreferrer noopener\">Simplecast</a>, or <a href=\"https://feeds.simplecast.com/2JE9sc8P\">RSS</a>. <img src=\"https://s.w.org/images/core/emoji/14.0.0/72x72/1f3a7.png\" alt=\"🎧\" class=\"wp-smiley\" /></p>\n\n\n\n<h2 class=\"eplus-wrapper\" id=\"h-transcript\">Transcript</h2>\n\n\n\n<p></p>\n<p>This article was published at Post Status — the community for WordPress professionals.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Fri, 18 Nov 2022 16:30:32 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:10:\"Dan Knauss\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:27;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:79:\"Do The Woo Community: A Sneak Peak into Do the Woo 4.0, Supporting Contributors\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:28:\"https://dothewoo.io/?p=73436\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:77:\"https://dothewoo.io/a-sneak-peak-into-do-the-woo-4-0-supporting-contributors/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:422:\"<p>In a recent podcast I gave a bit more insights to what you will be seeing with out newest update in early 2023.</p>\n<p>&gt;&gt; The post <a rel=\"nofollow\" href=\"https://dothewoo.io/a-sneak-peak-into-do-the-woo-4-0-supporting-contributors/\">A Sneak Peak into Do the Woo 4.0, Supporting Contributors</a> appeared first on <a rel=\"nofollow\" href=\"https://dothewoo.io\">Do the Woo - a WooCommerce Builder Community</a>	.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Fri, 18 Nov 2022 10:27:00 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:5:\"BobWP\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:28;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:63:\"Post Status: WordPress Tech Roundup for the Week of November 14\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:32:\"https://poststatus.com/?p=144586\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:74:\"https://poststatus.com/wordpress-tech-roundup-for-the-week-of-november-14/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:7153:\"<div class=\"is-layout-flow wp-block-group eplus-wrapper has-theme-palette-2-color has-theme-palette-8-background-color has-text-color has-background\"><div class=\"wp-block-group__inner-container\"><div class=\"wp-block-post-excerpt\"><p class=\"wp-block-post-excerpt__excerpt\">Learn Accessibility • The Return of SmashingConf • PHP 8.2 Release Delayed • Deno for Decoupled Front-End Development • LogoIpsum, Post to Telegram, and WP .gitgnore • Substack, the WordPress Plugin • Cool Tool: <a href=\"https://restrictwithstripe.com/\">Restrict With Stripe</a> </p></div>\n\n\n<div class=\"wp-block-spacer eplus-wrapper\"></div>\n\n\n\n<p class=\"yoast-reading-time__wrapper\"><span class=\"yoast-reading-time__icon\"></span><span class=\"yoast-reading-time__spacer\"></span><span class=\"yoast-reading-time__descriptive-text\">Estimated reading time:  </span><span class=\"yoast-reading-time__reading-time\">8</span><span class=\"yoast-reading-time__time-unit\"> minutes</span></p>\n</div></div>\n\n\n\n<h2>Learn Accessibility</h2>\n\n\n\n<p>Digital accessibility, commonly abbreviated <strong>a11y</strong>, is an important subject in web developer circles. More and more, folks are looking for solid guidance on designing and building websites and web apps that disabled people can interact with in a meaningful and equivalent way.</p>\n\n\n\n<p>Fortunately, thanks to <strong><a href=\"https://twitter.com/cariefisher\">Carie Fisher</a>,</strong> with input and review from <a href=\"https://twitter.com/heyawhite\"><strong>Alexandra White</strong></a> and <a href=\"https://twitter.com/rachelandrew\"><strong>Rachel Andr</strong>ew</a>, web developers can now take the free <a href=\"https://web.dev/learn/accessibility/\"><strong>Learn Accessibility</strong></a> course at <a href=\"https://web.dev/\"><strong>web.dev</strong></a>.</p>\n\n\n\n<p>This course is for beginner and advanced web developers. You can go through the series from start to finish to get a general understanding of accessibility practices and testing, or you can use it as a reference for specific subjects.</p>\n\n\n\n<div class=\"wp-block-kadence-spacer aligncenter kt-block-spacer-_fe6707-ad\"><div class=\"kt-block-spacer kt-block-spacer-halign-center\"><hr class=\"kt-divider\" /></div></div>\n\n\n\n<h2 id=\"h-the-return-of-smashingconf\">The Return of SmashingConf</h2>\n\n\n\n<p>Front-end developers rejoice, the yearly <a href=\"https://twitter.com/smashingconf\"><strong>SmashingConf</strong></a> hosted by the folks at <a href=\"https://twitter.com/smashingmag\"><strong>Smashing Magazine</strong></a> is <a href=\"https://twitter.com/smashingmag/status/1592489575863451649\">back in 2023</a>!</p>\n\n\n\n<p>SmashingConf has two events this year: one in <a href=\"https://smashingconf.com/sf-2023\">San Fransisco, US</a>, and one in <a href=\"https://smashingconf.com/freiburg-2023\">Freiburg, Germany</a>.</p>\n\n\n\n<p>SmashingConf SF will cover everything from accessibility and advanced <strong>CSS</strong> to <strong>JavaScript</strong> gems and web performance, while SmashingConf Freiburg is all about front-end, <strong>UX</strong>, and design.&nbsp;</p>\n\n\n\n<div class=\"wp-block-kadence-spacer aligncenter kt-block-spacer-_acdb2c-ee\"><div class=\"kt-block-spacer kt-block-spacer-halign-center\"><hr class=\"kt-divider\" /></div></div>\n\n\n\n<h2>PHP 8.2 Release Delayed</h2>\n\n\n\n<p>Due to some critical bugs related to <strong>OPcache</strong> that “are very likely to happen in a real-world use case” the <strong>PHP</strong> release managers have <a href=\"https://news-web.php.net/php.internals/118991/php.internals/\">decided to add another PHP 8.2.0 RC</a> and push back the final 8.2.0 release to December 8, 2022.</p>\n\n\n\n<p>With the fast pace at which new PHP releases have been coming out, it’s good to remember that early testing of release candidates is critical to solid releases.&nbsp;</p>\n\n\n\n<div class=\"wp-block-kadence-spacer aligncenter kt-block-spacer-_1cee3d-0d\"><div class=\"kt-block-spacer kt-block-spacer-halign-center\"><hr class=\"kt-divider\" /></div></div>\n\n\n\n<h2>Deno for Headless WordPress Themes</h2>\n\n\n\n<p>In a recent blog post on the <a href=\"https://deno.com/deploy\"><strong>Deno</strong></a> website, the team announced support for building <a href=\"https://deno.com/blog/introducing-fresh-wordpress-themes\">WordPress themes using the <strong>Fresh</strong> framework</a> as a front end for headless (or decoupled) WordPress.&nbsp;</p>\n\n\n\n<p>Deno is a runtime for <strong>JavaScript</strong>, <strong>TypeScript</strong>, and <strong>WebAssembly</strong> that is based on the <strong>V8 JavaScript</strong> engine and the <strong>Rust</strong> programming language. Created by <a href=\"https://tinyclouds.org/\"><strong>Ryan Dahl</strong></a>, the creator of the <strong>Node.js</strong> runtime, Deno aims to address some of Dahl’s regrets about the initial design decisions with Node.js.</p>\n\n\n\n<p>With the increased popularity of headless WordPress, this is an interesting entry into the space.</p>\n\n\n\n<div class=\"wp-block-kadence-spacer aligncenter kt-block-spacer-_4df434-ce\"><div class=\"kt-block-spacer kt-block-spacer-halign-center\"><hr class=\"kt-divider\" /></div></div>\n\n\n\n<h2 id=\"h-substack-the-wordpress-plugin\">Substack, the WordPress Plugin</h2>\n\n\n\n<p><strong>Ben Thompson</strong>’s <a href=\"https://stratechery.com/\">Stratechery</a> was a <strong>Substack</strong> inspiration and has always run on WordPress, but <a href=\"https://on.substack.com/p/five-years-of-substack-with-bill\">did you know Substack started as a WordPress product</a>?</p>\n\n\n\n<div class=\"wp-block-kadence-spacer aligncenter kt-block-spacer-_a1b824-37\"><div class=\"kt-block-spacer kt-block-spacer-halign-center\"><hr class=\"kt-divider\" /></div></div>\n\n\n\n<h2 id=\"h-logoipsum-post-to-telegram-and-wp-gitgnore\">LogoIpsum, Post to Telegram, and WP .gitgnore</h2>\n\n\n\n<ul>\n<li><a href=\"https://logoipsum.com/\">logoipsum.com</a> for free placeholder logos! Simple and sweet.</li>\n\n\n\n<li><strong>Jetpack</strong> and <strong>WordPress.com</strong> <a href=\"https://wordpress.com/blog/2022/07/18/publish-blog-posts-to-your-telegram-channel-automatically-with-jetpackwp-bot/\">can publish</a> to <strong>Telegram</strong>.</li>\n\n\n\n<li>The <a href=\"https://notesontech.com/wordpress-gitignore/\">ultimate gitignore for WordPress</a> projects.</li>\n</ul>\n\n\n\n<div class=\"is-layout-constrained wp-block-group has-theme-palette-8-background-color has-background\"><div class=\"wp-block-group__inner-container\">\n<h2>Cool Tool: <a href=\"https://restrictwithstripe.com/\">Restrict With Stripe</a></h2>\n\n\n\n<p>Each week we feature one cool tool that can help make your life easier as a WordPress builder.</p>\n\n\n\n<p><strong>Stranger Studios</strong> quietly launched a new e-commerce plugin for WordPress a few weeks ago: <a href=\"https://restrictwithstripe.com/\"><strong>Restrict With Stripe</strong></a>. If you love Stripe, it\'s for you. It connects to Stripe and lets you restrict a post, page, category, or tag by product so visitors must have purchased that product (or subscription) to get access to the restricted content. That\'s it.</p>\n</div></div>\n<p>This article was published at Post Status — the community for WordPress professionals.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Fri, 18 Nov 2022 10:00:26 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:18:\"Jonathan Bossenger\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:29;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:62:\"WPTavern: Jetpack Search Adds Free Tier and 3-Month Free Trial\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:30:\"https://wptavern.com/?p=139608\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:73:\"https://wptavern.com/jetpack-search-adds-free-tier-and-3-month-free-trial\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:3568:\"<p><a href=\"https://wordpress.org/plugins/jetpack-search/\">Jetpack Search</a>, a plugin that enhances WordPress&#8217; search capabilities, has <a href=\"https://jetpack.com/blog/jetpack-search-free-for-small-sites-and-free-trials-for-all/\">added a free tier</a> and a three-month free trial to what was previously only available as a paid upgrade. The plugin uses WordPress.com&#8217;s infrastructure to provide instant, more relevant search results without reloading the page, with real-time indexing, integration with WooCommerce, spelling correction, and more. </p>\n\n\n\n<p>Jetpack Search was <a href=\"https://wptavern.com/jetpack-goes-modular-with-more-features-now-available-as-individual-plugins\">launched as a standalone</a> plugin earlier this year but the user base hasn&#8217;t grown beyond a couple hundred active installs. The new free tier and free trials enable prospective customers to try out the functionality on their sites before committing to a new annual subscription.</p>\n\n\n\n<p>Free users are limited to 5k records (all posts, pages, and other types of content the site indexes) and 500 requests (every time a visitor searches for something on the site) per month. Sites that go over the limits will not be cut off for the first three months.</p>\n\n\n\n<p>At 10K records, pricing starts at $8.25/month, billed annually, and includes 10k requests, priority support, and unbranded search. When purchasing, <a href=\"https://twitter.com/gregibrown/status/1593314523158495232\">Jetpack estimates the size of the site</a>, but users who are not sure how many records they have can sign onto the free tier to find out. </p>\n\n\n\n<p>The previous pricing for Jetpack Search started at $2.50 per month (billed annually) for up to 100 records. The plugin&#8217;s support docs explain why Jetpack implemented this major pricing change:</p>\n\n\n\n<ol>\n<li><em>Many folks were only looking for Search and did not want to also be paying for features they didn’t need.</em></li>\n\n\n\n<li><em>Allowing an unlimited number of records felt unfair because it was preventing us from offering lower prices or making improvements. Our operating costs for a site with one million posts are much higher than for a site with one thousand posts, but both sites were paying the same amount. We also wanted to offer users a free option so that they can experience how great Jetpack Search is before making a commitment to buy.</em></li>\n</ol>\n\n\n\n<p>Jetpack assured existing search customers that the new pricing will not yet affect them until their plan renews and Automattic will contact them by email before the pricing changes.</p>\n\n\n\n<p>Jetpack Search is built on top of Elasticsearch, and currently uses version 7.16, which is Elastic&#8217;s proprietary offering after the company <a href=\"https://wptavern.com/elasticpress-io-service-considers-next-move-after-elasticsearch-abandons-open-source-licensing\">abandoned its open source licensing</a>. As a consequence, Amazon forked Elasticsearch and Kibana at version 7.10 to create the <a href=\"https://opensearch.org/\">OpenSearch</a> project.</p>\n\n\n\n<p>&#8220;We built our own solution on top of it. We use Elasticsearch to build Jetpack Search, but we also use a lot of our other systems, especially Jetpack Stats, to provide great search relevancy that you can’t get by just deploying Elasticsearch,&#8221; Jetpack Marketing Lead Rob Pugh said.</p>\n\n\n\n<p>&#8220;We are running both OpenSearch and Elasticsearch for different services but Jetpack Search is on ES. We&#8217;ll continue to consider both in the future.&#8221;</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Fri, 18 Nov 2022 03:40:42 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Sarah Gooding\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:30;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:22:\"Post Status: Two Tools\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:32:\"https://poststatus.com/?p=144143\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:33:\"https://poststatus.com/two-tools/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:450:\"<p><strong>Jetpack</strong> and <strong>WordPress.com</strong> <a href=\"https://wordpress.com/blog/2022/07/18/publish-blog-posts-to-your-telegram-channel-automatically-with-jetpackwp-bot/\">can publish</a> to <strong>Telegram</strong>.</p>\n\n\n\n<p>The <a href=\"https://notesontech.com/wordpress-gitignore/\">ultimate gitignore for WordPress</a> projects.</p>\n<p>This article was published at Post Status — the community for WordPress professionals.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Thu, 17 Nov 2022 21:37:22 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:10:\"Dan Knauss\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:31;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:45:\"Post Status: Are WebP and SVG Pixels Greener?\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:32:\"https://poststatus.com/?p=144155\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:55:\"https://poststatus.com/are-webp-and-svg-pixels-greener/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:1204:\"<p>As a followup to <a href=\"https://poststatus.com/how-green-is-webp-really/\">my note in August on this topic</a>, here\'s what Tom Greenwood had to say about WebP\'s value to sustainability in WordPress:</p>\n\n\n\n<blockquote class=\"wp-block-quote\">\n<p>I think as most browsers support WebP now, there is a real benefit to serving this format as it saves a lot on data transfer and improves performance. The downside perhaps is that most images are uploaded as JPG and pretty much all implementations that I have seen will then generate the WebP files as duplicates, so there is unfortunately an increase in data storage. I think the trade-off is worth it though.</p>\n\n\n\n<p>As for SVG, these can be way more efficient in terms of both data storage and transfer compared to JPG or WebP, but of course they should be well optimised, and I\'m not sure of an automated way to do that, so there is more hands on work there. The downside here is that complex SVG files could cause more CPU energy to be used on the end user\'s device, so the simpler the design and more optimised the files the better.</p>\n</blockquote>\n<p>This article was published at Post Status — the community for WordPress professionals.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Thu, 17 Nov 2022 17:46:00 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:10:\"Dan Knauss\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:32;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:92:\"Post Status: Pandemic experiences, “Are you disabled?” and the history of screen readers\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:32:\"https://poststatus.com/?p=143978\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:95:\"https://poststatus.com/pandemic-experiences-are-you-disabled-and-the-history-of-screen-readers/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:1343:\"<p>Back in July, <strong>Sabina Ionescu</strong> published <a href=\"https://www.codeinwp.com/blog/pandemic-vs-wordpress-two-years-after/\">a lot of different responses </a>from people in the WordPress community to questions about the impact of the pandemic on them. I missed it then, but it\'s still relevant and worth reading. </p>\n\n\n\n<p>Some other things I\'ve enjoyed but haven\'t slipped into a post yet:</p>\n\n\n\n<p><strong>Joanne Limburg</strong> discusses <a href=\"https://aeon.co/essays/what-does-it-mean-to-consider-yourself-a-disabled-person\">the agonizing and awful, inadequate disability/disabled questions</a> that come with job applications, government forms, etc.:</p>\n\n\n\n<blockquote class=\"wp-block-quote\">\n<p><strong>Do you consider yourself to be a disabled person?</strong></p>\n\n\n\n<p><strong>Yes: </strong>☐ <s><strong>No: </strong></s><s>☐</s><s><strong>Prefer not to say: </strong></s><s>☐</s></p>\n</blockquote>\n\n\n\n<p>The <a href=\"https://www.theverge.com/23203911/screen-readers-history-blind-henter-curran-teh-nvda\">history of screen readers</a> is incredible! <strong>Sheon Han</strong> tells their hidden story and how &#8220;blind programmers have been creating the tools their community needs&#8221; — for decades.</p>\n<p>This article was published at Post Status — the community for WordPress professionals.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Thu, 17 Nov 2022 14:34:00 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:10:\"Dan Knauss\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:33;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:92:\"Do The Woo Community: Piccia Neri, a Rocking Good UX Designer Passionate About Accessibility\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:28:\"https://dothewoo.io/?p=73508\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:90:\"https://dothewoo.io/piccia-neri-a-rocking-good-ux-designer-passionate-about-accessibility/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:475:\"<p>Piccia is passionate about good UX, and in this show offers some great user experience insights into both WordPress and WooCommerce sites.</p>\n<p>&gt;&gt; The post <a rel=\"nofollow\" href=\"https://dothewoo.io/piccia-neri-a-rocking-good-ux-designer-passionate-about-accessibility/\">Piccia Neri, a Rocking Good UX Designer Passionate About Accessibility</a> appeared first on <a rel=\"nofollow\" href=\"https://dothewoo.io\">Do the Woo - a WooCommerce Builder Community</a>	.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Thu, 17 Nov 2022 10:33:00 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:5:\"BobWP\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:34;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:111:\"Post Status: Patchstack enriches open vulnerability data with signals showing attack volume, method, and source\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:32:\"https://poststatus.com/?p=144216\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:120:\"https://poststatus.com/patchstack-enriches-open-vulnerability-data-with-signals-showing-attack-volume-method-and-source/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:2682:\"<p>Back in August, Oliver Sild announced in Post Status Slack that Patchstack was opening up &#8220;additional data&#8221; to &#8220;enrich the vulnerability data&#8221; their service discloses, now &#8220;with [a] real-time IP feed of attackers who hit [Patchstack\'s] virtual patches.&#8221; </p>\n\n\n\n<p>Virtual patches are Patchstack\'s quick interventions for customers\' sites when an official patch doesn\'t exist yet for a newly disclosed vulnerability. In Oliver\'s words, they are &#8220;security rules that protect from specific plugin/theme/core vulnerabilities.&#8221; So, if someone is actually hitting these virtual patches, it\'s very likely they are trying to probe or exploit a vulnerability. </p>\n\n\n\n<p>Since the large number of sites being protected by Patchstack\'s virtual patches makes a very big (but impenetrable) attack surface for new vulnerabilities and zero-day attacks, it makes a perfect attack monitoring network — or possibly even a honeypot for attackers. The data Patchstack can get from hits to their patches &#8220;gives more context to all vulnerabilities.&#8221; In other words, they can see if a particular vulnerability is being targeted heavily — or not at all. Then they can prioritize the attention of their security network partners and &#8220;fight fearmongering (<em>i.e low severity plugins that get to media, but we all know are not exploited</em>).&#8221;</p>\n\n\n\n<p>Oliver breaks down the details:</p>\n\n\n\n<blockquote class=\"wp-block-quote\">\n<p>We create those virtual patches on a daily basis for all new security vulnerabilities that we add to the Patchstack Database and protect a very large number of sites globally. That gives us an accurate coverage of both small and big attack campaigns targeting WordPress sites and plugins, but more importantly — we are often able to identify the attackers and their new methods first. The cool thing is that since our virtual patches cause no false positives, the same quality applies to our IP threat feed.</p>\n</blockquote>\n\n\n\n<p>This is cool indeed! WordPress security could go on the offensive with information like this and shut down attackers with the help of hosting partners. </p>\n\n\n\n<p>Patchstack is going to publicly release the actual attack levels for each vulnerability in their database, &#8220;but for anyone who needs such data in bulk (to apply on their entire hosting infrastructure or to network firewalls), here’s some more information already: <a href=\"https://patchstack.com/for-hosts/\" target=\"_blank\" rel=\"noreferrer noopener\">https://patchstack.com/for-hosts/</a></p>\n<p>This article was published at Post Status — the community for WordPress professionals.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Thu, 17 Nov 2022 05:00:00 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:10:\"Dan Knauss\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:35;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:53:\"WPTavern: Loudness: A New Block Theme from Automattic\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:30:\"https://wptavern.com/?p=139475\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:63:\"https://wptavern.com/loudness-a-new-block-theme-from-automattic\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:3200:\"<p>Automattic has released a new block theme called <a href=\"https://wordpress.org/themes/loudness/\">Loudness</a> that is available on both WordPress.com and WordPress.org. It&#8217;s an artistic and opinionated theme based on the company&#8217;s <a href=\"https://href.li/?https://github.com/Automattic/themes/tree/trunk/block-canvas\">Block Canvas</a> starter theme. Although Loudness&#8217; brief description suggests the theme was created for &#8220;music and learning,&#8221; the design and custom patterns lend themselves to a variety of different use cases. It could easily be used to whip up a quick event website with ticketing, an artist&#8217;s portfolio, or even a personal blog.</p>\n\n\n\n<img />\n\n\n\n<p>Loudness&#8217; typography features the energetic combination of the sans-serif <a href=\"https://fonts.google.com/specimen/Rubik\">Rubik</a> font for headers and <a href=\"https://fonts.google.com/specimen/DM+Mono\">DM Mono</a> for paragraph text. The type design and font development for DM Mono was commissioned from <a href=\"https://www.colophon-foundry.org/\">Colophon Foundry</a>, an award-winning type foundry based in London.</p>\n\n\n\n<p>Installing and activating the theme on a fresh website offers users a good experience, as it automatically puts everything in the design in place exactly like the <a href=\"https://wp-themes.com/loudness/\">live demo</a> on WordPress.com. Users don&#8217;t have to figure out which patterns to add in order to get it looking like the demo. </p>\n\n\n\n<p>Loudness packages 12 custom block patterns, which can be previewed on WordPress.org. The pattern organization in this theme could be improved, as Loudness&#8217; patterns are intermixed with selections from the pattern directory. It&#8217;s not easy to differentiate which ones belong to the theme. For purists who like to use only the patterns included in the theme to keep the design tight, it&#8217;s much easier when a theme creates a custom label in the pattern explorer for its own patterns.</p>\n\n\n\n<p>Not pictured in the demo is a full-width FAQ pattern with a dark color scheme, which matches the other quirky design elements in the theme.</p>\n\n\n\n<img />\n\n\n\n<p>In addition to the instructors pattern and pricing table shown in the demo, Loudness includes artistic designs for a pullquote pattern and a section of large text.</p>\n\n\n\n<img />\n\n\n\n<p>Two illustrations are included for use in the header area or to break up the design. They can easily be swapped out for a photo or a custom illustration from another source.</p>\n\n\n\n<img />\n\n\n\n<p>Loudness doesn&#8217;t include any style variations, likely because most of the patterns are highly dependent on the established color palette. Although users are free to alter it in the Site Editor, the results may not be as harmonious as expected when using the illustrations in the site design.</p>\n\n\n\n<p>Loudness is a unique block theme that makes a strong impression and can be creatively applied to many different types of websites &#8211; from events to blogs to businesses and agencies. The theme is <a href=\"https://wordpress.org/themes/loudness/\">available for free from WordPress.org</a> and is also available to users on WordPress.com.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Thu, 17 Nov 2022 01:47:03 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Sarah Gooding\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:36;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:40:\"Post Status: Catching up with Do the Woo\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:32:\"https://poststatus.com/?p=143970\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:51:\"https://poststatus.com/catching-up-with-do-the-woo/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:3251:\"<p>Bob puts out so much writing and audio at Do the Woo and has so many different people featured, it\'s hard to keep up! These are some recent ones I\'ve taken note of but didn\'t get into a post or newsletter. Definitely worth a listen:</p>\n\n\n\n<ul>\n<li>Did you know a client\'s involvement in a project makes it take 400% more time than it would without them? You can speed it up. <strong>Vito Peleg</strong> has <a href=\"https://dothewoo.io/woocommerce-project-delivery-proc\">lots of tips about delivery processes for WooCommerce projects</a>.</li>\n\n\n\n<li><strong>Milana Cap</strong> explains <a href=\"https://dothewoo.io/love-wp-cli/\">why she loves WP-CLI</a>.</li>\n\n\n\n<li><strong>Piccia Neri </strong>is <a href=\"https://dothewoo.io/piccia-neri-a-rocking-good-ux-designer-passionate-about-accessibility/\">a Rocking Good UX Designer and Passionate About Accessibility</a>!</li>\n\n\n\n<li><strong>Abha Thakor</strong> on <a href=\"https://dothewoo.io/storytelling-for-woocommerce-product-builders/\">why proper storytelling matters</a> and what it should look like for WooCommerce product builders.</li>\n\n\n\n<li><strong>Krissie VandeNoord</strong> on <a href=\"https://dothewoo.io/krissie-vandenoord-building-custom-solutions-with-woocommerce/\">Building Custom Solutions with WooCommerce</a>.</li>\n\n\n\n<li><a href=\"https://dothewoo.io/back-end-front-end-woocommerce-performance-insights/\">Front end and back end performance tips</a> for WooCommerce from <strong>Colm Troy</strong>.</li>\n\n\n\n<li><strong>David Mainayar</strong> and <strong>Robert Windisch</strong> make a very funny and insightful pair of guest experts on <a href=\"https://dothewoo.io/future-of-payments-woocommerce/\">the future of payments</a>. Is it just &#8220;a knife fight in the mud for the basis points on the transaction?&#8221;</li>\n\n\n\n<li><strong>Maciek Palmowski</strong> joins <strong>Zach Stepek</strong> and <strong>Carl Alexander</strong> to talk about <a href=\"https://dothewoo.io/continuous-integration-and-deployment/\">WooComerce and continuous Integration and deployment</a>. (CI/CD)</li>\n\n\n\n<li><a href=\"https://dothewoo.io/future-woocommerce-wordpress-blocks/\">The future of blocks is bright</a>, says <strong>Birgit Pauli-Haack</strong>.</li>\n\n\n\n<li><strong>BobWP</strong> himself on <a href=\"https://click.pstmrk.it/2sm/dothewoo.io%2Fthe-enigma-of-wordpress-and-woocommerce-partnerships%2F/dg3mCjAN/J7RK/sSkqbLLmqQ/YXV0b21hdGlvbi0xMTA\" target=\"_blank\" rel=\"noreferrer noopener\">WooCommerce partnerships</a>: affiliates, real business partners, sponsorships, and &#8220;soft&#8221; partners. </li>\n\n\n\n<li>This summer Bob shared his reflections on the history of Woo meetups and said he is considering <a href=\"https://dothewoo.io/what-about-that-woo-builder-meetup/\">a reboot</a> of some kind of in-person event — maybe even <a href=\"https://dothewoo.io/future-woocommerce-conference/\">a full conference</a>! Send him your thoughts.</li>\n\n\n\n<li>Best of all, Bob is starting to unroll his plans to <a href=\"https://dothewoo.io/a-sneak-peak-into-do-the-woo-4-0-supporting-contributors/\">help support WordPress contributors</a> by being a conduit for funding sources.</li>\n</ul>\n<p>This article was published at Post Status — the community for WordPress professionals.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Thu, 17 Nov 2022 00:29:01 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:10:\"Dan Knauss\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:37;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:43:\"Post Status: Naming is hard—but important\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:32:\"https://poststatus.com/?p=144121\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:52:\"https://poststatus.com/naming-is-hard-but-important/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:502:\"<p>This is <a href=\"https://wpwatercooler.com/devbranch/ep22-wordpress-terminology-meta/\">an important topic</a> that came out of a <strong>Post Status Slack #security</strong> discussion involving <strong>Robert Rowley</strong> and <strong>John James Jacoby</strong>: WordPress Terminology Meta. It continued over at the <strong>WPwatercooler</strong>.</p>\n\n\n\n<div class=\"wp-block-embed__wrapper\">\n\n</div>\n<p>This article was published at Post Status — the community for WordPress professionals.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Wed, 16 Nov 2022 21:17:59 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:10:\"Dan Knauss\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:38;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:86:\"Post Status: WordPress 6.1.1 • Team Rep Nominations • Codespaces for Contributions\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:32:\"https://poststatus.com/?p=144028\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:89:\"https://poststatus.com/wordpress-6-1-1-team-rep-nominations-codespaces-for-contributions/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:16163:\"<h2 id=\"h-this-week-at-wordpress-org-november-14-2022\">This Week at WordPress.org (November 14, 2022)</h2>\n\n\n<div class=\"has-background has-theme-palette-8-background-color wp-block-post-excerpt\"><p class=\"wp-block-post-excerpt__excerpt\">Time to update, WordPress 6.1.1 is out! GitHub has made Codespaces available for 60 hours/month, and WordPress is exploring Core contribution integrations with <code>wordpress/wordpress-develop</code>. It\'s team rep nomination time too. </p></div>\n\n\n<div class=\"wp-block-spacer\"></div>\n\n\n\n<div id=\"kt-info-box_68609b-a8\" class=\"wp-block-kadence-infobox\"><div class=\"kt-blocks-info-box-link-wrap kt-blocks-info-box-media-align-left kt-info-halign-left\"><div class=\"kt-blocks-info-box-media-container\"><div class=\"kt-blocks-info-box-media kt-info-media-animate-none\"><div class=\"kadence-info-box-icon-container kt-info-icon-animate-none\"><div class=\"kadence-info-box-icon-inner-container\"><span class=\"kt-info-svg-icon kt-info-svg-icon-fe_arrowUpCircle\"></span></div></div></div></div><div class=\"kt-infobox-textcontent\"><h2 class=\"kt-blocks-info-box-title\">WordPress 6.1.1 now available</h2><p class=\"kt-blocks-info-box-text\"><img src=\"https://s.w.org/images/core/emoji/14.0.0/72x72/1f680.png\" alt=\"🚀\" class=\"wp-smiley\" /> <a href=\"https://wordpress.org/news/2022/11/wordpress-6-1-1-maintenance-release/\">WordPress 6.1.1 Maintenance Release</a> <br /><img src=\"https://s.w.org/images/core/emoji/14.0.0/72x72/1f4bb.png\" alt=\"💻\" class=\"wp-smiley\" /> <a href=\"https://make.wordpress.org/core/2022/11/09/improving-the-contributor-experience-github-codespaces-for-wordpress-core/\">Improving the contributor experience: GitHub Codespaces for WordPress Core</a><br /><br /><img src=\"https://s.w.org/images/core/emoji/14.0.0/72x72/1f64b-1f3fc.png\" alt=\"🙋🏼\" class=\"wp-smiley\" /> <a href=\"https://make.wordpress.org/updates/2022/11/15/team-rep-nominations-2022/\">Team Rep Nominations, 2022</a></p></div></div></div>\n\n\n\n<h2 id=\"h-news\">News<a href=\"https://wordpress.org/news/2022/10/wordpress-6-1-release-candidate-3/\"></a></h2>\n\n\n\n<ul>\n<li><a href=\"https://wordpress.org/news/2022/11/wordpress-6-1-1-maintenance-release/\">WordPress 6.1.1 Maintenance Release</a></li>\n\n\n\n<li><a href=\"https://wordpress.org/news/2022/11/episode-43-openverse-photo-directory-what-are-they-and-how-are-they-different/\">WP Briefing: Episode 43: Openverse & Photo Directory– What Are They, and How Are They Different?</a></li>\n\n\n\n<li><a href=\"https://make.wordpress.org/updates/2022/11/15/team-rep-nominations-2022/\">Team Rep Nominations, 2022</a></li>\n</ul>\n\n\n\n<div class=\"wp-block-kadence-spacer aligncenter kt-block-spacer-_121b9e-cb\"><div class=\"kt-block-spacer kt-block-spacer-halign-center\"><hr class=\"kt-divider\" /></div></div>\n\n\n\n<div class=\"is-layout-flex wp-container-19 wp-block-columns\">\n<div class=\"is-layout-flow wp-block-column\">\n<h2 id=\"h-community\">Community</h2>\n\n\n\n<ul>\n<li><a href=\"https://make.wordpress.org/community/2022/11/15/recap-of-the-diverse-speaker-training-group-wpdiversity-amer-emea-on-november-9-2022/\">Recap of the Diverse Speaker Training group (#WPDiversity) AMER/EMEA on November 9, 2022</a></li>\n\n\n\n<li><a href=\"https://make.wordpress.org/community/2022/11/11/upcoming-wpdiversity-events-december-2022/\">Upcoming #WPDiversity Events: December 2022</a></li>\n\n\n\n<li><a href=\"https://make.wordpress.org/community/2022/11/10/community-team-rep-nominations-for-2023/\">Community Team Rep Nominations for 2023</a></li>\n</ul>\n\n\n\n<h2 id=\"h-core\"><a href=\"https://make.wordpress.org/core\">Core</a> </h2>\n\n\n\n<ul>\n<li><a href=\"https://make.wordpress.org/core/2022/11/15/a-week-in-core-november-14-2022/\">A Week in Core – November 14, 2022</a></li>\n\n\n\n<li><a href=\"https://make.wordpress.org/core/2022/11/14/nominations-for-core-team-reps-2023-edition/\">Nominations for Core Team Reps: 2023 Edition</a></li>\n\n\n\n<li><a href=\"https://make.wordpress.org/core/2022/11/09/wordpress-6-1-misha-retrospective/\">WordPress 6.1 ‘Misha’ Retrospective</a></li>\n\n\n\n<li><a href=\"https://make.wordpress.org/core/2022/11/09/improving-the-contributor-experience-github-codespaces-for-wordpress-core/\">Improving the contributor experience: GitHub Codespaces for WordPress Core</a></li>\n</ul>\n\n\n\n<h3 id=\"h-meetings\">Meetings</h3>\n\n\n\n<ul>\n<li><a href=\"https://make.wordpress.org/core/2022/11/15/dev-chat-agenda-wednesday-november-16-2022/\">Dev chat agenda: Wednesday, November 16, 2022</a></li>\n\n\n\n<li><a href=\"https://make.wordpress.org/core/2022/11/14/editor-chat-agenda-nov-16-2022/\">Editor Chat Agenda: November 16, 2022</a></li>\n</ul>\n\n\n\n<h2 id=\"h-design\"><a href=\"https://make.wordpress.org/design\">Design</a></h2>\n\n\n\n<ul>\n<li><a href=\"https://make.wordpress.org/design/2022/11/11/a-refresh-of-wordpress-org-showcase/\">A refresh of WordPress.org/Showcase</a></li>\n</ul>\n\n\n\n<h2 id=\"h-docs\"><a href=\"https://make.wordpress.org/docs\">Docs</a></h2>\n\n\n\n<ul>\n<li><a href=\"https://make.wordpress.org/docs/2022/11/15/summary-of-docs-team-meeting-15-november-2022/\">Summary of Docs Team Meeting: 15 November 2022</a></li>\n\n\n\n<li><a href=\"https://make.wordpress.org/docs/2022/11/14/13791/\">Agenda for 15 November 2022</a></li>\n</ul>\n\n\n\n<h2 id=\"h-hosting\"><a href=\"https://make.wordpress.org/hosting\">Hosting</a></h2>\n\n\n\n<ul>\n<li><a href=\"https://make.wordpress.org/hosting/2022/11/09/nominations-for-hosting-team-reps-2023/\">Nominations for Hosting Team Reps 2023</a></li>\n</ul>\n\n\n\n<h2 id=\"h-marketing\"><a href=\"https://make.wordpress.org/marketing\">Marketing</a></h2>\n\n\n\n<ul>\n<li><a href=\"https://make.wordpress.org/marketing/2022/11/16/2023-team-rep-nominations-for-marketing/\">2023 Team Rep Nominations for Marketing</a></li>\n\n\n\n<li><a href=\"https://make.wordpress.org/marketing/2022/11/16/agenda-global-marketing-team-meeting-november-16-2022/\">Agenda: global Marketing Team meeting, November 16, 2022</a></li>\n\n\n\n<li><a href=\"https://make.wordpress.org/marketing/2022/11/16/notes-global-marketing-team-meeting-november-9-2022/\">Notes: Global Marketing Team meeting, November 9, 2022</a></li>\n</ul>\n\n\n\n<h2 id=\"h-meta\"><a href=\"https://make.wordpress.org/meta\">Meta</a></h2>\n\n\n\n<ul>\n<li><a href=\"https://make.wordpress.org/meta/2022/10/21/wordpress-org-redesign-update/\">WordPress.org Redesign Update</a></li>\n</ul>\n\n\n\n<h2 id=\"h-mobile\"><a href=\"https://make.wordpress.org/mobile\">Mobile</a></h2>\n\n\n\n<ul>\n<li><a href=\"https://make.wordpress.org/mobile/2022/11/15/call-for-testing-wordpress-for-android-21-2/\">Call for Testing: WordPress for Android 21.2</a></li>\n\n\n\n<li><a href=\"https://make.wordpress.org/mobile/2022/11/14/call-for-testing-wordpress-for-ios-21-2/\">Call for Testing: WordPress for iOS 21.2</a></li>\n\n\n\n<li><a href=\"https://make.wordpress.org/updates/2022/11/15/mobile-team-update-november-15th/\">Mobile Team Update – November 15th</a></li>\n</ul>\n\n\n\n<h2 id=\"h-openverse\"><a href=\"http://make.wordpress.org/openverse\">Openverse</a></h2>\n\n\n\n<ul>\n<li><a href=\"https://make.wordpress.org/openverse/2022/11/16/openverse-now-includes-over-1-million-audio-records/\">Openverse Now Includes Over 1 Million Audio Records</a></li>\n\n\n\n<li><a href=\"https://make.wordpress.org/openverse/2022/11/16/thinking-towards-2023/\">Thinking towards 2023</a></li>\n\n\n\n<li><a href=\"https://make.wordpress.org/openverse/2022/11/16/record-number-of-contributors-for-the-catalog/\">Record number of contributors for the Catalog</a></li>\n\n\n\n<li><a href=\"https://make.wordpress.org/openverse/2022/11/15/community-meeting-recap-15-november-2022/\">Community Meeting Recap (15 November 2022)</a></li>\n</ul>\n\n\n\n<h2 id=\"h-performance\"><a href=\"https://make.wordpress.org/performance/\">Performance</a></h2>\n\n\n\n<ul>\n<li><a href=\"https://make.wordpress.org/core/2022/11/15/performance-chat-summary-15-november-2022/\">Performance Chat Summary: 15 November 2022</a></li>\n</ul>\n</div>\n\n\n\n<div class=\"is-layout-flow wp-block-column\">\n<h2 id=\"h-polyglots\">Polyglots</h2>\n\n\n\n<ul>\n<li><a href=\"https://make.wordpress.org/polyglots/2022/11/16/polyglots-outreach-effort-november-2022/\">Polyglots Outreach Effort: November 2022</a></li>\n\n\n\n<li><a href=\"https://make.wordpress.org/polyglots/2022/11/15/agenda-weekly-polyglots-chat-nov-16-2022-700-utc/\">Agenda: Weekly Polyglots Chat – Nov. 16, 2022 (7:00 UTC)</a></li>\n\n\n\n<li><a href=\"https://make.wordpress.org/polyglots/2022/11/08/call-for-polyglots-team-representatives-2/\">Call for Polyglots Team Representatives</a></li>\n</ul>\n\n\n\n<h2 id=\"h-project\"><a href=\"https://make.wordpress.org/project\">Project</a></h2>\n\n\n\n<ul>\n<li><a href=\"https://make.wordpress.org/project/2022/11/01/sustainability-channel-what-should-we-do/\">Now we have a sustainability channel in Making WordPress Slack, what should we do?</a></li>\n</ul>\n\n\n\n<h2><a href=\"https://make.wordpress.org/support\">Support</a></h2>\n\n\n\n<ul>\n<li><a href=\"https://make.wordpress.org/support/2022/11/agenda-support-team-meeting-thursday-november-11-2022/\">Agenda: Support Team Meeting Thursday, November 10, 2022</a></li>\n\n\n\n<li><a href=\"https://make.wordpress.org/support/2022/10/october-27th-support-team-meeting-summary-2/\">October 27th Support Team Meeting Summary</a></li>\n</ul>\n\n\n\n<h2 id=\"h-test\"><a href=\"https://make.wordpress.org/test\">Test</a></h2>\n\n\n\n<ul>\n<li><a href=\"https://make.wordpress.org/test/2022/11/13/fse-program-exploration-site-editor-sneak-peek/\">FSE Program Exploration: Site Editor Sneak Peek</a></li>\n\n\n\n<li><a href=\"https://make.wordpress.org/updates/2022/11/14/test-team-update-14-november-2022/\">Test Team Update: 14 November 2022</a></li>\n</ul>\n\n\n\n<h2 id=\"h-themes\"><a href=\"https://make.wordpress.org/themes\">Themes</a></h2>\n\n\n\n<ul>\n<li><a href=\"https://make.wordpress.org/themes/2022/11/16/nominations-call-for-the-themes-team-representatives-2023-edition/\">Nominations Call for the themes team representatives: 2023 Edition</a></li>\n\n\n\n<li><a href=\"https://make.wordpress.org/themes/2022/11/09/themes-team-meeting-notes-november-08-2022/\">Themes Team Meeting Notes –&nbsp;November 08, 2022</a></li>\n\n\n\n<li><a href=\"https://make.wordpress.org/updates/2022/11/15/themes-team-update-november-15-2022/\">Themes team update November 15, 2022</a></li>\n</ul>\n\n\n\n<h2 id=\"h-training\"><a href=\"https://make.wordpress.org/training\">Training</a></h2>\n\n\n\n<ul>\n<li><a href=\"https://learn.wordpress.org/individual-learner-survey/\">How did you learn WordPress?</a></li>\n\n\n\n<li><a href=\"https://make.wordpress.org/training/2022/11/09/choosing-accessible-contrasting-dark-theme-colors-for-online-workshops-and-tutorial-videos/\">Choosing accessible/contrasting dark theme colors for online workshops and tutorial videos</a></li>\n\n\n\n<li><a href=\"https://make.wordpress.org/training/2022/11/15/november-2022-faculty-meeting/\">November 2022 Faculty Meeting</a></li>\n\n\n\n<li><a href=\"https://make.wordpress.org/training/2022/11/14/meeting-agenda-for-november-15-2022/\">Meeting Agenda for November 15, 2022</a></li>\n\n\n\n<li><a href=\"https://make.wordpress.org/training/2022/11/09/choosing-accessible-contrasting-dark-theme-colors-for-online-workshops-and-tutorial-videos/\">Choosing accessible/contrasting dark theme colors for online workshops and tutorial videos</a></li>\n\n\n\n<li><a href=\"https://make.wordpress.org/training/2022/11/09/training-team-meeting-recap-for-november-1-2022/\">Training Team Meeting Recap for November 1, 2022</a></li>\n\n\n\n<li><a href=\"https://make.wordpress.org/training/2022/11/07/project-thread-content-localization-foundations/\">Project Thread: Content Localization Foundations</a></li>\n</ul>\n\n\n\n<h3 id=\"h-lesson-plans\"><a href=\"https://learn.wordpress.org/lesson-plans\">Lesson Plans</a></h3>\n\n\n\n<ul>\n<li><a href=\"https://learn.wordpress.org/lesson-plan/%E0%A4%AA%E0%A4%BE%E0%A4%A0-%E0%A4%AF%E0%A5%8B%E0%A4%9C%E0%A4%A8%E0%A4%BE-%E0%A4%95%E0%A5%88%E0%A4%B8%E0%A5%87-%E0%A4%AC%E0%A4%A8%E0%A4%BE%E0%A4%8F%E0%A4%82/\">पाठ योजना कैसे बनाएं</a></li>\n\n\n\n<li><a href=\"https://learn.wordpress.org/lesson-plan/%E0%A4%AA%E0%A4%BE%E0%A4%A0-%E0%A4%AF%E0%A5%8B%E0%A4%9C%E0%A4%A8%E0%A4%BE-%E0%A4%95%E0%A4%B8%E0%A4%B0%E0%A5%80-%E0%A4%AC%E0%A4%A8%E0%A4%BE%E0%A4%89%E0%A4%A8%E0%A5%87/\">पाठ योजना कसरी बनाउने</a></li>\n</ul>\n\n\n\n<h3 id=\"h-tutorials\">Tutorials</h3>\n\n\n\n<ul>\n<li><a href=\"https://learn.wordpress.org/tutorial/block-spacing/\">Block Spacing</a></li>\n</ul>\n\n\n\n<h3 id=\"h-online-workshops\">Online Workshops</h3>\n\n\n\n<ul>\n<li><a href=\"https://learn.wordpress.org/?meeting=demystifying-gutenberg-2\">Demystifying Gutenberg</a></li>\n\n\n\n<li><a href=\"https://learn.wordpress.org/?meeting=demystifying-gutenberg\">Demystifying Gutenberg</a></li>\n\n\n\n<li><a href=\"https://learn.wordpress.org/?meeting=thessaloniki-wordpress-meetup-block-theme-workshop-part-2\">Thessaloniki WordPress Meetup: Block Theme Workshop – Part 2</a></li>\n\n\n\n<li><a href=\"https://learn.wordpress.org/?meeting=wordpress-development-live-stream-developing-blocks-without-react-part-2\">WordPress development live stream: Developing Blocks without React – Part 2</a></li>\n</ul>\n\n\n\n<h2 id=\"h-wptv\">WPTV</h2>\n\n\n\n<ul>\n<li><a href=\"https://meta.trac.wordpress.org/ticket/1430\">WordPress TV videos are now auto-published to YouTube</a></li>\n\n\n\n<li><a href=\"https://wordpress.tv/category/year/2022/\">Latest WordPress TV videos</a></li>\n</ul>\n</div>\n</div>\n\n\n\n<hr class=\"wp-block-separator has-alpha-channel-opacity\" />\n\n\n\n<h2 id=\"h-related-news\">Related News:</h2>\n\n\n\n<ul>\n<li><a href=\"https://tc39.es/#proposals\">ECMAScript Proposals</a></li>\n</ul>\n\n\n\n<p class=\"has-theme-palette-7-background-color has-background\">Thanks for reading our WP dot .org roundup! Each week we are highlighting the news and discussions coming from the good folks making WordPress possible. If you or your company create products or services that use WordPress, you need to be engaged with them and their work. Be sure to share this resource with your product and project managers. <br /><br /><strong>Are you interested in giving back and contributing your time and skills to WordPress.org?</strong> <img src=\"https://s.w.org/images/core/emoji/14.0.0/72x72/1f64f.png\" alt=\"🙏\" class=\"wp-smiley\" /> <a href=\"https://wordpress.org/support/article/contributing-to-wordpress/\">Start Here ›</a><br /><br /><strong>Get our weekly WordPress community news digest</strong> — Post Status\' <a href=\"https://poststatus.com/news/week-in-review/\">Week in Review</a> — covering the WP/Woo news plus significant writing and podcasts. It\'s also available in <a href=\"https://poststatus.com/newsletter\">our newsletter</a>. <img src=\"https://s.w.org/images/core/emoji/14.0.0/72x72/1f48c.png\" alt=\"💌\" class=\"wp-smiley\" /></p>\n\n\n\n<div class=\"wp-block-spacer\"></div>\n\n\n\n<div class=\"wp-block-media-text alignwide is-stacked-on-mobile has-background\"><a href=\"https://poststatus.com/\"><img src=\"https://cdn.poststatus.com/wp-content/uploads/2021/09/vertical-post-status-logo-250.png\" alt=\"Post Status\" class=\"wp-image-85823 size-full\" /></a><div class=\"wp-block-media-text__content\">\n<p class=\"has-text-align-left has-normal-font-size\" id=\"h-get-ready-for-remote-work\">You — and <a href=\"https://poststatus.com/#Agency\">your whole team</a> can <a href=\"https://poststatus.com/#choose-membership\">Join Post Status</a> too!</p>\n\n\n\n<p class=\"has-text-align-left has-small-font-size\"><strong>Build your network. Learn with others. Find your next job — or your next hire.</strong> Read the <strong>Post Status</strong> <a href=\"https://poststatus.com/newsletter/\">newsletter</a>. <img src=\"https://s.w.org/images/core/emoji/14.0.0/72x72/2709.png\" alt=\"✉\" class=\"wp-smiley\" /> Listen to <a href=\"https://poststatus.com/podcasts/\">podcasts</a>. <img src=\"https://s.w.org/images/core/emoji/14.0.0/72x72/1f399.png\" alt=\"🎙\" class=\"wp-smiley\" /> Follow <a href=\"https://twitter.com/post_status/\">@Post_Status</a> <img src=\"https://s.w.org/images/core/emoji/14.0.0/72x72/1f426.png\" alt=\"🐦\" class=\"wp-smiley\" /> and <a href=\"https://www.linkedin.com/company/post-status-llc/\">LinkedIn</a>. <img src=\"https://s.w.org/images/core/emoji/14.0.0/72x72/1f4bc.png\" alt=\"💼\" class=\"wp-smiley\" /></p>\n</div></div>\n\n\n\n<div class=\"wp-block-spacer\"></div>\n<p>This article was published at Post Status — the community for WordPress professionals.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Wed, 16 Nov 2022 19:36:44 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:18:\"Courtney Robertson\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:39;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:69:\"WPTavern: WordCamp Asia 2023 Announces Speakers, Unveils Wapuu Mascot\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:30:\"https://wptavern.com/?p=139547\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:79:\"https://wptavern.com/wordcamp-asia-2023-announces-speakers-unveils-wapuu-mascot\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:2443:\"<p>WordCamp Asia 2023, the first flagship event to take place in Asia, is just a few months away, scheduled for February 17-19, 2023, in Bangkok, Thailand. Organizers have <a href=\"https://asia.wordcamp.org/2023/speakers-announcement-round-1/\">announced the first round of speakers</a>, a diverse selection of WordPress professionals from Asia and across the globe.</p>\n\n\n\n<img />\n\n\n\n<p>The event has also <a href=\"https://asia.wordcamp.org/2023/meet-wordcamp-asia-2023-wapuu/\">unveiled its wapuu mascot</a>. After receiving 10 design submissions from eight designers from India, Malaysia, Hong Kong, the Philippines, Taiwan, and Japan, organizers selected the Chao Phraya Boat Wapuu. Designer Chiaki Kouno explained the concept:</p>\n\n\n\n<blockquote class=\"wp-block-quote\">\n<p>This boat takes us to the venue “Icon Siam” on the Chao Phraya River! The boat contains the key colours of the WCA and the WCA logo is displayed on the ball. There is a splash of waves expressing a speedy feeling, showing everyone’s expectations for the last three years.</p>\n</blockquote>\n\n\n\n<img />\n\n\n\n<p>WordCamp Asia is running a series of webinars for contributors and attendees. The first episode was broadcast on Twitter this week and is embedded below. Organizers are asking contributors to share their stories in text, audio, or video format, to encourage newcomers to participate in the Contributor Day event. The webinar also featured tours of<strong> </strong>ICONSIAM, a beautiful and modern venue where the first WordCamp Asia will take place.</p>\n\n\n\n<p>Organizers <a href=\"https://asia.wordcamp.org/2023/childcare-services-at-wordcamp-asia/\">published a notice</a> that there will be no childcare offered at the WordCamp, due to the potential for COVID-19 transmission. Nursing and changing facilities are available the 4th and 5th floor of the venue, which also offers some children&#8217;s entertainment options. Those who are 12 years old and younger can attend the conference for free if accompanied by an adult who has purchased a ticket.</p>\n\n\n\n<div class=\"wp-block-embed__wrapper\">\n<blockquote class=\"twitter-tweet\"><p lang=\"en\" dir=\"ltr\">WordCamp Asia 2023 Contributor Series | Episode 01: Introduction <a href=\"https://t.co/5HdpCu2WvU\">https://t.co/5HdpCu2WvU</a></p>&mdash; WordCamp Asia (@WordCampAsia) <a href=\"https://twitter.com/WordCampAsia/status/1592518105737334787?ref_src=twsrc%5Etfw\">November 15, 2022</a></blockquote>\n</div>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Wed, 16 Nov 2022 19:19:46 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Sarah Gooding\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:40;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:87:\"WPTavern: #51 – Adam Lowe on Building Websites With Pinegrow’s New WordPress Plugin\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:48:\"https://wptavern.com/?post_type=podcast&p=139471\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:98:\"https://wptavern.com/podcast/51-adam-lowe-on-building-websites-with-pinegrows-new-wordpress-plugin\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:52951:\"Transcript<div>\n<p>Jukebox is a podcast which is dedicated to all things WordPress. The people, the events, the plugins, the blocks, the themes, and in this case using the new plugin from Pinegrow to create complex WordPress websites.</p>\n\n\n\n<p>If you&#8217;d like to subscribe to the podcast, you can do that by searching for WP Tavern in your podcast, player of choice. Or by going to WPTavern.com forward slash feed forward slash podcast. And you can copy that URL into most podcast players. If you have a topic that you&#8217;d like us to feature on the podcast, I&#8217;m keen to hear from you, and hopefully get you, or your idea, featured on the show.</p>\n\n\n\n<p>Head over to WPTavern.com forward slash contact forward slash jutebox and use the contact form there.</p>\n\n\n\n<p>So on the podcast today, we have Adam Lowe. Adam runs Peak Performance Digital, a small web consulting agency in Washington, DC, which specializes in providing website strategy along with custom WordPress solutions.</p>\n\n\n\n<p>He&#8217;s on the podcast today to talk about a new plugin from Pinegrow. Adam does not represent the company, but as an avid user of their products and experienced in how they work. The Pinegrow web editor is a desktop tool that lets you build websites with a graphical user interface.</p>\n\n\n\n<p>The closest comparison would be a page builder, but this is not entirely accurate. Unlike most page builders, which require very little technical expertise. Pinegrow does require an understanding of technology such as CSS, SASS Grid, Bootstrap, Tailwind CSS, to make use of the platform. The intention of the tool is to make it possible to create complex sites, but with a close eye on the HTML and CSS that is being output.</p>\n\n\n\n<p>Given the popularity of WordPress, the Pinegrow developers have created a WordPress plugin, which is just about to be released. It&#8217;s in closed beta and Adam has been using it as his go-to solution for several months now.</p>\n\n\n\n<p>We talk about what the platform can do and how it works. It&#8217;s not going to be a plugin for beginners, and there&#8217;s going to be a learning curve for those who do take the plunge. It&#8217;s intended as a bit of a bridge between novices and WordPress experts.</p>\n\n\n\n<p>We also get into a discussion about the fact that Pinegrow is intended to be a no dependency solution. Once you finished creating your theme block or whatever else you might want to create, you can export that in a way that no longer needs Pinegrow at all. If you&#8217;re curious about new ways to create websites in WordPress, have a listen to the podcast and see if Pinegrow is a good fit.</p>\n\n\n\n<p>If you&#8217;re interested in finding out more, you can find all of the links in the show notes by heading over to WPTavern.com forward slash podcast, where you&#8217;ll find all the other episodes as well.</p>\n\n\n\n<p>And so without further delay, I bring you Adam Lowe.</p>\n\n\n\n<p>I am joined on the podcast today by Adam Lowe. Hello, Adam.</p>\n\n\n\n<p>[00:03:46] <strong>Adam Lowe:</strong> Hello.</p>\n\n\n\n<p>[00:03:47] <strong>Nathan Wrigley:</strong> It is very nice to have you on the podcast today. We normally begin with a little bit of a brief introduction from our guests, just so that we can orientate ourselves around who you are, what your relationship is with WordPress. So if you wouldn&#8217;t mind, just for a few moments, just briefly describe your past in the WordPress space or with tech in a more general way.</p>\n\n\n\n<p>[00:04:07] <strong>Adam Lowe:</strong> I had been in the website space for a long time. I started in the late nineties. I actually think that I built my first website and sold my first in website 1997. And I&#8217;ve been around WordPress since the very first version, I think that was called Miles Davis actually. Used it for quite a while. Took a little bit of time away while I worked in-house in corporate, using some enterprise products. And then I got back into it again, I guess six or seven years ago. So it&#8217;s been a really interesting journey and seeing how far it&#8217;s come in that time period has been incredible.</p>\n\n\n\n<p>[00:04:36] <strong>Nathan Wrigley:</strong> You are on the podcast today to talk about a particular tool that you&#8217;ve been using. It&#8217;s a curious tool in that it is soon to be a WordPress plugin. So the features that the desktop version has had for a long time are being ported over into a WordPress plugin so that you can use it inside different installs of WordPress.</p>\n\n\n\n<p>It&#8217;s called Pinegrow. If you&#8217;ve not come across Pinegrow before, maybe it&#8217;s a good idea to pause the podcast and go Google Pinegrow. I&#8217;m sure you&#8217;ll find it. You can see exactly what it does, but would you be able to, first of all, lay out what Pinegrow is, and also would you just make it clear what your relationship to the company is? Because I think that might be an important thing to clarify right at the start.</p>\n\n\n\n<p>[00:05:19] <strong>Adam Lowe:</strong> It definitely is and I appreciate that. So Pinegrow, it looks like a page builder. It acts like a page builder. It smells like a page builder, but it&#8217;s not a page builder. Pinegrow is actually a theme builder and a block plugin builder, and what it does is it lets you visually create websites and visually create blocks and themes, and then it takes what you create in their builder and it spits out WordPress native code.</p>\n\n\n\n<p>So it uses native WordPress functions and all of that to, spit out React blocks, and PHP themes that you can just move to your website and install like you would anything else that you had hand coded. So, whereas most page builders live inside of WordPress and require you to have it installed and running, Pinegrow doesn&#8217;t need that.</p>\n\n\n\n<p>Pinegrow is just a builder that lets you, build things, basically code in a very visual manner. My relation to them is, I&#8217;m just a user. I pay for the product. I didn&#8217;t even think that it was going to be my main product a year and a half ago, but the more that I&#8217;ve used it, the more I&#8217;ve come to rely on it and I see the benefits of it.</p>\n\n\n\n<p>So I have developed a very close relationship with the company. I&#8217;m not employed by them. They don&#8217;t pay me, nothing like that. I just feel very passionate about this as a product and it definitely suits my needs from a business standpoint.</p>\n\n\n\n<p>[00:06:36] <strong>Nathan Wrigley:</strong> That&#8217;s good to clear up. Thank you for that. The intention of the product then, in the future will be that the desktop version that you&#8217;ve been using for years, is now going to be a WordPress plugin. In other words, you could install it on different sites, and you could modify all of the different pieces of your WordPress website.</p>\n\n\n\n<p>But just to be clear, once you have finished that work and exported a theme or a plugin, block, whatever it may be, you&#8217;re making the point that it&#8217;s no longer required. There isn&#8217;t a dependency to have that plugin installed any longer. You could whip it out. Remove all trace of Pinegrow, and everything should still just work.</p>\n\n\n\n<p>[00:07:17] <strong>Adam Lowe:</strong> That&#8217;s absolutely right. And when I talked to Matjaž a few, I guess several months ago, and he was telling me about this project, I had asked him, hey, is it possible to be able to do this sort of thing? And he came back and said, yes. And my mind was completely blown. I just didn&#8217;t think that anyone was going to be, maybe brave enough or, able to build something like that.</p>\n\n\n\n<p>And when he came back and said that, yes, this is the way that it already works, I was like, I need to get in this beta. And maybe two months ago he invited me into the private beta, and I&#8217;ve been testing it ever since. And yeah, it&#8217;s incredible that that&#8217;s what it does. It is just a builder that, it creates a plugin that you activate like a normal plugin or creates a theme that you activate like a normal theme. And once you&#8217;ve got it in there, the need for the Pinegrow builder plugin is gone. The only reason why you would potentially need or even want it, is if you wanted to make a change to that theme or to that block plugin. So there is still a benefit of having it on there, but it&#8217;s definitely not a dependency or a requirement.</p>\n\n\n\n<p>[00:08:12] <strong>Nathan Wrigley:</strong> Yeah, that&#8217;s really quite interesting. Obviously, if we&#8217;re using a typical page builder, if we remove the page builder, the page will look entirely different. But in this scenario, everything should still look the same because it&#8217;s not requiring Pinegrow from that moment on.</p>\n\n\n\n<p>[00:08:26] <strong>Adam Lowe:</strong> Exactly.</p>\n\n\n\n<p>[00:08:27] <strong>Nathan Wrigley:</strong> I&#8217;ve watched a few of your YouTube videos and I think we should probably figure out who the target audience for this is first, because the promise of page builders really is that more or less anybody can start building a website. And obviously, the advent of Gutenberg and full site editing and so on, that is hoped to be the promise. That anybody can log in and with a little bit of orientation and familiarization, they can start dropping things into the page and come up with something, perhaps use templates and modify those templates and so on.</p>\n\n\n\n<p>I think it&#8217;s fair to say that Pinegrow is not really aimed at that target audience. It feels to me like the barrier to entry may be a little bit higher than that. Have you got anything to, to add to that?</p>\n\n\n\n<p>[00:09:10] <strong>Adam Lowe:</strong> You&#8217;re right on the money. It is definitely not aimed at the new person. It&#8217;s not aimed at the Elementor crowd. It&#8217;s not aimed at even the DIY person. Originally Pinegrow was aimed at developers, and the desktop version, which is continuing to be supported and available. The desktop version continues to have more and different features than the website plugin. But that is really aimed towards people who want to get into the weeds.</p>\n\n\n\n<p>For the WordPress plugin, they&#8217;ve definitely put some considerations in there for people who aren&#8217;t quite as comfortable in code. So we&#8217;ve got some quick start tutorials. We&#8217;ve got some more, a little bit more handholding, but not as much as you would get with an Elementor. The best audience for Pinegrow would be somebody who is comfortable with code but doesn&#8217;t want to use it.</p>\n\n\n\n<p>Or maybe somebody who is trying to learn a little bit of code, or knows the concepts, but doesn&#8217;t want to get in there and write PHP, HTML, CSS all day long.</p>\n\n\n\n<p>[00:10:06] <strong>Nathan Wrigley:</strong> Is the reason for that because you need to have some sort of understanding, familiarity with the way WordPress works internally. Because this is generating, essentially code? You need to really understand where that code needs to be deployed, which lines of the HTML for example, it is that you&#8217;re going to target with various things. You need to basically have some understanding, otherwise, is it just going to be a purely frustrating experience?</p>\n\n\n\n<p>[00:10:32] <strong>Adam Lowe:</strong> That&#8217;s exactly what it is, and you need to have a conceptual understanding of how WordPress works and how code works. Not really a practical hands on understanding of it. So you don&#8217;t need to know what all the functions are and how to, how to write them from scratch. But you need to know when to use different things. You need to understand how the theme hierarchy works. You need to understand how WordPress calls different pieces. Again, what the names of some of those functions are so that you can apply them.</p>\n\n\n\n<p>[00:11:00] <strong>Nathan Wrigley:</strong> So, from everything that you&#8217;ve said, it feels a little bit like a bridge between, let&#8217;s just use the word novice, a novice user, and somebody who essentially is a complete expert. They understand everything. They can just open up, sort of IDE, a text editor if you like, and happily type away and build up all of the bits and pieces that they need.</p>\n\n\n\n<p>This is somewhere in between. You need to be, not an expert, but not a complete novice. There&#8217;s going to be some handholding and the UI will assist you along that path. But there&#8217;s definitely going to be some requirement to understand bits and pieces of how WordPress works conceptually.</p>\n\n\n\n<p>[00:11:34] <strong>Adam Lowe:</strong> That&#8217;s exactly what it is. And if you look at some of the more advanced page builders on the market, I&#8217;d say about half that crowd, the more advanced half of that crowd, would be perfect for using Pinegrow. And the less advanced half might get confused by it. And then you have the developer side, the people that can code who just don&#8217;t want to, and don&#8217;t want to do all that repetitive stuff. And that is definitely a great market for Pinegrow.</p>\n\n\n\n<p>[00:11:56] <strong>Nathan Wrigley:</strong> In terms of the level of understanding that would be a sensible default. Where are we pitching that really? Do you have to understand pretty much all of HTML and CSS? Do you have to have any understanding of JavaScript and React and so on? What are the core principles that you&#8217;d have to know off the bat, just so that you could begin using it?</p>\n\n\n\n<p>Because, I get the impression, having looked at your YouTube videos, that if I put a complete inexperienced user in front of this, there would just be, well, 10 minutes of mayhem and then throwing the computer out the window because it would be a very frustrating experience, because you wouldn&#8217;t know what anything meant. Where would you pitch this in terms of your CSS knowledge, HTML knowledge, and so on?</p>\n\n\n\n<p>[00:12:38] <strong>Adam Lowe:</strong> You definitely want to know HTML, and you want to understand, again, the concepts of CSS and maybe what the different things are called in there. Because Pinegrow has the visual controls for everything. You don&#8217;t need to remember what all the different classes are and what all the different properties are and everything like that.</p>\n\n\n\n<p>You can come in and click and start creating your CSS rules visually. So that&#8217;s great. But you do need to understand how CSS works, again, at a conceptual level. And the same thing with HTML. You don&#8217;t need to know all the different bits and pieces. You don&#8217;t have to memorize 300 and some odd elements. You need to have an understanding of what to use and when.</p>\n\n\n\n<p>[00:13:12] <strong>Nathan Wrigley:</strong> Does the plugin, because I think really that&#8217;s what we&#8217;re focusing on here. Does plugin bring along any guidance or tutorials to help you bridge that gap? So, explanations of how the UI works, but also more broadly, explanations of how WordPress works and explanations of things like CSS so that you can be swept along, just following Pinegrow&#8217;s documentation.</p>\n\n\n\n<p>[00:13:38] <strong>Adam Lowe:</strong> First of all, Pinegrow&#8217;s got an incredible amount of documentation on their website and they&#8217;ve got tutorials for just about everything. So if you&#8217;re interested in it, I would start there. The plugin does have a new tutorial section built in and they have one tutorial built that takes you kind of start to finish on how to create a block. And it walks you through how to use the interface, how to create CSS rules, how to put elements on the page. Basically how to do everything you need to do.</p>\n\n\n\n<p>So them, including that has been, a great way to get your feet wet and get a basic understanding. But then, you go to the website and they&#8217;ve got tutorials on how CSS works. They&#8217;ve got tutorials on how WordPress works. They&#8217;ve got tutorials on how to create a WooCommerce site from scratch. How to create themes from scratch, all of that stuff. And it&#8217;s really just a matter of going in, and the more you use it, and the more you do the tutorials yourself, the better you&#8217;re going to understand it.</p>\n\n\n\n<p>[00:14:28] <strong>Nathan Wrigley:</strong> A typical page builder&#8217;s UI would contain a panel at some point on the page, which would have icons, and those icons would be indicative of what the thing that you are about to drop on the page, the element, the module, whatever it is. You&#8217;d drop that onto the page and then something would immediately appear and you would then go about tweaking. You&#8217;d maybe change some numbers if it was padding or margin or font size or what have you. You could type text and change different things like background layouts and all of that. Is that broadly what Pinegrow looks like? Could you just sort of give us some indication of what the UI looks like and what we can expect? I know that&#8217;s very difficult in audio, but it&#8217;s probably important to understand what you&#8217;re getting into.</p>\n\n\n\n<p>[00:15:08] <strong>Adam Lowe:</strong> It really is, and you should see the hand gestures that I&#8217;m doing right now. They make absolutely no sense to anybody. So no, you&#8217;re definitely not dragging elements onto the page like you would with something like Elementor. You&#8217;re dragging raw HTML elements, which, if you don&#8217;t have any styling on them, they look like nothing, or they just look like plain text. It&#8217;s not until you start adding CSS to it that it does anything.</p>\n\n\n\n<p>So no, you don&#8217;t have those icons on there. You don&#8217;t have that kind of friendly thing. Again, I would equate it more to what you see with the advanced page builders in the WordPress space where you&#8217;re adding a section, you&#8217;re adding a column, you know, you&#8217;re adding in a header, you&#8217;re adding a text element. You do not get those predefined components. So you&#8217;re not going to get a menu builder. You&#8217;re not going to get a carousel element that you can just drag on there. You&#8217;re not going to get an accordion element that you can just drag onto there.</p>\n\n\n\n<p>Pinegrow does expect that you are able to either build that yourself or find libraries that are out there that you can just grab the code from and plop that into your page. They do include some starter libraries, and blocks, and components if you&#8217;re using something like Bootstrap or Tailwind. But if you&#8217;re just doing an HTML and CSS project, then no, you&#8217;re not going to get that.</p>\n\n\n\n<p>[00:16:18] <strong>Nathan Wrigley:</strong> Does Pinegrow have a community of people that have been doing things for a while in the background there? So in other words, if I was to get into this, is there a forum of some kind where I could go and see other people&#8217;s work that&#8217;s already been created? Or am I very much looking at tutorials and then I&#8217;m on my own, I&#8217;ve gotta work it out for myself?</p>\n\n\n\n<p>[00:16:37] <strong>Adam Lowe:</strong> So the Pinegrow website does have a very good forum. They&#8217;re not very active on Facebook. They&#8217;ve got their own reason, basically they don&#8217;t like Facebook and, and I&#8217;m okay with that. They&#8217;re not very active on Facebook, but if you go to pinegrow.com, they do have forums on there. It&#8217;s actually forum.pinegrow.com and that&#8217;s a great place to talk to other Pinegrow users, to get directly in touch with the company themselves. And they do have a section on there where people can showcase their work.</p>\n\n\n\n<p>The other place you can go, they&#8217;ve got a product called Pinegrow Online, which probably isn&#8217;t going anywhere, but it&#8217;s actually a very, very early version of this WordPress plugin. And if you go to pinegrowonline.com, I believe it is, or if you just Google Pinegrow online, you&#8217;ll see this. And right there on the page they&#8217;ve got, I don&#8217;t know, maybe 20 projects that people had submitted that you can come in, you can look at, and you can even open up the builder right there from the website and see how they&#8217;re created.</p>\n\n\n\n<p>[00:17:31] <strong>Nathan Wrigley:</strong> That&#8217;s really nice to know. Yeah, thank you for that. With a page builder, the intention is very much to build a website. You install it. You add pages. Possibly some templates for various different things, categories and so on and so forth. And at the end of it, the website is built that really is the point.</p>\n\n\n\n<p>Now, it feels to me that whilst that is also the point of Pinegrow, the intention is very much to create other things. So for example, to create blocks which you may wish to export and use elsewhere. Themes, which you may wish to use and export elsewhere? Have I got that? Have I understood that right? Is this not just a tool for building websites? This is also a tool for building components, themes, blocks, and so on. Plugins for other websites, other projects. So you could use it as a, as an example, you could have a standalone Pinegrow website, where you do all the building and then you could simply export the bits and pieces that you&#8217;ve built to use on your other client projects. That might be a possible use of it?</p>\n\n\n\n<p>[00:18:27] <strong>Adam Lowe:</strong> Probably not. You know, it sounds like what you&#8217;re describing might be getting again into page builder territory. So when you say building a website, there&#8217;s really two different ways that I see that. One is building a static HTML site, and that&#8217;s something where you would use a Pinegrow desktop app that just spits out generic HTML and CSS that you upload to any place.</p>\n\n\n\n<p>And then the other would be, you know, to use something inside a WordPress, it needs to be in either a theme or a block. So that&#8217;s how you enter your content. That&#8217;s how you make your pages look like something and do certain things. So Pinegrow doesn&#8217;t let you design pages. It lets you design those themes and those blocks that you can then activate on your site and start putting content into. Does that make sense?</p>\n\n\n\n<p>[00:19:09] <strong>Nathan Wrigley:</strong> Yes. I guess what I was trying to say was, if you created an array of blocks, which let&#8217;s say for example, you&#8217;re in the real estate niche or something like that, and you have a block that you&#8217;ve created in Pinegrow, that really satisfies almost everything that a real estate agent might wish to do. House pictures and pricing and so on and so forth. And it would spit out a nice display on the front end of the website. That was what I was imagining. You could then create that block, take it, export it, put it on all your other client websites and future client websites, and deploy it in that way.</p>\n\n\n\n<p>[00:19:41] <strong>Adam Lowe:</strong> Yes, absolutely. And here&#8217;s where we start getting into the gray area of whether the WordPress plugin version or the desktop plugin version makes more sense. So you can do that, and you can create those block libraries and export your themes and your blocks to use anywhere you want. On the WordPress plugin version, you&#8217;re kind of limited to everything being contained on that one site to build it.</p>\n\n\n\n<p>And, if you want to export the block and use it somewhere else, that&#8217;s great, you can do that. But then to modify that block, you&#8217;ve gotta go back to the original project that lives on your source website, let&#8217;s just call it that. So that gets a little bit cumbersome. And this is where the desktop version really comes into play because it lets you create reusable libraries.</p>\n\n\n\n<p>So you can create those libraries of components, of code, of themes. You can create those master themes that you can drop into any project. So it really speeds up the workflow. So for example, I&#8217;ve got a component library that I&#8217;ve created over time for basically everything that I need. And when I fire up Pinegrow Desktop, I just come in and with a few clicks I can drop a carousel or I can drop a menu on to someplace.</p>\n\n\n\n<p>I don&#8217;t have to recreate it from scratch. I don&#8217;t have to go back to an old project and copy paste code, like I would otherwise. That&#8217;s really the benefit there, and that&#8217;s part of the reason why you end up paying a little bit more for the desktop version than you will for the WordPress version.</p>\n\n\n\n<p>[00:21:03] <strong>Nathan Wrigley:</strong> I understand. So the desktop version may be more suitable for building components which you use all over the place, because that&#8217;s the place where they&#8217;re originating from. And perhaps if you&#8217;re building client websites, the WordPress plugin, and we&#8217;ll find out about the pricing shortly, is going to be suitable to install on each individual website until it&#8217;s no longer needed. Right, got it.</p>\n\n\n\n<p>[00:21:20] <strong>Adam Lowe:</strong> It is. And, while you can do what you were saying on the WordPress plugin, it&#8217;s just not going to be as efficient as you would be with the desktop.</p>\n\n\n\n<p>[00:21:27] <strong>Nathan Wrigley:</strong> Right. Thank you. In terms of the way that the tool has been built, I don&#8217;t know if this question will be of great interest for everybody, but it may be to some. Presumably given what it&#8217;s trying to do and the way that it&#8217;s trying to do it, it had to work fairly tightly in the, I&#8217;m doing air quotes, in the WordPress way.</p>\n\n\n\n<p>It had to stick fairly closely to the WordPress way of doing things. Is that the case? Has it been built with WordPress standards and typical ways that people would hopefully build themes and blocks, in order to achieve what it is hopefully outputting?</p>\n\n\n\n<p>[00:22:03] <strong>Adam Lowe:</strong> It has been. And there are a few places where it, kind of strays from that. And, just to give you an example. WordPress says that you should not include functionality in a theme. That a theme should be your design only, that if you&#8217;re going to put something in the WordPress repository that you really need to split functionality from design.</p>\n\n\n\n<p>However, in practice when somebody&#8217;s building a website for a client or for themselves, they&#8217;re going to combine the two because you cannot really separate the two practically. So, while you can use Pinegrow and you can create a plugin that has all your blocks in it, with all the smarts, and then a separate theme that has just your templates in there.</p>\n\n\n\n<p>Practically speaking, that doesn&#8217;t make sense. And all the tutorials and all the guidance says, just put it into the theme, that&#8217;s going to be the easiest way to go. So, yes you can do it 100% the WordPress way. You can completely work it if you want, or you can use a hybrid approach.</p>\n\n\n\n<p>[00:22:57] <strong>Nathan Wrigley:</strong> I have a, I have a curious question about this idea of the business going out of existence. And so, for any WordPress company, let&#8217;s say a page builder. If that company folded, then you are to some extent left in the lurch. You know, you&#8217;re hoping that somebody maintains that project and carries it on and what have you.</p>\n\n\n\n<p>With this, it presents a slightly different problem in that everything will still continue to work, but the Pinegrow editor, you would no longer be able to use, well, I guess you could use it, if WordPress didn&#8217;t change in such a way that it made it impossible to use. But you could in theory carry on editing all of the bits and pieces that you&#8217;ve got with your IDE, in a text editor if you like. That would still be possible?</p>\n\n\n\n<p>[00:23:39] <strong>Adam Lowe:</strong> It is, and this is actually one of the things that drove me to Pinegrow more than anything else. If you&#8217;ve been around WordPress for any period of time, you&#8217;ve seen the problem with abandoned plugins, You&#8217;ve seen the problem with things that just stop working. As a matter of fact, I&#8217;m working on a project right now where I have, out of 52 plugins, I think 10 of them are abandoned. Two of them have been removed from the repo, and more than half of them are older than three years old, and can&#8217;t be upgraded for one reason or another. So that&#8217;s the sort of thing that I fight against on a daily basis is, all these dependencies, all this crazy stuff that&#8217;s happening.</p>\n\n\n\n<p>And then you&#8217;ve got your page builders where, okay, the page builder&#8217;s one dependency, but then on top of the page builder, you have all these other add-ons. You&#8217;ve got frameworks, you&#8217;ve got, extra components that are being put in there. And each of those things adds just one more dependency on top of it.</p>\n\n\n\n<p>One more dependency. And if any one of those companies goes out of business, stop supporting it, has a security problem that they can&#8217;t fix or won&#8217;t fix, then you&#8217;re kind of left having to either refactor the whole website, or you&#8217;ve got a insecure website that you&#8217;re dealing with. So this is one of the big challenges that I&#8217;ve been facing over and over again.</p>\n\n\n\n<p>And when I saw Pinegrow and saw what they were doing with WordPress, this was one of the things that really drove me to it, was that it is creating native themes and native blocks that you would create them the same way if you were doing it by hand, using VS code or any other IDE.</p>\n\n\n\n<p>And if Pinegrow were to go out of business, that&#8217;s not a problem at all. You&#8217;ve still got those things that don&#8217;t rely on the builder at all to use or to modify. You can just go right in, change your PHP, change your blocks and, keep using it as if nothing ever happened.</p>\n\n\n\n<p>[00:25:19] <strong>Nathan Wrigley:</strong> Can you think of any caveats where that&#8217;s not necessarily the case? You know, this promise has been offered several times before, and then as you&#8217;ve described, it doesn&#8217;t actually bear out when the company does go out of existence. To your knowledge, I&#8217;m guessing, because you could simply remove Pinegrow and the whole thing still just works. There are no caveats to that as far as you know, there&#8217;s no dependency of any kind whatsoever. It&#8217;s just the ability to use their UI to modify things that you would lose out on if they disappeared.</p>\n\n\n\n<p>[00:25:51] <strong>Adam Lowe:</strong> I would say yes and no to that. So, yes, it really is just the dependency on their builder for making changes to it. However, there are things like Tailwind and Bootstrap and Green Sock that are extra libraries that could be dependencies if you chose to use them. So Pinegrow does let you use those frameworks, Bootstrap and Tailwind, in both the desktop version and the WordPress version.</p>\n\n\n\n<p>So if something were to happen with either of those and they no longer were supported or maintained, then yes, you would have that dependency problem. Same thing for Green Sock. And Green Sock is an animation library. It&#8217;s really a JavaScript library that lets you do all sorts of things from creating menu animations to things flying all around your screen and all sorts of silliness. It&#8217;s a very powerful piece. But again, if something happened with any of those other component libraries that you chose to use in your project, then you would run into that problem.</p>\n\n\n\n<p>[00:26:44] <strong>Nathan Wrigley:</strong> Just to be clear, that&#8217;s an option in Pinegrow or that&#8217;s a necessity. In other words, you don&#8217;t need to use Tailwind, you don&#8217;t need to use Bootstrap. And obviously if your site is animation free, you&#8217;re not going to be using any of that Green Sock either. All of that&#8217;s the case if you choose not to use those things, and just write native JavaScript, native CSS, we&#8217;re all good.</p>\n\n\n\n<p>[00:27:03] <strong>Adam Lowe:</strong> Yep, 100% optional.</p>\n\n\n\n<p>[00:27:05] <strong>Nathan Wrigley:</strong> Yeah. That&#8217;s great. The way that blocks have been growing over time, it feels like in the last year in particular, the complexity, the number of companies getting into this space has changed quite a lot. WordPress itself offering us heaps more functionality in the things that we can do. So for example, we&#8217;ve now got, full site editing, which enables us to do things on the back end. The capabilities and the different options available to us inside of blocks, too numerous to count.</p>\n\n\n\n<p>But each and every week it seems that there&#8217;s a new bit of news about something that&#8217;s going to be coming down in the next version of WordPress, which will alter the visual experience of how we interact with blocks. Have you noticed that Pinegrow, does it update basically? Does it watch the WordPress project closely to ensure that there&#8217;s compatibility, stability with the most recent versions of WordPress?</p>\n\n\n\n<p>[00:27:57] <strong>Adam Lowe:</strong> It does, and you raised an interesting point there where you talked about sorry, the block themes. Because right now Pinegrow does not have anything built in that works directly with block themes or to directly create a block theme. It still does, what are called classic themes. They are working on, some things for the block themes, but like you mentioned right now, it&#8217;s moving so fast in the WordPress space and it&#8217;s changing so often, that even if you were to install a block theme, you&#8217;d see the word beta inside of WordPress.</p>\n\n\n\n<p>So, really Pinegrow is waiting for WordPress to stabilize a little bit before they go in and really start supporting or letting you create a block theme, using some of their helpers. That&#8217;s not to say that you can&#8217;t create a block theme using Pinegrow, because I have, and I&#8217;ve got several sites that are running block themes that I created with Pinegrow. But there&#8217;s a few other manual steps that you need to take.</p>\n\n\n\n<p>In terms of blocks themselves, I&#8217;ve got a love hate relationship with blocks. I think there are pain in the butt, I think is just the most clunky way to build a website. But frankly, it, again, it&#8217;s the WordPress way. So either get on the bus or get off. There&#8217;s so many other benefits to WordPress that I&#8217;m on that bus. So I deal with it, and the blocks are changing all the time and they&#8217;re adding new things.</p>\n\n\n\n<p>So being able to do more with typography in there. Using fluid typography. And even now we have the ability to do a little bit of block locking and, content locking in there. Those are all really good things, and those were problems that I initially had turned to Pinegrow to solve. So it looks like WordPress is starting to do a little bit of that on their own. They&#8217;re still not quite there yet. So, there&#8217;s definitely room for both.</p>\n\n\n\n<p>[00:29:30] <strong>Nathan Wrigley:</strong> Tell me a little bit more about that. I know that the block locking capabilities in WordPress have been improved. Well, in the last few weeks we&#8217;ve had the ability to, with a click of a button, you can lock all the, the children of a particular parent block and so on and so forth. But the, the permissions model around that is not particularly, effective. There&#8217;s a lot that needs to be engineered to make that block locking solution work effectively. Are you saying that with. Pinegrow, you&#8217;re able to lock much more down?</p>\n\n\n\n<p>You can say, okay, you have a certain role or your username is this. You can only do this, this, this, but you&#8217;ve got a different role over there and you&#8217;ve got a different username, whatever it may be. You can do a whole bunch of other things. Does it have capabilities, permissions, which exceed what you can do with blocks at the moment, with blocks designed with Pinegrow?</p>\n\n\n\n<p>[00:30:16] <strong>Adam Lowe:</strong> Yes and no. So to get that granular as to, you know, role-based permissions to, for example, change a picture or, you know, user specific permissions to edit a text field. That&#8217;s the sort of thing that you may need to come in and write a little bit of custom code to do. Or write some conditionals in there. I actually haven&#8217;t tried to do that at that level, so it might be a whole lot easier than what I&#8217;m thinking. And I&#8217;d love if the Pinegrow people could just jump in and tell me, rather than me having to research it myself. Because I think there is some benefit to that.</p>\n\n\n\n<p>How I&#8217;ve used it is, just being able to define what fields are editable, and using standard role-based permissions for that sort of thing. So a lot of times, when I&#8217;m working with a client, they&#8217;ve got a marketing team that comes in and helps to find how things are going to look. But then the people that are actually editing the content, shouldn&#8217;t be able to remove a block, or they shouldn&#8217;t be able to do certain things.</p>\n\n\n\n<p>They need to adhere to certain style standards. So that&#8217;s the sort of thing where, within Pinegrow, I can define here&#8217;s the fields that you&#8217;re able to modify. Here&#8217;s the properties you&#8217;re able to modify, on a field by field basis. Whereas with WordPress, it&#8217;s kind of all or nothing.</p>\n\n\n\n<p>[00:31:22] <strong>Nathan Wrigley:</strong> That&#8217;s interesting. Thank you. In the preparation for this, I watched a few of the videos that you&#8217;ve made, more recently and, it&#8217;s certainly around Pinegrow but also around other different pieces. And one of the videos that I caught sight of was one where you were looking at the accessibility options in different page builders and, and how menus, for example, were accessible or were not accessible out of the gate.</p>\n\n\n\n<p>Is there anything to be said about the way that Pinegrow handles accessibility? I&#8217;m guessing the answer is, because you can do anything, you can make it as accessible as you like or not. But does it handle that kind of thing natively or is it simply the fact that it opens up the options? You can manually insert them to make anything as accessible as possible.</p>\n\n\n\n<p>[00:32:07] <strong>Adam Lowe:</strong> That&#8217;s exactly it. It opens up the options for you to make it as accessible as you want to or not. Again, it&#8217;s not going to make decisions for you. And, if you go to the forums, you&#8217;ll actually see a lot of conversations around people requesting that Pinegrow do certain things by default.</p>\n\n\n\n<p>But then they come back and, Pinegrow comes back and says, Well, you know, what about this case? What about this case? What about this case? And, the decision with Pinegrow is to leave things as open as possible for you to make those decisions rather than them forcing certain things on you.</p>\n\n\n\n<p>And it even comes down to silly stuff like, do you have a trailing backslash at the end of a URL? Do you put a no opener at the end of a link? That sort of thing. Where they really try to make it as open as possible. So, yes, for accessibility. Again, this comes back to one of the reasons that, I wouldn&#8217;t say in love with, but one of the reasons why I&#8217;ve standardized on Pinegrow is because I can build accessibility into my projects and, and accessibility&#8217;s become more of a focus of my agency over the last 18 months to two years.</p>\n\n\n\n<p>So the fact that I can come in and make a completely accessible menu is amazing. That I can create all these components in very accessible ways. Whereas before, I might have to turn to three or four different block plugins because, maybe the carousel in plugin number one is accessible, but the rest of the things aren&#8217;t.</p>\n\n\n\n<p>And the menu in another one is accessible, but the rest of the things aren&#8217;t. So, rather than cobble together all these bits and pieces that may or may not be the way that I want to accessibility wise, I just build. The templates are out there. The information&#8217;s out there. You just need to apply it.</p>\n\n\n\n<p>[00:33:38] <strong>Nathan Wrigley:</strong> Yeah, thank you. That&#8217;s really helpful. tool itself, I think we&#8217;ve established, it is for intermediate or above users I&#8217;m guessing might be a reasonable way of describing it. Now, by pure good coincidence, we&#8217;ve recorded this episode right before, like, literally right before the release from beta into a stable version of the product.</p>\n\n\n\n<p>Can you give us some indication, we are recording this right at the beginning of November. If memory serves, you are going to be, well, I say you, Pinegrow are going to be actually launching the product on the 17th of November, and given the date that this podcast is going to go out, that&#8217;s probably a day or two around that date. Have I got that right? The stable version&#8217;s coming out on the 17th of November, 2022.</p>\n\n\n\n<p>[00:34:25] <strong>Adam Lowe:</strong> Fingers crossed, that is going to be the date. So I don&#8217;t see any reason why they won&#8217;t hit that date. And that&#8217;s the date that Pinegrow has released me to talk about. So, uh, yes. November 17th is going to be the date that they launch it. They&#8217;re going to launch a free version as well as a paid version.</p>\n\n\n\n<p>[00:34:40] <strong>Nathan Wrigley:</strong> I think it&#8217;s probably apropos to say at this point that this isn&#8217;t a product which coming out of beta, is new is it? The change log for the desktop version extends back, well, years and years and years. And like you said, most of the functionality for this is ported from the desktop version.</p>\n\n\n\n<p>So, stepping in early, you are fairly confident that the product&#8217;s going to be, well, not just labeled stable, but will be stable. You&#8217;ve had a long, long play with the beta I guess?</p>\n\n\n\n<p>[00:35:10] <strong>Adam Lowe:</strong> I&#8217;ve had a long play and I think we&#8217;ve had over 30 beta releases come out since I&#8217;ve been involved. You just said it right there, is that this is a product with a long history. It goes back to 2014. And the codebase is exactly the same across all of them. It&#8217;s built on node.js. So that core is the same on Mac, Windows, Linux, desktop and WordPress. There&#8217;s no difference at all in what the builder does, how it works, the code that it spits out. So everything that you&#8217;re doing, from a builder standpoint is tried and tested, and it&#8217;s been out there in the field for quite a long time.</p>\n\n\n\n<p>The new pieces are really the ways that it interacts with WordPress from a front end standpoint. So, things like making sure that only people with the correct permissions can open a project. That two people can&#8217;t open the same project and step on each other, so that we&#8217;re not introducing security problems inside of WordPress by running the builder. That&#8217;s the kind of thing that is new. Not the builder itself, and the code that it spits out for your websites.</p>\n\n\n\n<p>[00:36:10] <strong>Nathan Wrigley:</strong> I&#8217;m going to link in the show notes to the desktop version, which has been out for a long time, but I&#8217;ll also, assuming that the links are live, I will endeavor to put in the plugin version as well. Just before we round it off, I think people will want to know what the opportunities are to get in here.</p>\n\n\n\n<p>My understanding is there&#8217;s going to be two pricing tiers for the paid version, but there&#8217;ll also be a free version. Now, just to be clear, the free version isn&#8217;t going to be available on the repo, but the free version, I&#8217;m guessing, will have a limited array of functionality. Maybe you could speak about that, but then could you also just highlight the pricing for the two models as you understand it?</p>\n\n\n\n<p>[00:36:48] <strong>Adam Lowe:</strong> Sure, and I&#8217;m going to talk about the free version for a minute because I think Pinegrow&#8217;s absolutely insane for what they&#8217;re doing. When I asked what I could talk about for the free version and they came back and told me, I was blown away. So you can do pretty much everything with the free version, with just a few minor exceptions.</p>\n\n\n\n<p>So, the big one is that you can&#8217;t export themes with the free version. You can only export blocks. So that&#8217;s going to be one of your biggest limitations. The other big limitation is that you cannot do what are called inner blocks. So, inside of WordPress you can create blocks within blocks within blocks, Yeah. Blockception even. You can&#8217;t do that with the free version of Pinegrow. You can create your one main block and that&#8217;s it. So you can create blocks with it, but you cannot do themes. You can&#8217;t do inner blocks. And the other part is that you cannot import and export projects, to and from the desktop.</p>\n\n\n\n<p>So that&#8217;s your other big limitation. The only one other thing that I&#8217;m going to throw out there is that the Green Sock, what they call Pinegrow interactions, is not available in the free version because of licensing restriction with Green Sock themselves. So you do have to go to a paid version to be able to use that.</p>\n\n\n\n<p>Otherwise, you can use the entire builder as much as you want. You really get a feel for how it works, how to do different things. And, quite frankly, you can build a whole website with this, with no problem. It&#8217;s pretty amazing what they&#8217;re giving away for free. And I&#8217;m happy to talk about pricing too, if you guys want to get into that.</p>\n\n\n\n<p>[00:38:09] <strong>Nathan Wrigley:</strong> Two models. There&#8217;s a one site model and then there&#8217;s the unlimited sites, an interesting pricing structure. One site or unlimited. Tell us the pricing around those.</p>\n\n\n\n<p>[00:38:18] <strong>Adam Lowe:</strong> Yeah. So it&#8217;s going to be $49 per year for a single site, or $199 a year for unlimited sites. And the reason why it&#8217;s so interesting to me is because once you build your site, there&#8217;s no dependency on Pinegrow anymore. So theoretically you could buy a single site license and export themes and blocks to use on as many sites as you want.</p>\n\n\n\n<p>You&#8217;re just not going to want to do that because, going back and modifying and editing those things is going to become a real pain in the butt. $199 is a fantastic price point for what you&#8217;re getting here, especially for a developer who, presumably is working on client sites and getting their money back for this thing.</p>\n\n\n\n<p>In addition, they&#8217;re also going to have Black Friday deal. So it&#8217;s going to be 35% off for Black Friday, and I think that sales going to start right around the same time that they launch this plugin. That&#8217;s a bonus. And then there&#8217;s also going to be a very steep discount for people who already have the Pinegrow desktop version.</p>\n\n\n\n<p>So if you want to own both the desktop and the WordPress version, I believe you get 50% off of the Pinegrow WordPress plugin. There&#8217;s a lot of incentive here and Pinegrow&#8217;s put a lot of time and effort into the WordPress space. They definitely see this as a strategic move to get into WordPress, and they&#8217;re doing everything they can to make it easy to use Pinegrow in there.</p>\n\n\n\n<p>[00:39:28] <strong>Nathan Wrigley:</strong> Just before we round off, it strikes me that we&#8217;ve missed a particular piece of the puzzle here, and it&#8217;s not something that should be ignored I think. Having watched your videos, I confess I haven&#8217;t actually opened up the tool myself, but I&#8217;ve watched quite a large amount of what you&#8217;ve done.</p>\n\n\n\n<p>It really feels like this could be a good place to increase your knowledge of WordPress and how WordPress works. If you are prepared to go through the learning curve, you&#8217;re going to be seeing what WordPress is doing, or, or at least the way that it is intending to be doing things. The HTML that it requires to make things work, and the PHP, and the functions and so on.</p>\n\n\n\n<p>So really there&#8217;s that, that we missed just the fact that it could be a good tool, should you wish to learn a bit more about WordPress. It may be that if you feel that you are a little bit below the level that is required to get up and running straight away, it might be a good way to bridge that gap as well.</p>\n\n\n\n<p>[00:40:18] <strong>Adam Lowe:</strong> It really is, and I can tell you I&#8217;ve learned so much about WordPress and even CSS just from using this tool. Because it has, it&#8217;s given me that bridge to go from the page builder world to, oh my gosh, I&#8217;m sitting here in front of a blank text editor. So it gives me those tools to be able to learn it and, so then I don&#8217;t get stuck in the process.</p>\n\n\n\n<p>As a matter of fact, it&#8217;s quite interesting, Pinegrow had a project that they used the early version of this WordPress plugin for, to teach kids how to do HTML. So that&#8217;s where a lot of this came into play. That&#8217;s actually part of the reason why they even built this WordPress plugin was for their, I forget what they call it, but it&#8217;s like, HTML academy for kids or something like that. So yeah, it is a great learning platform if you&#8217;re so inclined.</p>\n\n\n\n<p>[00:41:00] <strong>Nathan Wrigley:</strong> Adam, just before we round off, if people are interested in this, they can obviously go to the Pinegrow website. You, as you said, are a very interested user. You&#8217;re not affiliated with Pinegrow but nevertheless people might wish to ask you some questions and, plunder your growing knowledge about how it works and whether or not it would be a good fit for position and what they&#8217;re trying to achieve with their clients or their own website. Where could we find you best?</p>\n\n\n\n<p>[00:41:25] <strong>Adam Lowe:</strong> Two different places. My website is peakperformancedigital.com, and then I&#8217;ve been doing more and more on YouTube. So if you just search for Peak Performance Digital on YouTube, you&#8217;ll find my channel there. All the videos that I&#8217;ve created, and I try to be very responsive to anybody that leaves me a comment or sends me an email.</p>\n\n\n\n<p>[00:41:40] <strong>Nathan Wrigley:</strong> Adam Lowe, I appreciate you joining us on the podcast today. Thanks very much indeed.</p>\n\n\n\n<p>[00:41:45] <strong>Adam Lowe:</strong> Thank you, Nathan.</p>\n</div>\n\n\n\n<p>On the podcast today we have <a href=\"https://twitter.com/adamslowe\">Adam Lowe</a>.</p>\n\n\n\n<p>Adam Lowe runs <a href=\"https://peakperformancedigital.com/\">Peak Performance Digital</a>, a small web consulting agency in Washington, DC, that specialises in providing website strategy along with custom WordPress solutions.</p>\n\n\n\n<p>He’s on the podcast today to talk about a new plugin from <a href=\"https://pinegrow.com/\">Pinegrow</a>. Adam does not represent the company, but is an avid user of their products, and experienced in how they work.</p>\n\n\n\n<p>The ‘Pinegrow Web Editor’ is a desktop tool that lets you build websites with a GUI. The closest comparison would be a page builder, but this is not entirely accurate. Unlike most page builders, which require very little technical expertise, Pinegrow does require an understanding of technologies such as CSS, SASS, CSS Grid, Bootstrap and Tailwind CSS to make use of the platform. The intention of the tool is to make it possible to create complex sites, but with a close eye on the HTML and CSS that is being output.</p>\n\n\n\n<p>Given the popularity of WordPress, the Pinegrow developers have created a WordPress plugin, which is just about to be released. It’s been in closed beta, and Adam has been using it as his go-to solution for several months now.</p>\n\n\n\n<p>We talk about what the platform can do, and how it works. It’s not going to be a plugin for beginners, and there’s going to be a learning curve for those who do take the plunge. It’s intended as a bit of a bridge between novices and WordPress experts.</p>\n\n\n\n<p>We also get into a discussion about the fact that Pinegrow is intended to be a ‘no dependency’ solution. Once you’ve finished creating your theme, block or whatever else you might want to create, you can export that in a way that no longer needs Pinegrow at all.</p>\n\n\n\n<p>If you’re curious about new ways to create websites in WordPress, have a listen to the podcast and see if Pinegrow is a good fit.</p>\n\n\n\n<h2>Useful links.</h2>\n\n\n\n<p><a href=\"https://pinegrow.com/\">Pinegow website</a></p>\n\n\n\n<p><a href=\"https://forum.pinegrow.com/\">Pinegrow forum</a></p>\n\n\n\n<p><a href=\"https://pinegrow.online/\">Pinegrow Online</a></p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Wed, 16 Nov 2022 15:00:00 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:14:\"Nathan Wrigley\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:41;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:67:\"WPTavern: Meetup.com Raises Concerns with New Accessibility Overlay\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:30:\"https://wptavern.com/?p=139531\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:78:\"https://wptavern.com/meetup-com-raises-concerns-with-new-accessibility-overlay\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:3812:\"<p>Meetup.com raised some concerns with the WordPress community (and the broader community of accessibility professionals) this week after it added an accessibility overlay to its website. The overlay, powered by <a href=\"https://www.equalweb.com/html5/?_id=8591&did=1116&_gid=202027&trace=equalweb_menu_en_\">EqualWeb</a>, displays a list of settings that can be toggled, ostensibly to address various accessibility needs. </p>\n\n\n\n<div class=\"wp-block-embed__wrapper\">\n<blockquote class=\"twitter-tweet\"><p lang=\"en\" dir=\"ltr\">I\'m super disappointed <a href=\"https://twitter.com/Meetup?ref_src=twsrc%5Etfw\">@Meetup</a> added an <a href=\"https://twitter.com/hashtag/a11y?src=hash&ref_src=twsrc%5Etfw\">#a11y</a> overlay. <img src=\"https://s.w.org/images/core/emoji/14.0.0/72x72/1f622.png\" alt=\"😢\" class=\"wp-smiley\" /><br /><br />Time to look into event calendars for <a href=\"https://twitter.com/hashtag/WPA11yMeetup?src=hash&ref_src=twsrc%5Etfw\">#WPA11yMeetup</a>. We still have to be on Meetup to get events in <a href=\"https://twitter.com/hashtag/WordPress?src=hash&ref_src=twsrc%5Etfw\">#WordPress</a> admin, but we don\'t have to market those pages. Has the community team ever explored Meetup alternatives? <a href=\"https://t.co/pVgYdI5Qs3\">https://t.co/pVgYdI5Qs3</a></p>&mdash; Amber Hinds (@heyamberhinds) <a href=\"https://twitter.com/heyamberhinds/status/1592273476362113030?ref_src=twsrc%5Etfw\">November 14, 2022</a></blockquote>\n</div>\n\n\n\n<p>Accessibility overlay products are often marketed as a quick fix solution that will make a website ADA compliant and immune from legal action, when accessibility had not been built in from the beginning.  </p>\n\n\n\n<p>In May 2021, <a href=\"https://wptavern.com/accessibility-advocates-sign-open-letter-urging-people-not-to-use-accesibe-and-other-overlay-products\">accessibility advocates signed an open letter</a> urging people not to use accessibility overlay products like AccesiBe, EqualWeb, and others. Signatories published a four-part statement that articulates the reasons why overlays are harmful:</p>\n\n\n\n<ol>\n<li><em>We will never advocate, recommend, or integrate an overlay which deceptively markets itself as providing automated compliance with laws or standards.</em></li>\n\n\n\n<li><em>We will always advocate for the remediation of accessibility issues at the source of the original error.</em></li>\n\n\n\n<li><em>We will refuse to stay silent when overlay vendors use deception to market their products.</em></li>\n\n\n\n<li><em>More specifically, we hereby advocate for the removal of accessiBe, AudioEye, UserWay, User1st, MK-Sense, MaxAccess, FACIL’iti, and all similar products and encourage the site owners who’ve implemented these products to use more robust, independent, and permanent strategies to making their sites more accessible.</em></li>\n</ol>\n\n\n\n<p>WordPress&#8217; Community Team uses Meetup.com to organize local and virtual meetups, as well as educational events. Accessibility practitioners consider the use of overlay products a flagrant malpractice and are calling on Meetup.com to abandon this solution in favor of addressing inaccessibility at the root of the problem.</p>\n\n\n\n<p>After receiving some complaints, Meetup appeared to take the overlay down but reinstated it the next day. At the time of publishing. the overlay is still on the website. WordPress community organizer Angela Jin <a href=\"https://twitter.com/AngelaSJin/status/1592052279217377280\">offered</a> to contact Meetup.com on behalf of concerned community members. In the meantime, accessibility evangelist Amber Hinds <a href=\"https://twitter.com/heyamberhinds/status/1592273476362113030\">suggested</a> the Community Team explore Meetup.com alternatives and said the WordPress Accessibility Meetup will be looking into using a different events calendar.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Wed, 16 Nov 2022 03:55:49 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Sarah Gooding\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:42;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:63:\"WPTavern: WordPress.com Adds Support for New Pocket Casts Block\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:30:\"https://wptavern.com/?p=139509\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:74:\"https://wptavern.com/wordpress-com-adds-support-for-new-pocket-casts-block\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:2242:\"<p>WordPress.com has expanded its library of blocks to include <a href=\"https://wordpress.com/blog/2022/11/08/embed-a-pocket-casts-player-in-seconds-with-our-new-block/\">a new Pocket Casts block</a> that makes it easy to embed any show or episode in the WordPress editor. The block is branded for Pocket Casts and will display a podcast player and a selection of episodes when the show URL is selected. Alternatively, users can embed a specific episode by using its episode URL.</p>\n\n\n\n<div class=\"wp-block-embed__wrapper\">\n\n</div>\n\n\n\n<p>Automattic <a href=\"https://wptavern.com/automattic-acquires-pocket-casts\">acquired Pocket Casts</a> in 2021 after the app began struggling financially. At the time, Automattic’s Head of Apps, Eli Budelli, said the company would explore building deep integrations with WordPress.com and Pocket Casts by developing ways to make it easier to distribute and listen to podcasts. This new Pocket Casts block delivers on that promise with a solid integration for WordPress.</p>\n\n\n\n<p>Last month, Pocket Casts <a href=\"https://blog.pocketcasts.com/2022/10/19/pocket-casts-mobile-apps-are-now-open-source/\">open sourced its mobile apps</a> under the Mozilla Public License, a GPL-compatible copyleft license that encourages contributors to share their modifications of the code under the same license. The code for <a href=\"https://github.com/Automattic/pocket-casts-ios\">Pocket Casts iOS</a> and <a href=\"https://github.com/Automattic/pocket-casts-android\">Pocket Casts Android</a> is available on GitHub.</p>\n\n\n\n<p>&#8220;We believe that podcasting can not and should not be controlled by Apple and Spotify, and instead support a diverse ecosystem of third-party clients,&#8221; the Pocket Casts team said when announcing its open source podcasting client. Users and contributors can now more easily report bugs, suggest new features, and submit pull requests.</p>\n\n\n\n<p>Self-hosted WordPress users also have access to the new Pocket Casts block if using the latest version of WordPress. The <a href=\"https://github.com/WordPress/gutenberg/pull/41006\">Pocket Casts embed block variation</a> was quietly added to Gutenberg 13.6, which was one of the releases that was rolled into WordPress core in 6.1.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Tue, 15 Nov 2022 22:39:38 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Sarah Gooding\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:43;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:46:\"Post Status: WordPress in Substack’s History\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:32:\"https://poststatus.com/?p=143953\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:54:\"https://poststatus.com/wordpress-in-substacks-history/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:2144:\"<p>I wish <a href=\"https://on.substack.com/p/five-years-of-substack-with-bill\">this was a WordPress story</a>. It should\'ve been and could still be — a simple publishing platform built around freemium newsletters — and writers. </p>\n\n\n\n<p>In a way, it <em>is</em> a WordPress story.</p>\n\n\n\n<p>Ben Thompson\'s <a href=\"https://stratechery.com/\">Stratechery</a> was a Substack inspiration and has always run on WordPress, I believe.</p>\n\n\n\n<p>There\'s also this:</p>\n\n\n\n<blockquote class=\"wp-block-quote\">\n<p>Our plan was to build a subscriptions management system that would plug into WordPress.</p>\n<cite><a href=\"https://substack.com/profile/3567-hamish-mckenzie\">Hamish McKenzie</a>, Substack Co-founder and Chief Writing Officer</cite></blockquote>\n\n\n\n<p>I recall reading years ago that an early Substack proof-of-concept or early version was built on WordPress. That seems to be true according to this post by co-founder Hamish McKenzie\'s on the occasion of Substack\'s fifth birthday. It\'s unclear how far they went with WordPress before making Substack a proprietary project:</p>\n\n\n\n<p>Substack was built around — and for writers — so they can get paid and do great work. </p>\n\n\n\n<p>Former Economist editor Bill Bishop launched the tremendously valuable Sinocisim as Substack blog #1:</p>\n\n\n\n<div class=\"wp-block-embed__wrapper\">\n<blockquote class=\"twitter-tweet\"><p lang=\"en\" dir=\"ltr\">Five years ago today, <a href=\"https://twitter.com/niubi?ref_src=twsrc%5Etfw\">@niubi</a> launched the first Substack publication.<br /><br />Our experience with Bill shaped what Substack has become.<br /><br />Happy five years, Bill!<a href=\"https://t.co/G2zciq2e8G\">https://t.co/G2zciq2e8G</a></p>&mdash; Hamish McKenzie (@hamishmckenzie) <a href=\"https://twitter.com/hamishmckenzie/status/1581663914613317633?ref_src=twsrc%5Etfw\">October 16, 2022</a></blockquote>\n</div>\n\n\n\n<p>That\'s something the WordPress ecosystem distinction <em>lacks</em> for and about itself — WordPress writers writing about WordPress professionally and for a living.</p>\n<p>This article was published at Post Status — the community for WordPress professionals.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Tue, 15 Nov 2022 22:12:03 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:10:\"Dan Knauss\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:44;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:55:\"WordPress.org blog: WordPress 6.1.1 Maintenance Release\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:35:\"https://wordpress.org/news/?p=13918\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:71:\"https://wordpress.org/news/2022/11/wordpress-6-1-1-maintenance-release/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:9812:\"<h2>WordPress 6.1.1 is now available</h2>\n\n\n\n<p>This minor release features <a href=\"https://core.trac.wordpress.org/query?milestone=6.1.1&group=component&col=id&col=summary&col=status&col=owner&col=type&col=priority&col=milestone&order=priority\">29 bug fixes in Core</a> and <a href=\"https://github.com/WordPress/gutenberg/compare/ca07aa8354a1131dbabcc36dfcaf70e0c0891f54...6566f5fe9ece6ad5ae550349d3b1f0944a011040\">21 bug fixes</a> for the block editor. WordPress 6.1.1 is a short-cycle maintenance release. You can review a summary of the key updates in this release by reading the <a href=\"https://make.wordpress.org/core/2022/11/11/wordpress-6-1-1-rc1-is-now-available/\">RC1 announcement</a>.</p>\n\n\n\n<p>The next major release will be <a href=\"https://make.wordpress.org/core/6-2/\">version 6.2</a> planned for 2023.</p>\n\n\n\n<p>If you have sites that support automatic background updates, the update process will begin automatically.</p>\n\n\n\n<p>You can <a href=\"https://wordpress.org/wordpress-6.1.1.zip\">download WordPress 6.1.1 from WordPress.org</a>, or visit your WordPress Dashboard, click “Updates”, and then click “Update Now”.</p>\n\n\n\n<p>For more information, check out the <a href=\"https://wordpress.org/support/wordpress-version/version-6-1-1/\">version 6.1.1 HelpHub documentation page</a>.</p>\n\n\n\n<h2>Thank you to these WordPress contributors</h2>\n\n\n\n<p>The WordPress 6.1.1 release was led by <a href=\"https://profiles.wordpress.org/desrosj/\">Jonathan Desrosiers</a>, <a href=\"https://profiles.wordpress.org/mamaduka/\">George Mamadashvili</a>, and <a href=\"https://profiles.wordpress.org/jeffpaul/\">Jeffrey Paul</a>.</p>\n\n\n\n<p>WordPress 6.1.1 would not have been possible without the contributions of more than 105 people. Their asynchronous coordination to deliver several enhancements and fixes into a stable release is a testament to the power and capability of the WordPress community.</p>\n\n\n\n<p><a href=\"https://profiles.wordpress.org/10upsimon/\">10upsimon</a>, <a href=\"https://profiles.wordpress.org/jorbin/\">Aaron Jorbin</a>, <a href=\"https://profiles.wordpress.org/aaronrobertshaw/\">Aaron Robertshaw</a>, <a href=\"https://profiles.wordpress.org/adamsilverstein/\">Adam Silverstein</a>, <a href=\"https://profiles.wordpress.org/wildworks/\">Aki Hamano</a>, <a href=\"https://profiles.wordpress.org/alexstine/\">alexstine</a>, <a href=\"https://profiles.wordpress.org/andraganescu/\">Andrei Draganescu</a>, <a href=\"https://profiles.wordpress.org/azaozz/\">Andrew Ozz</a>, <a href=\"https://profiles.wordpress.org/andrewserong/\">Andrew Serong</a>, <a href=\"https://profiles.wordpress.org/oandregal/\">Andre</a>, <a href=\"https://profiles.wordpress.org/afragen/\">Andy Fragen</a>, <a href=\"https://profiles.wordpress.org/aristath/\">Ari Stathopoulos</a>, <a href=\"https://profiles.wordpress.org/azurseisme/\">azurseisme</a>, <a href=\"https://profiles.wordpress.org/scruffian/\">Ben Dwyer</a>, <a href=\"https://profiles.wordpress.org/bernhard-reiter/\">Bernie Reiter</a>, <a href=\"https://profiles.wordpress.org/mxbclang/\">Bethany Chobanian Lang</a>, <a href=\"https://profiles.wordpress.org/bph/\">Birgit Pauli-Haack</a>, <a href=\"https://profiles.wordpress.org/bjorn2404/\">bjorn2404</a>, <a href=\"https://profiles.wordpress.org/cbravobernal/\">Carlos Bravo</a>, <a href=\"https://profiles.wordpress.org/poena/\">Carolina Nymark</a>, <a href=\"https://profiles.wordpress.org/claytoncollie/\">Clayton Collie</a>, <a href=\"https://profiles.wordpress.org/codesdnc/\">codesdnc</a>, <a href=\"https://profiles.wordpress.org/costdev/\">Colin Stewart</a>, <a href=\"https://profiles.wordpress.org/talldanwp/\">Daniel Richards</a>, <a href=\"https://profiles.wordpress.org/davidbaumwald/\">David Baumwald</a>, <a href=\"https://profiles.wordpress.org/get_dave/\">David Smith</a>, <a href=\"https://profiles.wordpress.org/davidvongries/\">David Vongries</a>, <a href=\"https://profiles.wordpress.org/dilipbheda/\">Dilip Bheda</a>, <a href=\"https://profiles.wordpress.org/dd32/\">Dion Hulse</a>, <a href=\"https://profiles.wordpress.org/ocean90/\">Dominik Schilling</a>, <a href=\"https://profiles.wordpress.org/ellatrix/\">Ella</a>, <a href=\"https://profiles.wordpress.org/manuilov/\">Eugene M</a>, <a href=\"https://profiles.wordpress.org/flixos90/\">Felix Arntz</a>, <a href=\"https://profiles.wordpress.org/fpodhorsky/\">fpodhorsky</a>, <a href=\"https://profiles.wordpress.org/franz00/\">franzaurus</a>, <a href=\"https://profiles.wordpress.org/gamecreature/\">gamecreature</a>, <a href=\"https://profiles.wordpress.org/pento/\">Gary Pendergast</a>, <a href=\"https://profiles.wordpress.org/mamaduka/\">George Mamadashvili</a>, <a href=\"https://profiles.wordpress.org/gisgeo/\">gisgeo</a>, <a href=\"https://profiles.wordpress.org/glendaviesnz/\">glendaviesnz</a>, <a href=\"https://profiles.wordpress.org/innovext/\">Innovext</a>, <a href=\"https://profiles.wordpress.org/ironprogrammer/\">ironprogrammer</a>, <a href=\"https://profiles.wordpress.org/isabel_brison/\">Isabel Brison</a>, <a href=\"https://profiles.wordpress.org/outrankjames/\">James</a>, <a href=\"https://profiles.wordpress.org/janthiel/\">Jan Thiel</a>, <a href=\"https://profiles.wordpress.org/carazo/\">Javier Carazo</a>, <a href=\"https://profiles.wordpress.org/audrasjb/\">Jb Audras</a>, <a href=\"https://profiles.wordpress.org/jchambo/\">jchambo</a>, <a href=\"https://profiles.wordpress.org/jeffpaul/\">jeffpaul</a>, <a href=\"https://profiles.wordpress.org/joelmadigan/\">joelmadigan</a>, <a href=\"https://profiles.wordpress.org/joen/\">Joen A.</a>, <a href=\"https://profiles.wordpress.org/johnbillion/\">John Blackbourn</a>, <a href=\"https://profiles.wordpress.org/johnwatkins0/\">John Watkins</a>, <a href=\"https://profiles.wordpress.org/desrosj/\">Jonathan Desrosiers</a>, <a href=\"https://profiles.wordpress.org/spacedmonkey/\">Jonny Harris</a>, <a href=\"https://profiles.wordpress.org/jsh4/\">jsh4</a>, <a href=\"https://profiles.wordpress.org/jrf/\">Juliette Reinders Folmer</a>, <a href=\"https://profiles.wordpress.org/kadamwhite/\">K. Adam White</a>, <a href=\"https://profiles.wordpress.org/kacper3355/\">kacper3355</a>, <a href=\"https://profiles.wordpress.org/kevin940726/\">Kai Hao</a>, <a href=\"https://profiles.wordpress.org/obenland/\">Konstantin Obenland</a>, <a href=\"https://profiles.wordpress.org/konyoldeath/\">konyoldeath</a>, <a href=\"https://profiles.wordpress.org/larsmqller/\">larsmqller</a>, <a href=\"https://profiles.wordpress.org/0mirka00/\">Lena Morita</a>, <a href=\"https://profiles.wordpress.org/leonidasmilossis/\">Leo Milo</a>, <a href=\"https://profiles.wordpress.org/lozula/\">lozula</a>, <a href=\"https://profiles.wordpress.org/mciampini/\">Marco Ciampini</a>, <a href=\"https://profiles.wordpress.org/tyxla/\">Marin Atanasov</a>, <a href=\"https://profiles.wordpress.org/clorith/\">Marius L. J.</a>, <a href=\"https://profiles.wordpress.org/mattkeys/\">Matt Keys</a>, <a href=\"https://profiles.wordpress.org/czapla/\">Michal Czaplinski</a>, <a href=\"https://profiles.wordpress.org/miguelaxcar/\">Miguel Axcar</a>, <a href=\"https://profiles.wordpress.org/mcsf/\">Miguel Fonseca</a>, <a href=\"https://profiles.wordpress.org/mukesh27/\">Mukesh Panchal</a>, <a href=\"https://profiles.wordpress.org/mw108/\">mw108</a>, <a href=\"https://profiles.wordpress.org/namithjawahar/\">Namith Jawahar</a>, <a href=\"https://profiles.wordpress.org/ndiego/\">Nick Diego</a>, <a href=\"https://profiles.wordpress.org/ntsekouras/\">Nik Tsekouras</a>, <a href=\"https://profiles.wordpress.org/nithins53/\">Nithin SreeRaj</a>, <a href=\"https://profiles.wordpress.org/nuvopoint/\">nuvoPoint</a>, <a href=\"https://profiles.wordpress.org/oakesjosh/\">oakesjosh</a>, <a href=\"https://profiles.wordpress.org/ockham/\">ockham</a>, <a href=\"https://profiles.wordpress.org/webmandesign/\">Oliver Juhas</a>, <a href=\"https://profiles.wordpress.org/swissspidy/\">Pascal Birchler</a>, <a href=\"https://profiles.wordpress.org/pbiron/\">Paul Biron</a>, <a href=\"https://profiles.wordpress.org/peterwilsoncc/\">Peter Wilson</a>, <a href=\"https://profiles.wordpress.org/petitphp/\">petitphp</a>, <a href=\"https://profiles.wordpress.org/pkolenbr/\">pkolenbr</a>, <a href=\"https://profiles.wordpress.org/pypwalters/\">pypwalters</a>, <a href=\"https://profiles.wordpress.org/ramonopoly/\">ramonopoly</a>, <a href=\"https://profiles.wordpress.org/youknowriad/\">Riad Benguella</a>, <a href=\"https://profiles.wordpress.org/rjasdfiii/\">rjasdfiii</a>, <a href=\"https://profiles.wordpress.org/noisysocks/\">Robert Anderson</a>, <a href=\"https://profiles.wordpress.org/rodricus/\">rodricus</a>, <a href=\"https://profiles.wordpress.org/ryankienstra/\">Ryan Kienstra</a>, <a href=\"https://profiles.wordpress.org/mikachan/\">Sarah Norris</a>, <a href=\"https://profiles.wordpress.org/sergeybiryukov/\">Sergey Biryukov</a>, <a href=\"https://profiles.wordpress.org/stentibbing/\">stentibbing</a>, <a href=\"https://profiles.wordpress.org/sabernhardt/\">Stephen Bernhardt</a>, <a href=\"https://profiles.wordpress.org/subrataemfluence/\">Subrata Sarkar</a>, <a href=\"https://profiles.wordpress.org/cybr/\">Sybre Waaijer</a>, <a href=\"https://profiles.wordpress.org/sippis/\">Timi Wahalahti</a>, <a href=\"https://profiles.wordpress.org/timothyblynjacobs/\">Timothy Jacobs</a>, <a href=\"https://profiles.wordpress.org/hellofromtonya/\">Tonya Mork</a>, <a href=\"https://profiles.wordpress.org/zodiac1978/\">Torsten Landsiedel</a>, and <a href=\"https://profiles.wordpress.org/vtad/\">vtad</a>.</p>\n\n\n\n<h2>How to contribute</h2>\n\n\n\n<p>To get involved in WordPress core development, head over to Trac, <a href=\"https://core.trac.wordpress.org/report/6\">pick a ticket</a>, and join the conversation in the <a href=\"https://wordpress.slack.com/archives/C02RQBWTW\">#core</a> and <a href=\"https://wordpress.slack.com/archives/C03LZ88NX6G\">#6-1-release-leads channels</a>. Need help? Check out the <a href=\"https://make.wordpress.org/core/handbook/\">Core Contributor Handbook</a>.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Tue, 15 Nov 2022 19:51:45 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:12:\"Jeffrey Paul\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:45;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:94:\"Post Status: Keeping Higher Education Website Managers’ Dream Alive While Sunsetting Edupack\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:32:\"https://poststatus.com/?p=128296\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:102:\"https://poststatus.com/keeping-higher-education-website-managers-dream-alive-while-sunsetting-edupack/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:4975:\"<p class=\"has-drop-cap\">Every University IT department dreams of a self-service system in which they do not have to deal with outside vendors. The dream includes a simple form that its users can fill out to generate websites from a library of templates. With Nathan Monk and Matt Lees, I cofounded a project called Edupack to realize the dream of simplified website management with a single WordPress plugin.</p>\n\n\n\n<img width=\"752\" height=\"471\" src=\"https://cdn.poststatus.com/wp-content/uploads/2022/10/image-3-752x471.jpg\" alt=\"A screenshot of the Edupack plugin.\" class=\"not-transparent wp-image-128297\" />A screenshot of the Edupack plugin.\n\n\n\n<p>After eighteen months, <a href=\"https://poststatus.com/evolving-edupack-a-one-size-fits-all-plugin-leads-to-an-accessibility-platform-and-enhanced-agency-services\">Edupack is stopping work and moving in a new direction</a>.</p>\n\n\n\n<p>After user studies with folks from over 40 universities, including Harvard and Georgetown, I realize that Edupack cannot simplify website management with one plugin.</p>\n\n\n\n<p>University users have particular website needs. We would have to build thousands of templates to satisfy the many detail-focused university users before. That design work is not affordable for many Higher Ed technology teams.</p>\n\n\n\n<p>That said, Higher Ed pros should keep their dream of simplified website management alive.</p>\n\n\n\n<p>I encourage most Universities to give up templated solutions and restrict “self-service” controls. Templates do not meet specific user requirements. Technology teams should focus on websites that can’t be built on WordPress.com or Squarespace. Many self-service use cases, like faculty profiles, can be satisfied with simple forms instead of access to an entire Content Management System.</p>\n\n\n\n<p>Another key to simplified website management is increased resources. Website managers should argue the importance of their role. Websites are a key touchpoint for students. They not only include vital services like Student Information Systems, but websites also establish branding. Branding is an undervalued resource. Security teams rely on branding to establish official communication and brand awareness increases the marketing potential of any institution.</p>\n\n\n\n<p>Of course, Harvard has one of the most recognizable brands. They also have one of the more successful web teams I’ve seen. The <a href=\"https://hwp.harvard.edu\">Harvard Web Publishing</a> team fields tickets for new websites. Some of their websites are delivered as templated solutions. Other websites are built to the bespoke interests of their colleagues. Every new user goes through a content accessibility training course and their support staff is trained to answer most website publishing issues. That model allows Harvard to set their own requirements instead of relying on a third-party service while giving faculty and students a vital resource for promoting university-related work.</p>\n\n\n\n<p>Most institutions do not have a budget to create their in-house web agency or hire third-party vendors. That fact troubles me. My only solution to that problem is for prominent universities to open-source their work and knowledge. Groups like <a href=\"https://www.wpcampus.org\">WP Campus</a> help share open-source web publishing knowledge. Without paying any membership fee, administrators at small schools can participate in the active WP Campus Slack channels and attend their annual conference. The onus is on university staff to contribute their knowledge to the group.</p>\n\n\n\n<p>Edupack was born because of WP Campus. Matt, Nathan, and I saw reoccurring complaints about the complexity of website management on the WP Campus Slack. After many months of work, I hope lessons from Edupack inspire ever-better solutions.</p>\n\n\n\n<div class=\"wp-block-media-text is-stacked-on-mobile is-image-fill has-background\" id=\"author\"><a href=\"https://poststatus.com/\"><img width=\"250\" height=\"250\" src=\"https://cdn.poststatus.com/wp-content/uploads/2022/07/Fh0orwK7_400x400.jpg\" alt=\"Blake Bertucelli\" class=\"wp-image-102307 size-full\" /></a><div class=\"wp-block-media-text__content\">\n<p><strong>Blake Bertucelli</strong> is simplifying website management with <a href=\"https://edupack.dev)\">Edupack</a>, while building the world’s first accessibility platform, <a href=\"https://t.co/qU9MY0KpIl\">equalify.app</a>, and supporting independent journalism with <a href=\"http://t.co/wwRl8NtG4X\">Decubing Web Services</a>.</p>\n\n\n\n<ul class=\"is-content-justification-left is-layout-flex wp-container-11 wp-block-social-links has-small-icon-size is-style-logos-only\"><li class=\"wp-social-link wp-social-link-twitter wp-block-social-link\"><a href=\"https://twitter.com/bbertucc\" class=\"wp-block-social-link-anchor\"><span class=\"wp-block-social-link-label screen-reader-text\">Twitter</span></a></li></ul>\n</div></div>\n<p>This article was published at Post Status — the community for WordPress professionals.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Tue, 15 Nov 2022 14:15:00 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:17:\"Blake Bertuccelli\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:46;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:84:\"Do The Woo Community: Krissie VandeNoord, Building Custom Solutions with WooCommerce\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:28:\"https://dothewoo.io/?p=73496\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:82:\"https://dothewoo.io/krissie-vandenoord-building-custom-solutions-with-woocommerce/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:438:\"<p>Krissie VandeNoord shares insights and experiences with WooCommerce and WordPress through her agency North UX Design.</p>\n<p>&gt;&gt; The post <a rel=\"nofollow\" href=\"https://dothewoo.io/krissie-vandenoord-building-custom-solutions-with-woocommerce/\">Krissie VandeNoord, Building Custom Solutions with WooCommerce</a> appeared first on <a rel=\"nofollow\" href=\"https://dothewoo.io\">Do the Woo - a WooCommerce Builder Community</a>	.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Tue, 15 Nov 2022 10:14:00 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:5:\"BobWP\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:47;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:91:\"WPTavern: WordPress to Explore Using GitHub Codespaces for Improving Contributor Experience\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:30:\"https://wptavern.com/?p=139477\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:102:\"https://wptavern.com/wordpress-to-explore-using-github-codespaces-for-improving-contributor-experience\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:4102:\"<p>WordPress lead developer Helen Hou-Sandí has <a href=\"https://make.wordpress.org/core/2022/11/09/improving-the-contributor-experience-github-codespaces-for-wordpress-core/\">proposed using GitHub Codespaces</a> to improve the contributor experience. GitHub recently <a href=\"https://github.blog/2022-11-10-whats-new-with-codespaces-from-github-universe-2022/\">announced</a> the availability of GitHub Codespaces, its quick launch cloud-based developer environment, for all users, with 60 hours free per month for Free users and 90 hours for Pro users. Codespaces makes it possible to launch any GitHub repository in a single click.  </p>\n\n\n\n<img />image source: <a href=\"https://github.co.jp/features/codespaces\">GitHub.com</a>\n\n\n\n<p>&#8220;I’m looking to make <code>wordpress/wordpress-develop</code> usable in GitHub Codespaces with an initial target audience of folks getting started with contributing to core on a Contributor Day,&#8221; Hou-Sandí. &#8220;This seems to mostly be a matter of making decisions about our container setup(s).&#8221;</p>\n\n\n\n<p>Getting a development environment up and running can be one of the most time-consuming aspects of attending a contributor day, especially with slow wi-fi. Hou-Sandí recently experienced this at the 2022 WordCamp US Contributor Day.</p>\n\n\n\n<p>&#8220;This experience reminded me that as a project we should take a look at making it ever-easier to contribute to WordPress, and a remote development option is a good thing to have in our toolkit,&#8221; she said. &#8220;This allows contributors to get started with minimal setup and without the requirement of a desktop/laptop – you could patch and test WordPress from a tablet or your phone.&#8221;</p>\n\n\n\n<p>Hou-Sandí has been working with Codespaces for nearly two years. In her 2021 WCUS presentation titled &#8220;<a href=\"https://wordpress.tv/2021/12/23/helen-hou-sandi-a-voice-for-the-new-white-house-administration-with-the-block-editor/\">A voice for the new White House administration with the block editor</a>,&#8221; she surprised the audience with a live demo of the architecture of <a href=\"https://github.com/helen/wcus-2021\">a custom block</a> using Codespaces. The <a href=\"https://videopress.com/v/JUu36f8a?at=1810\">recording</a>, which tours some of the work she and her team did on the 2020/2021 Biden/Harris whitehouse.gov website, is a good example of how Codespaces can be a helpful tool for WordPress development.</p>\n\n\n\n<p>WordPress developers responded positively in support of using Codespaces to improve contributor experience and many are eager to help on the project and test when it&#8217;s ready.</p>\n\n\n\n<p>Gutenberg engineer Riad Benguella said having a built-in online development and testing environment would be &#8220;a great addition to the WordPress and Gutenberg repositories.&#8221;</p>\n\n\n\n<p>If using Codespaces can reduce the friction and help people get set up with a development environment in a matter of minutes versus hours, it would significantly improve the productivity at events dedicated to contributing.</p>\n\n\n\n<p>&#8220;I believe this will help not only new but all contributors,&#8221; WordPress developer Tung Du said. &#8220;To me, using Codespaces to review PRs is such a great experience.&#8221;</p>\n\n\n\n<p>&#8220;Besides, adding Codespaces support also means adding devcontainer support, which makes it way easier to set up the local development environment for contributors who use VS Code.&#8221;</p>\n\n\n\n<p>GitHub&#8217;s limit of 60 free hours may also be used up by developers in their own projects so there may still be the need for tutorials on using other local development methods. For the occasional Codespaces user, it&#8217;s tough to beat the convenience of spinning up a development environment in seconds.</p>\n\n\n\n<p>&#8220;I love this even for contributors who aren’t new,&#8221; Scott Kingsley Clark said. &#8220;I personally would find this very handy as it removes another roadblock towards contributing. I’m all for it, I can’t wait to give it a try once it’s ready for testing.&#8221;</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Tue, 15 Nov 2022 03:15:55 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Sarah Gooding\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:48;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:121:\"Post Status: Evolving Edupack: A One-Size Fits All Plugin Leads to an Accessibility Platform and Enhanced Agency Services\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:32:\"https://poststatus.com/?p=128289\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:131:\"https://poststatus.com/evolving-edupack-a-one-size-fits-all-plugin-leads-to-an-accessibility-platform-and-enhanced-agency-services/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:3853:\"<p class=\"has-drop-cap\">A little over a year ago, I cofounded Edupack with Nathan Monk and Matt Lees. Edupack endeavored to simplify Higher Ed website publishing with a single WordPress plugin.</p>\n\n\n\n<blockquote><p>In our interviews, Higher Ed admins said they were overwhelmed by accessibility issues. Good accessibility tools are too expensive for most web teams. Cheaper tools do more harm than good.</p></blockquote>\n\n\n\n<p>For many months, Edupack met with folks from over 40 universities, including Harvard, Dartmouth, Johns Hopkins, and Georgetown. We identified key problems around accessibility, governance, and sunsetting sites with stale content. Lessons from countless user interviews led to months of user testing before we released a coded version in early 2022.</p>\n\n\n\n<p>Now, Edupack is evolving.</p>\n\n\n\n<p><strong>I now believe that a one size fits all website publishing product is not possible.</strong> Each university has its own set of requirements. The requirements vary from the placement of buttons to the type of accessibility a university mandates. In the end, universities shouldn’t sacrifice individual requirements for ease of use.</p>\n\n\n\n<p><strong>The features that can be productized are largely around content accessibility.</strong> In our Edupack interviews, Higher Ed admins said they were overwhelmed by accessibility issues. Good accessibility tools, like <a href=\"https://www.siteimprove.com/\">SiteImprove</a>, are too expensive for most web teams. Cheaper tools, like <a href=\"https://accessibe.com/\">accessiBe</a>, do more harm than help.</p>\n\n\n\n<p>Edupack lessons around Accessibility inspired a new project called <a href=\"https://equalify.app/\">Equalify</a>. Equalify releases tools users expect from accessibility scanners under an Open Source, <a href=\"https://opensource.org/licenses/AGPL-3.0\" target=\"_blank\" rel=\"noreferrer noopener\">Affero General Public License</a>. On top of Open Source code, we will build additional tools that simplify content accessibility, hopefully satisfying the needs of Higher Ed pros we spoke with when building Edupack.</p>\n\n\n\n<p>Edupack lessons outside of Accessibility will also not go to waste. My web design agency, Decubing, is launching “<a href=\"http://decubing.com/campus\">Managed Campus</a>.” Managed Campus brings no productized requirements to a project. That allows us to adapt to the individual Higher Ed specifications, which prevented us from continuing Edupack.</p>\n\n\n\n<p>My career is built around website management. While I will miss the ring of the “Edupack” name, I am confident that my new chapter with Decubing and Equalify is a step toward better website management.</p>\n\n\n\n<div class=\"wp-block-media-text is-stacked-on-mobile is-image-fill has-background\" id=\"author\"><a href=\"https://poststatus.com/\"><img width=\"250\" height=\"250\" src=\"https://cdn.poststatus.com/wp-content/uploads/2022/07/Fh0orwK7_400x400.jpg\" alt=\"Blake Bertucelli\" class=\"wp-image-102307 size-full\" /></a><div class=\"wp-block-media-text__content\">\n<p><strong>Blake Bertucelli</strong> is simplifying website management with <a href=\"https://edupack.dev)\">Edupack</a>, while building the world’s first accessibility platform, <a href=\"https://t.co/qU9MY0KpIl\">equalify.app</a>, and supporting independent journalism with <a href=\"http://t.co/wwRl8NtG4X\">Decubing Web Services</a>.</p>\n\n\n\n<ul class=\"is-content-justification-left is-layout-flex wp-container-13 wp-block-social-links has-small-icon-size is-style-logos-only\"><li class=\"wp-social-link wp-social-link-twitter wp-block-social-link\"><a href=\"https://twitter.com/bbertucc\" class=\"wp-block-social-link-anchor\"><span class=\"wp-block-social-link-label screen-reader-text\">Twitter</span></a></li></ul>\n</div></div>\n<p>This article was published at Post Status — the community for WordPress professionals.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Mon, 14 Nov 2022 15:00:00 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:17:\"Blake Bertuccelli\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:49;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:122:\"WordPress.org blog: WP Briefing: Episode 43: Openverse &amp; Photo Directory– What Are They, and How Are They Different?\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:53:\"https://wordpress.org/news/?post_type=podcast&p=13890\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:113:\"https://wordpress.org/news/2022/11/episode-43-openverse-photo-directory-what-are-they-and-how-are-they-different/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:8472:\"<p>In the forty-third episode of the WordPress Briefing, Josepha Haden Chomphosy explores two resources for openly licensed media in the WordPress project&#8211; Openverse and Photo Directory&#8211; and how they differ from one another!</p>\n\n\n\n<p><em><strong>Have a question you&#8217;d like answered? You can submit them to <a href=\"mailto:wpbriefing@wordpress.org\">wpbriefing@wordpress.org</a>, either written or as a voice recording.</strong></em></p>\n\n\n\n<h2>Credits</h2>\n\n\n\n<p>Editor:&nbsp;<a href=\"https://profiles.wordpress.org/dustinhartzler/\">Dustin Hartzler</a><br />Logo:&nbsp;<a href=\"https://profiles.wordpress.org/javiarce/\">Javier Arce</a><br />Production:&nbsp;<a href=\"https://profiles.wordpress.org/santanainniss/\">Santana Inniss</a><br />Song: Fearless First by Kevin MacLeod </p>\n\n\n\n<h2>References</h2>\n\n\n\n<p><a href=\"https://make.wordpress.org/photos/\">Photo Directory Make Page</a><br /><a href=\"https://wordpress.org/photos/submit/\">Submit a Photo to the Photo Directory</a><br /><a href=\"https://make.wordpress.org/openverse/\">Openverse Make Page</a><br /><a href=\"https://github.com/WordPress/gutenberg/issues/44496\">Openverse Call for Contributions: Block Editor Integration</a><br /><a href=\"https://wordpress.org/download/\">Download WordPress 6.1</a><br /><a href=\"https://make.wordpress.org/docs/?p=13761\">Docs Team Contributor Day Recap Post</a><br /><a href=\"https://wp.me/p4FYxH-1XH\">Hallway Hangout Block Themes (Video)</a></p>\n\n\n\n<h2>Transcript</h2>\n\n\n\n<span id=\"more-13890\"></span>\n\n\n\n<p><strong>[Josepha Haden Chomphosy 00:00:00]&nbsp;</strong></p>\n\n\n\n<p>Hello everyone, and welcome to the WordPress Briefing, the podcast where you can catch quick explanations of the ideas behind the WordPress open source project, some insight into the community that supports it, and get a small list of big things coming up in the next two weeks.&nbsp;</p>\n\n\n\n<p>I&#8217;m your host, Josepha Haden Chomphosy. Here we go!</p>\n\n\n\n<p><strong>[Josepha Haden Chomphosy 00:00:27] </strong></p>\n\n\n\n<p>About 18 months ago, the Openverse project became part of the WordPress open source project, and at roughly the same time, we also welcomed the Photo Directory.</p>\n\n\n\n<p>Since that time, we&#8217;ve seen growth in teams supporting both of these initiatives. But if you&#8217;re not involved in the day-to-day, it can be hard to know how those two things fit together or if they fit together at all.</p>\n\n\n\n<p><strong>[Josepha Haden Chomphosy 00:01:00]&nbsp;</strong></p>\n\n\n\n<p>Today, let&#8217;s take a brief tour of those two projects and why they came to be.&nbsp;</p>\n\n\n\n<p>In my timeline, work on the Photo Directory started before the work on Openverse, so that&#8217;s where we&#8217;ll start.</p>\n\n\n\n<p>For as long as I can remember, the WordPress community has raised the need for WordPress-first ways to have and host GPL-compatible photos for use in themes, site builds, and marketing efforts as a whole. As recently as 2016, that was still coming up as a question at various flagship events and among the career photographers that contribute their time to WordPress.</p>\n\n\n\n<p>So in 2017 and 2018, as attention started to turn toward rebuilding the CMS using blocks, it dropped down the list of priority items. But it never really went away as a thing that people were hoping we could do for the project as a whole. So in 2019, it was becoming clear that having open source-first tools of all varieties for people whose businesses were built on our software would help broaden the availability of the open source freedoms we believe in.</p>\n\n\n\n<p><strong>[Josepha Haden Chomphosy 00:02:00]&nbsp;</strong></p>\n\n\n\n<p>This began the work on the Photo Directory with the intention of providing a GPL-friendly, community-driven repository of images. It has since launched, and we have photos in it now. We have a whole team around it. It&#8217;s wonderful. But that is how that all kind of came to be.&nbsp;</p>\n\n\n\n<p>Openverse, on the other hand, was launched as CC Search in 2019 with the laudable mandate to increase the discoverability and accessibility of open access media.</p>\n\n\n\n<p>Late in 2020, while work on the Photo Directory was underway, Matt shared with me that the team was looking for a new project home. When I first met with them, they shared an overview of the product, which they shorthanded as an open source search engine that searches openly licensed images. We were working on a repo of openly licensed images, so clearly, this was all written in the stars. And so you might be asking yourself at this point, great, how does it work together?</p>\n\n\n\n<p>I think for most of us, the timeline there kind of covers the question of what is the difference between these two things.&nbsp;</p>\n\n\n\n<p><strong>[Josepha Haden Chomphosy 00:03:00]&nbsp;</strong></p>\n\n\n\n<p>But because I never know which of you will want to strike up a conversation about open source on an elevator, I&#8217;ve also got the elevator pitch version.&nbsp;</p>\n\n\n\n<p>Openverse is an open source search engine that searches, indexes, and aggregates copy left media from across the web using sources such as WordPress&#8217;s Photo Directory, Flickr&#8217;s CC Tagged Media, and Wikimedia, to name just a few.&nbsp;</p>\n\n\n\n<p>Another key difference between the Photo Directory and Openverse is that in order to contribute to the Photo Directory, now that it&#8217;s all built, that&#8217;s mostly done by submitting photos or reviewing photos. So you don&#8217;t really need to be a developer to join in.&nbsp;</p>\n\n\n\n<p>Openverse is not only a developer-centric contribution opportunity, but it also uses a different tech stack than WordPress as a whole. So it&#8217;s a good place for folks to go if they&#8217;re looking to broaden their horizons.</p>\n\n\n\n<p>So that&#8217;s your elevator pitch of what Openverse is and how it uses the Photo Directory.&nbsp;</p>\n\n\n\n<p><strong>[Josepha Haden Chomphosy 00:04:00]&nbsp;</strong></p>\n\n\n\n<p>You have a couple of ways that you can get involved with these two projects. For the Photo Directory, as I mentioned at the start, you can always contribute photos, and they could always use more photo contributions.</p>\n\n\n\n<p>I&#8217;ll include a link to the submission guidelines in the show notes below, and as I mentioned, it is a no-code way to give back to the WordPress project. So no code, development environments, and testing skills are required. The Photo Directory team also could always use more contributors to help with the moderating of photo submissions.</p>\n\n\n\n<p>And so I&#8217;ll link to their making WordPress page in the show notes as well so that you can get started there.&nbsp;</p>\n\n\n\n<p>And as I mentioned before, Openverse is an aggregator, so it doesn&#8217;t host any media itself, but it is always accepting suggestions for new GPL-compatible media providers. I&#8217;ll link the area where you can leave suggestions in the show notes as well.</p>\n\n\n\n<p>And if you are more code inclined, there&#8217;s an open issue for adding Openverse browsing to the block editor right now.&nbsp;&nbsp;</p>\n\n\n\n<p><strong>[Josepha Haden Chomphosy 00:05:00]&nbsp;</strong></p>\n\n\n\n<p>So I&#8217;ll link that issue in the show notes in case you thought to yourself, gosh, that sounds like my most favorite thing to do. That is where you can go.&nbsp;</p>\n\n\n\n<p><strong>[Josepha Haden Chomphosy 00:05:12]</strong></p>\n\n\n\n<p>This leads us now to our small list of big things.</p>\n\n\n\n<p>In case you missed it, WordPress 6.1 is now available. It launched on November 1st. Late, late, late in the day, and so it was easy to miss if you&#8217;re used to seeing it at a particular time. We were about six hours later than usual. But if you go to wordpress.org/download, you can get your own copy there.</p>\n\n\n\n<p>The second thing on our small list of big things is that the Docs team had a contributor day. It was excellent. There&#8217;s a recap post up. I will include that in the show notes.&nbsp;</p>\n\n\n\n<p>And then the final thing is that there was a recent hallway hangout that talked about the site editor and block themes.</p>\n\n\n\n<p>[<strong>Josepha Haden Chomphosy </strong>00:06:00]&nbsp;</p>\n\n\n\n<p>The video for that is also published. I will also share that in our show notes.</p>\n\n\n\n<p>And that, my friends, is your small list of big things. Thank you for tuning in today for the WordPress Briefing. I&#8217;m your host, Josepha Haden Chomphosy, and I&#8217;ll see you again in a couple of weeks.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Mon, 14 Nov 2022 12:00:00 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:14:\"Santana Inniss\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}}}}}}}}}}}}s:4:\"type\";i:128;s:7:\"headers\";O:42:\"Requests_Utility_CaseInsensitiveDictionary\":1:{s:7:\"\0*\0data\";a:8:{s:6:\"server\";s:5:\"nginx\";s:4:\"date\";s:29:\"Thu, 01 Dec 2022 08:42:34 GMT\";s:12:\"content-type\";s:8:\"text/xml\";s:13:\"last-modified\";s:29:\"Thu, 01 Dec 2022 08:30:30 GMT\";s:4:\"vary\";s:15:\"Accept-Encoding\";s:15:\"x-frame-options\";s:10:\"SAMEORIGIN\";s:16:\"content-encoding\";s:2:\"br\";s:4:\"x-nc\";s:9:\"HIT ord 2\";}}s:5:\"build\";s:14:\"20211220193300\";}","no");
INSERT INTO ceba_options VALUES("186","_transient_timeout_feed_mod_d117b5738fbd35bd8c0391cda1f2b5d9","1669927354","no");
INSERT INTO ceba_options VALUES("187","_transient_feed_mod_d117b5738fbd35bd8c0391cda1f2b5d9","1669884154","no");
INSERT INTO ceba_options VALUES("188","_transient_timeout_dash_v2_88ae138922fe95674369b1cb3d215a2b","1669927354","no");
INSERT INTO ceba_options VALUES("189","_transient_dash_v2_88ae138922fe95674369b1cb3d215a2b","<div class=\"rss-widget\"><ul><li><a class=\'rsswidget\' href=\'https://wordpress.org/news/2022/11/people-of-wordpress-huanyi-chuang/\'>People of WordPress: Huanyi Chuang</a></li><li><a class=\'rsswidget\' href=\'https://wordpress.org/news/2022/11/episode-44-minors-majors-and-why-we-have-so-many-releases/\'>WP Briefing: Episode 44: Minors, Majors, and Why We Have So Many Releases</a></li></ul></div><div class=\"rss-widget\"><ul><li><a class=\'rsswidget\' href=\'https://wptavern.com/elasticpress-4-4-0-adds-new-status-report-page-and-instant-results-template-customization\'>WPTavern: ElasticPress 4.4.0 Adds New Status Report Page and Instant Results Template Customization</a></li><li><a class=\'rsswidget\' href=\'https://wptavern.com/wordpress-versions-3-7-4-0-no-longer-get-security-updates\'>WPTavern: WordPress Versions 3.7-4.0 No Longer Get Security Updates</a></li><li><a class=\'rsswidget\' href=\'https://wordpress.org/news/2022/11/people-of-wordpress-huanyi-chuang/\'>WordPress.org blog: People of WordPress: Huanyi Chuang</a></li></ul></div>","no");
INSERT INTO ceba_options VALUES("245","googlesitekit_has_connected_admins","0","yes");
INSERT INTO ceba_options VALUES("247","elementor_remote_info_library","a:3:{s:10:\"types_data\";a:3:{s:5:\"block\";a:1:{s:10:\"categories\";a:22:{i:0;s:8:\"404 page\";i:1;s:5:\"about\";i:2;s:7:\"archive\";i:3;s:14:\"call to action\";i:4;s:7:\"clients\";i:5;s:7:\"contact\";i:6;s:3:\"faq\";i:7;s:8:\"features\";i:8;s:6:\"footer\";i:9;s:6:\"header\";i:10;s:4:\"hero\";i:11;s:9:\"portfolio\";i:12;s:7:\"pricing\";i:13;s:15:\"product archive\";i:14;s:8:\"services\";i:15;s:11:\"single page\";i:16;s:11:\"single post\";i:17;s:14:\"single product\";i:18;s:5:\"stats\";i:19;s:9:\"subscribe\";i:20;s:4:\"team\";i:21;s:12:\"testimonials\";}}s:5:\"popup\";a:1:{s:10:\"categories\";a:6:{i:0;s:10:\"bottom bar\";i:1;s:7:\"classic\";i:2;s:6:\"fly-in\";i:3;s:11:\"full screen\";i:4;s:9:\"hello bar\";i:5;s:8:\"slide-in\";}}s:2:\"lp\";a:1:{s:10:\"categories\";a:15:{i:0;s:8:\"Business\";i:1;s:16:\"Coming Soon Page\";i:2;s:9:\"eCommerce\";i:3;s:9:\"Education\";i:4;s:6:\"Events\";i:5;s:18:\"Health and Fitness\";i:6;s:3:\"NFT\";i:7;s:14:\"Online Service\";i:8;s:7:\"Product\";i:9;s:11:\"Real Estate\";i:10;s:18:\"Social Involvement\";i:11;s:14:\"Thank You Page\";i:12;s:6:\"Travel\";i:13;s:18:\"Under Construction\";i:14;s:9:\"Wireframe\";}}}s:10:\"categories\";a:22:{i:0;s:8:\"404 page\";i:1;s:5:\"about\";i:2;s:7:\"archive\";i:3;s:14:\"call to action\";i:4;s:7:\"clients\";i:5;s:7:\"contact\";i:6;s:3:\"faq\";i:7;s:8:\"features\";i:8;s:6:\"footer\";i:9;s:6:\"header\";i:10;s:4:\"hero\";i:11;s:9:\"portfolio\";i:12;s:7:\"pricing\";i:13;s:15:\"product archive\";i:14;s:8:\"services\";i:15;s:11:\"single page\";i:16;s:11:\"single post\";i:17;s:14:\"single product\";i:18;s:5:\"stats\";i:19;s:9:\"subscribe\";i:20;s:4:\"team\";i:21;s:12:\"testimonials\";}s:9:\"templates\";a:825:{i:0;a:16:{s:4:\"tmpl\";i:1280;s:2:\"id\";i:22403;s:5:\"title\";s:40:\"Hello Bar | Subscribe | Aesthetic Clinic\";s:9:\"thumbnail\";s:80:\"https://library.elementor.com/wp-content/uploads/2022/03/aesthetic-clinic-19.jpg\";s:12:\"tmpl_created\";i:1647354307;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:142:\"https://library.elementor.com/popups/hello-bar-subscribe-aesthetic-clinic/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:9:\"hello bar\";s:4:\"tags\";s:48:\"[\"Barbershop\",\"Business\",\"Discount\",\"Marketing\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:1;a:16:{s:4:\"tmpl\";i:1281;s:2:\"id\";i:22410;s:5:\"title\";s:32:\"Fly-In | Discount | Hair Stylist\";s:9:\"thumbnail\";s:76:\"https://library.elementor.com/wp-content/uploads/2022/03/hair-stylist-20.jpg\";s:12:\"tmpl_created\";i:1647354614;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:134:\"https://library.elementor.com/popups/fly-in-discount-hair-stylist/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:6:\"fly-in\";s:4:\"tags\";s:32:\"[\"Barbershop\",\"Discount\",\"Hair\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:2;a:16:{s:4:\"tmpl\";i:1285;s:2:\"id\";i:22440;s:5:\"title\";s:32:\"Classic | Subscribe | Shoe Store\";s:9:\"thumbnail\";s:75:\"https://library.elementor.com/wp-content/uploads/2022/03/shoes-store-21.jpg\";s:12:\"tmpl_created\";i:1647418620;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:134:\"https://library.elementor.com/popups/classic-subscribe-shoe-store/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:37:\"[\"Ecommerce\",\"Marketing\",\"Subscribe\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:3;a:16:{s:4:\"tmpl\";i:1286;s:2:\"id\";i:22446;s:5:\"title\";s:37:\"Full Screen | Subscribe | Denim Store\";s:9:\"thumbnail\";s:75:\"https://library.elementor.com/wp-content/uploads/2022/03/denim-store-22.jpg\";s:12:\"tmpl_created\";i:1647419614;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:139:\"https://library.elementor.com/popups/full-screen-subscribe-denim-store/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:11:\"full screen\";s:4:\"tags\";s:35:\"[\"Ecommerce\",\"Fashion\",\"Marketing\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:4;a:16:{s:4:\"tmpl\";i:1287;s:2:\"id\";i:22452;s:5:\"title\";s:37:\"Fly-In | Subscribe | Pizza Restaurant\";s:9:\"thumbnail\";s:80:\"https://library.elementor.com/wp-content/uploads/2022/03/pizza-restaurant-23.jpg\";s:12:\"tmpl_created\";i:1647420733;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:139:\"https://library.elementor.com/popups/fly-in-subscribe-pizza-restaurant/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:6:\"fly-in\";s:4:\"tags\";s:19:\"[\"Business\",\"Food\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:5;a:16:{s:4:\"tmpl\";i:1288;s:2:\"id\";i:22458;s:5:\"title\";s:38:\"Full Screen | Subscribe | Fashion Shop\";s:9:\"thumbnail\";s:76:\"https://library.elementor.com/wp-content/uploads/2022/03/fashion-shop-24.jpg\";s:12:\"tmpl_created\";i:1647426379;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:140:\"https://library.elementor.com/popups/full-screen-subscribe-fashion-shop/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:11:\"full screen\";s:4:\"tags\";s:31:\"[\"Ecommerce\",\"Fashion\",\"Sales\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:6;a:16:{s:4:\"tmpl\";i:1289;s:2:\"id\";i:22464;s:5:\"title\";s:32:\"Fly-In | Contact | Makeup Studio\";s:9:\"thumbnail\";s:77:\"https://library.elementor.com/wp-content/uploads/2022/03/makeup-studio-25.jpg\";s:12:\"tmpl_created\";i:1647427026;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:134:\"https://library.elementor.com/popups/fly-in-contact-makeup-studio/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:6:\"fly-in\";s:4:\"tags\";s:22:\"[\"Business\",\"Contact\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:7;a:16:{s:4:\"tmpl\";i:1290;s:2:\"id\";i:22470;s:5:\"title\";s:32:\"Fly-In | Contact | Design Studio\";s:9:\"thumbnail\";s:77:\"https://library.elementor.com/wp-content/uploads/2022/03/design-studio-26.jpg\";s:12:\"tmpl_created\";i:1647428250;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:134:\"https://library.elementor.com/popups/fly-in-contact-design-studio/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:6:\"fly-in\";s:4:\"tags\";s:39:\"[\"Business\",\"Contact\",\"Digital Agency\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:8;a:16:{s:4:\"tmpl\";i:1291;s:2:\"id\";i:22480;s:5:\"title\";s:27:\"Classic | CTA | MasterClass\";s:9:\"thumbnail\";s:76:\"https://library.elementor.com/wp-content/uploads/2022/03/master-class-27.jpg\";s:12:\"tmpl_created\";i:1647428474;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:129:\"https://library.elementor.com/popups/classic-cta-masterclass/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:29:\"[\"cta\",\"Magazine\",\"Services\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:9;a:16:{s:4:\"tmpl\";i:1292;s:2:\"id\";i:22489;s:5:\"title\";s:29:\"Classic | CTA | Music Concert\";s:9:\"thumbnail\";s:77:\"https://library.elementor.com/wp-content/uploads/2022/03/music-concert-29.jpg\";s:12:\"tmpl_created\";i:1647429738;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:131:\"https://library.elementor.com/popups/classic-cta-music-concert/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:34:\"[\"cta\",\"Landing Pages\",\"Magazine\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:10;a:16:{s:4:\"tmpl\";i:1293;s:2:\"id\";i:22495;s:5:\"title\";s:27:\"Classic | CTA | Music Album\";s:9:\"thumbnail\";s:75:\"https://library.elementor.com/wp-content/uploads/2022/03/music-album-30.jpg\";s:12:\"tmpl_created\";i:1647430056;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:129:\"https://library.elementor.com/popups/classic-cta-music-album/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:34:\"[\"Ba\",\"Landing Pages\",\"Marketing\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:11;a:16:{s:4:\"tmpl\";i:1294;s:2:\"id\";i:22501;s:5:\"title\";s:37:\"Fly-In | CTA | Photography Exhibition\";s:9:\"thumbnail\";s:86:\"https://library.elementor.com/wp-content/uploads/2022/03/photography-exhibition-31.jpg\";s:12:\"tmpl_created\";i:1647430512;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:139:\"https://library.elementor.com/popups/fly-in-cta-photography-exhibition/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:6:\"fly-in\";s:4:\"tags\";s:33:\"[\"cta\",\"Photography\",\"Portfolio\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:12;a:16:{s:4:\"tmpl\";i:1295;s:2:\"id\";i:22507;s:5:\"title\";s:34:\"Classic | CTA | Clothing Shop Sale\";s:9:\"thumbnail\";s:82:\"https://library.elementor.com/wp-content/uploads/2022/03/clothing-shop-sale-32.jpg\";s:12:\"tmpl_created\";i:1647430774;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:136:\"https://library.elementor.com/popups/classic-cta-clothing-shop-sale/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:35:\"[\"Ecommerce\",\"Fashion\",\"Marketing\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:13;a:16:{s:4:\"tmpl\";i:1296;s:2:\"id\";i:22486;s:5:\"title\";s:30:\"Classic | CTA | Shop Promotion\";s:9:\"thumbnail\";s:78:\"https://library.elementor.com/wp-content/uploads/2022/03/shop-promotion-28.jpg\";s:12:\"tmpl_created\";i:1647430951;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:132:\"https://library.elementor.com/popups/classic-cta-shop-promotion/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:32:\"[\"cta\",\"Magazine\",\"Photography\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:14;a:16:{s:4:\"tmpl\";i:1297;s:2:\"id\";i:22516;s:5:\"title\";s:32:\"Fly-In | CTA | Glasses Shop Sale\";s:9:\"thumbnail\";s:81:\"https://library.elementor.com/wp-content/uploads/2022/03/glasses-shop-sale-33.jpg\";s:12:\"tmpl_created\";i:1647431136;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:134:\"https://library.elementor.com/popups/fly-in-cta-glasses-shop-sale/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:6:\"fly-in\";s:4:\"tags\";s:30:\"[\"Business\",\"cta\",\"Marketing\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:15;a:16:{s:4:\"tmpl\";i:1298;s:2:\"id\";i:22522;s:5:\"title\";s:30:\"Fly-In | Discount | Skate Shop\";s:9:\"thumbnail\";s:83:\"https://library.elementor.com/wp-content/uploads/2022/03/50-skate-shop-Discount.jpg\";s:12:\"tmpl_created\";i:1647434058;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:132:\"https://library.elementor.com/popups/fly-in-discount-skate-shop/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:6:\"fly-in\";s:4:\"tags\";s:32:\"[\"Discount\",\"Ecommerce\",\"Sales\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:16;a:16:{s:4:\"tmpl\";i:1299;s:2:\"id\";i:22532;s:5:\"title\";s:43:\"Classic | Subscription | Basketball Academy\";s:9:\"thumbnail\";s:95:\"https://library.elementor.com/wp-content/uploads/2022/03/21-basketball-academy-Subscription.jpg\";s:12:\"tmpl_created\";i:1647434608;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:145:\"https://library.elementor.com/popups/classic-subscription-basketball-academy/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:33:\"[\"Education\",\"Marketing\",\"Sport\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:17;a:16:{s:4:\"tmpl\";i:1300;s:2:\"id\";i:22543;s:5:\"title\";s:38:\"Classic | Discount | Veterinary Clinic\";s:9:\"thumbnail\";s:84:\"https://library.elementor.com/wp-content/uploads/2022/03/veterinery-clinic-small.jpg\";s:12:\"tmpl_created\";i:1647435581;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:140:\"https://library.elementor.com/popups/classic-discount-veterinary-clinic/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:19:\"[\"Discount\",\"Pets\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:18;a:16:{s:4:\"tmpl\";i:1301;s:2:\"id\";i:22553;s:5:\"title\";s:39:\"Classic | Contact | Business Consulting\";s:9:\"thumbnail\";s:94:\"https://library.elementor.com/wp-content/uploads/2022/03/27-business-consulting-Contact-Us.jpg\";s:12:\"tmpl_created\";i:1647439935;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:141:\"https://library.elementor.com/popups/classic-contact-business-consulting/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:22:\"[\"Business\",\"Contact\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:19;a:16:{s:4:\"tmpl\";i:1302;s:2:\"id\";i:22562;s:5:\"title\";s:28:\"Classic | Contact | Handyman\";s:9:\"thumbnail\";s:75:\"https://library.elementor.com/wp-content/uploads/2022/03/handyman-small.jpg\";s:12:\"tmpl_created\";i:1647440333;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:130:\"https://library.elementor.com/popups/classic-contact-handyman/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:33:\"[\"Business\",\"Contact\",\"Services\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:20;a:16:{s:4:\"tmpl\";i:1303;s:2:\"id\";i:22573;s:5:\"title\";s:40:\"Classic | Discount | Online Fashion Shop\";s:9:\"thumbnail\";s:92:\"https://library.elementor.com/wp-content/uploads/2022/03/31-online-fashion-shop-Discount.jpg\";s:12:\"tmpl_created\";i:1647462549;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:142:\"https://library.elementor.com/popups/classic-discount-online-fashion-shop/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:32:\"[\"Discount\",\"Ecommerce\",\"Sales\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:21;a:16:{s:4:\"tmpl\";i:1304;s:2:\"id\";i:22583;s:5:\"title\";s:36:\"Fly-In | Discount | Personal Trainer\";s:9:\"thumbnail\";s:83:\"https://library.elementor.com/wp-content/uploads/2022/03/personal-trainer-small.jpg\";s:12:\"tmpl_created\";i:1647503781;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:138:\"https://library.elementor.com/popups/fly-in-discount-personal-trainer/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:6:\"fly-in\";s:4:\"tags\";s:31:\"[\"Discount\",\"Sport\",\"Training\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:22;a:16:{s:4:\"tmpl\";i:1305;s:2:\"id\";i:22592;s:5:\"title\";s:41:\"Classic | Contact | Illustrator Portfolio\";s:9:\"thumbnail\";s:88:\"https://library.elementor.com/wp-content/uploads/2022/03/illustrator-protfolio-small.jpg\";s:12:\"tmpl_created\";i:1647504218;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:143:\"https://library.elementor.com/popups/classic-contact-illustrator-portfolio/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:49:\"[\"Contact\",\"Creative Portfolio\",\"Digital Agency\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:23;a:16:{s:4:\"tmpl\";i:1306;s:2:\"id\";i:22602;s:5:\"title\";s:46:\"Bottom Bar | Discount | Handmade Ceramics Shop\";s:9:\"thumbnail\";s:91:\"https://library.elementor.com/wp-content/uploads/2022/03/handmade-ceramic-shop-36-small.jpg\";s:12:\"tmpl_created\";i:1647507007;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:148:\"https://library.elementor.com/popups/bottom-bar-discount-handmade-ceramics-shop/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:10:\"bottom bar\";s:4:\"tags\";s:48:\"[\"Business\",\"cta\",\"Ecommerce\",\"Interior Design\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:24;a:16:{s:4:\"tmpl\";i:1307;s:2:\"id\";i:22612;s:5:\"title\";s:51:\"Classic | Contact | Classic Car Restoration Company\";s:9:\"thumbnail\";s:90:\"https://library.elementor.com/wp-content/uploads/2022/03/restoration-car-shop-37-small.jpg\";s:12:\"tmpl_created\";i:1647507310;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:153:\"https://library.elementor.com/popups/classic-contact-classic-car-restoration-company/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:32:\"[\"Booking\",\"Contact\",\"Services\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:25;a:16:{s:4:\"tmpl\";i:1308;s:2:\"id\";i:22621;s:5:\"title\";s:30:\"Classic | Booking | Life Coach\";s:9:\"thumbnail\";s:82:\"https://library.elementor.com/wp-content/uploads/2022/03/38-life-coach-Booking.jpg\";s:12:\"tmpl_created\";i:1647508596;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:132:\"https://library.elementor.com/popups/classic-booking-life-coach/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:33:\"[\"Booking\",\"Business\",\"Services\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:26;a:16:{s:4:\"tmpl\";i:1309;s:2:\"id\";i:22632;s:5:\"title\";s:42:\"Classic |  Subscription | Merchandise Shop\";s:9:\"thumbnail\";s:86:\"https://library.elementor.com/wp-content/uploads/2022/03/Merchandise-Shop-39-small.jpg\";s:12:\"tmpl_created\";i:1647509196;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:143:\"https://library.elementor.com/popups/classic-subscription-merchandise-shop/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:32:\"[\"Ecommerce\",\"Marketing\",\"Shop\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:27;a:16:{s:4:\"tmpl\";i:1310;s:2:\"id\";i:22643;s:5:\"title\";s:48:\"Fly-In | Contact | Non-Governmental Organization\";s:9:\"thumbnail\";s:73:\"https://library.elementor.com/wp-content/uploads/2022/03/NGO-41-small.jpg\";s:12:\"tmpl_created\";i:1647509528;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:150:\"https://library.elementor.com/popups/fly-in-contact-non-governmental-organization/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:6:\"fly-in\";s:4:\"tags\";s:11:\"[\"Contact\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:28;a:16:{s:4:\"tmpl\";i:1311;s:2:\"id\";i:22654;s:5:\"title\";s:35:\"Hello Bar | Contact | Family Doctor\";s:9:\"thumbnail\";s:83:\"https://library.elementor.com/wp-content/uploads/2022/03/family-doctor-44-small.jpg\";s:12:\"tmpl_created\";i:1647509732;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:137:\"https://library.elementor.com/popups/hello-bar-contact-family-doctor/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:9:\"hello bar\";s:4:\"tags\";s:31:\"[\"Contact\",\"Health\",\"Services\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:29;a:16:{s:4:\"tmpl\";i:1312;s:2:\"id\";i:22663;s:5:\"title\";s:36:\"Classic | Subscription | Sports Blog\";s:9:\"thumbnail\";s:87:\"https://library.elementor.com/wp-content/uploads/2022/03/45-sport-blog-Subscription.jpg\";s:12:\"tmpl_created\";i:1647509908;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:138:\"https://library.elementor.com/popups/classic-subscription-sports-blog/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:16:\"[\"Blog\",\"Sport\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:30;a:16:{s:4:\"tmpl\";i:1313;s:2:\"id\";i:22673;s:5:\"title\";s:30:\"Hello Bar | Booking | Event DJ\";s:9:\"thumbnail\";s:80:\"https://library.elementor.com/wp-content/uploads/2022/03/DJ-service-46-small.jpg\";s:12:\"tmpl_created\";i:1647510160;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:132:\"https://library.elementor.com/popups/hello-bar-booking-event-dj/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:9:\"hello bar\";s:4:\"tags\";s:31:\"[\"Booking\",\"Events\",\"Services\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:31;a:16:{s:4:\"tmpl\";i:1314;s:2:\"id\";i:22684;s:5:\"title\";s:36:\"Fly-In | Discount | Cleaning Company\";s:9:\"thumbnail\";s:89:\"https://library.elementor.com/wp-content/uploads/2022/03/51-cleaning-company-Discount.jpg\";s:12:\"tmpl_created\";i:1647510546;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:138:\"https://library.elementor.com/popups/fly-in-discount-cleaning-company/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:6:\"fly-in\";s:4:\"tags\";s:31:\"[\"Discount\",\"Offer\",\"Services\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:32;a:16:{s:4:\"tmpl\";i:1315;s:2:\"id\";i:22693;s:5:\"title\";s:28:\"Fly-In | Contact | Carpenter\";s:9:\"thumbnail\";s:79:\"https://library.elementor.com/wp-content/uploads/2022/03/carpenter-53-small.jpg\";s:12:\"tmpl_created\";i:1647511972;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:130:\"https://library.elementor.com/popups/fly-in-contact-carpenter/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:6:\"fly-in\";s:4:\"tags\";s:22:\"[\"Contact\",\"Services\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:33;a:16:{s:4:\"tmpl\";i:1316;s:2:\"id\";i:22703;s:5:\"title\";s:31:\"Classic | Booking | Yoga Studio\";s:9:\"thumbnail\";s:86:\"https://library.elementor.com/wp-content/uploads/2022/03/55-yoga-studio-Contact-Us.jpg\";s:12:\"tmpl_created\";i:1647512209;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:133:\"https://library.elementor.com/popups/classic-booking-yoga-studio/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:30:\"[\"Booking\",\"Contact\",\"Health\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:34;a:16:{s:4:\"tmpl\";i:1317;s:2:\"id\";i:22714;s:5:\"title\";s:37:\"Classic | Discount | Pet Care Company\";s:9:\"thumbnail\";s:81:\"https://library.elementor.com/wp-content/uploads/2022/03/56-Pet-Care-Discount.jpg\";s:12:\"tmpl_created\";i:1647513031;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:139:\"https://library.elementor.com/popups/classic-discount-pet-care-company/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:17:\"[\"Offer\",\"Sales\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:35;a:16:{s:4:\"tmpl\";i:1318;s:2:\"id\";i:22725;s:5:\"title\";s:38:\"Fly-In | Discount | Online Coffee Shop\";s:9:\"thumbnail\";s:88:\"https://library.elementor.com/wp-content/uploads/2022/03/online-coffee-shop-57-small.jpg\";s:12:\"tmpl_created\";i:1647513325;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:140:\"https://library.elementor.com/popups/fly-in-discount-online-coffee-shop/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:6:\"fly-in\";s:4:\"tags\";s:29:\"[\"Food\",\"Offer\",\"Restaurant\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:36;a:16:{s:4:\"tmpl\";i:1319;s:2:\"id\";i:22737;s:5:\"title\";s:44:\"Fly-In | CTA | Moving &#038; Storage Company\";s:9:\"thumbnail\";s:84:\"https://library.elementor.com/wp-content/uploads/2022/03/moving-company-59-small.jpg\";s:12:\"tmpl_created\";i:1647520956;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:139:\"https://library.elementor.com/popups/fly-in-cta-moving-storage-company/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:6:\"fly-in\";s:4:\"tags\";s:12:\"[\"Services\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:37;a:16:{s:4:\"tmpl\";i:1320;s:2:\"id\";i:22749;s:5:\"title\";s:47:\"Classic | Contact | Industrial Design Portfolio\";s:9:\"thumbnail\";s:92:\"https://library.elementor.com/wp-content/uploads/2022/03/60-industrial-design-Contact-Us.jpg\";s:12:\"tmpl_created\";i:1647528116;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:149:\"https://library.elementor.com/popups/classic-contact-industrial-design-portfolio/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:40:\"[\"Contact\",\"Interior Design\",\"Services\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:38;a:16:{s:4:\"tmpl\";i:1321;s:2:\"id\";i:22759;s:5:\"title\";s:25:\"Classic | Contact | Drone\";s:9:\"thumbnail\";s:75:\"https://library.elementor.com/wp-content/uploads/2022/03/drone-61-small.jpg\";s:12:\"tmpl_created\";i:1647528899;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:127:\"https://library.elementor.com/popups/classic-contact-drone/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:22:\"[\"Contact\",\"Services\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:39;a:16:{s:4:\"tmpl\";i:1322;s:2:\"id\";i:22768;s:5:\"title\";s:46:\"Full Screen | Menu | Fashion Stylist Portfolio\";s:9:\"thumbnail\";s:84:\"https://library.elementor.com/wp-content/uploads/2022/03/62-Fashion-Stylist-Menu.jpg\";s:12:\"tmpl_created\";i:1647529434;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:148:\"https://library.elementor.com/popups/full-screen-menu-fashion-stylist-portfolio/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:11:\"full screen\";s:4:\"tags\";s:31:\"[\"Fashion\",\"Fullscreen\",\"menu\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:40;a:16:{s:4:\"tmpl\";i:1323;s:2:\"id\";i:22780;s:5:\"title\";s:31:\"Fly-In | CTA | Landscape Design\";s:9:\"thumbnail\";s:94:\"https://library.elementor.com/wp-content/uploads/2022/03/64-Landscape-Design-Click-Through.jpg\";s:12:\"tmpl_created\";i:1647530337;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:133:\"https://library.elementor.com/popups/fly-in-cta-landscape-design/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:6:\"fly-in\";s:4:\"tags\";s:18:\"[\"cta\",\"Services\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:41;a:16:{s:4:\"tmpl\";i:1324;s:2:\"id\";i:22790;s:5:\"title\";s:48:\"Bottom Bar  | Contact | Architecture Photography\";s:9:\"thumbnail\";s:94:\"https://library.elementor.com/wp-content/uploads/2022/03/architecture-photography-65-small.jpg\";s:12:\"tmpl_created\";i:1647532358;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:149:\"https://library.elementor.com/popups/bottom-bar-contact-architecture-photography/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:10:\"bottom bar\";s:4:\"tags\";s:26:\"[\"Architecture\",\"Contact\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:42;a:16:{s:4:\"tmpl\";i:1325;s:2:\"id\";i:22800;s:5:\"title\";s:41:\"Fly-In  | CTA | Speech-Language Therapist\";s:9:\"thumbnail\";s:103:\"https://library.elementor.com/wp-content/uploads/2022/03/66-Speech-Language-Therapist-Click-Through.jpg\";s:12:\"tmpl_created\";i:1647532720;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:142:\"https://library.elementor.com/popups/fly-in-cta-speech-language-therapist/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:6:\"fly-in\";s:4:\"tags\";s:25:\"[\"cta\",\"Psychotherapist\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:43;a:16:{s:4:\"tmpl\";i:1326;s:2:\"id\";i:22812;s:5:\"title\";s:35:\"Full Screen | Verification | Winery\";s:9:\"thumbnail\";s:83:\"https://library.elementor.com/wp-content/uploads/2022/03/67-Winery-Verification.jpg\";s:12:\"tmpl_created\";i:1647761384;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:137:\"https://library.elementor.com/popups/full-screen-verification-winery/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:11:\"full screen\";s:4:\"tags\";s:24:\"[\"Alert\",\"Verification\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:44;a:16:{s:4:\"tmpl\";i:1327;s:2:\"id\";i:22822;s:5:\"title\";s:36:\"Fly-In | Subscription | Nutritionist\";s:9:\"thumbnail\";s:82:\"https://library.elementor.com/wp-content/uploads/2022/03/nutritionist-69-small.jpg\";s:12:\"tmpl_created\";i:1647762620;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:138:\"https://library.elementor.com/popups/fly-in-subscription-nutritionist/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:6:\"fly-in\";s:4:\"tags\";s:28:\"[\"Food\",\"Health\",\"Services\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:45;a:16:{s:4:\"tmpl\";i:1328;s:2:\"id\";i:22833;s:5:\"title\";s:40:\"Classic | Subscription | App &#038; SaaS\";s:9:\"thumbnail\";s:73:\"https://library.elementor.com/wp-content/uploads/2022/03/app-70-small.jpg\";s:12:\"tmpl_created\";i:1647762955;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:135:\"https://library.elementor.com/popups/classic-subscription-app-saas/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:14:\"[\"App\",\"SaaS\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:46;a:16:{s:4:\"tmpl\";i:1329;s:2:\"id\";i:22844;s:5:\"title\";s:41:\"Bottom Bar | Discount | Handmade Cupcakes\";s:9:\"thumbnail\";s:90:\"https://library.elementor.com/wp-content/uploads/2022/03/72-Handmade-Cupcakes-Discount.jpg\";s:12:\"tmpl_created\";i:1647763350;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:143:\"https://library.elementor.com/popups/bottom-bar-discount-handmade-cupcakes/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:10:\"bottom bar\";s:4:\"tags\";s:21:\"[\"Food\",\"Restaurant\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:47;a:16:{s:4:\"tmpl\";i:1330;s:2:\"id\";i:22855;s:5:\"title\";s:40:\"Bottom Bar | Subscription | Fashion Blog\";s:9:\"thumbnail\";s:82:\"https://library.elementor.com/wp-content/uploads/2022/03/fashion-blog-75-small.jpg\";s:12:\"tmpl_created\";i:1647763907;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:142:\"https://library.elementor.com/popups/bottom-bar-subscription-fashion-blog/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:10:\"bottom bar\";s:4:\"tags\";s:30:\"[\"Blog\",\"Fashion\",\"Subscribe\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:48;a:16:{s:4:\"tmpl\";i:1331;s:2:\"id\";i:22866;s:5:\"title\";s:28:\"Fly-In | CTA | Private Tutor\";s:9:\"thumbnail\";s:83:\"https://library.elementor.com/wp-content/uploads/2022/03/private-tutor-77-small.jpg\";s:12:\"tmpl_created\";i:1647764062;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:130:\"https://library.elementor.com/popups/fly-in-cta-private-tutor/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:6:\"fly-in\";s:4:\"tags\";s:7:\"[\"cta\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:49;a:16:{s:4:\"tmpl\";i:1332;s:2:\"id\";i:22876;s:5:\"title\";s:30:\"Classic | CTA | Tennis Academy\";s:9:\"thumbnail\";s:92:\"https://library.elementor.com/wp-content/uploads/2022/03/78-Tennis-Academy-Click-Through.jpg\";s:12:\"tmpl_created\";i:1647765192;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:132:\"https://library.elementor.com/popups/classic-cta-tennis-academy/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:7:\"[\"cta\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:50;a:16:{s:4:\"tmpl\";i:1333;s:2:\"id\";i:22887;s:5:\"title\";s:31:\"Fly-In | CTA | Shared Workspace\";s:9:\"thumbnail\";s:86:\"https://library.elementor.com/wp-content/uploads/2022/03/shared-workspace-79-small.jpg\";s:12:\"tmpl_created\";i:1647765419;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:133:\"https://library.elementor.com/popups/fly-in-cta-shared-workspace/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:6:\"fly-in\";s:4:\"tags\";s:18:\"[\"Business\",\"cta\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:51;a:16:{s:4:\"tmpl\";i:1334;s:2:\"id\";i:22899;s:5:\"title\";s:30:\"Bottom Bar | CTA | Art Gallery\";s:9:\"thumbnail\";s:89:\"https://library.elementor.com/wp-content/uploads/2022/03/80-Art-Gallery-Click-Through.jpg\";s:12:\"tmpl_created\";i:1647765652;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:132:\"https://library.elementor.com/popups/bottom-bar-cta-art-gallery/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:10:\"bottom bar\";s:4:\"tags\";s:13:\"[\"Art\",\"cta\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:52;a:16:{s:4:\"tmpl\";i:1335;s:2:\"id\";i:22910;s:5:\"title\";s:44:\"Fly-In | Subscription | Hiking Tours Company\";s:9:\"thumbnail\";s:90:\"https://library.elementor.com/wp-content/uploads/2022/03/hiking-tours-company-81-small.jpg\";s:12:\"tmpl_created\";i:1647765835;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:146:\"https://library.elementor.com/popups/fly-in-subscription-hiking-tours-company/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:6:\"fly-in\";s:4:\"tags\";s:29:\"[\"Subscribe\",\"Travel\",\"Trip\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:53;a:16:{s:4:\"tmpl\";i:1336;s:2:\"id\";i:22921;s:5:\"title\";s:26:\"Classic | CTA | Music Band\";s:9:\"thumbnail\";s:80:\"https://library.elementor.com/wp-content/uploads/2022/03/music-band-82-small.jpg\";s:12:\"tmpl_created\";i:1647769462;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:128:\"https://library.elementor.com/popups/classic-cta-music-band/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:21:\"[\"Marketing\",\"Music\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:54;a:16:{s:4:\"tmpl\";i:1337;s:2:\"id\";i:22935;s:5:\"title\";s:35:\"Classic | CTA | Computer Technician\";s:9:\"thumbnail\";s:88:\"https://library.elementor.com/wp-content/uploads/2022/03/comuter-technician-83-small.jpg\";s:12:\"tmpl_created\";i:1647769843;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:137:\"https://library.elementor.com/popups/classic-cta-computer-technician/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:18:\"[\"cta\",\"Services\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:55;a:16:{s:4:\"tmpl\";i:1338;s:2:\"id\";i:22945;s:5:\"title\";s:37:\"Classic | Discount | Delivery Company\";s:9:\"thumbnail\";s:86:\"https://library.elementor.com/wp-content/uploads/2022/03/delivery-company-88-small.jpg\";s:12:\"tmpl_created\";i:1647770834;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:139:\"https://library.elementor.com/popups/classic-discount-delivery-company/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:23:\"[\"Discount\",\"Services\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:56;a:16:{s:4:\"tmpl\";i:1339;s:2:\"id\";i:22959;s:5:\"title\";s:29:\"Classic | Discount | Eco Shop\";s:9:\"thumbnail\";s:79:\"https://library.elementor.com/wp-content/uploads/2022/03/echo-shop-89-small.jpg\";s:12:\"tmpl_created\";i:1647771211;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:131:\"https://library.elementor.com/popups/classic-discount-eco-shop/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:24:\"[\"Discount\",\"Ecommerce\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:57;a:16:{s:4:\"tmpl\";i:1340;s:2:\"id\";i:22972;s:5:\"title\";s:54:\"Fly-In | Subscription | Health &#038; Mindfulness Blog\";s:9:\"thumbnail\";s:81:\"https://library.elementor.com/wp-content/uploads/2022/03/health-blog-91-small.jpg\";s:12:\"tmpl_created\";i:1647771461;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:149:\"https://library.elementor.com/popups/fly-in-subscription-health-mindfulness-blog/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:6:\"fly-in\";s:4:\"tags\";s:21:\"[\"Health\",\"Magazine\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:58;a:16:{s:4:\"tmpl\";i:1341;s:2:\"id\";i:22982;s:5:\"title\";s:31:\"Full Screen | Menu | Art Museum\";s:9:\"thumbnail\";s:81:\"https://library.elementor.com/wp-content/uploads/2022/03/art-museum-112-small.jpg\";s:12:\"tmpl_created\";i:1647771938;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:133:\"https://library.elementor.com/popups/full-screen-menu-art-museum/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:11:\"full screen\";s:4:\"tags\";s:21:\"[\"Fullscreen\",\"menu\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:59;a:16:{s:4:\"tmpl\";i:1342;s:2:\"id\";i:22992;s:5:\"title\";s:40:\"Classic | Discount | Urban Clothing Shop\";s:9:\"thumbnail\";s:83:\"https://library.elementor.com/wp-content/uploads/2022/03/health-blog-91-small-1.jpg\";s:12:\"tmpl_created\";i:1647773067;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:142:\"https://library.elementor.com/popups/classic-discount-urban-clothing-shop/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:34:\"[\"Discount\",\"Ecommerce\",\"Fashion\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:60;a:16:{s:4:\"tmpl\";i:1343;s:2:\"id\";i:23004;s:5:\"title\";s:60:\"Full Screen | Menu | Digital &#038; Technology Design School\";s:9:\"thumbnail\";s:95:\"https://library.elementor.com/wp-content/uploads/2022/03/digital-design-tech-school-small-1.jpg\";s:12:\"tmpl_created\";i:1647773366;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:155:\"https://library.elementor.com/popups/full-screen-menu-digital-technology-design-school/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:11:\"full screen\";s:4:\"tags\";s:8:\"[\"menu\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:61;a:16:{s:4:\"tmpl\";i:1344;s:2:\"id\";i:23015;s:5:\"title\";s:62:\"Bottom Bar | Contact | Digital &#038; Technology Design School\";s:9:\"thumbnail\";s:93:\"https://library.elementor.com/wp-content/uploads/2022/03/digital-design-tech-school-small.jpg\";s:12:\"tmpl_created\";i:1647773492;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:157:\"https://library.elementor.com/popups/bottom-bar-contact-digital-technology-design-school/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:10:\"bottom bar\";s:4:\"tags\";s:23:\"[\"Contact\",\"Portfolio\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:62;a:16:{s:4:\"tmpl\";i:1345;s:2:\"id\";i:23025;s:5:\"title\";s:32:\"Full Screen | Menu | Flower Shop\";s:9:\"thumbnail\";s:78:\"https://library.elementor.com/wp-content/uploads/2022/03/flower-shop-small.jpg\";s:12:\"tmpl_created\";i:1647773820;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:134:\"https://library.elementor.com/popups/full-screen-menu-flower-shop/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:11:\"full screen\";s:4:\"tags\";s:21:\"[\"Fullscreen\",\"menu\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:63;a:16:{s:4:\"tmpl\";i:1346;s:2:\"id\";i:23037;s:5:\"title\";s:36:\"Classic | Subscription | Flower Shop\";s:9:\"thumbnail\";s:80:\"https://library.elementor.com/wp-content/uploads/2022/03/flower-shop-small-1.jpg\";s:12:\"tmpl_created\";i:1647773949;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:138:\"https://library.elementor.com/popups/classic-subscription-flower-shop/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:24:\"[\"Discount\",\"Subscribe\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:64;a:16:{s:4:\"tmpl\";i:1347;s:2:\"id\";i:23056;s:5:\"title\";s:48:\"Classic | Discount | Health &#038; Fitness eBook\";s:9:\"thumbnail\";s:82:\"https://library.elementor.com/wp-content/uploads/2022/03/fitness-ebook-small-1.jpg\";s:12:\"tmpl_created\";i:1647774468;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:143:\"https://library.elementor.com/popups/classic-discount-health-fitness-ebook/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:23:\"[\"Contact\",\"Marketing\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:65;a:16:{s:4:\"tmpl\";i:1348;s:2:\"id\";i:23067;s:5:\"title\";s:37:\"Fly-In | Menu | Baby Sleep Consultant\";s:9:\"thumbnail\";s:90:\"https://library.elementor.com/wp-content/uploads/2022/03/baby-sleep-consultant-small-1.jpg\";s:12:\"tmpl_created\";i:1647778954;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:127:\"https://library.elementor.com/popups/baby-sleep-consultant/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:6:\"fly-in\";s:4:\"tags\";s:8:\"[\"menu\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:66;a:16:{s:4:\"tmpl\";i:1349;s:2:\"id\";i:23077;s:5:\"title\";s:46:\"Classic | Subscription | Baby Sleep Consultant\";s:9:\"thumbnail\";s:88:\"https://library.elementor.com/wp-content/uploads/2022/03/baby-sleep-consultant-small.jpg\";s:12:\"tmpl_created\";i:1647779074;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:148:\"https://library.elementor.com/popups/classic-subscription-baby-sleep-consultant/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:12:\"[\"Discount\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:67;a:16:{s:4:\"tmpl\";i:1350;s:2:\"id\";i:23090;s:5:\"title\";s:33:\"Full Screen | Menu | Luxury Hotel\";s:9:\"thumbnail\";s:79:\"https://library.elementor.com/wp-content/uploads/2022/03/luxury-hotel-small.jpg\";s:12:\"tmpl_created\";i:1647779390;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:135:\"https://library.elementor.com/popups/full-screen-menu-luxury-hotel/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:11:\"full screen\";s:4:\"tags\";s:21:\"[\"Fullscreen\",\"menu\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:68;a:16:{s:4:\"tmpl\";i:1351;s:2:\"id\";i:23100;s:5:\"title\";s:31:\"Fly-In | Booking | Luxury Hotel\";s:9:\"thumbnail\";s:81:\"https://library.elementor.com/wp-content/uploads/2022/03/luxury-hotel-small-1.jpg\";s:12:\"tmpl_created\";i:1647779500;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:133:\"https://library.elementor.com/popups/fly-in-booking-luxury-hotel/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:6:\"fly-in\";s:4:\"tags\";s:20:\"[\"Booking\",\"Travel\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:69;a:16:{s:4:\"tmpl\";i:1352;s:2:\"id\";i:23109;s:5:\"title\";s:38:\"Full Screen | Menu | Design Conference\";s:9:\"thumbnail\";s:87:\"https://library.elementor.com/wp-content/uploads/2022/03/design-conference-35-small.jpg\";s:12:\"tmpl_created\";i:1647779675;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:140:\"https://library.elementor.com/popups/full-screen-menu-design-conference/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:11:\"full screen\";s:4:\"tags\";s:21:\"[\"Fullscreen\",\"menu\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:70;a:16:{s:4:\"tmpl\";i:1353;s:2:\"id\";i:23120;s:5:\"title\";s:41:\"Full Screen | Booking | Design Conference\";s:9:\"thumbnail\";s:89:\"https://library.elementor.com/wp-content/uploads/2022/03/design-conference-35-small-1.jpg\";s:12:\"tmpl_created\";i:1647779793;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:143:\"https://library.elementor.com/popups/full-screen-booking-design-conference/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:11:\"full screen\";s:4:\"tags\";s:35:\"[\"Booking\",\"Conference\",\"Creative\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:71;a:16:{s:4:\"tmpl\";i:1354;s:2:\"id\";i:23129;s:5:\"title\";s:29:\"Slide-In | Menu | VR Headsets\";s:9:\"thumbnail\";s:77:\"https://library.elementor.com/wp-content/uploads/2022/03/VR-headset-small.jpg\";s:12:\"tmpl_created\";i:1647781211;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:131:\"https://library.elementor.com/popups/slide-in-menu-vr-headsets/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:8:\"slide-in\";s:4:\"tags\";s:8:\"[\"menu\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:72;a:16:{s:4:\"tmpl\";i:1355;s:2:\"id\";i:23139;s:5:\"title\";s:31:\"Classic | Contact | VR Headsets\";s:9:\"thumbnail\";s:79:\"https://library.elementor.com/wp-content/uploads/2022/03/VR-headset-small-1.jpg\";s:12:\"tmpl_created\";i:1647781384;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:133:\"https://library.elementor.com/popups/classic-contact-vr-headsets/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:11:\"[\"Contact\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:73;a:16:{s:4:\"tmpl\";i:1356;s:2:\"id\";i:23149;s:5:\"title\";s:38:\"Slide-In | Menu | Portrait Photography\";s:9:\"thumbnail\";s:89:\"https://library.elementor.com/wp-content/uploads/2022/03/48-portrair-photography-Menu.jpg\";s:12:\"tmpl_created\";i:1647782336;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:140:\"https://library.elementor.com/popups/slide-in-menu-portrait-photography/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:8:\"slide-in\";s:4:\"tags\";s:8:\"[\"menu\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:74;a:16:{s:4:\"tmpl\";i:1357;s:2:\"id\";i:23159;s:5:\"title\";s:47:\"Hello Bar | Subscription | Portrait Photography\";s:9:\"thumbnail\";s:97:\"https://library.elementor.com/wp-content/uploads/2022/03/48-portrair-photography-Subscription.jpg\";s:12:\"tmpl_created\";i:1647782478;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:149:\"https://library.elementor.com/popups/hello-bar-subscription-portrait-photography/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:9:\"hello bar\";s:4:\"tags\";s:34:\"[\"Blog\",\"Photography\",\"Subscribe\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:75;a:16:{s:4:\"tmpl\";i:1358;s:2:\"id\";i:23169;s:5:\"title\";s:32:\"Full Screen | Menu | English Pub\";s:9:\"thumbnail\";s:80:\"https://library.elementor.com/wp-content/uploads/2022/03/49-englisg-pub-Menu.jpg\";s:12:\"tmpl_created\";i:1647782664;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:134:\"https://library.elementor.com/popups/full-screen-menu-english-pub/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:11:\"full screen\";s:4:\"tags\";s:21:\"[\"Fullscreen\",\"menu\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:76;a:16:{s:4:\"tmpl\";i:1359;s:2:\"id\";i:23179;s:5:\"title\";s:32:\"Classic | Discount | English Pub\";s:9:\"thumbnail\";s:84:\"https://library.elementor.com/wp-content/uploads/2022/03/49-englisg-pub-Discount.jpg\";s:12:\"tmpl_created\";i:1647782796;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:134:\"https://library.elementor.com/popups/classic-discount-english-pub/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:20:\"[\"Discount\",\"Offer\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:77;a:16:{s:4:\"tmpl\";i:1360;s:2:\"id\";i:23189;s:5:\"title\";s:27:\"Full Screen | Menu | Singer\";s:9:\"thumbnail\";s:81:\"https://library.elementor.com/wp-content/uploads/2022/03/58-Music-Artist-Menu.jpg\";s:12:\"tmpl_created\";i:1647783070;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:129:\"https://library.elementor.com/popups/full-screen-menu-singer/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:11:\"full screen\";s:4:\"tags\";s:29:\"[\"Fullscreen\",\"menu\",\"Music\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:78;a:16:{s:4:\"tmpl\";i:1361;s:2:\"id\";i:23200;s:5:\"title\";s:31:\"Classic | Subscription | Singer\";s:9:\"thumbnail\";s:89:\"https://library.elementor.com/wp-content/uploads/2022/03/58-Music-Artist-Subscription.jpg\";s:12:\"tmpl_created\";i:1647783249;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:133:\"https://library.elementor.com/popups/classic-subscription-singer/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:21:\"[\"Music\",\"Subscribe\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:79;a:16:{s:4:\"tmpl\";i:1362;s:2:\"id\";i:23210;s:5:\"title\";s:38:\"Full Screen | Menu | Virtual Assistant\";s:9:\"thumbnail\";s:86:\"https://library.elementor.com/wp-content/uploads/2022/03/virtual-assistnt-73-small.jpg\";s:12:\"tmpl_created\";i:1647784292;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:140:\"https://library.elementor.com/popups/full-screen-menu-virtual-assistant/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:11:\"full screen\";s:4:\"tags\";s:21:\"[\"Fullscreen\",\"menu\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:80;a:16:{s:4:\"tmpl\";i:1363;s:2:\"id\";i:23223;s:5:\"title\";s:39:\"Hello Bar | Contact | Virtual Assistant\";s:9:\"thumbnail\";s:92:\"https://library.elementor.com/wp-content/uploads/2022/03/73-Virtual-Assistant-Contact-Us.jpg\";s:12:\"tmpl_created\";i:1647784616;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:141:\"https://library.elementor.com/popups/hello-bar-contact-virtual-assistant/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:9:\"hello bar\";s:4:\"tags\";s:37:\"[\"Contact\",\"Psychologist\",\"Services\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:81;a:16:{s:4:\"tmpl\";i:1364;s:2:\"id\";i:23234;s:5:\"title\";s:32:\"Slide-In  | Menu | Personal Chef\";s:9:\"thumbnail\";s:82:\"https://library.elementor.com/wp-content/uploads/2022/03/74-Personal-Chef-Menu.jpg\";s:12:\"tmpl_created\";i:1647798194;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:133:\"https://library.elementor.com/popups/slide-in-menu-personal-chef/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:8:\"slide-in\";s:4:\"tags\";s:8:\"[\"menu\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:82;a:16:{s:4:\"tmpl\";i:1365;s:2:\"id\";i:23244;s:5:\"title\";s:29:\"Classic | CTA | Personal Chef\";s:9:\"thumbnail\";s:88:\"https://library.elementor.com/wp-content/uploads/2022/03/74-Personal-Chef-Contact-Us.jpg\";s:12:\"tmpl_created\";i:1647798297;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:131:\"https://library.elementor.com/popups/classic-cta-personal-chef/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:24:\"[\"Booking\",\"Chef\",\"cta\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:83;a:16:{s:4:\"tmpl\";i:1366;s:2:\"id\";i:23254;s:5:\"title\";s:31:\"Full Screen | Menu | Food Truck\";s:9:\"thumbnail\";s:82:\"https://library.elementor.com/wp-content/uploads/2022/03/food-truck-76-small-1.jpg\";s:12:\"tmpl_created\";i:1647798447;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:133:\"https://library.elementor.com/popups/full-screen-menu-food-truck/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:11:\"full screen\";s:4:\"tags\";s:21:\"[\"Fullscreen\",\"menu\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:84;a:16:{s:4:\"tmpl\";i:1367;s:2:\"id\";i:23265;s:5:\"title\";s:30:\"Fly-In | Discount | Food Truck\";s:9:\"thumbnail\";s:80:\"https://library.elementor.com/wp-content/uploads/2022/03/food-truck-76-small.jpg\";s:12:\"tmpl_created\";i:1647798657;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:132:\"https://library.elementor.com/popups/fly-in-discount-food-truck/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:6:\"fly-in\";s:4:\"tags\";s:20:\"[\"Discount\",\"Offer\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:85;a:16:{s:4:\"tmpl\";i:1369;s:2:\"id\";i:23323;s:5:\"title\";s:28:\"Classic | CTA | Black Friday\";s:9:\"thumbnail\";s:81:\"https://library.elementor.com/wp-content/uploads/2022/03/Black-Friday-6-Small.jpg\";s:12:\"tmpl_created\";i:1647855505;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:130:\"https://library.elementor.com/popups/classic-cta-black-friday/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:34:\"[\"Black Friday\",\"cta\",\"Ecommerce\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:86;a:16:{s:4:\"tmpl\";i:1370;s:2:\"id\";i:23329;s:5:\"title\";s:29:\"Slide-In | CTA | Black Friday\";s:9:\"thumbnail\";s:81:\"https://library.elementor.com/wp-content/uploads/2022/03/Black-Friday-5-Small.jpg\";s:12:\"tmpl_created\";i:1647855865;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:131:\"https://library.elementor.com/popups/slide-in-cta-black-friday/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:8:\"slide-in\";s:4:\"tags\";s:34:\"[\"Black Friday\",\"cta\",\"Ecommerce\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:87;a:16:{s:4:\"tmpl\";i:1371;s:2:\"id\";i:23335;s:5:\"title\";s:31:\"Slide-In | CTA | Black Friday 1\";s:9:\"thumbnail\";s:81:\"https://library.elementor.com/wp-content/uploads/2022/03/Black-Friday-1-Small.jpg\";s:12:\"tmpl_created\";i:1647856357;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:133:\"https://library.elementor.com/popups/slide-in-cta-black-friday-1/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:8:\"slide-in\";s:4:\"tags\";s:34:\"[\"Black Friday\",\"cta\",\"Ecommerce\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:88;a:16:{s:4:\"tmpl\";i:1372;s:2:\"id\";i:23341;s:5:\"title\";s:30:\"Classic | CTA | Black Friday 2\";s:9:\"thumbnail\";s:81:\"https://library.elementor.com/wp-content/uploads/2022/03/Black-Friday-3-Small.jpg\";s:12:\"tmpl_created\";i:1647856493;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:132:\"https://library.elementor.com/popups/classic-cta-black-friday-2/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:34:\"[\"Black Friday\",\"cta\",\"Ecommerce\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:89;a:16:{s:4:\"tmpl\";i:1373;s:2:\"id\";i:23347;s:5:\"title\";s:30:\"Classic | CTA | Black Friday 3\";s:9:\"thumbnail\";s:81:\"https://library.elementor.com/wp-content/uploads/2022/03/Black-Friday-2-Small.jpg\";s:12:\"tmpl_created\";i:1647856891;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:132:\"https://library.elementor.com/popups/classic-cta-black-friday-3/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:34:\"[\"Black Friday\",\"cta\",\"Ecommerce\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:90;a:16:{s:4:\"tmpl\";i:1374;s:2:\"id\";i:23354;s:5:\"title\";s:30:\"Classic | CTA | Black Friday 4\";s:9:\"thumbnail\";s:81:\"https://library.elementor.com/wp-content/uploads/2022/03/Black-Friday-4-Small.jpg\";s:12:\"tmpl_created\";i:1647856996;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:132:\"https://library.elementor.com/popups/classic-cta-black-friday-4/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:34:\"[\"Black Friday\",\"cta\",\"Ecommerce\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:91;a:16:{s:4:\"tmpl\";i:1375;s:2:\"id\";i:23394;s:5:\"title\";s:27:\"Classic | CTA | Halloween 1\";s:9:\"thumbnail\";s:78:\"https://library.elementor.com/wp-content/uploads/2022/03/Halloween-3-Small.jpg\";s:12:\"tmpl_created\";i:1647857351;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:129:\"https://library.elementor.com/popups/classic-cta-halloween-1/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:31:\"[\"cta\",\"Ecommerce\",\"Halloween\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:92;a:16:{s:4:\"tmpl\";i:1376;s:2:\"id\";i:23401;s:5:\"title\";s:33:\"Slide-In | Discount | Halloween 2\";s:9:\"thumbnail\";s:78:\"https://library.elementor.com/wp-content/uploads/2022/03/Halloween-2-Small.jpg\";s:12:\"tmpl_created\";i:1647857567;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:135:\"https://library.elementor.com/popups/slide-in-discount-halloween-2/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:8:\"slide-in\";s:4:\"tags\";s:36:\"[\"Discount\",\"Ecommerce\",\"Halloween\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:93;a:16:{s:4:\"tmpl\";i:1377;s:2:\"id\";i:23407;s:5:\"title\";s:33:\"Slide-In | Discount | Halloween 3\";s:9:\"thumbnail\";s:78:\"https://library.elementor.com/wp-content/uploads/2022/03/Halloween-1-Small.jpg\";s:12:\"tmpl_created\";i:1647857814;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:135:\"https://library.elementor.com/popups/slide-in-discount-halloween-3/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:8:\"slide-in\";s:4:\"tags\";s:36:\"[\"Discount\",\"Ecommerce\",\"Halloween\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:94;a:16:{s:4:\"tmpl\";i:1378;s:2:\"id\";i:23416;s:5:\"title\";s:31:\"Fly-In | Discount | Halloween 4\";s:9:\"thumbnail\";s:78:\"https://library.elementor.com/wp-content/uploads/2022/03/Halloween-5-Small.jpg\";s:12:\"tmpl_created\";i:1647858024;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:133:\"https://library.elementor.com/popups/fly-in-discount-halloween-4/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:6:\"fly-in\";s:4:\"tags\";s:44:\"[\"Discount\",\"Ecommerce\",\"Halloween\",\"Offer\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:95;a:16:{s:4:\"tmpl\";i:1379;s:2:\"id\";i:23422;s:5:\"title\";s:36:\"Classic | Subscription | Halloween 5\";s:9:\"thumbnail\";s:78:\"https://library.elementor.com/wp-content/uploads/2022/03/Halloween-4-Small.jpg\";s:12:\"tmpl_created\";i:1647858246;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:138:\"https://library.elementor.com/popups/classic-subscription-halloween-5/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:48:\"[\"Discount\",\"Ecommerce\",\"Halloween\",\"Subscribe\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:96;a:16:{s:4:\"tmpl\";i:1380;s:2:\"id\";i:23471;s:5:\"title\";s:28:\"Slide-In | CTA | Christmas 1\";s:9:\"thumbnail\";s:78:\"https://library.elementor.com/wp-content/uploads/2022/03/Christmas-2-Small.jpg\";s:12:\"tmpl_created\";i:1647859193;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:130:\"https://library.elementor.com/popups/slide-in-cta-christmas-1/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:8:\"slide-in\";s:4:\"tags\";s:19:\"[\"Christmas\",\"cta\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:97;a:16:{s:4:\"tmpl\";i:1381;s:2:\"id\";i:23477;s:5:\"title\";s:28:\"Slide-In | CTA | Christmas 2\";s:9:\"thumbnail\";s:78:\"https://library.elementor.com/wp-content/uploads/2022/03/Christmas-4-Small.jpg\";s:12:\"tmpl_created\";i:1647859838;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:130:\"https://library.elementor.com/popups/slide-in-cta-christmas-2/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:8:\"slide-in\";s:4:\"tags\";s:19:\"[\"Christmas\",\"cta\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:98;a:16:{s:4:\"tmpl\";i:1382;s:2:\"id\";i:23483;s:5:\"title\";s:26:\"Fly-In | CTA | Christmas 3\";s:9:\"thumbnail\";s:78:\"https://library.elementor.com/wp-content/uploads/2022/03/Christmas-1-Small.jpg\";s:12:\"tmpl_created\";i:1647860157;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:128:\"https://library.elementor.com/popups/fly-in-cta-christmas-3/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:6:\"fly-in\";s:4:\"tags\";s:31:\"[\"Christmas\",\"cta\",\"Ecommerce\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:99;a:16:{s:4:\"tmpl\";i:1383;s:2:\"id\";i:23489;s:5:\"title\";s:33:\"Slide-In | Discount | Christmas 4\";s:9:\"thumbnail\";s:78:\"https://library.elementor.com/wp-content/uploads/2022/03/Christmas-5-Small.jpg\";s:12:\"tmpl_created\";i:1647860302;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:135:\"https://library.elementor.com/popups/slide-in-discount-christmas-4/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:8:\"slide-in\";s:4:\"tags\";s:31:\"[\"Christmas\",\"cta\",\"Ecommerce\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:100;a:16:{s:4:\"tmpl\";i:1384;s:2:\"id\";i:23496;s:5:\"title\";s:32:\"Classic | Discount | Christmas 5\";s:9:\"thumbnail\";s:78:\"https://library.elementor.com/wp-content/uploads/2022/03/Christmas-3-Small.jpg\";s:12:\"tmpl_created\";i:1647860454;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:134:\"https://library.elementor.com/popups/classic-discount-christmas-5/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:29:\"[\"Christmas\",\"Offer\",\"Sales\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:101;a:16:{s:4:\"tmpl\";i:1385;s:2:\"id\";i:23523;s:5:\"title\";s:30:\"Classic | CTA | Valentines Day\";s:9:\"thumbnail\";s:83:\"https://library.elementor.com/wp-content/uploads/2022/03/Valentines-Day-2-Small.jpg\";s:12:\"tmpl_created\";i:1647860912;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:132:\"https://library.elementor.com/popups/classic-cta-valentines-day/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:25:\"[\"cta\",\"Valentine\'s Day\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:102;a:16:{s:4:\"tmpl\";i:1386;s:2:\"id\";i:23529;s:5:\"title\";s:39:\"Hello Bar | Discount | Valentines Day 2\";s:9:\"thumbnail\";s:83:\"https://library.elementor.com/wp-content/uploads/2022/03/Valentines-Day-1-Small.jpg\";s:12:\"tmpl_created\";i:1647861064;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:141:\"https://library.elementor.com/popups/hello-bar-discount-valentines-day-2/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:9:\"hello bar\";s:4:\"tags\";s:30:\"[\"Discount\",\"Valentine\'s Day\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:103;a:16:{s:4:\"tmpl\";i:1387;s:2:\"id\";i:23536;s:5:\"title\";s:32:\"Classic | CTA | Valentines Day 3\";s:9:\"thumbnail\";s:83:\"https://library.elementor.com/wp-content/uploads/2022/03/Valentines-Day-3-Small.jpg\";s:12:\"tmpl_created\";i:1647861536;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:134:\"https://library.elementor.com/popups/classic-cta-valentines-day-3/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:25:\"[\"cta\",\"Valentine\'s Day\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:104;a:16:{s:4:\"tmpl\";i:1388;s:2:\"id\";i:23586;s:5:\"title\";s:51:\"Fly-In | Subscribe | Health &#038; Wellness Company\";s:9:\"thumbnail\";s:103:\"https://library.elementor.com/wp-content/uploads/2022/03/35-Subscribe-Health-Wellness-Company-Small.jpg\";s:12:\"tmpl_created\";i:1647862008;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:146:\"https://library.elementor.com/popups/fly-in-subscribe-health-wellness-company/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:24:\"[\"Business\",\"Subscribe\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:105;a:16:{s:4:\"tmpl\";i:1389;s:2:\"id\";i:23592;s:5:\"title\";s:34:\"Classic | Subscribe | Tech Company\";s:9:\"thumbnail\";s:92:\"https://library.elementor.com/wp-content/uploads/2022/03/36-Subscribe-Tech-Company-Small.jpg\";s:12:\"tmpl_created\";i:1647866706;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:136:\"https://library.elementor.com/popups/classic-subscribe-tech-company/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:25:\"[\"Marketing\",\"Subscribe\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:106;a:16:{s:4:\"tmpl\";i:1390;s:2:\"id\";i:23598;s:5:\"title\";s:36:\"Classic | Contact Us | Fight Classes\";s:9:\"thumbnail\";s:94:\"https://library.elementor.com/wp-content/uploads/2022/03/37-Contact-Us-Fight-Classes-Small.jpg\";s:12:\"tmpl_created\";i:1647866869;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:138:\"https://library.elementor.com/popups/classic-contact-us-fight-classes/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:23:\"[\"Contact\",\"Marketing\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:107;a:16:{s:4:\"tmpl\";i:1391;s:2:\"id\";i:23611;s:5:\"title\";s:31:\"Classic | CTA | Mochi Shop Sale\";s:9:\"thumbnail\";s:99:\"https://library.elementor.com/wp-content/uploads/2022/03/39-Click-Through-Mochi-Shop-Sale-Small.jpg\";s:12:\"tmpl_created\";i:1647867750;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:133:\"https://library.elementor.com/popups/classic-cta-mochi-shop-sale/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:23:\"[\"cta\",\"Offer\",\"Sales\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:108;a:16:{s:4:\"tmpl\";i:1392;s:2:\"id\";i:23618;s:5:\"title\";s:28:\"Classic | CTA | Fashion Shop\";s:9:\"thumbnail\";s:96:\"https://library.elementor.com/wp-content/uploads/2022/03/40-Click-Through-Fashion-Shop-Small.jpg\";s:12:\"tmpl_created\";i:1647868251;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:130:\"https://library.elementor.com/popups/classic-cta-fashion-shop/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:19:\"[\"cta\",\"Ecommerce\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:109;a:16:{s:4:\"tmpl\";i:1393;s:2:\"id\";i:23624;s:5:\"title\";s:29:\"Fly-In | Login | Tech Company\";s:9:\"thumbnail\";s:88:\"https://library.elementor.com/wp-content/uploads/2022/03/41-Login-Tech-Company-Small.jpg\";s:12:\"tmpl_created\";i:1647868704;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:131:\"https://library.elementor.com/popups/fly-in-login-tech-company/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:6:\"fly-in\";s:4:\"tags\";s:9:\"[\"Login\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:110;a:16:{s:4:\"tmpl\";i:1394;s:2:\"id\";i:23630;s:5:\"title\";s:36:\"Fly-In | Verification | Liquor Store\";s:9:\"thumbnail\";s:95:\"https://library.elementor.com/wp-content/uploads/2022/03/42-Verification-Liquor-Store-Small.jpg\";s:12:\"tmpl_created\";i:1647870308;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:138:\"https://library.elementor.com/popups/fly-in-verification-liquor-store/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:6:\"fly-in\";s:4:\"tags\";s:16:\"[\"Verification\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:111;a:16:{s:4:\"tmpl\";i:1395;s:2:\"id\";i:23636;s:5:\"title\";s:39:\"Hello Bar | Subscribe | Online Magazine\";s:9:\"thumbnail\";s:95:\"https://library.elementor.com/wp-content/uploads/2022/03/44-Subscribe-Online-Magazine-Small.jpg\";s:12:\"tmpl_created\";i:1647870465;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:141:\"https://library.elementor.com/popups/hello-bar-subscribe-online-magazine/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:9:\"hello bar\";s:4:\"tags\";s:20:\"[\"Blog\",\"Subscribe\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:112;a:16:{s:4:\"tmpl\";i:1396;s:2:\"id\";i:23642;s:5:\"title\";s:27:\"Fly-In | Login | Health Spa\";s:9:\"thumbnail\";s:86:\"https://library.elementor.com/wp-content/uploads/2022/03/43-Login-Health-Spa-Small.jpg\";s:12:\"tmpl_created\";i:1647872427;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:129:\"https://library.elementor.com/popups/fly-in-login-health-spa/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:6:\"fly-in\";s:4:\"tags\";s:20:\"[\"Login\",\"Services\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:113;a:16:{s:4:\"tmpl\";i:1397;s:2:\"id\";i:23648;s:5:\"title\";s:33:\"Fly-In | Verification | Wine Shop\";s:9:\"thumbnail\";s:92:\"https://library.elementor.com/wp-content/uploads/2022/03/45-Verification-Wine-Shop-Small.jpg\";s:12:\"tmpl_created\";i:1647872627;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:135:\"https://library.elementor.com/popups/fly-in-verification-wine-shop/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:6:\"fly-in\";s:4:\"tags\";s:16:\"[\"Verification\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:114;a:16:{s:4:\"tmpl\";i:899;s:2:\"id\";i:11839;s:5:\"title\";s:9:\"Portfolio\";s:9:\"thumbnail\";s:73:\"https://library.elementor.com/wp-content/uploads/2019/09/Header_small.png\";s:12:\"tmpl_created\";i:1569430015;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:108:\"https://library.elementor.com/blocks/portfolio-9/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:6:\"header\";s:4:\"tags\";s:43:\"[\"creative portfolio\",\"header\",\"portfolio\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:189;s:11:\"trend_index\";i:20;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:115;a:16:{s:4:\"tmpl\";i:1421;s:2:\"id\";i:24235;s:5:\"title\";s:24:\"Ladydog Club &#8211; NFT\";s:9:\"thumbnail\";s:73:\"https://library.elementor.com/wp-content/uploads/2022/05/Ladydog_Club.jpg\";s:12:\"tmpl_created\";i:1651525072;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:118:\"https://library.elementor.com/lp/ladydog-club-nft/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:7:\"subtype\";s:3:\"NFT\";s:4:\"tags\";s:100:\"[\"Art\",\"Author\",\"Business\",\"Creative\",\"Design\",\"Gallery\",\"Landing Pages\",\"NFT\",\"Products\",\"Virtual\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:116;a:16:{s:4:\"tmpl\";i:1422;s:2:\"id\";i:24166;s:5:\"title\";s:15:\"Dot &#8211; NFT\";s:9:\"thumbnail\";s:72:\"https://library.elementor.com/wp-content/uploads/2022/05/Dot-250_280.jpg\";s:12:\"tmpl_created\";i:1651525117;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:109:\"https://library.elementor.com/lp/dot-nft/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:7:\"subtype\";s:3:\"NFT\";s:4:\"tags\";s:100:\"[\"Art\",\"Author\",\"Business\",\"Creative\",\"Design\",\"Gallery\",\"Landing Pages\",\"NFT\",\"Products\",\"Virtual\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:117;a:16:{s:4:\"tmpl\";i:1423;s:2:\"id\";i:24191;s:5:\"title\";s:28:\"Cosmic Neighbors &#8211; NFT\";s:9:\"thumbnail\";s:85:\"https://library.elementor.com/wp-content/uploads/2022/05/Cosmic_Neighbors-250_280.jpg\";s:12:\"tmpl_created\";i:1651525124;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:122:\"https://library.elementor.com/lp/cosmic-neighbors-nft/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:7:\"subtype\";s:3:\"NFT\";s:4:\"tags\";s:100:\"[\"Art\",\"Author\",\"Business\",\"Creative\",\"Design\",\"Gallery\",\"Landing Pages\",\"NFT\",\"Products\",\"Virtual\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:118;a:16:{s:4:\"tmpl\";i:1424;s:2:\"id\";i:24255;s:5:\"title\";s:30:\"Happy Food Friends &#8211; NFT\";s:9:\"thumbnail\";s:75:\"https://library.elementor.com/wp-content/uploads/2022/05/Featured_Image.jpg\";s:12:\"tmpl_created\";i:1651525475;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:124:\"https://library.elementor.com/lp/happy-food-friends-nft/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:7:\"subtype\";s:3:\"NFT\";s:4:\"tags\";s:100:\"[\"Art\",\"Author\",\"Business\",\"Creative\",\"Design\",\"Gallery\",\"Landing Pages\",\"NFT\",\"Products\",\"Virtual\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:119;a:16:{s:4:\"tmpl\";i:1443;s:2:\"id\";i:24599;s:5:\"title\";s:27:\"Wireframe &#8211; Courses 1\";s:9:\"thumbnail\";s:84:\"https://library.elementor.com/wp-content/uploads/2022/05/Wireframe-—-Courses-1.jpg\";s:12:\"tmpl_created\";i:1653989626;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:121:\"https://library.elementor.com/lp/wireframe-courses-1/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:7:\"subtype\";s:9:\"Wireframe\";s:4:\"tags\";s:180:\"[\"About\",\"Academy\",\"Booking\",\"Business\",\"Course Online\",\"Features\",\"Footer\",\"Landing Pages\",\"Online Service\",\"Professional\",\"School\",\"Services\",\"Subscribe\",\"Teacher\",\"Testimonial\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:120;a:16:{s:4:\"tmpl\";i:1444;s:2:\"id\";i:24614;s:5:\"title\";s:28:\"Wireframe &#8211; Services 1\";s:9:\"thumbnail\";s:87:\"https://library.elementor.com/wp-content/uploads/2022/05/Wireframe-—-Services-1-2.jpg\";s:12:\"tmpl_created\";i:1653990084;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:122:\"https://library.elementor.com/lp/wireframe-services-1/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:7:\"subtype\";s:9:\"Wireframe\";s:4:\"tags\";s:139:\"[\"About\",\"Business\",\"Contact\",\"Features\",\"Footer\",\"Form\",\"Header\",\"Landing Pages\",\"Online Service\",\"Professional\",\"Services\",\"Testimonial\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:121;a:16:{s:4:\"tmpl\";i:1445;s:2:\"id\";i:24629;s:5:\"title\";s:28:\"Wireframe &#8211; Services 2\";s:9:\"thumbnail\";s:87:\"https://library.elementor.com/wp-content/uploads/2022/05/Wireframe-—-Services-2-2.jpg\";s:12:\"tmpl_created\";i:1653990132;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:122:\"https://library.elementor.com/lp/wireframe-services-2/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:7:\"subtype\";s:9:\"Wireframe\";s:4:\"tags\";s:123:\"[\"About\",\"Business\",\"Contact\",\"Features\",\"Footer\",\"Form\",\"Gallery\",\"Landing Pages\",\"Professional\",\"Services\",\"Testimonial\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:122;a:16:{s:4:\"tmpl\";i:1446;s:2:\"id\";i:24644;s:5:\"title\";s:27:\"Wireframe &#8211; Webinar 1\";s:9:\"thumbnail\";s:84:\"https://library.elementor.com/wp-content/uploads/2022/05/Wireframe-—-Webinar-1.jpg\";s:12:\"tmpl_created\";i:1653990164;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:121:\"https://library.elementor.com/lp/wireframe-webinar-1/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:7:\"subtype\";s:9:\"Wireframe\";s:4:\"tags\";s:177:\"[\"About\",\"Academy\",\"Booking\",\"Conference\",\"Course Online\",\"Education\",\"Features\",\"Footer\",\"Form\",\"Landing Pages\",\"Online Event\",\"Online Service\",\"Subscribe\",\"Virtual\",\"Webinar\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:123;a:16:{s:4:\"tmpl\";i:1447;s:2:\"id\";i:24655;s:5:\"title\";s:28:\"Wireframe &#8211; Services 3\";s:9:\"thumbnail\";s:87:\"https://library.elementor.com/wp-content/uploads/2022/05/Wireframe-—-Services-3-2.jpg\";s:12:\"tmpl_created\";i:1653990198;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:122:\"https://library.elementor.com/lp/wireframe-services-3/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:7:\"subtype\";s:9:\"Wireframe\";s:4:\"tags\";s:143:\"[\"About\",\"Agency\",\"Business\",\"Contact\",\"Footer\",\"Form\",\"Gallery\",\"Landing Pages\",\"Portfolio\",\"Professional\",\"Project\",\"Services\",\"Testimonial\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:124;a:16:{s:4:\"tmpl\";i:1448;s:2:\"id\";i:24677;s:5:\"title\";s:28:\"Wireframe &#8211; Services 4\";s:9:\"thumbnail\";s:85:\"https://library.elementor.com/wp-content/uploads/2022/05/Wireframe-—-Services-4.jpg\";s:12:\"tmpl_created\";i:1653990233;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:122:\"https://library.elementor.com/lp/wireframe-services-4/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:7:\"subtype\";s:9:\"Wireframe\";s:4:\"tags\";s:102:\"[\"About\",\"Business\",\"Contact\",\"Footer\",\"Form\",\"Landing Pages\",\"Professional\",\"Services\",\"Testimonial\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:125;a:16:{s:4:\"tmpl\";i:1449;s:2:\"id\";i:24687;s:5:\"title\";s:28:\"Wireframe &#8211; Products 1\";s:9:\"thumbnail\";s:85:\"https://library.elementor.com/wp-content/uploads/2022/05/Wireframe-—-Products-1.jpg\";s:12:\"tmpl_created\";i:1653990273;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:122:\"https://library.elementor.com/lp/wireframe-products-1/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:7:\"subtype\";s:9:\"Wireframe\";s:4:\"tags\";s:128:\"[\"About\",\"Booking\",\"Business\",\"Clients\",\"Ecommerce\",\"Features\",\"Footer\",\"Landing Pages\",\"Products\",\"Sales\",\"Shop\",\"Testimonial\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:126;a:16:{s:4:\"tmpl\";i:1450;s:2:\"id\";i:24706;s:5:\"title\";s:28:\"Wireframe &#8211; Services 5\";s:9:\"thumbnail\";s:85:\"https://library.elementor.com/wp-content/uploads/2022/05/Wireframe-—-Services-5.jpg\";s:12:\"tmpl_created\";i:1653990322;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:122:\"https://library.elementor.com/lp/wireframe-services-5/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:7:\"subtype\";s:9:\"Wireframe\";s:4:\"tags\";s:149:\"[\"About\",\"Booking\",\"Consulting\",\"Contact\",\"Doctor\",\"Footer\",\"Form\",\"Header\",\"Landing Pages\",\"Online Service\",\"Professional\",\"Services\",\"Testimonial\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:127;a:16:{s:4:\"tmpl\";i:1451;s:2:\"id\";i:23604;s:5:\"title\";s:38:\"Classic | Subscribe | Nail Polish Shop\";s:9:\"thumbnail\";s:96:\"https://library.elementor.com/wp-content/uploads/2022/03/38-Subscribe-Nail-Polish-Shop-Small.jpg\";s:12:\"tmpl_created\";i:1660205114;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:140:\"https://library.elementor.com/popups/classic-subscribe-nail-polish-shop/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:20:\"[\"Blog\",\"Subscribe\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:128;a:16:{s:4:\"tmpl\";i:1452;s:2:\"id\";i:23047;s:5:\"title\";s:46:\"Fly-In | Contact | Health &#038; Fitness eBook\";s:9:\"thumbnail\";s:80:\"https://library.elementor.com/wp-content/uploads/2022/03/fitness-ebook-small.jpg\";s:12:\"tmpl_created\";i:1660205149;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:141:\"https://library.elementor.com/popups/fly-in-contact-health-fitness-ebook/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:6:\"fly-in\";s:4:\"tags\";s:28:\"[\"Contact\",\"Ebook\",\"Health\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:129;a:16:{s:4:\"tmpl\";i:1199;s:2:\"id\";i:18839;s:5:\"title\";s:27:\"Hello Bar | CTA | eCommerce\";s:9:\"thumbnail\";s:68:\"https://library.elementor.com/wp-content/uploads/2021/05/350x250.png\";s:12:\"tmpl_created\";i:1621870603;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:129:\"https://library.elementor.com/popups/hello-bar-cta-ecommerce/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:9:\"hello bar\";s:4:\"tags\";s:41:\"[\"Ecommerce\",\"Online Shop\",\"Sale\",\"Shop\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:130;a:16:{s:4:\"tmpl\";i:1247;s:2:\"id\";i:21907;s:5:\"title\";s:50:\"Fly-In | Team Details  | Electronic Music Festival\";s:9:\"thumbnail\";s:104:\"https://library.elementor.com/wp-content/uploads/2022/03/Kit-8-electronic-music-festival-CTA-image-1.jpg\";s:12:\"tmpl_created\";i:1646660881;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:157:\"https://library.elementor.com/popups/fly-in-team-details-popup-electronic-music-festival/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:6:\"fly-in\";s:4:\"tags\";s:8:\"[\"Team\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:131;a:16:{s:4:\"tmpl\";i:1253;s:2:\"id\";i:22162;s:5:\"title\";s:46:\"Full Screen | Menu | Electronic Music Festival\";s:9:\"thumbnail\";s:90:\"https://library.elementor.com/wp-content/uploads/2022/03/8-music-festival-Team-Details.jpg\";s:12:\"tmpl_created\";i:1647272934;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:154:\"https://library.elementor.com/popups/full-screen-menu-popup-electronic-music-festival/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:11:\"full screen\";s:4:\"tags\";s:21:\"[\"Fullscreen\",\"menu\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:132;a:16:{s:4:\"tmpl\";i:1254;s:2:\"id\";i:22172;s:5:\"title\";s:45:\"Classic | Discount | Health &#038; Beauty Spa\";s:9:\"thumbnail\";s:84:\"https://library.elementor.com/wp-content/uploads/2022/03/health-beauty-spa-small.jpg\";s:12:\"tmpl_created\";i:1647273547;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:146:\"https://library.elementor.com/popups/classic-discount-popup-health-beauty-spa/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:36:\"[\"Hair\",\"Health\",\"Sales\",\"Services\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:133;a:16:{s:4:\"tmpl\";i:1255;s:2:\"id\";i:22183;s:5:\"title\";s:44:\"Hello Bar | CTA | Environmental Organization\";s:9:\"thumbnail\";s:104:\"https://library.elementor.com/wp-content/uploads/2022/03/11-Environmental-Organization-Click-Through.jpg\";s:12:\"tmpl_created\";i:1647274384;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:152:\"https://library.elementor.com/popups/hello-bar-cta-popup-environmental-organization/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:9:\"hello bar\";s:4:\"tags\";s:7:\"[\"cta\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:134;a:16:{s:4:\"tmpl\";i:1256;s:2:\"id\";i:22195;s:5:\"title\";s:39:\"Classic | Discount | Italian Restaurant\";s:9:\"thumbnail\";s:77:\"https://library.elementor.com/wp-content/uploads/2022/03/restaurant-small.jpg\";s:12:\"tmpl_created\";i:1647329432;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:147:\"https://library.elementor.com/popups/classic-discount-popup-italian-restaurant/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:22:\"[\"Restaurant\",\"Sales\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:135;a:16:{s:4:\"tmpl\";i:1257;s:2:\"id\";i:22210;s:5:\"title\";s:45:\"Bottom Bar | Discount | Technology Conference\";s:9:\"thumbnail\";s:82:\"https://library.elementor.com/wp-content/uploads/2022/03/tech-conference-small.jpg\";s:12:\"tmpl_created\";i:1647330423;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:153:\"https://library.elementor.com/popups/bottom-bar-discount-popup-technology-conference/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:10:\"bottom bar\";s:4:\"tags\";s:38:\"[\"Conference\",\"Sales\",\"Save the Date\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:136;a:16:{s:4:\"tmpl\";i:1258;s:2:\"id\";i:22221;s:5:\"title\";s:32:\"Hello Bar | Menu | Tattoo Studio\";s:9:\"thumbnail\";s:82:\"https://library.elementor.com/wp-content/uploads/2022/03/tattoo-studio-small-1.jpg\";s:12:\"tmpl_created\";i:1647330705;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:140:\"https://library.elementor.com/popups/hello-bar-menu-popup-tattoo-studio/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:9:\"hello bar\";s:4:\"tags\";s:17:\"[\"Header\",\"menu\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:137;a:16:{s:4:\"tmpl\";i:1259;s:2:\"id\";i:22231;s:5:\"title\";s:37:\"Full Screen | Booking | Tattoo Studio\";s:9:\"thumbnail\";s:80:\"https://library.elementor.com/wp-content/uploads/2022/03/tattoo-studio-small.jpg\";s:12:\"tmpl_created\";i:1647331823;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:145:\"https://library.elementor.com/popups/full-screen-booking-popup-tattoo-studio/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:11:\"full screen\";s:4:\"tags\";s:32:\"[\"Booking\",\"Contact\",\"Services\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:138;a:16:{s:4:\"tmpl\";i:1260;s:2:\"id\";i:22251;s:5:\"title\";s:34:\"Classic | Discount | Dental Clinic\";s:9:\"thumbnail\";s:80:\"https://library.elementor.com/wp-content/uploads/2022/03/dental-clinic-small.jpg\";s:12:\"tmpl_created\";i:1647332171;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:142:\"https://library.elementor.com/popups/classic-discount-popup-dental-clinic/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:30:\"[\"Health\",\"Marketing\",\"Sales\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:139;a:16:{s:4:\"tmpl\";i:1261;s:2:\"id\";i:22261;s:5:\"title\";s:34:\"Slide-In | Contact | Makeup Artist\";s:9:\"thumbnail\";s:88:\"https://library.elementor.com/wp-content/uploads/2022/03/20-Makeup-Artist-Contact-Us.jpg\";s:12:\"tmpl_created\";i:1647333946;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:142:\"https://library.elementor.com/popups/slide-in-contact-popup-makeup-artist/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:8:\"slide-in\";s:4:\"tags\";s:33:\"[\"Business\",\"Contact\",\"Services\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:140;a:16:{s:4:\"tmpl\";i:1262;s:2:\"id\";i:22271;s:5:\"title\";s:24:\"Fly-In | CTA | Headphone\";s:9:\"thumbnail\";s:79:\"https://library.elementor.com/wp-content/uploads/2022/03/headphones-1-small.jpg\";s:12:\"tmpl_created\";i:1647334784;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:132:\"https://library.elementor.com/popups/fly-in-cta-popup-headphone/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:6:\"fly-in\";s:4:\"tags\";s:41:\"[\"cta\",\"Ecommerce\",\"Marketing\",\"Product\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:141;a:16:{s:4:\"tmpl\";i:1263;s:2:\"id\";i:22277;s:5:\"title\";s:29:\"Classic | CTA | Online Course\";s:9:\"thumbnail\";s:76:\"https://library.elementor.com/wp-content/uploads/2022/03/online-course-2.jpg\";s:12:\"tmpl_created\";i:1647337110;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:137:\"https://library.elementor.com/popups/classic-cta-popup-online-course/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:35:\"[\"Course Online\",\"cta\",\"Marketing\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:142;a:16:{s:4:\"tmpl\";i:1264;s:2:\"id\";i:22283;s:5:\"title\";s:40:\"Bottom Bar | Contact | Virtual Assistant\";s:9:\"thumbnail\";s:80:\"https://library.elementor.com/wp-content/uploads/2022/03/virtual-assistant-3.jpg\";s:12:\"tmpl_created\";i:1647337517;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:148:\"https://library.elementor.com/popups/bottom-bar-contact-popup-virtual-assistant/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:10:\"bottom bar\";s:4:\"tags\";s:33:\"[\"Business\",\"Contact\",\"Services\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:143;a:16:{s:4:\"tmpl\";i:1265;s:2:\"id\";i:22289;s:5:\"title\";s:32:\"Fly-In | Contact | Private Tutor\";s:9:\"thumbnail\";s:76:\"https://library.elementor.com/wp-content/uploads/2022/03/private-tutor-4.jpg\";s:12:\"tmpl_created\";i:1647337676;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:140:\"https://library.elementor.com/popups/fly-in-contact-popup-private-tutor/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:6:\"fly-in\";s:4:\"tags\";s:27:\"[\"Contact\",\"Course Online\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:144;a:16:{s:4:\"tmpl\";i:1266;s:2:\"id\";i:22295;s:5:\"title\";s:31:\"Classic |  Login | Login Travel\";s:9:\"thumbnail\";s:75:\"https://library.elementor.com/wp-content/uploads/2022/03/login-travel-6.jpg\";s:12:\"tmpl_created\";i:1647339467;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:138:\"https://library.elementor.com/popups/classic-login-popup-login-travel/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:9:\"[\"Login\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:145;a:16:{s:4:\"tmpl\";i:1267;s:2:\"id\";i:22301;s:5:\"title\";s:36:\"Full Screen | Login | Login Business\";s:9:\"thumbnail\";s:77:\"https://library.elementor.com/wp-content/uploads/2022/03/login-business-7.jpg\";s:12:\"tmpl_created\";i:1647339782;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:144:\"https://library.elementor.com/popups/full-screen-login-popup-login-business/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:11:\"full screen\";s:4:\"tags\";s:16:\"[\"Login\",\"SaaS\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:146;a:16:{s:4:\"tmpl\";i:1268;s:2:\"id\";i:22307;s:5:\"title\";s:28:\"Classic | Login | Login Blog\";s:9:\"thumbnail\";s:73:\"https://library.elementor.com/wp-content/uploads/2022/03/login-blog-8.jpg\";s:12:\"tmpl_created\";i:1647339986;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:136:\"https://library.elementor.com/popups/classic-login-popup-login-blog/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:16:\"[\"Blog\",\"Login\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:147;a:16:{s:4:\"tmpl\";i:1269;s:2:\"id\";i:22313;s:5:\"title\";s:31:\"Classic | Login | Login Fashion\";s:9:\"thumbnail\";s:76:\"https://library.elementor.com/wp-content/uploads/2022/03/login-fashion-9.jpg\";s:12:\"tmpl_created\";i:1647340204;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:139:\"https://library.elementor.com/popups/classic-login-popup-login-fashion/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:19:\"[\"Fashion\",\"Login\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:148;a:16:{s:4:\"tmpl\";i:1270;s:2:\"id\";i:22319;s:5:\"title\";s:40:\"Classic |  Login | Login Design Platform\";s:9:\"thumbnail\";s:85:\"https://library.elementor.com/wp-content/uploads/2022/03/login-design-platform-10.jpg\";s:12:\"tmpl_created\";i:1647340531;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:147:\"https://library.elementor.com/popups/classic-login-popup-login-design-platform/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:25:\"[\"Design\",\"Login\",\"SaaS\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:149;a:16:{s:4:\"tmpl\";i:1271;s:2:\"id\";i:22325;s:5:\"title\";s:36:\"Fly-In | Contact | Digital Marketing\";s:9:\"thumbnail\";s:81:\"https://library.elementor.com/wp-content/uploads/2022/03/digital-marketing-11.jpg\";s:12:\"tmpl_created\";i:1647340770;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:144:\"https://library.elementor.com/popups/fly-in-contact-popup-digital-marketing/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:6:\"fly-in\";s:4:\"tags\";s:51:\"[\"Business\",\"Contact\",\"Digital Agency\",\"Marketing\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:150;a:16:{s:4:\"tmpl\";i:1272;s:2:\"id\";i:22331;s:5:\"title\";s:36:\"Fly-In | CTA | Dog Cat Food Delivery\";s:9:\"thumbnail\";s:84:\"https://library.elementor.com/wp-content/uploads/2022/03/dog-cat-food-delivery-5.jpg\";s:12:\"tmpl_created\";i:1647341069;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:144:\"https://library.elementor.com/popups/fly-in-cta-popup-dog-cat-food-delivery/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:6:\"fly-in\";s:4:\"tags\";s:33:\"[\"cta\",\"Delivery Service\",\"Pets\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:151;a:16:{s:4:\"tmpl\";i:1273;s:2:\"id\";i:22337;s:5:\"title\";s:37:\"Full Screen | Contact | Design Studio\";s:9:\"thumbnail\";s:77:\"https://library.elementor.com/wp-content/uploads/2022/03/design-studio-12.jpg\";s:12:\"tmpl_created\";i:1647341370;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:145:\"https://library.elementor.com/popups/full-screen-contact-popup-design-studio/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:11:\"full screen\";s:4:\"tags\";s:39:\"[\"Business\",\"Contact\",\"Digital Agency\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:152;a:16:{s:4:\"tmpl\";i:1274;s:2:\"id\";i:22343;s:5:\"title\";s:44:\"Classic | Contact | Support Product Platform\";s:9:\"thumbnail\";s:71:\"https://library.elementor.com/wp-content/uploads/2022/03/support-13.jpg\";s:12:\"tmpl_created\";i:1647341972;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:146:\"https://library.elementor.com/popups/classic-contact-support-product-platform/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:21:\"[\"Contact\",\"Support\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:153;a:16:{s:4:\"tmpl\";i:1275;s:2:\"id\";i:22371;s:5:\"title\";s:38:\"Full Screen | Contact | Small Business\";s:9:\"thumbnail\";s:78:\"https://library.elementor.com/wp-content/uploads/2022/03/small-business-14.jpg\";s:12:\"tmpl_created\";i:1647342508;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:140:\"https://library.elementor.com/popups/full-screen-contact-small-business/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:11:\"full screen\";s:4:\"tags\";s:40:\"[\"Business\",\"Contact\",\"Interior Design\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:154;a:16:{s:4:\"tmpl\";i:1276;s:2:\"id\";i:22377;s:5:\"title\";s:31:\"Classic | Contact | Online Shop\";s:9:\"thumbnail\";s:75:\"https://library.elementor.com/wp-content/uploads/2022/03/online-shop-15.jpg\";s:12:\"tmpl_created\";i:1647352786;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:133:\"https://library.elementor.com/popups/classic-contact-online-shop/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:11:\"[\"Contact\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:155;a:16:{s:4:\"tmpl\";i:1277;s:2:\"id\";i:22383;s:5:\"title\";s:40:\"Classic | Booking | Children Optometrist\";s:9:\"thumbnail\";s:84:\"https://library.elementor.com/wp-content/uploads/2022/03/children-optometrist-16.jpg\";s:12:\"tmpl_created\";i:1647352963;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:142:\"https://library.elementor.com/popups/classic-booking-children-optometrist/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:53:\"[\"Booking\",\"Business\",\"Contact\",\"Education\",\"Health\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:156;a:16:{s:4:\"tmpl\";i:1278;s:2:\"id\";i:22389;s:5:\"title\";s:28:\"Fly-In | Contact | Open Week\";s:9:\"thumbnail\";s:72:\"https://library.elementor.com/wp-content/uploads/2022/03/open-week17.jpg\";s:12:\"tmpl_created\";i:1647353281;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:130:\"https://library.elementor.com/popups/fly-in-contact-open-week/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:6:\"fly-in\";s:4:\"tags\";s:34:\"[\"Business\",\"Contact\",\"Marketing\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:157;a:16:{s:4:\"tmpl\";i:1279;s:2:\"id\";i:22397;s:5:\"title\";s:43:\"Full Screen | CTA | Plant Pots Online Store\";s:9:\"thumbnail\";s:87:\"https://library.elementor.com/wp-content/uploads/2022/03/plant-pots-online-store-18.jpg\";s:12:\"tmpl_created\";i:1647353429;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:145:\"https://library.elementor.com/popups/full-screen-cta-plant-pots-online-store/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:11:\"full screen\";s:4:\"tags\";s:33:\"[\"Ecommerce\",\"Marketing\",\"Sales\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:158;a:16:{s:4:\"tmpl\";i:1054;s:2:\"id\";i:15414;s:5:\"title\";s:32:\"Classic | Contact | Dance Studio\";s:9:\"thumbnail\";s:66:\"https://library.elementor.com/wp-content/uploads/2020/10/PopUp.jpg\";s:12:\"tmpl_created\";i:1603180596;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:134:\"https://library.elementor.com/popups/classic-contact-dance-studio/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:16:\"[\"Dance Studio\"]\";s:10:\"menu_order\";i:1;s:16:\"popularity_index\";i:762;s:11:\"trend_index\";i:650;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:159;a:16:{s:4:\"tmpl\";i:1398;s:2:\"id\";i:23687;s:5:\"title\";s:32:\"Pizza Promotion &#8211; Business\";s:9:\"thumbnail\";s:79:\"https://library.elementor.com/wp-content/uploads/2022/04/48-Pizza-Promotion.jpg\";s:12:\"tmpl_created\";i:1649670575;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:126:\"https://library.elementor.com/lp/pizza-promotion-business/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:7:\"subtype\";s:8:\"Business\";s:4:\"tags\";s:92:\"[\"Business\",\"Cooking\",\"Delivery\",\"Discount\",\"Fast Food\",\"Food\",\"Landing Pages\",\"Restaurant\"]\";s:10:\"menu_order\";i:1;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:160;a:16:{s:4:\"tmpl\";i:1400;s:2:\"id\";i:23751;s:5:\"title\";s:33:\"Baby Sleep Webinar &#8211; Events\";s:9:\"thumbnail\";s:82:\"https://library.elementor.com/wp-content/uploads/2022/04/63-Baby-Sleep-Webinar.jpg\";s:12:\"tmpl_created\";i:1649676065;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:127:\"https://library.elementor.com/lp/baby-sleep-webinar-events/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:7:\"subtype\";s:6:\"Events\";s:4:\"tags\";s:227:\"[\"Baby\",\"Booking\",\"Business\",\"Children\",\"Course Online\",\"Education\",\"Events\",\"Health\",\"Landing Pages\",\"Life Coach\",\"Lifestyle\",\"Online Event\",\"Online Service\",\"Parenting\",\"Professional\",\"Remote\",\"Services\",\"Training\",\"Webinar\"]\";s:10:\"menu_order\";i:1;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:161;a:16:{s:4:\"tmpl\";i:1401;s:2:\"id\";i:23776;s:5:\"title\";s:34:\"Ski Hotel Promotion &#8211; Travel\";s:9:\"thumbnail\";s:83:\"https://library.elementor.com/wp-content/uploads/2022/04/64-Ski-Hotel-Promotion.jpg\";s:12:\"tmpl_created\";i:1649691720;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:128:\"https://library.elementor.com/lp/ski-hotel-promotion-travel/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:7:\"subtype\";s:6:\"Travel\";s:4:\"tags\";s:118:\"[\"Accommodation\",\"Booking\",\"Discount. Landing Pages\",\"Lifestyle\",\"Luxury\",\"Services\",\"Spa\",\"Travel\",\"Trip\",\"Vacation\"]\";s:10:\"menu_order\";i:1;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:20;}i:162;a:16:{s:4:\"tmpl\";i:1402;s:2:\"id\";i:23804;s:5:\"title\";s:30:\"Cake Delivery &#8211; Business\";s:9:\"thumbnail\";s:77:\"https://library.elementor.com/wp-content/uploads/2022/04/67-Cake-Delivery.jpg\";s:12:\"tmpl_created\";i:1649692909;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:124:\"https://library.elementor.com/lp/cake-delivery-business/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:7:\"subtype\";s:8:\"Business\";s:4:\"tags\";s:101:\"[\"Bakery\",\"Business\",\"Cake\",\"Cooking\",\"Delivery\",\"Discount\",\"Food\",\"Landing Pages\",\"Products\",\"Shop\"]\";s:10:\"menu_order\";i:1;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:163;a:16:{s:4:\"tmpl\";i:1403;s:2:\"id\";i:23832;s:5:\"title\";s:32:\"Furniture Store &#8211; Business\";s:9:\"thumbnail\";s:79:\"https://library.elementor.com/wp-content/uploads/2022/04/87-Furniture-Store.jpg\";s:12:\"tmpl_created\";i:1649694812;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:126:\"https://library.elementor.com/lp/furniture-store-business/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:7:\"subtype\";s:8:\"Business\";s:4:\"tags\";s:232:\"[\"Architecture\",\"Art\",\"Business\",\"Construction\",\"Coupon\",\"Creative\",\"Decor\",\"Designer\",\"Discount\",\"Fashion\",\"Furniture Design\",\"Home\",\"House\",\"Interior Design\",\"Landing Pages\",\"Lifestyle\",\"Products\",\"Professional\",\"Services\",\"Shop\"]\";s:10:\"menu_order\";i:1;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:164;a:16:{s:4:\"tmpl\";i:1404;s:2:\"id\";i:23746;s:5:\"title\";s:22:\"Nails &#8211; Business\";s:9:\"thumbnail\";s:71:\"https://library.elementor.com/wp-content/uploads/2022/04/62-Nails-1.jpg\";s:12:\"tmpl_created\";i:1649704635;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:116:\"https://library.elementor.com/lp/nails-business/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:7:\"subtype\";s:8:\"Business\";s:4:\"tags\";s:173:\"[\"Art\",\"Beauty\",\"Business\",\"Colorful\",\"Cosmetics\",\"Creative\",\"Design\",\"Discount\",\"Fashion\",\"Girly\",\"Landing Pages\",\"Lifestyle\",\"Manicure\",\"Modern\",\"Professional\",\"Services\"]\";s:10:\"menu_order\";i:1;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:165;a:16:{s:4:\"tmpl\";i:1405;s:2:\"id\";i:23846;s:5:\"title\";s:29:\"Music Festival &#8211; Events\";s:9:\"thumbnail\";s:78:\"https://library.elementor.com/wp-content/uploads/2022/04/88-Music-Festival.jpg\";s:12:\"tmpl_created\";i:1649707763;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:123:\"https://library.elementor.com/lp/music-festival-events/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:7:\"subtype\";s:6:\"Events\";s:4:\"tags\";s:128:\"[\"Author\",\"Booking\",\"Business\",\"Creative\",\"Discount\",\"Events\",\"Landing Pages\",\"Music\",\"Online\",\"Online Event\",\"Party\",\"Virtual\"]\";s:10:\"menu_order\";i:1;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:166;a:16:{s:4:\"tmpl\";i:1406;s:2:\"id\";i:23872;s:5:\"title\";s:40:\"Fashion Styling Course &#8211; Education\";s:9:\"thumbnail\";s:86:\"https://library.elementor.com/wp-content/uploads/2022/04/89-Fashion-Styling-Course.jpg\";s:12:\"tmpl_created\";i:1649708569;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:134:\"https://library.elementor.com/lp/fashion-styling-course-education/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:7:\"subtype\";s:9:\"Education\";s:4:\"tags\";s:173:\"[\"Aesthetic\",\"Art\",\"Beauty\",\"Business\",\"Course Online\",\"Creative\",\"Discount\",\"Education\",\"Fashion\",\"Landing Pages\",\"Lifestyle\",\"Online\",\"Online Service\",\"Stylist\",\"Virtual\"]\";s:10:\"menu_order\";i:1;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:167;a:16:{s:4:\"tmpl\";i:1407;s:2:\"id\";i:23897;s:5:\"title\";s:33:\"Bags Online Shop &#8211; Business\";s:9:\"thumbnail\";s:80:\"https://library.elementor.com/wp-content/uploads/2022/04/90-Bags-Online-Shop.jpg\";s:12:\"tmpl_created\";i:1649709513;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:127:\"https://library.elementor.com/lp/bags-online-shop-business/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:7:\"subtype\";s:8:\"Business\";s:4:\"tags\";s:170:\"[\"Art\",\"Bag\",\"Business\",\"Creative\",\"Design\",\"Discount\",\"Fashion\",\"Landing Pages\",\"Lifestyle\",\"Luxury\",\"Modern\",\"Online\",\"Online Shop\",\"Products\",\"Sales\",\"Shop\",\"Stylist\"]\";s:10:\"menu_order\";i:1;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:168;a:16:{s:4:\"tmpl\";i:1408;s:2:\"id\";i:23932;s:5:\"title\";s:32:\"Cooking Academy &#8211; Business\";s:9:\"thumbnail\";s:79:\"https://library.elementor.com/wp-content/uploads/2022/04/91-Cooking-Academy.jpg\";s:12:\"tmpl_created\";i:1649710216;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:126:\"https://library.elementor.com/lp/cooking-academy-business/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:7:\"subtype\";s:8:\"Business\";s:4:\"tags\";s:145:\"[\"Academy\",\"Booking\",\"Business\",\"Chef\",\"Cooking\",\"Education\",\"Food\",\"Free Trial\",\"Landing Pages\",\"Professional\",\"School\",\"Teacher\",\"Testimonial\"]\";s:10:\"menu_order\";i:1;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:169;a:16:{s:4:\"tmpl\";i:1409;s:2:\"id\";i:23970;s:5:\"title\";s:45:\"Ophthalmology Medical Clinic &#8211; Business\";s:9:\"thumbnail\";s:92:\"https://library.elementor.com/wp-content/uploads/2022/04/92-Ophthalmology-Medical-Clinic.jpg\";s:12:\"tmpl_created\";i:1649711096;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:139:\"https://library.elementor.com/lp/ophthalmology-medical-clinic-business/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:7:\"subtype\";s:8:\"Business\";s:4:\"tags\";s:165:\"[\"About\",\"Business\",\"Care\",\"Consulting\",\"Eye\",\"Free Trial\",\"Glasses\",\"Health\",\"Landing Pages\",\"Lifestyle\",\"Medical\",\"Modern\",\"Optometrist\",\"Professional\",\"Services\"]\";s:10:\"menu_order\";i:1;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:170;a:16:{s:4:\"tmpl\";i:1425;s:2:\"id\";i:24331;s:5:\"title\";s:24:\"Wireframe &#8211; Home 1\";s:9:\"thumbnail\";s:81:\"https://library.elementor.com/wp-content/uploads/2022/05/Wireframe-—-Home-1.jpg\";s:12:\"tmpl_created\";i:1653988363;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:115:\"https://library.elementor.com/wireframe-home-1/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:102:\"[\"Business\",\"Contact\",\"Features\",\"Footer\",\"Header\",\"Homepage\",\"Professional\",\"Services\",\"Testimonial\"]\";s:10:\"menu_order\";i:1;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:171;a:16:{s:4:\"tmpl\";i:674;s:2:\"id\";i:8505;s:5:\"title\";s:11:\"404 page 01\";s:9:\"thumbnail\";s:64:\"https://library.elementor.com/wp-content/uploads/2018/05/001.jpg\";s:12:\"tmpl_created\";i:1526415501;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:117:\"https://library.elementor.com/blocks/404-page-01/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:8:\"404 page\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:1;s:16:\"popularity_index\";i:533;s:11:\"trend_index\";i:222;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:172;a:16:{s:4:\"tmpl\";i:1218;s:2:\"id\";i:20792;s:5:\"title\";s:26:\"Luxury Car &#8211; Product\";s:9:\"thumbnail\";s:70:\"https://library.elementor.com/wp-content/uploads/2021/11/250x280-1.jpg\";s:12:\"tmpl_created\";i:1636903770;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:120:\"https://library.elementor.com/lp/luxury-car-product/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:7:\"subtype\";s:7:\"Product\";s:4:\"tags\";s:54:\"[\"car\",\"Ecommerce\",\"Landing Pages\",\"Luxury\",\"Product\"]\";s:10:\"menu_order\";i:1;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:173;a:16:{s:4:\"tmpl\";i:1428;s:2:\"id\";i:24398;s:5:\"title\";s:25:\"Wireframe &#8211; About 1\";s:9:\"thumbnail\";s:82:\"https://library.elementor.com/wp-content/uploads/2022/05/Wireframe-—-About-1.jpg\";s:12:\"tmpl_created\";i:1653988534;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:116:\"https://library.elementor.com/wireframe-about-1/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:83:\"[\"About\",\"Business\",\"Contact\",\"Features\",\"Footer\",\"Professional\",\"Services\",\"Team\"]\";s:10:\"menu_order\";i:2;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:174;a:16:{s:4:\"tmpl\";i:675;s:2:\"id\";i:8511;s:5:\"title\";s:11:\"404 page 02\";s:9:\"thumbnail\";s:64:\"https://library.elementor.com/wp-content/uploads/2018/05/002.jpg\";s:12:\"tmpl_created\";i:1526415528;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:117:\"https://library.elementor.com/blocks/404-page-02/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:8:\"404 page\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:2;s:16:\"popularity_index\";i:347;s:11:\"trend_index\";i:155;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:175;a:16:{s:4:\"tmpl\";i:1204;s:2:\"id\";i:20208;s:5:\"title\";s:49:\"Alternative Medicine Acupuncture &#8211; Business\";s:9:\"thumbnail\";s:112:\"https://library.elementor.com/wp-content/uploads/2021/10/Alternative-Medicine-Acupuncture-Business-250x280-1.jpg\";s:12:\"tmpl_created\";i:1633880557;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:143:\"https://library.elementor.com/lp/alternative-medicine-acupuncture-business/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:7:\"subtype\";s:8:\"Business\";s:4:\"tags\";s:47:\"[\"Health\",\"Landing Pages\",\"Medical\",\"Services\"]\";s:10:\"menu_order\";i:2;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:20;}i:176;a:16:{s:4:\"tmpl\";i:991;s:2:\"id\";i:13413;s:5:\"title\";s:33:\"Classic | Contact | Online Course\";s:9:\"thumbnail\";s:71:\"https://library.elementor.com/wp-content/uploads/2020/04/PopUp-Help.jpg\";s:12:\"tmpl_created\";i:1587474761;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:135:\"https://library.elementor.com/popups/classic-contact-online-course/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:29:\"[\"Course Online\",\"Education\"]\";s:10:\"menu_order\";i:2;s:16:\"popularity_index\";i:530;s:11:\"trend_index\";i:369;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:177;a:16:{s:4:\"tmpl\";i:1053;s:2:\"id\";i:15272;s:5:\"title\";s:32:\"Classic | Contact | Psychologist\";s:9:\"thumbnail\";s:66:\"https://library.elementor.com/wp-content/uploads/2020/09/PopUp.png\";s:12:\"tmpl_created\";i:1600170487;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:134:\"https://library.elementor.com/popups/classic-contact-psychologist/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:34:\"[\"Psychologist\",\"Psychotherapist\"]\";s:10:\"menu_order\";i:3;s:16:\"popularity_index\";i:578;s:11:\"trend_index\";i:312;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:178;a:16:{s:4:\"tmpl\";i:1433;s:2:\"id\";i:24477;s:5:\"title\";s:27:\"Wireframe &#8211; Gallery 2\";s:9:\"thumbnail\";s:84:\"https://library.elementor.com/wp-content/uploads/2022/05/Wireframe-—-Gallery-2.jpg\";s:12:\"tmpl_created\";i:1653988835;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:118:\"https://library.elementor.com/wireframe-gallery-2/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:82:\"[\"Business\",\"Contact\",\"Design\",\"Footer\",\"Gallery\",\"Header\",\"Portfolio\",\"Services\"]\";s:10:\"menu_order\";i:3;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:179;a:16:{s:4:\"tmpl\";i:672;s:2:\"id\";i:8512;s:5:\"title\";s:11:\"404 page 03\";s:9:\"thumbnail\";s:64:\"https://library.elementor.com/wp-content/uploads/2018/05/003.jpg\";s:12:\"tmpl_created\";i:1526415449;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:117:\"https://library.elementor.com/blocks/404-page-03/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:8:\"404 page\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:3;s:16:\"popularity_index\";i:450;s:11:\"trend_index\";i:375;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:180;a:16:{s:4:\"tmpl\";i:1205;s:2:\"id\";i:20233;s:5:\"title\";s:32:\"Art Magazine &#8211; Coming Soon\";s:9:\"thumbnail\";s:95:\"https://library.elementor.com/wp-content/uploads/2021/10/Art-Magazine-Coming-Soon-250x280-1.jpg\";s:12:\"tmpl_created\";i:1633881371;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:126:\"https://library.elementor.com/lp/art-magazine-coming-soon/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:7:\"subtype\";s:16:\"Coming Soon Page\";s:4:\"tags\";s:48:\"[\"Art\",\"Coming Soon\",\"Landing Pages\",\"Magazine\"]\";s:10:\"menu_order\";i:3;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:20;}i:181;a:16:{s:4:\"tmpl\";i:671;s:2:\"id\";i:8513;s:5:\"title\";s:11:\"404 page 04\";s:9:\"thumbnail\";s:64:\"https://library.elementor.com/wp-content/uploads/2018/05/004.jpg\";s:12:\"tmpl_created\";i:1526415417;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:117:\"https://library.elementor.com/blocks/404-page-04/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:8:\"404 page\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:4;s:16:\"popularity_index\";i:420;s:11:\"trend_index\";i:176;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:182;a:16:{s:4:\"tmpl\";i:1214;s:2:\"id\";i:20539;s:5:\"title\";s:31:\"Design Blog &#8211; Coming Soon\";s:9:\"thumbnail\";s:94:\"https://library.elementor.com/wp-content/uploads/2021/10/Design-Blog-Coming-Soon-250x280-1.jpg\";s:12:\"tmpl_created\";i:1634022706;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:125:\"https://library.elementor.com/lp/design-blog-coming-soon/?utm_source=template-library